// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.20.1
// source: peer/peer.proto

package peer

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// PeerClient is the client API for Peer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PeerClient interface {
	// Notify sends information about hubble peers in the cluster.
	// When Notify is called, it sends information about all the peers that are
	// already part of the cluster (with the type as PEER_ADDED). It
	// subsequently notifies of any change.
	Notify(ctx context.Context, in *NotifyRequest, opts ...grpc.CallOption) (Peer_NotifyClient, error)
}

type peerClient struct {
	cc grpc.ClientConnInterface
}

func NewPeerClient(cc grpc.ClientConnInterface) PeerClient {
	return &peerClient{cc}
}

func (c *peerClient) Notify(ctx context.Context, in *NotifyRequest, opts ...grpc.CallOption) (Peer_NotifyClient, error) {
	stream, err := c.cc.NewStream(ctx, &Peer_ServiceDesc.Streams[0], "/peer.Peer/Notify", opts...)
	if err != nil {
		return nil, err
	}
	x := &peerNotifyClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Peer_NotifyClient interface {
	Recv() (*ChangeNotification, error)
	grpc.ClientStream
}

type peerNotifyClient struct {
	grpc.ClientStream
}

func (x *peerNotifyClient) Recv() (*ChangeNotification, error) {
	m := new(ChangeNotification)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PeerServer is the server API for Peer service.
// All implementations should embed UnimplementedPeerServer
// for forward compatibility
type PeerServer interface {
	// Notify sends information about hubble peers in the cluster.
	// When Notify is called, it sends information about all the peers that are
	// already part of the cluster (with the type as PEER_ADDED). It
	// subsequently notifies of any change.
	Notify(*NotifyRequest, Peer_NotifyServer) error
}

// UnimplementedPeerServer should be embedded to have forward compatible implementations.
type UnimplementedPeerServer struct {
}

func (UnimplementedPeerServer) Notify(*NotifyRequest, Peer_NotifyServer) error {
	return status.Errorf(codes.Unimplemented, "method Notify not implemented")
}

// UnsafePeerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PeerServer will
// result in compilation errors.
type UnsafePeerServer interface {
	mustEmbedUnimplementedPeerServer()
}

func RegisterPeerServer(s grpc.ServiceRegistrar, srv PeerServer) {
	s.RegisterService(&Peer_ServiceDesc, srv)
}

func _Peer_Notify_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(NotifyRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PeerServer).Notify(m, &peerNotifyServer{stream})
}

type Peer_NotifyServer interface {
	Send(*ChangeNotification) error
	grpc.ServerStream
}

type peerNotifyServer struct {
	grpc.ServerStream
}

func (x *peerNotifyServer) Send(m *ChangeNotification) error {
	return x.ServerStream.SendMsg(m)
}

// Peer_ServiceDesc is the grpc.ServiceDesc for Peer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Peer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "peer.Peer",
	HandlerType: (*PeerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Notify",
			Handler:       _Peer_Notify_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "peer/peer.proto",
}
