/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.python;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.lexer.PythonLexerKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/python/PythonMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "intellij.ml.inline.completion.python"})
@SourceDebugExtension(value={"SMAP\nPythonMLCompletionLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/python/PythonMLCompletionLexer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,67:1\n158#2,6:68\n*S KotlinDebug\n*F\n+ 1 PythonMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/python/PythonMLCompletionLexer\n*L\n28#1:68,6\n*E\n"})
public final class PythonMLCompletionLexer
extends MLCompletionLexerAdapter {
    public PythonMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        super(enclosuresDefinition);
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)new PythonLexer(PythonLexerKind.CONSOLE);
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (PyTokenTypes.ALL_BRACES.contains(token)) {
            collector.bracket(StringsKt.first((CharSequence)text), offset);
            return;
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.SINGLE_QUOTED_STRING)) {
            int quoteIndex;
            block20: {
                int n;
                CharSequence $this$indexOfFirst$iv = text;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!this.getEnclosures().isStringMarker(it)) continue;
                    n = index$iv;
                    break block20;
                }
                n = quoteIndex = -1;
            }
            if (quoteIndex != -1) {
                char quote = text.charAt(quoteIndex);
                String string = text.substring(0, quoteIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector.stringMarker(quote, offset + quoteIndex, string);
                if (quoteIndex + 1 != text.length() && quote == StringsKt.last((CharSequence)text)) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_START)) {
            if (this.getEnclosures().isStringMarker(StringsKt.last((CharSequence)text))) {
                char c = StringsKt.last((CharSequence)text);
                int n = offset + text.length() - 1;
                String string = text.substring(0, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector.stringMarker(c, n, string);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_END)) {
            if (this.getEnclosures().isStringMarker(StringsKt.first((CharSequence)text))) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_START)) {
            if (this.getEnclosures().isOpenBracket(StringsKt.first((CharSequence)text))) {
                MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_END)) {
            if (this.getEnclosures().isCloseBracket(StringsKt.first((CharSequence)text))) {
                MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.RARROW) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.DOT) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.COMMA) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.SEMICOLON)) {
            collector.special(text, offset);
        }
    }
}

