/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RepositoryWithBranchPanel<T extends PushTarget>
extends NonOpaquePanel {
    private final JBCheckBox myRepositoryCheckbox;
    private final PushTargetPanel<T> myDestPushTargetPanelComponent;
    @Nls
    private final String myRepositoryName;
    @Nls
    private final String mySourceName;
    private final ColoredTreeCellRenderer myTextRenderer;
    @NotNull
    private final List<RepositoryNodeListener<T>> myListeners;

    public RepositoryWithBranchPanel(final @NotNull Project project, @NotNull @Nls String repoName, @NotNull @Nls String sourceName, @NotNull PushTargetPanel<T> destPushTargetPanelComponent) {
        if (project == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(0);
        }
        if (repoName == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(1);
        }
        if (sourceName == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(2);
        }
        if (destPushTargetPanelComponent == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(3);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.setLayout(new BorderLayout());
        this.myRepositoryCheckbox = new JBCheckBox();
        this.myRepositoryCheckbox.setFocusable(false);
        this.myRepositoryCheckbox.setOpaque(false);
        this.myRepositoryCheckbox.setBorder(null);
        this.myRepositoryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RepositoryWithBranchPanel.this.fireOnSelectionChange(RepositoryWithBranchPanel.this.myRepositoryCheckbox.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$1", "actionPerformed"));
            }
        });
        this.myRepositoryName = repoName;
        this.mySourceName = sourceName;
        this.myDestPushTargetPanelComponent = destPushTargetPanelComponent;
        this.myTextRenderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$2", "customizeCellRenderer"));
            }
        };
        this.myTextRenderer.setOpaque(false);
        this.layoutComponents();
        this.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                ValidationInfo error = RepositoryWithBranchPanel.this.myDestPushTargetPanelComponent.verify();
                if (error != null) {
                    PopupUtil.showBalloonForComponent((Component)error.component, (String)error.message, (MessageType)MessageType.WARNING, (boolean)false, (Disposable)project);
                }
                return error == null;
            }
        });
        JCheckBox emptyBorderCheckBox = new JCheckBox();
        emptyBorderCheckBox.setBorder(null);
    }

    private void layoutComponents() {
        this.add((Component)this.myRepositoryCheckbox, "West");
        NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel.add((Component)this.myTextRenderer, "West");
        panel.add(this.myDestPushTargetPanelComponent, "Center");
        this.add((Component)panel, "Center");
    }

    @Nls
    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryName;
        if (string == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    public String getSourceName() {
        return this.mySourceName;
    }

    @Nls
    public String getArrow() {
        return " " + UIUtil.rightArrow() + " ";
    }

    @NotNull
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Rectangle bounds = tree.getPathBounds(tree.getPathForRow(row));
        this.invalidate();
        this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof SingleRepositoryNode) {
            this.myTextRenderer.setIpad((Insets)JBUI.insetsLeft((int)10));
            this.myRepositoryCheckbox.setVisible(false);
        } else {
            RepositoryNode node = (RepositoryNode)value;
            this.myRepositoryCheckbox.setSelected(node.isChecked());
            this.myRepositoryCheckbox.setVisible(true);
            this.myTextRenderer.setIpad((Insets)JBUI.emptyInsets());
            this.myTextRenderer.append(this.getRepositoryName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myTextRenderer.appendTextPadding(120);
        }
        if (this.myDestPushTargetPanelComponent.showSourceWhenEditing()) {
            if (value instanceof SingleRepositoryNode) {
                this.myTextRenderer.append(" ");
            }
            this.myTextRenderer.append(this.getSourceName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myTextRenderer.append(this.getArrow(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (bounds != null) {
            this.setPreferredSize(new Dimension(tree.getVisibleRect().width - bounds.x, bounds.height));
        }
        if (this.myTextRenderer.getTree().hasFocus()) {
            this.myDestPushTargetPanelComponent.requestFocus(true);
        }
        this.revalidate();
        RepositoryWithBranchPanel repositoryWithBranchPanel = this;
        if (repositoryWithBranchPanel == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(5);
        }
        return repositoryWithBranchPanel;
    }

    public void addRepoNodeListener(@NotNull RepositoryNodeListener<T> listener) {
        if (listener == null) {
            RepositoryWithBranchPanel.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener);
        this.myDestPushTargetPanelComponent.addTargetEditorListener(new PushTargetEditorListener(){

            @Override
            public void onTargetInEditModeChanged(@NotNull @Nls String value) {
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (RepositoryNodeListener listener : RepositoryWithBranchPanel.this.myListeners) {
                    listener.onTargetInEditMode(value);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$4", "onTargetInEditModeChanged"));
            }
        });
    }

    public void fireOnChange() {
        this.myDestPushTargetPanelComponent.fireOnChange();
        T target = this.myDestPushTargetPanelComponent.getValue();
        if (target == null) {
            return;
        }
        for (RepositoryNodeListener<T> listener : this.myListeners) {
            listener.onTargetChanged(target);
        }
    }

    public void fireOnSelectionChange(boolean isSelected) {
        for (RepositoryNodeListener<T> listener : this.myListeners) {
            listener.onSelectionChanged(isSelected);
        }
    }

    public void fireOnCancel() {
        this.myDestPushTargetPanelComponent.fireOnCancel();
    }

    public PushTargetPanel getTargetPanel() {
        return this.myDestPushTargetPanelComponent;
    }

    public boolean isEditable() {
        return this.myDestPushTargetPanelComponent.getValue() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destPushTargetPanelComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeCellEditorComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRepoNodeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

