/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.OpenSourceUtil;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageLineStatusTracker;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/actions/GitStageShowVersionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "showStaged", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getTargetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetFile", "caret", "Lcom/intellij/openapi/editor/Caret;", "intellij.vcs.git"})
public abstract class GitStageShowVersionAction
extends DumbAwareAction {
    private final boolean showStaged;

    public GitStageShowVersionAction(boolean showStaged) {
        this.showStaged = showStaged;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file == null || file instanceof GitIndexVirtualFile == this.showStaged) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file);
        e.getPresentation().setVisible(status != null);
        GitFileStatus gitFileStatus = status;
        e.getPresentation().setEnabled(gitFileStatus != null ? GitFileStatusKt.has(gitFileStatus, this.showStaged ? ContentVersion.STAGED : ContentVersion.LOCAL) : false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile;
        VirtualFile virtualFile2 = GitStageTrackerKt.getRoot(project2, sourceFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile root = virtualFile2;
        VirtualFile virtualFile3 = this.showStaged ? (VirtualFile)GitIndexFileSystemRefresher.Companion.getInstance(project2).getFile(root, GitIndexVirtualFileKt.filePath(sourceFile)) : GitIndexVirtualFileKt.filePath(sourceFile).getVirtualFile();
        if (virtualFile3 == null) {
            return;
        }
        VirtualFile targetFile = virtualFile3;
        Caret caret = (Caret)e.getData(CommonDataKeys.CARET);
        if (caret == null) {
            Navigatable[] navigatableArray = new Navigatable[]{new OpenFileDescriptor(project2, targetFile)};
            OpenSourceUtil.navigate((Navigatable[])navigatableArray);
            return;
        }
        LogicalPosition targetPosition = this.getTargetPosition(project2, sourceFile, targetFile, caret);
        Navigatable[] navigatableArray = new Navigatable[]{new OpenFileDescriptor(project2, targetFile, targetPosition.line, targetPosition.column)};
        OpenSourceUtil.navigate((Navigatable[])navigatableArray);
    }

    private final LogicalPosition getTargetPosition(Project project, VirtualFile sourceFile, VirtualFile targetFile, Caret caret) {
        LineStatusTracker lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(this.showStaged ? sourceFile : targetFile);
        if (lineStatusTracker == null) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            return logicalPosition;
        }
        LineStatusTracker lst = lineStatusTracker;
        if (!(lst instanceof GitStageLineStatusTracker)) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            return logicalPosition;
        }
        int line = this.showStaged ? ((GitStageLineStatusTracker)lst).transferLineFromLocalToStaged(caret.getLogicalPosition().line, true) : ((GitStageLineStatusTracker)lst).transferLineFromStagedToLocal(caret.getLogicalPosition().line, true);
        return new LogicalPosition(line, caret.getLogicalPosition().column);
    }
}

