/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.util.TextMatcher;

final class JTableMatchingCellQuery {
    @Nonnull
    @RunsInEDT
    static TableCell cellWithValue(@Nonnull JTable table, @Nonnull TextMatcher matcher2, @Nonnull JTableCellReader cellReader) {
        TableCell result = GuiActionRunner.execute(() -> JTableMatchingCellQuery.findMatchingCell(table, matcher2, cellReader));
        return (TableCell)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static TableCell findMatchingCell(@Nonnull JTable table, @Nonnull TextMatcher matcher2, @Nonnull JTableCellReader cellReader) {
        int rCount = table.getRowCount();
        int cCount = table.getColumnCount();
        for (int r = 0; r < rCount; ++r) {
            for (int c = 0; c < cCount; ++c) {
                if (!JTableMatchingCellQuery.cellHasValue(table, r, c, matcher2, cellReader)) continue;
                return TableCell.row(r).column(c);
            }
        }
        String msg = String.format("Unable to find cell matching %s %s", matcher2.description(), matcher2.formattedValues());
        throw ActionFailedException.actionFailure(msg);
    }

    @RunsInCurrentThread
    private static boolean cellHasValue(@Nonnull JTable table, int row, int column, @Nonnull TextMatcher matcher2, @Nonnull JTableCellReader cellReader) {
        return matcher2.isMatching(cellReader.valueAt(table, row, column));
    }

    private JTableMatchingCellQuery() {
    }
}

