/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language.identifier;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.languagetool.noop.NoopLanguage;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLanguageIdentifier
extends LanguageIdentifier {
    private static final Logger log = LoggerFactory.getLogger(SimpleLanguageIdentifier.class);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private final Map<String, SpellingCheckRule> spellingCheckRules = new HashMap<String, SpellingCheckRule>();

    public SimpleLanguageIdentifier() {
        super(1000);
        List<Language> languages2 = Languages.get();
        for (Language language : languages2) {
            ResourceBundle bundle;
            SpellingCheckRule defaultSpellingCheckRule;
            if (language.isVariant() || language.getShortCode().equals("zz")) continue;
            boolean hasVariant = language.hasVariant();
            Language spellingRuleLanguage = null;
            if (hasVariant) {
                spellingRuleLanguage = language.getDefaultLanguageVariant();
            }
            if (spellingRuleLanguage == null) {
                spellingRuleLanguage = language;
            }
            if ((defaultSpellingCheckRule = spellingRuleLanguage.getDefaultSpellingRule(bundle = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale(spellingRuleLanguage.getShortCodeWithCountryAndVariant())))) != null) {
                this.spellingCheckRules.put(language.getShortCode(), defaultSpellingCheckRule);
                continue;
            }
            log.warn("Could not find default speller rule for {}", (Object)language.getShortCode());
        }
    }

    public SimpleLanguageIdentifier(List<String> preferredLangCodes) {
        super(1000);
        log.info("Init SimpleLanguageIdentifier with {}", preferredLangCodes);
        preferredLangCodes.forEach(langCode -> {
            Language language = Languages.getLanguageForShortCode(langCode);
            SpellingCheckRule defaultSpellingRule = language.getDefaultSpellingRule(JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale((String)langCode)));
            if (defaultSpellingRule != null) {
                this.spellingCheckRules.put(language.getShortCode(), defaultSpellingRule);
            }
        });
    }

    @Override
    @Nullable
    public DetectedLanguage detectLanguage(String cleanText2, List<String> noopLangsTmp, List<String> preferredLangsTmp) {
        LanguageIdentifier.ParsedLanguageLists parsedLanguageLists = this.prepareDetectLanguage(cleanText2, noopLangsTmp, preferredLangsTmp);
        if (parsedLanguageLists == null) {
            return new DetectedLanguage(null, new NoopLanguage());
        }
        List<String> additionalLangs = parsedLanguageLists.getAdditionalLangs();
        List<String> preferredLangs = parsedLanguageLists.getPreferredLangs();
        String[] words2 = WHITESPACE.split(cleanText2);
        List<String> dominantLangCodes = UNICODE_BASED_LANG_IDENTIFIER.getDominantLangCodes(cleanText2);
        HashMap<String, Double> scores = new HashMap<String, Double>();
        String detectionSource = "spellchecker";
        for (Map.Entry<String, SpellingCheckRule> scp : this.spellingCheckRules.entrySet()) {
            if (!(dominantLangCodes.contains(scp.getKey()) ^ (dominantLangCodes.isEmpty() && !NON_LATIN_CHARS_LANGUAGES.contains(scp.getKey())))) continue;
            double errors = 0.0;
            for (String word : words2) {
                try {
                    errors += scp.getValue().isMisspelled(word) ? 1.0 : 0.0;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            double errorRate = errors / (double)words2.length;
            log.info("Found {} errors for {} words with {} spellchecker, this scores in an error rate of {}", new Object[]{errors, words2.length, scp.getKey(), errorRate});
            scores.put(scp.getKey(), 1.0 - errorRate);
        }
        if (scores.isEmpty()) {
            scores.put("zz", 1.0);
        }
        log.debug("Got scores: {}", scores);
        double maxValue = 0.0;
        int countFullScore = 0;
        for (Map.Entry entry2 : scores.entrySet()) {
            if ((Double)entry2.getValue() > maxValue) {
                countFullScore = 1;
                maxValue = (Double)entry2.getValue();
                continue;
            }
            if ((Double)entry2.getValue() != maxValue) continue;
            ++countFullScore;
        }
        Map.Entry<String, Double> highestScoringResult = this.getHighestScoringResult(scores);
        if (highestScoringResult.getValue() < (double)0.85f || highestScoringResult.getKey().equals("zz") || countFullScore > 1) {
            Map<Language, Integer> lang2Count = COMMON_WORDS_LANG_IDENTIFIER.getKnownWordsPerLanguage(cleanText2);
            HashSet<String> baseLangAlreadyHandled = new HashSet<String>();
            for (Map.Entry<Language, Integer> entry3 : lang2Count.entrySet()) {
                String langCode = entry3.getKey().getShortCode();
                if (baseLangAlreadyHandled.contains(langCode)) continue;
                baseLangAlreadyHandled.add(langCode);
                if (scores.containsKey(langCode)) {
                    scores.put(langCode, (Double)scores.get(langCode) + Double.valueOf(entry3.getValue().intValue()));
                    continue;
                }
                scores.put(langCode, (double)entry3.getValue());
            }
            detectionSource = detectionSource + "+commonwords";
            highestScoringResult = this.getHighestScoringResult(scores);
        }
        if (preferredLangs.contains("no") && !preferredLangs.contains("da")) {
            scores.keySet().removeIf(k -> k.equals("da"));
            highestScoringResult = this.getHighestScoringResult(scores);
        }
        if (cleanText2.length() < 50 && preferredLangs.size() > 0) {
            scores.keySet().removeIf(k -> !preferredLangs.contains(k));
            highestScoringResult = this.getHighestScoringResult(scores);
            detectionSource = detectionSource + "+prefLang";
        }
        if (highestScoringResult.getKey() != null && LanguageIdentifierService.INSTANCE.canLanguageBeDetected(highestScoringResult.getKey(), additionalLangs)) {
            return new DetectedLanguage(null, Languages.getLanguageForShortCode(highestScoringResult.getKey(), additionalLangs), highestScoringResult.getValue().floatValue(), detectionSource);
        }
        return null;
    }

    @Override
    @Nullable
    public DetectedLanguage detectLanguage(String cleanText2, List<String> noopLangsTmp, List<String> preferredLangsTmp, boolean limitOnPreferredLangs) {
        return this.detectLanguage(cleanText2, noopLangsTmp, preferredLangsTmp);
    }

    @Override
    @NotNull
    public List<DetectedLanguage> getDetectedLanguageScores(String cleanText2, List<String> noopLangsTmp, List<String> preferredLangsTmp, boolean limitOnPreferredLangs, int count) {
        return Collections.singletonList(this.detectLanguage(cleanText2, noopLangsTmp, preferredLangsTmp, limitOnPreferredLangs));
    }

    @Override
    @Nullable
    public Language detectLanguage(String cleanText2) {
        return null;
    }
}

