/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PySyntaxCoreBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstCaseClause;
import com.jetbrains.python.ast.PyAstComprehensionElement;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstForStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstMatchStatement;
import com.jetbrains.python.ast.PyAstNumericLiteralExpression;
import com.jetbrains.python.ast.PyAstPrefixExpression;
import com.jetbrains.python.ast.PyAstTypeAliasStatement;
import com.jetbrains.python.ast.PyAstWithStatement;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.validation.PyFrontendAnnotator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyHighlightingAnnotator
extends PyFrontendAnnotator
implements HighlightRangeExtension {
    @Override
    public void visitPyFunction(@NotNull PyAstFunction node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (node.isAsyncAllowed()) {
            this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
        } else {
            Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)).ifPresent(asyncNode -> this.getHolder().newAnnotation(HighlightSeverity.ERROR, PySyntaxCoreBundle.message("ANN.function.cannot.be.async", node.getName())).range(asyncNode).create());
        }
    }

    @Override
    public void visitPyNumericLiteralExpression(@NotNull PyAstNumericLiteralExpression node) {
        String suffix;
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if ((suffix = node.getIntegerLiteralSuffix()) == null || "l".equalsIgnoreCase(suffix)) {
            return;
        }
        if (node.getContainingFile().getLanguage() != PythonLanguage.getInstance()) {
            return;
        }
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, PySyntaxCoreBundle.message("INSP.python.trailing.suffix.not.support", suffix)).range((PsiElement)node).create();
    }

    @Override
    public void visitPyForStatement(@NotNull PyAstForStatement node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public void visitPyWithStatement(@NotNull PyAstWithStatement node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyAstPrefixExpression node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        this.highlightKeyword((PsiElement)node, PyTokenTypes.AWAIT_KEYWORD);
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyAstComprehensionElement node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(5);
        }
        this.highlightKeywords(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public void visitPyMatchStatement(@NotNull PyAstMatchStatement node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(6);
        }
        this.highlightKeyword((PsiElement)node, PyTokenTypes.MATCH_KEYWORD);
    }

    @Override
    public void visitPyCaseClause(@NotNull PyAstCaseClause node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(7);
        }
        this.highlightKeyword((PsiElement)node, PyTokenTypes.CASE_KEYWORD);
    }

    @Override
    public void visitPyTypeAliasStatement(@NotNull PyAstTypeAliasStatement node) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(8);
        }
        this.highlightKeyword(node, PyTokenTypes.TYPE_KEYWORD);
    }

    public boolean isForceHighlightParents(@NotNull PsiFile file) {
        if (file == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(9);
        }
        return file instanceof PyAstFile;
    }

    private void highlightKeyword(@NotNull PsiElement node, @NotNull PyElementType elementType) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(10);
        }
        if (elementType == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(11);
        }
        this.highlightAsKeyword(node.getNode().findChildByType((IElementType)elementType));
    }

    private void highlightKeywords(@NotNull PsiElement node, @NotNull PyElementType elementType) {
        if (node == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(12);
        }
        if (elementType == null) {
            PyHighlightingAnnotator.$$$reportNull$$$0(13);
        }
        for (ASTNode astNode : node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{elementType}))) {
            this.highlightAsKeyword(astNode);
        }
    }

    private void highlightAsKeyword(@Nullable ASTNode astNode) {
        if (astNode != null) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range(astNode).textAttributes(PyHighlighter.PY_KEYWORD).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyNumericLiteralExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyForStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyWithStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyComprehensionElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyMatchStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyCaseClause";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyTypeAliasStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isForceHighlightParents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

