/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.CloudConfigVersionContext;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSynchronizerKt;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.auth.JbaJwtTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.InvalidVersionIdException;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 C2\u00020\u0001:\u0001CB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0005J \u0010\u001b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u001aH\u0002J7\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\"\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010.\u001a\u00020/H\u0002J\u001a\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00162\b\u00102\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00103\u001a\u0004\u0018\u00010\u001c2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u000206J\u0018\u00107\u001a\u00020/2\u0006\u00104\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0016J\u0012\u00109\u001a\u0004\u0018\u0001062\u0006\u00104\u001a\u00020\u0003H\u0002J\u0010\u0010:\u001a\u00020/2\u0006\u00104\u001a\u00020\u0003H\u0016J\u0010\u0010;\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u0003H\u0016J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u0002060=2\u0006\u00104\u001a\u00020\u0003J\u001d\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0007H\u0011\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020BH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "serverUrl", "", "<init>", "(Ljava/lang/String;)V", "clientVersionContext", "Lcom/intellij/settingsSync/CloudConfigVersionContext;", "getClientVersionContext", "()Lcom/intellij/settingsSync/CloudConfigVersionContext;", "_currentIdTokenVar", "get_currentIdTokenVar$intellij_settingsSync", "()Ljava/lang/String;", "set_currentIdTokenVar$intellij_settingsSync", "_client", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "client", "getClient$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "lastRemoteErrorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getCurrentIdToken", "currentSnapshotFilePath", "Lkotlin/Pair;", "", "receiveSnapshotFile", "Ljava/io/InputStream;", "snapshotFilePath", "sendSnapshotFile", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "inputStream", "knownServerVersion", "force", "versionContext", "cloudConfigClient", "sendSnapshotFile$intellij_settingsSync", "checkServerState", "Lcom/intellij/settingsSync/ServerState;", "receiveUpdates", "Lcom/intellij/settingsSync/UpdateResult;", "push", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "expectedServerVersionId", "clearLastRemoteError", "", "handleRemoteError", "e", "idTokenInRequest", "downloadSnapshot", "filePath", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "createFile", "content", "getLatestVersion", "deleteFile", "isFileExists", "fetchHistory", "", "createCloudConfigClient", "url", "createCloudConfigClient$intellij_settingsSync", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigServerCommunicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,389:1\n14#2:390\n*S KotlinDebug\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n*L\n371#1:390\n*E\n"})
public class CloudConfigServerCommunicator
implements SettingsSyncRemoteCommunicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudConfigVersionContext clientVersionContext;
    @VisibleForTesting
    @Nullable
    private volatile String _currentIdTokenVar;
    @NotNull
    private SynchronizedClearableLazy<CloudConfigFileClientV2> _client;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    @NotNull
    private static final String URL_PROVIDER = "https://www.jetbrains.com/config/IdeaCloudConfig.xml";
    @NotNull
    private static final String DEFAULT_PRODUCTION_URL = "https://cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String DEFAULT_DEBUG_URL = "https://stgn.cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String URL_PROPERTY = "idea.settings.sync.cloud.url";
    @NotNull
    private static final Lazy<String> _url = LazyKt.lazy(CloudConfigServerCommunicator::_url$lambda$4);
    @NotNull
    private static final Logger LOG;
    @VisibleForTesting
    @NotNull
    private static final ETagStorage DUMMY_ETAG_STORAGE;

    public CloudConfigServerCommunicator(@Nullable String serverUrl) {
        this.clientVersionContext = new CloudConfigVersionContext();
        this._client = new SynchronizedClearableLazy(() -> CloudConfigServerCommunicator._client$lambda$0(this, serverUrl));
        this.lastRemoteErrorRef = new AtomicReference();
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void loginStateChanged() {
                _client.drop();
            }
        });
    }

    public /* synthetic */ CloudConfigServerCommunicator(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @NotNull
    protected final CloudConfigVersionContext getClientVersionContext() {
        return this.clientVersionContext;
    }

    @Nullable
    public final String get_currentIdTokenVar$intellij_settingsSync() {
        return this._currentIdTokenVar;
    }

    public final void set_currentIdTokenVar$intellij_settingsSync(@Nullable String string) {
        this._currentIdTokenVar = string;
    }

    @NotNull
    public CloudConfigFileClientV2 getClient$intellij_settingsSync() {
        return (CloudConfigFileClientV2)this._client.getValue();
    }

    private final String getCurrentIdToken() {
        this._client.getValue();
        return this._currentIdTokenVar;
    }

    @VisibleForTesting
    @Nullable
    protected final Pair<String, Boolean> currentSnapshotFilePath() throws IOException, UnauthorizedException {
        try {
            boolean crossIdeSyncEnabled = this.isFileExists("cross-ide-sync-enabled");
            if (crossIdeSyncEnabled != SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()) {
                LOG.info("Cross-IDE sync status on server is: " + SettingsSynchronizerKt.enabledOrDisabled(crossIdeSyncEnabled) + ". Updating local settings with it.");
                SettingsSyncLocalSettings.Companion.getInstance().setCrossIdeSyncEnabled(crossIdeSyncEnabled);
            }
            if (crossIdeSyncEnabled) {
                return new Pair((Object)"settings.sync.snapshot.zip", (Object)true);
            }
            String string = ApplicationNamesInfo.getInstance().getProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return new Pair((Object)(string2 + "/settings.sync.snapshot.zip"), (Object)false);
        }
        catch (Throwable e) {
            if (e instanceof IOException || e instanceof UnauthorizedException) {
                throw e;
            }
            LOG.warn("Couldn't check if cross-ide-sync-enabled exists", e);
            return null;
        }
    }

    private final Pair<InputStream, String> receiveSnapshotFile(String snapshotFilePath) throws IOException {
        return (Pair)this.clientVersionContext.doWithVersion(snapshotFilePath, null, arg_0 -> CloudConfigServerCommunicator.receiveSnapshotFile$lambda$1(this, arg_0));
    }

    private final SettingsSyncPushResult sendSnapshotFile(InputStream inputStream, String knownServerVersion, boolean force) {
        return this.sendSnapshotFile$intellij_settingsSync(inputStream, knownServerVersion, force, this.clientVersionContext, this.getClient$intellij_settingsSync());
    }

    @VisibleForTesting
    @NotNull
    public final SettingsSyncPushResult sendSnapshotFile$intellij_settingsSync(@NotNull InputStream inputStream, @Nullable String knownServerVersion, boolean force, @NotNull CloudConfigVersionContext versionContext, @NotNull CloudConfigFileClientV2 cloudConfigClient) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Intrinsics.checkNotNullParameter((Object)cloudConfigClient, (String)"cloudConfigClient");
        Object snapshotFilePath = null;
        String defaultMessage = "Unknown during checking cross-ide-sync-enabled";
        try {
            Object object = this.currentSnapshotFilePath();
            if (object == null || (object = (String)object.getFirst()) == null) {
                return new SettingsSyncPushResult.Error(defaultMessage);
            }
            snapshotFilePath = object;
        }
        catch (IOException ioe) {
            String string = ioe.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
            return new SettingsSyncPushResult.Error(string);
        }
        String versionToPush = null;
        if (force) {
            FileVersionInfo fileVersionInfo = this.getLatestVersion((String)snapshotFilePath);
            versionToPush = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
        } else if (knownServerVersion != null) {
            versionToPush = knownServerVersion;
        } else {
            String serverVersion;
            FileVersionInfo fileVersionInfo = this.getLatestVersion((String)snapshotFilePath);
            String string = serverVersion = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (serverVersion == null) {
                versionToPush = null;
            } else {
                return SettingsSyncPushResult.Rejected.INSTANCE;
            }
        }
        String serverVersionId = (String)versionContext.doWithVersion((String)snapshotFilePath, versionToPush, arg_0 -> CloudConfigServerCommunicator.sendSnapshotFile$lambda$2(cloudConfigClient, inputStream, versionContext, arg_0));
        return new SettingsSyncPushResult.Success(serverVersionId);
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            String string;
            Object object = this.currentSnapshotFilePath();
            if (object == null || (object = (String)object.getFirst()) == null) {
                return new ServerState.Error("Unknown error during checkServerState");
            }
            Object snapshotFilePath = object;
            FileVersionInfo latestVersion = this.getClient$intellij_settingsSync().getLatestVersion((String)snapshotFilePath);
            LOG.debug("Latest version info: " + latestVersion);
            this.clearLastRemoteError();
            FileVersionInfo fileVersionInfo = latestVersion;
            String string2 = string = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (string == null) {
                return ServerState.FileNotExists.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)string, (Object)SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId())) {
                return ServerState.UpToDate.INSTANCE;
            }
            return ServerState.UpdateNeeded.INSTANCE;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            return new ServerState.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        LOG.info("Receiving settings snapshot from the cloud config server...");
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            Pair<String, Boolean> pair = this.currentSnapshotFilePath();
            if (pair == null) {
                return new UpdateResult.Error("Unknown error during receiveUpdates");
            }
            Pair<String, Boolean> pair2 = pair;
            String snapshotFilePath = (String)pair2.component1();
            boolean isCrossIdeSync = (Boolean)pair2.component2();
            Pair<InputStream, String> pair3 = this.receiveSnapshotFile(snapshotFilePath);
            InputStream stream = (InputStream)pair3.component1();
            String version = (String)pair3.component2();
            this.clearLastRemoteError();
            if (stream == null) {
                LOG.info(snapshotFilePath + " not found on the server");
                return UpdateResult.NoFileOnServer.INSTANCE;
            }
            File file = FileUtil.createTempFile((String)"settings.sync.snapshot", (String)(UUID.randomUUID() + ".zip"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tempFile = file;
            try {
                FileUtil.writeToFile((File)tempFile, (byte[])stream.readAllBytes());
                Path path = tempFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                SettingsSnapshot snapshot = SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(path);
                if (snapshot == null) {
                    LOG.info("cannot extract snapshot from tempFile " + tempFile.toPath() + ". Implying there's no snapshot");
                    UpdateResult updateResult = UpdateResult.NoFileOnServer.INSTANCE;
                    return updateResult;
                }
                UpdateResult updateResult = snapshot.isDeleted() ? (UpdateResult)UpdateResult.FileDeletedFromServer.INSTANCE : (UpdateResult)new UpdateResult.Success(snapshot, version, isCrossIdeSync);
                return updateResult;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            return new UpdateResult.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot, boolean force, @Nullable String expectedServerVersionId) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        LOG.info("Pushing setting snapshot to the cloud config server...");
        try {
            path = SettingsSnapshotZipSerializer.INSTANCE.serializeToZip(snapshot);
        }
        catch (Throwable e) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = "Couldn't prepare zip file";
            }
            return new SettingsSyncPushResult.Error(string);
        }
        Path zip = path;
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(zip, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            SettingsSyncPushResult pushResult = this.sendSnapshotFile(inputStream, expectedServerVersionId, force);
            this.clearLastRemoteError();
            SettingsSyncPushResult settingsSyncPushResult = pushResult;
            return settingsSyncPushResult;
        }
        catch (InvalidVersionIdException ive) {
            LOG.info("Rejected: version doesn't match the version on server: " + ive.getMessage());
            SettingsSyncPushResult e = SettingsSyncPushResult.Rejected.INSTANCE;
            return e;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            SettingsSyncPushResult settingsSyncPushResult = new SettingsSyncPushResult.Error(message);
            return settingsSyncPushResult;
        }
        finally {
            try {
                PathKt.delete$default((Path)zip, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
    }

    private final void clearLastRemoteError() {
        if (this.lastRemoteErrorRef.get() != null) {
            LOG.info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    private final String handleRemoteError(Throwable e, String idTokenInRequest) {
        String string;
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                LOG.warn(defaultMessage + ": " + e.getMessage());
            }
        } else if (e instanceof UnauthorizedException) {
            if (idTokenInRequest != null) {
                SettingsSyncAuthService.Companion.getInstance().invalidateJBA(idTokenInRequest);
            }
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
            LOG.warn("Got \"Unauthorized\" from Settings Sync server. Settings Sync will be disabled. Please login to JBA again");
        } else {
            LOG.error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull String filePath, @NotNull FileVersionInfo version) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        InputStream stream = (InputStream)this.clientVersionContext.doWithVersion(filePath, version.getVersionId(), arg_0 -> CloudConfigServerCommunicator.downloadSnapshot$lambda$3(this, arg_0));
        if (stream == null) {
            LOG.info(filePath + " not found on the server");
        }
        return stream;
    }

    @Override
    public void createFile(@NotNull String filePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CloudConfigFileClientV2 cloudConfigFileClientV2 = this.getClient$intellij_settingsSync();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        cloudConfigFileClientV2.write(filePath, new ByteArrayInputStream(byArray));
    }

    private final FileVersionInfo getLatestVersion(String filePath) {
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath);
    }

    @Override
    public void deleteFile(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(null);
        this.getClient$intellij_settingsSync().delete(filePath);
    }

    @Override
    public boolean isFileExists(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath) != null;
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List<FileVersionInfo> list = this.getClient$intellij_settingsSync().getVersions(filePath);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVersions(...)");
        return list;
    }

    @VisibleForTesting
    @NotNull
    public CloudConfigFileClientV2 createCloudConfigClient$intellij_settingsSync(@NotNull String url, @NotNull CloudConfigVersionContext versionContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Configuration conf = this.createConfiguration();
        return new CloudConfigFileClientV2(url, conf, DUMMY_ETAG_STORAGE, versionContext);
    }

    private final Configuration createConfiguration() {
        String idToken;
        Configuration configuration = new Configuration().connectTimeout(10000).readTimeout(50000);
        this._currentIdTokenVar = idToken = SettingsSyncAuthService.Companion.getInstance().getIdToken();
        if (idToken == null) {
            LOG.warn("No idToken provided! Setting Sync will be disabled");
        } else {
            configuration.auth(new JbaJwtTokenAuthProvider(idToken));
        }
        Intrinsics.checkNotNull((Object)configuration);
        return configuration;
    }

    private static final CloudConfigFileClientV2 _client$lambda$0(CloudConfigServerCommunicator this$0, String $serverUrl) {
        String string = $serverUrl;
        if (string == null) {
            string = Companion.getDefaultUrl$intellij_settingsSync();
        }
        return this$0.createCloudConfigClient$intellij_settingsSync(string, this$0.clientVersionContext);
    }

    private static final Pair receiveSnapshotFile$lambda$1(CloudConfigServerCommunicator this$0, String filePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            InputStream stream = this$0.getClient$intellij_settingsSync().read(filePath);
            String actualVersion = this$0.clientVersionContext.get(filePath);
            if (actualVersion == null) {
                LOG.warn("Version not stored in the context for " + filePath);
            }
            pair = new Pair((Object)stream, (Object)actualVersion);
        }
        catch (FileNotFoundException fileNotFound) {
            pair = new Pair(null, null);
        }
        return pair;
    }

    private static final String sendSnapshotFile$lambda$2(CloudConfigFileClientV2 $cloudConfigClient, InputStream $inputStream, CloudConfigVersionContext $versionContext, String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        $cloudConfigClient.write(filePath, $inputStream);
        String actualVersion = $versionContext.get(filePath);
        if (actualVersion == null) {
            LOG.warn("Version not stored in the context for " + filePath);
        }
        return actualVersion;
    }

    private static final InputStream downloadSnapshot$lambda$3(CloudConfigServerCommunicator this$0, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this$0.getClient$intellij_settingsSync().read(path);
    }

    private static final String _url$lambda$4() {
        String string;
        String explicitUrl = System.getProperty(URL_PROPERTY);
        if (explicitUrl != null) {
            LOG.info("Using SettingSync server URL (from properties): " + explicitUrl);
            string = explicitUrl;
        } else if (PluginManagerCore.isRunningFromSources()) {
            LOG.info("Using SettingSync server URL (DEBUG): https://stgn.cloudconfig.jetbrains.com/cloudconfig");
            string = DEFAULT_DEBUG_URL;
        } else {
            string = CloudConfigServerCommunicator.Companion.getProductionUrl();
        }
        return string;
    }

    public CloudConfigServerCommunicator() {
        this(null, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_ETAG_STORAGE = new ETagStorage(){

            public String get(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return null;
            }

            public void store(String path, String value) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void remove(String path) {
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00128\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator$Companion;", "", "<init>", "()V", "URL_PROVIDER", "", "DEFAULT_PRODUCTION_URL", "DEFAULT_DEBUG_URL", "URL_PROPERTY", "defaultUrl", "getDefaultUrl$intellij_settingsSync", "()Ljava/lang/String;", "_url", "Lkotlin/Lazy;", "getProductionUrl", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DUMMY_ETAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "getDUMMY_ETAG_STORAGE$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/ETagStorage;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultUrl$intellij_settingsSync() {
            return (String)_url.getValue();
        }

        private final String getProductionUrl() {
            String configUrl = (String)HttpRequests.request((String)CloudConfigServerCommunicator.URL_PROVIDER).productNameAsUserAgent().connect(Companion::getProductionUrl$lambda$0, (Object)CloudConfigServerCommunicator.DEFAULT_PRODUCTION_URL, LOG);
            LOG.info("Using SettingSync server URL: " + configUrl);
            Intrinsics.checkNotNull((Object)configUrl);
            return configUrl;
        }

        @NotNull
        public final ETagStorage getDUMMY_ETAG_STORAGE$intellij_settingsSync() {
            return DUMMY_ETAG_STORAGE;
        }

        private static final String getProductionUrl$lambda$0(HttpRequests.Request request) {
            String string;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Element documentElement = JDOMUtil.load((InputStream)request.getInputStream());
                string = documentElement.getAttributeValue("baseUrl");
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

