/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ThreadingAssertions {
    private static final String DOCUMENTATION_URL = "https://jb.gg/ij-platform-threading";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_READ_ACTION = "Read access is allowed from inside read-action only (see Application.runReadAction())";
    private static final String MUST_EXECUTE_IN_READ_ACTION_EXPLICIT = "Access is allowed with explicit read lock.\nNow each coroutine scheduled on EDT wrapped in implicit write intent lock (which implies read lock too). This implicit lock will be removed in future releases.\nPlease, use explicit lock API like ReadAction.run(), WriteIntentReadAction.run(), readAction() or writeIntentReadAction() to wrap code which needs lock to access model or PSI.\nPlease note, that read action API can re-schedule your code to background threads, if you are sure that your code need to be executed on EDT, you need to use write intent read action.\nAlso, consult with https://jb.gg/ij-platform-threading";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_READ_ACTION = "Must not execute inside read action";
    private static final String MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION = "Access is allowed from write thread only";
    private static final String MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION_EXPLICIT = "Access is allowed from EDT with explicit write intent lock.\nNow each coroutine scheduled on EDT wrapped in implicit write intent lock. This implicit lock will be removed in future releases.\nPlease, use explicit lock API like WriteIntentReadAction.run() or writeIntentReadAction() to wrap code which needs lock to modify model or PSI.\nAlso, consult with https://jb.gg/ij-platform-threading";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_WRITE_ACTION = "Write access is allowed inside write-action only (see Application.runWriteAction())";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_EDT = "Access is allowed from Event Dispatch Thread (EDT) only";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_EDT = "Access from Event Dispatch Thread (EDT) is not allowed";
    private static boolean implicitLock = false;

    private ThreadingAssertions() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ThreadingAssertions.class);
        if (logger == null) {
            ThreadingAssertions.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_EDT);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_EDT));
        }
    }

    public static void assertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_EDT);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_NOT_EXECUTE_IN_EDT));
        }
    }

    public static void assertReadAccess() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_READ_ACTION);
        } else if (ThreadingAssertions.isImplicitLockOnEDT() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ThreadingAssertions.reportImplicitRead();
        }
    }

    @ApiStatus.Internal
    public static void reportImplicitRead() {
        ThreadingAssertions.getLogger().error(new RuntimeExceptionWithAttachments(MUST_EXECUTE_IN_READ_ACTION_EXPLICIT, new Attachment[0]));
    }

    @ApiStatus.Obsolete
    public static void softAssertReadAccess() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_READ_ACTION));
        }
    }

    public static void assertNoReadAccess() {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_READ_ACTION);
        }
    }

    public static void assertWriteIntentReadAccess() {
        if (!ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            ThreadingAssertions.throwWriteIntentReadAccess();
        } else if (ThreadingAssertions.isImplicitLockOnEDT()) {
            ThreadingAssertions.reportImplicitWriteIntent();
        }
    }

    @ApiStatus.Internal
    public static void reportImplicitWriteIntent() {
        ThreadingAssertions.getLogger().error(new RuntimeExceptionWithAttachments(MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION_EXPLICIT, new Attachment[0]));
    }

    public static void throwWriteIntentReadAccess() {
        ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION);
    }

    public static void assertWriteAccess() {
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_ACTION);
        }
    }

    private static void throwThreadAccessException(@NotNull @NonNls String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        throw ThreadingAssertions.createThreadAccessException(message);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NonNls @NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        boolean skipReadAction = EDT.isCurrentThreadEdt() && ThreadContext.currentThreadContextOrNull() != null;
        return new RuntimeExceptionWithAttachments(message + "; If you access or modify model on EDT consider wrapping your code in WriteIntentReadAction " + (skipReadAction ? "" : " or ReadAction") + "; see " + DOCUMENTATION_URL + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment[0]);
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThreadOrNull();
        String string = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String describe(@Nullable Thread o) {
        String string = o == null ? "null" : o + " " + System.identityHashCode(o);
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isImplicitLockOnEDT() {
        if (!EDT.isCurrentThreadEdt()) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            return false;
        }
        return implicitLock;
    }

    public static void setImplicitLockOnEDT(boolean implicitLock) {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        ThreadingAssertions.implicitLock = implicitLock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

