/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ConfigureImageDialog;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0002H&J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H&J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0015\u0010\u0019\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001a2\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "createDialog", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageDialog;", "element", "(Lcom/intellij/psi/PsiElement;)Lorg/intellij/plugins/markdown/images/editor/ConfigureImageDialog;", "obtainPathText", "", "applyChanges", "", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "obtainLeafElement", "obtainOuterElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "performAction", "getName", "processFileName", "filePath", "getMarkerElementPresentation", "Lorg/jetbrains/annotations/Nls;", "ConfigureImageLineMarkerInfo", "Companion", "intellij.markdown.images"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigureImageLineMarkerProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureImageLineMarkerProviderBase.kt\norg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public abstract class ConfigureImageLineMarkerProviderBase<T extends PsiElement>
extends LineMarkerProviderDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GutterIconRenderer.Alignment ALIGNMENT = GutterIconRenderer.Alignment.CENTER;

    @Nullable
    public abstract ConfigureImageDialog createDialog(@NotNull T var1);

    @Nullable
    public abstract String obtainPathText(@NotNull PsiElement var1);

    public abstract void applyChanges(@NotNull PsiElement var1, @NotNull MarkdownImageData var2);

    @Nullable
    public abstract PsiElement obtainLeafElement(@NotNull PsiElement var1);

    @Nullable
    public abstract T obtainOuterElement(@NotNull PsiElement var1);

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = this.obtainLeafElement(element2);
        if (psiElement == null) {
            return null;
        }
        PsiElement leaf = psiElement;
        TextRange textRange = leaf.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return (LineMarkerInfo)new ConfigureImageLineMarkerInfo(element2, textRange);
    }

    public final void performAction(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        T t = this.obtainOuterElement(element2);
        if (t == null) {
            return;
        }
        T outerElement = t;
        ConfigureImageDialog configureImageDialog = this.createDialog(outerElement);
        if (configureImageDialog == null) {
            return;
        }
        ConfigureImageDialog dialog = configureImageDialog;
        dialog.show((Function1<? super MarkdownImageData, Unit>)((Function1)arg_0 -> ConfigureImageLineMarkerProviderBase.performAction$lambda$0(this, element2, arg_0)));
    }

    @NotNull
    public String getName() {
        return MarkdownImagesBundle.INSTANCE.message("markdown.configure.markdown.image.line.marker.provider.name", new Object[0]);
    }

    private final String processFileName(String filePath) {
        try {
            String string = URI.create(FileUtil.toSystemIndependentName((String)filePath)).getPath();
            if (string == null) {
                return null;
            }
            String uri = string;
            Path path = Paths.get(uri, new String[0]).getFileName();
            return path != null ? ((Object)path).toString() : null;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        catch (InvalidPathException exception) {
            return null;
        }
    }

    private final String getMarkerElementPresentation(PsiElement element2) {
        String string;
        String string2;
        block6: {
            block5: {
                string2 = this.obtainPathText(element2);
                if (string2 == null) break block5;
                String p0 = string2;
                boolean $i$f$getMarkerElementPresentation$stub_for_inlining = false;
                boolean bl = false;
                String string3 = this.processFileName(p0);
                string2 = string3;
                if (string3 != null) break block6;
            }
            string2 = "";
        }
        String fileName = string2;
        if (((CharSequence)fileName).length() == 0) {
            string = MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.text", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{fileName};
            string = MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.line.marker.presentation", objectArray);
        }
        return string;
    }

    private static final Unit performAction$lambda$0(ConfigureImageLineMarkerProviderBase this$0, PsiElement $element, MarkdownImageData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.applyChanges($element, it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase$Companion;", "", "<init>", "()V", "ALIGNMENT", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "intellij.markdown.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase$ConfigureImageLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "element", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getElementPresentation", "", "canMergeWith", "", "info", "getCommonIcon", "Ljavax/swing/Icon;", "infos", "", "getCommonIconAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "intellij.markdown.images"})
    private final class ConfigureImageLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        public ConfigureImageLineMarkerInfo(@NotNull PsiElement element2, TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            super(element2, textRange, MarkdownIcons.ImageGutter, arg_0 -> ConfigureImageLineMarkerInfo._init_$lambda$0((Function1)new Function1<PsiElement, String>((Object)ConfigureImageLineMarkerProviderBase.this){

                public final String invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ConfigureImageLineMarkerProviderBase)((Object)this.receiver)).getMarkerElementPresentation(p0);
                }
            }, arg_0), (arg_0, arg_1) -> ConfigureImageLineMarkerInfo._init_$lambda$1(ConfigureImageLineMarkerProviderBase.this, arg_0, arg_1), ALIGNMENT, ConfigureImageLineMarkerInfo::_init_$lambda$2);
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return ConfigureImageLineMarkerProviderBase.this.getMarkerElementPresentation(element2);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof ConfigureImageLineMarkerInfo;
        }

        @NotNull
        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            Icon icon = ((MergeableLineMarkerInfo)CollectionsKt.first(infos)).getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }

        @NotNull
        public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            return ALIGNMENT;
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final void _init_$lambda$1(ConfigureImageLineMarkerProviderBase this$0, MouseEvent mouseEvent, PsiElement e) {
            Intrinsics.checkNotNull((Object)e);
            this$0.performAction(e);
        }

        private static final String _init_$lambda$2() {
            return MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.text", new Object[0]);
        }
    }
}

