/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiFilter;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.CodeFormatter;
import org.jetbrains.completion.full.line.language.ElementFormatter;
import org.jetbrains.completion.full.line.language.formatters.CodeFormatterBase;
import org.jetbrains.completion.full.line.language.formatters.PlainTextFormatter;
import org.jetbrains.completion.full.line.language.formatters.SkippedElementsFormatter;
import org.jetbrains.completion.full.line.python.formatters.WhitespaceFormatter;
import org.jetbrains.completion.full.line.python.formatters.indents.PyIndentToScopeFormatterBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/PythonCodeFormatterBase;", "Lorg/jetbrains/completion/full/line/language/formatters/CodeFormatterBase;", "<init>", "()V", "elementFormatters", "", "Lorg/jetbrains/completion/full/line/language/ElementFormatter;", "getElementFormatters", "()Ljava/util/List;", "indentFormatter", "Lorg/jetbrains/completion/full/line/python/formatters/indents/PyIndentToScopeFormatterBase;", "getIndentFormatter", "()Lorg/jetbrains/completion/full/line/python/formatters/indents/PyIndentToScopeFormatterBase;", "format", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "importElements", "Lorg/jetbrains/completion/full/line/language/CodeFormatter$ImportElement;", "file", "Lcom/intellij/psi/PsiFile;", "endOfLineMarkers", "getEndOfLineMarkers", "intellij.fullLine.python"})
public abstract class PythonCodeFormatterBase
extends CodeFormatterBase {
    @NotNull
    private final List<ElementFormatter> elementFormatters;
    @NotNull
    private final List<String> endOfLineMarkers;

    public PythonCodeFormatterBase() {
        Object[] objectArray = new ElementFormatter[3];
        objectArray[0] = new WhitespaceFormatter();
        Class[] classArray = new Class[]{PsiComment.class, OuterLanguageElement.class};
        objectArray[1] = new SkippedElementsFormatter(classArray);
        objectArray[2] = new PlainTextFormatter();
        this.elementFormatters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"\u21e5", "\u21e4"};
        this.endOfLineMarkers = CollectionsKt.plus((Collection)super.getEndOfLineMarkers(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public List<ElementFormatter> getElementFormatters() {
        return this.elementFormatters;
    }

    @NotNull
    protected abstract PyIndentToScopeFormatterBase getIndentFormatter();

    @NotNull
    public String format(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String formatted = ((Object)StringsKt.trimStart((CharSequence)super.format(element, range))).toString();
        return this.getIndentFormatter().format(formatted);
    }

    @NotNull
    public List<CodeFormatter.ImportElement> importElements(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = new ArrayList();
        new PsiFilter(PyImportStatementBase.class).createVisitor(list).visitFile(file);
        return this.asImportElements(list);
    }

    @NotNull
    public List<String> getEndOfLineMarkers() {
        return this.endOfLineMarkers;
    }
}

