/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance(PtyCommandLine.class);
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    public static final int MAX_COLUMNS = 2500;
    private final LocalPtyOptions.Builder myOptionsBuilder;
    private boolean myWindowsAnsiColorEnabled;
    private boolean myUnixOpenTtyToPreserveOutputAfterTermination;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    public PtyCommandLine() {
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = SystemProperties.getBooleanProperty((String)"pty4j.open.child.tty", (boolean)SystemInfo.isMac);
    }

    public PtyCommandLine(@NotNull List<String> command) {
        if (command == null) {
            PtyCommandLine.$$$reportNull$$$0(0);
        }
        super(command);
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = SystemProperties.getBooleanProperty((String)"pty4j.open.child.tty", (boolean)SystemInfo.isMac);
    }

    public PtyCommandLine(@NotNull GeneralCommandLine original) {
        if (original == null) {
            PtyCommandLine.$$$reportNull$$$0(1);
        }
        super(original);
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = SystemProperties.getBooleanProperty((String)"pty4j.open.child.tty", (boolean)SystemInfo.isMac);
        if (original instanceof PtyCommandLine) {
            this.myOptionsBuilder.set(((PtyCommandLine)original).myOptionsBuilder.build());
        }
    }

    public PtyCommandLine withUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myOptionsBuilder.useCygwinLaunch(useCygwinLaunch);
        return this;
    }

    public PtyCommandLine withConsoleMode(boolean consoleMode) {
        this.myOptionsBuilder.consoleMode(consoleMode);
        return this;
    }

    public PtyCommandLine withInitialColumns(int initialColumns) {
        this.myOptionsBuilder.initialColumns(initialColumns);
        return this;
    }

    public PtyCommandLine withInitialRows(int initialRows) {
        this.myOptionsBuilder.initialRows(initialRows);
        return this;
    }

    public PtyCommandLine withOptions(@NotNull LocalPtyOptions options) {
        if (options == null) {
            PtyCommandLine.$$$reportNull$$$0(2);
        }
        this.myOptionsBuilder.set(options);
        return this;
    }

    @NotNull
    PtyCommandLine withWindowsAnsiColorDisabled() {
        this.myWindowsAnsiColorEnabled = false;
        PtyCommandLine ptyCommandLine = this;
        if (ptyCommandLine == null) {
            PtyCommandLine.$$$reportNull$$$0(3);
        }
        return ptyCommandLine;
    }

    @NotNull
    public PtyCommandLine withUnixOpenTtyToPreserveOutputAfterTermination(boolean unixOpenTtyToPreserveOutputAfterTermination) {
        this.myUnixOpenTtyToPreserveOutputAfterTermination = unixOpenTtyToPreserveOutputAfterTermination;
        PtyCommandLine ptyCommandLine = this;
        if (ptyCommandLine == null) {
            PtyCommandLine.$$$reportNull$$$0(4);
        }
        return ptyCommandLine;
    }

    @Override
    @NotNull
    protected Process createProcess(@NotNull ProcessBuilder processBuilder) throws IOException {
        if (processBuilder == null) {
            PtyCommandLine.$$$reportNull$$$0(5);
        }
        if (this.getInputFile() == null && !this.isProcessCreatorSet()) {
            Process process;
            try {
                process = this.startProcessWithPty(processBuilder.command());
            }
            catch (Throwable t) {
                String message = "Couldn't run process with PTY";
                if (LOG.isDebugEnabled()) {
                    String logFileContent = PtyCommandLine.loadLogFile();
                    if (logFileContent != null) {
                        LOG.debug(message, new Object[]{t, logFileContent});
                    } else {
                        LOG.warn(message, t);
                    }
                }
                LOG.warn(message, t);
            }
            if (process == null) {
                PtyCommandLine.$$$reportNull$$$0(6);
            }
            return process;
        }
        Process process = super.createProcess(processBuilder);
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(7);
        }
        return process;
    }

    @Nullable
    private static String loadLogFile() {
        Path logFile;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isEAP() && Files.exists(logFile = PathManager.getLogDir().resolve("pty.log"), new LinkOption[0])) {
            try {
                return Files.readString(logFile);
            }
            catch (Exception e) {
                return "Unable to retrieve PTY log: " + e.getMessage();
            }
        }
        return null;
    }

    @NotNull
    public LocalPtyOptions getPtyOptions() {
        LocalPtyOptions localPtyOptions = this.myOptionsBuilder.build();
        if (localPtyOptions == null) {
            PtyCommandLine.$$$reportNull$$$0(8);
        }
        return localPtyOptions;
    }

    @ApiStatus.Internal
    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(9);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (!SystemInfo.isWindows && !this.getEnvironment().containsKey("TERM")) {
            env.put("TERM", "xterm-256color");
        }
        String[] command = ArrayUtilRt.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        LocalPtyOptions options = this.getPtyOptions();
        Application app = ApplicationManager.getApplication();
        Process process = ProcessService.getInstance().startPtyProcess(command, directory, env, options, app, this.isRedirectErrorStream(), this.myWindowsAnsiColorEnabled, this.myUnixOpenTtyToPreserveOutputAfterTermination);
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(10);
        }
        return process;
    }

    @ApiStatus.Internal
    @NotNull
    public static LocalPtyOptions getDefaultPtyOptions() {
        LocalPtyOptions localPtyOptions = LocalPtyOptions.defaults().builder().consoleMode(true).build();
        if (localPtyOptions == null) {
            PtyCommandLine.$$$reportNull$$$0(11);
        }
        return localPtyOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withWindowsAnsiColorDisabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withUnixOpenTtyToPreserveOutputAfterTermination";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPtyOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessWithPty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPtyOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withOptions";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startProcessWithPty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

