/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.simplepainter;

import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.TransformCreator;
import com.openhtmltopdf.render.simplepainter.SimpleBoxCollector;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.Map;

public class SimplePainter {
    private final int xTranslate;
    private final int yTranslate;

    public SimplePainter(int xtrans, int ytrans) {
        this.xTranslate = xtrans;
        this.yTranslate = ytrans;
    }

    private void debugOnly(String msg, Object arg) {
    }

    public void paintLayer(RenderingContext c, Layer layer) {
        Box master = layer.getMaster();
        Rectangle parentClip = layer.getMaster().getParentClipBox(c, layer.getParent());
        if (parentClip != null) {
            c.getOutputDevice().pushClip(parentClip);
        }
        if (layer.hasLocalTransform()) {
            AffineTransform transform2 = c.isInPageMargins() ? TransformCreator.createPageMarginCoordinatesTransform(c, master, c.getPage(), this.xTranslate, this.yTranslate) : TransformCreator.createPageCoordinatesTranform(c, master, c.getPage(), c.getShadowPageNumber());
            c.getOutputDevice().pushTransformLayer(transform2);
        }
        if (!layer.isInline() && ((BlockBox)master).isReplaced()) {
            this.paintLayerBackgroundAndBorder(c, master);
            this.paintReplacedElement(c, (BlockBox)master);
        } else {
            SimpleBoxCollector boxCollector = new SimpleBoxCollector();
            boxCollector.collect(c, layer);
            if (!layer.isInline() && master instanceof BlockBox) {
                this.paintLayerBackgroundAndBorder(c, master);
            }
            if (layer.isRootLayer() || layer.isStackingContext() || master.getStyle().isFixed()) {
                this.paintLayers(c, layer.getSortedLayers(3));
            }
            Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders = boxCollector.tcells().isEmpty() ? null : DisplayListCollector.collectCollapsedTableBorders(c, boxCollector.tcells());
            this.paintBackgroundsAndBorders(c, boxCollector.blocks(), collapsedTableBorders);
            this.paintFloats(c, layer.getFloats());
            this.paintListMarkers(c, boxCollector.listItems());
            this.paintInlineContent(c, boxCollector.inlines());
            this.paintReplacedElements(c, boxCollector.replaceds());
            if (layer.isRootLayer() || layer.isStackingContext() || master.getStyle().isFixed()) {
                this.paintLayers(c, layer.collectLayers(4));
                this.paintLayers(c, layer.getSortedLayers(2));
                this.paintLayers(c, layer.getSortedLayers(1));
            }
        }
        if (layer.hasLocalTransform()) {
            c.getOutputDevice().popTransformLayer();
        }
        if (parentClip != null) {
            c.getOutputDevice().popClip();
        }
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c, Box master) {
        master.paintBackground(c);
        master.paintBorder(c);
    }

    private void clip(RenderingContext c, OperatorClip clip) {
        this.debugOnly("clipping", clip.getClip());
        c.getOutputDevice().pushClip(clip.getClip());
    }

    private void setClip(RenderingContext c, OperatorSetClip setclip) {
        this.debugOnly("popping clip", null);
        c.getOutputDevice().popClip();
    }

    private void paintBackgroundsAndBorders(RenderingContext c, List<DisplayListItem> blocks, Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders) {
        for (DisplayListItem dli : blocks) {
            List<CollapsedBorderSide> borders;
            TableCellBox cell;
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            this.debugOnly("painting bg", box);
            box.paintBackground(c);
            box.paintBorder(c);
            if (collapsedTableBorders == null || !(box instanceof TableCellBox) || !(cell = (TableCellBox)box).hasCollapsedPaintingBorder() || (borders = collapsedTableBorders.get(cell)) == null) continue;
            for (CollapsedBorderSide border : borders) {
                border.getCell().paintCollapsedBorder(c, border.getSide());
            }
        }
    }

    private void paintListMarkers(RenderingContext c, List<DisplayListItem> listItems) {
        for (DisplayListItem dli : listItems) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            this.debugOnly("Painting list item", dli);
            ((BlockBox)dli).paintListMarker(c);
        }
    }

    private void paintInlineContent(RenderingContext c, List<DisplayListItem> inlines) {
        for (DisplayListItem dli : inlines) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            if (dli instanceof BlockBox) {
                BlockBox bb = (BlockBox)dli;
                this.paintAsLayer(c, bb);
                continue;
            }
            InlinePaintable paintable = (InlinePaintable)((Object)dli);
            this.debugOnly("Painting Inline", paintable);
            paintable.paintInline(c);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        c.getOutputDevice().paintReplacedElement(c, replaced);
    }

    private void paintReplacedElements(RenderingContext c, List<DisplayListItem> replaceds) {
        for (DisplayListItem dli : replaceds) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            this.paintReplacedElement(c, box);
        }
    }

    private void paintFloats(RenderingContext c, List<BlockBox> floaters) {
        for (int i = floaters.size() - 1; i >= 0; --i) {
            this.paintAsLayer(c, floaters.get(i));
        }
    }

    private void paintLayers(RenderingContext c, List<Layer> layers) {
        for (Layer layer : layers) {
            this.paintLayer(c, layer);
        }
    }

    public void paintAsLayer(RenderingContext c, BlockBox startingPoint) {
        if (startingPoint.getStyle().requiresLayer()) {
            return;
        }
        SimpleBoxCollector collector = new SimpleBoxCollector();
        collector.collect(c, startingPoint.getContainingLayer(), startingPoint);
        Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders = collector.tcells().isEmpty() ? null : DisplayListCollector.collectCollapsedTableBorders(c, collector.tcells());
        this.paintBackgroundsAndBorders(c, collector.blocks(), collapsedTableBorders);
        this.paintListMarkers(c, collector.listItems());
        this.paintInlineContent(c, collector.inlines());
        this.paintReplacedElements(c, collector.replaceds());
    }
}

