/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.ext.attributes.AttributeImplicitName;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributeValueQuotes;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesFormatOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.formatter.ExplicitAttributeIdProvider;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.NotNullValueSupplier;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesNodeFormatter
implements PhasedNodeFormatter,
ExplicitAttributeIdProvider {
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATION_MAP = new DataKey<NotNullValueSupplier<Map>>("ATTRIBUTE_TRANSLATION_MAP", HashMap::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATED_MAP = new DataKey<NotNullValueSupplier<Map>>("ATTRIBUTE_TRANSLATED_MAP", HashMap::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_ORIGINAL_ID_MAP = new DataKey<NotNullValueSupplier<Map>>("ATTRIBUTE_ORIGINAL_ID_MAP", HashMap::new);
    public static final DataKey<Set<Node>> PROCESSED_ATTRIBUTES = new DataKey<NotNullValueSupplier<Set>>("PROCESSED_ATTRIBUTES", HashSet::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_ID_MAP = Formatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP;
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP = new DataKey<NotNullValueSupplier<Map>>("ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP", HashMap::new);
    public static final DataKey<Integer> ATTRIBUTE_TRANSLATION_ID = new DataKey<Integer>("ATTRIBUTE_TRANSLATION_ID", 0);
    private Map<String, String> attributeTranslationMap;
    private Map<String, String> attributeTranslatedMap;
    private Map<String, String> attributeOriginalIdMap;
    private Map<String, String> attributeUniquificationIdMap;
    private int attributeOriginalId;
    private final AttributesFormatOptions formatOptions;

    public AttributesNodeFormatter(DataHolder options) {
        this.formatOptions = new AttributesFormatOptions(options);
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    @Nullable
    public Set<FormattingPhase> getFormattingPhases() {
        return Collections.singleton(FormattingPhase.COLLECT);
    }

    @Override
    public void addExplicitId(@NotNull Node node, @Nullable String id, @NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown) {
        String uniqueId;
        if (id != null && node instanceof Heading && context.getRenderPurpose() == RenderPurpose.TRANSLATED && this.hasNoIdAttribute(node) && this.attributeUniquificationIdMap != null && !(uniqueId = this.attributeUniquificationIdMap.getOrDefault(id, id)).equals(id)) {
            markdown.append(" {.");
            markdown.append(uniqueId);
            markdown.append("}");
        }
    }

    boolean hasNoIdAttribute(Node node) {
        boolean haveIdAttribute = false;
        for (Node child : node.getChildren()) {
            if (!(child instanceof AttributesNode)) continue;
            for (Node attr : child.getChildren()) {
                if (!(attr instanceof AttributeNode) || !((AttributeNode)attr).isId()) continue;
                haveIdAttribute = true;
                break;
            }
            if (!haveIdAttribute) continue;
            break;
        }
        return !haveIdAttribute;
    }

    @Override
    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        if (context.isTransformingText()) {
            context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, Integer.valueOf(0));
            this.attributeOriginalId = 0;
            if (phase == FormattingPhase.COLLECT) {
                context.getDocument().remove(PROCESSED_ATTRIBUTES);
                if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                    context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_MAP, new HashMap());
                    context.getTranslationStore().set(ATTRIBUTE_TRANSLATED_MAP, new HashMap());
                    context.getTranslationStore().set(ATTRIBUTE_ORIGINAL_ID_MAP, new HashMap());
                    MergeContext mergeContext = context.getMergeContext();
                    if (mergeContext != null) {
                        final HashSet mergedUniquified = new HashSet();
                        mergeContext.forEachPrecedingDocument(document, (docContext, doc, index) -> {
                            NodeAttributeRepository attributes = AttributesExtension.NODE_ATTRIBUTES.get(doc);
                            final Map<String, String> idUniquificationMap = ATTRIBUTE_UNIQUIFICATION_ID_MAP.get(docContext.getTranslationStore());
                            for (List list2 : attributes.values()) {
                                for (AttributesNode attributesNode : list2) {
                                    for (Node childNode : attributesNode.getChildren()) {
                                        String key;
                                        String newKey;
                                        AttributeNode attributeNode;
                                        if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId() || mergedUniquified.contains(newKey = idUniquificationMap.getOrDefault(key = attributeNode.getValue().toString(), key))) continue;
                                        mergedUniquified.add(newKey);
                                    }
                                }
                            }
                            final HtmlIdGenerator generator = context.getIdGenerator();
                            if (generator != null) {
                                new AnchorRefTargetBlockVisitor(){

                                    @Override
                                    protected void visit(AnchorRefTarget refTarget) {
                                        Node node = (Node)((Object)refTarget);
                                        if (AttributesNodeFormatter.this.hasNoIdAttribute(node)) {
                                            String newKey;
                                            String key = generator.getId(node);
                                            if (key == null) {
                                                String text2 = refTarget.getAnchorRefText();
                                                key = generator.getId(text2);
                                                refTarget.setAnchorRefId(key);
                                            }
                                            if (key != null && !mergedUniquified.contains(newKey = idUniquificationMap.getOrDefault(key, key))) {
                                                mergedUniquified.add(newKey);
                                            }
                                        }
                                    }
                                }.visit(document);
                            }
                        });
                        NodeAttributeRepository attributes = AttributesExtension.NODE_ATTRIBUTES.get(document);
                        Map<String, String> categoryUniquificationMap = ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP.get(context.getTranslationStore());
                        final HashMap<String, String> idMap = new HashMap<String, String>();
                        for (List list2 : attributes.values()) {
                            for (AttributesNode attributesNode : list2) {
                                for (Node childNode : attributesNode.getChildren()) {
                                    String key;
                                    AttributeNode attributeNode;
                                    if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId()) continue;
                                    BasedSequence valueChars = attributeNode.getValue();
                                    String useKey = key = valueChars.toString();
                                    int pos = valueChars.indexOf(':');
                                    if (pos != -1) {
                                        String category = valueChars.subSequence(0, pos).toString();
                                        String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                                        String uniqueCategory = category;
                                        uniqueCategory = categoryUniquificationMap.getOrDefault(category, category);
                                        useKey = String.format("%s:%s", uniqueCategory, id);
                                    }
                                    int i = 0;
                                    String newKey = useKey;
                                    while (mergedUniquified.contains(newKey)) {
                                        newKey = String.format("%s%d", useKey, ++i);
                                    }
                                    if (i <= 0 && newKey.equals(key)) continue;
                                    idMap.put(key, newKey);
                                }
                            }
                        }
                        final HtmlIdGenerator generator = context.getIdGenerator();
                        if (generator != null) {
                            new AnchorRefTargetBlockVisitor(){

                                @Override
                                protected void visit(AnchorRefTarget refTarget) {
                                    Node node = (Node)((Object)refTarget);
                                    if (AttributesNodeFormatter.this.hasNoIdAttribute(node)) {
                                        String key = generator.getId(node);
                                        if (key == null) {
                                            String text2 = refTarget.getAnchorRefText();
                                            key = generator.getId(text2);
                                            refTarget.setAnchorRefId(key);
                                        }
                                        if (key != null) {
                                            int i = 0;
                                            String newKey = key;
                                            while (mergedUniquified.contains(newKey)) {
                                                newKey = String.format("%s%d", key, ++i);
                                            }
                                            if (i > 0 || !newKey.equals(key)) {
                                                idMap.put(key, newKey);
                                            }
                                        }
                                    }
                                }
                            }.visit(document);
                        }
                        if (!idMap.isEmpty()) {
                            context.getTranslationStore().set(ATTRIBUTE_UNIQUIFICATION_ID_MAP, idMap);
                        }
                    }
                }
            }
        }
        this.attributeUniquificationIdMap = ATTRIBUTE_UNIQUIFICATION_ID_MAP.get(context.getTranslationStore());
        this.attributeTranslationMap = ATTRIBUTE_TRANSLATION_MAP.get(context.getTranslationStore());
        this.attributeTranslatedMap = ATTRIBUTE_TRANSLATED_MAP.get(context.getTranslationStore());
        this.attributeOriginalIdMap = ATTRIBUTE_ORIGINAL_ID_MAP.get(context.getTranslationStore());
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeFormattingHandler<AttributesNode>(AttributesNode.class, this::render));
        set.add(new NodeFormattingHandler<AttributesDelimiter>(AttributesDelimiter.class, this::render));
        return set;
    }

    public static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown) {
        Map<String, String> idUniquificationMap;
        Map<String, String> attributeTranslationMap = ATTRIBUTE_TRANSLATION_MAP.get(context.getTranslationStore());
        Map<String, String> attributeTranslatedMap = ATTRIBUTE_TRANSLATED_MAP.get(context.getTranslationStore());
        String id = AttributesNodeFormatter.getEncodedIdAttribute(category, categoryId, context, markdown, attributeTranslationMap, attributeTranslatedMap);
        if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && !(idUniquificationMap = ATTRIBUTE_UNIQUIFICATION_ID_MAP.get(context.getTranslationStore())).isEmpty()) {
            return idUniquificationMap.getOrDefault(id, id);
        }
        return id;
    }

    private static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown, Map<String, String> attributeTranslationMap, Map<String, String> attributeTranslatedMap) {
        String encodedCategory = category;
        String encodedId = categoryId;
        int placeholderId = ATTRIBUTE_TRANSLATION_ID.get(context.getTranslationStore());
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                if (!attributeTranslationMap.containsKey(category)) {
                    encodedCategory = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(category, encodedCategory);
                    attributeTranslatedMap.put(encodedCategory, category);
                } else {
                    encodedCategory = attributeTranslationMap.get(category);
                }
                if (categoryId != null && !attributeTranslationMap.containsKey(categoryId)) {
                    encodedId = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(categoryId, encodedId);
                    attributeTranslatedMap.put(encodedId, categoryId);
                    break;
                }
                encodedId = attributeTranslationMap.get(categoryId);
                break;
            }
            case TRANSLATED_SPANS: {
                break;
            }
            case TRANSLATED: {
                encodedCategory = attributeTranslatedMap.get(category);
                if (categoryId == null) break;
                encodedId = attributeTranslatedMap.get(categoryId);
                break;
            }
        }
        context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, Integer.valueOf(placeholderId));
        if (encodedId == null) {
            return encodedCategory;
        }
        return encodedCategory + ":" + encodedId;
    }

    private String getEncodedOriginalId(String attribute, NodeFormatterContext context) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                String encodedAttribute = "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
                this.attributeOriginalIdMap.put(encodedAttribute, attribute);
                return encodedAttribute;
            }
            case TRANSLATED_SPANS: {
                return "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
            }
            case TRANSLATED: {
                ++this.attributeOriginalId;
                String id = this.attributeOriginalIdMap.get(attribute);
                if (this.attributeUniquificationIdMap != null) {
                    return this.attributeUniquificationIdMap.getOrDefault(id, id);
                }
                return id;
            }
        }
        return attribute;
    }

    void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        block54: {
            Collection childNodes;
            block53: {
                Node previous = node.getPrevious();
                if (!(previous == null || previous.getChars().isContinuedBy(node.getChars()) || previous.getChars().endsWith(" ") || node.getChars().startsWith(" "))) {
                    markdown.append(' ');
                }
                if (!context.isTransformingText()) break block53;
                markdown.append(node.getOpeningMarker());
                boolean firstChild = true;
                for (Node child : node.getChildren()) {
                    AttributeNode attributeNode = (AttributeNode)child;
                    if (!firstChild) {
                        markdown.append(' ');
                    }
                    if (attributeNode.isId()) {
                        BasedSequence valueChars = attributeNode.getValue();
                        int pos = valueChars.indexOf(':');
                        if (pos == -1) {
                            Object encodedOriginal = this.getEncodedOriginalId(attributeNode.getChars().toString(), context);
                            if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && !this.attributeUniquificationIdMap.isEmpty()) {
                                String idOnly = ((String)encodedOriginal).substring(1);
                                encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                            }
                            markdown.append((CharSequence)encodedOriginal);
                        } else {
                            String category = valueChars.subSequence(0, pos).toString();
                            String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                            String encoded2 = AttributesNodeFormatter.getEncodedIdAttribute(category, id, context, markdown, this.attributeTranslationMap, this.attributeTranslatedMap);
                            switch (context.getRenderPurpose()) {
                                case TRANSLATION_SPANS: 
                                case TRANSLATED_SPANS: {
                                    String encodedAttribute = "#" + encoded2;
                                    this.attributeOriginalIdMap.put(encodedAttribute, attributeNode.getChars().toString());
                                    ((MarkdownWriter)markdown.append('#')).append(encoded2);
                                    break;
                                }
                                case TRANSLATED: {
                                    Object encodedOriginal = this.attributeOriginalIdMap.get("#" + valueChars.toString());
                                    if (this.attributeUniquificationIdMap != null && !this.attributeUniquificationIdMap.isEmpty()) {
                                        String idOnly = ((String)encodedOriginal).substring(1);
                                        encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                                    }
                                    markdown.append((CharSequence)(encodedOriginal == null ? attributeNode.getChars().toString() : encodedOriginal));
                                    break;
                                }
                                default: {
                                    markdown.append(attributeNode.getChars());
                                }
                            }
                        }
                    } else {
                        markdown.appendNonTranslating(".", attributeNode.getChars());
                    }
                    firstChild = false;
                }
                markdown.append(node.getClosingMarker());
                break block54;
            }
            Set<Node> processedNodes = PROCESSED_ATTRIBUTES.get(context.getDocument());
            if (processedNodes.contains(node)) {
                return;
            }
            BasedSequence chars = node.getChars();
            BasedSequence openMarker = node.getOpeningMarker();
            BasedSequence closeMarker = node.getClosingMarker();
            BasedSequence spaceAfterOpenMarker = chars.safeBaseCharAt(openMarker.getEndOffset()) == ' ' ? chars.baseSubSequence(openMarker.getEndOffset(), openMarker.getEndOffset() + 1) : BasedSequence.NULL;
            BasedSequence spaceBeforeCloseMarker = chars.safeBaseCharAt(closeMarker.getStartOffset() - 1) == ' ' ? chars.baseSubSequence(closeMarker.getStartOffset() - 1, closeMarker.getStartOffset()) : BasedSequence.NULL;
            switch (this.formatOptions.attributesSpaces) {
                case AS_IS: {
                    break;
                }
                case ADD: {
                    spaceAfterOpenMarker = BasedSequence.SPACE;
                    spaceBeforeCloseMarker = BasedSequence.SPACE;
                    break;
                }
                case REMOVE: {
                    spaceAfterOpenMarker = BasedSequence.NULL;
                    spaceBeforeCloseMarker = BasedSequence.NULL;
                }
            }
            markdown.append(node.getOpeningMarker());
            markdown.append(spaceAfterOpenMarker);
            AttributeValueQuotes valueQuotes = this.formatOptions.attributeValueQuotes;
            boolean firstChild = true;
            LinkedHashMap<String, AttributeNode> attributeNodes = new LinkedHashMap<String, AttributeNode>();
            if (this.formatOptions.attributesCombineConsecutive) {
                NodeAttributeRepository nodeAttributeRepository = AttributesExtension.NODE_ATTRIBUTES.get(context.getDocument());
                for (Map.Entry<Node, ArrayList<AttributesNode>> entry : nodeAttributeRepository.entrySet()) {
                    if (!entry.getValue().contains(node)) continue;
                    for (AttributesNode attributesNode : entry.getValue()) {
                        processedNodes.add(attributesNode);
                        for (Node child : attributesNode.getChildren()) {
                            AttributeNode attributeNode = (AttributeNode)child;
                            attributeNodes.put(attributeNode.getName().toString(), AttributesNodeFormatter.combineAttributes(attributeNodes, attributeNode));
                        }
                    }
                }
            }
            if (attributeNodes.isEmpty()) {
                for (Node child : node.getChildren()) {
                    AttributeNode attributeNode = (AttributeNode)child;
                    attributeNodes.put(attributeNode.getName().toString(), AttributesNodeFormatter.combineAttributes(attributeNodes, attributeNode));
                }
            }
            if (this.formatOptions.attributesSort) {
                ArrayList entries = new ArrayList(attributeNodes.entrySet());
                entries.sort((o1, o2) -> {
                    if (((AttributeNode)o1.getValue()).isId()) {
                        return -1;
                    }
                    if (((AttributeNode)o2.getValue()).isId()) {
                        return 1;
                    }
                    if (((AttributeNode)o1.getValue()).isClass()) {
                        return -1;
                    }
                    if (((AttributeNode)o2.getValue()).isClass()) {
                        return 1;
                    }
                    return ((AttributeNode)o1.getValue()).getName().compareTo(((AttributeNode)o2.getValue()).getName());
                });
                ArrayList nodes = new ArrayList(entries.size());
                for (Map.Entry entry : entries) {
                    nodes.add((AttributeNode)entry.getValue());
                }
                childNodes = nodes;
            } else {
                childNodes = attributeNodes.values();
            }
            for (Node child : childNodes) {
                String quote;
                BasedSequence spaceAfterSep;
                BasedSequence spaceBeforeSep;
                BasedSequence sep;
                BasedSequence value2;
                BasedSequence name;
                block56: {
                    String needQuote;
                    AttributeNode attributeNode;
                    block55: {
                        attributeNode = (AttributeNode)child;
                        if (!firstChild) {
                            markdown.append(' ');
                        }
                        BasedSequence basedSequence = attributeNode.getChars();
                        name = attributeNode.getName();
                        value2 = attributeNode.getValue();
                        sep = attributeNode.getAttributeSeparator();
                        spaceBeforeSep = basedSequence.safeBaseCharAt(sep.getStartOffset() - 1) == ' ' ? basedSequence.baseSubSequence(sep.getStartOffset() - 1, sep.getStartOffset()) : BasedSequence.NULL;
                        spaceAfterSep = basedSequence.safeBaseCharAt(sep.getEndOffset()) == ' ' ? basedSequence.baseSubSequence(sep.getEndOffset(), sep.getEndOffset() + 1) : BasedSequence.NULL;
                        switch (this.formatOptions.attributeEqualSpace) {
                            case AS_IS: {
                                break;
                            }
                            case ADD: {
                                spaceBeforeSep = BasedSequence.SPACE;
                                spaceAfterSep = BasedSequence.SPACE;
                                break;
                            }
                            case REMOVE: {
                                spaceBeforeSep = BasedSequence.NULL;
                                spaceAfterSep = BasedSequence.NULL;
                            }
                        }
                        quote = attributeNode.isImplicitName() ? "" : valueQuotes.quotesFor(value2, attributeNode.getOpeningMarker());
                        needQuote = AttributeValueQuotes.NO_QUOTES_DOUBLE_PREFERRED.quotesFor(value2, "");
                        if (!attributeNode.isId()) break block55;
                        switch (needQuote.isEmpty() ? this.formatOptions.attributeIdFormat : AttributeImplicitName.EXPLICIT_PREFERRED) {
                            case AS_IS: {
                                break block56;
                            }
                            case IMPLICIT_PREFERRED: {
                                if (!attributeNode.isImplicitName()) {
                                    name = PrefixedSubSequence.prefixOf("#", name.getEmptyPrefix());
                                    sep = BasedSequence.NULL;
                                    quote = "";
                                }
                                break block56;
                            }
                            case EXPLICIT_PREFERRED: {
                                if (attributeNode.isImplicitName()) {
                                    name = PrefixedSubSequence.prefixOf("id", name.getEmptyPrefix());
                                    sep = PrefixedSubSequence.prefixOf("=", name.getEmptySuffix());
                                    if (quote.isEmpty() && (quote = valueQuotes.quotesFor(value2, attributeNode.getOpeningMarker())).isEmpty()) {
                                        quote = needQuote;
                                    }
                                }
                                break block56;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + this.formatOptions.attributeIdFormat);
                            }
                        }
                    }
                    if (attributeNode.isClass()) {
                        switch (needQuote.isEmpty() ? this.formatOptions.attributeClassFormat : AttributeImplicitName.EXPLICIT_PREFERRED) {
                            case AS_IS: {
                                break;
                            }
                            case IMPLICIT_PREFERRED: {
                                if (attributeNode.isImplicitName()) break;
                                name = PrefixedSubSequence.prefixOf(".", name.getEmptyPrefix());
                                sep = BasedSequence.NULL;
                                quote = "";
                                break;
                            }
                            case EXPLICIT_PREFERRED: {
                                if (!attributeNode.isImplicitName()) break;
                                name = PrefixedSubSequence.prefixOf("class", name.getEmptyPrefix());
                                sep = PrefixedSubSequence.prefixOf("=", name.getEmptySuffix());
                                if (!quote.isEmpty() || !(quote = valueQuotes.quotesFor(value2, attributeNode.getOpeningMarker())).isEmpty()) break;
                                quote = needQuote;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + this.formatOptions.attributeIdFormat);
                            }
                        }
                    }
                }
                markdown.append(name);
                if (!sep.isEmpty()) {
                    ((MarkdownWriter)((MarkdownWriter)markdown.append(spaceBeforeSep)).append(sep)).append(spaceAfterSep);
                }
                if (!quote.isEmpty()) {
                    String replaceQuote = quote.equals("'") ? "&apos;" : (quote.equals("\"") ? "&quot;" : "");
                    markdown.append(quote);
                    markdown.append((CharSequence)value2.replace(quote, replaceQuote));
                    markdown.append(quote);
                } else {
                    markdown.append(value2);
                }
                firstChild = false;
            }
            markdown.append(spaceBeforeCloseMarker);
            markdown.append(node.getClosingMarker());
        }
        Node next = node.getNext();
        if (!(next == null || next instanceof AttributesNode || node.getChars().isContinuedBy(next.getChars()) || node.getChars().endsWith(" ") || next.getChars().startsWith(" "))) {
            markdown.append(' ');
        }
    }

    static AttributeNode combineAttributes(LinkedHashMap<String, AttributeNode> attributeNodes, AttributeNode attributeNode) {
        if (attributeNode.isId()) {
            attributeNodes.remove("id");
            attributeNodes.remove("#");
            return attributeNode;
        }
        if (attributeNode.isClass()) {
            AttributeNode newNode = attributeNode;
            AttributeNode removed1 = (AttributeNode)attributeNodes.remove("class");
            AttributeNode removed2 = (AttributeNode)attributeNodes.remove(".");
            if (removed1 != null || removed2 != null) {
                MutableAttributes attributes = new MutableAttributes();
                if (removed1 != null) {
                    attributes.addValue("class", removed1.getValue());
                }
                if (removed2 != null) {
                    attributes.addValue("class", removed2.getValue());
                }
                String value2 = attributes.getValue("class");
                if (!attributeNode.getValue().equals(value2)) {
                    PrefixedSubSequence newValue = PrefixedSubSequence.prefixOf(value2 + " ", attributeNode.getValue());
                    newNode = new AttributeNode(attributeNode.getName(), attributeNode.getAttributeSeparator(), attributeNode.getOpeningMarker(), newValue, attributeNode.getClosingMarker());
                }
            }
            return newNode;
        }
        if (attributeNode.getName().equals("style")) {
            AttributeNode newNode = attributeNode;
            AttributeNode removed1 = (AttributeNode)attributeNodes.remove("style");
            if (removed1 != null) {
                MutableAttributes attributes = new MutableAttributes();
                attributes.addValue("style", removed1.getValue());
                String value3 = attributes.getValue("style");
                if (!attributeNode.getValue().equals(value3)) {
                    PrefixedSubSequence newValue = PrefixedSubSequence.prefixOf(value3 + ";", attributeNode.getValue());
                    newNode = new AttributeNode(attributeNode.getName(), attributeNode.getAttributeSeparator(), attributeNode.getOpeningMarker(), newValue, attributeNode.getClosingMarker());
                }
            }
            return newNode;
        }
        return attributeNode;
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new AttributesNodeFormatter(options);
        }
    }
}

