/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.webTypes.json.Css;
import com.intellij.webSymbols.webTypes.json.Html;
import com.intellij.webSymbols.webTypes.json.JsGlobal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"html", "css", "js"})
public class Contributions {
    @JsonProperty(value="html")
    @JsonPropertyDescription(value="Contains contributions to HTML namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are 2 predefined kinds, which integrate directly with IDE - HTML elements and HTML attributes. There are also 2 deprecated kinds: tags (which is equivalent to 'elements') and 'events' (which was moved to JS namespace)")
    private Html html;
    @JsonProperty(value="css")
    @JsonPropertyDescription(value="Contains contributions to CSS namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are predefined kinds, which integrate directly with IDE - properties, classes, functions, pseudo-elements, pseudo-classes and parts.")
    private Css css;
    @JsonProperty(value="js")
    @JsonPropertyDescription(value="Contains contributions to JS namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are 2 predefined kinds, which integrate directly with IDE - properties and events, but only events can be contributed globally.")
    private JsGlobal js;

    @JsonProperty(value="html")
    public Html getHtml() {
        return this.html;
    }

    @JsonProperty(value="html")
    public void setHtml(Html html) {
        this.html = html;
    }

    @JsonProperty(value="css")
    public Css getCss() {
        return this.css;
    }

    @JsonProperty(value="css")
    public void setCss(Css css) {
        this.css = css;
    }

    @JsonProperty(value="js")
    public JsGlobal getJs() {
        return this.js;
    }

    @JsonProperty(value="js")
    public void setJs(JsGlobal js) {
        this.js = js;
    }
}

