/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaTagsProcessor {
    public static final ThreadLocal<Boolean> PROCESSING_FLAG = new ThreadLocal();
    private final Set<XmlTag> myVisited = new HashSet<XmlTag>();
    protected final XmlNSDescriptorImpl myNsDescriptor;
    private final String[] myTagsToIgnore;

    public XmlSchemaTagsProcessor(XmlNSDescriptorImpl nsDescriptor, String ... tagsToIgnore) {
        this.myNsDescriptor = nsDescriptor;
        this.myTagsToIgnore = (String[])ArrayUtil.append((Object[])tagsToIgnore, (Object)"annotation");
    }

    public final void startProcessing(XmlTag tag) {
        try {
            PROCESSING_FLAG.set(Boolean.TRUE);
            this.processTag(tag, null);
        }
        finally {
            PROCESSING_FLAG.set(null);
        }
    }

    private void processTag(XmlTag tag, @Nullable XmlTag context) {
        if (this.myVisited.contains(tag)) {
            return;
        }
        this.myVisited.add(tag);
        if (!XmlNSDescriptorImpl.checkSchemaNamespace(tag)) {
            this.processTagWithSubTags(tag, context, null);
            return;
        }
        String tagName = tag.getLocalName();
        if (XmlSchemaTagsProcessor.checkTagName(tagName, "element", "attribute")) {
            XmlAttribute ref = tag.getAttribute("ref");
            if (ref != null) {
                XmlTag resolved = XmlSchemaTagsProcessor.resolveTagReference(ref);
                if (resolved != null) {
                    this.tagStarted(resolved, resolved.getLocalName(), tag, tag);
                }
            } else {
                this.tagStarted(tag, tag.getLocalName(), context, null);
            }
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "group")) {
            String value = tag.getAttributeValue("ref");
            if (value != null) {
                XmlTag group = this.myNsDescriptor.findGroup(value);
                if (group == null) {
                    group = XmlSchemaTagsProcessor.resolveTagReference(tag.getAttribute("ref"));
                }
                this.processTagWithSubTags(group, tag, tag);
            }
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "attributeGroup")) {
            XmlTag group;
            String ref = tag.getAttributeValue("ref");
            if (ref == null) {
                return;
            }
            XmlTag parentTag = tag.getParentTag();
            assert (parentTag != null);
            if (XmlNSDescriptorImpl.equalsToSchemaName(parentTag, "attributeGroup") && ref.equals(parentTag.getAttributeValue("name"))) {
                group = XmlSchemaTagsProcessor.resolveTagReference(tag.getAttribute("ref"));
                if (group == null) {
                    group = this.myNsDescriptor.findAttributeGroup(ref);
                }
            } else {
                group = this.myNsDescriptor.findAttributeGroup(ref);
                if (group == null) {
                    group = XmlSchemaTagsProcessor.resolveTagReference(tag.getAttribute("ref"));
                }
            }
            this.processTagWithSubTags(group, tag, null);
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "restriction", "extension")) {
            this.processTagWithSubTags(XmlSchemaTagsProcessor.resolveTagReference(tag.getAttribute("base")), tag, null);
            this.processTagWithSubTags(tag, context, null);
        } else if (!XmlSchemaTagsProcessor.checkTagName(tagName, this.myTagsToIgnore)) {
            this.processTagWithSubTags(tag, context, null);
        }
    }

    private void processTagWithSubTags(@Nullable XmlTag tag, XmlTag ctx, @Nullable XmlTag ref) {
        XmlTag[] subTags;
        if (tag == null) {
            return;
        }
        this.tagStarted(tag, tag.getLocalName(), ctx, ref);
        for (XmlTag subTag : subTags = tag.getSubTags()) {
            this.processTag(subTag, tag);
        }
        this.tagFinished(tag);
    }

    protected abstract void tagStarted(XmlTag var1, String var2, XmlTag var3, @Nullable XmlTag var4);

    protected void tagFinished(XmlTag tag) {
    }

    @Nullable
    public static XmlTag resolveTagReference(@Nullable XmlAttribute ref) {
        PsiElement element = XmlSchemaTagsProcessor.resolveReference(ref);
        return element instanceof XmlTag ? (XmlTag)element : null;
    }

    @Nullable
    static PsiElement resolveReference(@Nullable XmlAttribute ref) {
        PsiReference[] references;
        XmlAttributeValue value;
        if (ref != null && (value = ref.getValueElement()) != null && (references = value.getReferences()).length > 0) {
            return references[0].resolve();
        }
        return null;
    }

    protected static boolean checkTagName(String tagName, String ... names) {
        return ArrayUtil.contains((String)tagName, (String[])names);
    }
}

