Release v1.54.10 (2024-06-27)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/chime-sdk-media-pipelines`: Updates service API and documentation
* `service/cloudfront`: Updates service API and documentation
  * Doc only update for CloudFront that fixes customer-reported issue
* `service/datazone`: Updates service API, documentation, and paginators
* `service/elasticache`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/mq`: Updates service API and documentation
  * This release makes the EngineVersion field optional for both broker and configuration and uses the latest available version by default. The AutoMinorVersionUpgrade field is also now optional for broker creation and defaults to 'true'.
* `service/qconnect`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * Adding support for Repeating Sections, Nested Filters
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for TAZ export to S3.
* `service/sagemaker`: Updates service API and documentation
  * Add capability for Admins to customize Studio experience for the user by showing or hiding Apps and MLTools.
* `service/workspaces`: Updates service API and documentation
  * Added support for WorkSpaces Pools.

Release v1.54.9 (2024-06-26)
===

### Service Client Updates
* `service/controltower`: Updates service API, documentation, and paginators
* `service/eks`: Updates service API and documentation
* `service/ivs-realtime`: Updates service API, documentation, and paginators
* `service/kinesisanalyticsv2`: Updates service API, documentation, and paginators
* `service/opensearch`: Updates service API and documentation

Release v1.54.8 (2024-06-25)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Doc only update for Auto Scaling's TargetTrackingMetricDataQuery
* `service/ec2`: Updates service API
  * This release is for the launch of the new u7ib-12tb.224xlarge, R8g, c7gn.metal and mac2-m1ultra.metal instance types
* `service/networkmanager`: Updates service API and documentation
* `service/workspaces-thin-client`: Updates service API and documentation

Release v1.54.7 (2024-06-24)
===

### Service Client Updates
* `service/bedrock-runtime`: Updates service API
* `service/customer-profiles`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Fix EC2 multi-protocol info in models.
* `service/qbusiness`: Updates service API and documentation
* `service/ssm`: Updates service API
  * Add sensitive trait to SSM IPAddress property for CloudTrail redaction
* `service/workspaces-web`: Updates service API and documentation

Release v1.54.6 (2024-06-20)
===

### Service Client Updates
* `service/bedrock-runtime`: Updates service API and documentation
* `service/codeartifact`: Updates service API and documentation
* `service/compute-optimizer`: Updates service API and documentation
* `service/cost-optimization-hub`: Updates service API, documentation, and waiters
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Doc-only update for DynamoDB. Fixed Important note in 6 Global table APIs - CreateGlobalTable, DescribeGlobalTable, DescribeGlobalTableSettings, ListGlobalTables, UpdateGlobalTable, and UpdateGlobalTableSettings.
* `service/glue`: Updates service paginators
  * Fix Glue paginators for Jobs, JobRuns, Triggers, Blueprints and Workflows.
* `service/ivs-realtime`: Updates service API, documentation, and waiters
* `service/sagemaker`: Updates service API and documentation
  * Adds support for model references in Hub service, and adds support for cross-account access of Hubs
* `service/securityhub`: Updates service API and documentation

Release v1.54.5 (2024-06-19)
===

### Service Client Updates
* `service/artifact`: Updates service API, documentation, waiters, and examples
* `service/athena`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/cur`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/directconnect`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/elastictranscoder`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/opensearch`: Updates service API and documentation

Release v1.54.4 (2024-06-18)
===

### Service Client Updates
* `service/bedrock-runtime`: Updates service API and documentation
* `service/cloudtrail`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/config`: Updates service API
* `service/eks`: Updates service API and documentation
* `service/lightsail`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/polly`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/rekognition`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Launched a new feature in SageMaker to provide managed MLflow Tracking Servers for customers to track ML experiments. This release also adds a new capability of attaching additional storage to SageMaker HyperPod cluster instances.
* `service/shield`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/snowball`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.

Release v1.54.3 (2024-06-17)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/batch`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now supports global and organization GitHub webhooks
* `service/cognito-idp`: Updates service API
* `service/ds`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/elasticfilesystem`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/glue`: Updates service API, documentation, and paginators
  * This release introduces a new feature, Usage profiles. Usage profiles allow the AWS Glue admin to create different profiles for various classes of users within the account, enforcing limits and defaults for jobs and sessions.
* `service/kms`: Updates service examples
  * Updating SDK example for KMS DeriveSharedSecret API.
* `service/mediaconvert`: Updates service API and documentation
  * This release includes support for creating I-frame only video segments for DASH trick play.
* `service/secretsmanager`: Updates service documentation
  * Doc only update for Secrets Manager
* `service/waf`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.

Release v1.54.2 (2024-06-14)
===

### Service Client Updates
* `service/datazone`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/macie2`: Updates service API, documentation, and paginators
* `service/mediaconvert`: Updates service API, documentation, and paginators
  * This release adds the ability to search for historical job records within the management console using a search box and/or via the SDK/CLI with partial string matching search on input file name.
* `service/route53domains`: Updates service API
  * Add v2 smoke tests and smithy smokeTests trait for SDK testing.

### SDK Bugs
* Remove test dependency on golang.org/x/net.
  * This was used for h2 support which is now transparently available in the stdlib.

Release v1.54.1 (2024-06-13)
===

### Service Client Updates
* `service/cloudhsmv2`: Updates service API and documentation
  * Added support for hsm type hsm2m.medium. Added supported for creating a cluster in FIPS or NON_FIPS mode.
* `service/glue`: Updates service API and documentation
  * This release adds support for configuration of evaluation method for composite rules in Glue Data Quality rulesets.
* `service/iotwireless`: Updates service API
* `service/kms`: Updates service API, documentation, and examples
  * This feature allows customers to use their keys stored in KMS to derive a shared secret which can then be used to establish a secured channel for communication, provide proof of possession, or establish trust with other parties.
* `service/mediapackagev2`: Updates service API, documentation, and examples

Release v1.54.0 (2024-06-12)
===

### Service Client Updates
* `service/apptest`: Updates service API, documentation, waiters, paginators, and examples
* `service/ec2`: Updates service API and documentation
  * Tagging support for Traffic Mirroring FilterRule resource
* `service/osis`: Updates service API and documentation
* `service/redshift`: Updates service API and documentation
  * Updates to remove DC1 and DS2 node types.
* `service/secretsmanager`: Updates service API and documentation
  * Introducing RotationToken parameter for PutSecretValue API
* `service/securitylake`: Updates service API and documentation
* `service/sesv2`: Updates service API and documentation

### SDK Features
* `service/backupstorage`: Remove Backupstorage
  * This change removes the Backupstorage service, which has been deprecated.

Release v1.53.21 (2024-06-11)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API, documentation, paginators, and examples
* `service/guardduty`: Updates service API and documentation
  * Added API support for GuardDuty Malware Protection for S3.
* `service/networkmanager`: Updates service API and documentation
* `service/pca-connector-scep`: Adds new service
* `service/sagemaker`: Updates service API and documentation
  * Introduced Scope and AuthenticationRequestExtraParams to SageMaker Workforce OIDC configuration; this allows customers to modify these options for their private Workforce IdP integration. Model Registry Cross-account model package groups are discoverable.

Release v1.53.20 (2024-06-10)
===

### Service Client Updates
* `service/application-signals`: Adds new service
* `service/ecs`: Updates service API and documentation
  * This release introduces a new cluster configuration to support the customer-managed keys for ECS managed storage encryption.
* `service/imagebuilder`: Updates service API

Release v1.53.19 (2024-06-07)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/b2bi`: Updates service API
* `service/codepipeline`: Updates service API and documentation
  * CodePipeline now supports overriding S3 Source Object Key during StartPipelineExecution, as part of Source Overrides.
* `service/sagemaker`: Updates service API and documentation
  * This release introduces a new optional parameter: InferenceAmiVersion, in ProductionVariant.
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.53.18 (2024-06-06)
===

### Service Client Updates
* `service/account`: Updates service API and documentation
* `service/firehose`: Updates service API and documentation
  * Adds integration with Secrets Manager for Redshift, Splunk, HttpEndpoint, and Snowflake destinations
* `service/fsx`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * This release adds support for creating and updating Glue Data Catalog Views.
* `service/iotwireless`: Updates service API
* `service/location`: Updates service API, documentation, and paginators
* `service/sns`: Updates service API and documentation
  * Doc-only update for SNS. These changes include customer-reported issues and TXC3 updates.
* `service/sqs`: Updates service API and documentation
  * Doc only updates for SQS. These updates include customer-reported issues and TCX3 modifications.
* `service/storagegateway`: Updates service API and documentation
  * Adds SoftwareUpdatePreferences to DescribeMaintenanceStartTime and UpdateMaintenanceStartTime, a structure which contains AutomaticUpdatePolicy.

Release v1.53.17 (2024-06-05)
===

### Service Client Updates
* `service/globalaccelerator`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * AWS Glue now supports native SaaS connectivity: Salesforce connector available now
* `service/s3`: Updates service API and examples
  * Added new params copySource and key to copyObject API for supporting S3 Access Grants plugin. These changes will not change any of the existing S3 API functionality.

Release v1.53.16 (2024-06-04)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * U7i instances with up to 32 TiB of DDR5 memory and 896 vCPUs are now available. C7i-flex instances are launched and are lower-priced variants of the Amazon EC2 C7i instances that offer a baseline level of CPU performance with the ability to scale up to the full compute performance 95% of the time.
* `service/pipes`: Updates service API, documentation, and waiters
* `service/sagemaker`: Updates service API and documentation
  * Extend DescribeClusterNode response with private DNS hostname and IP address, and placement information about availability zone and availability zone ID.
* `service/taxsettings`: Adds new service

Release v1.53.15 (2024-06-03)
===

### Service Client Updates
* `service/amplify`: Updates service documentation
* `service/batch`: Updates service API and documentation
  * This release adds support for the AWS Batch GetJobQueueSnapshot API operation.
* `service/eks`: Updates service API and documentation
* `service/iottwinmaker`: Updates service API

Release v1.53.14 (2024-05-31)
===

### Service Client Updates
* `service/codebuild`: Updates service documentation
  * AWS CodeBuild now supports Self-hosted GitHub Actions runners for Github Enterprise
* `service/codeguru-security`: Updates service API and documentation
* `service/elasticache`: Updates service API and documentation
  * Update to attributes of TestFailover and minor revisions.
* `service/launch-wizard`: Updates service API and documentation

Release v1.53.13 (2024-05-30)
===

### Service Client Updates
* `service/acm`: Updates service API
  * add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `service/bedrock-agent`: Updates service API and documentation
* `service/bedrock-runtime`: Updates service API and documentation
* `service/cloudtrail`: Updates service API and documentation
  * CloudTrail Lake returns PartitionKeys in the GetEventDataStore API response. Events are grouped into partitions based on these keys for better query performance. For example, the calendarday key groups events by day, while combining the calendarday key with the hour key groups them by day and hour.
* `service/connect`: Updates service API and documentation
* `service/emr-serverless`: Updates service API, documentation, and paginators
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for Aurora Postgres DBname.
* `service/sagemaker`: Updates service API and documentation
  * Adds Model Card information as a new component to Model Package. Autopilot launches algorithm selection for TimeSeries modality to generate AutoML candidates per algorithm.

Release v1.53.12 (2024-05-29)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Throwing validation errors on CreateNotebook with Name containing `/`,`:`,`\`
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now supports manually creating GitHub webhooks
* `service/connect`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Add optional field JobMode to CreateJob and UpdateJob APIs.
* `service/securityhub`: Updates service API

Release v1.53.11 (2024-05-28)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Doc-only update for DynamoDB. Specified the IAM actions needed to authorize a user to create a table with a resource-based policy.
* `service/ec2`: Updates service API and documentation
  * Providing support to accept BgpAsnExtended attribute
* `service/kafka`: Updates service API and documentation
* `service/swf`: Updates service API and documentation
  * This release adds new APIs for deleting activity type and workflow type resources.

Release v1.53.10 (2024-05-24)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation only updates for DynamoDB.
* `service/iotfleetwise`: Updates service API and documentation
* `service/managedblockchain`: Updates service API and documentation

### SDK Bugs
* Fix misaligned struct member used in atomic operation.
  * This change fixes panics on 32-bit systems in services that use endpoint discovery.

Release v1.53.9 (2024-05-23)
===

### Service Client Updates
* `service/emr-serverless`: Updates service API and documentation
* `service/opsworks`: Updates service API and documentation
  * Documentation-only update for OpsWorks Stacks.

Release v1.53.8 (2024-05-22)
===

### Service Client Updates
* `service/chatbot`: Updates service API and documentation
* `service/cloudformation`: Updates service API and documentation
  * Added DeletionMode FORCE_DELETE_STACK for deleting a stack that is stuck in DELETE_FAILED state due to resource deletion failure.
* `service/kms`: Updates service API and documentation
  * This release includes feature to import customer's asymmetric (RSA, ECC and SM2) and HMAC keys into KMS in China.
* `service/opensearch`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

### SDK Bugs
* `service/ec2`: Correct empty list serialization behavior.
  * Empty, non-nil lists should NOT be serialized for this service.

Release v1.53.7 (2024-05-21)
===

### Service Client Updates
* `service/cloudfront`: Updates service API
  * Model update; no change to SDK functionality.
* `service/glue`: Updates service API and documentation
  * Add Maintenance window to CreateJob and UpdateJob APIs and JobRun response. Add a new Job Run State for EXPIRED.
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Amazon Lightsail instances to switch between dual-stack or IPv4 only and IPv6-only public IP address types.
* `service/mailmanager`: Adds new service
* `service/pi`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for Db2 license through AWS Marketplace.
* `service/storagegateway`: Updates service API and documentation
  * Added new SMBSecurityStrategy enum named MandatoryEncryptionNoAes128, new mode enforces encryption and disables AES 128-bit algorithums.

Release v1.53.6 (2024-05-20)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API and documentation
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/controltower`: Updates service API, documentation, and paginators
* `service/osis`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for EngineLifecycleSupport on DBInstances, DBClusters, and GlobalClusters.
* `service/secretsmanager`: Updates service documentation
  * add v2 smoke tests and smithy smokeTests trait for SDK testing

Release v1.53.5 (2024-05-17)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API
* `service/codebuild`: Updates service API and documentation
  * Aws CodeBuild now supports 36 hours build timeout
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Enable use of CloudFormation traits in Smithy model to improve generated CloudFormation schema from the Smithy API model.

Release v1.53.4 (2024-05-16)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and waiters
* `service/connect`: Updates service documentation
* `service/kafka`: Updates service API and documentation
* `service/mwaa`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * This release adds DescribeKeyRegistration and UpdateKeyRegistration APIs to manage QuickSight Customer Managed Keys (CMK).
* `service/sagemaker`: Updates service API and documentation
  * Introduced WorkerAccessConfiguration to SageMaker Workteam. This allows customers to configure resource access for workers in a workteam.
* `service/secretsmanager`: Updates service API and documentation
  * Documentation updates for AWS Secrets Manager

Release v1.53.3 (2024-05-15)
===

### Service Client Updates
* `service/bedrock-agent-runtime`: Updates service documentation
* `service/codebuild`: Updates service API and documentation
  * CodeBuild Reserved Capacity VPC Support
* `service/datasync`: Updates service API
* `service/grafana`: Updates service API, documentation, and paginators
* `service/medical-imaging`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.53.2 (2024-05-14)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/s3`: Updates service API and examples
  * Updated a few x-id in the http uri traits

Release v1.53.1 (2024-05-13)
===

### Service Client Updates
* `service/eventbridge`: Updates service API and documentation
* `service/vpc-lattice`: Updates service API and documentation

Release v1.53.0 (2024-05-10)
===

### Service Client Updates
* `service/discovery`: Updates service API
  * add v2 smoke tests and smithy smokeTests trait for SDK testing
* `service/greengrassv2`: Updates service API and documentation
* `service/sagemaker`: Updates service API
  * Introduced support for G6 instance types on Sagemaker Notebook Instances and on SageMaker Studio for JupyterLab and CodeEditor applications.
* `service/sso-oidc`: Updates service API, documentation, and examples

### SDK Features
* `service/honeycode`: Remove Honeycode
  * This change removes the Honeycode service, which has been deprecated.

Release v1.52.6 (2024-05-09)
===

### Service Client Updates
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This release adds support for specifying email message headers for Email Templates, Campaigns, Journeys and Send Messages.
* `service/route53resolver`: Updates service documentation
* `service/ssm-sap`: Updates service API, documentation, and paginators
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.52.5 (2024-05-08)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API
* `service/ec2`: Updates service API and documentation
  * Adding Precision Hardware Clock (PHC) to public API DescribeInstanceTypes
* `service/ecr`: Updates service API and documentation
  * This release adds pull through cache rules support for GitLab container registry in Amazon ECR.
* `service/fms`: Updates service documentation
* `service/polly`: Updates service API and documentation
  * Add new engine - generative - that builds the most expressive conversational voices.
* `service/sqs`: Updates service API and documentation
  * This release adds MessageSystemAttributeNames to ReceiveMessageRequest to replace AttributeNames.

Release v1.52.4 (2024-05-07)
===

### Service Client Updates
* `service/b2bi`: Updates service documentation
* `service/budgets`: Updates service API and documentation
  * This release adds tag support for budgets and budget actions.
* `service/resiliencehub`: Updates service API, documentation, and paginators
* `service/route53profiles`: Updates service API and documentation

Release v1.52.3 (2024-05-06)
===

### Service Client Updates
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports configuring how SCTE 35 passthrough triggers segment breaks in HLS and MediaPackage output groups. Previously, messages triggered breaks in all these output groups. The new option is to trigger segment breaks only in groups that have SCTE 35 passthrough enabled.

Release v1.52.2 (2024-05-03)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/connectcases`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/inspector2`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Inference now supports m6i, c6i, r6i, m7i, c7i, r7i and g5 instance types for Batch Transform Jobs
* `service/sesv2`: Updates service API and documentation

Release v1.52.1 (2024-05-02)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support to specify an optional, maximum OnDemandThroughput for DynamoDB tables and global secondary indexes in the CreateTable or UpdateTable APIs. You can also override the OnDemandThroughput settings by calling the ImportTable, RestoreFromPointInTime, or RestoreFromBackup APIs.
* `service/ec2`: Updates service API and documentation
  * This release includes a new API for retrieving the public endorsement key of the EC2 instance's Nitro Trusted Platform Module (NitroTPM).
* `service/personalize`: Updates service API and documentation
* `service/redshift-serverless`: Updates service API and documentation

Release v1.52.0 (2024-05-01)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API and documentation
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/personalize-runtime`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation
* `service/sesv2`: Updates service API

### SDK Features
* `service/alexaforbusiness`: Remove Alexaforbusiness
  * This change removes the Alexaforbusiness service, since it is deprecated.

Release v1.51.32 (2024-04-30)
===

### Service Client Updates
* `service/chime-sdk-voice`: Updates service API and documentation
* `service/codeartifact`: Updates service API and documentation
* `service/fms`: Updates service API and documentation
* `service/omics`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/pinpoint-sms-voice-v2`: Updates service API, documentation, and paginators
* `service/qbusiness`: Updates service API, documentation, and waiters
* `service/quicksight`: Updates service API and documentation
  * New Q embedding supporting Generative Q&A
* `service/route53resolver`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Training now supports the use of attribute-based access control (ABAC) roles for training job execution roles. Amazon SageMaker Inference now supports G6 instance types.
* `service/signer`: Updates service API and documentation
  * Documentation updates for AWS Signer. Adds cross-account signing constraint and definitions for cross-account actions.

Release v1.51.31 (2024-04-29)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/connectcases`: Updates service API and documentation
* `service/inspector2`: Updates service API and documentation
* `service/timestream-query`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation
* `service/trustedadvisor`: Updates service API and documentation

Release v1.51.30 (2024-04-26)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Add ability to manually and automatically roll back a pipeline stage to a previously successful execution.
* `service/cognito-idp`: Updates service API and documentation
* `service/connectcampaigns`: Updates service API and documentation
* `service/entitlement.marketplace`: Updates service API
* `service/oam`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * SupportsLimitlessDatabase field added to describe-db-engine-versions to indicate whether the DB engine version supports Aurora Limitless Database.
* `service/support`: Updates service API
  * Releasing minor endpoint updates.

Release v1.51.29 (2024-04-25)
===

### Service Client Updates
* `service/appsync`: Updates service API
* `service/fms`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/ivs-realtime`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for setting local time zones for RDS for Db2 DB instances.
* `service/states`: Updates service API and documentation
  * Add new ValidateStateMachineDefinition operation, which performs syntax checking on the definition of a Amazon States Language (ASL) state machine.

Release v1.51.28 (2024-04-24)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Launching capability for customers to enable or disable automatic assignment of public IPv4 addresses to their network interface
* `service/emr-containers`: Updates service API, documentation, and paginators
* `service/entityresolution`: Updates service API and documentation
* `service/gamelift`: Updates service API, documentation, and paginators
  * Amazon GameLift releases container fleets support for public preview. Deploy Linux-based containerized game server software for hosting on Amazon GameLift.
* `service/ssm`: Updates service API, documentation, and paginators
  * Add SSM DescribeInstanceProperties API to public AWS SDK.

Release v1.51.27 (2024-04-23)
===

### Service Client Updates
* `service/bedrock`: Updates service API, documentation, and paginators
* `service/bedrock-agent`: Updates service API and documentation
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/bedrock-runtime`: Updates service API and documentation
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release introduces EC2 AMI Deregistration Protection, a new AMI property that can be enabled by customers to protect an AMI against an unintended deregistration. This release also enables the AMI owners to view the AMI 'LastLaunchedTime' in DescribeImages API.
* `service/pi`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Fix the example ARN for ModifyActivityStreamRequest
* `service/workspaces-web`: Updates service API and documentation

Release v1.51.26 (2024-04-22)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API and documentation
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/payment-cryptography`: Updates service API, documentation, and waiters
* `service/redshift-serverless`: Updates service documentation
* `service/route53profiles`: Adds new service
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for Real-Time Collaboration and Shared Space for JupyterLab App on SageMaker Studio.
* `service/servicediscovery`: Updates service documentation and examples
* `service/transfer`: Updates service API and documentation
  * Adding new API to support remote directory listing using SFTP connector

Release v1.51.25 (2024-04-19)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Adding RowFilter in the response for GetUnfilteredTableMetadata API
* `service/internetmonitor`: Updates service API, documentation, and paginators
* `service/personalize`: Updates service API and documentation

Release v1.51.24 (2024-04-18)
===

### Service Client Updates
* `service/drs`: Updates service API and documentation
* `service/emr-serverless`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Added IPv6Address fields for local and remote IP addresses
* `service/quicksight`: Updates service API and documentation
  * This release adds support for the Cross Sheet Filter and Control features, and support for warnings in asset imports for any permitted errors encountered during execution
* `service/rolesanywhere`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Removed deprecated enum values and updated API documentation.
* `service/workspaces`: Updates service API, documentation, and paginators
  * Adds new APIs for managing and sharing WorkSpaces BYOL configuration across accounts.

Release v1.51.23 (2024-04-17)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation updates for Elastic Compute Cloud (EC2).
* `service/qbusiness`: Updates service API and documentation

Release v1.51.22 (2024-04-16)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API and documentation
* `service/emr-serverless`: Updates service API and documentation
* `service/entityresolution`: Updates service API, documentation, and paginators
* `service/iotwireless`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation
* `service/m2`: Updates service API and documentation
* `service/mediapackagev2`: Updates service API and documentation
* `service/outposts`: Updates service API, documentation, and paginators
* `service/wellarchitected`: Updates service API and documentation

Release v1.51.21 (2024-04-12)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Adding support for the new parameter "IncludePropertyValues" in the CloudFormation DescribeChangeSet API. When this parameter is included, the DescribeChangeSet response will include more detailed information such as before and after values for the resource properties that will change.
* `service/config`: Updates service documentation
* `service/glue`: Updates service API and documentation
  * Modifying request for GetUnfilteredTableMetadata for view-related fields.
* `service/healthlake`: Updates service API and documentation
* `service/iotfleethub`: Updates service documentation
* `service/kms`: Updates service API, documentation, paginators, and examples
  * This feature supports the ability to specify a custom rotation period for automatic key rotations, the ability to perform on-demand key rotations, and visibility into your key material rotations.
* `service/mediatailor`: Updates service API and documentation
* `service/outposts`: Updates service API
* `service/redshift`: Updates service API and documentation
  * Adds support for Amazon Redshift DescribeClusterSnapshots API to include Snapshot ARN response field.
* `service/transfer`: Updates service API and documentation
  * This change releases support for importing self signed certificates to the Transfer Family for sending outbound file transfers over TLS/HTTPS.

Release v1.51.20 (2024-04-11)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This release adds the task properties field to attempt details and the name field on EKS container detail.
* `service/cloudfront`: Updates service API and documentation
  * CloudFront origin access control extends support to AWS Lambda function URLs and AWS Elemental MediaPackage v2 origins.
* `service/codebuild`: Updates service documentation
  * Support access tokens for Bitbucket sources
* `service/iam`: Updates service API and documentation
  * For CreateOpenIDConnectProvider API, the ThumbprintList parameter is no longer required.
* `service/medialive`: Updates service API, documentation, waiters, and paginators
  * AWS Elemental MediaLive introduces workflow monitor, a new feature that enables the visualization and monitoring of your media workflows. Create signal maps of your existing workflows and monitor them by creating notification and monitoring template groups.
* `service/monitoring`: Updates service API and documentation
  * This release adds support for Metric Characteristics for CloudWatch Anomaly Detection. Anomaly Detector now takes Metric Characteristics object with Periodic Spikes boolean field that tells Anomaly Detection that spikes that repeat at the same time every week are part of the expected pattern.
* `service/omics`: Updates service API and documentation
* `service/pipes`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for Standard Edition 2 support in RDS Custom for Oracle.
* `service/s3control`: Updates service documentation
  * Documentation updates for Amazon S3-control.
* `service/wafv2`: Adds new service

Release v1.51.19 (2024-04-10)
===

### Service Client Updates
* `service/cleanrooms`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/networkmonitor`: Updates service documentation
* `service/qconnect`: Updates service API and documentation
* `service/rekognition`: Updates service API and documentation
  * Added support for ContentType to content moderation detections.
* `service/supplychain`: Updates service API, documentation, and examples
* `service/workspaces-thin-client`: Updates service API and documentation

Release v1.51.18 (2024-04-09)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Add new webhook filter types for GitHub webhooks
* `service/mediaconvert`: Updates service API and documentation
  * This release includes support for bringing your own fonts to use for burn-in or DVB-Sub captioning workflows.
* `service/pinpoint`: Updates service API and documentation
  * The OrchestrationSendingRoleArn has been added to the email channel and is used to send emails from campaigns or journeys.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for specifying the CA certificate to use for the new db instance when restoring from db snapshot, restoring from s3, restoring to point in time, and creating a db instance read replica.

Release v1.51.17 (2024-04-08)
===

### Service Client Updates
* `service/controlcatalog`: Adds new service
* `service/mgn`: Updates service API and documentation
* `service/networkmonitor`: Updates service API and documentation

Release v1.51.16 (2024-04-05)
===

### Service Client Updates
* `service/quicksight`: Updates service API and documentation
  * Adding IAMIdentityCenterInstanceArn parameter to CreateAccountSubscription
* `service/resource-groups`: Updates service API and documentation
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.51.15 (2024-04-04)
===

### Service Client Updates
* `service/b2bi`: Updates service API
* `service/cleanrooms`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Amazon EC2 G6 instances powered by NVIDIA L4 Tensor Core GPUs can be used for a wide range of graphics-intensive and machine learning use cases. Gr6 instances also feature NVIDIA L4 GPUs and can be used for graphics workloads with higher memory requirements.
* `service/emr-containers`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.51.14 (2024-04-03)
===

### Service Client Updates
* `service/cleanroomsml`: Updates service API and documentation
* `service/cloudformation`: Updates service API and documentation
  * This release would return a new field - PolicyAction in cloudformation's existed DescribeChangeSetResponse, showing actions we are going to apply on the physical resource (e.g., Delete, Retain) according to the user's template
* `service/datazone`: Updates service API, documentation, and paginators
* `service/docdb`: Updates service API and documentation
  * This release adds Global Cluster Switchover capability which enables you to change your global cluster's primary AWS Region, the region that serves writes, while preserving the replication between all regions in the global cluster.
* `service/groundstation`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Add Ruby 3.3 (ruby3.3) support to AWS Lambda
* `service/medialive`: Updates service API and documentation
  * Cmaf Ingest outputs are now supported in Media Live
* `service/medical-imaging`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Add ability to specify Security Policies for SFTP Connectors

Release v1.51.13 (2024-04-02)
===

### Service Client Updates
* `service/ecs`: Updates service documentation
  * Documentation only update for Amazon ECS.
* `service/glue`: Updates service API and documentation
  * Adding View related fields to responses of read-only Table APIs.
* `service/ivschat`: Updates service documentation
* `service/rolesanywhere`: Updates service API and documentation
* `service/securityhub`: Updates service documentation

Release v1.51.12 (2024-04-01)
===

### Service Client Updates
* `service/datazone`: Updates service API, documentation, and paginators
* `service/deadline`: Updates service API, documentation, waiters, paginators, and examples
* `service/elasticmapreduce`: Updates service documentation
  * This release fixes a broken link in the documentation.
* `service/lightsail`: Updates service API and documentation
  * This release adds support to upgrade the TLS version of the distribution.
* `service/monitoring`: Updates service API and documentation
  * This release adds support for CloudWatch Anomaly Detection on cross-account metrics. SingleMetricAnomalyDetector and MetricDataQuery inputs to Anomaly Detection APIs now take an optional AccountId field.

Release v1.51.11 (2024-03-29)
===

### Service Client Updates
* `service/b2bi`: Updates service API and documentation
* `service/codebuild`: Updates service API
  * Add new fleet status code for Reserved Capacity.
* `service/codeconnections`: Adds new service
* `service/internetmonitor`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for custom images for the CodeEditor App on SageMaker Studio

Release v1.51.10 (2024-03-28)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Amazon EC2 C7gd, M7gd and R7gd metal instances with up to 3.8 TB of local NVMe-based SSD block-level storage have up to 45% improved real-time NVMe storage performance than comparable Graviton2-based instances.
* `service/eks`: Updates service API
* `service/guardduty`: Updates service API and documentation
  * Add EC2 support for GuardDuty Runtime Monitoring auto management.
* `service/oam`: Updates service API
* `service/quicksight`: Updates service API and documentation
  * Amazon QuickSight: Adds support for setting up VPC Endpoint restrictions for accessing QuickSight Website.

Release v1.51.9 (2024-03-27)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This feature allows AWS Batch to support configuration of imagePullSecrets and allowPrivilegeEscalation for jobs running on EKS
* `service/bedrock-agent`: Updates service API and documentation
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/elasticache`: Updates service API and documentation
  * Added minimum capacity to  Amazon ElastiCache Serverless. This feature allows customer to ensure minimum capacity even without current load
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager

Release v1.51.8 (2024-03-26)
===

### Service Client Updates
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/ce`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * Documentation updates for Elastic Compute Cloud (EC2).
* `service/ecs`: Updates service documentation
  * This is a documentation update for Amazon ECS.
* `service/finspace`: Updates service API and documentation

Release v1.51.7 (2024-03-25)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Supporting GitLab and GitLab Self Managed as source types in AWS CodeBuild.
* `service/ec2`: Updates service API and documentation
  * Added support for ModifyInstanceMetadataDefaults and GetInstanceMetadataDefaults to set Instance Metadata Service account defaults
* `service/ecs`: Updates service documentation
  * Documentation only update for Amazon ECS.
* `service/emr-containers`: Updates service API
* `service/globalaccelerator`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * Exposing TileMedia H265 options
* `service/sagemaker`: Updates service API
  * Introduced support for the following new instance types on SageMaker Studio for JupyterLab and CodeEditor applications: m6i, m6id, m7i, c6i, c6id, c7i, r6i, r6id, r7i, and p5

Release v1.51.6 (2024-03-22)
===

### Service Client Updates
* `service/firehose`: Updates service documentation
  * Updates Amazon Firehose documentation for message regarding Enforcing Tags IAM Policy.
* `service/kendra`: Updates service documentation
  * Documentation update, March 2024. Corrects some docs for Amazon Kendra.
* `service/pricing`: Updates service API and documentation
* `service/rolesanywhere`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.51.5 (2024-03-21)
===

### Service Client Updates
* `service/codeartifact`: Updates service API, documentation, and paginators

Release v1.51.4 (2024-03-20)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/codebuild`: Updates service documentation
  * This release adds support for new webhook events (RELEASED and PRERELEASED) and filter types (TAG_NAME and RELEASE_NAME).
* `service/connect`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * This release introduces 3 new APIs ('GetResourcePolicy', 'PutResourcePolicy' and 'DeleteResourcePolicy') and modifies the existing 'CreateTable' API for the resource-based policy support. It also modifies several APIs to accept a 'TableArn' for the 'TableName' parameter.
* `service/managedblockchain-query`: Updates service API and documentation
* `service/savingsplans`: Updates service API and documentation

Release v1.51.3 (2024-03-19)
===

### Service Client Updates
* `service/cloudformation`: Updates service documentation
  * Documentation update, March 2024. Corrects some formatting.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds the new DescribeMacHosts API operation for getting information about EC2 Mac Dedicated Hosts. Users can now see the latest macOS versions that their underlying Apple Mac can support without needing to be updated.
* `service/finspace`: Updates service API and documentation
* `service/logs`: Updates service API and documentation
  * Update LogSamples field in Anomaly model to be a list of LogEvent
* `service/managedblockchain-query`: Updates service API, documentation, and paginators

Release v1.51.2 (2024-03-18)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * This release supports for a new API ListStackSetAutoDeploymentTargets, which provider auto-deployment configuration as a describable resource. Customers can now view the specific combinations of regions and OUs that are being auto-deployed.
* `service/kms`: Updates service API and documentation
  * Adds the ability to use the default policy name by omitting the policyName parameter in calls to PutKeyPolicy and GetKeyPolicy
* `service/mediatailor`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release launches the ModifyIntegration API and support for data filtering for zero-ETL Integrations.
* `service/s3`: Updates service API and examples
  * Fix two issues with response root node names.
* `service/timestream-query`: Updates service documentation

Release v1.51.1 (2024-03-15)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now supports overflow behavior on Reserved Capacity.
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Add media accelerator and neuron device information on the describe instance types API.
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3.
* `service/sagemaker`: Updates service API and documentation
  * Adds m6i, m6id, m7i, c6i, c6id, c7i, r6i r6id, r7i, p5 instance type support to Sagemaker Notebook Instances and miscellaneous wording fixes for previous Sagemaker documentation.
* `service/workspaces-thin-client`: Updates service API and documentation

Release v1.51.0 (2024-03-14)
===

### Service Client Updates
* `service/amplify`: Updates service documentation
* `service/ec2-instance-connect`: Updates service API and documentation
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/fis`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for EBCDIC collation for RDS for Db2.
* `service/secretsmanager`: Updates service documentation
  * Doc only update for Secrets Manager
* `service/timestream-influxdb`: Adds new service

### SDK Features
* `service/iotroborunner`: Remove Iotroborunner
  * This change removes the iotroborunner service, since it is deprecated.

Release v1.50.38 (2024-03-13)
===

### Service Client Updates
* `service/ivs-realtime`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/s3`: Updates service examples
  * This release makes the default option for S3 on Outposts request signing to use the SigV4A algorithm when using AWS Common Runtime (CRT).

Release v1.50.37 (2024-03-12)
===

### Service Client Updates
* `service/cloudformation`: Updates service documentation
  * CloudFormation documentation update for March, 2024
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/kafka`: Updates service API and documentation
* `service/ssm`: Updates service documentation
  * March 2024 doc-only updates for Systems Manager.

Release v1.50.36 (2024-03-11)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Revisions to API text that are now to be carried over to SDK text, changing usages of "SFO" in code examples to "us-west-1", and some other typos.
* `service/mediapackagev2`: Updates service API and documentation

Release v1.50.35 (2024-03-08)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This release adds JobStateTimeLimitActions setting to the Job Queue API. It allows you to configure an action Batch can take for a blocking job in front of the queue after the defined period of time. The new parameter applies for ECS, EKS, and FARGATE Job Queues.
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/cloudtrail`: Updates service API and documentation
  * Added exceptions to CreateTrail, DescribeTrails, and ListImportFailures APIs.
* `service/codebuild`: Updates service documentation
  * This release adds support for a new webhook event: PULL_REQUEST_CLOSED.
* `service/cognito-idp`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Add RDS Provisioned and Serverless Usage types
* `service/transfer`: Updates service API and documentation
  * Added DES_EDE3_CBC to the list of supported encryption algorithms for messages sent with an AS2 connector.

Release v1.50.34 (2024-03-07)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds an optional parameter to RegisterImage and CopyImage APIs to support tagging AMIs at the time of creation.
* `service/grafana`: Updates service API and documentation
* `service/lambda`: Updates service documentation
  * Documentation updates for AWS Lambda
* `service/payment-cryptography-data`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for io2 storage for Multi-AZ DB clusters
* `service/snowball`: Updates service documentation
  * Doc-only update for change to EKS-Anywhere ordering.
* `service/wafv2`: Updates service API and documentation
* `service/workspaces`: Updates service documentation
  * Added note for user decoupling

Release v1.50.33 (2024-03-06)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Doc only updates for DynamoDB documentation
* `service/imagebuilder`: Updates service API and documentation
* `service/mwaa`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updated the input of CreateDBCluster and ModifyDBCluster to support setting CA certificates. Updated the output of DescribeDBCluster to show current CA certificate setting value.
* `service/redshift`: Updates service documentation
  * Update for documentation only. Covers port ranges, definition updates for data sharing, and definition updates to cluster-snapshot documentation.
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.50.32 (2024-03-05)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/chatbot`: Updates service API
* `service/organizations`: Adds new service
  * This release contains an endpoint addition
* `service/sesv2`: Updates service API and documentation

Release v1.50.31 (2024-03-04)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Add DetailedStatus field to DescribeStackEvents and DescribeStacks APIs
* `service/fsx`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * Documentation update for AWS Organizations

Release v1.50.30 (2024-03-01)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service documentation
* `service/autoscaling`: Updates service documentation
  * With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.
* `service/ec2`: Updates service documentation
  * With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.

Release v1.50.29 (2024-02-29)
===

### Service Client Updates
* `service/docdb-elastic`: Updates service API and documentation
* `service/eks`: Updates service API
* `service/migrationhuborchestrator`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * TooltipTarget for Combo chart visuals; ColumnConfiguration limit increase to 2000; Documentation Update
* `service/sagemaker`: Updates service API and documentation
  * Adds support for ModelDataSource in Model Packages to support unzipped models. Adds support to specify SourceUri for models which allows registration of models without mandating a container for hosting. Using SourceUri, customers can decouple the model from hosting information during registration.
* `service/securitylake`: Updates service API and documentation

Release v1.50.28 (2024-02-28)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This release adds Batch support for configuration of multicontainer jobs in ECS, Fargate, and EKS. This support is available for all types of jobs, including both array jobs and multi-node parallel jobs.
* `service/bedrock-agent-runtime`: Updates service API and documentation
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release increases the range of MaxResults for GetNetworkInsightsAccessScopeAnalysisFindings to 1,000.
* `service/iot`: Updates service API and documentation
  * This release reduces the maximum results returned per query invocation from 500 to 100 for the SearchIndex API. This change has no implications as long as the API is invoked until the nextToken is NULL.
* `service/wafv2`: Updates service API and documentation

Release v1.50.27 (2024-02-27)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API and documentation

Release v1.50.26 (2024-02-26)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway.
* `service/drs`: Updates service API and documentation
* `service/kafkaconnect`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for gp3 data volumes for Multi-AZ DB Clusters.

Release v1.50.25 (2024-02-23)
===

### Service Client Updates
* `service/appsync`: Updates service documentation
* `service/qldb`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Add pattern and length based validations for DBShardGroupIdentifier
* `service/rum`: Updates service documentation

Release v1.50.24 (2024-02-22)
===

### Service Client Updates
* `service/internetmonitor`: Updates service API and documentation
* `service/kinesisvideo`: Updates service API
  * Increasing NextToken parameter length restriction for List APIs from 512 to 1024.

Release v1.50.23 (2024-02-21)
===

### Service Client Updates
* `service/iotevents`: Updates service API
* `service/lookoutequipment`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * MediaLive now supports the ability to restart pipelines in a running channel.
* `service/ssm`: Updates service API and documentation
  * This release adds support for sharing Systems Manager parameters with other AWS accounts.

Release v1.50.22 (2024-02-20)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Publishing quick fix for doc only update.
* `service/firehose`: Updates service API and documentation
  * This release updates a few Firehose related APIs.
* `service/lambda`: Updates service API and documentation
  * Add .NET 8 (dotnet8) Runtime support to AWS Lambda.

Release v1.50.21 (2024-02-19)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/chatbot`: Updates service API, documentation, paginators, and examples
* `service/config`: Updates service documentation
* `service/ivs`: Updates service documentation
* `service/keyspaces`: Updates service documentation
* `service/mediatailor`: Updates service API

Release v1.50.20 (2024-02-16)
===

### Service Client Updates
* `service/connectparticipant`: Updates service documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * adds fine grained control over Unhealthy Node Replacement to Amazon ElasticMapReduce
* `service/firehose`: Updates service API and documentation
  * This release adds support for Data Message Extraction for decompressed CloudWatch logs, and to use a custom file extension or time zone for S3 destinations.
* `service/lambda`: Updates service documentation
  * Documentation-only updates for Lambda to clarify a number of existing actions and properties.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Doc only update for a valid option in DB parameter group
* `service/sns`: Updates service API and documentation
  * This release marks phone numbers as sensitive inputs.

Release v1.50.19 (2024-02-15)
===

### Service Client Updates
* `service/artifact`: Updates service API, documentation, paginators, and examples
* `service/codepipeline`: Updates service API and documentation
  * Add ability to override timeout on action level.
* `service/detective`: Updates service documentation
* `service/guardduty`: Updates service API and documentation
  * Marked fields IpAddressV4, PrivateIpAddress, Email as Sensitive.
* `service/healthlake`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds 1 new voice - Burcu (tr-TR)
* `service/sagemaker`: Updates service API and documentation
  * This release adds a new API UpdateClusterSoftware for SageMaker HyperPod. This API allows users to patch HyperPod clusters with latest platform softwares.
* `service/secretsmanager`: Updates service documentation
  * Doc only update for Secrets Manager

Release v1.50.18 (2024-02-14)
===

### Service Client Updates
* `service/controltower`: Updates service API, documentation, and paginators
* `service/lookoutequipment`: Updates service API and documentation
* `service/qbusiness`: Updates service API and documentation

Release v1.50.17 (2024-02-13)
===

### Service Client Updates
* `service/lightsail`: Updates service API and documentation
  * This release adds support to upgrade the major version of a database.
* `service/marketplace-catalog`: Updates service API and documentation
* `service/resource-explorer-2`: Adds new service
* `service/securitylake`: Updates service documentation

Release v1.50.16 (2024-02-12)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/monitoring`: Updates service API
  * This release enables PutMetricData API request payload compression by default.
* `service/route53domains`: Updates service API and documentation
  * This release adds bill contact support for RegisterDomain, TransferDomain, UpdateDomainContact and GetDomainDetail API.

Release v1.50.15 (2024-02-09)
===

### Service Client Updates
* `service/amp`: Updates service API and documentation
* `service/batch`: Updates service API and documentation
  * This feature allows Batch to support configuration of repository credentials for jobs running on ECS
* `service/braket`: Updates service API
* `service/cost-optimization-hub`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * Documentation only update for Amazon ECS.
* `service/iot`: Updates service API and documentation
  * This release allows AWS IoT Core users to enable Online Certificate Status Protocol (OCSP) Stapling for TLS X.509 Server Certificates when creating and updating AWS IoT Domain Configurations with Custom Domain.
* `service/pricing`: Updates service API and documentation

Release v1.50.14 (2024-02-08)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Add ability to execute pipelines with new parallel & queued execution modes and add support for triggers with filtering on branches and file paths.
* `service/quicksight`: Updates service API and documentation
  * General Interactions for Visuals; Waterfall Chart Color Configuration; Documentation Update
* `service/workspaces`: Updates service API and documentation
  * This release introduces User-Decoupling feature. This feature allows Workspaces Core customers to provision workspaces without providing users. CreateWorkspaces and DescribeWorkspaces APIs will now take a new optional parameter "WorkspaceName".

Release v1.50.13 (2024-02-07)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/redshift`: Updates service API, documentation, and paginators
  * LisRecommendations API to fetch Amazon Redshift Advisor recommendations.

Release v1.50.12 (2024-02-06)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * This release is a documentation only update to address customer issues.
* `service/es`: Updates service API and documentation
  * This release adds clear visibility to the customers on the changes that they make on the domain.
* `service/logs`: Updates service API and documentation
  * This release adds a new field, logGroupArn, to the response of the logs:DescribeLogGroups action.
* `service/opensearch`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.50.11 (2024-02-05)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Introduce Catalog Encryption Role within Glue Data Catalog Settings. Introduce SASL/PLAIN as an authentication method for Glue Kafka connections
* `service/workspaces`: Updates service documentation
  * Added definitions of various WorkSpace states

Release v1.50.10 (2024-02-02)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Canvas adds GenerativeAiSettings support for CanvasAppSettings.

Release v1.50.9 (2024-02-01)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/ivs`: Updates service API, documentation, and paginators
* `service/managedblockchain-query`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release includes support for broadcast-mixed audio description tracks.

Release v1.50.8 (2024-01-31)
===

### Service Client Updates
* `service/cloudformation`: Updates service API, documentation, paginators, and examples
  * CloudFormation IaC generator allows you to scan existing resources in your account and select resources to generate a template for a new or existing CloudFormation stack.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Update page size limits for GetJobRuns and GetTriggers APIs.
* `service/ssm`: Updates service API and documentation
  * This release adds an optional Duration parameter to StateManager Associations. This allows customers to specify how long an apply-only-on-cron association execution should run. Once the specified Duration is out all the ongoing cancellable commands or automations are cancelled.

Release v1.50.7 (2024-01-30)
===

### Service Client Updates
* `service/datazone`: Updates service API and documentation
* `service/route53`: Updates service documentation
  * Update the SDKs for text changes in the APIs.

Release v1.50.6 (2024-01-29)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * EC2 Auto Scaling customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `service/comprehend`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * EC2 Fleet customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `service/mwaa`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS RestoreDBClusterFromSnapshot and RestoreDBClusterToPointInTime API methods. This provides enhanced error handling, ensuring a more robust experience.
* `service/snowball`: Updates service documentation
  * Modified description of createaddress to include direction to add path when providing a JSON file.

Release v1.50.5 (2024-01-26)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/inspector2`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now provides an API to programmatically delete tuning jobs.

Release v1.50.4 (2024-01-25)
===

### Service Client Updates
* `service/acm-pca`: Updates service API, documentation, and waiters
* `service/lightsail`: Updates service API and documentation
  * This release adds support for IPv6-only instance plans.

Release v1.50.3 (2024-01-24)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Introduced a new clientToken request parameter on CreateNetworkAcl and CreateRouteTable APIs. The clientToken parameter allows idempotent operations on the APIs.
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS.
* `service/outposts`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for Aurora Limitless Database.
* `service/storagegateway`: Updates service API and documentation
  * Add DeprecationDate and SoftwareVersion to response of ListGateways.

Release v1.50.2 (2024-01-23)
===

### Service Client Updates
* `service/inspector2`: Updates service API, documentation, and paginators

Release v1.50.1 (2024-01-22)
===

### Service Client Updates
* `service/appconfigdata`: Adds new service
* `service/cloud9`: Updates service documentation
  * Doc-only update around removing AL1 from list of available AMIs for Cloud9
* `service/connectcases`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/ecs`: Updates service API and documentation
  * This release adds support for Transport Layer Security (TLS) and Configurable Timeout to ECS Service Connect. TLS facilitates privacy and data security for inter-service communications, while Configurable Timeout allows customized per-request timeout and idle timeout for Service Connect services.
* `service/finspace`: Updates service API
* `service/organizations`: Updates service documentation
  * Doc only update for quota increase change
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS CreateDBCluster API method. This provides enhanced error handling, ensuring a more robust experience when creating database clusters with insufficient instance capacity.

Release v1.50.0 (2024-01-19)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Introducing new NotebookS3LocationUri parameter to Athena ImportNotebook API. Payload is no longer required and either Payload or NotebookS3LocationUri needs to be provided (not both) for a successful ImportNotebook API call. If both are provided, an InvalidRequestException will be thrown.
* `service/codebuild`: Updates service API, documentation, and paginators
  * Release CodeBuild Reserved Capacity feature
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for including ApproximateCreationDateTimePrecision configurations in EnableKinesisStreamingDestination API, adds the same as an optional field in the response of DescribeKinesisStreamingDestination, and adds support for a new UpdateKinesisStreamingDestination API.
* `service/qconnect`: Updates service API

### SDK Features
* `service/cloudfrontkeyvaluestore`: Deprecate cloudfrontkeyvaluestore
  * This change removes the cloudfrontkeyvaluestore service, since it does not support sigv4a.

Release v1.49.24 (2024-01-18)
===

### Service Client Updates
* `service/b2bi`: Updates service API, documentation, and examples
* `service/cloudtrail`: Updates service API, documentation, and paginators
  * This release adds a new API ListInsightsMetricData to retrieve metric data from CloudTrail Insights.
* `service/connect`: Updates service API and documentation
* `service/drs`: Updates service API
* `service/firehose`: Updates service API and documentation
  * Allow support for Snowflake as a Kinesis Data Firehose delivery destination.
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation

Release v1.49.23 (2024-01-17)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Updating note for enabling streams for UpdateTable.
* `service/keyspaces`: Updates service API and documentation

Release v1.49.22 (2024-01-16)
===

### Service Client Updates
* `service/iot`: Updates service API
  * Revert release of LogTargetTypes
* `service/iotfleetwise`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/payment-cryptography`: Updates service API and documentation
* `service/personalize`: Updates service documentation
* `service/personalize-runtime`: Updates service documentation
* `service/rekognition`: Updates service API and documentation
  * This release adds ContentType and TaxonomyLevel attributes to DetectModerationLabels and GetMediaAnalysisJob API responses.
* `service/securityhub`: Updates service documentation

Release v1.49.21 (2024-01-14)
===

### Service Client Updates
* `service/sagemaker`: Updates service API
  * This release will have ValidationException thrown if certain invalid app types are provided. The release will also throw ValidationException if more than 10 account ids are provided in VpcOnlyTrustedAccounts.

Release v1.49.20 (2024-01-12)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/connectparticipant`: Updates service API
* `service/location`: Updates service documentation
* `service/mwaa`: Updates service API and documentation
* `service/s3control`: Adds new service
  * S3 On Outposts team adds dualstack endpoints support for S3Control and S3Outposts API calls.
* `service/supplychain`: Adds new service
* `service/transfer`: Updates service API and documentation
  * AWS Transfer Family now supports static IP addresses for SFTP & AS2 connectors and for async MDNs on AS2 servers.

Release v1.49.19 (2024-01-11)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `service/ecs`: Updates service API and documentation
  * This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `service/eventbridge`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * Add ConflictException to Update APIs of AWS IoT Software Package Catalog
* `service/iotfleetwise`: Updates service API
* `service/secretsmanager`: Updates service documentation and examples
  * Doc only update for Secrets Manager
* `service/workspaces`: Updates service documentation
  * Added AWS Workspaces RebootWorkspaces API - Extended Reboot documentation update

Release v1.49.18 (2024-01-10)
===

### Service Client Updates
* `service/connectcampaigns`: Updates service API
* `service/location`: Updates service API and documentation
* `service/logs`: Updates service API and documentation
  * Add support for account level subscription filter policies to PutAccountPolicy, DescribeAccountPolicies, and DeleteAccountPolicy APIs. Additionally, PutAccountPolicy has been modified with new optional "selectionCriteria" parameter for resource selection.
* `service/qconnect`: Updates service API
* `service/redshift-serverless`: Updates service documentation
* `service/route53`: Updates service API and documentation
  * Route53 now supports geoproximity routing in AWS regions
* `service/wisdom`: Updates service API

Release v1.49.17 (2024-01-08)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Aws CodeBuild now supports new compute type BUILD_GENERAL1_XLARGE
* `service/ec2`: Updates service API
  * Amazon EC2 R7iz bare metal instances are powered by custom 4th generation Intel Xeon Scalable processors.
* `service/route53resolver`: Updates service API and documentation

Release v1.49.16 (2024-01-05)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/kms`: Updates service documentation
  * Documentation updates for AWS Key Management Service (KMS).
* `service/redshift-serverless`: Updates service documentation

### SDK Bugs
* The logging behavior in `aws/ec2metadata/token_provider.go` was updated: warnings about falling back to IMDSv1 are now logged only when LogLevel is set to `LogDebugWithDeprecated`.
  * This change prevents unnecessary warnings when LogLevel is set to suppress messages.

Release v1.49.15 (2024-01-04)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/docdb`: Updates service API and documentation
  * Adding PerformanceInsightsEnabled and PerformanceInsightsKMSKeyId fields to DescribeDBInstances Response.
* `service/ecs`: Updates service API and documentation
  * This release adds support for managed instance draining which facilitates graceful termination of Amazon ECS instances.
* `service/es`: Updates service API and documentation
  * This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `service/lightsail`: Updates service API and documentation
  * This release adds support to set up an HTTPS endpoint on an instance.
* `service/opensearch`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Adding support for provisioned throughput mode for SageMaker Feature Groups
* `service/servicecatalog`: Updates service API and documentation
  * Added Idempotency token support to Service Catalog  AssociateServiceActionWithProvisioningArtifact, DisassociateServiceActionFromProvisioningArtifact, DeleteServiceAction API

Release v1.49.14 (2024-01-03)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release includes video engine updates including HEVC improvements, support for ingesting VP9 encoded video in MP4 containers, and support for user-specified 3D LUTs.

Release v1.49.13 (2023-12-29)
===

### Service Client Updates
* `service/apprunner`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Add LinkEntityArn support for different partitions; Add UnsupportedUserEditionException in UpdateDashboardLinks API; Add support for New Reader Experience Topics

Release v1.49.12 (2023-12-28)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Studio now supports Docker access from within app container

Release v1.49.11 (2023-12-27)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * Add support for customers to modify cluster attribute auto-terminate post cluster launch

Release v1.49.10 (2023-12-26)
===

### Service Client Updates
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).

### SDK Enhancements
* `aws`: Add `WithUseFIPSEndpoint` to `aws.Config`. ([#5078](https://github.com/aws/aws-sdk-go/pull/5078))
  * `WithUseFIPSEndpoint` can be used to explicitly enable or disable FIPS endpoint variants.

Release v1.49.9 (2023-12-22)
===

### Service Client Updates
* `service/bedrock-agent`: Updates service API
* `service/glue`: Updates service API and documentation
  * This release adds additional configurations for Query Session Context on the following APIs: GetUnfilteredTableMetadata, GetUnfilteredPartitionMetadata, GetUnfilteredPartitionsMetadata.
* `service/lakeformation`: Updates service API and documentation
* `service/mediaconnect`: Updates service API and documentation
* `service/networkmonitor`: Adds new service
* `service/omics`: Updates service documentation
* `service/s3`: Updates service examples
  * Added additional examples for some operations.
* `service/secretsmanager`: Adds new service
  * Update endpoint rules and examples.

Release v1.49.8 (2023-12-21)
===

### Service Client Updates
* `service/amp`: Updates service API and documentation
* `service/appintegrations`: Updates service API, documentation, paginators, and examples
* `service/bedrock-agent`: Updates service API and documentation
* `service/codecommit`: Updates service API and documentation
  * AWS CodeCommit now supports customer managed keys from AWS Key Management Service. UpdateRepositoryEncryptionKey is added for updating the key configuration. CreateRepository, GetRepository, BatchGetRepositories are updated with new input or output parameters.
* `service/connect`: Updates service API, documentation, and paginators
* `service/medialive`: Updates service API and documentation
  * MediaLive now supports the ability to configure the audio that an AWS Elemental Link UHD device produces, when the device is configured as the source for a flow in AWS Elemental MediaConnect.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `service/rds-data`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Training now provides model training container access for debugging purposes. Amazon SageMaker Search now provides the ability to use visibility conditions to limit resource access to a single domain or multiple domains.

Release v1.49.7 (2023-12-20)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This release introduces configurable clipboard, allowing admins to specify the maximum length of text that can be copied by the users from their device to the remote session and vice-versa.
* `service/eks`: Updates service API, documentation, and paginators
* `service/guardduty`: Updates service API and documentation
  * This release 1) introduces a new API: GetOrganizationStatistics , and 2) adds a new UsageStatisticType TOP_ACCOUNTS_BY_FEATURE for GetUsageStatistics API
* `service/managedblockchain-query`: Updates service API and documentation
* `service/mediatailor`: Updates service API and documentation
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Canada West (Calgary) Region (ca-west-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

Release v1.49.6 (2023-12-19)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Provision BYOIPv4 address ranges and advertise them by specifying the network border groups option in Los Angeles, Phoenix and Dallas AWS Local Zones.
* `service/fsx`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * RDS - The release adds two new APIs: DescribeDBRecommendations and ModifyDBRecommendation

Release v1.49.5 (2023-12-18)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/eks`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service documentation
  * A docs-only release to add missing entities to the API reference.
* `service/route53resolver`: Updates service API and documentation

Release v1.49.4 (2023-12-15)
===

### Service Client Updates
* `service/cloud9`: Updates service documentation and examples
  * Updated Cloud9 API documentation for AL2023 release
* `service/connect`: Updates service API and documentation
* `service/connectcases`: Updates service API
* `service/kms`: Updates service documentation
  * Documentation updates for AWS Key Management Service
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation by adding code examples
* `service/sagemaker`: Updates service API and documentation
  * This release 1) introduces a new API: DeleteCompilationJob , and 2) adds InfraCheckConfig for Create/Describe training job API

Release v1.49.3 (2023-12-14)
===

### Service Client Updates
* `service/appstream`: Updates service API
  * This release includes support for images of Windows Server 2022 platform.
* `service/b2bi`: Updates service documentation and examples
* `service/billingconductor`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/controltower`: Updates service documentation
* `service/firehose`: Updates service API and documentation
  * This release, 1) adds configurable buffering hints for the Splunk destination, and 2) reduces the minimum configurable buffering interval for supported destinations
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift adds the ability to add and update the game properties of active game sessions.
* `service/iot`: Updates service API and documentation
  * This release adds the ability to self-manage certificate signing in AWS IoT Core fleet provisioning using the new certificate provider resource.
* `service/opensearch`: Updates service documentation
* `service/quicksight`: Updates service API and documentation
  * Update Dashboard Links support; SingleAxisOptions support; Scatterplot Query limit support.
* `service/workspaces`: Updates service documentation
  * Updated note to ensure customers understand running modes.

Release v1.49.2 (2023-12-13)
===

### Service Client Updates
* `service/drs`: Updates service API and documentation

Release v1.49.1 (2023-12-12)
===

### Service Client Updates
* `service/imagebuilder`: Updates service API, documentation, and paginators
* `service/location`: Updates service API and documentation
* `service/logs`: Updates service API and documentation
  * This release introduces the StartLiveTail API to tail ingested logs in near real time.

Release v1.49.0 (2023-12-11)
===

### Service Client Updates
* `service/neptune`: Updates service API and documentation
  * This release adds a new parameter configuration setting to the Neptune cluster related APIs that can be leveraged to switch between the underlying supported storage modes.
* `service/pinpoint`: Updates service documentation
  * This release includes Amazon Pinpoint API documentation updates pertaining to campaign message sending rate limits.
* `service/securityhub`: Updates service API and documentation

### SDK Features
* `service/sqs`: BREAKFIX: Revert SQS error constants to original state
  * Values for SQS error constants were incorrectly changed. This reverts them back.

Release v1.48.16 (2023-12-08)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * M2 Mac instances are built on Apple M2 Mac mini computers. I4i instances are powered by 3rd generation Intel Xeon Scalable processors. C7i compute optimized, M7i general purpose and R7i memory optimized instances are powered by custom 4th Generation Intel Xeon Scalable processors.
* `service/finspace`: Updates service API, documentation, and paginators
* `service/monitoring`: Updates service API and documentation
  * Adds support for the OpenTelemetry 1.0 output format in CloudWatch Metric Streams.

Release v1.48.15 (2023-12-07)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * This release adds support for two new CodeDeploy features: 1) zonal deployments for Amazon EC2 in-place deployments, 2) deployments triggered by Auto Scaling group termination lifecycle hook events.

Release v1.48.14 (2023-12-06)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/comprehend`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Releasing the new cpuManufacturer attribute within the DescribeInstanceTypes API response which notifies our customers with information on who the Manufacturer is for the processor attached to the instance, for example: Intel.
* `service/payment-cryptography`: Updates service API and documentation

Release v1.48.13 (2023-12-05)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Adding IdentityCenter enabled request for interactive query
* `service/cleanroomsml`: Updates service API and documentation
* `service/cloudformation`: Updates service documentation
  * Documentation update, December 2023
* `service/ec2`: Updates service API and documentation
  * Adds A10G, T4G, and H100 as accelerator name options and Habana as an accelerator manufacturer option for attribute based selection

Release v1.48.12 (2023-12-04)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/braket`: Updates service API and documentation
* `service/cloud9`: Updates service API and documentation
  * This release adds the requirement to include the imageId parameter in the CreateEnvironmentEC2 API call.
* `service/cloudformation`: Updates service waiters
  * Including UPDATE_* states as a success status for CreateStack waiter.
* `service/finspace`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * Adds support for custom color correction on channels using 3D LUT files.
* `service/servicecatalog-appregistry`: Updates service documentation

Release v1.48.11 (2023-12-01)
===

### Service Client Updates
* `service/qconnect`: Updates service API and documentation
* `service/rbin`: Updates service API and documentation
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.48.10 (2023-11-30)
===

### Service Client Updates
* `service/arc-zonal-shift`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Adds observation and analyzer support to the GetDataQualityResult and BatchGetDataQualityResult APIs.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for 1/ Code Editor, based on Code-OSS, Visual Studio Code Open Source, a new fully managed IDE option in SageMaker Studio  2/ JupyterLab, a new fully managed JupyterLab IDE experience in SageMaker Studio

Release v1.48.9 (2023-11-30)
===

### Service Client Updates
* `service/marketplace-agreement`: Adds new service
* `service/marketplace-catalog`: Updates service API and documentation
* `service/marketplace-deployment`: Adds new service
* `service/redshift-serverless`: Updates service API, documentation, and paginators

Release v1.48.8 (2023-11-29)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/cleanrooms`: Updates service API, documentation, and paginators
* `service/cleanroomsml`: Adds new service
* `service/opensearch`: Updates service API and documentation
* `service/opensearchserverless`: Updates service API and documentation
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This release adds following support 1/ Improved SDK tooling for model deployment. 2/ New Inference Component based features to lower inference costs and latency 3/ SageMaker HyperPod management. 4/ Additional parameters for FM Fine Tuning in Autopilot
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.

Release v1.48.7 (2023-11-28)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/bedrock`: Updates service API and documentation
* `service/bedrock-agent`: Adds new service
* `service/bedrock-agent-runtime`: Adds new service
* `service/bedrock-runtime`: Updates service API, documentation, and waiters
* `service/connect`: Updates service API, documentation, and paginators
* `service/customer-profiles`: Updates service API and documentation
* `service/qbusiness`: Updates service API, documentation, paginators, and examples
* `service/qconnect`: Updates service API, documentation, paginators, and examples
* `service/s3`: Updates service API, documentation, paginators, and examples
* `service/s3control`: Updates service API and documentation

Release v1.48.6 (2023-11-28)
===

### Service Client Updates
* `service/elasticache`: Updates service API, documentation, and paginators
  * Launching Amazon ElastiCache Serverless that enables you to create a cache in under a minute without any capacity management. ElastiCache Serverless monitors the cache's memory, CPU, and network usage and scales both vertically and horizontally to support your application's requirements.

Release v1.48.5 (2023-11-27)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/b2bi`: Updates service API, documentation, paginators, and examples
* `service/backup`: Updates service API, documentation, and paginators
* `service/controltower`: Updates service API and documentation
* `service/elasticfilesystem`: Updates service API and documentation
  * Adding support for EFS Replication to existing file system.
* `service/fis`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * add observations support to DQ CodeGen config model + update document for connectiontypes supported by ConnectorData entities
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for support for RDS for Db2.
* `service/securityhub`: Updates service API, documentation, paginators, and examples
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.48.4 (2023-11-27)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API, documentation, and paginators
* `service/amp`: Updates service API, documentation, waiters, and paginators
* `service/bcm-data-exports`: Adds new service
* `service/cloudtrail`: Updates service API and documentation
  * CloudTrail Lake now supports federating event data stores. giving users the ability to run queries against their event data using Amazon Athena.
* `service/codestar-connections`: Updates service API, documentation, and paginators
* `service/compute-optimizer`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/controltower`: Updates service API, documentation, and paginators
* `service/cost-optimization-hub`: Adds new service
* `service/detective`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Adds a new 'type' property to the Setting structure. Adds a new AccountSetting - guardDutyActivate for ECS.
* `service/eks`: Updates service API, documentation, and paginators
* `service/eks-auth`: Updates service API, documentation, waiters, paginators, and examples
* `service/elasticfilesystem`: Updates service API, documentation, and paginators
  * Adding support for EFS Archive lifecycle configuration.
* `service/elasticloadbalancingv2`: Updates service API, documentation, and paginators
* `service/freetier`: Updates service API, documentation, paginators, and examples
* `service/fsx`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Add support for Runtime Monitoring for ECS and ECS-EC2.
* `service/iotfleetwise`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation
* `service/logs`: Updates service API, documentation, and paginators
  * Added APIs to Create, Update, Get, List and Delete LogAnomalyDetectors and List and Update Anomalies in Detector. Added LogGroupClass attribute for LogGroups to classify loggroup as Standard loggroup with all capabilities or InfrequentAccess loggroup with limited capabilities.
* `service/managedblockchain`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/personalize`: Updates service API and documentation
* `service/personalize-events`: Updates service API and documentation
* `service/personalize-runtime`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * This release launches new APIs for trusted identity propagation setup and supports creating datasources using trusted identity propagation as authentication method for QuickSight accounts configured with IAM Identity Center.
* `service/redshift`: Updates service API and documentation
  * This release adds support for multi-data warehouse writes through data sharing.
* `service/repostspace`: Adds new service
* `service/runtime.lex.v2`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Adding new params - Key and Prefix, to S3 API operations for supporting S3 Access Grants. Note - These updates will not change any of the existing S3 API functionality.
* `service/s3control`: Updates service API, documentation, and paginators
  * Introduce Amazon S3 Access Grants, a new S3 access control feature that maps identities in directories such as Active Directory, or AWS Identity and Access Management (IAM) Principals, to datasets in S3.
* `service/secretsmanager`: Updates service API, documentation, and paginators
  * AWS Secrets Manager has released the BatchGetSecretValue API, which allows customers to fetch up to 20 Secrets with a single request using a list of secret names or filters.
* `service/securityhub`: Updates service API, documentation, and examples
* `service/states`: Updates service API and documentation
  * Adds new TestState operation which accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine.
* `service/transcribe`: Updates service API and documentation
* `service/workspaces`: Updates service API and documentation
  * The release introduces Multi-Region Resilience one-way data replication that allows you to replicate data from your primary WorkSpace to a standby WorkSpace in another AWS Region. DescribeWorkspaces now returns the status of data replication.
* `service/workspaces-thin-client`: Adds new service

Release v1.48.3 (2023-11-22)
===

### Service Client Updates
* `service/kinesis`: Updates service API and documentation
  * This release adds support for resource based policies on streams and consumers.
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations now manages buckets or prefixes in a single step.
* `service/sagemaker`: Updates service API and documentation
  * This feature adds the end user license agreement status as a model access configuration parameter.

Release v1.48.2 (2023-11-21)
===

### Service Client Updates
* `service/cloudfront`: Updates service API, documentation, paginators, and examples
  * This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `service/cloudfront-keyvaluestore`: Adds new service
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/inspector-scan`: Adds new service
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/iottwinmaker`: Updates service API, documentation, and paginators
* `service/s3`: Updates service API, documentation, and examples
  * Add support for automatic date based partitioning in S3 Server Access Logs.

Release v1.48.1 (2023-11-20)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API, documentation, and paginators
* `service/docdb`: Updates service API and documentation
  * Amazon DocumentDB updates for new cluster storage configuration: Amazon DocumentDB I/O-Optimized.
* `service/ec2`: Updates service API and documentation
  * This release adds support for Security group referencing over Transit gateways, enabling you to simplify Security group management and control of instance-to-instance traffic across VPCs that are connected by Transit gateway.

Release v1.48.0 (2023-11-17)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/athena`: Updates service API and documentation
  * Adding SerivicePreProcessing time metric
* `service/cloud9`: Updates service documentation and examples
  * A minor doc only update related to changing the date of an API change.
* `service/cloudformation`: Updates service API and documentation
  * This release adds a new flag ImportExistingResources to CreateChangeSet. Specify this parameter on a CREATE- or UPDATE-type change set to import existing resources with custom names instead of recreating them.
* `service/codepipeline`: Updates service API and documentation
  * CodePipeline now supports overriding source revisions to achieve manual re-deploy of a past revision
* `service/codestar-connections`: Updates service API, documentation, and paginators
* `service/connect`: Updates service API
* `service/dlm`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * This release adds new features for Amazon VPC IP Address Manager (IPAM) Allowing a choice between Free and Advanced Tiers, viewing public IP address insights across regions and in Amazon Cloudwatch, use IPAM to plan your subnet IPs within a VPC and bring your own autonomous system number to IPAM.
* `service/ecr`: Updates service API and documentation
  * Documentation and operational updates for Amazon ECR, adding support for pull through cache rules for upstream registries that require authentication.
* `service/elasticmapreduce`: Updates service API and documentation
  * Launch support for IAM Identity Center Trusted Identity Propagation and workspace storage encryption using AWS KMS in EMR Studio
* `service/eventbridge`: Updates service API and documentation
* `service/internetmonitor`: Updates service API, documentation, and paginators
* `service/ivs`: Updates service API
* `service/ivschat`: Updates service API
* `service/kinesisvideo`: Updates service documentation
  * Docs only build to bring up-to-date with public docs.
* `service/location`: Updates service API
* `service/medialive`: Updates service API and documentation
  * MediaLive has now added support for per-output static image overlay.
* `service/mgn`: Updates service API
* `service/osis`: Updates service API and documentation
* `service/pipes`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for option groups and replica enhancements to Amazon RDS Custom.
* `service/redshift`: Updates service API, documentation, and paginators
  * Updated SDK for Amazon Redshift, which you can use to configure a connection with IAM Identity Center to manage access to databases. With these, you can create a connection through a managed application. You can also change a managed application, delete it, or get information about an existing one.
* `service/redshift-serverless`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Removes all default 0 values for numbers and false values for booleans
* `service/sso-admin`: Updates service API and documentation
* `service/sso-oidc`: Updates service API, documentation, and examples
* `service/sts`: Updates service documentation
  * API updates for the AWS Security Token Service
* `service/trustedadvisor`: Adds new service
* `service/verifiedpermissions`: Updates service API and documentation
* `service/wisdom`: Updates service API, documentation, and paginators

### SDK Features
* `service/macie`: Deprecate Macie
  * This change removes the macie service, since it is deprecated.

Release v1.47.13 (2023-11-16)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Enable use of tenant-specific PublicSigningKeyUrl from device trust providers and onboard jumpcloud as a new device trust provider.
* `service/fsx`: Updates service API and documentation
* `service/glue`: Updates service API, documentation, and paginators
  * Introduces new column statistics APIs to support statistics generation for tables within the Glue Data Catalog.
* `service/imagebuilder`: Updates service API, documentation, and paginators
* `service/iot`: Updates service API and documentation
  * GA release the ability to index and search devices based on their GeoLocation data. With GeoQueries you can narrow your search to retrieve devices located in the desired geographic boundary.
* `service/ivs-realtime`: Updates service API, documentation, and paginators
* `service/kafka`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Adds support for logging configuration in Lambda Functions. Customers will have more control how their function logs are captured and to which cloud watch log group they are delivered also.
* `service/macie2`: Updates service API and documentation
* `service/mediapackage`: Updates service API and documentation
  * DRM_TOP_LEVEL_COMPACT allows placing content protection elements at the MPD level and referenced at the AdaptationSet level
* `service/pinpoint-sms-voice-v2`: Updates service API, documentation, and paginators
* `service/polly`: Updates service API and documentation
  * Add new engine - long-form - dedicated for longer content, such as news articles, training materials, or marketing videos.
* `service/quicksight`: Updates service API, documentation, and paginators
  * Custom permission support for QuickSight roles; Three new datasources STARBURST, TRINO, BIGQUERY; Lenient mode changes the default behavior to allow for exporting and importing with certain UI allowed errors, Support for permissions and tags export and import.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Studio now supports Trainium instance types - trn1.2xlarge, trn1.32xlarge, trn1n.32xlarge.
* `service/ssm`: Updates service API and documentation
  * This release introduces the ability to filter automation execution steps which have parent steps. In addition, runbook variable information is returned by GetAutomationExecution and parent step information is returned by the DescribeAutomationStepExecutions API.
* `service/ssm-incidents`: Updates service API, documentation, and paginators
* `service/sso-admin`: Updates service API, documentation, and paginators
* `service/transfer`: Updates service API and documentation
  * Introduced S3StorageOptions for servers to enable directory listing optimizations and added Type fields to logical directory mappings.

Release v1.47.12 (2023-11-15)
===

### Service Client Updates
* `service/autoscaling`: Updates service API, documentation, and examples
  * This release introduces Instance Maintenance Policy, a new EC2 Auto Scaling capability that allows customers to define whether instances are launched before or after existing instances are terminated during instance replacement operations.
* `service/cloudtrail`: Updates service API and documentation
  * The Lake Repricing feature lets customers configure a BillingMode for an event data store. The BillingMode determines the cost for ingesting and storing events and the default and maximum retention period for the event data store.
* `service/ec2`: Updates service API and documentation
  * AWS EBS now supports Snapshot Lock, giving users the ability to lock an EBS Snapshot to prohibit deletion of the snapshot. This release introduces the LockSnapshot, UnlockSnapshot & DescribeLockedSnapshots APIs to manage lock configuration for snapshots. The release also includes the dl2q_24xlarge.
* `service/finspace`: Updates service API
* `service/finspace-data`: Updates service API
* `service/lambda`: Updates service API
  * Add Java 21 (java21) support to AWS Lambda
* `service/mwaa`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for support for upgrading RDS for MySQL snapshots from version 5.7 to version 8.0.
* `service/redshift`: Updates service API and documentation
  * The custom domain name SDK for Amazon Redshift provisioned clusters is updated with additional required parameters for modify and delete operations. Additionally, users can provide domain names with longer top-level domains.
* `service/s3control`: Updates service API, documentation, and paginators
  * Add 5 APIs to create, update, get, list, delete S3 Storage Lens group(eg. CreateStorageLensGroup), 3 APIs for tagging(TagResource,UntagResource,ListTagsForResource), and update to StorageLensConfiguration to allow metrics to be aggregated on Storage Lens groups.
* `service/ssm-sap`: Updates service API

### SDK Bugs
* Don't generate cloudwatchlogs event streams tests for now.
  * The test harness does not handle event stream APIs with a host prefix at this time.

Release v1.47.11 (2023-11-14)
===

### Service Client Updates
* `service/backup`: Updates service API, documentation, and paginators
* `service/cleanrooms`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/glue`: Updates service API, documentation, and paginators
  * Introduces new storage optimization APIs to support automatic compaction of Apache Iceberg tables.
* `service/iot`: Updates service API and documentation
  * This release introduces new attributes in API CreateSecurityProfile, UpdateSecurityProfile and DescribeSecurityProfile to support management of Metrics Export for AWS IoT Device Defender Detect.
* `service/lambda`: Updates service API
  * Add Python 3.12 (python3.12) support to AWS Lambda
* `service/mediatailor`: Updates service API
* `service/pipes`: Updates service API and documentation
* `service/resource-explorer-2`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * This release makes Model Registry Inference Specification fields as not required.
* `service/signer`: Updates service documentation
  * Documentation updates for AWS Signer
* `service/states`: Updates service API and documentation
  * This release adds support to redrive executions in AWS Step Functions with a new RedriveExecution operation.

### SDK Bugs
* `aws/defaults`: Feature updates to endpoint credentials provider.
  * Add support for dynamic auth token from file and EKS container host in configured URI.

Release v1.47.10 (2023-11-13)
===

### Service Client Updates
* `service/dataexchange`: Updates service API
* `service/dms`: Updates service API and documentation
  * Added new Db2 LUW Target endpoint with related endpoint settings. New executeTimeout endpoint setting for mysql endpoint. New ReplicationDeprovisionTime field for serverless describe-replications.
* `service/ec2`: Updates service API, documentation, and paginators
  * Adds the new EC2 DescribeInstanceTopology API, which you can use to retrieve the network topology of your running instances on select platform types to determine their relative proximity to each other.
* `service/ecs`: Updates service API and documentation
  * Adds a Client Token parameter to the ECS RunTask API. The Client Token parameter allows for idempotent RunTask requests.
* `service/elasticmapreduce`: Updates service API
  * Updated GetClusterSessionCredentials API  to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters to support IdentityCenter/PEZ integration.
* `service/servicecatalog-appregistry`: Updates service API and documentation
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.47.9 (2023-11-10)
===

### Service Client Updates
* `service/controltower`: Updates service API and documentation
* `service/cur`: Updates service API and documentation
  * This release adds support for tagging and customers can now tag report definitions. Additionally, ReportStatus is now added to report definition to show when the last delivered time stamp and if it succeeded or not.
* `service/ec2`: Updates service API and documentation
  * EC2 adds API updates to enable ENA Express at instance launch time.
* `service/entitlement.marketplace`: Updates service API, documentation, and paginators
* `service/fms`: Updates service documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release includes the ability to specify any input source as the primary input for corresponding follow modes, and allows users to specify fit and fill behaviors without resizing content.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for zero-ETL integrations.

### SDK Enhancements
* `aws/signer/v4`: Add bucket owner header to presigned list.
  * Add x-amz-expected-bucket-owner header to the list of headers that need to be presigned.

Release v1.47.8 (2023-11-09)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Added new ConcurrencyMode feature for AWS CloudFormation StackSets for faster deployments to target accounts.
* `service/cloudtrail`: Updates service API and documentation
  * The Insights in Lake feature lets customers enable CloudTrail Insights on a source CloudTrail Lake event data store and create a destination event data store to collect Insights events based on unusual management event activity in the source event data store.
* `service/comprehend`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * AWS EBS now supports Block Public Access for EBS Snapshots. This release introduces the EnableSnapshotBlockPublicAccess, DisableSnapshotBlockPublicAccess and GetSnapshotBlockPublicAccessState APIs to manage account-level public access settings for EBS Snapshots in an AWS Region.
* `service/eks`: Updates service API and documentation
* `service/lambda`: Updates service API
  * Add Custom runtime on Amazon Linux 2023 (provided.al2023) support to AWS Lambda.
* `service/logs`: Updates service API, documentation, and paginators
  * Update to support new APIs for delivery of logs from AWS services.
* `service/omics`: Updates service API and documentation

Release v1.47.7 (2023-11-09)
===

### Service Client Updates
* `service/sqs`: Updates service API and documentation
  * This release enables customers to call SQS using AWS JSON-1.0 protocol and bug fix.

Release v1.47.6 (2023-11-08)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/connectcases`: Updates service API and documentation
* `service/datasync`: Updates service API
* `service/guardduty`: Updates service API and documentation
  * Added API support for new GuardDuty EKS Audit Log finding types.
* `service/lambda`: Updates service API and documentation
  * Add Node 20 (nodejs20.x) support to AWS Lambda.
* `service/models.lex.v2`: Updates service API and documentation
* `service/omics`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This Amazon RDS release adds support for patching the OS of an RDS Custom for Oracle DB instance. You can now upgrade the database or operating system using the modify-db-instance command.
* `service/redshift-serverless`: Updates service API and documentation
* `service/resiliencehub`: Updates service API and documentation
* `service/sqs`: Updates service API, documentation, and paginators
  * This release enables customers to call SQS using AWS JSON-1.0 protocol.

Release v1.47.5 (2023-11-07)
===

### Service Client Updates
* `service/dataexchange`: Updates service API and documentation
* `service/dlm`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This Amazon RDS release adds support for the multi-tenant configuration. In this configuration, an RDS DB instance can contain multiple tenant databases. In RDS for Oracle, a tenant database is a pluggable database (PDB).

Release v1.47.4 (2023-11-06)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now supports AWS Lambda compute.
* `service/connect`: Updates service API and documentation
* `service/docdb`: Updates service API and documentation
  * Update the input of CreateDBInstance and ModifyDBInstance to support setting CA Certificates. Update the output of DescribeDBInstance and DescribeDBEngineVersions to show current and supported CA certificates.
* `service/iam`: Adds new service
  * Add partitional endpoint for iso-e.
* `service/mwaa`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new US English voices - Danielle and Gregory. Danielle and Gregory are available as Neural voices only.
* `service/route53`: Adds new service
  * Add partitional endpoints for iso-e and iso-f.

Release v1.47.3 (2023-11-03)
===

### Service Client Updates
* `service/config`: Updates service API
* `service/connect`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/launch-wizard`: Adds new service

Release v1.47.2 (2023-11-02)
===

### Service Client Updates
* `service/apprunner`: Updates service API and documentation
* `service/connect`: Updates service documentation
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift adds support for shared credentials, which allows applications that are deployed on managed EC2 fleets to interact with other AWS resources.
* `service/glue`: Updates service API and documentation
  * This release introduces Google BigQuery Source and Target in AWS Glue CodeGenConfigurationNode.
* `service/network-firewall`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * This release introduces Float Decimal Type as SubType in QuickSight SPICE datasets and Custom week start and Custom timezone options in Analysis and DashboardI

### SDK Enhancements
* `aws/ec2metadata`: Added environment and shared config support for disabling IMDSv1 fallback.
  * Use env `AWS_EC2_METADATA_V1_DISABLED` or shared config `ec2_metadata_v1_disabled` accordingly.

Release v1.47.1 (2023-11-01)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/globalaccelerator`: Updates service API, documentation, and paginators
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for customized networking resources to Amazon RDS Custom.
* `service/redshift`: Updates service API and documentation
  * Added support for Multi-AZ deployments for Provisioned RA3 clusters that provide 99.99% SLA availability.
* `service/sagemaker`: Updates service API and documentation
  * Support for batch transform input in Model dashboard

Release v1.47.0 (2023-10-31)
===

### Service Client Updates
* `service/amplify`: Updates service API, documentation, and paginators
* `service/application-insights`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * Capacity Blocks for ML are a new EC2 purchasing option for reserving GPU instances on a future date to support short duration machine learning (ML) workloads. Capacity Blocks automatically place instances close together inside Amazon EC2 UltraClusters for low-latency, high-throughput networking.
* `service/m2`: Updates service API and documentation
* `service/neptunedata`: Updates service API and documentation
* `service/translate`: Updates service API and documentation

### SDK Features
* `aws`: Bump minimum go version to 1.19.
  * See https://aws.amazon.com/blogs/developer/aws-sdk-for-go-aligns-with-go-release-policy-on-supported-runtimes/.

Release v1.46.7 (2023-10-30)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/dataexchange`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/finspace`: Updates service API and documentation
* `service/mediapackagev2`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release launches the CreateIntegration, DeleteIntegration, and DescribeIntegrations APIs to manage zero-ETL Integrations.
* `service/redshift-serverless`: Updates service API, documentation, and paginators
* `service/resiliencehub`: Updates service API and documentation
* `service/s3outposts`: Updates service API and documentation
* `service/wisdom`: Updates service documentation

Release v1.46.6 (2023-10-27)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * Updated CreateCluster API request and DescribeCluster API responses to include EbsRootVolumeIops, and EbsRootVolumeThroughput attributes that specify the user configured root volume IOPS and throughput for Amazon EBS root device volume. This feature will be available from Amazon EMR releases 6.15.0
* `service/neptune`: Updates service API and documentation
  * Update TdeCredentialPassword type to SensitiveString
* `service/pinpoint`: Updates service documentation
  * Updated documentation to describe the case insensitivity for EndpointIds.
* `service/redshift`: Updates service API and documentation
  * added support to create a dual stack cluster
* `service/wafv2`: Updates service documentation

Release v1.46.5 (2023-10-26)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `service/ec2`: Updates service API, documentation, and paginators
  * Launching GetSecurityGroupsForVpc API. This API gets security groups that can be associated by the AWS account making the request with network interfaces in the specified VPC.
* `service/network-firewall`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/redshift`: Updates service API, documentation, and paginators
  * Add Redshift APIs GetResourcePolicy, DeleteResourcePolicy, PutResourcePolicy and DescribeInboundIntegrations for the new Amazon Redshift Zero-ETL integration feature, which can be used to control data ingress into Redshift namespace, and view inbound integrations.
* `service/sagemaker`: Updates service API and documentation
  * Amazon Sagemaker Autopilot now supports Text Generation jobs.
* `service/sns`: Updates service API and documentation
  * Message Archiving and Replay is now supported in Amazon SNS for FIFO topics.
* `service/ssm-sap`: Updates service API and documentation
* `service/transfer`: Updates service API, documentation, waiters, and paginators
  * No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.

Release v1.46.4 (2023-10-25)
===

### Service Client Updates
* `service/connectcases`: Updates service API and documentation
* `service/groundstation`: Updates service API and documentation
* `service/iam`: Updates service API and documentation
  * Updates to GetAccessKeyLastUsed action to replace NoSuchEntity error with AccessDeniedException error.

Release v1.46.3 (2023-10-24)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Add ability to trigger pipelines from git tags, define variables at pipeline level and new pipeline type V2.
* `service/ec2`: Updates service documentation
  * This release updates the documentation for InstanceInterruptionBehavior and HibernationOptionsRequest to more accurately describe the behavior of these two parameters when using Spot hibernation.
* `service/eks`: Updates service API
* `service/iam`: Adds new service
  * Add the partitional endpoint for IAM in iso-f.
* `service/migrationhub-config`: Updates service API and documentation
* `service/migrationhubstrategy`: Updates service API, documentation, and paginators
* `service/opensearchserverless`: Updates service API, documentation, and paginators

Release v1.46.2 (2023-10-23)
===

### Service Client Updates
* `service/marketplacecommerceanalytics`: Updates service API and documentation
  * The StartSupportDataExport operation has been deprecated as part of the Product Support Connection deprecation. As of December 2022, Product Support Connection is no longer supported.
* `service/networkmanager`: Updates service API and documentation
* `service/redshift-serverless`: Updates service API and documentation
* `service/rekognition`: Updates service API, documentation, paginators, and examples
  * Amazon Rekognition introduces StartMediaAnalysisJob, GetMediaAnalysisJob, and ListMediaAnalysisJobs operations to run a bulk analysis of images with a Detect Moderation model.

Release v1.46.1 (2023-10-20)
===

### Service Client Updates
* `service/appconfig`: Updates service API
* `service/appintegrations`: Updates service API
* `service/connect`: Updates service API and documentation
* `service/discovery`: Updates service API, documentation, and paginators
  * This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `service/medical-imaging`: Updates service documentation
* `service/ssm`: Updates service API and documentation
  * This release introduces a new API: DeleteOpsItem. This allows deletion of an OpsItem.

Release v1.46.0 (2023-10-19)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Amazon EC2 C7a instances, powered by 4th generation AMD EPYC processors, are ideal for high performance, compute-intensive workloads such as high performance computing. Amazon EC2 R7i instances are next-generation memory optimized and powered by custom 4th Generation Intel Xeon Scalable processors.
* `service/managedblockchain-query`: Updates service API
* `service/neptunedata`: Updates service documentation
* `service/omics`: Updates service API and documentation
* `service/opensearch`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * This release adds the following: 1) Trino and Starburst Database Connectors 2) Custom total for tables and pivot tables 3) Enable restricted folders 4) Add rolling dates for time equality filters 5) Refine DataPathValue and introduce DataPathType 6) Add SeriesType to ReferenceLineDataConfiguration
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/servicecatalog`: Updates service API and documentation
  * Introduce support for EXTERNAL product and provisioning artifact type in CreateProduct and CreateProvisioningArtifact APIs.
* `service/verifiedpermissions`: Updates service API and documentation
* `service/workspaces`: Updates service documentation
  * Documentation updates for WorkSpaces

### SDK Features
* `service/gamesparks`: Deprecate Gamesparks
  * This change removes the gamesparks service, since it is deprecated.

Release v1.45.28 (2023-10-18)
===

### Service Client Updates
* `service/cloud9`: Updates service documentation
  * Update to imageId parameter behavior and dates updated.
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Updating descriptions for several APIs.
* `service/kendra`: Updates service API and documentation
  * Changes for a new feature in Amazon Kendra's Query API to Collapse/Expand query results
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for upgrading the storage file system configuration on the DB instance using a blue/green deployment or a read replica.
* `service/wisdom`: Updates service API

Release v1.45.27 (2023-10-17)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Add retryMode ALL_ACTIONS to RetryStageExecution API that retries a failed stage starting from first action in the stage
* `service/discovery`: Updates service API and documentation
  * This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `service/ecs`: Updates service documentation and examples
  * Documentation only updates to address Amazon ECS tickets.
* `service/globalaccelerator`: Updates service paginators
* `service/guardduty`: Updates service API and documentation
  * Add domainWithSuffix finding field to dnsRequestAction
* `service/kafka`: Updates service API, documentation, and paginators
* `service/route53-recovery-cluster`: Updates service API and documentation
* `service/route53-recovery-control-config`: Updates service API and documentation

Release v1.45.26 (2023-10-16)
===

### Service Client Updates
* `service/cloudformation`: Updates service API
  * SDK and documentation updates for UpdateReplacePolicy
* `service/drs`: Updates service API and documentation
* `service/entityresolution`: Updates service API, documentation, and paginators
* `service/managedblockchain-query`: Updates service API, documentation, and paginators
* `service/mediapackagev2`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/redshift`: Updates service API and documentation
  * Added support for managing credentials of provisioned cluster admin using AWS Secrets Manager.
* `service/redshift-serverless`: Updates service API and documentation
* `service/sesv2`: Updates service API and documentation
* `service/transfer`: Updates service documentation
  * Documentation updates for AWS Transfer Family
* `service/xray`: Updates service API and documentation
  * This releases enhances GetTraceSummaries API to support new TimeRangeType Service to query trace summaries by segment end time.

Release v1.45.25 (2023-10-12)
===

### Service Client Updates
* `service/auditmanager`: Updates service API
* `service/autoscaling`: Updates service API, documentation, paginators, and examples
  * Update the NotificationMetadata field to only allow visible ascii characters. Add paginators to DescribeInstanceRefreshes, DescribeLoadBalancers, and DescribeLoadBalancerTargetGroups
* `service/config`: Updates service API and documentation
* `service/controltower`: Updates service API and documentation
* `service/customer-profiles`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds Ubuntu Pro as a supported platform for On-Demand Capacity Reservations and adds support for setting an Amazon Machine Image (AMI) to disabled state. Disabling the AMI makes it private if it was previously shared, and prevents new EC2 instance launches from it.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/glue`: Updates service API and documentation
  * Extending version control support to GitLab and Bitbucket from AWSGlue
* `service/inspector2`: Updates service API and documentation
* `service/ivs-realtime`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Adds support for Lambda functions to access Dual-Stack subnets over IPv6, via an opt-in flag in CreateFunction and UpdateFunctionConfiguration APIs
* `service/location`: Updates service API
* `service/machinelearning`: Updates service API
  * This release marks Password field as sensitive
* `service/pricing`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for adding a dedicated log volume to open-source RDS instances.
* `service/rekognition`: Updates service API and documentation
  * Amazon Rekognition introduces support for Custom Moderation. This allows the enhancement of accuracy for detect moderation labels operations by creating custom adapters tuned on customer data.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Canvas adds KendraSettings and DirectDeploySettings support for CanvasAppSettings
* `service/textract`: Updates service API, documentation, and paginators
* `service/transcribe`: Updates service API
* `service/workspaces`: Updates service documentation
  * Updated the CreateWorkspaces action documentation to clarify that the PCoIP protocol is only available for Windows bundles.

Release v1.45.24 (2023-10-06)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation updates for Elastic Compute Cloud (EC2).
* `service/fsx`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * NullOption in FilterListConfiguration; Dataset schema/table max length increased; Support total placement for pivot table visual; Lenient mode relaxes the validation to create resources with definition; Data sources can be added to folders; Redshift data sources support IAM Role-based authentication
* `service/transfer`: Updates service API and documentation
  * This release updates the max character limit of PreAuthenticationLoginBanner and PostAuthenticationLoginBanner to 4096 characters

Release v1.45.23 (2023-10-05)
===

### Service Client Updates
* `service/omics`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for corrections and minor improvements.
* `service/route53`: Updates service API and documentation
  * Add hostedzonetype filter to ListHostedZones API.
* `service/securityhub`: Updates service API and documentation
* `service/storagegateway`: Updates service API and documentation
  * Add SoftwareVersion to response of DescribeGatewayInformation.
* `service/workspaces`: Updates service API, documentation, and paginators
  * This release introduces Manage applications. This feature allows users to manage their WorkSpaces applications by associating or disassociating their WorkSpaces with applications. The DescribeWorkspaces API will now additionally return OperatingSystemName in its responses.

Release v1.45.22 (2023-10-04)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/datazone`: Updates service API, documentation, paginators, and examples
* `service/mediatailor`: Updates service API and documentation
* `service/mgn`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * Adding support for AdditionalS3DataSource, a data source used for training or inference that is in addition to the input dataset or model data.

Release v1.45.21 (2023-10-03)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release adds the ability to replace video frames without modifying the audio essence.
* `service/oam`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release allows users to run Selective Execution in SageMaker Pipelines without SourcePipelineExecutionArn if selected steps do not have any dependent steps.
* `service/wellarchitected`: Updates service API, documentation, and paginators

Release v1.45.20 (2023-10-02)
===

### Service Client Updates
* `service/bedrock`: Updates service API, documentation, waiters, and paginators
* `service/bedrock-runtime`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Introducing Amazon EC2 R7iz instances with 3.9 GHz sustained all-core turbo frequency and deliver up to 20% better performance than previous generation z1d instances.
* `service/managedblockchain`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds DefaultCertificateForNewLaunches field in the DescribeCertificates API response.
* `service/sso`: Adds new service
  * Fix FIPS Endpoints in aws-us-gov.
* `service/sts`: Updates service API and documentation
  * STS API updates for assumeRole
* `service/transfer`: Updates service documentation
  * Documentation updates for AWS Transfer Family

Release v1.45.19 (2023-09-28)
===

### Service Client Updates
* `service/bedrock`: Updates service API, documentation, paginators, and examples
* `service/bedrock-runtime`: Adds new service
* `service/budgets`: Updates service API and documentation
  * Update DescribeBudgets and DescribeBudgetNotificationsForAccount MaxResults limit to 1000.
* `service/ec2`: Updates service API and documentation
  * Adds support for Customer Managed Key encryption for Amazon Verified Access resources
* `service/iotfleetwise`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Online store feature groups supports Standard and InMemory tier storage types for low latency storage for real-time data retrieval. The InMemory tier supports collection types List, Set, and Vector.
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation
* `service/wafv2`: Updates service documentation

Release v1.45.18 (2023-09-27)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API, documentation, and examples
* `service/firehose`: Updates service API and documentation
  * Features : Adding support for new data ingestion source to Kinesis Firehose - AWS Managed Services Kafka.
* `service/iot`: Updates service API and documentation
  * Added support for IoT Rules Engine Kafka Action Headers
* `service/textract`: Updates service API and documentation

Release v1.45.17 (2023-09-26)
===

### Service Client Updates
* `service/appintegrations`: Updates service API, documentation, paginators, and examples
* `service/apprunner`: Updates service API and documentation
* `service/codedeploy`: Updates service documentation
  * CodeDeploy now supports In-place and Blue/Green EC2 deployments with multiple Classic Load Balancers and multiple Target Groups.
* `service/connect`: Updates service API, documentation, and paginators
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Amazon DynamoDB now supports Incremental Export as an enhancement to the existing Export Table
* `service/ec2`: Updates service API and documentation
  * The release includes AWS verified access to support FIPs compliance in North America regions
* `service/lakeformation`: Updates service API, documentation, and paginators
* `service/pinpoint`: Updates service documentation
  * Update documentation for RemoveAttributes to more accurately reflect its behavior when attributes are deleted.
* `service/s3`: Updates service API and examples
  * This release adds a new field COMPLETED to the ReplicationStatus Enum. You can now use this field to validate the replication status of S3 objects using the AWS SDK.

Release v1.45.16 (2023-09-25)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API and documentation
* `service/chime-sdk-media-pipelines`: Updates service API, documentation, and paginators
* `service/emr-serverless`: Updates service API and documentation
* `service/finspace-data`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Added ability to tag users upon creation.
* `service/ssm`: Updates service API and documentation
  * This release updates the enum values for ResourceType in SSM DescribeInstanceInformation input and ConnectionStatus in GetConnectionStatus output.
* `service/wafv2`: Updates service API and documentation

Release v1.45.15 (2023-09-22)
===

### Service Client Updates
* `service/braket`: Updates service API and documentation
* `service/dms`: Updates service API, documentation, and examples
  * new vendors for DMS CSF: MongoDB, MariaDB, DocumentDb and Redshift
* `service/ec2`: Updates service API
  * EC2 M2 Pro Mac instances are powered by Apple M2 Pro Mac Mini computers featuring 12 core CPU, 19 core GPU, 32 GiB of memory, and 16 core Apple Neural Engine and uniquely enabled by the AWS Nitro System through high-speed Thunderbolt connections.
* `service/elasticfilesystem`: Updates service documentation
  * Documentation updates for Elastic File System
* `service/events`: Updates service API and documentation
  * Adds sensitive trait to various shapes in Jetstream Connections API model.
* `service/guardduty`: Updates service API and documentation
  * Add `EKS_CLUSTER_NAME` to filter and sort key.
* `service/mediaconvert`: Updates service API and documentation
  * This release supports the creation of of audio-only tracks in CMAF output groups.

### SDK Bugs
* `aws/session`: Removed typed literal parsing for config, everything is now treated as a string until a numeric value is needed.
  * This resolves an issue where the contents of a profile would silently be dropped with certain values.

Release v1.45.14 (2023-09-20)
===

### Service Client Updates
* `service/appconfig`: Updates service API, documentation, and paginators
* `service/apprunner`: Updates service API, documentation, and paginators
* `service/codeartifact`: Updates service API
* `service/kinesisvideo`: Updates service documentation
  * Updated DescribeMediaStorageConfiguration, StartEdgeConfigurationUpdate, ImageGenerationConfiguration$SamplingInterval, and UpdateMediaStorageConfiguration to match AWS Docs.
* `service/logs`: Updates service API and documentation
  * Add ClientToken to QueryDefinition CFN Handler in CWL
* `service/s3`: Updates service API, documentation, and examples
  * Fix an issue where the SDK can fail to unmarshall response due to NumberFormatException
* `service/servicediscovery`: Updates service API and documentation
* `service/sso-oidc`: Adds new service

Release v1.45.13 (2023-09-19)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release adds support for C7i, and R7a instance types.
* `service/outposts`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for one-time model monitoring schedules that are executed immediately without delay, explicit data analysis windows for model monitoring schedules and exclude features attributes to remove features from model monitor analysis.

Release v1.45.12 (2023-09-18)
===

### Service Client Updates
* `service/discovery`: Updates service API
  * Add sensitive protection for customer information
* `service/macie2`: Updates service documentation
* `service/workmail`: Updates service API, documentation, and paginators
  * This release includes four new APIs UpdateUser, UpdateGroup, ListGroupsForEntity and DescribeEntity, along with RemoteUsers and some enhancements to existing APIs.

Release v1.45.11 (2023-09-15)
===

### Service Client Updates
* `service/appstream`: Updates service API, documentation, and waiters
  * This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `service/connect`: Updates service API
* `service/datasync`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * This release introduces Skip Model Validation for Model Packages

Release v1.45.10 (2023-09-14)
===

### Service Client Updates
* `service/appstream`: Updates service API, documentation, and waiters
  * This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `service/cloudformation`: Updates service documentation
  * Documentation updates for AWS CloudFormation
* `service/entityresolution`: Updates service API and documentation
* `service/lookoutequipment`: Updates service API, documentation, paginators, and examples

Release v1.45.9 (2023-09-13)
===

### Service Client Updates
* `service/cloud9`: Updates service documentation
  * Update to include information on Ubuntu 18 deprecation.
* `service/drs`: Updates service API, documentation, and paginators
* `service/firehose`: Updates service API and documentation
  * DocumentIdOptions has been added for the Amazon OpenSearch destination.
* `service/guardduty`: Updates service API and documentation
  * Add `managementType` field to ListCoverage API response.
* `service/internetmonitor`: Adds new service
* `service/ivs-realtime`: Updates service documentation
* `service/simspaceweaver`: Updates service documentation
* `service/xray`: Updates service API and documentation
  * Add StartTime field in GetTraceSummaries API response for each TraceSummary.

Release v1.45.8 (2023-09-12)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for restricting public sharing of AMIs through AMI Block Public Access
* `service/eventbridge`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports confidence score buckets for retrieved passage results using the Retrieve API.

### SDK Enhancements
* `service/glacier`: Improve efficiency of tree hash algorithm
  * Refactor tree hashing to reduce allocations.

Release v1.45.7 (2023-09-11)
===

### Service Client Updates
* `service/ecr`: Updates service API, documentation, and examples
  * This release will have ValidationException be thrown from ECR LifecyclePolicy APIs in regions LifecyclePolicy is not supported, this includes existing Amazon Dedicated Cloud (ADC) regions. This release will also change Tag: TagValue and Tag: TagKey to required.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental Link now supports attaching a Link UHD device to a MediaConnect flow.
* `service/quicksight`: Updates service API and documentation
  * This release launches new updates to QuickSight KPI visuals - support for sparklines, new templated layout and new targets for conditional formatting rules.

Release v1.45.6 (2023-09-08)
===

### Service Client Updates
* `service/fsx`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * Autopilot APIs will now support holiday featurization for Timeseries models. The models will now hold holiday metadata and should be able to accommodate holiday effect during inference.
* `service/sso-admin`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * A new field "ErrorDetails" will be added to the output of "DescribeWorkspaceImages" API call. This field provides in-depth details about the error occurred during image import process. These details include the possible causes of the errors and troubleshooting information.

Release v1.45.5 (2023-09-07)
===

### Service Client Updates
* `service/neptunedata`: Updates service API
* `service/securityhub`: Updates service documentation
* `service/simspaceweaver`: Updates service API

Release v1.45.4 (2023-09-06)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/ec2`: Updates service API
  * This release adds 'outpost' location type to the DescribeInstanceTypeOfferings API, allowing customers that have been allowlisted for outpost to query their offerings in the API.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/medialive`: Updates service API and documentation
  * Adds advanced Output Locking options for Epoch Locking: Custom Epoch and Jam Sync Time
* `service/wafv2`: Updates service API and documentation

Release v1.45.3 (2023-09-05)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/cloud9`: Updates service documentation
  * Added support for Ubuntu 22.04 that was not picked up in a previous Trebuchet request. Doc-only update.
* `service/compute-optimizer`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Introducing Amazon EC2 C7gd, M7gd, and R7gd Instances with up to 3.8 TB of local NVMe-based SSD block-level storage. These instances are powered by AWS Graviton3 processors, delivering up to 25% better performance over Graviton2-based instances.
* `service/ecs`: Updates service documentation
  * Documentation only update for Amazon ECS.
* `service/eventbridge`: Adds new service
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Add support for feature integration with AWS Backup.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Neo now supports data input shape derivation for Pytorch 2.0  and XGBoost compilation job for cloud instance targets. You can skip DataInputConfig field during compilation job creation. You can also access derived information from model in DescribeCompilationJob response.
* `service/vpc-lattice`: Updates service API and documentation

Release v1.45.2 (2023-09-01)
===

### Service Client Updates
* `service/chime-sdk-media-pipelines`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/identitystore`: Updates service API and documentation
* `service/neptunedata`: Updates service documentation

Release v1.45.1 (2023-08-31)
===

### Service Client Updates
* `service/chime-sdk-media-pipelines`: Updates service API and documentation
* `service/cloudhsm`: Updates service API
  * Deprecating CloudHSM Classic API Service.
* `service/connectcampaigns`: Updates service API and documentation
* `service/connectparticipant`: Updates service API and documentation
* `service/customer-profiles`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release adds support for an account-level setting that you can use to configure the number of days for AWS Fargate task retirement.
* `service/events`: Updates service documentation
  * Documentation updates for CloudWatch Events.
* `service/grafana`: Updates service API
* `service/health`: Updates service API and documentation
  * Adds new API DescribeEntityAggregatesForOrganization that retrieves entity aggregates across your organization. Also adds support for resource status filtering in DescribeAffectedEntitiesForOrganization, resource status aggregates in the DescribeEntityAggregates response, and new resource statuses.
* `service/ivs`: Updates service documentation
* `service/kafkaconnect`: Updates service API and documentation
* `service/payment-cryptography-data`: Updates service API and documentation
* `service/runtime.sagemaker`: Updates service API and documentation

Release v1.45.0 (2023-08-30)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/apprunner`: Updates service API and documentation
* `service/auditmanager`: Updates service API
* `service/cleanrooms`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/neptunedata`: Adds new service
* `service/network-firewall`: Updates service API and documentation
* `service/pca-connector-ad`: Adds new service
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Canvas adds IdentityProviderOAuthSettings support for CanvasAppSettings

### SDK Features
* `aws/corehandlers`: Add internal flag in user agent functionality
  * Added handler which will add aws internal metadata to the user agent string

Release v1.44.334 (2023-08-29)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API, documentation, and examples
* `service/fsx`: Updates service documentation
* `service/omics`: Updates service API and documentation
* `service/sesv2`: Updates service API, documentation, paginators, and examples

Release v1.44.333 (2023-08-28)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/compute-optimizer`: Updates service API and documentation
* `service/organizations`: Updates service documentation
  * Documentation updates for permissions and links.
* `service/securitylake`: Updates service API
* `service/service-quotas`: Updates service API and documentation
* `service/workspaces-web`: Updates service API and documentation

Release v1.44.332 (2023-08-25)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API and documentation
  * Add ThrottlingException with error code 429 to handle CloudTrail Delegated Admin request rate exceeded on organization resources.
* `service/detective`: Updates service API
* `service/monitoring`: Updates service documentation
  * Doc-only update to get doc bug fixes into the SDK docs

Release v1.44.331 (2023-08-24)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Amazon EC2 M7a instances, powered by 4th generation AMD EPYC processors, deliver up to 50% higher performance compared to M6a instances. Amazon EC2 Hpc7a instances, powered by 4th Gen AMD EPYC processors, deliver up to 2.5x better performance compared to Amazon EC2 Hpc6a instances.
* `service/glue`: Updates service API and documentation
  * Added API attributes that help in the monitoring of sessions.
* `service/mediaconvert`: Updates service API and documentation
  * This release includes additional audio channel tags in Quicktime outputs, support for film grain synthesis for AV1 outputs, ability to create audio-only FLAC outputs, and ability to specify Amazon S3 destination storage class.
* `service/medialive`: Updates service API and documentation
  * MediaLive now supports passthrough of KLV data to a HLS output group with a TS container. MediaLive now supports setting an attenuation mode for AC3 audio when the coding mode is 3/2 LFE. MediaLive now supports specifying whether to include filler NAL units in RTMP output group settings.
* `service/mediatailor`: Updates service API and documentation
* `service/quicksight`: Updates service API, documentation, and paginators
  * Excel support in Snapshot Export APIs. Removed Required trait for some insight Computations. Namespace-shared Folders support. Global Filters support. Table pin Column support.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release updates the supported versions for Percona XtraBackup in Aurora MySQL.
* `service/s3`: Updates service examples
  * Updates to endpoint ruleset tests to address Smithy validation issues.
* `service/s3control`: Adds new service
  * Updates to endpoint ruleset tests to address Smithy validation issues and standardize the capitalization of DualStack.
* `service/verifiedpermissions`: Updates service documentation

Release v1.44.330 (2023-08-23)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * This release adds RootResourceId to GetRestApi response.
* `service/ec2`: Updates service API and documentation
  * Marking fields as sensitive on BundleTask and GetPasswordData
* `service/polly`: Updates service API
  * Amazon Polly adds 1 new voice - Zayd (ar-AE)

Release v1.44.329 (2023-08-22)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/globalaccelerator`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adding parameters to CreateCustomDbEngineVersion reserved for future use.
* `service/verifiedpermissions`: Updates service API and documentation

Release v1.44.328 (2023-08-21)
===

### Service Client Updates
* `service/cloud9`: Adds new service
  * Doc only update to add Ubuntu 22.04 as an Image ID option for Cloud9
* `service/ec2`: Updates service API and documentation
  * The DeleteKeyPair API has been updated to return the keyPairId when an existing key pair is deleted.
* `service/finspace`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adding support for RDS Aurora Global Database Unplanned Failover
* `service/route53domains`: Updates service documentation
  * Fixed typos in description fields

Release v1.44.327 (2023-08-18)
===

### Service Client Updates
* `service/codecommit`: Updates service API, documentation, and paginators
  * Add new ListFileCommitHistory operation to retrieve commits which introduced changes to a specific file.
* `service/securityhub`: Updates service API and documentation

### SDK Bugs
* `aws/credentials/ssocreds`: Modify sso token provider logic to handle possible nil val returned by CreateToken.
  * Fixes [4947](https://github.com/aws/aws-sdk-go/issues/4947)

Release v1.44.326 (2023-08-17)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds support for SubnetConfigurations to allow users to select their own IPv4 and IPv6 addresses for Interface VPC endpoints
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift updates its instance types support.

### SDK Bugs
* `aws/signer/v4`: Sign `X-Amz-Server-Side-Encryption-Context` header.
  * Fixes signing for PutObject requests that set `SSEKMSEncryptionContext`.

Release v1.44.325 (2023-08-16)
===

### Service Client Updates
* `service/models.lex.v2`: Updates service API
* `service/monitoring`: Updates service documentation
  * Doc-only update to incorporate several doc bug fixes

Release v1.44.324 (2023-08-15)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API
* `service/ec2`: Updates service documentation
  * Documentation updates for Elastic Compute Cloud (EC2).
* `service/glue`: Updates service API and documentation
  * AWS Glue Crawlers can now accept SerDe overrides from a custom csv classifier. The two SerDe options are LazySimpleSerDe and OpenCSVSerDe. In case, the user wants crawler to do the selection, "None" can be selected for this purpose.
* `service/pi`: Updates service API, documentation, and paginators
* `service/route53domains`: Updates service API and documentation
  * Provide explanation if CheckDomainTransferability return false. Provide requestId if a request is already submitted.  Add sensitive protection for customer information
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now provides SupportedResponseMIMETypes from DescribeInferenceRecommendationsJob response

Release v1.44.323 (2023-08-14)
===

### Service Client Updates
* `service/mediapackage`: Updates service API
  * Fix SDK logging of certain fields.
* `service/omics`: Updates service API, documentation, waiters, and paginators
* `service/transfer`: Updates service documentation
  * Documentation updates for AWS Transfer Family

Release v1.44.322 (2023-08-11)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API
* `service/config`: Updates service API
* `service/ec2`: Updates service API
  * Amazon EC2 P5 instances, powered by the latest NVIDIA H100 Tensor Core GPUs, deliver the highest performance in EC2 for deep learning (DL) and HPC applications. M7i-flex and M7i instances are next-generation general purpose instances powered by custom 4th Generation Intel Xeon Scalable processors.
* `service/email`: Updates service documentation
  * Doc only updates to include: 1) Clarified which part of an email address where it's okay to have Punycode when it contains non-ASCII characters for the SendRawEmail action and other actions where this is applicable. 2) Updated S3Action description with new MB max bucket size from 30 to 40.
* `service/quicksight`: Updates service API and documentation
  * New Authentication method for Account subscription - IAM Identity Center. Hierarchy layout support, default column width support and related style properties for pivot table visuals. Non-additive topic field aggregations for Topic API
* `service/swf`: Updates service API and documentation
  * This release adds new API parameters to override workflow task list for workflow executions.

Release v1.44.321 (2023-08-10)
===

### Service Client Updates
* `service/cloudtrail`: Updates service documentation
  * Documentation updates for CloudTrail.
* `service/connect`: Updates service API, documentation, and paginators
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/omics`: Updates service API and documentation
* `service/secretsmanager`: Updates service API
  * Add additional InvalidRequestException to list of possible exceptions for ListSecret.
* `service/transfer`: Updates service documentation
  * Documentation updates for AW Transfer Family

Release v1.44.320 (2023-08-09)
===

### Service Client Updates
* `service/chime-sdk-voice`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/globalaccelerator`: Updates service documentation
* `service/guardduty`: Updates service API and documentation
  * Added autoEnable ALL to UpdateOrganizationConfiguration and DescribeOrganizationConfiguration APIs.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for cross account access for SageMaker Model Cards through AWS RAM.

Release v1.44.319 (2023-08-08)
===

### Service Client Updates
* `service/backup`: Updates service API, documentation, and paginators
* `service/elasticache`: Updates service API and documentation
  * Added support for cluster mode in online migration and test migration API
* `service/servicecatalog`: Updates service API and documentation
  * Introduce support for HashiCorp Terraform Cloud in Service Catalog by addying TERRAFORM_CLOUD product type in CreateProduct and CreateProvisioningArtifact API.

Release v1.44.318 (2023-08-07)
===

### Service Client Updates
* `service/detective`: Updates service API
* `service/ivs-realtime`: Updates service API and documentation
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/kinesisvideo`: Updates service API and documentation
  * This release enables minimum of Images SamplingInterval to be as low as 200 milliseconds in Kinesis Video Stream Image feature.
* `service/rekognition`: Updates service documentation and examples
  * This release adds code snippets for Amazon Rekognition Custom Labels.

Release v1.44.317 (2023-08-04)
===

### Service Client Updates
* `service/acm-pca`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * This is a documentation update to address various tickets.
* `service/sagemaker`: Updates service API and documentation
  * Including DataCaptureConfig key in the Amazon Sagemaker Search's transform job object

Release v1.44.316 (2023-08-03)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation and examples
  * Documentation changes related to Amazon EC2 Auto Scaling APIs.
* `service/cloud9`: Updates service documentation
  * Updated the deprecation date for Amazon Linux. Doc only update.
* `service/dms`: Updates service API, documentation, and paginators
  * The release makes public API for DMS Schema Conversion feature.
* `service/ec2`: Updates service API and documentation
  * This release adds new parameter isPrimaryIPv6 to  allow assigning an IPv6 address as a primary IPv6 address to a network interface which cannot be changed to give equivalent functionality available for network interfaces with primary IPv4 address.
* `service/sagemaker`: Updates service API
  * Amazon SageMaker now supports running training jobs on p5.48xlarge instance types.

Release v1.44.315 (2023-08-02)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * As part of CAE tagging integration we need to update our budget names regex filter to prevent customers from using "/action/" in their budget names.
* `service/cognito-idp`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * This release includes additional Glue Streaming KAKFA SASL property types.
* `service/resiliencehub`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender introduces a new API GetScalingConfigurationRecommendation to recommend auto scaling policies based on completed Inference Recommender jobs.

Release v1.44.314 (2023-08-01)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This release adds support for price capacity optimized allocation strategy for Spot Instances.
* `service/dms`: Updates service API, documentation, and paginators
  * Adding new API describe-engine-versions which provides information about the lifecycle of a replication instance's version.
* `service/internetmonitor`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental Link devices now report their Availability Zone. Link devices now support the ability to change their Availability Zone.
* `service/polly`: Updates service API
  * Amazon Polly adds new French Belgian voice - Isabelle. Isabelle is available as Neural voice only.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Added support for deleted clusters PiTR.
* `service/sagemaker`: Updates service API and documentation
  * Add Stairs TrafficPattern and FlatInvocations to RecommendationJobStoppingConditions

Release v1.44.313 (2023-07-31)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API and documentation
* `service/autoscaling`: Updates service API, documentation, and examples
  * You can now configure an instance refresh to set its status to 'failed' when it detects that a specified CloudWatch alarm has gone into the ALARM state. You can also choose to roll back the instance refresh automatically when the alarm threshold is met.
* `service/cleanrooms`: Updates service API, documentation, and paginators
* `service/codestar-connections`: Updates service API and documentation
* `service/drs`: Updates service API
* `service/inspector2`: Updates service API and documentation
* `service/lookoutequipment`: Updates service API, documentation, and paginators
* `service/omics`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for Aurora MySQL local write forwarding, which allows for forwarding of write operations from reader DB instances to the writer DB instance.
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Israel (Tel Aviv) Region (il-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/scheduler`: Updates service API and documentation

Release v1.44.312 (2023-07-28)
===

### Service Client Updates
* `service/application-insights`: Updates service API, documentation, and paginators
* `service/cloudformation`: Updates service API and documentation
  * This SDK release is for the feature launch of AWS CloudFormation RetainExceptOnCreate. It adds a new parameter retainExceptOnCreate in the following APIs: CreateStack, UpdateStack, RollbackStack, ExecuteChangeSet.
* `service/cloudfront`: Updates service API and documentation
  * Add a new JavaScript runtime version for CloudFront Functions.
* `service/connect`: Updates service API
* `service/kafka`: Updates service API, documentation, and paginators
* `service/pinpoint`: Updates service API, documentation, and examples
  * Added support for sending push notifications using the FCM v1 API with json credentials. Amazon Pinpoint customers can now deliver messages to Android devices using both FCM v1 API and the legacy FCM/GCM API

Release v1.44.311 (2023-07-28)
===

### Service Client Updates
* `service/sqs`: Updates service documentation
  * Documentation changes related to SQS APIs.

### SDK Bugs
* `aws/session`: Modify resolving sso credential logic to fix stack overflow bug while configuring shared config profile via env var.
  * Fixes [4912](https://github.com/aws/aws-sdk-go/issues/4912)

Release v1.44.310 (2023-07-27)
===

### Service Client Updates
* `service/autoscaling`: Updates service API, documentation, paginators, and examples
  * This release updates validation for instance types used in the AllowedInstanceTypes and ExcludedInstanceTypes parameters of the InstanceRequirements property of a MixedInstancesPolicy.
* `service/ebs`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and waiters
  * SDK and documentation updates for Amazon Elastic Block Store APIs
* `service/eks`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * Expose ProfilerConfig attribute in SageMaker Search API response.

Release v1.44.309 (2023-07-26)
===

### Service Client Updates
* `service/cloudcontrol`: Updates service documentation
* `service/entityresolution`: Adds new service
* `service/glue`: Updates service API and documentation
  * Release Glue Studio Snowflake Connector Node for SDK/CLI
* `service/healthlake`: Updates service documentation
* `service/managedblockchain-query`: Adds new service
* `service/mediaconvert`: Updates service API and documentation
  * This release includes general updates to user documentation.
* `service/omics`: Updates service documentation
* `service/opensearchserverless`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds 1 new voice - Lisa (nl-BE)
* `service/route53`: Updates service documentation
  * Update that corrects the documents for received feedback.

Release v1.44.308 (2023-07-25)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/customer-profiles`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for DynamoDB
* `service/ec2`: Updates service API and documentation
  * This release adds an instance's peak and baseline network bandwidth as well as the memory sizes of an instance's inference accelerators to DescribeInstanceTypes.
* `service/emr-serverless`: Updates service API and documentation
* `service/lambda`: Updates service API
  * Add Python 3.11 (python3.11) support to AWS Lambda
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for monitoring storage optimization progress on the DescribeDBInstances API.
* `service/sagemaker`: Updates service API and documentation
  * Mark ContentColumn and TargetLabelColumn as required Targets in TextClassificationJobConfig in CreateAutoMLJobV2API
* `service/securityhub`: Updates service API and documentation
* `service/sts`: Updates service API and documentation
  * API updates for the AWS Security Token Service
* `service/transfer`: Updates service API and documentation
  * This release adds support for SFTP Connectors.
* `service/wisdom`: Updates service API and documentation

Release v1.44.307 (2023-07-24)
===

### Service Client Updates
* `service/apigatewayv2`: Adds new service
  * Documentation updates for Amazon API Gateway.
* `service/ce`: Updates service API and documentation
* `service/chime-sdk-media-pipelines`: Updates service API and documentation
* `service/cloudformation`: Updates service API and documentation
  * This release supports filtering by DRIFT_STATUS for existing API ListStackInstances and adds support for a new API ListStackInstanceResourceDrifts. Customers can now view resource drift information from their StackSet management accounts.
* `service/ec2`: Updates service API
  * Add "disabled" enum value to SpotInstanceState.
* `service/glue`: Updates service API and documentation
  * Added support for Data Preparation Recipe node in Glue Studio jobs
* `service/quicksight`: Updates service API, documentation, and paginators
  * This release launches new Snapshot APIs for CSV and PDF exports, adds support for info icon for filters and parameters in Exploration APIs, adds modeled exception to the DeleteAccountCustomization API, and introduces AttributeAggregationFunction's ability to add UNIQUE_VALUE aggregation in tooltips.

Release v1.44.306 (2023-07-21)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * This release adds support for AWS Glue Crawler with Apache Hudi Tables, allowing Crawlers to discover Hudi Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `service/mediaconvert`: Updates service documentation
  * This release includes improvements to Preserve 444 handling, compatibility of HEVC sources without frame rates, and general improvements to MP4 outputs.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for the DBSystemID parameter of CreateDBInstance to RDS Custom for Oracle.
* `service/workspaces`: Updates service documentation
  * Fixed VolumeEncryptionKey descriptions

### SDK Bugs
* `codegen`: Prevent unused imports from being generated for event streams.
  * Potentially-unused `"time"` import was causing vet failures on generated code.

Release v1.44.305 (2023-07-20)
===

### Service Client Updates
* `service/connectcases`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API and documentation
* `service/route53resolver`: Updates service API, documentation, and paginators
* `service/s3`: Updates service examples
  * Improve performance of S3 clients by simplifying and optimizing endpoint resolution.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Cross account support for SageMaker Feature Store
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation
* `service/securitylake`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

Release v1.44.304 (2023-07-20)
===

### Service Client Updates
* `service/savingsplans`: Updates service documentation

Release v1.44.303 (2023-07-19)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * SDK and documentation updates for GetTemplateSummary API (unrecognized resources)
* `service/ec2`: Updates service documentation
  * Amazon EC2 documentation updates.
* `service/grafana`: Updates service API, documentation, and paginators
* `service/medical-imaging`: Adds new service
* `service/ram`: Updates service API and documentation
* `service/ssm-sap`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.44.302 (2023-07-18)
===

### Service Client Updates
* `service/codeguru-security`: Updates service documentation
* `service/connect`: Updates service documentation
* `service/es`: Updates service API
  * Regex Validation on the ElasticSearch Engine Version attribute
* `service/m2`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/snowball`: Updates service API, documentation, paginators, and examples
  * Adds support for RACK_5U_C. This is the first AWS Snow Family device designed to meet U.S. Military Ruggedization Standards (MIL-STD-810H) with 208 vCPU device in a portable, compact 5U, half-rack width form-factor.
* `service/translate`: Updates service documentation

Release v1.44.301 (2023-07-17)
===

### Service Client Updates
* `service/codeartifact`: Updates service documentation
* `service/docdb`: Updates service API and documentation
  * Added major version upgrade option in ModifyDBCluster API
* `service/ec2`: Updates service API and documentation
  * Add Nitro TPM support on DescribeInstanceTypes
* `service/glue`: Updates service API
  * Adding new supported permission type flags to get-unfiltered endpoints that callers may pass to indicate support for enforcing Lake Formation fine-grained access control on nested column attributes.
* `service/ivs`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation

Release v1.44.300 (2023-07-13)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API
* `service/connect`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * Enhanced PostgreSQL target endpoint settings for providing Babelfish support.
* `service/ec2`: Updates service API
  * This release adds support for the C7gn and Hpc7g instances. C7gn instances are powered by AWS Graviton3 processors and the fifth-generation AWS Nitro Cards. Hpc7g instances are powered by AWS Graviton 3E processors and provide up to 200 Gbps network bandwidth.
* `service/fsx`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/mediatailor`: Updates service API and documentation
* `service/personalize`: Updates service API and documentation
* `service/proton`: Updates service API, documentation, and paginators
* `service/s3`: Updates service API, documentation, and examples
  * S3 Inventory now supports Object Access Control List and Object Owner as available object metadata fields in inventory reports.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Canvas adds WorkspeceSettings support for CanvasAppSettings
* `service/secretsmanager`: Updates service documentation and examples
  * Documentation updates for Secrets Manager

Release v1.44.299 (2023-07-11)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API

Release v1.44.298 (2023-07-07)
===

### Service Client Updates
* `service/dms`: Updates service API, documentation, and paginators
  * Releasing DMS Serverless. Adding support for PostgreSQL 15.x as source and target endpoint. Adding support for DocDB Elastic Clusters with sharded collections, PostgreSQL datatype mapping customization and disabling hostname validation of the certificate authority in Kafka endpoint settings
* `service/glue`: Updates service API and documentation
  * This release enables customers to create new Apache Iceberg tables and associated metadata in Amazon S3 by using native AWS Glue CreateTable operation.
* `service/logs`: Updates service API and documentation
  * Add CMK encryption support for CloudWatch Logs Insights query result data
* `service/medialive`: Updates service API and documentation
  * This release enables the use of Thumbnails in AWS Elemental MediaLive.
* `service/mediatailor`: Updates service API and documentation

### SDK Bugs
* `aws/credentials/ssocreds`: Implement SSO token provider support for `sso-session` in AWS shared config.
  * Fixes [4649](https://github.com/aws/aws-sdk-go/issues/4649)

Release v1.44.297 (2023-07-06)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Add Nitro Enclaves support on DescribeInstanceTypes
* `service/location`: Updates service API and documentation
* `service/outposts`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * This release includes below three changes: small multiples axes improvement, field based coloring, removed required trait from Aggregation function for TopBottomFilter.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Updates Amazon RDS documentation for creating DB instances and creating Aurora global clusters.

Release v1.44.296 (2023-07-05)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service documentation
* `service/connect`: Updates service documentation
* `service/kms`: Updates service API and documentation
  * Added Dry Run Feature to cryptographic and cross-account mutating KMS APIs (14 in all). This feature allows users to test their permissions and parameters before making the actual API call.
* `service/mgn`: Updates service API, documentation, and paginators
* `service/securityhub`: Updates service documentation

Release v1.44.295 (2023-07-03)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This feature allows customers to use AWS Batch with Linux with ARM64 CPU Architecture and X86_64 CPU Architecture with Windows OS on Fargate Platform.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now accepts new fields SupportedEndpointType and ServerlessConfiguration to support serverless endpoints.

Release v1.44.294 (2023-06-30)
===

### Service Client Updates
* `service/amp`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Added new field  "credentialspecs" to the ecs task definition to support gMSA of windows/linux in both domainless and domain-joined mode
* `service/ivs`: Updates service API
* `service/mediaconvert`: Updates service documentation
  * This release includes improved color handling of overlays and general updates to user documentation.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for rolling deployment in SageMaker Inference.
* `service/transfer`: Updates service API and documentation
  * Add outbound Basic authentication support to AS2 connectors
* `service/verifiedpermissions`: Updates service documentation

Release v1.44.293 (2023-06-29)
===

### Service Client Updates
* `service/appstream`: Updates service API, documentation, and paginators
  * This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `service/chime`: Updates service API and documentation
  * The Amazon Chime SDK APIs in the Chime namespace are no longer supported.  Customers should use APIs in the dedicated Amazon Chime SDK namespaces: ChimeSDKIdentity, ChimeSDKMediaPipelines, ChimeSDKMeetings, ChimeSDKMessaging, and ChimeSDKVoice.
* `service/cleanrooms`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds ReturnValuesOnConditionCheckFailure parameter to PutItem, UpdateItem, DeleteItem, ExecuteStatement, BatchExecuteStatement and ExecuteTransaction APIs. When set to ALL_OLD,  API returns a copy of the item as it was when a conditional write failed
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift now supports game builds that use the Amazon Linux 2023 (AL2023) operating system.
* `service/glue`: Updates service API and documentation
  * This release adds support for AWS Glue Crawler with Iceberg Tables, allowing Crawlers to discover Iceberg Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `service/sagemaker`: Updates service API and documentation
  * Adding support for timeseries forecasting in the CreateAutoMLJobV2 API.

### SDK Bugs
* `private/protocol`: Fix header serialization of empty enum lists in restxml.
  * Header was serialized as the empty string if list was nil/empty.

Release v1.44.292 (2023-06-28)
===

### Service Client Updates
* `service/internetmonitor`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API
* `service/lambda`: Updates service API and documentation
  * Surface ResourceConflictException in DeleteEventSourceMapping
* `service/omics`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Amazon Relational Database Service (RDS) now supports joining a RDS for SQL Server instance to a self-managed Active Directory.
* `service/s3`: Updates service API, documentation, and examples
  * The S3 LISTObjects, ListObjectsV2 and ListObjectVersions API now supports a new optional header x-amz-optional-object-attributes. If header contains RestoreStatus as the value, then S3 will include Glacier restore status i.e. isRestoreInProgress and RestoreExpiryDate in List response.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for Model Cards Model Registry integration.

Release v1.44.291 (2023-06-27)
===

### Service Client Updates
* `service/appfabric`: Updates service API, documentation, waiters, paginators, and examples
* `service/appflow`: Updates service API and documentation
* `service/emr-serverless`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/kinesisvideo`: Updates service API, documentation, and paginators
  * General Availability (GA) release of Kinesis Video Streams at Edge, enabling customers to provide a configuration for the Kinesis Video Streams EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on a configured schedule.
* `service/macie2`: Updates service API and documentation
* `service/privatenetworks`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Introducing TTL for online store records in feature groups.
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation
* `service/ssm`: Updates service documentation
  * Systems Manager doc-only update for June 2023.
* `service/verifiedpermissions`: Updates service documentation

Release v1.44.290 (2023-06-26)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Timestamp Starting Position For Kinesis and Kafka Data Sources in a Glue Streaming Job
* `service/guardduty`: Updates service API and documentation
  * Add support for user.extra.sessionName in Kubernetes Audit Logs Findings.
* `service/iam`: Updates service API, documentation, and paginators
  * Support for a new API "GetMFADevice" to present MFA device metadata such as device certifications
* `service/pinpoint`: Updates service API and documentation
  * Added time zone estimation support for journeys

Release v1.44.289 (2023-06-23)
===

### Service Client Updates
* `service/devops-guru`: Updates service API and documentation
* `service/fsx`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation improvements for create, describe, and modify DB clusters and DB instances.
* `service/verifiedpermissions`: Updates service documentation

Release v1.44.288 (2023-06-22)
===

### Service Client Updates
* `service/chime-sdk-identity`: Updates service API and documentation
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Introducing Amazon Kendra Retrieve API that can be used to retrieve relevant passages or text excerpts given an input query.
* `service/states`: Updates service API and documentation
  * Adds support for Versions and Aliases. Adds 8 operations: PublishStateMachineVersion, DeleteStateMachineVersion, ListStateMachineVersions, CreateStateMachineAlias, DescribeStateMachineAlias, UpdateStateMachineAlias, DeleteStateMachineAlias, ListStateMachineAliases

Release v1.44.287 (2023-06-21)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for DynamoDB
* `service/elasticmapreduce`: Updates service API, documentation, and paginators
  * This release introduces a new Amazon EMR EPI called ListSupportedInstanceTypes that returns a list of all instance types supported by a given EMR release.
* `service/inspector2`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release introduces the bandwidth reduction filter for the HEVC encoder, increases the limits of outputs per job, and updates support for the Nagra SDK to version 1.14.7.
* `service/mq`: Updates service API and documentation
  * The Cross Region Disaster Recovery feature allows to replicate a brokers state from one region to another in order to provide customers with multi-region resiliency in the event of a regional outage.
* `service/sagemaker`: Updates service API and documentation
  * This release provides support in SageMaker for output files in training jobs to be uploaded without compression and enable customer to deploy uncompressed model from S3 to real-time inference Endpoints. In addition, ml.trn1n.32xlarge is added to supported instance type list in training job.
* `service/transfer`: Updates service API and documentation
  * This release adds a new parameter StructuredLogDestinations to CreateServer, UpdateServer APIs.

Release v1.44.286 (2023-06-20)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/config`: Updates service API
* `service/ec2`: Updates service API and documentation
  * Adds support for targeting Dedicated Host allocations by assetIds in AWS Outposts
* `service/lambda`: Updates service API and documentation
  * This release adds RecursiveInvocationException to the Invoke API and InvokeWithResponseStream API.
* `service/redshift`: Updates service API, documentation, and paginators
  * Added support for custom domain names for Redshift Provisioned clusters. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.

Release v1.44.285 (2023-06-19)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Specify desired CloudFormation behavior in the event of ChangeSet execution failure using the CreateChangeSet OnStackFailure parameter
* `service/ec2`: Updates service API, documentation, and examples
  * API changes to AWS Verified Access to include data from trust providers in logs
* `service/ecs`: Updates service documentation
  * Documentation only update to address various tickets.
* `service/glue`: Updates service API and documentation
  * This release adds support for creating cross region table/database resource links
* `service/pricing`: Updates service API, documentation, waiters, and examples
* `service/route53domains`: Updates service API and documentation
  * Update MaxItems upper bound to 1000 for ListPricesRequest
* `service/sagemaker`: Updates service API and documentation
  * Amazon Sagemaker Autopilot releases CreateAutoMLJobV2 and DescribeAutoMLJobV2 for Autopilot customers with ImageClassification, TextClassification and Tabular problem type config support.

Release v1.44.284 (2023-06-16)
===

### Service Client Updates
* `service/account`: Updates service paginators
* `service/connect`: Updates service API and documentation
* `service/discovery`: Updates service API and documentation
  * Add Amazon EC2 instance recommendations export
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/s3`: Updates service API, documentation, and examples
  * This release adds SDK support for request-payer request header and request-charged response header in the "GetBucketAccelerateConfiguration", "ListMultipartUploads", "ListObjects", "ListObjectsV2" and "ListObjectVersions" S3 APIs.

Release v1.44.283 (2023-06-15)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/elasticfilesystem`: Updates service documentation
  * Documentation updates for EFS.
* `service/guardduty`: Updates service documentation
  * Updated descriptions for some APIs.
* `service/location`: Updates service API and documentation

Release v1.44.282 (2023-06-13)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API and documentation
  * This feature allows users to view dashboards for CloudTrail Lake event data stores.
* `service/codeguru-security`: Adds new service
* `service/drs`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * This release introduces a new feature, EC2 Instance Connect Endpoint, that enables you to connect to a resource over TCP, without requiring the resource to have a public IPv4 address.
* `service/imagebuilder`: Updates service documentation
* `service/lightsail`: Updates service API and documentation
  * This release adds pagination for the Get Certificates API operation.
* `service/s3`: Updates service API and examples
  * Integrate double encryption feature to SDKs.
* `service/securityhub`: Updates service API, documentation, and examples
* `service/simspaceweaver`: Updates service API and documentation
* `service/verifiedpermissions`: Adds new service
* `service/wafv2`: Updates service API and documentation
* `service/wellarchitected`: Updates service API, documentation, and paginators

Release v1.44.281 (2023-06-12)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API, documentation, and paginators
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for DynamoDB
* `service/fsx`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/rekognition`: Updates service API, documentation, paginators, and examples
  * This release adds support for improved accuracy with user vector in Amazon Rekognition Face Search. Adds new APIs: AssociateFaces, CreateUser, DeleteUser, DisassociateFaces, ListUsers, SearchUsers, SearchUsersByImage. Also adds new face metadata that can be stored: user vector.
* `service/sagemaker`: Updates service API and documentation
  * Sagemaker Neo now supports compilation for inferentia2 (ML_INF2) and Trainium1 (ML_TRN1) as available targets. With these devices, you can run your workloads at highest performance with lowest cost. inferentia2 (ML_INF2) is available in CMH and Trainium1 (ML_TRN1) is available in IAD currently
* `service/streams.dynamodb`: Updates service documentation

Release v1.44.280 (2023-06-09)
===

### Service Client Updates
* `service/acm-pca`: Updates service documentation
* `service/connect`: Updates service API, documentation, and paginators

Release v1.44.279 (2023-06-08)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `service/comprehendmedical`: Updates service API
* `service/payment-cryptography`: Adds new service
* `service/payment-cryptography-data`: Adds new service
* `service/servicecatalog`: Updates service API and documentation
  * New parameter added in ServiceCatalog DescribeProvisioningArtifact api - IncludeProvisioningArtifactParameters. This parameter can be used to return information about the parameters used to provision the product
* `service/timestream-write`: Updates service API and documentation

Release v1.44.278 (2023-06-07)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * AWS CloudFormation StackSets is updating the deployment experience for all stackset operations to skip suspended AWS accounts during deployments. StackSets will skip target AWS accounts that are suspended and set the Detailed Status of the corresponding stack instances as SKIPPED_SUSPENDED_ACCOUNT
* `service/customer-profiles`: Updates service API, documentation, and paginators
* `service/directconnect`: Updates service documentation
  * This update corrects the jumbo frames mtu values from 9100 to 8500 for transit virtual interfaces.
* `service/emr-containers`: Updates service API and documentation
* `service/iotdeviceadvisor`: Updates service API and documentation
* `service/logs`: Updates service API and documentation
  * This change adds support for account level data protection policies using 3 new APIs, PutAccountPolicy, DeleteAccountPolicy and DescribeAccountPolicy. DescribeLogGroup API has been modified to indicate if account level policy is applied to the LogGroup via "inheritedProperties" list in the response.

Release v1.44.277 (2023-06-06)
===

### Service Client Updates
* `service/connect`: Updates service documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * This release provides customers the ability to specify an allocation strategies amongst PRICE_CAPACITY_OPTIMIZED, CAPACITY_OPTIMIZED, LOWEST_PRICE, DIVERSIFIED for Spot instances in Instance Feet cluster. This enables customers to choose an allocation strategy best suited for their workload.
* `service/iam`: Updates service API and documentation
  * This release updates the AccountAlias regex pattern with the same length restrictions enforced by the length constraint.
* `service/inspector2`: Updates service API and documentation
* `service/iot`: Updates service API, documentation, and paginators
  * Adding IoT Device Management Software Package Catalog APIs to register, store, and report system software packages, along with their versions and metadata in a centralized location.
* `service/iot-data`: Updates service API
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * QuickSight support for pivot table field collapse state, radar chart range scale and multiple scope options in conditional formatting.
* `service/signer`: Updates service API and documentation
  * AWS Signer is launching Container Image Signing, a new feature that enables you to sign and verify container images. This feature enables you to validate that only container images you approve are used in your enterprise.
* `service/sqs`: Updates service API and documentation
  * Amazon SQS adds three new APIs - StartMessageMoveTask, CancelMessageMoveTask, and ListMessageMoveTasks to automate redriving messages from dead-letter queues to source queues or a custom destination.

Release v1.44.276 (2023-06-05)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * AWS CloudFormation StackSets provides customers with three new APIs to activate, deactivate, and describe AWS Organizations trusted access which is needed to get started with service-managed StackSets.
* `service/ec2`: Updates service API
  * Making InstanceTagAttribute as the required parameter for the DeregisterInstanceEventNotificationAttributes and RegisterInstanceEventNotificationAttributes APIs.
* `service/finspace`: Updates service API, documentation, and paginators
* `service/frauddetector`: Updates service API and documentation
* `service/keyspaces`: Updates service API and documentation
* `service/kms`: Updates service API, documentation, and examples
  * This release includes feature to import customer's asymmetric (RSA and ECC) and HMAC keys into KMS.  It also includes feature to allow customers to specify number of days to schedule a KMS key deletion as a policy condition key.
* `service/lambda`: Updates service API and documentation
  * Add Ruby 3.2 (ruby3.2) Runtime support to AWS Lambda.
* `service/mwaa`: Updates service API and documentation

Release v1.44.275 (2023-06-02)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release introduces the DeleteCapacityReservation API and the ability to manage capacity reservations using CloudFormation
* `service/cloudtrail`: Updates service API and documentation
  * This feature allows users to start and stop event ingestion on a CloudTrail Lake event data store.
* `service/sagemaker`: Updates service API and documentation
  * This release adds Selective Execution feature that allows SageMaker Pipelines users to run selected steps in a pipeline.
* `service/wafv2`: Updates service API and documentation

Release v1.44.274 (2023-06-01)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/appflow`: Updates service API and documentation
* `service/customer-profiles`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/sagemaker`: Updates service documentation
  * Amazon Sagemaker Autopilot adds support for Parquet file input to NLP text classification jobs.
* `service/wafv2`: Updates service documentation

Release v1.44.273 (2023-05-31)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/frauddetector`: Updates service API and documentation
* `service/healthlake`: Updates service API and documentation
* `service/m2`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for changing the engine for Oracle using the ModifyDbInstance API
* `service/servicecatalog`: Updates service documentation
  * Documentation updates for ServiceCatalog.
* `service/workspaces-web`: Updates service API, documentation, and paginators

Release v1.44.272 (2023-05-30)
===

### Service Client Updates
* `service/chime-sdk-voice`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Added Runtime parameter to allow selection of Ray Runtime
* `service/groundstation`: Updates service documentation
* `service/iotfleetwise`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/memorydb`: Updates service API
* `service/personalize`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds 2 new voices - Sofie (da-DK) and Niamh (en-IE)
* `service/securityhub`: Updates service API, documentation, and examples
* `service/securitylake`: Updates service API, documentation, and paginators
* `service/wafv2`: Updates service API and documentation

Release v1.44.271 (2023-05-26)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/iotwireless`: Updates service API and documentation
* `service/sagemaker`: Updates service API
  * Added ml.p4d and ml.inf1 as supported instance type families for SageMaker Notebook Instances.

Release v1.44.270 (2023-05-25)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/codepipeline`: Updates service API and documentation
  * Add PollingDisabledAt time information in PipelineMetadata object of GetPipeline API.
* `service/gamelift`: Updates service API and documentation
  * GameLift FleetIQ users can now filter game server claim requests to exclude servers on instances that are draining.
* `service/glue`: Updates service API and documentation
  * Added ability to create data quality rulesets for shared, cross-account Glue Data Catalog tables. Added support for dataset comparison rules through a new parameter called AdditionalDataSources. Enhanced the data quality results with a map containing profiled metric values.
* `service/migration-hub-refactor-spaces`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now supports enabling Autotune for tuning jobs which can choose tuning job configurations.

### SDK Bugs

* `service/s3`: Populate X-Amz-Content-Sha256 header when using s3 outpost arn
  * Using an outpost ARN results in a different signing name from the resolved endpoint. This signing name was not included in the signer logic to indicate the `X-Amz-Content-Sha256` header should be added to the request which is required by S3.

Release v1.44.269 (2023-05-24)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/connect`: Updates service API
* `service/cur`: Updates service API
  * Add support for split cost allocation data on a report.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker now provides an instantaneous deployment recommendation through the DescribeModel API

### SDK Bugs

* `service/sms`: Remove deprecated services (SMS) integration tests.
  * SMS integration tests will fail because SMS deprecated their service.

Release v1.44.268 (2023-05-23)
===

### Service Client Updates
* `service/fms`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * Added ModelNameEquals, ModelPackageVersionArnEquals in request and ModelName, SamplePayloadUrl, ModelPackageVersionArn in response of ListInferenceRecommendationsJobs API. Added Invocation timestamps in response of DescribeInferenceRecommendationsJob API & ListInferenceRecommendationsJobSteps API.
* `service/translate`: Updates service API and documentation

Release v1.44.267 (2023-05-22)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/pinpoint`: Updates service documentation
  * Amazon Pinpoint is deprecating the tags parameter in the UpdateSegment, UpdateCampaign, UpdateEmailTemplate, UpdateSmsTemplate, UpdatePushTemplate, UpdateInAppTemplate and UpdateVoiceTemplate. Amazon Pinpoint will end support tags parameter by May 22, 2023.
* `service/quicksight`: Updates service API, documentation, and paginators
  * Add support for Asset Bundle, Geospatial Heatmaps.

### SDK Bugs
* `rest`: Revert removing unnecessary path normalization behavior.
  * This behavior would mutate request paths with URI-encoded characters, potentially resulting in misrouted requests.
* `config`: Revert deprecating `DisableRestProtocolURICleaning` config setting.
  * This setting will have an effect again. REST-protocol paths will now be normalized after serialization.

Release v1.44.266 (2023-05-19)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/connectcases`: Updates service API
* `service/mediapackagev2`: Adds new service
* `service/sesv2`: Updates service API, documentation, and examples

Release v1.44.265 (2023-05-18)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Removing SparkProperties from EngineConfiguration object for StartSession API call
* `service/cloudtrail`: Updates service API and documentation
  * Add ConflictException to PutEventSelectors, add (Channel/EDS)ARNInvalidException to Tag APIs. These exceptions provide customers with more specific error messages instead of internal errors.
* `service/compute-optimizer`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Add support for i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge and i4g.16xlarge instances powered by AWS Graviton2 processors that deliver up to 15% better compute performance than our other storage-optimized instances.
* `service/ecs`: Updates service documentation
  * Documentation only release to address various tickets.
* `service/mediaconvert`: Updates service API and documentation
  * This release introduces a new MXF Profile for XDCAM which is strictly compliant with the SMPTE RDD 9 standard and improved handling of output name modifiers.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * RDS documentation update for the EngineVersion parameter of ModifyDBSnapshot
* `service/sagemaker-geospatial`: Updates service API and documentation
* `service/sts`: Updates service API
  * API updates for the AWS Security Token Service

### SDK Bugs
* `rest`: Remove unnecessary path normalization behavior.
  * This behavior would incorrectly mutate request paths with URI-encoded characters, potentially resulting in misrouted requests.
* `config`: Deprecate `DisableRestProtocolURICleaning` config setting.
  * This setting no longer has any effect. REST-protocol paths will now never be normalized after serialization.

Release v1.44.264 (2023-05-16)
===

### Service Client Updates
* `service/detective`: Updates service API
* `service/directconnect`: Updates service documentation
  * This release includes an update to the mtu value for CreateTransitVirtualInterface from 9001 mtu to 8500 mtu.
* `service/glue`: Updates service API and documentation
  * Add Support for Tags for Custom Entity Types
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/wafv2`: Updates service API and documentation

Release v1.44.263 (2023-05-15)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `service/kafka`: Updates service API
* `service/rekognition`: Updates service API and documentation
  * This release adds a new EyeDirection attribute in Amazon Rekognition DetectFaces and IndexFaces APIs which predicts the yaw and pitch angles of a person's eye gaze direction for each face detected in the image.
* `service/rolesanywhere`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * This release introduces the ability to require both password and SSH key when users authenticate to your Transfer Family servers that use the SFTP protocol.

Release v1.44.262 (2023-05-11)
===

### Service Client Updates
* `service/connect`: Updates service documentation
* `service/elasticache`: Updates service API and documentation
  * Added support to modify the cluster mode configuration for the existing ElastiCache ReplicationGroups. Customers can now modify the configuration from cluster mode disabled to cluster mode enabled.
* `service/es`: Updates service API and documentation
  * This release fixes DescribePackages API error with null filter value parameter.
* `service/health`: Updates service documentation
  * Add support for regional endpoints
* `service/ivs-realtime`: Updates service API, documentation, and paginators
* `service/omics`: Updates service API, documentation, and paginators
* `service/opensearch`: Updates service API
* `service/route53resolver`: Adds new service
* `service/support`: Updates service API and documentation
  * This release adds 2 new Support APIs, DescribeCreateCaseOptions and DescribeSupportedLanguages. You can use these new APIs to get available support languages.

Release v1.44.261 (2023-05-10)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * EMR Studio now supports programmatically executing a Notebooks on an EMR on EKS cluster.  In addition, notebooks can now be executed by specifying its location in S3.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Amazon Relational Database Service (RDS) updates for the new Aurora I/O-Optimized storage type for Amazon Aurora DB clusters
* `service/swf`: Updates service API and documentation
  * This release adds a new API parameter to exclude old history events from decision tasks.

### SDK Bugs

* `service/sms`: Remove deprecated services (SMS) integration tests.
  * SMS integration tests will fail because SMS deprecated their service.

Release v1.44.260 (2023-05-09)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API, documentation, and examples
* `service/glue`: Updates service API and documentation
  * This release adds AmazonRedshift Source and Target nodes in addition to DynamicTransform OutputSchemas
* `service/sagemaker`: Updates service API and documentation
  * This release includes support for (1) Provisioned Concurrency for Amazon SageMaker Serverless Inference and (2) UpdateEndpointWeightsAndCapacities API for Serverless endpoints.

Release v1.44.259 (2023-05-08)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Support large worker types G.4x and G.8x for Glue Spark”
* `service/guardduty`: Updates service API and documentation
  * Add AccessDeniedException 403 Error message code to support 3 Tagging related APIs
* `service/iotsitewise`: Updates service API and documentation
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.

### SDK Bugs
* `restjson`: Correct failure to deserialize errors.
  * Deserialize generic error information when no response body is present.

Release v1.44.258 (2023-05-05)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release adds support the inf2 and trn1n instances. inf2 instances are purpose built for deep learning inference while trn1n instances are powered by AWS Trainium accelerators and they build on the capabilities of Trainium-powered trn1 instances.
* `service/inspector2`: Updates service API, documentation, and paginators
* `service/mediatailor`: Updates service API and documentation
* `service/sqs`: Updates service API, documentation, and paginators
  * Revert previous SQS protocol change.

Release v1.44.257 (2023-05-04)
===

### Service Client Updates
* `service/config`: Updates service API
* `service/connect`: Updates service API and documentation
* `service/ecs`: Updates service API
  * Documentation update for new error type NamespaceNotFoundException for CreateCluster and UpdateCluster
* `service/monitoring`: Updates service API and documentation
  * Adds support for filtering by metric names in CloudWatch Metric Streams.
* `service/network-firewall`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/quicksight`: Updates service API, documentation, and paginators
  * Add support for Topic, Dataset parameters and VPC
* `service/rekognition`: Updates service API and documentation
  * This release adds a new attribute FaceOccluded. Additionally, you can now select attributes individually (e.g. ["DEFAULT", "FACE_OCCLUDED", "AGE_RANGE"] instead of ["ALL"]), which can reduce response time.
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3
* `service/sagemaker`: Updates service API
  * We added support for ml.inf2 and ml.trn1 family of instances on Amazon SageMaker for deploying machine learning (ML) models for Real-time and Asynchronous inference. You can use these instances to achieve high performance at a low cost for generative artificial intelligence (AI) models.
* `service/securityhub`: Updates service API, documentation, paginators, and examples
* `service/sqs`: Updates service API, documentation, and paginators
  * This release enables customers to call SQS using AWS JSON-1.0 protocol.

Release v1.44.256 (2023-05-03)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/ec2`: Updates service paginators
  * Adds an SDK paginator for GetNetworkInsightsAccessScopeAnalysisFindings
* `service/inspector2`: Updates service API and documentation
* `service/iottwinmaker`: Updates service API and documentation
* `service/network-firewall`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation
* `service/wellarchitected`: Updates service API and documentation

Release v1.44.255 (2023-05-02)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/connect`: Updates service API
* `service/ecs`: Updates service documentation
  * Documentation only update to address Amazon ECS tickets.
* `service/kendra`: Updates service API and documentation
  * AWS Kendra now supports configuring document fields/attributes via the GetQuerySuggestions API. You can now base query suggestions on the contents of document fields.
* `service/resiliencehub`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon Sagemaker Autopilot supports training models with sample weights and additional objective metrics.

Release v1.44.254 (2023-05-01)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/kms`: Updates service API, documentation, and examples
  * This release makes the NitroEnclave request parameter Recipient and the response field for CiphertextForRecipient available in AWS SDKs. It also adds the regex pattern for CloudHsmClusterId validation.

Release v1.44.253 (2023-04-28)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/athena`: Updates service API, documentation, and paginators
  * You can now use capacity reservations on Amazon Athena to run SQL queries on fully-managed compute capacity.
* `service/directconnect`: Updates service documentation
  * This release corrects the jumbo frames MTU from 9100 to 8500.
* `service/elasticfilesystem`: Updates service API
  * This release adds PAUSED and PAUSING state as a returned value for DescribeReplicationConfigurations response.
* `service/grafana`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * This release allows AWS IoT Core users to specify a TLS security policy when creating and updating AWS IoT Domain Configurations.
* `service/rekognition`: Updates service API and documentation
  * Added support for aggregating moderation labels by video segment timestamps for Stored Video Content Moderation APIs and added additional information about the job to all Stored Video Get API responses.
* `service/simspaceweaver`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation
* `service/workspaces`: Updates service documentation
  * Added Windows 11 to support Microsoft_Office_2019

Release v1.44.252 (2023-04-27)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for AMD SEV-SNP on EC2 instances.
* `service/emr-containers`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Added API support to initiate on-demand malware scan on specific resources.
* `service/iotdeviceadvisor`: Updates service API and documentation
* `service/kafka`: Updates service API, documentation, and paginators
* `service/lambda`: Updates service API
  * Add Java 17 (java17) support to AWS Lambda
* `service/marketplace-catalog`: Updates service paginators
* `service/osis`: Updates service documentation
* `service/qldb`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * Added ml.p4d.24xlarge and ml.p4de.24xlarge as supported instances for SageMaker Studio
* `service/xray`: Adds new service
  * Updated X-Ray documentation with Resource Policy API descriptions.

Release v1.44.251 (2023-04-26)
===

### Service Client Updates
* `service/osis`: Updates service API, documentation, paginators, and examples

Release v1.44.250 (2023-04-25)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/datasync`: Updates service API, documentation, and paginators
* `service/ds`: Updates service API and documentation
  * New field added in AWS Managed Microsoft AD DescribeSettings response and regex pattern update for UpdateSettings value.  Added length validation to RemoteDomainName.
* `service/pinpoint`: Updates service API, documentation, and examples
  * Adds support for journey runs and querying journey execution metrics based on journey runs. Adds execution metrics to campaign activities. Updates docs for Advanced Quiet Time.

Release v1.44.249 (2023-04-24)
===

### Service Client Updates
* `service/appflow`: Updates service API
* `service/ec2`: Updates service API and documentation
  * API changes to AWS Verified Access related to identity providers' information.
* `service/mediaconvert`: Updates service API and documentation
  * This release introduces a noise reduction pre-filter, linear interpolation deinterlace mode, video pass-through, updated default job settings, and expanded LC-AAC Stereo audio bitrate ranges.
* `service/rekognition`: Updates service API and documentation
  * Added new status result to Liveness session status.

Release v1.44.248 (2023-04-21)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * Documentation update to address various Amazon ECS tickets.
* `service/fms`: Updates service API, documentation, and paginators

Release v1.44.247 (2023-04-20)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Adds support for Hindi and Thai languages and additional Amazon Transcribe parameters to the StartMeetingTranscription API.
* `service/chime-sdk-media-pipelines`: Updates service API and documentation
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift supports creating Builds for Windows 2016 operating system.
* `service/guardduty`: Updates service API and documentation
  * This release adds support for the new Lambda Protection feature.
* `service/iot`: Updates service API and paginators
  * Support additional OTA states in GetOTAUpdate API
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Canvas adds ModelRegisterSettings support for CanvasAppSettings.
* `service/snowball`: Updates service API and documentation
  * Adds support for Amazon S3 compatible storage. AWS Snow Family customers can now use Amazon S3 compatible storage on Snowball Edge devices. Also adds support for V3_5S. This is a refreshed AWS Snowball Edge Storage Optimized device type with 210TB SSD (customer usable).
* `service/wafv2`: Updates service API and documentation

Release v1.44.246 (2023-04-19)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release supports the Account Setting "TagResourceAuthorization" that allows for enhanced Tagging security controls.
* `service/ram`: Updates service API, documentation, and paginators
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for the ImageId parameter of CreateCustomDBEngineVersion to RDS Custom for Oracle
* `service/s3`: Updates service API, documentation, and examples
  * Provides support for "Snow" Storage class.
* `service/s3control`: Adds new service
  * Provides support for overriding endpoint when region is "snow". This will enable bucket APIs for Amazon S3 Compatible storage on Snow Family devices.
* `service/secretsmanager`: Updates service documentation and examples
  * Documentation updates for Secrets Manager
* `service/securityhub`: Updates service examples

Release v1.44.245 (2023-04-17)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/drs`: Updates service API, documentation, and paginators
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for DynamoDB API
* `service/emr-serverless`: Updates service API and documentation
* `service/internetmonitor`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/lambda`: Updates service API
  * Add Python 3.10 (python3.10) support to AWS Lambda

Release v1.44.244 (2023-04-14)
===

### Service Client Updates
* `service/ecs`: Updates service documentation
  * This release supports  ephemeral storage for AWS Fargate Windows containers.
* `service/lambda`: Updates service API and documentation
  * This release adds SnapStart related exceptions to InvokeWithResponseStream API. IAM access related documentation is also added for this API.
* `service/migration-hub-refactor-spaces`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support of modifying the engine mode of database clusters.

Release v1.44.243 (2023-04-13)
===

### Service Client Updates
* `service/chime-sdk-voice`: Updates service API and documentation
* `service/mediaconnect`: Updates service API, documentation, and paginators

Release v1.44.242 (2023-04-12)
===

### Service Client Updates
* `service/groundstation`: Updates service API and documentation
* `service/managedblockchain`: Updates service documentation

Release v1.44.241 (2023-04-11)
===

### Service Client Updates
* `service/ecr-public`: Updates service API and documentation
* `service/emr-serverless`: Updates service API and documentation
* `service/eventbridge`: Updates service API and documentation
* `service/iot`: Adds new service
  * Re-release to remove unexpected API changes
* `service/iot-data`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.44.240 (2023-04-10)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release adds support for enabling FIPS compliance on Amazon ECS Fargate tasks
* `service/marketplace-catalog`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK now supports conversion of 608 paint-on captions to pop-on captions for SCC sources.
* `service/omics`: Updates service API
* `service/rekognition`: Updates service API and documentation
  * This release adds support for Face Liveness APIs in Amazon Rekognition. Updates UpdateStreamProcessor to return ResourceInUseException Exception. Minor updates to API documentation.

Release v1.44.239 (2023-04-07)
===

### Service Client Updates
* `service/dlm`: Adds new service
* `service/docdb`: Updates service API and documentation
  * This release adds a new parameter 'DBClusterParameterGroupName' to 'RestoreDBClusterFromSnapshot' API to associate the name of the DB cluster parameter group while performing restore.
* `service/fsx`: Updates service documentation
* `service/lambda`: Updates service API and documentation
  * This release adds a new Lambda InvokeWithResponseStream API to support streaming Lambda function responses. The release also adds a new InvokeMode parameter to Function Url APIs to control whether the response will be streamed or buffered.
* `service/quicksight`: Updates service API and documentation
  * This release has two changes: adding the OR condition to tag-based RLS rules in CreateDataSet and UpdateDataSet; adding RefreshSchedule and Incremental RefreshProperties operations for users to programmatically configure SPICE dataset ingestions.
* `service/redshift-data`: Updates service documentation
* `service/servicecatalog`: Updates service documentation
  * Updates description for property

Release v1.44.238 (2023-04-06)
===

### Service Client Updates
* `service/cloudformation`: Updates service waiters
  * Including UPDATE_COMPLETE as a failed status for DeleteStack waiter.
* `service/greengrassv2`: Updates service API and documentation
* `service/proton`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds and updates the SDK examples

Release v1.44.237 (2023-04-05)
===

### Service Client Updates
* `service/apprunner`: Updates service API
* `service/config`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * This is a document only updated to add information about Amazon Elastic Inference (EI).
* `service/identitystore`: Updates service documentation
* `service/ivs-realtime`: Updates service API
* `service/network-firewall`: Updates service API and documentation
* `service/servicecatalog`: Updates service API
  * removed incorrect product type value
* `service/vpc-lattice`: Updates service documentation

Release v1.44.236 (2023-04-04)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API, documentation, and waiters
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling
* `service/dataexchange`: Updates service API
* `service/ec2`: Updates service API
  * C6in, M6in, M6idn, R6in and R6idn bare metal instances are powered by 3rd Generation Intel Xeon Scalable processors and offer up to 200 Gbps of network bandwidth.
* `service/elastic-inference`: Updates service API and documentation
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Asynchronous Inference now allows customer's to receive failure model responses in S3 and receive success/failure model responses in SNS notifications.
* `service/wafv2`: Updates service API and documentation

Release v1.44.235 (2023-04-03)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Add support for database-level federation
* `service/lakeformation`: Updates service API and documentation
* `service/license-manager`: Updates service API and documentation
* `service/mwaa`: Updates service API and documentation
* `service/servicecatalog`: Updates service API and documentation
  * This release introduces Service Catalog support for Terraform open source. It enables 1. The notify* APIs to Service Catalog. These APIs are used by the terraform engine to notify the result of the provisioning engine execution. 2. Adds a new TERRAFORM_OPEN_SOURCE product type in CreateProduct API.
* `service/wafv2`: Updates service API and documentation

Release v1.44.234 (2023-03-31)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2 On Demand Capacity Reservations
* `service/internetmonitor`: Updates service API and documentation
* `service/resiliencehub`: Updates service documentation
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation
* `service/sms`: Updates service API
  * Deprecating AWS Server Migration Service.

Release v1.44.233 (2023-03-30)
===

### Service Client Updates
* `service/athena`: Updates service API
  * Make DefaultExecutorDpuSize and CoordinatorDpuSize  fields optional  in StartSession
* `service/autoscaling`: Updates service API, documentation, paginators, and examples
  * Amazon EC2 Auto Scaling now supports Elastic Load Balancing traffic sources with the AttachTrafficSources, DetachTrafficSources, and DescribeTrafficSources APIs. This release also introduces a new activity status, "WaitingForConnectionDraining", for VPC Lattice to the DescribeScalingActivities API.
* `service/batch`: Updates service API and documentation
  * This feature allows Batch on EKS to support configuration of Pod Labels through Metadata for Batch on EKS Jobs.
* `service/compute-optimizer`: Updates service API and documentation
* `service/drs`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for Tunnel Endpoint Lifecycle control, a new feature that provides Site-to-Site VPN customers with better visibility and control of their VPN tunnel maintenance updates.
* `service/elasticmapreduce`: Updates service API and documentation
  * Updated DescribeCluster and ListClusters API responses to include ErrorDetail that specifies error code, programmatically accessible error data,and an error message. ErrorDetail provides the underlying reason for cluster failure and recommends actions to simplify troubleshooting of EMR clusters.
* `service/glue`: Updates service API and documentation
  * This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `service/guardduty`: Updates service API, documentation, and paginators
  * Added EKS Runtime Monitoring feature support to existing detector, finding APIs and introducing new Coverage APIs
* `service/imagebuilder`: Updates service API, documentation, and paginators
* `service/ivs`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * AWS Kendra now supports featured results for a query.
* `service/network-firewall`: Updates service API, documentation, and paginators
* `service/sagemaker-geospatial`: Updates service API and documentation
* `service/vpc-lattice`: Adds new service
* `service/wellarchitected`: Updates service API, documentation, and paginators

### SDK Bugs

* `aws/session`: Fix `AWS_USE_FIPS_ENDPOINT` not being inferred on resolved credentials.
  * Defer resolving default credentials chain until after other config is resolved.

Release v1.44.232 (2023-03-29)
===

### Service Client Updates
* `service/opensearchserverless`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Add support for creating a read replica DB instance from a Multi-AZ DB cluster.

Release v1.44.231 (2023-03-28)
===

### Service Client Updates
* `service/iot-data`: Adds new service
* `service/ssm-contacts`: Updates service API, documentation, paginators, and examples
* `service/ssm-incidents`: Updates service API and documentation

Release v1.44.230 (2023-03-27)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.
* `service/chime-sdk-voice`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/connectparticipant`: Updates service documentation
* `service/iotwireless`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports ID3 tag insertion for audio only HLS output groups. AWS Elemental Link devices now support tagging.
* `service/sagemaker`: Updates service documentation
  * Fixed some improperly rendered links in SDK documentation.
* `service/securityhub`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Updates service API and documentation
* `service/voice-id`: Updates service API, documentation, and paginators

Release v1.44.229 (2023-03-24)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/monitoring`: Updates service documentation
  * Doc-only update to correct alarm actions list
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Added error code CreateCustomDBEngineVersionFault for when the create custom engine version for Custom engines fails.

Release v1.44.228 (2023-03-23)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * This feature allows Batch to support configuration of ephemeral storage size for jobs running on FARGATE
* `service/chime-sdk-identity`: Updates service API, documentation, and paginators
* `service/chime-sdk-media-pipelines`: Updates service API, documentation, and paginators
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/chime-sdk-voice`: Updates service API, documentation, and paginators
* `service/codeartifact`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Adds AutoEnableOrganizationMembers attribute to DescribeOrganizationConfiguration and UpdateOrganizationConfiguration APIs.
* `service/ivs-realtime`: Adds new service
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK now supports passthrough of ID3v2 tags for audio inputs to audio-only HLS outputs.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds two new APIs - CreateAutoMLJobV2 and DescribeAutoMLJobV2. Amazon SageMaker Notebook Instances now supports the ml.geospatial.interactive instance type.
* `service/servicediscovery`: Updates service API
* `service/textract`: Updates service API and documentation

Release v1.44.227 (2023-03-22)
===

### Service Client Updates
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/iottwinmaker`: Updates service API and documentation
* `service/networkmanager`: Updates service documentation
* `service/pipes`: Updates service API
* `service/resiliencehub`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release supports creating, updating, and deleting Patch Baselines for AmazonLinux2023, AlmaLinux.

Release v1.44.226 (2023-03-21)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/cleanrooms`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for AWS Network Firewall, AWS PrivateLink, and Gateway Load Balancers to Amazon VPC Reachability Analyzer, and it makes the path destination optional as long as a destination address in the filter at source is provided.
* `service/iotsitewise`: Updates service API and documentation
* `service/mgn`: Updates service API, documentation, and paginators

Release v1.44.225 (2023-03-20)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API, documentation, and examples
* `service/neptune`: Updates service API and documentation
  * This release makes following few changes. db-cluster-identifier is now a required parameter of create-db-instance. describe-db-cluster will now return PendingModifiedValues and GlobalClusterIdentifier fields in the response.
* `service/s3outposts`: Updates service API and documentation
* `service/workdocs`: Updates service API, documentation, and paginators
  * This release adds a new API, SearchResources, which enable users to search through metadata and content of folders, documents, document versions and comments in a WorkDocs site.

Release v1.44.224 (2023-03-17)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * S3 setting to create AWS Glue Data Catalog. Oracle setting to control conversion of timestamp column. Support for Kafka SASL Plain authentication. Setting to map boolean from PostgreSQL to Redshift. SQL Server settings to force lob lookup on inline LOBs and to control access of database logs.

Release v1.44.223 (2023-03-16)
===

### Service Client Updates
* `service/guardduty`: Updates service API, documentation, and paginators
  * Updated 9 APIs for feature enablement to reflect expansion of GuardDuty to features. Added new APIs and updated existing APIs to support RDS Protection GA.
* `service/resource-explorer-2`: Updates service documentation
* `service/runtime.sagemaker`: Updates service documentation

Release v1.44.222 (2023-03-15)
===

### Service Client Updates
* `service/migrationhubstrategy`: Updates service API and documentation
* `service/s3control`: Updates service API and documentation
  * Added support for S3 Object Lambda aliases.
* `service/securitylake`: Updates service API and documentation

### SDK Bugs

* `private/protocol`: Fix error message being elided in restJson errors.
  * Use request body error message for unknown errors when header is absent.

Release v1.44.221 (2023-03-14)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/dataexchange`: Updates service API and documentation
* `service/directconnect`: Updates service documentation
  * describe-direct-connect-gateway-associations includes a new status, updating, indicating that the association is currently in-process of updating.
* `service/ec2`: Updates service API and documentation
  * This release adds a new DnsOptions key (PrivateDnsOnlyForInboundResolverEndpoint) to CreateVpcEndpoint and ModifyVpcEndpoint APIs.
* `service/iam`: Updates service documentation
  * Documentation only updates to correct customer-reported issues
* `service/keyspaces`: Updates service API and documentation

### SDK Enhancements

* `aws/ec2metadata`: Added an option to disable fallback to IMDSv1. 
  * When set the SDK will no longer fallback to IMDSv1 when fetching a token fails. Use `aws.WithEC2MetadataDisableFallback` to enable.

Release v1.44.220 (2023-03-13)
===

### Service Client Updates
* `service/appintegrations`: Updates service API and documentation
* `service/lakeformation`: Updates service documentation
* `service/s3control`: Updates service API and documentation
  * Added support for cross-account Multi-Region Access Points. Added support for S3 Replication for S3 on Outposts.
* `service/tnb`: Updates service API and documentation
* `service/wisdom`: Updates service API and documentation

Release v1.44.219 (2023-03-10)
===

### Service Client Updates
* `service/ivschat`: Updates service API
* `service/secretsmanager`: Updates service API
  * The type definitions of SecretString and SecretBinary now have a minimum length of 1 in the model to match the exception thrown when you pass in empty values.

Release v1.44.218 (2023-03-09)
===

### Service Client Updates
* `service/codeartifact`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/evidently`: Updates service documentation
* `service/networkmanager`: Updates service documentation
* `service/quicksight`: Updates service API and documentation
  * This release has two changes: add state persistence feature for embedded dashboard and console in GenerateEmbedUrlForRegisteredUser API; add properties for hidden collapsed row dimensions in PivotTableOptions.
* `service/redshift-data`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Inference now allows SSM access to customer's model container by setting the "EnableSSMAccess" parameter for a ProductionVariant in CreateEndpointConfig API.
* `service/servicediscovery`: Updates service API
* `service/sesv2`: Updates service API and documentation

Release v1.44.217 (2023-03-08)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * A new field SubstatementType is added to GetQueryExecution API, so customers have an error free way to detect the query type and interpret the result.
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Adds deletion protection support to DynamoDB tables. Tables with deletion protection enabled cannot be deleted. Deletion protection is disabled by default, can be enabled via the CreateTable or UpdateTable APIs, and is visible in TableDescription. This setting is not replicated for Global Tables.
* `service/ec2`: Updates service API
  * Introducing Amazon EC2 C7g, M7g and R7g instances, powered by the latest generation AWS Graviton3 processors and deliver up to 25% better performance over Graviton2-based instances.
* `service/lakeformation`: Updates service API and documentation
* `service/mediapackage`: Updates service API and documentation
  * This release provides the date and time live resources were created.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/route53resolver`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * There needs to be a user identity to specify the SageMaker user who perform each action regarding the entity. However, these is a not a unified concept of user identity across SageMaker service that could be used today.

Release v1.44.216 (2023-03-07)
===

### Service Client Updates
* `service/dms`: Updates service API, documentation, and paginators
  * This release adds DMS Fleet Advisor Target Recommendation APIs and exposes functionality for DMS Fleet Advisor. It adds functionality to start Target Recommendation calculation.
* `service/location`: Updates service documentation

Release v1.44.215 (2023-03-06)
===

### Service Client Updates
* `service/account`: Updates service API and documentation
* `service/ivs`: Updates service documentation

Release v1.44.214 (2023-03-03)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for DynamoDB.
* `service/ec2`: Updates service API and documentation
  * This release adds support for a new boot mode for EC2 instances called 'UEFI Preferred'.
* `service/macie2`: Updates service documentation
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has improved handling for different input and output color space combinations.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive adds support for Nielsen watermark timezones.
* `service/transcribe`: Updates service API and documentation

Release v1.44.213 (2023-03-02)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * A recurring maintenance window is an optional configuration used for rolling out the job document to all devices in the target group observing a predetermined start time, duration, and frequency that the maintenance window occurs.
* `service/migrationhubstrategy`: Updates service API
* `service/organizations`: Updates service API and documentation
  * This release introduces a new reason code, ACCOUNT_CREATION_NOT_COMPLETE, to ConstraintViolationException in CreateOrganization API.
* `service/pi`: Updates service API and documentation
* `service/pipes`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Add a new field "EndpointMetrics" in SageMaker Inference Recommender "ListInferenceRecommendationsJobSteps" API response.

Release v1.44.212 (2023-03-01)
===

### Service Client Updates
* `service/pricing`: Updates service API, documentation, and paginators
* `service/s3outposts`: Updates service API, documentation, and paginators

Release v1.44.211 (2023-02-28)
===

### Service Client Updates
* `service/comprehend`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This release allows IMDS support to be set to v2-only on an existing AMI, so that all future instances launched from that AMI will use IMDSv2 by default.
* `service/kms`: Updates service documentation and examples
  * AWS KMS is deprecating the RSAES_PKCS1_V1_5 wrapping algorithm option in the GetParametersForImport API that is used in the AWS KMS Import Key Material feature. AWS KMS will end support for this wrapping algorithm by October 1, 2023.
* `service/lightsail`: Updates service API and documentation
  * This release adds Lightsail for Research feature support, such as GUI session access, cost estimates, stop instance on idle, and disk auto mount.
* `service/managedblockchain`: Updates service API and documentation
* `service/omics`: Updates service API and documentation

Release v1.44.210 (2023-02-27)
===

### Service Client Updates
* `service/devops-guru`: Updates service API and documentation
* `service/drs`: Updates service API and documentation
* `service/internetmonitor`: Adds new service
* `service/lambda`: Updates service API and documentation
  * This release adds the ability to create ESMs with Document DB change streams as event source. For more information see  https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html.
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has added support for HDR10 to SDR tone mapping, and animated GIF video input sources.
* `service/timestream-write`: Updates service API, documentation, and paginators

Release v1.44.209 (2023-02-24)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/connectcases`: Updates service API and documentation
* `service/redshift`: Updates service documentation
  * Documentation updates for Redshift API bringing it in line with IAM best practices.
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/servicecatalog`: Updates service documentation
  * Documentation updates for Service Catalog

Release v1.44.208 (2023-02-23)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release supports deleting Amazon ECS task definitions that are in the INACTIVE state.
* `service/grafana`: Updates service documentation
* `service/guardduty`: Updates service documentation
  * Updated API and data types descriptions for CreateFilter, UpdateFilter, and TriggerDetails.
* `service/iotwireless`: Updates service API and documentation
* `service/location`: Updates service API, documentation, and paginators
* `service/macie2`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.44.207 (2023-02-22)
===

### Service Client Updates
* `service/chime-sdk-voice`: Updates service API and documentation
* `service/cloudfront`: Updates service API and documentation
  * CloudFront now supports block lists in origin request policies so that you can forward all headers, cookies, or query string from viewer requests to the origin *except* for those specified in the block list.
* `service/datasync`: Updates service API
* `service/opensearch`: Updates service API, documentation, and paginators
* `service/rum`: Updates service API and documentation
* `service/ssm`: Updates service documentation
  * Document only update for Feb 2023

Release v1.44.206 (2023-02-21)
===

### Service Client Updates
* `service/quicksight`: Updates service API and documentation
  * S3 data sources now accept a custom IAM role.
* `service/resiliencehub`: Updates service API, documentation, and paginators
* `service/securityhub`: Updates service documentation
* `service/tnb`: Updates service API, documentation, paginators, and examples

Release v1.44.205 (2023-02-20)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/connect`: Updates service API and documentation

Release v1.44.204 (2023-02-17)
===

### Service Client Updates
* `service/apprunner`: Updates service API
* `service/glue`: Updates service API and documentation
  * Release of Delta Lake Data Lake Format for Glue Studio Service

Release v1.44.203 (2023-02-16)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * This release provides customers the ability to define a timeout period for procuring capacity during a resize operation for Instance Fleet clusters. Customers can specify this timeout using the ResizeSpecifications parameter supported by RunJobFlow, ModifyInstanceFleet and AddInstanceFleet APIs.
* `service/grafana`: Updates service API and documentation
* `service/ivs`: Updates service documentation
* `service/wafv2`: Updates service documentation

Release v1.44.202 (2023-02-15)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API
  * This release adds an InsufficientEncryptionPolicyException type to the StartImport endpoint
* `service/elasticfilesystem`: Updates service documentation
  * Documentation update for EFS to support IAM best practices.
* `service/frauddetector`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Fix DirectJDBCSource not showing up in CLI code gen
* `service/privatenetworks`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Database Activity Stream support for RDS for SQL Server.
* `service/wafv2`: Updates service API and documentation

Release v1.44.201 (2023-02-14)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * With this release customers can turn host maintenance on or off when allocating or modifying a supported dedicated host. Host maintenance is turned on by default for supported hosts.

Release v1.44.200 (2023-02-13)
===

### Service Client Updates
* `service/account`: Updates service API, documentation, and paginators
* `service/appconfigdata`: Updates service API and documentation
* `service/snowball`: Updates service API and documentation
  * Adds support for EKS Anywhere on Snowball. AWS Snow Family customers can now install EKS Anywhere service on Snowball Edge Compute Optimized devices.

Release v1.44.199 (2023-02-10)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * You can now either terminate/replace, ignore, or wait for EC2 Auto Scaling instances on standby or protected from scale in. Also, you can also roll back changes from a failed instance refresh.
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and waiters
  * Adds support for waiters that automatically poll for an imported snapshot until it reaches the completed state.
* `service/polly`: Updates service API
  * Amazon Polly adds two new neural Japanese voices - Kazuha, Tomoko
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds support for selecting algorithms in CreateAutoMLJob API.
* `service/sns`: Updates service documentation
  * This release adds support for SNS X-Ray active tracing as well as other updates.

Release v1.44.198 (2023-02-09)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service documentation
* `service/emr-containers`: Updates service API and documentation
* `service/evidently`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/migration-hub-refactor-spaces`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API and documentation
* `service/runtime.lex.v2`: Updates service API and documentation
* `service/workdocs`: Updates service documentation
  * Doc only update for the WorkDocs APIs.
* `service/workspaces`: Updates service documentation
  * Removed Windows Server 2016 BYOL and made changes based on IAM campaign.

Release v1.44.197 (2023-02-08)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/cloudfront`: Updates service API and documentation
  * CloudFront Origin Access Control extends support to AWS Elemental MediaStore origins.
* `service/glue`: Updates service API and documentation
  * DirectJDBCSource + Glue 4.0 streaming options
* `service/lakeformation`: Updates service API

Release v1.44.196 (2023-02-07)
===

### Service Client Updates
* `service/transfer`: Updates service documentation
  * Updated the documentation for the ImportCertificate API call, and added examples.

Release v1.44.195 (2023-02-06)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/customer-profiles`: Updates service API and documentation
* `service/frauddetector`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has added improved scene change detection capabilities and a bandwidth reduction filter, along with video quality enhancements, to the AVC encoder.
* `service/outposts`: Updates service API and documentation

Release v1.44.194 (2023-02-03)
===

### Service Client Updates
* `service/proton`: Updates service API and documentation
* `service/redshift`: Updates service documentation
  * Corrects descriptions of the parameters for the API operations RestoreFromClusterSnapshot, RestoreTableFromClusterSnapshot, and CreateCluster.

Release v1.44.193 (2023-02-02)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/connect`: Adds new service
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/keyspaces`: Adds new service
* `service/quicksight`: Updates service API and documentation
  * QuickSight support for Radar Chart and Dashboard Publish Options
* `service/redshift`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/sso-admin`: Adds new service

Release v1.44.192 (2023-02-01)
===

### Service Client Updates
* `service/devops-guru`: Updates service API and documentation
* `service/forecast`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/mediatailor`: Updates service API and documentation
* `service/sns`: Updates service documentation
  * Additional attributes added for set-topic-attributes.

Release v1.44.191 (2023-01-31)
===

### Service Client Updates
* `service/accessanalyzer`: Adds new service
* `service/appsync`: Updates service API and documentation
* `service/cloudtrail`: Updates service API and documentation
  * Add new "Channel" APIs to enable users to manage channels used for CloudTrail Lake integrations, and "Resource Policy" APIs to enable users to manage the resource-based permissions policy attached to a channel.
* `service/cloudtrail-data`: Adds new service
* `service/codeartifact`: Updates service API and documentation
* `service/connectparticipant`: Adds new service
* `service/ec2`: Updates service API and documentation
  * This launch allows customers to associate up to 8 IP addresses to their NAT Gateways to increase the limit on concurrent connections to a single destination by eight times from 55K to 440K.
* `service/groundstation`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * Added support for IoT Rules Engine Cloudwatch Logs action batch mode.
* `service/kinesis`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/opensearch`: Updates service API and documentation
* `service/outposts`: Adds new service
* `service/polly`: Updates service API
  * Amazon Polly adds two new neural American English voices - Ruth, Stephen
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now supports more completion criteria for Hyperparameter Optimization.
* `service/securityhub`: Updates service API and documentation
* `service/support`: Adds new service
  * This fixes incorrect endpoint construction when a customer is explicitly setting a region.

Release v1.44.190 (2023-01-30)
===

### Service Client Updates
* `service/clouddirectory`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/cloudformation`: Updates service API and documentation
  * This feature provides a method of obtaining which regions a stackset has stack instances deployed in.
* `service/discovery`: Updates service API
  * Update ImportName validation to 255 from the current length of 100
* `service/dlm`: Adds new service
* `service/ec2`: Updates service API and documentation
  * We add Prefix Lists as a new route destination option for LocalGatewayRoutes. This will allow customers to create routes to Prefix Lists. Prefix List routes will allow customers to group individual CIDR routes with the same target into a single route.
* `service/imagebuilder`: Adds new service
* `service/kafka`: Adds new service
* `service/mediaconvert`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/swf`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.

Release v1.44.189 (2023-01-27)
===

### Service Client Updates
* `service/application-autoscaling`: Adds new service
* `service/appstream`: Updates service waiters
  * Fixing the issue where Appstream waiters hang for fleet_started and fleet_stopped.
* `service/elasticbeanstalk`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/fis`: Adds new service
* `service/glacier`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/greengrass`: Adds new service
  * Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `service/greengrassv2`: Adds new service
* `service/mediatailor`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release supports running SageMaker Training jobs with container images that are in a private Docker registry.
* `service/serverlessrepo`: Adds new service

Release v1.44.188 (2023-01-26)
===

### Service Client Updates
* `service/eventbridge`: Updates service documentation
* `service/iotfleetwise`: Updates service API
* `service/s3`: Updates service examples
  * Allow FIPS to be used with path-style URLs.

Release v1.44.187 (2023-01-25)
===

### Service Client Updates
* `service/cloudformation`: Adds new service
  * Enabled FIPS aws-us-gov endpoints in SDK.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds new functionality that allows customers to provision IPv6 CIDR blocks through Amazon VPC IP Address Manager (IPAM) as well as allowing customers to utilize IPAM Resource Discovery APIs.
* `service/m2`: Updates service API and documentation
* `service/polly`: Updates service API
  * Add 5 new neural voices - Sergio (es-ES), Andres (es-MX), Remi (fr-FR), Adriano (it-IT) and Thiago (pt-BR).
* `service/redshift-serverless`: Updates service documentation
* `service/s3control`: Updates service API
  * Add additional endpoint tests for S3 Control. Fix missing endpoint parameters for PutBucketVersioning and GetBucketVersioning. Prior to this fix, those operations may have resulted in an invalid endpoint being resolved.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now decouples from Model Registry and could accept Model Name to invoke inference recommendations job; Inference Recommender now provides CPU/Memory Utilization metrics data in recommendation output.
* `service/sts`: Updates service documentation
  * Doc only change to update wording in a key topic

Release v1.44.186 (2023-01-24)
===

### Service Client Updates
* `service/databrew`: Adds new service
* `service/route53`: Updates service API
  * Amazon Route 53 now supports the Asia Pacific (Melbourne) Region (ap-southeast-4) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/ssm-sap`: Updates service API, documentation, and paginators

Release v1.44.185 (2023-01-23)
===

### Service Client Updates
* `service/lambda`: Updates service API and documentation
  * Release Lambda RuntimeManagementConfig, enabling customers to better manage runtime updates to their Lambda functions. This release adds two new APIs, GetRuntimeManagementConfig and PutRuntimeManagementConfig, as well as support on existing Create/Get/Update function APIs.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Inference now supports P4de instance types.

Release v1.44.184 (2023-01-20)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * C6in, M6in, M6idn, R6in and R6idn instances are powered by 3rd Generation Intel Xeon Scalable processors (code named Ice Lake) with an all-core turbo frequency of 3.5 GHz.
* `service/ivs`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * This release adds support for data bars in QuickSight table and increases pivot table field well limit.

Release v1.44.183 (2023-01-19)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/codeartifact`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/connectparticipant`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Adds SSM Parameter Resource Aliasing support to EC2 Launch Templates. Launch Templates can now store parameter aliases in place of AMI Resource IDs. CreateLaunchTemplateVersion and DescribeLaunchTemplateVersions now support a convenience flag, ResolveAlias, to return the resolved parameter value.
* `service/glue`: Updates service API and documentation
  * Release Glue Studio Hudi Data Lake Format for SDK/CLI
* `service/groundstation`: Updates service API, documentation, and waiters
* `service/logs`: Updates service API and documentation
  * Bug fix - Removed the regex pattern validation from CoralModel to avoid potential security issue.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive adds support for SCTE 35 preRollMilliSeconds.
* `service/opensearch`: Updates service API and documentation
* `service/panorama`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * HyperParameterTuningJobs now allow passing environment variables into the corresponding TrainingJobs

Release v1.44.182 (2023-01-18)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service documentation
  * Documentation updates for EFS access points limit increase
* `service/ivschat`: Updates service API
* `service/monitoring`: Updates service API and documentation
  * Enable cross-account streams in CloudWatch Metric Streams via Observability Access Manager.
* `service/wafv2`: Updates service documentation

Release v1.44.181 (2023-01-17)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/cloud9`: Updates service API
  * Added minimum value to AutomaticStopTimeMinutes parameter.
* `service/imagebuilder`: Updates service API and documentation
* `service/network-firewall`: Updates service API and documentation

Release v1.44.180 (2023-01-13)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2.
* `service/outposts`: Updates service API
* `service/resource-groups`: Updates service API and documentation

Release v1.44.179 (2023-01-12)
===

### Service Client Updates
* `service/cleanrooms`: Adds new service
* `service/lambda`: Updates service API and documentation
  * Add support for MaximumConcurrency parameter for SQS event source. Customers can now limit the maximum concurrent invocations for their SQS Event Source Mapping.
* `service/logs`: Updates service API and documentation
  * Bug fix: logGroupName is now not a required field in GetLogEvents, FilterLogEvents, GetLogGroupFields, and DescribeLogStreams APIs as logGroupIdentifier can be provided instead
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has added support for compact DASH manifest generation, audio normalization using TruePeak measurements, and the ability to clip the sample range in the color corrector.
* `service/secretsmanager`: Updates service documentation and examples
  * Update documentation for new ListSecrets and DescribeSecret parameters

Release v1.44.178 (2023-01-11)
===

### Service Client Updates
* `service/kendra`: Updates service API and documentation
  * This release adds support to new document types - RTF, XML, XSLT, MS_EXCEL, CSV, JSON, MD

Release v1.44.177 (2023-01-10)
===

### Service Client Updates
* `service/location`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for configuring allocated storage on the CreateDBInstanceReadReplica, RestoreDBInstanceFromDBSnapshot, and RestoreDBInstanceToPointInTime APIs.

Release v1.44.176 (2023-01-09)
===

### Service Client Updates
* `service/ecr-public`: Updates service API and documentation
* `service/kendra-ranking`: Adds new service
* `service/network-firewall`: Updates service API and documentation
* `service/ram`: Adds new service
* `service/workspaces-web`: Updates service API and documentation

Release v1.44.175 (2023-01-06)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/auditmanager`: Updates service API and documentation

Release v1.44.174 (2023-01-05)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API and documentation
* `service/apprunner`: Updates service API and documentation
* `service/connect`: Updates service API
* `service/emr-serverless`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Amazon Lightsail.
* `service/mwaa`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for specifying which certificate authority (CA) to use for a DB instance's server certificate during DB instance creation, as well as other CA enhancements.

Release v1.44.173 (2023-01-04)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/logs`: Updates service documentation
  * Update to remove sequenceToken as a required field in PutLogEvents calls.
* `service/ssm`: Updates service API and documentation
  * Adding support for QuickSetup Document Type in Systems Manager

Release v1.44.172 (2023-01-03)
===

### Service Client Updates
* `service/securitylake`: Updates service API and documentation

Release v1.44.171 (2022-12-30)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Extend response headers policy to support removing headers from viewer responses
* `service/iotfleetwise`: Updates service documentation

Release v1.44.170 (2022-12-29)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/elasticmapreduce`: Updates service API and documentation
  * Added GetClusterSessionCredentials API to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters with runtime roles and AWS Lake Formation-based access control for Apache Spark, Apache Hive, and Presto queries.
* `service/secretsmanager`: Updates service API and documentation
  * Added owning service filter, include planned deletion flag, and next rotation date response parameter in ListSecrets.
* `service/wisdom`: Updates service API and documentation

Release v1.44.169 (2022-12-28)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * This release allows you to modify the encryption in transit setting, for existing Redis clusters. You can now change the TLS configuration of your Redis clusters without the need to re-build or re-provision the clusters or impact application availability.
* `service/network-firewall`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for Custom Engine Version (CEV) on RDS Custom SQL Server.
* `service/route53-recovery-control-config`: Updates service documentation and paginators

Release v1.44.168 (2022-12-27)
===

### Service Client Updates
* `service/memorydb`: Updates service API, documentation, and paginators
* `service/transfer`: Updates service API
  * Add additional operations to throw ThrottlingExceptions

Release v1.44.167 (2022-12-23)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/connectparticipant`: Updates service API and documentation
* `service/detective`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/inspector2`: Updates service API

Release v1.44.166 (2022-12-22)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API, documentation, and paginators
* `service/connect`: Updates service API and documentation
* `service/iotdeviceadvisor`: Updates service API and documentation
* `service/kinesis-video-webrtc-storage`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Add support for managing master user password in AWS Secrets Manager for the DBInstance and DBCluster.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager

Release v1.44.165 (2022-12-21)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/connectparticipant`: Updates service API
* `service/license-manager-linux-subscriptions`: Adds new service
* `service/macie2`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * This release enables adding RStudio Workbench support to an existing Amazon SageMaker Studio domain. It allows setting your RStudio on SageMaker environment configuration parameters and also updating the RStudioConnectUrl and RStudioPackageManagerUrl parameters for existing domains
* `service/scheduler`: Updates service API
* `service/ssm`: Updates service documentation
  * Doc-only updates for December 2022.
* `service/support`: Updates service documentation
  * Documentation updates for the AWS Support API
* `service/transfer`: Updates service API and documentation
  * This release adds support for Decrypt as a workflow step type.

Release v1.44.164 (2022-12-20)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Adds isCancelled and isTerminated to DescribeJobs response.
* `service/ec2`: Updates service API, documentation, and paginators
  * Adds support for pagination in the EC2 DescribeImages API.
* `service/lookoutequipment`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * This release adds support for two new features to AWS Elemental MediaLive. First, you can now burn-in timecodes to your MediaLive outputs. Second, we now now support the ability to decode Dolby E audio when it comes in on an input.
* `service/nimble`: Updates service API, documentation, and paginators
* `service/resource-explorer-2`: Updates service documentation
* `service/route53domains`: Updates service API and documentation
  * Use Route 53 domain APIs to change owner, create/delete DS record, modify IPS tag, resend authorization. New: AssociateDelegationSignerToDomain, DisassociateDelegationSignerFromDomain, PushDomain, ResendOperationAuthorization. Updated: UpdateDomainContact, ListOperations, CheckDomainTransferability.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds support for new objective metrics in CreateAutoMLJob API.
* `service/transcribe`: Updates service API

Release v1.44.163 (2022-12-19)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Add missed InvalidRequestException in GetCalculationExecutionCode,StopCalculationExecution APIs. Correct required parameters (Payload and Type) in UpdateNotebook API. Change Notebook size from 15 Mb to 10 Mb.
* `service/ecs`: Updates service API and documentation
  * This release adds support for alarm-based rollbacks in ECS, a new feature that allows customers to add automated safeguards for Amazon ECS service rolling updates.
* `service/kinesis-video-webrtc-storage`: Adds new service
* `service/kinesisvideo`: Updates service API, documentation, and paginators
  * Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Add support for --enable-customer-owned-ip to RDS create-db-instance-read-replica API for RDS on Outposts.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * AWS Sagemaker - Sagemaker Images now supports Aliases as secondary identifiers for ImageVersions. SageMaker Images now supports additional metadata for ImageVersions for better images management.

Release v1.44.162 (2022-12-16)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/cloudfront`: Updates service documentation
  * Updated documentation for CloudFront
* `service/datasync`: Updates service API and documentation
* `service/elasticfilesystem`: Updates service documentation
  * General documentation updates for EFS.
* `service/guardduty`: Updates service documentation
  * This release provides the valid characters for the Description and Name field.
* `service/iotfleetwise`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * AWS sagemaker - Features: This release adds support for random seed, it's an integer value used to initialize a pseudo-random number generator. Setting a random seed will allow the hyperparameter tuning search strategies to produce more consistent configurations for the same tuning job.

Release v1.44.161 (2022-12-15)
===

### Service Client Updates
* `service/backup-gateway`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release adds support for container port ranges in ECS, a new capability that allows customers to provide container port ranges to simplify use cases where multiple ports are in use in a container. This release updates TaskDefinition mutation APIs and the Task description APIs.
* `service/eks`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * This release adds support for AWS Glue Crawler with native DeltaLake tables, allowing Crawlers to classify Delta Lake format tables and catalog them for query engines to query against.
* `service/kinesis`: Updates service API, documentation, and paginators
  * Added StreamARN parameter for Kinesis Data Streams APIs. Added a new opaque pagination token for ListStreams. SDKs will auto-generate Account Endpoint when accessing Kinesis Data Streams.
* `service/location`: Updates service documentation
* `service/m2`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now allows customers to load tests their models on various instance types using private VPC.
* `service/securityhub`: Updates service API and documentation
* `service/translate`: Updates service API and documentation

Release v1.44.160 (2022-12-14)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/monitoring`: Updates service API and documentation
  * Adding support for Metrics Insights Alarms
* `service/networkmanager`: Updates service API and documentation
* `service/redshift-data`: Updates service API and documentation
* `service/sagemaker-metrics`: Updates service documentation

Release v1.44.159 (2022-12-13)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API and documentation
  * Merging mainline branch for service model into mainline release branch. There are no new APIs.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This deployment adds ClientPasswordAuthType field to the Auth structure of the DBProxy.

Release v1.44.158 (2022-12-12)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release updates DescribeFpgaImages to show supported instance types of AFIs in its response.
* `service/kinesisvideo`: Updates service API and documentation
  * This release adds support for public preview of Kinesis Video Stream at Edge enabling customers to provide configuration for the Kinesis Video Stream EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on configured schedule.
* `service/lookoutvision`: Updates service documentation
* `service/migration-hub-refactor-spaces`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Update the RDS API model to support copying option groups during the CopyDBSnapshot operation
* `service/rekognition`: Updates service API and documentation
  * Adds support for "aliases" and "categories", inclusion and exclusion filters for labels and label categories, and aggregating labels by video segment timestamps for Stored Video Label Detection APIs.
* `service/sagemaker-metrics`: Adds new service
* `service/wafv2`: Updates service documentation

Release v1.44.157 (2022-12-09)
===

### Service Client Updates
* `service/iotfleetwise`: Updates service API and documentation
* `service/logs`: Updates service documentation
  * Doc-only update for CloudWatch Logs, for Tagging Permissions clarifications
* `service/medialive`: Updates service API and documentation
  * Link devices now support buffer size (latency) configuration. A higher latency value means a longer delay in transmitting from the device to MediaLive, but improved resiliency. A lower latency value means a shorter delay, but less resiliency.
* `service/mediapackage-vod`: Updates service API and documentation

Release v1.44.156 (2022-12-08)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Adds support for metric math for target tracking scaling policies, saving you the cost and effort of publishing a custom metric to CloudWatch. Also adds support for VPC Lattice by adding the Attach/Detach/DescribeTrafficSources APIs and a new health check type to the CreateAutoScalingGroup API.
* `service/iottwinmaker`: Updates service API, documentation, and paginators
* `service/migrationhubstrategy`: Updates service API and documentation

Release v1.44.155 (2022-12-07)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/cloudfront`: Updates service API and documentation
  * Introducing UpdateDistributionWithStagingConfig that can be used to promote the staging configuration to the production.
* `service/eks`: Updates service API and documentation
* `service/kms`: Updates service documentation and examples
  * Updated examples and exceptions for External Key Store (XKS).

Release v1.44.154 (2022-12-06)
===

### Service Client Updates
* `service/billingconductor`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Endpoint Ruleset update: Use http instead of https for the "local" region.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds the BlueGreenDeploymentNotFoundFault to the AddTagsToResource, ListTagsForResource, and RemoveTagsFromResource operations.
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation
* `service/streams.dynamodb`: Adds new service

Release v1.44.153 (2022-12-05)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2.
* `service/ivschat`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds the InvalidDBInstanceStateFault to the RestoreDBClusterFromSnapshot operation.
* `service/transcribe`: Updates service API

Release v1.44.152 (2022-12-02)
===

### Service Client Updates
* `service/appsync`: Updates service documentation
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS
* `service/fms`: Updates service API
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has added support for configurable ID3 eMSG box attributes and the ability to signal them with InbandEventStream tags in DASH and CMAF outputs.
* `service/medialive`: Updates service API and documentation
  * Updates to Event Signaling and Management (ESAM) API and documentation.
* `service/polly`: Updates service API
  * Add language code for Finnish (fi-FI)
* `service/proton`: Updates service API
* `service/redshift-serverless`: Updates service API, documentation, and paginators
* `service/sns`: Updates service documentation
  * This release adds the message payload-filtering feature to the SNS Subscribe, SetSubscriptionAttributes, and GetSubscriptionAttributes API actions

Release v1.44.151 (2022-12-01)
===

### Service Client Updates
* `service/comprehend`: Updates service API, documentation, and paginators
* `service/gamelift`: Updates service API, documentation, and paginators
  * GameLift introduces a new feature, GameLift Anywhere. GameLift Anywhere allows you to integrate your own compute resources with GameLift. You can also use GameLift Anywhere to iteratively test your game servers without uploading the build to GameLift for every iteration.
* `service/pipes`: Updates service API, documentation, paginators, and examples
* `service/states`: Updates service API, documentation, and paginators
  * This release adds support for the AWS Step Functions Map state in Distributed mode. The changes include a new MapRun resource and several new and modified APIs.

Release v1.44.150 (2022-11-30)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/athena`: Updates service API, documentation, and paginators
  * This release includes support for using Apache Spark in Amazon Athena.
* `service/dataexchange`: Updates service API and documentation
* `service/docdb-elastic`: Adds new service
* `service/glue`: Updates service API, documentation, and paginators
  * This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `service/s3control`: Updates service API and documentation
  * Amazon S3 now supports cross-account access points. S3 bucket owners can now allow trusted AWS accounts to create access points associated with their bucket.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Added Models as part of the Search API. Added Model shadow deployments in realtime inference, and shadow testing in managed inference. Added support for shared spaces, geospatial APIs, Model Cards, AutoMLJobStep in pipelines, Git repositories on user profiles and domains, Model sharing in Jumpstart.
* `service/sagemaker-geospatial`: Adds new service

Release v1.44.149 (2022-11-29)
===

Release v1.44.148 (2022-11-29)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds support for AWS Verified Access and the Hpc6id Amazon EC2 compute optimized instance type, which features 3rd generation Intel Xeon Scalable processors.
  * This release adds support for AWS Verified Access and the Hpc6id Amazon EC2 compute optimized instance type, which features 3rd generation Intel Xeon Scalable processors.
* `service/firehose`: Updates service API and documentation
  * Allow support for the Serverless offering for Amazon OpenSearch Service as a Kinesis Data Firehose delivery destination.
  * Allow support for the Serverless offering for Amazon OpenSearch Service as a Kinesis Data Firehose delivery destination.
* `service/kms`: Updates service API, documentation, paginators, and examples
  * AWS KMS introduces the External Key Store (XKS), a new feature for customers who want to protect their data with encryption keys stored in an external key management system under their control.
  * AWS KMS introduces the External Key Store (XKS), a new feature for customers who want to protect their data with encryption keys stored in an external key management system under their control.
* `service/omics`: Updates service API, documentation, waiters, paginators, and examples
* `service/opensearchserverless`: Adds new service
* `service/securitylake`: Adds new service
* `service/simspaceweaver`: Adds new service

Release v1.44.147 (2022-11-29)
===

### Service Client Updates
* `service/arc-zonal-shift`: Adds new service
* `service/compute-optimizer`: Updates service API and documentation
* `service/config`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * Introduces ENA Express, which uses AWS SRD and dynamic routing to increase throughput and minimize latency, adds support for trust relationships between Reachability Analyzer and AWS Organizations to enable cross-account analysis, and adds support for Infrastructure Performance metric subscriptions.
* `service/eks`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * This release allows the creation of Custom Visual Transforms (Dynamic Transforms) to be created via AWS Glue CLI/SDK.
* `service/inspector2`: Updates service API and documentation
* `service/lambda`: Updates service API, documentation, and waiters
  * Adds support for Lambda SnapStart, which helps improve the startup performance of functions. Customers can now manage SnapStart based functions via CreateFunction and UpdateFunctionConfiguration APIs
* `service/license-manager-user-subscriptions`: Updates service API and documentation
* `service/macie2`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * This release adds new Describe APIs and updates Create and Update APIs to support the data model for Dashboards, Analyses, and Templates.
* `service/s3control`: Updates service API and documentation
  * Added two new APIs to support Amazon S3 Multi-Region Access Point failover controls: GetMultiRegionAccessPointRoutes and SubmitMultiRegionAccessPointRoutes. The failover control APIs are supported in the following Regions: us-east-1, us-west-2, eu-west-1, ap-southeast-2, and ap-northeast-1.
* `service/securityhub`: Updates service API and documentation

Release v1.44.146 (2022-11-28)
===

### Service Client Updates
* `service/backup`: Updates service API, documentation, and paginators
* `service/drs`: Updates service API and documentation
* `service/ecs`: Updates service API, documentation, and paginators
  * This release adds support for ECS Service Connect, a new capability that simplifies writing and operating resilient distributed applications. This release updates the TaskDefinition, Cluster, Service mutation APIs with Service connect constructs and also adds a new ListServicesByNamespace API.
* `service/elasticfilesystem`: Updates service API and documentation
  * This release adds elastic as a new ThroughputMode value for EFS file systems and adds AFTER_1_DAY as a value for TransitionToIARules.
* `service/iot`: Updates service API and documentation
  * Job scheduling enables the scheduled rollout of a Job with start and end times and a customizable end behavior when end time is reached. This is available for continuous and snapshot jobs. Added support for MQTT5 properties to AWS IoT TopicRule Republish Action.
* `service/iot-data`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports preview of table information from HTML tables in the search results. The most relevant cells with their corresponding rows, columns are displayed as a preview in the search result. The most relevant table cell or cells are also highlighted in table preview.
* `service/logs`: Updates service API and documentation
  * Updates to support CloudWatch Logs data protection and CloudWatch cross-account observability
* `service/mgn`: Updates service API, documentation, and paginators
* `service/monitoring`: Updates service API, documentation, and paginators
  * Adds cross-account support to the GetMetricData API. Adds cross-account support to the ListMetrics API through the usage of the IncludeLinkedAccounts flag and the new OwningAccounts field.
* `service/oam`: Updates service API, documentation, paginators, and examples
* `service/organizations`: Updates service API and documentation
  * This release introduces delegated administrator for AWS Organizations, a new feature to help you delegate the management of your Organizations policies, enabling you to govern your AWS organization in a decentralized way. You can now allow member accounts to manage Organizations policies.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release enables new Aurora and RDS feature called Blue/Green Deployments that makes updates to databases safer, simpler and faster.
* `service/textract`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.44.145 (2022-11-23)
===

### Service Client Updates
* `service/grafana`: Updates service API and documentation
* `service/rbin`: Updates service API and documentation

Release v1.44.144 (2022-11-22)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API and documentation

Release v1.44.143 (2022-11-21)
===

### Service Client Updates
* `service/route53`: Updates service API
  * Amazon Route 53 now supports the Asia Pacific (Hyderabad) Region (ap-south-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

Release v1.44.142 (2022-11-18)
===

### Notes
* Removes old model file for ssm sap and uses the new model file to regenerate client

Release v1.44.141 (2022-11-18)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/auditmanager`: Updates service API and documentation
* `service/chime-sdk-voice`: Adds new service
* `service/cloudfront`: Updates service API and documentation
  * CloudFront API support for staging distributions and associated traffic management policies.
* `service/connect`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Updated minor fixes for DynamoDB documentation.
* `service/ec2`: Updates service API and documentation
  * This release adds support for copying an Amazon Machine Image's tags when copying an AMI.
* `service/glue`: Updates service API and documentation
  * AWSGlue Crawler - Adding support for Table and Column level Comments with database level datatypes for JDBC based crawler.
* `service/iot-roborunner`: Adds new service
* `service/quicksight`: Updates service API, documentation, and paginators
  * This release adds the following: 1) Asset management for centralized assets governance 2) QuickSight Q now supports public embedding 3) New Termination protection flag to mitigate accidental deletes 4) Athena data sources now accept a custom IAM role 5) QuickSight supports connectivity to Databricks
* `service/sagemaker`: Updates service API and documentation
  * Added DisableProfiler flag as a new field in ProfilerConfig
* `service/servicecatalog`: Updates service API and documentation
  * This release 1. adds support for Principal Name Sharing with Service Catalog portfolio sharing. 2. Introduces repo sourced products which are created and managed with existing SC APIs. These products are synced to external repos and auto create new product versions based on changes in the repo.
* `service/ssm-sap`: Updates service API, documentation, paginators, and examples
* `service/states`: Updates service API and documentation
  * This release adds support for using Step Functions service integrations to invoke any cross-account AWS resource, even if that service doesn't support resource-based policies or cross-account calls. See https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html
* `service/streams.dynamodb`: Updates service documentation
* `service/transfer`: Updates service API and documentation
  * Adds a NONE encryption algorithm type to AS2 connectors, providing support for skipping encryption of the AS2 message body when a HTTPS URL is also specified.

Release v1.44.140 (2022-11-17)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/appflow`: Updates service API and documentation
* `service/appsync`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * Adds support for Internet Protocol Version 6 (IPv6) on DMS Replication Instances
* `service/ec2`: Updates service API and documentation
  * This release adds a new optional parameter "privateIpAddress" for the CreateNatGateway API. PrivateIPAddress will allow customers to select a custom Private IPv4 address instead of having it be auto-assigned.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/emr-serverless`: Updates service API and documentation
* `service/ivschat`: Updates service API, documentation, and paginators
* `service/lambda`: Updates service API and documentation
  * Add Node 18 (nodejs18.x) support to AWS Lambda.
* `service/personalize`: Updates service API, documentation, and paginators
* `service/polly`: Updates service API
  * Add two new neural voices - Ola (pl-PL) and Hala (ar-AE).
* `service/rum`: Updates service API and documentation
* `service/s3control`: Updates service API and documentation
  * Added 34 new S3 Storage Lens metrics to support additional customer use cases.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager.
* `service/securityhub`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Updates service API and documentation
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.
* `service/textract`: Updates service API and documentation
* `service/workspaces`: Updates service API and documentation
  * The release introduces CreateStandbyWorkspaces, an API that allows you to create standby WorkSpaces associated with a primary WorkSpace in another Region. DescribeWorkspaces now includes related WorkSpaces properties. DescribeWorkspaceBundles and CreateWorkspaceBundle now return more bundle details.

Release v1.44.139 (2022-11-16)
===

### Service Client Updates
* `service/batch`: Updates service documentation
  * Documentation updates related to Batch on EKS
* `service/billingconductor`: Updates service API and documentation
* `service/cloudformation`: Updates service API
  * Added UnsupportedTarget HandlerErrorCode for use with CFN Resource Hooks
* `service/comprehendmedical`: Updates service API
* `service/connect`: Updates service API and documentation
* `service/eks`: Updates service API and documentation
* `service/elasticache`: Updates service API and documentation
  * for Redis now supports AWS Identity and Access Management authentication access to Redis clusters starting with redis-engine version 7.0
* `service/iottwinmaker`: Updates service API, documentation, and paginators
* `service/personalize-events`: Updates service API and documentation
* `service/proton`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for container databases (CDBs) to Amazon RDS Custom for Oracle. A CDB contains one PDB at creation. You can add more PDBs using Oracle SQL. You can also customize your database installation by setting the Oracle base, Oracle home, and the OS user name and group.
* `service/ssm`: Updates service API, documentation, and paginators
  * This release adds support for cross account access in CreateOpsItem, UpdateOpsItem and GetOpsItem. It introduces new APIs to setup resource policies for SSM resources: PutResourcePolicy, GetResourcePolicies and DeleteResourcePolicy.
* `service/ssm-incidents`: Updates service API and documentation
* `service/transfer`: Updates service API
  * Allow additional operations to throw ThrottlingException
* `service/xray`: Updates service API, documentation, and paginators
  * This release adds new APIs - PutResourcePolicy, DeleteResourcePolicy, ListResourcePolicies for supporting resource based policies for AWS X-Ray.

Release v1.44.138 (2022-11-15)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/greengrassv2`: Updates service API and documentation
* `service/route53`: Updates service API
  * Amazon Route 53 now supports the Europe (Spain) Region (eu-south-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/ssmsap`: Updates service API, documentation, paginators, and examples
* `service/workspaces`: Updates service API and documentation
  * This release introduces ModifyCertificateBasedAuthProperties, a new API that allows control of certificate-based auth properties associated with a WorkSpaces directory. The DescribeWorkspaceDirectories API will now additionally return certificate-based auth properties in its responses.

Release v1.44.137 (2022-11-14)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation
* `service/managedblockchain`: Updates service documentation
* `service/proton`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for restoring an RDS Multi-AZ DB cluster snapshot to a Single-AZ deployment or a Multi-AZ DB instance deployment.
* `service/workdocs`: Updates service API and documentation
  * Added 2 new document related operations, DeleteDocumentVersion and RestoreDocumentVersions.
* `service/xray`: Updates service API and documentation
  * This release enhances GetServiceGraph API to support new type of edge to represent links between SQS and Lambda in event-driven applications.

Release v1.44.136 (2022-11-11)
===

### Service Client Updates
* `service/glue`: Updates service documentation
  * Added links related to enabling job bookmarks.
* `service/iot`: Updates service API and documentation
  * This release add new api listRelatedResourcesForAuditFinding and new member type IssuerCertificates for Iot device device defender Audit.
* `service/license-manager`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/rekognition`: Updates service API and documentation
  * Adding support for ImageProperties feature to detect dominant colors and image brightness, sharpness, and contrast, inclusion and exclusion filters for labels and label categories, new fields to the API response, "aliases" and "categories"
* `service/securityhub`: Updates service documentation
* `service/ssm-incidents`: Updates service API and documentation

Release v1.44.135 (2022-11-10)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * This release adds a new price capacity optimized allocation strategy for Spot Instances to help customers optimize provisioning of Spot Instances via EC2 Auto Scaling, EC2 Fleet, and Spot Fleet. It allocates Spot Instances based on both spare capacity availability and Spot Instance price.
* `service/ec2`: Updates service API and documentation
  * This release adds a new price capacity optimized allocation strategy for Spot Instances to help customers optimize provisioning of Spot Instances via EC2 Auto Scaling, EC2 Fleet, and Spot Fleet. It allocates Spot Instances based on both spare capacity availability and Spot Instance price.
* `service/ecs`: Updates service API, documentation, and examples
  * This release adds support for task scale-in protection with updateTaskProtection and getTaskProtection APIs. UpdateTaskProtection API can be used to protect a service managed task from being terminated by scale-in events and getTaskProtection API to get the scale-in protection status of a task.
* `service/es`: Updates service API and documentation
  * Amazon OpenSearch Service now offers managed VPC endpoints to connect to your Amazon OpenSearch Service VPC-enabled domain in a Virtual Private Cloud (VPC). This feature allows you to privately access OpenSearch Service domain without using public IPs or requiring traffic to traverse the Internet.
* `service/resource-explorer-2`: Updates service documentation
* `service/scheduler`: Updates service API, documentation, paginators, and examples

Release v1.44.134 (2022-11-09)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/connectcases`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Amazon EC2 Trn1 instances, powered by AWS Trainium chips, are purpose built for high-performance deep learning training. u-24tb1.112xlarge and u-18tb1.112xlarge High Memory instances are purpose-built to run large in-memory databases.
* `service/groundstation`: Updates service API, documentation, and paginators
* `service/mediapackage-vod`: Updates service API and documentation
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.44.133 (2022-11-08)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * Support added for requesting elliptic curve certificate key algorithm types P-256 (EC_prime256v1) and P-384 (EC_secp384r1).
* `service/billingconductor`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This release enables sharing of EC2 Placement Groups across accounts and within AWS Organizations using Resource Access Manager
* `service/fms`: Updates service API and documentation
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Amazon Lightsail to automate the delegation of domains registered through Amazon Route 53 to Lightsail DNS management and to automate record creation for DNS validation of Lightsail SSL/TLS certificates.
* `service/opensearch`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new voices: Elin (sv-SE), Ida (nb-NO), Laura (nl-NL) and Suvi (fi-FI). They are available as neural voices only.
* `service/resource-explorer-2`: Adds new service
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Europe (Zurich) Region (eu-central-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

Release v1.44.132 (2022-11-07)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * Adds support for using Query Result Reuse
* `service/autoscaling`: Updates service API and documentation
  * This release adds support for two new attributes for attribute-based instance type selection - NetworkBandwidthGbps and AllowedInstanceTypes.
* `service/cloudtrail`: Updates service API and documentation
  * This release includes support for configuring a delegated administrator to manage an AWS Organizations organization CloudTrail trails and event data stores, and AWS Key Management Service encryption of CloudTrail Lake event data stores.
* `service/ec2`: Updates service API and documentation
  * This release adds support for two new attributes for attribute-based instance type selection - NetworkBandwidthGbps and AllowedInstanceTypes.
* `service/elasticache`: Updates service API and documentation
  * Added support for IPv6 and dual stack for Memcached and Redis clusters. Customers can now launch new Redis and Memcached clusters with IPv6 and dual stack networking support.
* `service/mediaconvert`: Updates service API and documentation
  * The AWS Elemental MediaConvert SDK has added support for setting the SDR reference white point for HDR conversions and conversion of HDR10 to DolbyVision without mastering metadata.
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/ssm`: Updates service API and documentation
  * This release includes support for applying a CloudWatch alarm to multi account multi region Systems Manager Automation
* `service/wafv2`: Updates service documentation
* `service/wellarchitected`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * This release adds protocols attribute to workspaces properties data type. This enables customers to migrate workspaces from PC over IP (PCoIP) to WorkSpaces Streaming Protocol (WSP) using create and modify workspaces public APIs.

Release v1.44.131 (2022-11-04)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds API support for the recipient of an AMI account share to remove shared AMI launch permissions.
* `service/emr-containers`: Updates service API, documentation, and paginators
* `service/logs`: Updates service documentation
  * Doc-only update for bug fixes and support of export to buckets encrypted with SSE-KMS

Release v1.44.130 (2022-11-03)
===

### Service Client Updates
* `service/memorydb`: Updates service API and documentation
* `service/sagemaker`: Updates service API
  * Amazon SageMaker now supports running training jobs on ml.trn1 instance types.

Release v1.44.129 (2022-11-02)
===

### Service Client Updates
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/s3control`: Updates service API and documentation
  * S3 on Outposts launches support for Lifecycle configuration for Outposts buckets. With S3 Lifecycle configuration, you can mange objects so they are stored cost effectively. You can manage objects using size-based rules and specify how many noncurrent versions bucket will retain.
* `service/sagemaker`: Updates service API and documentation
  * This release updates Framework model regex for ModelPackage to support new Framework version xgboost, sklearn.
* `service/ssm-incidents`: Updates service API and documentation

Release v1.44.128 (2022-11-01)
===

### Service Client Updates
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Relational Database Service - This release adds support for configuring Storage Throughput on RDS database instances.
* `service/textract`: Updates service API and documentation

Release v1.44.127 (2022-10-31)
===

### Service Client Updates
* `service/apprunner`: Updates service API, documentation, and paginators
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * Elastic IP transfer is a new Amazon VPC feature that allows you to transfer your Elastic IP addresses from one AWS Account to another.
* `service/iot`: Updates service API and documentation
  * This release adds the Amazon Location action to IoT Rules Engine.
* `service/logs`: Updates service API and documentation
  * SDK release to support tagging for destinations and log groups with TagResource. Also supports tag on create with PutDestination.
* `service/sesv2`: Updates service API, documentation, and paginators
* `service/textract`: Updates service API and documentation

Release v1.44.126 (2022-10-28)
===

### Service Client Updates
* `service/apprunner`: Updates service API
* `service/appstream`: Updates service API and documentation
  * This release includes CertificateBasedAuthProperties in CreateDirectoryConfig and UpdateDirectoryConfig.
* `service/cloud9`: Updates service documentation
  * Update to the documentation section of the Cloud9 API Reference guide.
* `service/cloudformation`: Updates service API and documentation
  * This release adds more fields to improves visibility of AWS CloudFormation StackSets information in following APIs: ListStackInstances, DescribeStackInstance, ListStackSetOperationResults, ListStackSetOperations, DescribeStackSetOperation.
* `service/gamesparks`: Updates service API
* `service/mediatailor`: Updates service API and documentation
* `service/privatenetworks`: Adds new service
* `service/support-app`: Adds new service

Release v1.44.125 (2022-10-27)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Feature supports the replacement of instance root volume using an updated AMI without requiring customers to stop their instance.
* `service/fms`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Added support for custom datatypes when using custom csv classifier.
* `service/redshift`: Updates service documentation
  * This release clarifies use for the ElasticIp parameter of the CreateCluster and RestoreFromClusterSnapshot APIs.
* `service/sagemaker`: Updates service API and documentation
  * This change allows customers to provide a custom entrypoint script for the docker container to be run while executing training jobs, and provide custom arguments to the entrypoint script.
* `service/wafv2`: Updates service API and documentation

Release v1.44.124 (2022-10-26)
===

### Service Client Updates
* `service/iam`: Updates service documentation
  * Doc only update that corrects instances of CLI not using an entity.
* `service/kafka`: Updates service API and documentation
* `service/neptune`: Updates service API, documentation, and paginators
  * Added a new cluster-level attribute to set the capacity range for Neptune Serverless instances.
* `service/sagemaker`: Updates service API
  * Amazon SageMaker Automatic Model Tuning now supports specifying Grid Search strategy for tuning jobs, which evaluates all hyperparameter combinations exhaustively based on the categorical hyperparameters provided.

Release v1.44.123 (2022-10-25)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/location`: Updates service documentation
* `service/mediatailor`: Updates service API, documentation, paginators, and examples
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Relational Database Service - This release adds support for exporting DB cluster data to Amazon S3.
* `service/workspaces`: Updates service API and documentation
  * This release adds new enums for supporting Workspaces Core features, including creating Manual running mode workspaces, importing regular Workspaces Core images and importing g4dn Workspaces Core images.

Release v1.44.122 (2022-10-24)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/batch`: Updates service API and documentation
  * This release adds support for AWS Batch on Amazon EKS.
* `service/datasync`: Updates service API and documentation
* `service/sagemaker`: Updates service API, documentation, and paginators
  * SageMaker Inference Recommender now supports a new API ListInferenceRecommendationJobSteps to return the details of all the benchmark we create for an inference recommendation job.

Release v1.44.121 (2022-10-21)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/s3`: Updates service examples
  * S3 on Outposts launches support for automatic bucket-style alias. You can use the automatic access point alias instead of an access point ARN for any object-level operation in an Outposts bucket.
* `service/sagemaker`: Updates service API and documentation
  * CreateInferenceRecommenderjob API now supports passing endpoint details directly, that will help customers to identify the max invocation and max latency they can achieve for their model and the associated endpoint along with getting recommendations on other instances.

Release v1.44.120 (2022-10-20)
===

### Service Client Updates
* `service/devops-guru`: Updates service API and documentation
* `service/globalaccelerator`: Updates service API and documentation
* `service/resiliencehub`: Updates service API and documentation
* `service/rum`: Updates service API, documentation, and paginators

Release v1.44.119 (2022-10-19)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service documentation
* `service/cloudtrail`: Updates service API and documentation
  * This release includes support for exporting CloudTrail Lake query results to an Amazon S3 bucket.
* `service/config`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/eventbridge`: Updates service API
* `service/managedblockchain`: Updates service API, documentation, and paginators
* `service/s3`: Updates service API and examples
  * Updates internal logic for constructing API endpoints. We have added rule-based endpoints and internal model parameters.
* `service/s3control`: Updates service API
  * Updates internal logic for constructing API endpoints. We have added rule-based endpoints and internal model parameters.
* `service/support-app`: Updates service API and documentation
* `service/workspaces-web`: Updates service API, documentation, and paginators

### SDK Enhancements
* `aws/session`: Modified config resolution strategy when `$HOME` or `%USERPROFILE%` environment variables are not set.
  * When the environment variables are not set, the SDK will attempt to determine the home directory using `user.Current()`.

Release v1.44.118 (2022-10-18)
===

### Service Client Updates
* `service/frauddetector`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * This change allows customers to enable data capturing while running a batch transform job, and configure monitoring schedule to monitoring the captured data.
* `service/servicediscovery`: Updates service API, documentation, and examples
* `service/sesv2`: Updates service API and documentation

Release v1.44.117 (2022-10-17)
===

### Service Client Updates
* `service/greengrass`: Updates service API and documentation
  * This change allows customers to specify FunctionRuntimeOverride in FunctionDefinitionVersion. This configuration can be used if the runtime on the device is different from the AWS Lambda runtime specified for that function.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for C7g, C6g, C6gd, C6gn, M6g, M6gd, R6g, and R6gn Graviton instance types in Amazon SageMaker Inference.

Release v1.44.116 (2022-10-14)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * MediaConvert now supports specifying the minimum percentage of the HRD buffer available at the end of each encoded video segment.

Release v1.44.115 (2022-10-13)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API and documentation
* `service/appflow`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ds`: Updates service API, documentation, and paginators
  * This release adds support for describing and updating AWS Managed Microsoft AD set up.
* `service/ecs`: Updates service documentation
  * Documentation update to address tickets.
* `service/guardduty`: Updates service API and documentation
  * Add UnprocessedDataSources to CreateDetectorResponse which specifies the data sources that couldn't be enabled during the CreateDetector request. In addition, update documentations.
* `service/iam`: Updates service documentation
  * Documentation updates for the AWS Identity and Access Management API Reference.
* `service/iotfleetwise`: Updates service documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports forwarding SCTE-35 messages through the Event Signaling and Management (ESAM) API, and can read those SCTE-35 messages from an inactive source.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/panorama`: Updates service API and documentation
* `service/rds-data`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * Support of AmazonLinux2022 by Patch Manager
* `service/ssm-incidents`: Updates service API
* `service/transfer`: Updates service API and documentation
  * This release adds an option for customers to configure workflows that are triggered when files are only partially received from a client due to premature session disconnect.
* `service/translate`: Updates service documentation
* `service/wisdom`: Updates service API and documentation

Release v1.44.114 (2022-10-07)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service documentation
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/greengrassv2`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Amazon QuickSight now supports SecretsManager Secret ARN in place of CredentialPair for DataSource creation and update. This release also has some minor documentation updates and removes CountryCode as a required parameter in GeoSpatialColumnGroup

Release v1.44.113 (2022-10-06)
===

### Service Client Updates
* `service/resiliencehub`: Updates service documentation

Release v1.44.112 (2022-10-05)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * This SDK release adds support to sync glue jobs with source control provider. Additionally, a new parameter called SourceControlDetails will be added to Job model.
* `service/network-firewall`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation

Release v1.44.111 (2022-10-04)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/connectcases`: Adds new service
* `service/ec2`: Updates service API and documentation
  * Added EnableNetworkAddressUsageMetrics flag for ModifyVpcAttribute, DescribeVpcAttribute APIs.
* `service/ecs`: Updates service documentation
  * Documentation updates to address various Amazon ECS tickets.
* `service/s3control`: Updates service API
  * S3 Object Lambda adds support to allow customers to intercept HeadObject and ListObjects requests and introduce their own compute. These requests were previously proxied to S3.
* `service/workmail`: Updates service API, documentation, and paginators
  * This release adds support for impersonation roles in Amazon WorkMail.

Release v1.44.110 (2022-10-03)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Adding an imdsSupport attribute to EC2 AMIs
* `service/snowball`: Updates service API, documentation, and paginators
  * Adds support for V3_5C. This is a refreshed AWS Snowball Edge Compute Optimized device type with 28TB SSD, 104 vCPU and 416GB memory (customer usable).

Release v1.44.109 (2022-09-30)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * This release allows you to override the alarm configurations when creating a deployment.
* `service/devops-guru`: Updates service API and documentation
* `service/dlm`: Updates service API and documentation
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * A new parameter called ExplainerConfig is added to CreateEndpointConfig API to enable SageMaker Clarify online explainability feature.
* `service/sso-oidc`: Updates service documentation

Release v1.44.108 (2022-09-29)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * This update returns additional certificate details such as certificate SANs and allows sorting in the ListCertificates API.
* `service/ec2`: Updates service API
  * u-3tb1 instances are powered by Intel Xeon Platinum 8176M (Skylake) processors and are purpose-built to run large in-memory databases.
* `service/emr-serverless`: Updates service API and documentation
* `service/fsx`: Updates service API, documentation, and paginators
* `service/migrationhuborchestrator`: Adds new service
* `service/polly`: Updates service API
  * Added support for the new Cantonese voice - Hiujin. Hiujin is available as a Neural voice only.
* `service/proton`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Training Managed Warm Pools let you retain provisioned infrastructure to reduce latency for repetitive training workloads.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/translate`: Updates service API and documentation
* `service/workspaces`: Updates service API and documentation
  * This release includes diagnostic log uploading feature. If it is enabled, the log files of WorkSpaces Windows client will be sent to Amazon WorkSpaces automatically for troubleshooting. You can use modifyClientProperty api to enable/disable this feature.

Release v1.44.107 (2022-09-27)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/kendra`: Updates service documentation
  * My AWS Service (placeholder) - Amazon Kendra now provides a data source connector for DropBox. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-dropbox.html
* `service/location`: Updates service API and documentation

Release v1.44.106 (2022-09-26)
===

### Service Client Updates
* `service/cur`: Updates service API
  * This release adds two new support regions(me-central-1/eu-south-2) for OSG.
* `service/iotfleetwise`: Adds new service
* `service/ssm`: Updates service API and documentation
  * This release includes support for applying a CloudWatch alarm to Systems Manager capabilities like Automation, Run Command, State Manager, and Maintenance Windows.

Release v1.44.105 (2022-09-23)
===

### Service Client Updates
* `service/apprunner`: Updates service API
* `service/ec2`: Updates service API and documentation
  * Letting external AWS customers provide ImageId as a Launch Template override in FleetLaunchTemplateOverridesRequest
* `service/lightsail`: Updates service API and documentation
  * This release adds Instance Metadata Service (IMDS) support for Lightsail instances.
* `service/models.lex.v2`: Updates service API and documentation
* `service/nimble`: Updates service API, documentation, and waiters
* `service/ssm`: Updates service API
  * This release adds new SSM document types ConformancePackTemplate and CloudFormation
* `service/wafv2`: Updates service documentation

Release v1.44.104 (2022-09-22)
===

### Service Client Updates
* `service/backup-gateway`: Updates service API and documentation
* `service/devicefarm`: Updates service API and documentation
  * This release adds the support for VPC-ENI based connectivity for private devices on AWS Device Farm.
* `service/ec2`: Updates service API and documentation
  * Documentation updates for Amazon EC2.
* `service/glue`: Updates service API and documentation
  * Added support for S3 Event Notifications for Catalog Target Crawlers.
* `service/identitystore`: Updates service documentation

Release v1.44.103 (2022-09-21)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/s3control`: Updates service API and documentation
  * S3 on Outposts launches support for object versioning for Outposts buckets. With S3 Versioning, you can preserve, retrieve, and restore every version of every object stored in your buckets. You can recover from both unintended user actions and application failures.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker now allows customization on Canvas Application settings, including enabling/disabling time-series forecasting and specifying an Amazon Forecast execution role at both the Domain and UserProfile levels.

Release v1.44.102 (2022-09-20)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for blocked paths to Amazon VPC Reachability Analyzer.

Release v1.44.101 (2022-09-19)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API, documentation, and paginators
  * This release includes support for importing existing trails into CloudTrail Lake.
* `service/ec2`: Updates service API and documentation
  * This release adds CapacityAllocations field to DescribeCapacityReservations
* `service/mediaconnect`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for Amazon RDS Proxy with SQL Server compatibility.

Release v1.44.100 (2022-09-16)
===

### Service Client Updates
* `service/codestar-notifications`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * This release supports new task definition sizes.

Release v1.44.99 (2022-09-15)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Increased DynamoDB transaction limit from 25 to 100.
* `service/ec2`: Updates service API and documentation
  * This feature allows customers to create tags for vpc-endpoint-connections and vpc-endpoint-service-permissions.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now supports specifying Hyperband strategy for tuning jobs, which uses a multi-fidelity based tuning strategy to stop underperforming hyperparameter configurations early.

Release v1.44.98 (2022-09-14)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This update introduces API operations to manage and create local gateway route tables, CoIP pools, and VIF group associations.

Release v1.44.97 (2022-09-13)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/drs`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Two new features for local gateway route tables: support for static routes targeting Elastic Network Interfaces and direct VPC routing.
* `service/evidently`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * This release enables our customer to choose the option of Sharepoint 2019 for the on-premise Sharepoint connector.
* `service/transfer`: Updates service API and documentation
  * This release introduces the ability to have multiple server host keys for any of your Transfer Family servers that use the SFTP protocol.

Release v1.44.96 (2022-09-12)
===

### Service Client Updates
* `service/eks`: Updates service API and documentation

Release v1.44.95 (2022-09-09)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API, documentation, and paginators
  * This release adds CloudTrail getChannel and listChannels APIs to allow customer to view the ServiceLinkedChannel configurations.
* `service/models.lex.v2`: Updates service API and documentation
* `service/pi`: Updates service API
* `service/redshift`: Updates service documentation
  * This release updates documentation for AQUA features and other description updates.
* `service/runtime.lex.v2`: Updates service API and documentation

Release v1.44.94 (2022-09-08)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support to send VPC Flow Logs to kinesis-data-firehose as new destination type
* `service/emr-containers`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * This change exposes API settings which allow Dolby Atmos and Dolby Vision to be used when running a channel using Elemental Media Live
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Middle East (UAE) Region (me-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/sagemaker`: Updates service API and documentation
  * This release adds Mode to AutoMLJobConfig.
* `service/ssm`: Updates service API and documentation
  * This release adds support for Systems Manager State Manager Association tagging.

Release v1.44.93 (2022-09-07)
===

### Service Client Updates
* `service/dataexchange`: Updates service API, documentation, waiters, paginators, and examples
* `service/ec2`: Updates service API
  * Documentation updates for Amazon EC2.
* `service/eks`: Updates service API and documentation
* `service/fsx`: Updates service documentation
* `service/inspector2`: Updates service API and documentation
* `service/iotsitewise`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Hosting now allows customization on ML instance storage volume size, model data download timeout and inference container startup ping health check timeout for each ProductionVariant in CreateEndpointConfig API.
* `service/sns`: Updates service API and documentation
  * Amazon SNS introduces the Data Protection Policy APIs, which enable customers to attach a data protection policy to an SNS topic. This allows topic owners to enable the new message data protection feature to audit and block sensitive data that is exchanged through their topics.

Release v1.44.92 (2022-09-06)
===

### Service Client Updates
* `service/identitystore`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * This release adds HyperParameterTuningJob type in Search API.

Release v1.44.91 (2022-09-02)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/mediapackage`: Updates service API and documentation
  * Added support for AES_CTR encryption to CMAF origin endpoints
* `service/sagemaker`: Updates service API and documentation
  * This release enables administrators to attribute user activity and API calls from Studio notebooks, Data Wrangler and Canvas to specific users even when users share the same execution IAM role.  ExecutionRoleIdentityConfig at Sagemaker domain level enables this feature.

Release v1.44.90 (2022-09-01)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service documentation
* `service/controltower`: Adds new service
* `service/route53`: Updates service documentation
  * Documentation updates for Amazon Route 53.

Release v1.44.89 (2022-08-31)
===

### Service Client Updates
* `service/cloudfront`: Updates service documentation
  * Update API documentation for CloudFront origin access control (OAC)
* `service/identitystore`: Updates service API, documentation, and paginators
* `service/iotthingsgraph`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/rds-data`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now accepts Inference Recommender fields: Domain, Task, Framework, SamplePayloadUrl, SupportedContentTypes, SupportedInstanceTypes, directly in our CreateInferenceRecommendationsJob API through ContainerConfig

Release v1.44.88 (2022-08-30)
===

### Service Client Updates
* `service/greengrassv2`: Updates service API and documentation
* `service/identitystore`: Updates service documentation
* `service/lookoutequipment`: Updates service API, documentation, and paginators
* `service/macie2`: Updates service API and documentation
* `service/sso`: Updates service documentation
  * Documentation updates for the AWS IAM Identity Center Portal CLI Reference.
* `service/sso-admin`: Updates service documentation

Release v1.44.87 (2022-08-29)
===

### Service Client Updates
* `service/fsx`: Updates service documentation
* `service/voice-id`: Updates service API and documentation

Release v1.44.86 (2022-08-26)
===

### Service Client Updates
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Removes support for RDS Custom from DBInstanceClass in ModifyDBInstance

Release v1.44.85 (2022-08-25)
===

### Service Client Updates
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/gamelift`: Updates service API
  * This release adds support for eight EC2 local zones as fleet locations; Atlanta, Chicago, Dallas, Denver, Houston, Kansas City (us-east-1-mci-1a), Los Angeles, and Phoenix. It also adds support for C5d, C6a, C6i, and R5d EC2 instance families.
* `service/iotwireless`: Updates service API and documentation
* `service/ivschat`: Updates service documentation
* `service/panorama`: Updates service API and documentation
* `service/sso-oidc`: Updates service API and documentation

Release v1.44.84 (2022-08-24)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Adds support for CloudFront origin access control (OAC), making it possible to restrict public access to S3 bucket origins in all AWS Regions, those with SSE-KMS, and more.
* `service/config`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/ivs`: Updates service documentation
* `service/quicksight`: Updates service API and documentation
  * Added a new optional property DashboardVisual under ExperienceConfiguration parameter of GenerateEmbedUrlForAnonymousUser and GenerateEmbedUrlForRegisteredUser API operations. This supports embedding of specific visuals in QuickSight dashboards.
* `service/transfer`: Updates service documentation
  * Documentation updates for AWS Transfer Family

Release v1.44.83 (2022-08-23)
===

### Service Client Updates
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * RDS for Oracle supports Oracle Data Guard switchover and read replica backups.
* `service/sso-admin`: Updates service documentation

Release v1.44.82 (2022-08-22)
===

### Service Client Updates
* `service/docdb`: Updates service documentation
  * Update document for volume clone
* `service/ec2`: Updates service API
  * R6a instances are powered by 3rd generation AMD EPYC (Milan) processors delivering all-core turbo frequency of 3.6 GHz. C6id, M6id, and R6id instances are powered by 3rd generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz.
* `service/forecast`: Updates service API, documentation, and paginators
* `service/forecastquery`: Updates service API and documentation
* `service/iotsitewise`: Updates service API
* `service/models.lex.v2`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation
* `service/support-app`: Adds new service

Release v1.44.81 (2022-08-19)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/ivschat`: Updates service documentation
* `service/kendra`: Updates service API and documentation
  * This release adds support for a new authentication type - Personal Access Token (PAT) for confluence server.
* `service/lookoutmetrics`: Updates service API and documentation

Release v1.44.80 (2022-08-18)
===

### Service Client Updates
* `service/chime-sdk-media-pipelines`: Updates service API, documentation, and paginators
* `service/cognito-idp`: Updates service API
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for importing data from S3 into a new DynamoDB table
* `service/ec2`: Updates service API and documentation
  * This release adds support for VPN log options , a new feature allowing S2S VPN connections to send IKE activity logs to CloudWatch Logs
* `service/monitoring`: Updates service API, documentation, and paginators
  * Add support for managed Contributor Insights Rules
* `service/networkmanager`: Updates service API and documentation

Release v1.44.79 (2022-08-17)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/connectcampaigns`: Updates service API
* `service/kendra`: Updates service API and documentation
  * This release adds Zendesk connector (which allows you to specify Zendesk SAAS platform as data source), Proxy Support for Sharepoint and Confluence Server (which allows you to specify the proxy configuration if proxy is required to connect to your Sharepoint/Confluence Server as data source).
* `service/lakeformation`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Added support for customization of Consumer Group ID for MSK and Kafka Event Source Mappings.
* `service/models.lex.v2`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for Internet Protocol Version 6 (IPv6) for RDS Aurora database clusters.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager.

Release v1.44.78 (2022-08-16)
===

### Service Client Updates
* `service/rekognition`: Updates service API, documentation, paginators, and examples
  * This release adds APIs which support copying an Amazon Rekognition Custom Labels model and managing project policies across AWS account.
* `service/servicecatalog`: Updates service documentation
  * Documentation updates for Service Catalog

Release v1.44.77 (2022-08-15)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Adds Http 3 support to distributions
* `service/identitystore`: Updates service documentation
* `service/sso`: Updates service documentation
  * Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `service/wisdom`: Updates service API and documentation

Release v1.44.76 (2022-08-12)
===

### Service Client Updates
* `service/amp`: Updates service API and documentation
* `service/chime-sdk-messaging`: Updates service API, documentation, and paginators
* `service/ivs`: Updates service API and documentation
* `service/personalize-runtime`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for RDS Custom to DBInstanceClass in ModifyDBInstance

Release v1.44.75 (2022-08-11)
===

### Service Client Updates
* `service/backupstorage`: Adds new service
* `service/glue`: Updates service API
  * Add support for Python 3.9 AWS Glue Python Shell jobs
* `service/privatenetworks`: Adds new service

Release v1.44.74 (2022-08-11)
===

### SDK Enhancements
* `service/dynamodb/dynamodbattribute`: Add String method to UnixTime
  * Adds a `String` method to `UnixTime`, so that when structs with this field get logged it prints a human readable time.

Release v1.44.73 (2022-08-10)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for excluding specific data (non-root) volumes from multi-volume snapshot sets created from instances.

Release v1.44.72 (2022-08-09)
===

### Service Client Updates
* `service/location`: Updates service API and documentation
* `service/monitoring`: Updates service API and documentation
  * Various quota increases related to dimensions and custom metrics
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now supports specifying multiple alternate EC2 instance types to make tuning jobs more robust when the preferred instance type is not available due to insufficient capacity.
* `service/sagemaker-a2i-runtime`: Updates service API

Release v1.44.71 (2022-08-08)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Add an option to run non-urgent or non-time sensitive Glue Jobs on spare capacity
* `service/identitystore`: Updates service documentation
* `service/iotwireless`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * Adds support for Advance Quiet Time in Journeys. Adds RefreshOnSegmentUpdate and WaitForQuietTime to JourneyResponse.
* `service/quicksight`: Updates service documentation
  * A series of documentation updates to the QuickSight API reference.
* `service/sso`: Updates service documentation
  * Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `service/sso-admin`: Updates service documentation
* `service/sso-oidc`: Updates service documentation

Release v1.44.70 (2022-08-04)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/config`: Updates service API
* `service/dms`: Updates service documentation
  * Documentation updates for Database Migration Service (DMS).
* `service/iot`: Updates service API and documentation
  * The release is to support attach a provisioning template to CACert for JITP function,  Customer now doesn't have to hardcode a roleArn and templateBody during register a CACert to enable JITP.

Release v1.44.69 (2022-08-03)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.44.68 (2022-08-02)
===

### Service Client Updates
* `service/license-manager-user-subscriptions`: Adds new service
* `service/personalize`: Updates service API and documentation

Release v1.44.67 (2022-08-01)
===

### Service Client Updates
* `service/config`: Updates service documentation
* `service/workspaces`: Updates service API and documentation
  * This release introduces ModifySamlProperties, a new API that allows control of SAML properties associated with a WorkSpaces directory. The DescribeWorkspaceDirectories API will now additionally return SAML properties in its responses.

Release v1.44.66 (2022-07-29)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Documentation updates for Amazon EC2.
* `service/fsx`: Updates service documentation
* `service/shield`: Updates service API and documentation
  * AWS Shield Advanced now supports filtering for ListProtections and ListProtectionGroups.

Release v1.44.65 (2022-07-28)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation updates for VM Import/Export.
* `service/es`: Updates service API and documentation
  * This release adds support for gp3 EBS (Elastic Block Store) storage.
* `service/lookoutvision`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation

Release v1.44.64 (2022-07-27)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * Chime VoiceConnector will now support ValidateE911Address which will allow customers to prevalidate their addresses included in their SIP invites for emergency calling
* `service/config`: Updates service API, documentation, and paginators
* `service/globalaccelerator`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new English and Hindi voice - Kajal. Kajal is available as Neural voice only.
* `service/ssm`: Updates service documentation
  * Adding doc updates for OpsCenter support in Service Setting actions.
* `service/workspaces`: Updates service API and documentation
  * Added CreateWorkspaceImage API to create a new WorkSpace image from an existing WorkSpace.

Release v1.44.63 (2022-07-26)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/detective`: Updates service API, documentation, and paginators
* `service/guardduty`: Updates service API, documentation, and paginators
  * Amazon GuardDuty introduces a new Malware Protection feature that triggers malware scan on selected EC2 instance resources, after the service detects a potentially malicious activity.
* `service/lookoutvision`: Updates service API and documentation
* `service/macie2`: Updates service API, documentation, and waiters
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for using RDS Proxies with RDS for MariaDB databases.
* `service/rekognition`: Updates service API and documentation
  * This release introduces support for the automatic scaling of inference units used by Amazon Rekognition Custom Labels models.
* `service/securityhub`: Updates service documentation
* `service/transfer`: Updates service API, documentation, and paginators
  * AWS Transfer Family now supports Applicability Statement 2 (AS2), a network protocol used for the secure and reliable transfer of critical Business-to-Business (B2B) data over the public internet using HTTP/HTTPS as the transport mechanism.

Release v1.44.62 (2022-07-25)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation update for Amazon EC2 Auto Scaling.

Release v1.44.61 (2022-07-22)
===

### Service Client Updates
* `service/account`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Added support for EC2 M1 Mac instances. For more information, please visit aws.amazon.com/mac.
* `service/iotdeviceadvisor`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * Link devices now support remote rebooting. Link devices now support maintenance windows. Maintenance windows allow a Link device to install software updates without stopping the MediaLive channel. The channel will experience a brief loss of input from the device while updates are installed.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds the "ModifyActivityStream" API with support for audit policy state locking and unlocking.
* `service/transcribe`: Updates service API

Release v1.44.60 (2022-07-21)
===

### Service Client Updates
* `service/athena`: Updates service API, documentation, and paginators
  * This feature allows customers to retrieve runtime statistics for completed queries
* `service/dms`: Updates service documentation
  * Documentation updates for Database Migration Service (DMS).
* `service/docdb`: Updates service API and documentation
  * Enable copy-on-write restore type
* `service/ec2-instance-connect`: Updates service API and documentation
* `service/frauddetector`: Updates service API and documentation
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides Oauth2 support for SharePoint Online. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html
* `service/monitoring`: Updates service API and documentation
  * Adding support for the suppression of Composite Alarm actions
* `service/network-firewall`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for creating an RDS Proxy for an RDS for MariaDB database.

Release v1.44.59 (2022-07-20)
===

### Service Client Updates
* `service/acm-pca`: Updates service documentation
* `service/iot`: Updates service API and documentation
  * GA release the ability to enable/disable IoT Fleet Indexing for Device Defender and Named Shadow information, and search them through IoT Fleet Indexing APIs. This includes Named Shadow Selection as a part of the UpdateIndexingConfiguration API.

### SDK Bugs
* `service/pricing`: Fixes a bug that caused `GetProductsOutput.PriceList` to be generated incorrectly. ([#4486](https://github.com/aws/aws-sdk-go/pull/4486))
  * The [v1.44.46](https://github.com/aws/aws-sdk-go/releases/tag/v1.44.46) release incorrectly resulted in the `PriceList` field's type changing from `[]aws.JSONValue` to `[]*string`.
  * This release reverts this change, with the field now correctly updated to `[]aws.JSONValue`.
  * Fixes [#4480](https://github.com/aws/aws-sdk-go/issues/4480)

Release v1.44.58 (2022-07-19)
===

### Service Client Updates
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/glue`: Updates service documentation
  * Documentation updates for AWS Glue Job Timeout and Autoscaling
* `service/sagemaker`: Updates service API
  * Fixed an issue with cross account QueryLineage
* `service/sagemaker-edge`: Updates service API and documentation
* `service/workspaces`: Updates service API
  * Increased the character limit of the login message from 850 to 2000 characters.

Release v1.44.57 (2022-07-18)
===

### Service Client Updates
* `service/discovery`: Updates service API and documentation
  * Add AWS Agentless Collector details to the GetDiscoverySummary API response
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/elasticache`: Updates service API and documentation
  * Adding AutoMinorVersionUpgrade in the DescribeReplicationGroups API
* `service/kms`: Updates service API, documentation, and paginators
  * Added support for the SM2 KeySpec in China Partition Regions
* `service/mediapackage`: Updates service API and documentation
  * This release adds "IncludeIframeOnlyStream" for Dash endpoints and increases the number of supported video and audio encryption presets for Speke v2
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Amazon SageMaker Edge Manager provides lightweight model deployment feature to deploy machine learning models on requested devices.
* `service/sso-admin`: Updates service API, documentation, and paginators

Release v1.44.56 (2022-07-15)
===

### Service Client Updates
* `service/datasync`: Updates service documentation
* `service/drs`: Updates service API and documentation
* `service/evidently`: Updates service API, documentation, and paginators
* `service/wafv2`: Updates service API and documentation

Release v1.44.55 (2022-07-14)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release updates data types that contain either QueryExecutionId, NamedQueryId or ExpectedBucketOwner. Ids must be between 1 and 128 characters and contain only non-whitespace characters. ExpectedBucketOwner must be 12-digit string.
* `service/codeartifact`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API
  * This release adds flow logs for Transit Gateway to  allow customers to gain deeper visibility and insights into network traffic through their Transit Gateways.
* `service/fms`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * This release adds an additional worker type for Glue Streaming jobs.
* `service/inspector2`: Updates service API and documentation
* `service/kendra`: Updates service API, documentation, and paginators
  * This release adds AccessControlConfigurations which allow you to redefine your document level access control without the need for content re-indexing.
* `service/nimble`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for G5, P4d, and C6i instance types in Amazon SageMaker Inference and increases the number of hyperparameters that can be searched from 20 to 30 in Amazon SageMaker Automatic Model Tuning

Release v1.44.54 (2022-07-13)
===

### Service Client Updates
* `service/appconfig`: Updates service API, documentation, and paginators

Release v1.44.53 (2022-07-12)
===

### Service Client Updates
* `service/networkmanager`: Updates service API, documentation, and paginators

Release v1.44.52 (2022-07-11)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * Build, manage, and monitor a unified global network that connects resources running across your cloud and on-premises environments using the AWS Cloud WAN APIs.
* `service/redshift`: Updates service API and documentation
  * This release adds a new --snapshot-arn field for describe-cluster-snapshots, describe-node-configuration-options, restore-from-cluster-snapshot, authorize-snapshot-acsess, and revoke-snapshot-acsess APIs. It allows customers to give a Redshift snapshot ARN or a Redshift Serverless ARN as input.
* `service/redshift-serverless`: Updates service documentation

Release v1.44.51 (2022-07-08)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation

Release v1.44.50 (2022-07-07)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * New api to migrate event subscriptions to event bridge rules
* `service/iot`: Updates service API and documentation
  * This release adds support to register a CA certificate without having to provide a verification certificate. This also allows multiple AWS accounts to register the same CA in the same region.
* `service/iotwireless`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * Heterogeneous clusters: the ability to launch training jobs with multiple instance types. This enables running component of the training job on the instance type that is most suitable for it. e.g. doing data processing and augmentation on CPU instances and neural network training on GPU instances

Release v1.44.49 (2022-07-06)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * My AWS Service (placeholder) - Add a new feature Account-level Targeting for StackSet operation
* `service/synthetics`: Updates service API, documentation, and paginators

Release v1.44.48 (2022-07-05)
===

### Service Client Updates
* `service/config`: Updates service documentation
* `service/models.lex.v2`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * This release allows customers to programmatically create QuickSight accounts with Enterprise and Enterprise + Q editions. It also releases allowlisting domains for embedding QuickSight dashboards at runtime through the embedding APIs.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds waiters support for DBCluster.
* `service/rolesanywhere`: Adds new service
* `service/ssm-incidents`: Updates service API and documentation

Release v1.44.47 (2022-07-01)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Added new features for AWS DMS version 3.4.7 that includes new endpoint settings for S3, OpenSearch, Postgres, SQLServer and Oracle.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for additional retention periods to Performance Insights.

Release v1.44.46 (2022-06-30)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This feature introduces the API support for Athena's parameterized query and BatchGetPreparedStatement API.
* `service/customer-profiles`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * This release adds support for the ExecutionRoleArn parameter in the AddJobFlowSteps and DescribeStep APIs. Customers can use ExecutionRoleArn to specify the IAM role used for each job they submit using the AddJobFlowSteps API.
* `service/glue`: Updates service API and documentation
  * This release adds tag as an input of CreateDatabase
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for alfresco
* `service/mwaa`: Updates service API and documentation
* `service/pricing`: Updates service API and documentation
* `service/wellarchitected`: Updates service API and documentation
* `service/workmail`: Updates service API, documentation, and paginators
  * This release adds support for managing user availability configurations in Amazon WorkMail.

Release v1.44.45 (2022-06-29)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Includes support for StreamingExperienceSettings in CreateStack and UpdateStack APIs
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * This release introduces additional optional parameter "Throughput" to VolumeSpecification to enable user to configure throughput for gp3 ebs volumes.
* `service/medialive`: Updates service API and documentation
  * This release adds support for automatic renewal of MediaLive reservations at the end of each reservation term. Automatic renewal is optional. This release also adds support for labelling accessibility-focused audio and caption tracks in HLS outputs.
* `service/redshift-serverless`: Adds new service
* `service/sagemaker`: Updates service API and documentation
  * This release adds: UpdateFeatureGroup, UpdateFeatureMetadata, DescribeFeatureMetadata APIs; FeatureMetadata type in Search API; LastModifiedTime, LastUpdateStatus, OnlineStoreTotalSizeBytes in DescribeFeatureGroup API.
* `service/translate`: Updates service API, documentation, and paginators

Release v1.44.44 (2022-06-28)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds a new spread placement group to EC2 Placement Groups: host level spread, which spread instances between physical hosts, available to Outpost customers only. CreatePlacementGroup and DescribePlacementGroups APIs were updated with a new parameter: SpreadLevel to support this feature.
* `service/finspace-data`: Updates service API and documentation
* `service/polly`: Updates service API
  * Add 4 new neural voices - Pedro (es-US), Liam (fr-CA), Daniel (de-DE) and Arthur (en-GB).

Release v1.44.43 (2022-06-27)
===

### Service Client Updates
* `service/iot`: Updates service API
  * This release ease the restriction for the input of tag value to align with AWS standard, now instead of min length 1, we change it to min length 0.

Release v1.44.42 (2022-06-24)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * This release enables the new ListCrawls API for viewing the AWS Glue Crawler run history.
* `service/rds-data`: Updates service documentation

Release v1.44.41 (2022-06-23)
===

### Service Client Updates
* `service/lookoutequipment`: Updates service API, documentation, and paginators
* `service/mediaconvert`: Updates service documentation
  * AWS Elemental MediaConvert SDK has released support for automatic DolbyVision metadata generation when converting HDR10 to DolbyVision.
* `service/mgn`: Updates service API, documentation, and paginators
* `service/migration-hub-refactor-spaces`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Ground Truth now supports Virtual Private Cloud. Customers can launch labeling jobs and access to their private workforce in VPC mode.

Release v1.44.40 (2022-06-22)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/pricing`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Until today, the service supported only RSA host keys and user keys. Now with this launch, Transfer Family has expanded the support for ECDSA and ED25519 host keys and user keys, enabling customers to support a broader set of clients by choosing RSA, ECDSA, and ED25519 host and user keys.

Release v1.44.39 (2022-06-21)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for Private IP VPNs, a new feature allowing S2S VPN connections to use private ip addresses as the tunnel outside ip address over Direct Connect as transport.
* `service/ecs`: Updates service documentation
  * Amazon ECS UpdateService now supports the following parameters: PlacementStrategies, PlacementConstraints and CapacityProviderStrategy.
* `service/wellarchitected`: Updates service API and documentation

Release v1.44.38 (2022-06-20)
===

### Service Client Updates
* `service/ds`: Updates service API and documentation
  * This release adds support for describing and updating AWS Managed Microsoft AD settings
* `service/kafka`: Updates service documentation
* `service/outposts`: Updates service API and documentation

Release v1.44.37 (2022-06-17)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/connectcampaigns`: Adds new service
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Doc only update for DynamoDB service
* `service/streams.dynamodb`: Updates service documentation

Release v1.44.36 (2022-06-16)
===

### Service Client Updates
* `service/redshift-data`: Updates service API and documentation
* `service/redshiftserverless`: Adds new service
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/securityhub`: Updates service API and documentation

Release v1.44.35 (2022-06-15)
===

### Service Client Updates
* `service/finspace-data`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Adds finding fields available from GuardDuty Console. Adds FreeTrial related operations. Deprecates the use of various APIs related to Master Accounts and Replace them with Administrator Accounts.
* `service/servicecatalog-appregistry`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * Added new field "reason" to OperationNotSupportedException. Receiving this exception in the DeregisterWorkspaceDirectory API will now return a reason giving more context on the failure.

Release v1.44.34 (2022-06-14)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Add a budgets ThrottlingException. Update the CostFilters value pattern.
* `service/lookoutmetrics`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for rules that constrain Automatic-ABR rendition selection when generating ABR package ladders.

Release v1.44.33 (2022-06-13)
===

### Service Client Updates
* `service/outposts`: Updates service API and documentation

Release v1.44.32 (2022-06-10)
===

### Service Client Updates
* `service/frauddetector`: Updates service documentation

Release v1.44.31 (2022-06-09)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API

Release v1.44.30 (2022-06-08)
===

### Service Client Updates
* `service/dms`: Updates service API, documentation, and paginators
  * This release adds DMS Fleet Advisor APIs and exposes functionality for DMS Fleet Advisor. It adds functionality to create and modify fleet advisor instances, and to collect and analyze information about the local data infrastructure.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/m2`: Updates service API, documentation, paginators, and examples
* `service/neptune`: Updates service API and documentation
  * This release adds support for Neptune to be configured as a global database, with a primary DB cluster in one region, and up to five secondary DB clusters in other regions.
* `service/redshift`: Updates service API and documentation
  * Adds new API GetClusterCredentialsWithIAM to return temporary credentials.
* `service/redshift-serverless`: Adds new service

Release v1.44.29 (2022-06-07)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/ce`: Updates service API, documentation, and paginators

Release v1.44.28 (2022-06-06)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service API, documentation, and paginators
* `service/connect`: Updates service API, documentation, and paginators

### SDK Enhancements
* `service/cloudwatch`: Add helper to send request payload as GZIP content encoding
  * Adds a new helper, `WithGzipRequest` to the `cloudwatch` package. The helper will configure the payload to be sent as `content-encoding: gzip`. It is supported by operations like `PutMetricData`. See the service's API Reference documentation for other operations supported.

Release v1.44.27 (2022-06-02)
===

### Service Client Updates
* `service/application-insights`: Updates service API and documentation
* `service/codeartifact`: Updates service documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for GitHub. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html
* `service/proton`: Updates service API, documentation, waiters, and paginators
* `service/voice-id`: Updates service API and documentation

Release v1.44.26 (2022-06-01)
===

### Service Client Updates
* `service/backup-gateway`: Updates service API and documentation
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/forecast`: Updates service API and documentation
* `service/route53`: Updates service API, documentation, and paginators
  * Add new APIs to support Route 53 IP Based Routing

Release v1.44.25 (2022-05-31)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/drs`: Updates service API, documentation, and paginators
* `service/iotsitewise`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation
* `service/sagemaker`: Updates service API
  * Amazon SageMaker Notebook Instances now support Jupyter Lab 3.
* `service/transcribe`: Updates service API and documentation

Release v1.44.24 (2022-05-27)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/datasync`: Updates service API, documentation, and paginators
* `service/emr-serverless`: Adds new service
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Notebook Instances now allows configuration of Instance Metadata Service version and Amazon SageMaker Studio now supports G5 instance types.

Release v1.44.23 (2022-05-26)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * C7g instances, powered by the latest generation AWS Graviton3 processors, provide the best price performance in Amazon EC2 for compute-intensive workloads.
* `service/emr-serverless`: Adds new service
* `service/forecast`: Updates service API and documentation
* `service/lightsail`: Updates service API and documentation
  * Amazon Lightsail now supports the ability to configure a Lightsail Container Service to pull images from Amazon ECR private repositories in your account.

### SDK Bugs
* `service/cloudwatchevidently`: Introduces a breaking change for following parameters from a JSONValue to string type, because the SDKs JSONValue is not compatible with the service's request and response shapes.
  * `EvaluateFeatureInput.EvaluationContext` 
  * `EvaluateFeatureOutput.Details`
  * `EvaluationRequest.EvaluationContext`
  * `EvaluationResult.Details`
  * `Event.Data`
  * `ExperimentReport.Content`
  * `MetricDefinition.EventPattern`
  * `MetricDefinitionConfig.EventPattern`

Release v1.44.22 (2022-05-25)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/apprunner`: Updates service documentation
* `service/cloudformation`: Updates service API and documentation
  * Add a new parameter statusReason to DescribeStackSetOperation output for additional details
* `service/fsx`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds support for manually selecting features from the input dataset using the CreateAutoMLJob API.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/voice-id`: Updates service API, documentation, and paginators

Release v1.44.21 (2022-05-24)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Stop Protection feature enables customers to protect their instances from accidental stop actions.
* `service/ivschat`: Updates service documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for rules that constrain Automatic-ABR rendition selection when generating ABR package ladders.
* `service/networkmanager`: Updates service API and documentation

Release v1.44.20 (2022-05-23)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * Added support for encryption in transit for Memcached clusters. Customers can now launch Memcached cluster with encryption in transit enabled when using Memcached version 1.6.12 or later.
* `service/forecast`: Updates service API, documentation, and paginators
* `service/personalize`: Updates service API and documentation

Release v1.44.19 (2022-05-20)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/logs`: Updates service documentation
  * Doc-only update to publish the new valid values for log retention

Release v1.44.18 (2022-05-19)
===

### Service Client Updates
* `service/gamesparks`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation

Release v1.44.17 (2022-05-18)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/batch`: Updates service documentation
  * Documentation updates for AWS Batch.
* `service/greengrassv2`: Updates service API and documentation
* `service/iotevents-data`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * API UpdatePublicSharingSettings enables IAM admins to enable/disable account level setting for public access of dashboards. When enabled, owners/co-owners for dashboards can enable public access on their dashboards. These dashboards can only be accessed through share link or embedding.
* `service/transfer`: Updates service API and documentation
  * AWS Transfer Family now supports SetStat server configuration option, which provides the ability to ignore SetStat command issued by file transfer clients, enabling customers to upload files without any errors.

Release v1.44.16 (2022-05-17)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * This release adds a new optional parameter called codeGenNodeConfiguration to CRUD job APIs that allows users to manage visual jobs via APIs. The updated CreateJob and UpdateJob will create jobs that can be viewed in Glue Studio as a visual graph. GetJob can be used to get codeGenNodeConfiguration.
* `service/kms`: Updates service documentation
  * Add HMAC best practice tip, annual rotation of AWS managed keys.

Release v1.44.15 (2022-05-16)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Introduced a new error (TooLongCSPInResponseHeadersPolicy) that is returned when the value of the Content-Security-Policy header in a response headers policy exceeds the maximum allowed length.
* `service/discovery`: Updates service API and documentation
  * Add Migration Evaluator Collector details to the GetDiscoverySummary API response
* `service/rekognition`: Updates service documentation
  * Documentation updates for Amazon Rekognition.
* `service/resiliencehub`: Updates service API and documentation
* `service/servicecatalog`: Updates service documentation
  * Updated the descriptions for the ListAcceptedPortfolioShares API description and the PortfolioShareType parameters.
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.
* `service/workspaces-web`: Updates service API and documentation

Release v1.44.14 (2022-05-13)
===

### Service Client Updates
* `service/grafana`: Updates service API and documentation

Release v1.44.13 (2022-05-12)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release introduces a target type Gateway Load Balancer Endpoint for mirrored traffic. Customers can now specify GatewayLoadBalancerEndpoint option during the creation of a traffic mirror target.
* `service/finspace-data`: Updates service documentation
* `service/iot`: Updates service documentation
  * Documentation update for China region ListMetricValues for IoT
* `service/ivschat`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Jira. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html
* `service/lambda`: Updates service API and documentation
  * Lambda releases NodeJs 16 managed runtime to be available in all commercial regions.
* `service/lightsail`: Updates service API and documentation
  * This release adds support to include inactive database bundles in the response of the GetRelationalDatabaseBundles request.
* `service/outposts`: Updates service documentation
* `service/ssm-incidents`: Updates service API and documentation
* `service/transfer`: Updates service documentation
  * AWS Transfer Family now accepts ECDSA keys for server host keys
* `service/workspaces`: Updates service API
  * Increased the character limit of the login message from 600 to 850 characters.

Release v1.44.12 (2022-05-11)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release updates AWS PrivateLink APIs to support IPv6 for PrivateLink Services and Endpoints of type 'Interface'.
* `service/secretsmanager`: Updates service documentation and examples
  * Doc only update for Secrets Manager that fixes several customer-reported issues.

Release v1.44.11 (2022-05-10)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * Added support for using NitroTPM and UEFI Secure Boot on EC2 instances.
* `service/eks`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * This release updates the Amazon EMR ModifyInstanceGroups API to support "MERGE" type cluster reconfiguration. Also, added the ability to specify a particular Amazon Linux release for all nodes in a cluster launch request.
* `service/migration-hub-refactor-spaces`: Updates service documentation

Release v1.44.10 (2022-05-09)
===

### Service Client Updates
* `service/cloudcontrol`: Updates service API, documentation, waiters, and paginators
* `service/evidently`: Updates service API and documentation
* `service/ssm-contacts`: Updates service documentation and examples

Release v1.44.9 (2022-05-06)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Add new state values for IPAMs, IPAM Scopes, and IPAM Pools.
* `service/location`: Updates service API, documentation, and paginators
* `service/mediapackage`: Updates service API and documentation
  * This release adds Dvb Dash 2014 as an available profile option for Dash Origin Endpoints.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Various documentation improvements.
* `service/redshift`: Updates service API and documentation
  * Introduces new field 'LoadSampleData' in CreateCluster operation. Customers can now specify 'LoadSampleData' option during creation of a cluster, which results in loading of sample data in the cluster that is created.
* `service/securityhub`: Updates service documentation

Release v1.44.8 (2022-05-05)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Amazon EC2 I4i instances are powered by 3rd generation Intel Xeon Scalable processors and feature up to 30 TB of local AWS Nitro SSD storage
* `service/iot`: Updates service API and documentation
  * AWS IoT Jobs now allows you to create up to 100,000 active continuous and snapshot jobs by using concurrency control.
* `service/kendra`: Updates service API, documentation, and paginators
  * AWS Kendra now supports hierarchical facets for a query. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/filtering.html

Release v1.44.7 (2022-05-04)
===

### Service Client Updates
* `service/backup`: Updates service API, documentation, and paginators
* `service/iotsecuretunneling`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/ssm`: Updates service API and documentation
  * This release adds the TargetMaps parameter in SSM State Manager API.

Release v1.44.6 (2022-05-03)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds support for allocating Dedicated Hosts on AWS  Outposts. The AllocateHosts API now accepts an OutpostArn request  parameter, and the DescribeHosts API now includes an OutpostArn response parameter.
* `service/kinesis-video-archived-media`: Updates service API, documentation, and paginators
* `service/kinesisvideo`: Updates service API and documentation
  * Add support for multiple image feature related APIs for configuring image generation and notification of a video stream. Add "GET_IMAGES" to the list of supported API names for the GetDataEndpoint API.
* `service/s3`: Updates service documentation and examples
  * Documentation only update for doc bug fixes for the S3 API docs.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Autopilot adds new metrics for all candidate models generated by Autopilot experiments; RStudio on SageMaker now allows users to bring your own development environment in a custom image.

Release v1.44.5 (2022-05-02)
===

### Service Client Updates
* `service/organizations`: Updates service API and documentation
  * This release adds the INVALID_PAYMENT_INSTRUMENT as a fail reason and an error message.
* `service/outposts`: Updates service API, documentation, and paginators
* `service/synthetics`: Updates service API and documentation

Release v1.44.4 (2022-04-29)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK nows supports creation of Dolby Vision profile 8.1, the ability to generate black frames of video, and introduces audio-only DASH and CMAF support.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Feature - Adds support for Internet Protocol Version 6 (IPv6) on RDS database instances.
* `service/ssm`: Updates service API and documentation
  * Update the StartChangeRequestExecution, adding TargetMaps to the Runbook parameter
* `service/wafv2`: Updates service API and documentation

Release v1.44.3 (2022-04-28)
===

### Service Client Updates
* `service/auditmanager`: Updates service documentation
* `service/braket`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support to query the public key and creation date of EC2 Key Pairs. Additionally, the format (pem or ppk) of a key pair can be specified when creating a new key pair.
* `service/guardduty`: Updates service documentation
  * Documentation update for API description.
* `service/network-firewall`: Updates service API and documentation

Release v1.44.2 (2022-04-27)
===

### Service Client Updates
* `service/amplify`: Updates service documentation
* `service/chime-sdk-media-pipelines`: Adds new service
* `service/cloudtrail`: Updates service API and documentation
  * Increases the retention period maximum to 2557 days. Deprecates unused fields of the ListEventDataStores API response. Updates documentation.
* `service/iotwireless`: Updates service API, documentation, and paginators
* `service/lookoutequipment`: Updates service API, documentation, and paginators
* `service/rekognition`: Updates service API and documentation
  * This release adds support to configure stream-processor resources for label detections on streaming-videos. UpateStreamProcessor API is also launched with this release, which could be used to update an existing stream-processor.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds support for custom validation dataset and validation ratio through the CreateAutoMLJob and DescribeAutoMLJob APIs.

Release v1.44.1 (2022-04-26)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * CloudFront now supports the Server-Timing header in HTTP responses sent from CloudFront. You can use this header to view metrics that help you gain insights about the behavior and performance of CloudFront. To use this header, enable it in a response headers policy.
* `service/glue`: Updates service documentation
  * This release adds documentation for the APIs to create, read, delete, list, and batch read of AWS Glue custom patterns, and for Lake Formation configuration settings in the AWS Glue crawler.
* `service/ivschat`: Updates service API, documentation, paginators, and examples
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Lightsail load balancer HTTP to HTTPS redirect and TLS policy configuration.
* `service/network-firewall`: Updates service API and documentation
* `service/pricing`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Inference Recommender now accepts customer KMS key ID for encryption of endpoints and compilation outputs created during inference recommendation.

Release v1.44.0 (2022-04-25)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/gamelift`: Updates service documentation
  * Documentation updates for Amazon GameLift.
* `service/mq`: Updates service API and documentation
  * This release adds the CRITICAL_ACTION_REQUIRED broker state and the ActionRequired API property. CRITICAL_ACTION_REQUIRED informs you when your broker is degraded. ActionRequired provides you with a code which you can use to find instructions in the Developer Guide on how to resolve the issue.
* `service/rds-data`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

### SDK Features
* `aws/request`: Fixes bug in WithSetRequestHeaders where the header key was added to the header map directly
  * Addresses an issue where the header keys being added were being added directly to the header map, and did not have the canonical header casing applied. This introduced bugs where instead of overwriting existing header key, it added another map entry.

Release v1.43.45 (2022-04-22)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and waiters
  * Adds support for waiters that automatically poll for a deleted NAT Gateway until it reaches the deleted state.

Release v1.43.44 (2022-04-21)
===

### Service Client Updates
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/glue`: Updates service API, documentation, and paginators
  * This release adds APIs to create, read, delete, list, and batch read of Glue custom entity types
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/iottwinmaker`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/storagegateway`: Updates service API and documentation
  * This release adds support for minimum of 5 character length virtual tape barcodes.
* `service/wisdom`: Updates service API and documentation

Release v1.43.43 (2022-04-20)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/macie2`: Updates service API and documentation
* `service/mgn`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Added a new cluster-level attribute to set the capacity range for Aurora Serverless v2 instances.

Release v1.43.42 (2022-04-19)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * EC2 Auto Scaling now adds default instance warm-up times for all scaling activities, health check replacements, and other replacement events in the Auto Scaling instance lifecycle.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Quip. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-quip.html
* `service/kms`: Updates service API, documentation, and examples
  * Adds support for KMS keys and APIs that generate and verify HMAC codes
* `service/personalize`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new Austrian German voice - Hannah. Hannah is available as Neural voice only.
* `service/redshift`: Updates service API and documentation
  * Introduces new fields for LogDestinationType and LogExports on EnableLogging requests and Enable/Disable/DescribeLogging responses. Customers can now select CloudWatch Logs as a destination for their Audit Logs.
* `service/ssm`: Updates service API and documentation
  * Added offset support for specifying the number of days to wait after the date and time specified by a CRON expression when creating SSM association.
* `service/textract`: Updates service API and documentation
* `service/transfer`: Updates service documentation
  * This release contains corrected HomeDirectoryMappings examples for several API functions: CreateAccess, UpdateAccess, CreateUser, and UpdateUser,.
* `service/worklink`: Updates service API

Release v1.43.41 (2022-04-15)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release adds subfields, ErrorMessage, Retryable, to the AthenaError response object in the GetQueryExecution API when a query fails.
* `service/lightsail`: Updates service API and documentation
  * This release adds support to describe the synchronization status of the account-level block public access feature for your Amazon Lightsail buckets.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Removes Amazon RDS on VMware with the deletion of APIs related to Custom Availability Zones and Media installation

Release v1.43.40 (2022-04-14)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/appstream`: Updates service API and documentation
  * Includes updates for create and update fleet APIs to manage the session scripts locations for Elastic fleets.
* `service/batch`: Updates service API and documentation
  * Enables configuration updates for compute environments with BEST_FIT_PROGRESSIVE and SPOT_CAPACITY_OPTIMIZED allocation strategies.
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2.
* `service/glue`: Updates service API and documentation
  * Auto Scaling for Glue version 3.0 and later jobs to dynamically scale compute resources. This SDK change provides customers with the auto-scaled DPU usage
* `service/monitoring`: Updates service documentation
  * Updates documentation for additional statistics in CloudWatch Metric Streams.

Release v1.43.39 (2022-04-13)
===

### Service Client Updates
* `service/fsx`: Updates service API, documentation, and paginators
* `service/monitoring`: Updates service API and documentation
  * Adds support for additional statistics in CloudWatch Metric Streams.

Release v1.43.38 (2022-04-12)
===

### Service Client Updates
* `service/devops-guru`: Updates service API and documentation
* `service/ec2`: Updates service API
  * X2idn and X2iedn instances are powered by 3rd generation Intel Xeon Scalable processors with an all-core turbo frequency up to 3.5 GHzAmazon EC2. C6a instances are powered by 3rd generation AMD EPYC processors.
* `service/elasticfilesystem`: Updates service API and documentation
  * Amazon EFS adds support for a ThrottlingException when using the CreateAccessPoint API if the account is nearing the AccessPoint limit(120).
* `service/iottwinmaker`: Updates service API and documentation

Release v1.43.37 (2022-04-11)
===

### Service Client Updates
* `service/amplifyuibuilder`: Updates service API and documentation
* `service/apprunner`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * Added API support that allows customers to create GPU-enabled WorkSpaces using EC2 G4dn instances.

Release v1.43.36 (2022-04-08)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for the pass-through of WebVTT styling to WebVTT outputs, pass-through of KLV metadata to supported formats, and improved filter support for processing 444/RGB content.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.43.35 (2022-04-07)
===

### Service Client Updates
* `service/apigateway`: Updates service paginators
  * ApiGateway CLI command get-usage now includes usagePlanId, startDate, and endDate fields in the output to match documentation.
* `service/docdb`: Updates service API and documentation
  * Added support to enable/disable performance insights when creating or modifying db instances
* `service/eventbridge`: Updates service API and documentation
* `service/personalize`: Updates service API and documentation
* `service/pi`: Updates service documentation
* `service/sagemaker`: Updates service API
  * Amazon Sagemaker Notebook Instances now supports G5 instance types

Release v1.43.34 (2022-04-06)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Box. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html
* `service/lambda`: Updates service API, documentation, and paginators
  * This release adds new APIs for creating and managing Lambda Function URLs and adds a new FunctionUrlAuthType parameter to the AddPermission API. Customers can use Function URLs to create built-in HTTPS endpoints on their functions.
* `service/panorama`: Updates service API and documentation

Release v1.43.33 (2022-04-05)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/s3control`: Updates service documentation
  * Documentation-only update for doc bug fixes for the S3 Control API docs.
* `service/securityhub`: Updates service API and documentation

Release v1.43.32 (2022-04-04)
===

### Service Client Updates
* `service/iot`: Updates service API, documentation, and paginators
  * AWS IoT - AWS IoT Device Defender adds support to list metric datapoints collected for IoT devices through the ListMetricValues API
* `service/proton`: Updates service API and documentation
* `service/servicecatalog`: Updates service API and documentation
  * This release adds ProvisioningArtifictOutputKeys to DescribeProvisioningParameters to reference the outputs of a Provisioned Product and deprecates ProvisioningArtifactOutputs.
* `service/sms`: Updates service documentation
  * Revised product update notice for SMS console deprecation.

Release v1.43.31 (2022-04-01)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation

Release v1.43.30 (2022-03-31)
===

### Service Client Updates
* `service/auditmanager`: Updates service documentation
* `service/cloudcontrol`: Updates service API and documentation
* `service/databrew`: Updates service API and documentation
* `service/grafana`: Updates service API and documentation
* `service/pinpoint-sms-voice-v2`: Adds new service
* `service/route53-recovery-cluster`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * Added APIs that allow you to customize the logo, login message, and help links in the WorkSpaces client login page. To learn more, visit https://docs.aws.amazon.com/workspaces/latest/adminguide/customize-branding.html

Release v1.43.29 (2022-03-30)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release simplifies the auto-recovery configuration process enabling customers to set the recovery behavior to disabled or default
* `service/fms`: Updates service API, documentation, and paginators
* `service/fsx`: Updates service API and documentation
* `service/iot`: Updates service documentation
  * Doc only update for IoT that fixes customer-reported issues.
* `service/iot-data`: Updates service API and documentation

Release v1.43.28 (2022-03-29)
===

### Service Client Updates
* `service/organizations`: Updates service API and documentation
  * This release provides the new CloseAccount API that enables principals in the management account to close any member account within an organization.

Release v1.43.27 (2022-03-28)
===

### Service Client Updates
* `service/acm-pca`: Updates service documentation
* `service/medialive`: Updates service API and documentation
  * This release adds support for selecting a maintenance window.

Release v1.43.26 (2022-03-25)
===

### Service Client Updates
* `service/batch`: Updates service documentation
  * Bug Fix: Fixed a bug where shapes were marked as unboxed and were not serialized and sent over the wire, causing an API error from the service.
* `service/ec2`: Updates service API and documentation
  * This is release adds support for Amazon VPC Reachability Analyzer to analyze path through a Transit Gateway.
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release supports creating, updating, and deleting Patch Baselines for Rocky Linux OS.

Release v1.43.25 (2022-03-24)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Adds support for increased ephemeral storage (/tmp) up to 10GB for Lambda functions. Customers can now provision up to 10 GB of ephemeral storage per function instance, a 20x increase over the previous limit of 512 MB.
* `service/transcribe`: Updates service API and documentation

Release v1.43.24 (2022-03-23)
===

### Service Client Updates
* `service/auditmanager`: Updates service API
* `service/ebs`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/gamesparks`: Adds new service
* `service/redshift`: Updates service API and documentation
  * This release adds a new [--encrypted | --no-encrypted] field in restore-from-cluster-snapshot API. Customers can now restore an unencrypted snapshot to a cluster encrypted with AWS Managed Key or their own KMS key.
* `service/ssm`: Updates service API and documentation
  * Update AddTagsToResource, ListTagsForResource, and RemoveTagsFromResource APIs to reflect the support for tagging Automation resources. Includes other minor documentation updates.
* `service/transfer`: Updates service documentation
  * Documentation updates for AWS Transfer Family to describe how to remove an associated workflow from a server.

Release v1.43.23 (2022-03-22)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/ecs`: Updates service documentation
  * Documentation only update to address tickets
* `service/lakeformation`: Updates service API
* `service/location`: Updates service API, documentation, and paginators
* `service/polly`: Updates service API and documentation
  * Amazon Polly adds new Catalan voice - Arlet. Arlet is available as Neural voice only.

Release v1.43.22 (2022-03-21)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/ecr`: Updates service documentation and paginators
  * This release includes a fix in the DescribeImageScanFindings paginated output.
* `service/mediaconnect`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * AWS QuickSight Service Features - Expand public API support for group management.
* `service/ram`: Updates service documentation

Release v1.43.21 (2022-03-18)
===

### Service Client Updates
* `service/glue`: Updates service API, documentation, and paginators
  * Added 9 new APIs for AWS Glue Interactive Sessions: ListSessions, StopSession, CreateSession, GetSession, DeleteSession, RunStatement, GetStatement, ListStatements, CancelStatement

Release v1.43.20 (2022-03-16)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/amplifybackend`: Updates service API and documentation
* `service/billingconductor`: Adds new service
* `service/s3outposts`: Updates service API, documentation, and paginators
* `service/ssm-incidents`: Updates service API and documentation

Release v1.43.19 (2022-03-15)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/dataexchange`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Adds the Cascade parameter to the DeleteIpam API. Customers can use this parameter to automatically delete their IPAM, including non-default scopes, pools, cidrs, and allocations. There mustn't be any pools provisioned in the default public scope to use this parameter.
* `service/ecs`: Updates service documentation
  * Documentation only update to address tickets
* `service/keyspaces`: Updates service documentation
* `service/location`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Various documentation improvements
* `service/robomaker`: Updates service API and documentation

Release v1.43.18 (2022-03-14)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Slack. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html
* `service/timestream-query`: Updates service API

Release v1.43.17 (2022-03-11)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Chime VoiceConnector Logging APIs will now support MediaMetricLogs. Also CreateMeetingDialOut now returns AccessDeniedException.
* `service/connect`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Adds PrincipalOrgID support to AddPermission API. Customers can use it to manage permissions to lambda functions at AWS Organizations level.
* `service/outposts`: Updates service API and documentation
* `service/secretsmanager`: Updates service documentation and examples
  * Documentation updates for Secrets Manager.
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.43.16 (2022-03-10)
===

### Service Client Updates
* `service/models.lex.v2`: Updates service API
* `service/transcribe`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Adding more descriptive error types for managed workflows

Release v1.43.15 (2022-03-09)
===

### Service Client Updates
* `service/comprehend`: Updates service API, documentation, and paginators

Release v1.43.14 (2022-03-08)
===

### Service Client Updates
* `service/eks`: Updates service API
* `service/keyspaces`: Updates service documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for reading timecode from AVCHD sources and now provides the ability to segment WebVTT at the same interval as the video and audio in HLS packages.

Release v1.43.13 (2022-03-07)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Amazon ECS UpdateService API now supports additional parameters: loadBalancers, propagateTags, enableECSManagedTags, and serviceRegistries
* `service/migration-hub-refactor-spaces`: Updates service documentation

Release v1.43.12 (2022-03-04)
===

### Service Client Updates
* `service/connect`: Updates service API
* `service/devops-guru`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Documentation updates for Amazon EC2.
* `service/macie`: Updates service documentation
  * Amazon Macie Classic (macie) has been discontinued and is no longer available. A new Amazon Macie (macie2) is now available with significant design improvements and additional features.
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.
* `service/synthetics`: Updates service API and documentation
* `service/transfer`: Updates service waiters
  * Add waiters for server online and offline.

Release v1.43.11 (2022-03-03)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/greengrassv2`: Updates service documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now suggests spell corrections for a query. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/query-spell-check.html
* `service/timestream-query`: Updates service documentation

Release v1.43.10 (2022-03-02)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release adds support for S3 Object Ownership by allowing the S3 bucket owner full control canned ACL to be set when Athena writes query results to S3 buckets.
* `service/cloudtrail`: Updates service API and documentation
  * Add bytesScanned field into responses of DescribeQuery and GetQueryResults.
* `service/ecr`: Updates service API and documentation
  * This release adds support for tracking images lastRecordedPullTime.
* `service/gamelift`: Updates service documentation
  * Minor updates to address errors.
* `service/keyspaces`: Updates service API, documentation, waiters, paginators, and examples

Release v1.43.9 (2022-03-01)
===

### Service Client Updates
* `service/kafkaconnect`: Updates service API and documentation
* `service/mediapackage`: Updates service API
  * This release adds Hybridcast as an available profile option for Dash Origin Endpoints.
* `service/mgn`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for Multi-AZ DB clusters.

Release v1.43.8 (2022-02-28)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/amplifyuibuilder`: Updates service API, documentation, and paginators
* `service/athena`: Updates service API and documentation
  * This release adds support for updating an existing named query.
* `service/ec2`: Updates service API and documentation
  * This release adds support for new AMI property 'lastLaunchedTime'
* `service/finspace-data`: Updates service API, documentation, and paginators
* `service/fis`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/route53-recovery-cluster`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Updates service API

Release v1.43.7 (2022-02-25)
===

### Service Client Updates
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/panorama`: Updates service API and documentation

Release v1.43.6 (2022-02-24)
===

### Service Client Updates
* `service/autoscaling`: Updates service API, documentation, and examples
  * You can now hibernate instances in a warm pool to stop instances without deleting their RAM contents. You can now also return instances to the warm pool on scale in, instead of always terminating capacity that you will need later.
* `service/databrew`: Updates service API and documentation
* `service/fms`: Updates service API and documentation
* `service/lightsail`: Updates service API and documentation
  * This release adds support to delete and create Lightsail default key pairs that you can use with Lightsail instances.
* `service/route53`: Updates service documentation
  * SDK doc update for Route 53 to update some parameters with new information.
* `service/s3`: Updates service examples
  * This release adds support for new integrity checking capabilities in Amazon S3. You can choose from four supported checksum algorithms for data integrity checking on your upload and download requests. In addition, AWS SDK can automatically calculate a checksum as it streams data into S3
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations adds support for new integrity checking capabilities in Amazon S3.
* `service/transfer`: Updates service paginators
  * Support automatic pagination when listing AWS Transfer Family resources.

Release v1.43.5 (2022-02-23)
===

### Service Client Updates
* `service/lambda`: Updates service API, documentation, and waiters
  * Lambda releases .NET 6 managed runtime to be available in all commercial regions.
* `service/textract`: Updates service API
* `service/transfer`: Updates service API and documentation
  * The file input selection feature provides the ability to use either the originally uploaded file or the output file from the previous workflow step, enabling customers to make multiple copies of the original file while keeping the source file intact for file archival.

Release v1.43.4 (2022-02-22)
===

### Service Client Updates
* `service/apprunner`: Updates service API
* `service/translate`: Updates service API and documentation
* `service/wafv2`: Updates service documentation

### SDK Bugs
* `service/lexruntimev2`: Add fix to prevent HTTP/2 event stream request hang on error with Go 1.15 through 1.17.
* `service/transcribestreamingservice`: Add fix to prevent HTTP/2 event stream request hang on error with Go 1.15 through 1.17.
  * Adds fix addressing an issue where SDK's bi-directional eventstream API operation request could hang when the HTTP/2 stream was closed by the service with a non-200 status code.

Release v1.43.3 (2022-02-21)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * DynamoDB ExecuteStatement API now supports Limit as a request parameter to specify the maximum number of items to evaluate. If specified, the service will process up to the Limit and the results will include a LastEvaluatedKey value to continue the read in a subsequent operation.
* `service/imagebuilder`: Updates service API and documentation

Release v1.43.2 (2022-02-18)
===

### Service Client Updates
* `service/budgets`: Updates service API, documentation, and paginators
  * This change introduces DescribeBudgetNotificationsForAccount API which returns budget notifications for the specified account
* `service/gamelift`: Updates service documentation
  * Increase string list limit from 10 to 100.
* `service/transfer`: Updates service API and documentation
  * Properties for Transfer Family used with SFTP, FTP, and FTPS protocols. Display Banners are bodies of text that can be displayed before and/or after a user authenticates onto a server using one of the previously mentioned protocols.

Release v1.43.1 (2022-02-17)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/evidently`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/redshift`: Updates service API and documentation
  * SDK release for Cross region datasharing and cost-control for cross region datasharing

Release v1.43.0 (2022-02-16)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Adds support for auto-adjusting budgets, a new budget method alongside fixed and planned. Auto-adjusting budgets introduces new metadata to configure a budget limit baseline using a historical lookback average or current period forecast.
* `service/ce`: Updates service API
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2.
* `service/glue`: Updates service API and documentation
  * Support for optimistic locking in UpdateTable
* `service/ssm`: Updates service documentation
  * Assorted ticket fixes and updates for AWS Systems Manager.

### SDK Features
* `codegen`: Updates the SDK's code generation to stop supporting new API modeled JSONValue parameters. The SDK's JSONValue type is only compatible with JSON documents with a top level JSON Object. JSON Lists, Strings, Scalars, are not compatible. This prevents JSON Value working with some APIs such as Amazon Lex Runtime Service's operations. 
  * Related to [#4264](https://github.com/aws/aws-sdk-go/pull/4264) and [#4258](https://github.com/aws/aws-sdk-go/issues/4258)

### SDK Bugs
* `service/lexruntimeservice`: Introduces a breaking change for following parameters from a JSONValue to string type, because the SDKs JSONValue is not compatible with JSON documents of lists.
  * PostContentInput.ActiveContexts
  * PutContentOutput.AlternativeIntents
  * PutContentOutput.ActiveContexts
  * PutSessionOutput.ActiveContexts
  * Fixes [#4258](https://github.com/aws/aws-sdk-go/issues/4258)

Release v1.42.53 (2022-02-14)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/athena`: Updates service API and documentation
  * This release adds a subfield, ErrorType, to the AthenaError response object in the GetQueryExecution API when a query fails.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for determining which Aurora PostgreSQL versions support Babelfish.

Release v1.42.52 (2022-02-11)
===

### Service Client Updates
* `service/ssm`: Updates service API
  * Documentation updates for AWS Systems Manager.

Release v1.42.51 (2022-02-10)
===

### Service Client Updates
* `service/cloudformation`: Updates service API
  * This SDK release adds AWS CloudFormation Hooks HandlerErrorCodes
* `service/lookoutvision`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This SDK release adds a new paramater creation date for GetApp and GetApps Api call
* `service/sns`: Updates service documentation
  * Customer requested typo fix in API documentation.
* `service/wafv2`: Updates service API and documentation

Release v1.42.50 (2022-02-09)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * This SDK release is for the feature launch of AWS CloudFormation Hooks.

Release v1.42.49 (2022-02-08)
===

### Service Client Updates
* `service/apprunner`: Updates service API, documentation, and paginators
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Amazon FSx. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-fsx.html
* `service/s3control`: Updates service API and documentation
  * This release adds support for S3 Batch Replication. Batch Replication lets you replicate existing objects, already replicated objects to new destinations, and objects that previously failed to replicate. Customers will receive object-level visibility of progress and a detailed completion report.
* `service/sagemaker`: Updates service API and documentation
  * Autopilot now generates an additional report with information on the performance of the best model, such as a Confusion matrix and  Area under the receiver operating characteristic (AUC-ROC). The path to the report can be found in CandidateArtifactLocations.

Release v1.42.48 (2022-02-07)
===

### Service Client Updates
* `service/auditmanager`: Updates service API
* `service/eventbridge`: Updates service documentation
* `service/ssm-incidents`: Updates service API
* `service/synthetics`: Updates service API and documentation

Release v1.42.47 (2022-02-04)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * You can now optionally specify the account ID that you expect to be the owner of your query results output location bucket in Athena. If the account ID of the query results bucket owner does not match the specified account ID, attempts to output to the bucket will fail with an S3 permissions error.
* `service/lakeformation`: Updates service API
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * updates for RDS Custom for Oracle 12.1 support

Release v1.42.46 (2022-02-03)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * adds support for AMIs in Recycle Bin
* `service/meteringmarketplace`: Updates service API and documentation
  * Add CustomerAWSAccountId to ResolveCustomer API response and increase UsageAllocation limit to 2500.
* `service/rbin`: Updates service API and documentation
* `service/robomaker`: Updates service API and documentation

Release v1.42.45 (2022-02-02)
===

### Service Client Updates
* `service/appflow`: Updates service API, documentation, and paginators
* `service/ce`: Updates service API and documentation
* `service/comprehend`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation update for DynamoDB Java SDK.
* `service/elasticache`: Updates service documentation
  * Documentation update for AWS ElastiCache
* `service/elasticmapreduce`: Updates service documentation
  * Documentation updates for Amazon EMR.
* `service/es`: Updates service API and documentation
  * Allows customers to get progress updates for blue/green deployments
* `service/fis`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Launch Protobuf support for AWS Glue Schema Registry
* `service/iot`: Updates service API
  * This release adds support for configuring AWS IoT logging level per client ID, source IP, or principal ID.
* `service/personalize`: Updates service API and documentation

Release v1.42.44 (2022-01-28)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/appconfigdata`: Updates service API and documentation
* `service/athena`: Updates service API and documentation
  * This release adds a field, AthenaError, to the GetQueryExecution response object when a query fails.
* `service/cognito-idp`: Updates service documentation
* `service/sagemaker`: Updates service API
  * This release added a new NNA accelerator compilation support for Sagemaker Neo.
* `service/secretsmanager`: Updates service API and documentation
  * Feature are ready to release on Jan 28th

Release v1.42.43 (2022-01-27)
===

### Service Client Updates
* `service/amplify`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API
  * X2ezn instances are powered by Intel Cascade Lake CPUs that deliver turbo all core frequency of up to 4.5 GHz and up to 100 Gbps of networking bandwidth
* `service/kafka`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation

### SDK Bugs
* `aws/request`: Update Request Send to always ensure Request.HTTPResponse is populated.
    * Fixes [#4211](https://github.com/aws/aws-sdk-go/issues/4211)

Release v1.42.42 (2022-01-26)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API, documentation, and waiters
* `service/ebs`: Updates service documentation
* `service/frauddetector`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * API changes relating to Fail steps in model building pipeline and add PipelineExecutionFailureReason in PipelineExecutionSummary.
* `service/securityhub`: Updates service API and documentation

Release v1.42.41 (2022-01-25)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/elasticfilesystem`: Updates service API and documentation
  * Use Amazon EFS Replication to replicate your Amazon EFS file system in the AWS Region of your preference.
* `service/fsx`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Amazon GuardDuty expands threat detection coverage to protect Amazon Elastic Kubernetes Service (EKS) workloads.

Release v1.42.40 (2022-01-24)
===

### Service Client Updates
* `service/route53-recovery-readiness`: Updates service documentation

Release v1.42.39 (2022-01-21)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for 4K AV1 output resolutions & 10-bit AV1 color, the ability to ingest sidecar Dolby Vision XML metadata files, and the ability to flag WebVTT and IMSC tracks for accessibility in HLS.
* `service/transcribe`: Updates service API and documentation

Release v1.42.38 (2022-01-20)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API
  * C6i, M6i and R6i instances are powered by a third-generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz
* `service/fis`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Amazon GuardDuty findings now include remoteAccountDetails under AwsApiCallAction section if instance credential is exfiltrated.
* `service/mediatailor`: Updates service API and documentation

Release v1.42.37 (2022-01-19)
===

### Service Client Updates
* `service/ec2-instance-connect`: Updates service API and documentation
* `service/macie2`: Updates service API

Release v1.42.36 (2022-01-18)
===

### Service Client Updates
* `service/cloudtrail`: Updates service documentation
  * This release fixes a documentation bug in the description for the readOnly field selector in advanced event selectors. The description now clarifies that users omit the readOnly field selector to select both Read and Write management events.
* `service/ec2`: Updates service API and documentation
  * Add support for AWS Client VPN client login banner and session timeout.
* `service/ivs`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/storagegateway`: Updates service documentation
  * Documentation update for adding bandwidth throttling support for S3 File Gateways.

Release v1.42.35 (2022-01-14)
===

### Service Client Updates
* `service/application-insights`: Updates service API
* `service/config`: Updates service API
* `service/honeycode`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation
* `service/ram`: Updates service API, documentation, and paginators

Release v1.42.34 (2022-01-13)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * AWS ElastiCache for Redis has added a new Engine Log LogType in LogDelivery feature. You can now publish the Engine Log from your Amazon ElastiCache for Redis clusters to Amazon CloudWatch Logs and Amazon Kinesis Data Firehose.
* `service/glue`: Updates service API and documentation
  * This SDK release adds support to pass run properties when starting a workflow run
* `service/nimble`: Updates service API and documentation
* `service/pinpoint`: Updates service API
  * Adds JourneyChannelSettings to WriteJourneyRequest
* `service/runtime.lex.v2`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager adds category support for DescribeDocument API

Release v1.42.33 (2022-01-12)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Hpc6a instances are powered by a third-generation AMD EPYC processors (Milan) delivering all-core turbo frequency of 3.4 GHz
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/fms`: Updates service API and documentation
* `service/honeycode`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API and documentation
* `service/pi`: Updates service API, documentation, and paginators

Release v1.42.32 (2022-01-11)
===

### Service Client Updates
* `service/ce`: Updates service documentation
* `service/ec2`: Updates service API
  * EC2 Capacity Reservations now supports RHEL instance platforms (RHEL with SQL Server Standard, RHEL with SQL Server Enterprise, RHEL with SQL Server Web, RHEL with HA, RHEL with HA and SQL Server Standard, RHEL with HA and SQL Server Enterprise)
* `service/finspace-data`: Updates service documentation
* `service/iotevents-data`: Updates service documentation
* `service/kendra`: Updates service API, documentation, and paginators
  * Amazon Kendra now supports advanced query language and query-less search.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds the db-proxy event type to support subscribing to RDS Proxy events.
* `service/workspaces`: Updates service API and documentation
  * Introducing new APIs for Workspaces audio optimization with Amazon Connect: CreateConnectClientAddIn, DescribeConnectClientAddIns, UpdateConnectClientAddIn and DeleteConnectClientAddIn.

Release v1.42.31 (2022-01-10)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/databrew`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * New feature: Updated EC2 API to support faster launching for Windows images. Optimized images are pre-provisioned, using snapshots to launch instances up to 65% faster.
* `service/lookoutmetrics`: Updates service API and documentation
* `service/transcribe`: Updates service documentation

Release v1.42.30 (2022-01-07)
===

### Service Client Updates
* `service/medialive`: Updates service API and documentation
  * This release adds support for selecting the Program Date Time (PDT) Clock source algorithm for HLS outputs.

Release v1.42.29 (2022-01-06)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release introduces On-Demand Capacity Reservation support for Cluster Placement Groups, adds Tags on instance Metadata, and includes documentation updates for Amazon EC2.
* `service/es`: Updates service API and documentation
  * Amazon OpenSearch Service adds support for Fine Grained Access Control for existing domains running Elasticsearch version 6.7 and above
* `service/iotwireless`: Updates service API, documentation, and paginators
* `service/mediatailor`: Updates service API and documentation
* `service/mwaa`: Updates service API and documentation
* `service/opensearch`: Updates service API and documentation

Release v1.42.28 (2022-01-05)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Includes APIs for App Entitlement management regarding entitlement and entitled application association.
* `service/cloudtrail`: Updates service API, documentation, and paginators
  * This release adds support for CloudTrail Lake, a new feature that lets you run SQL-based queries on events that you have aggregated into event data stores. New APIs have been added for creating and managing event data stores, and creating, running, and managing queries in CloudTrail Lake.
* `service/ec2`: Updates service API and documentation
  * This release adds a new API called ModifyVpcEndpointServicePayerResponsibility which allows VPC endpoint service owners to take payer responsibility of their VPC Endpoint connections.
* `service/ecs`: Updates service documentation
  * Documentation update for ticket fixes.
* `service/eks`: Updates service API and documentation
* `service/glue`: Updates service API, documentation, and paginators
  * Add Delta Lake target support for Glue Crawler and 3rd Party Support for Lake Formation
* `service/iot`: Updates service API and documentation
  * This release adds an automatic retry mechanism for AWS IoT Jobs. You can now define a maximum number of retries for each Job rollout, along with the criteria to trigger the retry for FAILED/TIMED_OUT/ALL(both FAILED an TIMED_OUT) job.
* `service/lakeformation`: Updates service API and documentation
* `service/quicksight`: Updates service documentation
  * Multiple Doc-only updates for Amazon QuickSight.
* `service/sagemaker`: Updates service API
  * Amazon SageMaker now supports running training jobs on ml.g5 instance types.
* `service/snowball`: Updates service API, documentation, and examples
  * Updating validation rules for interfaces used in the Snowball API to tighten security of service.

Release v1.42.27 (2022-01-04)
===

### Service Client Updates
* `service/rekognition`: Updates service API and documentation
  * This release introduces a new field IndexFacesModelVersion, which is the version of the face detect and storage model that was used when indexing the face vector.
* `service/s3`: Updates service documentation and examples
  * Minor doc-based updates based on feedback bugs received.
* `service/s3control`: Updates service documentation
  * Documentation updates for the renaming of Glacier to Glacier Flexible Retrieval.

### SDK Enhancements

* `aws/session`: Add options for customizing the construction of credential providers. Currently only supported for `stscreds.WebIdentityRoleProvider`.

Release v1.42.26 (2022-01-03)
===

### Service Client Updates
* `service/detective`: Updates service API, documentation, and paginators
* `service/greengrassv2`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added strength levels to the Sharpness Filter and now permits OGG files to be specified as sidecar audio inputs.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Multiple doc-only updates for Relational Database Service (RDS)
* `service/sagemaker`: Updates service API and documentation
  * The release allows users to pass pipeline definitions as Amazon S3 locations and control the pipeline execution concurrency using ParallelismConfiguration. It also adds support of EMR jobs as pipeline steps.

Release v1.42.25 (2021-12-21)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/imagebuilder`: Updates service documentation
* `service/lookoutmetrics`: Updates service API, documentation, and paginators
* `service/mediaconnect`: Updates service API and documentation
* `service/nimble`: Updates service API and documentation
* `service/qldb`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Property for Transfer Family used with the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session.
* `service/workmail`: Updates service API and documentation
  * This release allows customers to change their email monitoring configuration in Amazon WorkMail.

Release v1.42.24 (2021-12-20)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/customer-profiles`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/finspace-data`: Updates service API and documentation
* `service/forecast`: Updates service API and documentation
* `service/imagebuilder`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/redshift`: Updates service API and documentation
  * This release adds API support for managed Redshift datashares. Customers can now interact with a Redshift datashare that is managed by a different service, such as AWS Data Exchange.
* `service/sagemaker`: Updates service API and documentation
  * This release adds a new ContentType field in AutoMLChannel for SageMaker CreateAutoMLJob InputDataConfig.
* `service/securityhub`: Updates service API and documentation

Release v1.42.23 (2021-12-13)
===

### Service Client Updates
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager

Release v1.42.22 (2021-12-09)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and waiters
  * Adds waiters support for internet gateways.
* `service/models.lex.v2`: Updates service API and documentation
* `service/network-firewall`: Updates service API and documentation
* `service/route53-recovery-control-config`: Updates service API and documentation
* `service/route53domains`: Updates service API, documentation, and paginators
  * Amazon Route 53 domain registration APIs now support filtering and sorting in the ListDomains API, deleting a domain by using the DeleteDomain API and getting domain pricing information by using the ListPrices API.
* `service/savingsplans`: Updates service documentation
* `service/sms`: Updates service documentation
  * This release adds SMS discontinuation information to the API and CLI references.

Release v1.42.21 (2021-12-08)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service API and documentation
* `service/health`: Updates service documentation
  * Documentation updates for AWS Health
* `service/iot`: Updates service API and documentation
  * This release allows customer to enable caching of custom authorizer on HTTP protocol for clients that use persistent or Keep-Alive connection in order to reduce the number of Lambda invocations.
* `service/logs`: Updates service API and documentation
  * This release adds AWS Organizations support as condition key in destination policy for cross account Subscriptions in CloudWatch Logs.
* `service/lookoutvision`: Updates service API, documentation, and paginators
* `service/outposts`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release added a new Ambarella device(amba_cv2) compilation support for Sagemaker Neo.
* `service/support`: Updates service documentation
  * Documentation updates for AWS Support.

Release v1.42.20 (2021-12-06)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/location`: Updates service API and documentation
* `service/route53`: Updates service API and documentation
  * Add PriorRequestNotComplete exception to UpdateHostedZoneComment API

Release v1.42.19 (2021-12-03)
===

### Service Client Updates
* `service/rekognition`: Updates service API and documentation
  * This release added new KnownGender types for Celebrity Recognition.

Release v1.42.18 (2021-12-02)
===

### Service Client Updates
* `service/amplifyuibuilder`: Adds new service
* `service/networkmanager`: Updates service API, documentation, and paginators
* `service/ram`: Updates service API and documentation

Release v1.42.17 (2021-12-01)
===

### Service Client Updates
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/directconnect`: Updates service API and documentation
  * Adds SiteLink support to private and transit virtual interfaces. SiteLink is a new Direct Connect feature that allows routing between Direct Connect points of presence.
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Add support for Table Classes and introduce the Standard Infrequent Access table class.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds support for Amazon VPC IP Address Manager (IPAM), which enables you to plan, track, and monitor IP addresses for your workloads. This release also adds support for VPC Network Access Analyzer, which enables you to analyze network access to resources in your Virtual Private Clouds.
* `service/kendra`: Updates service API, documentation, and paginators
  * Experience Builder allows customers to build search applications without writing code. Analytics Dashboard provides quality and usability metrics for Kendra indexes. Custom Document Enrichment allows customers to build a custom ingestion pipeline to pre-process documents and generate metadata.
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This release enables - 1/ Inference endpoint configuration recommendations and ability to run custom load tests to meet performance needs. 2/ Deploy serverless inference endpoints. 3/ Query, filter and retrieve end-to-end ML lineage graph, and incorporate model quality/bias detection in ML workflow.
* `service/shield`: Updates service API and documentation
  * This release adds API support for Automatic Application Layer DDoS Mitigation for AWS Shield Advanced. Customers can now enable automatic DDoS mitigation in count or block mode for layer 7 protected resources.

Release v1.42.16 (2021-11-30)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/backup-gateway`: Adds new service
* `service/ec2`: Updates service API and documentation
  * This release adds support for Is4gen and Im4gn instances. This release also adds a new subnet attribute, enableLniAtDeviceIndex, to support local network interfaces, which are logical networking components that connect an EC2 instance to your on-premises network.
* `service/fsx`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Support for DataLake transactions
* `service/iot`: Updates service API and documentation
  * Added the ability to enable/disable IoT Fleet Indexing for Device Defender and Named Shadow information, and search them through IoT Fleet Indexing APIs.
* `service/iottwinmaker`: Adds new service
* `service/kafka`: Updates service API, documentation, and paginators
* `service/kinesis`: Updates service API and documentation
  * Amazon Kinesis Data Streams now supports on demand streams.
* `service/lakeformation`: Updates service API, documentation, and paginators
* `service/outposts`: Updates service API and documentation
* `service/redshift-data`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Introduce Amazon S3 Glacier Instant Retrieval storage class and a new setting in S3 Object Ownership to disable ACLs for bucket and the objects in it.
* `service/snowball`: Updates service API and documentation
  * Tapeball is to integrate tape gateway onto snowball, it enables customer to transfer local data on the tape to snowball,and then ingest the data into tape gateway on the cloud.
* `service/storagegateway`: Updates service API and documentation
  * Added gateway type VTL_SNOW. Added new SNOWBALL HostEnvironment for gateways running on a Snowball device. Added new field HostEnvironmentId to serve as an identifier for the HostEnvironment on which the gateway is running.
* `service/workspaces-web`: Adds new service

Release v1.42.15 (2021-11-29)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/dataexchange`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds support for G5g and M6a instances. This release also adds support for Amazon EBS Snapshots Archive, a feature that enables you to archive your EBS snapshots; and Recycle Bin, a feature that enables you to protect your EBS snapshots against accidental deletion.
* `service/ecr`: Updates service API, documentation, and paginators
  * This release adds supports for pull through cache rules and enhanced scanning.
* `service/evidently`: Updates service API, documentation, paginators, and examples
* `service/inspector2`: Adds new service
* `service/iotsitewise`: Updates service API and documentation
* `service/rbin`: Updates service API, documentation, paginators, and examples
* `service/rum`: Updates service API, documentation, paginators, and examples
* `service/s3`: Updates service API, documentation, and examples
  * Amazon S3 Event Notifications adds Amazon EventBridge as a destination and supports additional event types. The PutBucketNotificationConfiguration API can now skip validation of Amazon SQS, Amazon SNS and AWS Lambda destinations.
* `service/ssm`: Updates service API and documentation
  * Added two new attributes to DescribeInstanceInformation called SourceId and SourceType along with new string filters SourceIds and SourceTypes to filter instance records.
* `service/wellarchitected`: Updates service API, documentation, and paginators

Release v1.42.14 (2021-11-29)
===

### Service Client Updates
* `service/migration-hub-refactor-spaces`: Adds new service
* `service/personalize`: Updates service API, documentation, and paginators
* `service/personalize-runtime`: Updates service API and documentation
* `service/textract`: Updates service API and documentation

Release v1.42.13 (2021-11-26)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling.
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2.
* `service/iotdeviceadvisor`: Updates service documentation
* `service/mgn`: Updates service API, documentation, and paginators
* `service/outposts`: Updates service API, documentation, and paginators
* `service/pinpoint`: Updates service API and documentation
  * Added a One-Time Password (OTP) management feature. You can use the Amazon Pinpoint API to generate OTP codes and send them to your users as SMS messages. Your apps can then call the API to verify the OTP codes that your users input

Release v1.42.12 (2021-11-24)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Customers can now configure predictive scaling policies to proactively scale EC2 Auto Scaling groups based on any CloudWatch metrics that more accurately represent the load on the group than the four predefined metrics. They can also use math expressions to further customize the metrics.
* `service/customer-profiles`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/imagebuilder`: Updates service API and documentation
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/lambda`: Updates service API, documentation, and paginators
  * Remove Lambda function url apis
* `service/proton`: Updates service API, documentation, and paginators
* `service/timestream-query`: Updates service API, documentation, and paginators
* `service/timestream-write`: Updates service API and documentation
* `service/translate`: Updates service API and documentation

### SDK Bugs
* `aws/crr`: Fixed a race condition that caused concurrent calls relying on endpoint discovery to share the same `url.URL` reference in their operation's `http.Request`.

Release v1.42.11 (2021-11-23)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * DynamoDB PartiQL now supports ReturnConsumedCapacity, which returns capacity units consumed by PartiQL APIs if the request specified returnConsumedCapacity parameter. PartiQL APIs include ExecuteStatement, BatchExecuteStatement, and ExecuteTransaction.
* `service/ec2`: Updates service API and documentation
  * This release adds a new parameter ipv6Native to the allow creation of IPv6-only subnets using the CreateSubnet operation, and the operation ModifySubnetAttribute includes new parameters to modify subnet attributes to use resource-based naming and enable DNS resolutions for Private DNS name.
* `service/ecs`: Updates service documentation
  * Documentation update for ARM support on Amazon ECS.
* `service/elasticache`: Updates service API and documentation
  * Adding support for r6gd instances for Redis with data tiering. In a cluster with data tiering enabled, when available memory capacity is exhausted, the least recently used data is automatically tiered to solid state drives for cost-effective capacity scaling with minimal performance impact.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/finspace-data`: Updates service documentation
* `service/iot`: Updates service API and documentation
  * This release introduces a new feature, Managed Job Template, for AWS IoT Jobs Service. Customers can now use service provided managed job templates to easily create jobs for supported standard job actions.
* `service/iotdeviceadvisor`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Release Lambda event source filtering for SQS, Kinesis Streams, and DynamoDB Streams.
* `service/macie2`: Updates service documentation
* `service/opensearch`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds support for Multi-AZ DB clusters for RDS for MySQL and RDS for PostgreSQL.
* `service/redshift`: Updates service API, documentation, and paginators
  * This release adds support for reserved node exchange with restore/resize
* `service/s3`: Updates service API, documentation, and examples
  * Introduce two new Filters to S3 Lifecycle configurations - ObjectSizeGreaterThan and ObjectSizeLessThan. Introduce a new way to trigger actions on noncurrent versions by providing the number of newer noncurrent versions along with noncurrent days.
* `service/sqs`: Updates service API and documentation
  * Amazon SQS adds a new queue attribute, SqsManagedSseEnabled, which enables server-side queue encryption using SQS owned encryption keys.
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.
* `service/workspaces`: Updates service documentation
  * Documentation updates for Amazon WorkSpaces

Release v1.42.10 (2021-11-22)
===

### Service Client Updates
* `service/braket`: Updates service API, documentation, and paginators
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/cloudformation`: Updates service API and documentation
  * This release include SDK changes for the feature launch of Stack Import to Service Managed StackSet.
* `service/connect`: Updates service API, documentation, and paginators
* `service/dms`: Updates service API and documentation
  * Added new S3 endpoint settings to allow to convert the current UTC time into a specified time zone when a date partition folder is created. Using with 'DatePartitionedEnabled'.
* `service/eks`: Updates service API and documentation
* `service/es`: Updates service API and documentation
  * This release adds an optional parameter dry-run for the UpdateElasticsearchDomainConfig API to perform basic validation checks, and detect the deployment type that will be required for the configuration change, without actually applying the change.
* `service/finspace-data`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * Add support for Exasol data source, 1 click enterprise embedding and email customization.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds local backup support to Amazon RDS on AWS Outposts.
* `service/s3control`: Updates service API and documentation
  * Added Amazon CloudWatch publishing option for S3 Storage Lens metrics.
* `service/ssm`: Updates service API and documentation
  * Adds new parameter to CreateActivation API . This parameter is for "internal use only".
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.42.9 (2021-11-19)
===

### Service Client Updates
* `service/application-insights`: Updates service API
* `service/appstream`: Updates service API and documentation
  * Includes APIs for managing resources for Elastic fleets: applications, app blocks, and application-fleet associations.
* `service/batch`: Updates service documentation
  * Documentation updates for AWS Batch.
* `service/cloudformation`: Updates service API and documentation
  * The StackSets ManagedExecution feature will allow concurrency for non-conflicting StackSet operations and queuing the StackSet operations that conflict at a given time for later execution.
* `service/lambda`: Updates service API, documentation, and paginators
  * Add support for Lambda Function URLs. Customers can use Function URLs to create built-in HTTPS endpoints on their functions.
* `service/medialive`: Updates service API and documentation
  * This release adds support for specifying a SCTE-35 PID on input. MediaLive now supports SCTE-35 PID selection on inputs containing one or more active SCTE-35 PIDs.
* `service/redshift`: Updates service API and documentation
  * Added support of default IAM role for CreateCluster, RestoreFromClusterSnapshot and ModifyClusterIamRoles APIs
* `service/runtime.lex.v2`: Updates service API and documentation

Release v1.42.8 (2021-11-18)
===

### Service Client Updates
* `service/appconfig`: Updates service API, documentation, and examples
* `service/auditmanager`: Updates service API, documentation, and paginators
* `service/chime`: Updates service API and documentation
  * Adds new Transcribe API parameters to StartMeetingTranscription, including support for content identification and redaction (PII & PHI), partial results stabilization, and custom language models.
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/databrew`: Updates service API, documentation, and paginators
* `service/forecast`: Updates service API and documentation
* `service/ivs`: Updates service API, documentation, and paginators
* `service/kafka`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Added support for CLIENT_CERTIFICATE_TLS_AUTH and SERVER_ROOT_CA_CERTIFICATE as SourceAccessType for MSK and Kafka event source mappings.
* `service/models.lex.v2`: Updates service API and documentation
* `service/monitoring`: Updates service API and documentation
  * CloudWatch Anomaly Detection now supports anomaly detectors that use metric math as input.
* `service/redshift-data`: Updates service API and documentation

Release v1.42.7 (2021-11-17)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API and documentation
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway.
* `service/appconfigdata`: Adds new service
* `service/devops-guru`: Updates service paginators
* `service/drs`: Updates service API, documentation, paginators, and examples
* `service/redshift-data`: Updates service API and documentation
* `service/sns`: Updates service API and documentation
  * Amazon SNS introduces the PublishBatch API, which enables customers to publish up to 10 messages per API request. The new API is valid for Standard and FIFO topics.

Release v1.42.6 (2021-11-16)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API and documentation
  * CloudTrail Insights now supports ApiErrorRateInsight, which enables customers to identify unusual activity in their AWS account based on API error codes and their rate.
* `service/location`: Updates service API and documentation

Release v1.42.5 (2021-11-15)
===

### Service Client Updates
* `service/appstream`: Updates service API
  * This release includes support for images of AmazonLinux2 platform type.
* `service/dms`: Updates service API and documentation
  * Add Settings in JSON format for the source GCP MySQL endpoint
* `service/ec2`: Updates service API and documentation
  * Adds a new VPC Subnet attribute "EnableDns64." When enabled on IPv6 Subnets, the Amazon-Provided DNS Resolver returns synthetic IPv6 addresses for IPv4-only destinations.
* `service/eks`: Updates service API and documentation
* `service/migrationhubstrategy`: Adds new service
* `service/ssm`: Updates service API and documentation
  * Adds support for Session Reason and Max Session Duration for Systems Manager Session Manager.
* `service/transfer`: Updates service API and documentation
  * AWS Transfer Family now supports integrating a custom identity provider using AWS Lambda
* `service/wafv2`: Updates service API and documentation

Release v1.42.4 (2021-11-12)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API
  * C6i instances are powered by a third-generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz. G5 instances feature up to 8 NVIDIA A10G Tensor Core GPUs and second generation AMD EPYC processors.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added automatic modes for GOP configuration and added the ability to ingest screen recordings generated by Safari on MacOS 12 Monterey.
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release supports creating Patch Baselines for RaspberryPi OS (formerly Raspbian)

Release v1.42.3 (2021-11-11)
===

### Service Client Updates
* `service/dynamodb`: Updates service API, documentation, waiters, paginators, and examples
  * Updated Help section for "dynamodb update-contributor-insights" API
* `service/ec2`: Updates service API and documentation
  * This release provides an additional route target for the VPC route table.
* `service/translate`: Updates service API and documentation

Release v1.42.2 (2021-11-10)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release adds support for container instance health.
* `service/resiliencehub`: Adds new service

Release v1.42.1 (2021-11-09)
===

### Service Client Updates
* `service/batch`: Updates service API, documentation, paginators, and examples
  * Adds support for scheduling policy APIs.
* `service/greengrassv2`: Updates service API and documentation
* `service/health`: Updates service documentation
  * Documentation updates for AWS Health.

Release v1.42.0 (2021-11-08)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds internal validation on the GatewayAssociationState field
* `service/sagemaker`: Updates service API and documentation
  * SageMaker CreateEndpoint and UpdateEndpoint APIs now support additional deployment configuration to manage traffic shifting options and automatic rollback monitoring. DescribeEndpoint now shows new in-progress deployment details with stage status.
* `service/wafv2`: Updates service API and documentation

### SDK Features
* Support has been added for configuring endpoints with requirements such as FIPS and DualStack. ([#3938](https://github.com/aws/aws-sdk-go/pull/3938))
  * `AWS_USE_FIPS_ENDPOINT` and `AWS_USE_DUALSTACK_ENDPOINT` can be set to `true` or `false` in the environment to indicate an endpoint with the respective characteristic must be resolved.
  * `use_fips_endpoint` and `use_dualstack_endpoint` can be set to `true` or `false` in the shared config file to indicate an endpoint with the respective characteristic must be resolved.
  * Programmatic configuration of FIPS and DualStack endpoint resolution.
  * For more information see the `aws/session` package documentation.

Release v1.41.19 (2021-11-05)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * DescribeInstances now returns customer-owned IP addresses for instances running on an AWS Outpost.
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates and improvements.
* `service/translate`: Updates service API and documentation

Release v1.41.18 (2021-11-04)
===

### Service Client Updates
* `service/chime-sdk-meetings`: Adds new service
* `service/connect`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This release adds a new instance replacement strategy for EC2 Fleet, Spot Fleet. Now you can select an action to perform when your instance gets a rebalance notification. EC2 Fleet, Spot Fleet can launch a replacement then terminate the instance that received notification after a termination delay
* `service/iotwireless`: Updates service API, documentation, and paginators
* `service/sagemaker`: Updates service API and documentation
  * ListDevices and DescribeDevice now show Edge Manager agent version.

### SDK Bugs
* `aws/signer/v4`: Fix Signer not trimming header value spaces
  * Fixes the AWS Sigv4 signer to trim header value's whitespace when computing the canonical headers block of the string to sign.

Release v1.41.17 (2021-11-03)
===

### Service Client Updates
* `service/connectparticipant`: Updates service API
* `service/datasync`: Updates service API and documentation
* `service/finspace`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation

Release v1.41.16 (2021-11-02)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * CloudFront now supports response headers policies to add HTTP headers to the responses that CloudFront sends to viewers. You can use these policies to add CORS headers, control browser caching, and more, without modifying your origin or writing any code.
* `service/connect`: Updates service API and documentation
* `service/nimble`: Updates service API, documentation, waiters, paginators, and examples

Release v1.41.15 (2021-11-01)
===

### Service Client Updates
* `service/lightsail`: Updates service API and documentation
  * This release adds support to enable access logging for buckets in the Lightsail object storage service.
* `service/neptune`: Updates service API and documentation
  * Adds support for major version upgrades to ModifyDbCluster API
* `service/networkmanager`: Updates service API, documentation, and paginators
* `service/rekognition`: Updates service API, documentation, and paginators
  * This Amazon Rekognition Custom Labels release introduces the management of datasets with  projects

Release v1.41.14 (2021-10-29)
===

### Service Client Updates
* `service/application-insights`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Support added for AMI sharing with organizations and organizational units in ModifyImageAttribute API
* `service/rekognition`: Updates service API and documentation
  * This release added new attributes to Rekognition Video GetCelebrityRecognition API operations.
* `service/transcribe`: Updates service API and documentation

Release v1.41.13 (2021-10-28)
===

### Service Client Updates
* `service/connectparticipant`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Added new read-only DenyAllIGWTraffic network interface attribute. Added support for DL1 24xlarge instances powered by Habana Gaudi Accelerators for deep learning model training workloads
* `service/ecs`: Updates service API and documentation
  * Amazon ECS now supports running Fargate tasks on Windows Operating Systems Families which includes Windows Server 2019 Core and Windows Server 2019 Full.
* `service/gamelift`: Updates service API and documentation
  * Added support for Arm-based AWS Graviton2 instances, such as M6g, C6g, and R6g.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for RStudio on SageMaker.
* `service/ssm-incidents`: Updates service API and documentation

Release v1.41.12 (2021-10-27)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * This release adds support for attribute-based instance type selection, a new EC2 Auto Scaling feature that lets customers express their instance requirements as a set of attributes, such as vCPU, memory, and storage.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds: attribute-based instance type selection for EC2 Fleet, Spot Fleet, a feature that lets customers express instance requirements as attributes like vCPU, memory, and storage; and Spot placement score, a feature that helps customers identify an optimal location to run Spot workloads.
* `service/eks`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * This release allows customers to describe one or more versioned model packages through BatchDescribeModelPackage, update project via UpdateProject, modify and read customer metadata properties using Create, Update and Describe ModelPackage and enables cross account registration of model packages.
* `service/textract`: Updates service API and documentation

Release v1.41.11 (2021-10-26)
===

### Service Client Updates
* `service/chime-sdk-identity`: Updates service API, documentation, and paginators
* `service/chime-sdk-messaging`: Updates service API and documentation
* `service/emr-containers`: Updates service API and documentation

Release v1.41.10 (2021-10-25)
===

### Service Client Updates
* `service/auditmanager`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This release adds support to create a VPN Connection that is not attached to a Gateway at the time of creation. Use this to create VPNs associated with Core Networks, or modify your VPN and attach a gateway using the modify API after creation.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for Amazon RDS Custom, which is a new RDS management type that gives you full access to your database and operating system. For more information, see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-custom.html
* `service/route53resolver`: Updates service API, documentation, and paginators

Release v1.41.9 (2021-10-22)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * Chime VoiceConnector and VoiceConnectorGroup APIs will now return an ARN.
* `service/quicksight`: Updates service API and documentation
  * Added QSearchBar option for GenerateEmbedUrlForRegisteredUser ExperienceConfiguration to support Q search bar embedding

Release v1.41.8 (2021-10-21)
===

### Service Client Updates
* `service/connect`: Updates service documentation

Release v1.41.7 (2021-10-20)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/directconnect`: Updates service API and documentation
  * This release adds 4 new APIS, which needs to be public able
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for specifying caption time delta in milliseconds and the ability to apply color range legalization to source content other than AVC video.
* `service/mediapackage`: Updates service API and documentation
  * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/panorama`: Updates service API, documentation, paginators, and examples
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/transcribe-streaming`: Updates service API and documentation

### SDK Bugs
* `codegen`: Fix SDK not draining HTTP response body for operations without modeled output parameters.
  * Fixes a bug in the SDK that was causing HTTP response bodies to not be drained, preventing the connection being reused in the connection pool. For some operations this could contributed to an increase in `close_wait` connection states.

Release v1.41.6 (2021-10-19)
===

### Service Client Updates
* `service/chime-sdk-messaging`: Updates service API, documentation, and paginators
* `service/dataexchange`: Updates service API and documentation

Release v1.41.5 (2021-10-18)
===

### Service Client Updates
* `service/ivs`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * AWS QuickSight Service  Features    - Add IP Restriction UI and public APIs support.

Release v1.41.4 (2021-10-15)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service documentation
  * EFS adds documentation for a new exception for short identifiers to be thrown after its migration to long resource identifiers.
* `service/glue`: Updates service API and documentation
  * Enable S3 event base crawler API.

Release v1.41.3 (2021-10-14)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling now supports filtering describe Auto Scaling groups API using tags
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/robomaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release updates the provisioning artifact ID to an optional parameter in CreateProject API. The provisioning artifact ID defaults to the latest provisioning artifact ID of the product if you don't provide one.

Release v1.41.2 (2021-10-13)
===

### Service Client Updates
* `service/config`: Updates service API
* `service/ec2`: Updates service API and documentation
  * This release adds support for additional VPC Flow Logs delivery options to S3, such as Apache Parquet formatted files, Hourly partitions and Hive-compatible S3 prefixes
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/storagegateway`: Updates service API and documentation
  * Adding support for Audit Logs on NFS shares and Force Closing Files on SMB shares.
* `service/workmail`: Updates service API, documentation, and paginators
  * This release adds APIs for adding, removing and retrieving details of mail domains

Release v1.41.1 (2021-10-12)
===

### Service Client Updates
* `service/cloudsearch`: Updates service API
  * Adds an additional validation exception for Amazon CloudSearch configuration APIs for better error handling.
* `service/ec2`: Updates service API and documentation
  * EncryptionSupport for InstanceStorageInfo added to DescribeInstanceTypes API
* `service/ecs`: Updates service documentation
  * Documentation only update to address tickets.
* `service/mediatailor`: Updates service API, documentation, and paginators

Release v1.41.0 (2021-10-11)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation update for Amazon EC2.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/frauddetector`: Updates service API, documentation, and paginators
* `service/medialive`: Updates service API and documentation
  * This release adds support for Transport Stream files as an input type to MediaLive encoders.

### SDK Features
* Update SDK's serialization of REST-JSON API input and Content-Type
  * Updates the SDK's serialization of REST-JSON based API input parameters into HTTP request message payload, and Content-Type are set correctly. API operations with input structure members that are modeled to be serialized to the request payload will always have at least an empty JSON object serialized. Even if all members targeting the payload are nil. Also fixes REST-JSON serialization so that Content-Type is not sent if the input parameter has no members target the request payload.

Release v1.40.59 (2021-10-08)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release removes a requirement for filters on SearchLocalGatewayRoutes operations.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert has added the ability to set account policies which control access restrictions for HTTP, HTTPS, and S3 content sources.
* `service/models.lex.v2`: Updates service API and documentation
* `service/runtime.lex.v2`: Updates service API and documentation
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for Secrets Manager
* `service/securityhub`: Updates service API and documentation

Release v1.40.58 (2021-10-07)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * This release enables customers to configure Chime MediaCapturePipeline via API.
* `service/firehose`: Updates service API and documentation
  * Allow support for Amazon Opensearch Service(successor to Amazon Elasticsearch Service) as a Kinesis Data Firehose delivery destination.
* `service/grafana`: Updates service API, documentation, paginators, and examples
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports indexing and querying documents in different languages.
* `service/schemas`: Updates service API and documentation

Release v1.40.57 (2021-10-06)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API and documentation
* `service/fsx`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports integration with AWS SSO
* `service/sagemaker`: Updates service API and documentation
  * This release adds a new TrainingInputMode FastFile for SageMaker Training APIs.

Release v1.40.56 (2021-10-05)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/backup`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, waiters, and paginators
  * Released Capacity Reservation Fleet, a feature of Amazon EC2 Capacity Reservations, which provides a way to manage reserved capacity across instance types. For more information: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-fleets.html
* `service/glue`: Updates service API and documentation
  * This release adds tag as an input of CreateConnection
* `service/location`: Updates service API and documentation
* `service/workmail`: Updates service API and documentation
  * This release allows customers to change their inbound DMARC settings in Amazon WorkMail.

Release v1.40.55 (2021-10-04)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild now allows you to select how batch build statuses are sent to the source provider for a project.
* `service/elasticfilesystem`: Updates service API
  * EFS adds a new exception for short identifiers to be thrown after its migration to long resource identifiers.
* `service/kms`: Updates service documentation and examples
  * Added SDK examples for ConnectCustomKeyStore, CreateCustomKeyStore, CreateKey, DeleteCustomKeyStore, DescribeCustomKeyStores, DisconnectCustomKeyStore, GenerateDataKeyPair, GenerateDataKeyPairWithoutPlaintext, GetPublicKey, ReplicateKey, Sign, UpdateCustomKeyStore and Verify APIs

Release v1.40.54 (2021-10-01)
===

### Service Client Updates
* `service/apprunner`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * When "AutoApprovable" is true for a Change Template, then specifying --auto-approve (boolean) in Start-Change-Request-Execution will create a change request that bypasses approver review. (except for change calendar restrictions)
* `service/synthetics`: Updates service API and documentation

Release v1.40.53 (2021-09-30)
===

### Service Client Updates
* `service/account`: Updates service API, documentation, paginators, and examples
* `service/cloudcontrol`: Adds new service
* `service/dataexchange`: Updates service API, documentation, and paginators
* `service/macie2`: Updates service API and documentation
* `service/network-firewall`: Updates service API and documentation
* `service/workmail`: Updates service API, documentation, and paginators
  * This release adds support for mobile device access overrides management in Amazon WorkMail.
* `service/workspaces`: Updates service API and documentation
  * Added CreateUpdatedWorkspaceImage API to update WorkSpace images with latest software and drivers. Updated DescribeWorkspaceImages API to display if there are updates available for WorkSpace images.

Release v1.40.52 (2021-09-29)
===

### Service Client Updates
* `service/amp`: Updates service API, documentation, waiters, and paginators
* `service/lambda`: Updates service API and documentation
  * Adds support for Lambda functions powered by AWS Graviton2 processors. Customers can now select the CPU architecture for their functions.
* `service/sesv2`: Updates service API and documentation

Release v1.40.51 (2021-09-28)
===

### Service Client Updates
* `service/imagebuilder`: Updates service documentation
* `service/transfer`: Updates service documentation
  * Added changes for managed workflows feature APIs.

Release v1.40.50 (2021-09-27)
===

### Service Client Updates
* `service/appintegrations`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * Added support for journey with contact center activity
* `service/voice-id`: Updates service API, documentation, paginators, and examples
* `service/wisdom`: Updates service API, documentation, paginators, and examples

Release v1.40.49 (2021-09-24)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * DescribeInstances now returns Platform Details, Usage Operation, and Usage Operation Update Time.
* `service/license-manager`: Updates service API and documentation

Release v1.40.48 (2021-09-23)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release adds style and positioning support for caption or subtitle burn-in from rich text sources such as TTML. This release also introduces configurable image-based trick play track generation.
* `service/ssm`: Updates service API, documentation, and waiters
  * Added cutoff behavior support for preventing new task invocations from starting when the maintenance window cutoff time is reached.

Release v1.40.47 (2021-09-22)
===

### Service Client Updates
* `service/iam`: Updates service documentation
  * Added changes to OIDC API about not using port numbers in the URL.
* `service/imagebuilder`: Updates service API and documentation
* `service/license-manager`: Updates service API and documentation
* `service/mediapackage-vod`: Updates service API and documentation
* `service/mediatailor`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/wafv2`: Updates service API and documentation

Release v1.40.46 (2021-09-21)
===

### Service Client Updates
* `service/comprehend`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * This update adds support for downloading configuration templates using new APIs (GetVpnConnectionDeviceTypes and GetVpnConnectionDeviceSampleConfiguration) and Internet Key Exchange version 2 (IKEv2) parameters for many popular CGW devices.
* `service/ecr`: Updates service API and documentation
  * This release adds additional support for repository replication
* `service/iot`: Updates service API and documentation
  * This release adds support for verifying, viewing and filtering AWS IoT Device Defender detect violations with four verification states.
* `service/kafka`: Updates service API

### SDK Bugs
* `service/dynamodb/dynamodbattribute`: Fix string alias unmarshal.
  * Fixes #3983 by correcting the unmarshaler's decoding of AttributeValue number (N) parameter into type that is a string alias.

Release v1.40.45 (2021-09-17)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Optional flag force-planned-failover added to reboot-replication-instance API call. This flag can be used to test a planned failover scenario used during some maintenance operations.
* `service/es`: Updates service API and documentation
  * This release adds an optional parameter in the ListDomainNames API to filter domains based on the engine type (OpenSearch/Elasticsearch).
* `service/opensearch`: Updates service API and documentation

Release v1.40.44 (2021-09-16)
===

### Service Client Updates
* `service/kafkaconnect`: Adds new service
* `service/macie2`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This SDK release adds a new feature for Pinpoint campaigns, in-app messaging.
* `service/robomaker`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Add support for access point arn filtering in S3 CW Request Metrics
* `service/sagemaker`: Updates service API and documentation
  * Add API for users to retry a failed pipeline execution or resume a stopped one.
* `service/transcribe`: Updates service API and documentation

### SDK Enhancements
* Update SDK API client documentation for suppressed API parameters
  * Updates the documentation for API parameters that will be suppressed in structures' String and GoString methods.

### SDK Bugs
* `aws/client`: Update client logging to only log request headers when logging is enabled
  * Updates the SDK's base client to only log request headers when logging is enabled. This fixes an issue where event stream API operations would always log request headers. Regardless if logging was enabled or not.

Release v1.40.43 (2021-09-14)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Adds support for SipHeaders parameter for CreateSipMediaApplicationCall.
* `service/comprehend`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for vt1 3xlarge, 6xlarge and 24xlarge instances powered by Xilinx Alveo U30 Media Accelerators for video transcoding workloads
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for "Project Search"
* `service/transcribe-streaming`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.40.42 (2021-09-13)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds support for T3 instances on Amazon EC2 Dedicated Hosts.
* `service/iot`: Updates service API and documentation
  * AWS IoT Rules Engine adds OpenSearch action. The OpenSearch rule action lets you stream data from IoT sensors and applications to Amazon OpenSearch Service which is a successor to Amazon Elasticsearch Service.

Release v1.40.41 (2021-09-10)
===

### Service Client Updates
* `service/cloudformation`: Updates service documentation
  * Doc only update for CloudFormation that fixes several customer-reported issues.
* `service/ecr`: Updates service documentation
  * This release updates terminology around KMS keys.
* `service/quicksight`: Updates service API and documentation
  * Add new data source type for Amazon OpenSearch (successor to Amazon ElasticSearch).
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds support for providing a custom timeout value for finding a scaling point during autoscaling in Aurora Serverless v1.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This release adds support for "Lifecycle Configurations" to SageMaker Studio
* `service/transcribe`: Updates service API and documentation

Release v1.40.40 (2021-09-09)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * This release enables customers to login to EMR Studio using AWS Identity and Access Management (IAM) identities or identities in their Identity Provider (IdP) via IAM.
* `service/lookoutequipment`: Updates service API and documentation

Release v1.40.39 (2021-09-08)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/opensearch`: Adds new service
* `service/ram`: Updates service documentation

Release v1.40.38 (2021-09-07)
===

### Service Client Updates
* `service/amp`: Updates service API and documentation
* `service/eks`: Updates service API, documentation, and waiters
* `service/elasticache`: Updates service documentation
  * Doc only update for ElastiCache
* `service/forecast`: Updates service API and documentation
* `service/mediapackage`: Updates service documentation
  * SPEKE v2 support for live CMAF packaging type. SPEKE v2 is an upgrade to the existing SPEKE API to support multiple encryption keys, it supports live DASH currently.
* `service/ssm-contacts`: Updates service documentation and examples
* `service/xray`: Updates service documentation
  * Updated references to AWS KMS keys and customer managed keys to reflect current terminology.

Release v1.40.37 (2021-09-03)
===

### Service Client Updates
* `service/chime-sdk-identity`: Updates service documentation
* `service/chime-sdk-messaging`: Updates service documentation
* `service/codeguru-reviewer`: Updates service API
* `service/frauddetector`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation

Release v1.40.36 (2021-09-02)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/acm-pca`: Updates service API and documentation
* `service/ebs`: Updates service documentation
* `service/elasticfilesystem`: Updates service API and documentation
  * Adds support for EFS Intelligent-Tiering, which uses EFS Lifecycle Management to monitor file access patterns and is designed to automatically transition files to and from your corresponding Infrequent Access (IA) storage classes.
* `service/fsx`: Updates service API, documentation, and paginators
* `service/lex-models`: Updates service API
* `service/quicksight`: Updates service API and documentation
  * This release adds support for referencing parent datasets as sources in a child dataset.
* `service/s3control`: Updates service API, documentation, and paginators
  * S3 Multi-Region Access Points provide a single global endpoint to access a data set that spans multiple S3 buckets in different AWS Regions.
* `service/schemas`: Updates service API and documentation
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/transfer`: Updates service API, documentation, and paginators
  * AWS Transfer Family introduces Managed Workflows for creating, executing, monitoring, and standardizing post file transfer processing

Release v1.40.35 (2021-09-01)
===

### Service Client Updates
* `service/cloudtrail`: Updates service documentation
  * Documentation updates for CloudTrail
* `service/config`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * Added LaunchTemplate support for the IMDS IPv6 endpoint
* `service/mediatailor`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Updates service API and documentation

Release v1.40.34 (2021-08-31)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service documentation
* `service/iot`: Updates service API, documentation, and paginators
  * Added Create/Update/Delete/Describe/List APIs for a new IoT resource named FleetMetric. Added a new Fleet Indexing query API named GetBucketsAggregation. Added a new field named DisconnectedReason in Fleet Indexing query response. Updated their related documentations.
* `service/memorydb`: Updates service documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new South African English voice - Ayanda. Ayanda is available as Neural voice only.
* `service/sqs`: Updates service API and documentation
  * Amazon SQS adds a new queue attribute, RedriveAllowPolicy, which includes the dead-letter queue redrive permission parameters. It defines which source queues can specify dead-letter queues as a JSON object.

Release v1.40.33 (2021-08-30)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * AWS CloudFormation allows you to iteratively develop your applications when failures are encountered without rolling back successfully provisioned resources. By specifying stack failure options, you can troubleshoot resources in a CREATE_FAILED or UPDATE_FAILED status.
* `service/codebuild`: Updates service documentation
  * Documentation updates for CodeBuild
* `service/firehose`: Updates service API and documentation
  * This release adds the Dynamic Partitioning feature to Kinesis Data Firehose service for S3 destinations.
* `service/kms`: Updates service API, documentation, and examples
  * This release has changes to KMS nomenclature to remove the word master from both the "Customer master key" and "CMK" abbreviation and replace those naming conventions with "KMS key".

Release v1.40.32 (2021-08-27)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds the BootMode flag to the ImportImage API and showing the detected BootMode of an ImportImage task.
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR now supports auto-terminating idle EMR clusters. You can specify the idle timeout value when enabling auto-termination for both running and new clusters and Amazon EMR automatically terminates the cluster when idle timeout kicks in.
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3.

Release v1.40.31 (2021-08-26)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Support added for resizing VPC prefix lists
* `service/rekognition`: Updates service API and documentation
  * This release added new attributes to Rekognition RecognizeCelebities and GetCelebrityInfo API operations.
* `service/transcribe`: Updates service API and documentation

Release v1.40.30 (2021-08-25)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Support added for IMDS IPv6 endpoint
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * AWS CWEvents adds an enum of EXTERNAL for EcsParameters LaunchType for PutTargets API
* `service/fms`: Updates service API and documentation

### SDK Bugs
* `private/protocol`: Add support for parsing RFC 3339 timestamp without trailing Z
  * Adds support for parsing RFC 3339 timestamp but without the `Z` character, nor UTC offset.
  * Related to [aws/aws-sdk-go-v2#1387](https://github.com/aws/aws-sdk-go-v2/issues/1387)

Release v1.40.29 (2021-08-24)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added MBAFF encoding support for AVC video and the ability to pass encryption context from the job settings to S3.
* `service/polly`: Updates service API and documentation
  * Amazon Polly adds new New Zealand English voice - Aria. Aria is available as Neural voice only.
* `service/ssm`: Updates service API
  * Updated Parameter Store property for logging improvements.
* `service/transcribe`: Updates service API and documentation

### SDK Enhancements
* `service/iotdataplane`: Updated Publish with support for new Retain flag and added two new API operations: GetRetainedMessage, ListRetainedMessages.

Release v1.40.28 (2021-08-23)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Adding some of the pending releases (1) Adding WAF Filter to GatewayResponseType enum (2) Ensuring consistent error model for all operations (3) Add missing BRE to GetVpcLink operation
* `service/backup`: Updates service API, documentation, and paginators
* `service/dlm`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * Amazon AWS DMS service now support Redis target endpoint migration. Now S3 endpoint setting is capable to setup features which are used to be configurable only in extract connection attributes.
* `service/frauddetector`: Updates service API and documentation
* `service/glue`: Updates service API, documentation, and paginators
  * Add support for Custom Blueprints
* `service/iotsitewise`: Updates service documentation

Release v1.40.27 (2021-08-20)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * encryptionInTransitSupported added to DescribeInstanceTypes API
* `service/eks`: Updates service API and documentation
* `service/robomaker`: Updates service documentation

### SDK Bugs
* `aws`: Fix SDK's suppressing of sensitive API parameters being logged.
  * The SDK did not correctly suppress sensitive API parameters via the `String` and `GoString` methods. Updates the SDK's behavior to suppress sensitive API parameters.

Release v1.40.26 (2021-08-19)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/application-autoscaling`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * The ImportImage API now supports the ability to create AMIs with AWS-managed licenses for Microsoft SQL Server for both Windows and Linux.
* `service/memorydb`: Updates service API, documentation, paginators, and examples

Release v1.40.25 (2021-08-18)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild now allows you to make the build results for your build projects available to the public without requiring access to an AWS account.
* `service/route53`: Updates service documentation
  * Documentation updates for route53
* `service/route53resolver`: Updates service documentation
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports Asynchronous Inference endpoints. Adds PlatformIdentifier field that allows Notebook Instance creation with different platform selections. Increases the maximum number of containers in multi-container endpoints to 15. Adds more instance types to InstanceType field.

### SDK Bugs
* `service/s3`: Close http.Response.Body in CopyObject, UploadPartCopy and CompleteMultipartUpload operations
  * Fixes [#4037](https://github.com/aws/aws-sdk-go/issues/4037)

Release v1.40.24 (2021-08-17)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/cloud9`: Updates service API and documentation
  * Added DryRun parameter to CreateEnvironmentEC2 API. Added ManagedCredentialsActions parameter to UpdateEnvironment API
* `service/clouddirectory`: Updates service documentation
  * Documentation updates for clouddirectory
* `service/ec2`: Updates service API and documentation
  * This release adds support for EC2 ED25519 key pairs for authentication
* `service/logs`: Updates service documentation
  * Documentation-only update for CloudWatch Logs

Release v1.40.23 (2021-08-16)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild now allows you to select how batch build statuses are sent to the source provider for a project.
* `service/config`: Updates service API
* `service/ds`: Updates service API and documentation
  * This release adds support for describing client authentication settings.
* `service/iotsitewise`: Updates service API and documentation
* `service/license-manager`: Updates service API
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3

Release v1.40.22 (2021-08-13)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/elasticache`: Updates service API and documentation
  * This release adds ReplicationGroupCreateTime field to ReplicationGroup which indicates the UTC time when ElastiCache ReplicationGroup is created
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR customers can now specify custom AMIs at the instance level in their clusters. This allows using custom AMIs in clusters that have instances with different instruction set architectures, e.g. m5.xlarge (x86) and m6g.xlarge (ARM).
* `service/quicksight`: Updates service documentation
  * Documentation updates for QuickSight.

Release v1.40.21 (2021-08-12)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Adding support for ACM imported or private CA certificates for mTLS enabled domain names
* `service/apigatewayv2`: Updates service API and documentation
  * Adding support for ACM imported or private CA certificates for mTLS enabled domain names
* `service/databrew`: Updates service API
* `service/lambda`: Updates service API and documentation
  * Lambda Python 3.9 runtime launch
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot adds new metrics for all candidate models generated by Autopilot experiments.

Release v1.40.20 (2021-08-11)
===

### Service Client Updates
* `service/codebuild`: Updates service API, documentation, and examples
  * CodeBuild now allows you to make the build results for your build projects available to the public without requiring access to an AWS account.
* `service/ebs`: Updates service documentation
* `service/ecs`: Updates service documentation
  * Documentation updates for ECS.
* `service/nimble`: Updates service API and documentation
* `service/route53`: Updates service documentation
  * Documentation updates for route53
* `service/snow-device-management`: Adds new service

Release v1.40.19 (2021-08-10)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Add support for "auto" in Region field of StartMeetingTranscription API request.

Release v1.40.18 (2021-08-09)
===

### Service Client Updates
* `service/rekognition`: Updates service API and documentation
  * This release adds support for four new types of segments (opening credits, content segments, slates, and studio logos), improved accuracy for credits and shot detection and new filters to control black frame detection.
* `service/ssm`: Updates service documentation
  * Documentation updates for AWS Systems Manager.
* `service/wafv2`: Updates service API and documentation

Release v1.40.17 (2021-08-06)
===

### Service Client Updates
* `service/athena`: Updates service documentation
  * Documentation updates for Athena.
* `service/chime-sdk-identity`: Adds new service
* `service/chime-sdk-messaging`: Adds new service
* `service/connect`: Updates service API, documentation, and paginators
* `service/lightsail`: Updates service API and documentation
  * This release adds support to track when a bucket access key was last used.
* `service/synthetics`: Updates service documentation

Release v1.40.16 (2021-08-05)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * EC2 Auto Scaling adds configuration checks and Launch Template validation to Instance Refresh.
* `service/models.lex.v2`: Updates service API and documentation

Release v1.40.15 (2021-08-04)
===

### Service Client Updates
* `service/eventbridge`: Updates service documentation
* `service/imagebuilder`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release adds AutomaticRestartTime to the DescribeDBInstances and DescribeDBClusters operations. AutomaticRestartTime indicates the time when a stopped DB instance or DB cluster is restarted automatically.
* `service/ssm-incidents`: Updates service API and documentation
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.40.14 (2021-08-03)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Add ConcurrentModificationException to create-table, delete-table, create-database, update-database, delete-database
* `service/iotsitewise`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added control over the passthrough of XDS captions metadata to outputs.
* `service/proton`: Updates service documentation
* `service/redshift`: Updates service API and documentation
  * API support for Redshift Data Sharing feature.

Release v1.40.13 (2021-08-02)
===

### Service Client Updates
* `service/greengrassv2`: Updates service API and documentation
* `service/ssm-contacts`: Updates service API and documentation

Release v1.40.12 (2021-07-30)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/sagemaker`: Updates service API, documentation, and waiters
  * API changes with respect to Lambda steps in model building pipelines. Adds several waiters to async Sagemaker Image APIs. Add more instance types to AppInstanceType field
* `service/secretsmanager`: Updates service API and documentation
  * Add support for KmsKeyIds in the ListSecretVersionIds API response

Release v1.40.11 (2021-07-29)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Adds support for live transcription of meetings with Amazon Transcribe and Amazon Transcribe Medical.  The new APIs, StartMeetingTranscription and StopMeetingTranscription, control the generation of user-attributed transcriptions sent to meeting clients via Amazon Chime SDK data messages.
* `service/ec2`: Updates service API and documentation
  * This release adds support for G4ad xlarge and 2xlarge instances powered by AMD Radeon Pro V520 GPUs and AMD 2nd Generation EPYC processors
* `service/iot`: Updates service API and documentation
  * Increase maximum credential duration of role alias to 12 hours.
* `service/iotsitewise`: Updates service API and documentation
* `service/savingsplans`: Updates service API

Release v1.40.10 (2021-07-28)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * SDK update to support Importing existing Stacks to new/existing Self Managed StackSet - Stack Import feature.
* `service/sso-admin`: Updates service documentation

Release v1.40.9 (2021-07-27)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Add support for ListJob filters
* `service/iotanalytics`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/models.lex.v2`: Updates service waiters
* `service/quicksight`: Updates service API and documentation
  * Add support to use row-level security with tags when embedding dashboards for users not provisioned in QuickSight
* `service/redshift-data`: Updates service API and documentation
* `service/route53`: Updates service API and documentation
  * This release adds support for the RECOVERY_CONTROL health check type to be used in conjunction with Route53 Application Recovery Controller.
* `service/route53-recovery-cluster`: Adds new service
* `service/route53-recovery-control-config`: Adds new service
* `service/route53-recovery-readiness`: Adds new service
* `service/shield`: Updates service documentation
  * Change name of DDoS Response Team (DRT) to Shield Response Team (SRT)

Release v1.40.8 (2021-07-26)
===

### Service Client Updates
* `service/identitystore`: Updates service documentation
* `service/monitoring`: Updates service API and documentation
  * SDK update to support creation of Cross-Account Metric Alarms and update API documentation.
* `service/proton`: Updates service documentation
* `service/s3control`: Updates service API and documentation
  * S3 Access Point aliases can be used anywhere you use S3 bucket names to access data in S3
* `service/synthetics`: Updates service API and documentation
* `service/textract`: Updates service API and documentation

Release v1.40.7 (2021-07-23)
===

### Service Client Updates
* `service/imagebuilder`: Updates service documentation
* `service/s3outposts`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.40.6 (2021-07-22)
===

### Service Client Updates
* `service/databrew`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release allows customers to assign prefixes to their elastic network interface and to reserve IP blocks in their subnet CIDRs. These reserved blocks can be used to assign prefixes to elastic network interfaces or be excluded from auto-assignment.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/medialive`: Updates service API and documentation
  * MediaLive now supports passing through style data on WebVTT caption outputs.
* `service/qldb`: Updates service API and documentation
* `service/s3control`: Updates service documentation
  * Documentation updates for Amazon S3-control

Release v1.40.5 (2021-07-21)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now allows you to set the access permissions for build artifacts, project artifacts, and log files that are uploaded to an Amazon S3 bucket that is owned by another account.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/elasticmapreduce`: Updates service API, documentation, and paginators
  * EMR now supports new DescribeReleaseLabel and ListReleaseLabel APIs. They can provide Amazon EMR release label details. You can programmatically list available releases and applications for a specific Amazon EMR release label.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now provides a data source connector for Amazon WorkDocs. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-workdocs.html
* `service/lambda`: Updates service API and documentation
  * New ResourceConflictException error code for PutFunctionEventInvokeConfig, UpdateFunctionEventInvokeConfig, and DeleteFunctionEventInvokeConfig operations.
* `service/personalize`: Updates service API and documentation
* `service/proton`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Adds the OriginalSnapshotCreateTime field to the DBSnapshot response object. This field timestamps the underlying data of a snapshot and doesn't change when the snapshot is copied.

Release v1.40.4 (2021-07-20)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * Added idempotency to the CreateVolume API using the ClientToken request parameter

Release v1.40.3 (2021-07-19)
===

### Service Client Updates
* `service/directconnect`: Updates service documentation
  * Documentation updates for directconnect
* `service/emr-containers`: Updates service API and documentation
* `service/health`: Updates service API and documentation
  * In the Health API, the maximum number of entities for the EventFilter and EntityFilter data types has changed from 100 to 99. This change is related to an internal optimization of the AWS Health service.
* `service/imagebuilder`: Updates service documentation
* `service/location`: Updates service API and documentation
* `service/robomaker`: Updates service API and documentation

Release v1.40.2 (2021-07-16)
===

### Service Client Updates
* `service/appintegrations`: Updates service documentation
* `service/auditmanager`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * This SDK release adds Account Status as one of the attributes in Account API response

Release v1.40.1 (2021-07-15)
===

### Service Client Updates
* `service/cognito-idp`: Updates service documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * This feature enables customers  to specify weekly recurring time window(s) for scheduled events that reboot, stop or terminate EC2 instances.
* `service/ecs`: Updates service documentation
  * Documentation updates for support of awsvpc mode on Windows.
* `service/iotsitewise`: Updates service API
* `service/lex-models`: Updates service API

Release v1.40.0 (2021-07-14)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * Added support for RSA 3072 SSL certificate import
* `service/dms`: Updates service API and documentation
  * Release of feature needed for ECA-Endpoint settings. This allows customer to delete a field in endpoint settings by using --exact-settings flag in modify-endpoint api. This also displays default values for certain required fields of endpoint settings in describe-endpoint-settings api.
* `service/glue`: Updates service API and documentation
  * Add support for Event Driven Workflows
* `service/healthlake`: Updates service API, documentation, and paginators
* `service/lightsail`: Updates service API and documentation
  * This release adds support for the Amazon Lightsail object storage service, which allows you to create buckets and store objects.
* `service/wellarchitected`: Updates service API and documentation

### SDK Features
* `aws/session`: Support has been added for EC2 IPv6-enabled Instance Metadata Service Endpoints ([#4006](https://github.com/aws/aws-sdk-go/pull/4006))
  * Adds support for `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE`  environment variable which may specify `IPv6` or `IPv4` for selecting the desired endpoint.
  * Adds support for `ec2_metadata_service_endpoint_mode` AWS profile key, which may specify `IPv6` or `IPv4` for selecting the desired endpoint. Has lower precedence then `AWS_EC2_METADATA_SERVICE_ENDPOINT`.
  * Adds support for `ec2_metadata_service_endpoint` AWS profile key, which may specify an explicit endpoint URI. Has higher precedence then `ec2_metadata_service_endpoint_mode`.
* `aws/endpoints`: Supported has been added for EC2 IPv6-enabled Instance Metadata Service Endpoints ([#4006](https://github.com/aws/aws-sdk-go/pull/4006))

Release v1.39.6 (2021-07-13)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API and documentation
* `service/devops-guru`: Updates service paginators
* `service/directconnect`: Updates service API and documentation
  * This release adds a new filed named awsLogicalDeviceId that it displays the AWS Direct Connect endpoint which terminates a physical connection's BGP Sessions.
* `service/lex-models`: Updates service API, documentation, and paginators
* `service/pricing`: Updates service documentation and examples
* `service/redshift`: Updates service API and documentation
  * Release new APIs to support new Redshift feature - Authentication Profile
* `service/ssm`: Updates service API and documentation
  * Changes to OpsCenter APIs to support a new feature, operational insights.

Release v1.39.5 (2021-07-12)
===

### Service Client Updates
* `service/eks`: Updates service documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports Principal Store

Release v1.39.4 (2021-07-09)
===

### Service Client Updates
* `service/frauddetector`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * MediaConvert now supports color, style and position information passthrough from 608 and Teletext to SRT and WebVTT subtitles. MediaConvert now also supports Automatic QVBR quality levels for QVBR RateControlMode.
* `service/sagemaker`: Updates service API and documentation
  * Releasing new APIs related to Tuning steps in model building pipelines.

Release v1.39.3 (2021-07-08)
===

### Service Client Updates
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/eks`: Updates service waiters
* `service/fms`: Updates service API, documentation, and paginators
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/outposts`: Updates service API and documentation
* `service/ssm-contacts`: Updates service documentation

Release v1.39.2 (2021-07-07)
===

### Service Client Updates
* `service/chime`: Updates service API, documentation, and paginators
  * Releasing new APIs for AWS Chime MediaCapturePipeline
* `service/cloudfront`: Updates service API and documentation
  * Amazon CloudFront now provides two new APIs, ListConflictingAliases and AssociateAlias, that help locate and move Alternate Domain Names (CNAMEs) if you encounter the CNAMEAlreadyExists error code.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds resource ids and tagging support for VPC security group rules.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/iotsitewise`: Updates service API and documentation
* `service/mq`: Updates service API and documentation
  * adds support for modifying the maintenance window for brokers.
* `service/storagegateway`: Updates service API and documentation
  * Adding support for oplocks for SMB file shares,  S3 Access Point and S3 Private Link for all file shares and IP address support for file system associations
* `service/sts`: Updates service documentation
  * Documentation updates for AWS Security Token Service.

Release v1.39.1 (2021-07-06)
===

### Service Client Updates
* `service/eks`: Updates service API
* `service/imagebuilder`: Updates service API and documentation
* `service/lambda`: Updates service API, documentation, and examples
  * Added support for AmazonMQRabbitMQ as an event source. Added support for VIRTUAL_HOST as SourceAccessType for streams event source mappings.
* `service/macie2`: Updates service documentation
* `service/mgn`: Updates service API
* `service/sns`: Updates service documentation and paginators
  * Documentation updates for Amazon SNS.

### SDK Enhancements
* Update golang.org/x/net dependency [#3991](https://github.com/aws/aws-sdk-go/pull/3991)
    * Updates the SDK's dependency on golang.org/x/net module dependency.

Release v1.39.0 (2021-07-02)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release removes network-insights-boundary
* `service/elasticloadbalancingv2`: Updates service documentation

### SDK Features
* `internal/ini`: The ini parser has been updated to support `[`, `]`, `:`, and `=` being present in section key values. ([#3958](https://github.com/aws/aws-sdk-go/issues/3958))

Release v1.38.71 (2021-07-01)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adding a new reserved field to support future infrastructure improvements for Amazon EC2 Fleet.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker model registry now supports up to 5 containers and associated environment variables.
* `service/sqs`: Updates service documentation
  * Documentation updates for Amazon SQS.

Release v1.38.70 (2021-06-30)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling infrastructure improvements and optimizations.
* `service/databrew`: Updates service API and documentation
* `service/kendra`: Updates service documentation
  * Amazon Kendra Enterprise Edition now offered in smaller more granular units to enable customers with smaller workloads. Virtual Storage Capacity units now offer scaling in increments of 100,000 documents (up to 30GB) per unit and Virtual Query Units offer scaling increments of 8,000 queries per day.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/servicediscovery`: Updates service API and documentation
* `service/ssm-contacts`: Updates service API

Release v1.38.69 (2021-06-28)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Add JSON Support for Glue Schema Registry
* `service/mediaconvert`: Updates service API and documentation
  * MediaConvert adds support for HDR10+, ProRes 4444,  and XAVC outputs, ADM/DAMF support for Dolby Atmos ingest, and alternative audio and WebVTT caption ingest via HLS inputs. MediaConvert also now supports creating trickplay outputs for Roku devices for HLS, CMAF, and DASH output groups.
* `service/redshift`: Updates service API
  * Added InvalidClusterStateFault to the DisableLogging API, thrown when calling the API on a non available cluster.
* `service/sagemaker`: Updates service API and documentation
  * Sagemaker Neo now supports running compilation jobs using customer's Amazon VPC

Release v1.38.68 (2021-06-25)
===

### Service Client Updates
* `service/amplifybackend`: Updates service API and documentation
* `service/proton`: Updates service waiters
* `service/snowball`: Updates service API and documentation
  * AWS Snow Family customers can remotely monitor and operate their connected AWS Snowcone devices. AWS Snowball Edge Storage Optimized customers can now import and export their data using NFS.

Release v1.38.67 (2021-06-24)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Adds EventIngestionUrl field to MediaPlacement
* `service/cloud9`: Updates service documentation and examples
  * Minor update to AWS Cloud9 documentation to allow correct parsing of outputted text
* `service/codebuild`: Updates service API and documentation
  * BucketOwnerAccess is currently not supported
* `service/connect`: Updates service API and documentation
* `service/dax`: Updates service API and documentation
  * Add support for encryption in transit to DAX clusters.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports SharePoint 2013 and SharePoint 2016 when using a SharePoint data source.
* `service/securityhub`: Updates service API and documentation
* `service/transfer`: Updates service API and documentation
  * Customers can successfully use legacy clients with Transfer Family endpoints enabled for FTPS and FTP behind routers, firewalls, and load balancers by providing a Custom IP address used for data channel communication.
* `service/wafv2`: Updates service API and documentation

Release v1.38.66 (2021-06-23)
===

### Service Client Updates
* `service/cloud9`: Updates service documentation and examples
  * Updated documentation for CreateEnvironmentEC2 to explain that because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2--which includes long term support through 2023--for new AWS Cloud9 environments.
* `service/cloudfront`: Updates service API
  * Amazon CloudFront adds support for a new security policy, TLSv1.2_2021.
* `service/cloudsearch`: Updates service API and documentation
  * This release replaces previous generation CloudSearch instances with equivalent new instances that provide better stability at the same price.
* `service/codeguru-reviewer`: Updates service API, documentation, and waiters
* `service/docdb`: Updates service documentation
  * DocumentDB documentation-only edits
* `service/ec2`: Updates service API and documentation
  * This release adds support for provisioning your own IP (BYOIP) range in multiple regions. This feature is in limited Preview for this release. Contact your account manager if you are interested in this feature.
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Added the following parameters to ECS targets: CapacityProviderStrategy, EnableECSManagedTags, EnableExecuteCommand, PlacementConstraints, PlacementStrategy, PropagateTags, ReferenceId, and Tags
* `service/license-manager`: Updates service API and documentation
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/quicksight`: Updates service API and documentation
  * Releasing new APIs for AWS QuickSight Folders

Release v1.38.65 (2021-06-21)
===

### Service Client Updates
* `service/cloudformation`: Updates service API, documentation, and paginators
  * CloudFormation registry service now supports 3rd party public type sharing

### SDK Bugs
* `aws/signer/v4`: Add X-Amz-Object-Lock-* as unhoisted presign headers
  * Updates the SigV4 signer to exlucde the X-Amz-Object-Lock- group of headers to not be signed as a part of the query string for presigned URLs.
* `private/protocol`: Add support for UTC offset for ISO8601 datetime formats ([#3960](https://github.com/aws/aws-sdk-go/pull/3960))
  * Updates the SDK's parsing of ISO8601 date time formats to support UTC offsets.

Release v1.38.64 (2021-06-17)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * This release adds a new API UpdateSipMediaApplicationCall, to update an in-progress call for SipMediaApplication.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports the indexing of web documents for search through the web crawler.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release enables Database Activity Streams for RDS Oracle
* `service/sagemaker`: Updates service API and documentation
  * Enable ml.g4dn instance types for SageMaker Batch Transform and SageMaker Processing

### SDK Bugs
* `aws/ec2metadata`: Fix client retrying 404 responses ([#3962](https://github.com/aws/aws-sdk-go/pull/3962))
  * Fixes the EC2 IMDS client to not retry 404 HTTP errors received for operations like GetMetadata.

Release v1.38.63 (2021-06-16)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for VLAN-tagged network traffic over an Elastic Network Interface (ENI). This feature is in limited Preview for this release. Contact your account manager if you are interested in this feature.
* `service/kms`: Updates service API, documentation, and examples
  * Adds support for multi-Region keys
* `service/mediatailor`: Updates service API and documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * This release enables fast cloning in Aurora Serverless. You can now clone between Aurora Serverless clusters and Aurora Provisioned clusters.

Release v1.38.62 (2021-06-15)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API
  * EC2 M5n, M5dn, R5n, R5dn metal instances with 100 Gbps network performance and Elastic Fabric Adapter (EFA) for ultra low latency
* `service/models.lex.v2`: Updates service API and documentation
* `service/redshift-data`: Updates service API and documentation
* `service/runtime.lex.v2`: Updates service API and documentation

Release v1.38.61 (2021-06-14)
===

### Service Client Updates
* `service/greengrassv2`: Updates service API, documentation, and paginators
* `service/iotanalytics`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation

Release v1.38.60 (2021-06-11)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 adds new AMI property to flag outdated AMIs
* `service/mediaconnect`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS MediaLive now supports OCR-based conversion of DVB-Sub and SCTE-27 image-based source captions to WebVTT, and supports ingest of ad avail decorations in HLS input manifests.

Release v1.38.59 (2021-06-10)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/appmesh`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * This SDK release adds support for UpdateAccount API to allow users to update their default license on Chime account.
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds a new optional parameter connectivityType (public, private) for the CreateNatGateway API. Private NatGateway does not require customers to attach an InternetGateway to the VPC and can be used for communication with other VPCs and on-premise networks.
* `service/managedblockchain`: Updates service API and documentation
* `service/ram`: Updates service API, documentation, and paginators
* `service/redshift`: Updates service API
  * Added InvalidClusterStateFault to the ModifyAquaConfiguration API, thrown when calling the API on a non available cluster.
* `service/sagemaker`: Updates service API and documentation
  * Using SageMaker Edge Manager with AWS IoT Greengrass v2 simplifies accessing, maintaining, and deploying models to your devices. You can now create deployable IoT Greengrass components during edge packaging jobs. You can choose to create a device fleet with or without creating an AWS IoT role alias.
* `service/sagemaker-featurestore-runtime`: Updates service API and documentation

Release v1.38.58 (2021-06-09)
===

### Service Client Updates
* `service/kendra`: Updates service API and documentation
  * AWS Kendra now supports checking document status.
* `service/personalize-events`: Updates service API
* `service/proton`: Updates service API, documentation, paginators, and examples
* `service/transfer`: Updates service documentation
  * Documentation updates for the AWS Transfer Family service.

Release v1.38.57 (2021-06-08)
===

### Service Client Updates
* `service/cognito-idp`: Updates service documentation
* `service/fsx`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/servicecatalog`: Updates service API and documentation
  * increase max pagesize for List/Search apis

Release v1.38.56 (2021-06-07)
===

### Service Client Updates
* `service/eks`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Add SampleSize variable to S3Target to enable s3-sampling feature through API.
* `service/personalize`: Updates service API
* `service/sagemaker`: Updates service API and documentation
  * AWS SageMaker - Releasing new APIs related to Callback steps in model building pipelines. Adds experiment integration to model building pipelines.

Release v1.38.55 (2021-06-04)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling
* `service/cloudtrail`: Updates service documentation
  * AWS CloudTrail supports data events on new service resources, including Amazon DynamoDB tables and S3 Object Lambda access points.
* `service/medialive`: Updates service API and documentation
  * Add support for automatically setting the H.264 adaptive quantization and GOP B-frame fields.
* `service/pi`: Updates service API and documentation
* `service/qldb`: Updates service documentation
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Documentation updates for RDS: fixing an outdated link to the RDS documentation in DBInstance$DBInstanceStatus

Release v1.38.54 (2021-06-03)
===

### Service Client Updates
* `service/forecast`: Updates service API and documentation
* `service/route53resolver`: Updates service documentation
* `service/s3`: Updates service API, documentation, and examples
  * S3 Inventory now supports Bucket Key Status
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations now supports S3 Bucket Keys.
* `service/ssm`: Updates service documentation
  * Documentation updates for ssm to fix customer reported issue

Release v1.38.53 (2021-06-02)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * You can now launch EC2 instances with GP3 volumes when using Auto Scaling groups with Launch Configurations
* `service/braket`: Updates service API and documentation
* `service/docdb`: Updates service API, documentation, and paginators
  * This SDK release adds support for DocDB global clusters.
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail

Release v1.38.52 (2021-06-01)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Added idempotency to CreateNetworkInterface using the ClientToken parameter.
* `service/iotwireless`: Updates service API and documentation
* `service/polly`: Updates service API
  * Amazon Polly adds new Canadian French voice - Gabrielle. Gabrielle is available as Neural voice only.
* `service/servicediscovery`: Updates service API and documentation
* `service/sns`: Updates service API, documentation, and paginators
  * This release adds SMS sandbox in Amazon SNS and the ability to view all configured origination numbers. The SMS sandbox provides a safe environment for sending SMS messages, without risking your reputation as an SMS sender.

Release v1.38.51 (2021-05-28)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/location`: Updates service API, documentation, and paginators
* `service/lookoutmetrics`: Updates service API

### SDK Bugs
* `aws/request`: Fix handling of endpoints with trailing slashes
  * Fixes the SDK's handling of endpoint URLs that contain a trailing slash when the API operation's modeled path is suffixed. Also ensures any endpoint URL query string is squashed consistently.

Release v1.38.50 (2021-05-27)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * Introduces support for using our desktop testing service with applications hosted within your Virtual Private Cloud (VPC).
* `service/fsx`: Updates service API and documentation
* `service/iotevents`: Updates service API and documentation
* `service/iotevents-data`: Updates service API and documentation
* `service/iotsitewise`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now suggests popular queries in order to help guide query typing and help overall accuracy.
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/resource-groups`: Updates service documentation
* `service/sqs`: Updates service documentation
  * Documentation updates for Amazon SQS for General Availability of high throughput for FIFO queues.

Release v1.38.49 (2021-05-27)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * This release removes resource ids and tagging support for VPC security group rules.

Release v1.38.48 (2021-05-26)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/cloudfront`: Updates service documentation
  * Documentation fix for CloudFront
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds resource ids and tagging support for VPC security group rules.
* `service/ecs`: Updates service API and documentation
  * The release adds support for registering External instances to your Amazon ECS clusters.
* `service/mwaa`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/qldb`: Updates service API and documentation

Release v1.38.47 (2021-05-25)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * This release includes support for a new feature: Job templates for AWS IoT Device Management Jobs. The release includes job templates as a new resource and APIs for managing job templates.
* `service/transfer`: Updates service API, documentation, and paginators
  * AWS Transfer Family customers can now use AWS Managed Active Directory or AD Connector to authenticate their end users, enabling seamless migration of file transfer workflows that rely on AD authentication, without changing end users' credentials or needing a custom authorizer.
* `service/workspaces`: Updates service API and documentation
  * Adds support for Linux device types in WorkspaceAccessProperties

Release v1.38.46 (2021-05-24)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/compute-optimizer`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for creating and managing EC2 On-Demand Capacity Reservations on Outposts.
* `service/logs`: Updates service API and documentation
  * This release provides dimensions and unit support for metric filters.
* `service/quicksight`: Updates service API and documentation
  * Add new parameters on RegisterUser and UpdateUser APIs to assign or update external ID associated to QuickSight users federated through web identity.

Release v1.38.45 (2021-05-21)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service API and documentation
  * EFS now supports account preferences. Utilizing the new capability, users can customize some aspects of their experience using EFS APIs and the EFS Console. The first preference clients are able to set is whether to start using longer File System and Mount Target IDs before EFS migrates to such IDs.
* `service/forecast`: Updates service API and documentation
* `service/opsworkscm`: Updates service API and documentation
  * New PUPPET_API_CRL attribute returned by DescribeServers API; new EngineVersion of 2019 available for Puppet Enterprise servers.
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3

Release v1.38.44 (2021-05-20)
===

### Service Client Updates
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/models.lex.v2`: Updates service API and documentation
* `service/personalize`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Add ARN based Row Level Security support to CreateDataSet/UpdateDataSet APIs.

Release v1.38.43 (2021-05-19)
===

### Service Client Updates
* `service/autoscaling`: Updates service API, documentation, and examples
  * With this release, customers can easily use Predictive Scaling as a policy directly through Amazon EC2 Auto Scaling configurations to proactively scale their applications ahead of predicted demand.
* `service/eks`: Updates service waiters
* `service/iam`: Updates service paginators
  * Add pagination to ListUserTags operation
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Amazon Lightsail.
* `service/rekognition`: Updates service API and documentation
  * Amazon Rekognition Custom Labels adds support for customer managed encryption, using AWS Key Management Service, of image files copied into the service and files written back to the customer.

Release v1.38.42 (2021-05-18)
===

### Service Client Updates
* `service/apprunner`: Updates service API, documentation, paginators, and examples
* `service/compute-optimizer`: Updates service API and documentation
* `service/iotsitewise`: Updates service documentation
* `service/license-manager`: Updates service API and documentation
* `service/models.lex.v2`: Updates service API, documentation, and paginators
* `service/personalize`: Updates service API and documentation
* `service/support`: Updates service documentation
  * Documentation updates for support

### SDK Enhancements
* `aws/session`: Enable SSO provider to be mixed with other credential providers ([#3905](https://github.com/aws/aws-sdk-go/pull/3905))
  * Fixes [#3763](https://github.com/aws/aws-sdk-go/issues/3763)

Release v1.38.41 (2021-05-17)
===

### Service Client Updates
* `service/applicationcostprofiler`: Adds new service
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/iotdeviceadvisor`: Updates service API, documentation, and paginators
* `service/mediaconnect`: Updates service API and documentation
* `service/neptune`: Updates service API, documentation, and paginators
  * Neptune support for CopyTagsToSnapshots
* `service/sagemaker-a2i-runtime`: Updates service documentation

Release v1.38.40 (2021-05-14)
===

### Service Client Updates
* `service/detective`: Updates service documentation
* `service/es`: Updates service API and documentation
  * Adds support for cold storage.
* `service/eventbridge`: Updates service API
* `service/events`: Updates service API
  * Update InputTransformer variable limit from 10 to 100 variables.
* `service/imagebuilder`: Updates service documentation
* `service/macie2`: Updates service API, documentation, and paginators
* `service/securityhub`: Updates service documentation
* `service/transcribe`: Updates service API and documentation

Release v1.38.39 (2021-05-12)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * High Memory virtual instances are powered by Intel Sky Lake CPUs and offer up to 12TB of memory.

Release v1.38.38 (2021-05-11)
===

### Service Client Updates
* `service/s3control`: Updates service API and documentation
  * Documentation updates for Amazon S3-control
* `service/ssm-contacts`: Adds new service
* `service/ssm-incidents`: Adds new service
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.38.37 (2021-05-10)
===

### Service Client Updates
* `service/codeartifact`: Updates service documentation
* `service/config`: Updates service paginators
* `service/ecs`: Updates service documentation
  * This release contains updates for Amazon ECS.
* `service/eks`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for Kantar SNAP File Audio Watermarking with a Kantar Watermarking account, and Display Definition Segment(DDS) segment data controls for DVB-Sub caption outputs.
* `service/ssm`: Updates service API, documentation, and paginators
  * This release adds new APIs to associate, disassociate and list related items in SSM OpsCenter; and this release adds DisplayName as a version-level attribute for SSM Documents and introduces two new document types: ProblemAnalysis, ProblemAnalysisTemplate.

Release v1.38.36 (2021-05-07)
===

### Service Client Updates
* `service/connect`: Updates service API and documentation
* `service/lakeformation`: Updates service API and documentation
* `service/lookoutmetrics`: Updates service API and documentation

Release v1.38.35 (2021-05-06)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/servicediscovery`: Updates service API and documentation
* `service/snowball`: Updates service API and documentation
  * AWS Snow Family adds APIs for ordering and managing Snow jobs with long term pricing
* `service/ssm`: Updates service API and documentation
  * SSM feature release - ChangeCalendar integration with StateManager.

Release v1.38.34 (2021-05-05)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/nimble`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot now provides the ability to automatically deploy the best model to an endpoint

### SDK Bugs
* `service/finspace`: Fix Content-Type header sent in request ([#3896](https://github.com/aws/aws-sdk-go/pull/3896))
  * Fixes the Content-Type header sent by the SDK in requests to the API
* `service/finspacedata`: Fix Content-Type header sent in request ([#3896](https://github.com/aws/aws-sdk-go/pull/3896))
  * Fixes the Content-Type header sent by the SDK in requests to the API

Release v1.38.33 (2021-05-05)
===

### Service Client Updates
* `service/finspace`: Updates service documentation
* `service/finspace-data`: Updates service documentation

Release v1.38.32 (2021-05-04)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/chime`: Updates service API, documentation, and paginators
  * This release adds the ability to search for and order international phone numbers for Amazon Chime SIP media applications.
* `service/devops-guru`: Updates service API, documentation, and paginators
* `service/health`: Updates service documentation
  * Documentation updates for health
* `service/sagemaker`: Updates service API and documentation
  * Enable retrying Training and Tuning Jobs that fail with InternalServerError by setting RetryStrategy.

Release v1.38.31 (2021-05-03)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Added new BatchCreateChannelMembership API to support multiple membership creation for channels
* `service/finspace`: Updates service API, documentation, paginators, and examples
* `service/finspace-data`: Adds new service
* `service/mturk-requester`: Updates service documentation
* `service/securityhub`: Updates service API and documentation

Release v1.38.30 (2021-04-30)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * CloudFront now supports CloudFront Functions, a native feature of CloudFront that enables you to write lightweight functions in JavaScript for high-scale, latency-sensitive CDN customizations.
* `service/customer-profiles`: Updates service API and documentation
* `service/forecast`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/personalize`: Updates service documentation
* `service/robomaker`: Updates service API

### SDK Enhancements
* `private/protocol/xml/xmlutil`: XML encoding has been updated to include encoding line feed character. ([#3881](https://github.com/aws/aws-sdk-go/pull/3881))

Release v1.38.29 (2021-04-29)
===

### Service Client Updates
* `service/chime`: Updates service API
  * Increase AppInstanceUserId length to 64 characters
* `service/ecs`: Updates service API and documentation
  * Add support for EphemeralStorage on TaskDefinition and TaskOverride
* `service/macie2`: Updates service API and documentation
* `service/organizations`: Updates service documentation
  * Minor text updates for AWS Organizations API Reference

Release v1.38.28 (2021-04-28)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Add CallAs parameter to GetTemplateSummary to enable use with StackSets delegated administrator integration
* `service/connect`: Updates service API
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/mediapackage-vod`: Updates service API and documentation
* `service/nimble`: Updates service API, documentation, and paginators

Release v1.38.27 (2021-04-27)
===

### Service Client Updates
* `service/auditmanager`: Updates service API and documentation

Release v1.38.26 (2021-04-26)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Adding support for Red Hat Enterprise Linux with HA for Reserved Instances.
* `service/eks`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Adding Kafka Client Auth Related Parameters
* `service/iotwireless`: Updates service API and documentation
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * Documentation updates for mediaconvert
* `service/personalize`: Updates service API, documentation, and paginators

Release v1.38.25 (2021-04-23)
===

### Service Client Updates
* `service/mediapackage`: Updates service API and documentation
  * Add support for Widevine DRM on CMAF origin endpoints. Both Widevine and FairPlay DRMs can now be used simultaneously, with CBCS encryption.
* `service/sns`: Updates service documentation
  * Amazon SNS adds two new attributes, TemplateId and EntityId, for using sender IDs to send SMS messages to destinations in India.

Release v1.38.24 (2021-04-22)
===

### Service Client Updates
* `service/cognito-idp`: Updates service documentation
* `service/elasticache`: Updates service API and documentation
  * This release introduces log delivery of Redis slow log from Amazon ElastiCache.
* `service/forecast`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.38.23 (2021-04-21)
===

### Service Client Updates
* `service/cloudformation`: Updates service documentation
  * Added support for creating and updating stack sets with self-managed permissions from templates that reference macros.
* `service/detective`: Updates service API and documentation
* `service/groundstation`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now enables users to override index-level boosting configurations for each query.
* `service/redshift`: Updates service API, documentation, and paginators
  * Add operations: AddPartner, DescribePartners, DeletePartner, and UpdatePartnerStatus to support tracking integration status with data partners.

Release v1.38.22 (2021-04-19)
===

### Service Client Updates
* `service/ce`: Updates service API
* `service/savingsplans`: Updates service API

Release v1.38.21 (2021-04-15)
===

### Service Client Updates
* `service/dms`: Updates service API, documentation, waiters, and paginators
  * AWS DMS added support of TLS for Kafka endpoint. Added Describe endpoint setting API for DMS endpoints.
* `service/sts`: Updates service API
  * STS now supports assume role with Web Identity using JWT token length upto 20000 characters

Release v1.38.20 (2021-04-14)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/mediaconnect`: Updates service API, documentation, and waiters
* `service/route53`: Updates service documentation
  * Documentation updates for route53

Release v1.38.19 (2021-04-13)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Amazon Lightsail.
* `service/rds`: Updates service API, documentation, waiters, paginators, and examples
  * Clarify that enabling or disabling automated backups causes a brief downtime, not an outage.
* `service/redshift`: Updates service API and documentation
  * Added support to enable AQUA in Amazon Redshift clusters.
* `service/sts`: Updates service API and documentation
  * This release adds the SourceIdentity parameter that can be set when assuming a role.

Release v1.38.18 (2021-04-12)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now allows you to set the access permissions for build artifacts, project artifacts, and log files that are uploaded to an Amazon S3 bucket that is owned by another account.
* `service/fsx`: Updates service API, documentation, and examples

Release v1.38.17 (2021-04-09)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * Add paginator support to DescribeStoreImageTasks and update documentation.
* `service/redshift`: Updates service API and documentation
  * Add support for case sensitive table level restore
* `service/shield`: Updates service API and documentation
  * CreateProtection now throws InvalidParameterException instead of InternalErrorException when system tags (tag with keys prefixed with "aws:") are passed in.

Release v1.38.16 (2021-04-08)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This release provides support for image updates
* `service/autoscaling`: Updates service API, documentation, and examples
  * Amazon EC2 Auto Scaling announces Warm Pools that help applications to scale out faster by pre-initializing EC2 instances and save money by requiring fewer continuously running instances
* `service/customer-profiles`: Updates service documentation
* `service/kinesis-video-archived-media`: Updates service documentation
* `service/lookoutequipment`: Adds new service
* `service/ram`: Updates service documentation
* `service/robomaker`: Updates service API and documentation

Release v1.38.15 (2021-04-07)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API, documentation, and paginators
* `service/elasticache`: Updates service API and documentation
  * This release adds tagging support for all AWS ElastiCache resources except Global Replication Groups.
* `service/ivs`: Updates service API, documentation, and paginators
* `service/mgn`: Updates service API, documentation, paginators, and examples
* `service/storagegateway`: Updates service API, documentation, and paginators
  * File Gateway APIs now support FSx for Windows as a cloud storage.

Release v1.38.14 (2021-04-06)
===

### Service Client Updates
* `service/cloud9`: Updates service documentation
  * Documentation updates for Cloud9
* `service/ec2`: Updates service API and documentation
  * This release adds support for storing EBS-backed AMIs in S3 and restoring them from S3 to enable cross-partition copying of AMIs
* `service/medialive`: Updates service API and documentation
  * MediaLive VPC outputs update to include Availability Zones, Security groups, Elastic Network Interfaces, and Subnet Ids in channel response
* `service/ssm`: Updates service API and documentation
  * Supports removing a label or labels from a parameter, enables ScheduledEndTime and ChangeDetails for StartChangeRequestExecution API, supports critical/security/other noncompliant count for patch API.

Release v1.38.13 (2021-04-05)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/auditmanager`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * MediaLive now support HTML5 Motion Graphics overlay

Release v1.38.12 (2021-04-02)
===

### Service Client Updates
* `service/imagebuilder`: Updates service API and documentation
* `service/mediapackage`: Updates service API and documentation
  * SPEKE v2 is an upgrade to the existing SPEKE API to support multiple encryption keys, based on an encryption contract selected by the customer.

Release v1.38.11 (2021-04-01)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * VPC Flow Logs Service adds a new API, GetFlowLogsIntegrationTemplate, which generates CloudFormation templates for Athena. For more info, see https://docs.aws.amazon.com/console/vpc/flow-logs/athena
* `service/fms`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * AWS Kendra's ServiceNow data source now supports OAuth 2.0 authentication and knowledge article filtering via a ServiceNow query.
* `service/lex-models`: Updates service API
* `service/lightsail`: Updates service API and documentation
  * - This release adds support for state detail for Amazon Lightsail container services.
* `service/mediaconvert`: Updates service API and documentation
  * MediaConvert now supports HLS ingest, sidecar WebVTT ingest, Teletext color & style passthrough to TTML subtitles, TTML to WebVTT subtitle conversion with style, & DRC profiles in AC3 audio.
* `service/route53resolver`: Updates service API, documentation, and paginators
* `service/runtime.lex`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.38.10 (2021-03-31)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * AWS Batch adds support for Amazon EFS File System
* `service/cloud9`: Updates service API, documentation, and examples
  * Add ImageId input parameter to CreateEnvironmentEC2 endpoint. New parameter enables creation of environments with different AMIs.
* `service/cloudformation`: Updates service API and documentation
  * 1. Added a new parameter "RegionConcurrencyType" in OperationPreferences. 2. Changed the name of "AccountUrl" to "AccountsUrl" in "DeploymentTargets" parameter.
* `service/cloudhsm`: Updates service API and documentation
  * Minor documentation and link updates.
* `service/cognito-sync`: Updates service API, documentation, paginators, and examples
* `service/comprehend`: Updates service API and documentation
* `service/datapipeline`: Updates service API, documentation, paginators, and examples
  * Minor documentation updates and link updates.
* `service/detective`: Updates service API and documentation
* `service/directconnect`: Updates service API and documentation
  * This release adds MACsec support to AWS Direct Connect
* `service/iot`: Updates service API and documentation
  * Added ability to prefix search on attribute value for ListThings API.
* `service/iotwireless`: Updates service API and documentation
* `service/machinelearning`: Updates service API, documentation, paginators, and examples
  * Minor documentation updates and link updates.
* `service/pricing`: Updates service API, documentation, and examples
* `service/redshift`: Updates service API and documentation
  * Enable customers to share access to their Redshift clusters from other VPCs (including VPCs from other accounts).
* `service/transcribe`: Updates service API
* `service/workmail`: Updates service API and documentation
  * This release adds support for mobile device access rules management in Amazon WorkMail.

Release v1.38.9 (2021-03-30)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/databrew`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, waiters, and paginators
  * ReplaceRootVolume feature enables customers to replace the EBS root volume of a running instance to a previously known state. Add support to grant account-level access to the EC2 serial console
* `service/ec2-instance-connect`: Updates service API and documentation
* `service/frauddetector`: Updates service API, documentation, and paginators
* `service/monitoring`: Updates service API, documentation, and paginators
  * SDK update for new Metric Streams feature
* `service/pinpoint`: Updates service API and documentation
  * Added support for journey pause/resume, journey updatable import segment and journey quiet time wait.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Autopilot now supports 1) feature importance reports for AutoML jobs and 2) PartialFailures for AutoML jobs

Release v1.38.8 (2021-03-29)
===

### Service Client Updates
* `service/docdb`: Updates service API, documentation, and paginators
  * This release adds support for Event Subscriptions to DocumentDB.
* `service/glue`: Updates service API and documentation
  * Allow Dots in Registry and Schema Names for CreateRegistry, CreateSchema; Fixed issue when duplicate keys are present and not returned as part of QuerySchemaVersionMetadata.
* `service/iam`: Updates service API
  * AWS Identity and Access Management GetAccessKeyLastUsed API will throw a custom error if customer public key is not found for access keys.
* `service/location`: Updates service API and documentation
* `service/wafv2`: Updates service API and documentation

Release v1.38.7 (2021-03-26)
===

### Service Client Updates
* `service/customer-profiles`: Updates service API and documentation
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Add support for SageMaker Model Builder Pipelines Targets to EventBridge
* `service/iotwireless`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

Release v1.38.6 (2021-03-25)
===

### Service Client Updates
* `service/lookoutmetrics`: Fixes handling of API requests.
  * Fix SDK's serialization of request to include expected Content-Type header.

Release v1.38.5 (2021-03-25)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/lookoutmetrics`: Adds new service
* `service/medialive`: Updates service API and documentation
  * EML now supports handling HDR10 and HLG 2020 color space from a Link input.
* `service/rekognition`: Updates service API and documentation
  * "This release introduces AWS tagging support for Amazon Rekognition collections, stream processors, and Custom Label models."
* `service/sagemaker`: Updates service API and documentation
  * This feature allows customer to specify the environment variables in their CreateTrainingJob requests.
* `service/sqs`: Updates service documentation
  * Documentation updates for Amazon SQS

Release v1.38.4 (2021-03-24)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * maximumEfaInterfaces added to DescribeInstanceTypes API
* `service/greengrass`: Updates service API
  * Updated the parameters to make name required for CreateGroup API.
* `service/route53`: Updates service documentation
  * Documentation updates for route53
* `service/s3`: Updates service documentation and examples
  * Documentation updates for Amazon S3
* `service/s3control`: Updates service documentation and paginators
  * Documentation updates for s3-control
* `service/ssm`: Updates service API and documentation
  * This release allows SSM Explorer customers to enable OpsData sources across their organization when creating a resource data sync.

Release v1.38.3 (2021-03-23)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/fis`: Updates service API
* `service/gamelift`: Updates service API and documentation
  * GameLift adds support for using event notifications to monitor game session placements. Specify an SNS topic or use CloudWatch Events to track activity for a game session queue.
* `service/iam`: Updates service documentation
  * Documentation updates for IAM operations and descriptions.
* `service/redshift`: Updates service API and documentation
  * Removed APIs to control AQUA on clusters.

Release v1.38.2 (2021-03-22)
===

### Service Client Updates
* `service/codeartifact`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for UEFI boot on selected AMD- and Intel-based EC2 instances.
* `service/macie2`: Updates service API and documentation
* `service/redshift`: Updates service API and documentation
  * Added support to enable AQUA in Amazon Redshift clusters.

Release v1.38.1 (2021-03-19)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * X2gd instances are the next generation of memory-optimized instances powered by AWS-designed, Arm-based AWS Graviton2 processors.
* `service/sagemaker`: Updates service API and documentation
  * Adding authentication support for pulling images stored in private Docker registries to build containers for real-time inference.

Release v1.38.0 (2021-03-18)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling Instance Refresh now supports phased deployments.
* `service/redshift`: Updates service API and documentation
  * Add new fields for additional information about VPC endpoint for clusters with reallocation enabled, and a new field for total storage capacity for all clusters.
* `service/securityhub`: Updates service API and documentation

### SDK Features
* `service/s3`: S3 Object Lambda is a new S3 feature that enables users to apply their own custom code to process the output of a standard S3 GET request by automatically invoking a Lambda function with a GET request
* `service/s3control`: S3 Object Lambda is a new S3 feature that enables users to apply their own custom code to process the output of a standard S3 GET request by automatically invoking a Lambda function with a GET request.

Release v1.37.33 (2021-03-17)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Making serviceRole an optional parameter when creating a compute environment. If serviceRole is not provided then Service Linked Role will be created (or reused if it already exists).
* `service/sagemaker`: Updates service API and documentation
  * Support new target device ml_eia2 in SageMaker CreateCompilationJob API

Release v1.37.32 (2021-03-16)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API, documentation, and paginators
* `service/gamelift`: Updates service API, documentation, and paginators
  * GameLift expands to six new AWS Regions, adds support for multi-location fleets to streamline management of hosting resources, and lets you customize more of the game session placement process.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/lambda`: Updates service API
  * Allow empty list for function response types
* `service/mediaconnect`: Updates service API and documentation
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/mwaa`: Updates service API

Release v1.37.31 (2021-03-15)
===

### Announcement
* The HEAD tracking branch of the repository has been renamed from `master` to `main`.
  * Users using GOPATH to manage application dependencies need to remove the SDK from GOPATH and re-retrieve the SDK using `go get github.com/aws/aws-sdk-go`.

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * AWS CodeDeploy can now detect instances running an outdated revision of your application and automatically update them with the latest revision.
* `service/ecs`: Updates service API and documentation
  * This is for ecs exec feature release which includes two new APIs - execute-command and update-cluster and an AWS CLI customization for execute-command API
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR customers can now specify Resource Group to target Capacity Reservations in their EMR clusters with instance fleets using allocation strategy.
* `service/fis`: Updates service API, documentation, paginators, and examples
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.37.30 (2021-03-12)
===

### Service Client Updates
* `service/cur`: Updates service API and documentation
  * - Added optional billingViewArn field for OSG.
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service API and documentation
  * Adds API support for WorkSpaces bundle management operations.

Release v1.37.29 (2021-03-11)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * MediaLive supports the ability to apply a canned ACL to output sent to an AWS S3 bucket; supports ability to specify position for EBU-TT and TTML output captions converted from Teletext source.
* `service/network-firewall`: Updates service documentation
* `service/wafv2`: Updates service documentation

Release v1.37.28 (2021-03-10)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API, documentation, and paginators
* `service/backup`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Adding ID element to the CORSRule schema
* `service/ssm`: Updates service API and documentation
  * Systems Manager support for tagging OpsMetadata.

Release v1.37.27 (2021-03-09)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * EC2 Auto Scaling now supports setting a local time zone for cron expressions in scheduled actions, removing the need to adjust for Daylight Saving Time (DST)
* `service/codeguruprofiler`: Updates service API and documentation
* `service/elasticfilesystem`: Updates service API, documentation, and examples
  * AWS EFS is introducing one-zone file systems.
* `service/iotwireless`: Updates service API
* `service/rds`: Updates service API, documentation, and paginators
  * This release adds support for Amazon RDS Proxy endpoints.

Release v1.37.26 (2021-03-08)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for autoscaling for capacity-optimized-prioritized SpotAllocationStrategy
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR customers can now specify how EC2 On-Demand Capacity Reservations are used in their EMR clusters with instance fleets using allocation strategy.
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Documentation updates for Lambda. Constraint updates to AddLayerVersionPermission's Action and OrganizationId parameters, and AddPermission's Principal and SourceAccount parameters.
* `service/s3`: Updates service documentation and examples
  * Amazon S3 Documentation updates
* `service/s3control`: Updates service API and documentation
  * Documentation updates for Amazon S3

Release v1.37.25 (2021-03-05)
===

### Service Client Updates
* `service/appflow`: Updates service documentation
* `service/athena`: Updates service API, documentation, and paginators
  * Adds APIs to create, list, update, and delete prepared SQL statements that have optional placeholder parameters. A prepared statement can use different values for these parameters each time it is run.
* `service/codepipeline`: Updates service API
  * Updated the parameters to make actionType required for UpdateActionType
* `service/ec2`: Updates service API and documentation
  * Expands EC2/Spot Fleet capacity-optimized allocation strategy to allow users to prioritize instance pools. Fleet attempts to fulfill priorities on a best-effort basis but optimizes for capacity first.
* `service/license-manager`: Updates service API
* `service/medialive`: Updates service API and documentation
  * Medialive now supports the ability to transfer AWS Elemental Link devices to another region.
* `service/network-firewall`: Updates service API and documentation
* `service/shield`: Updates service API and documentation
  * Add support for tagging of Shield protection and protection group resources.

Release v1.37.24 (2021-03-04)
===

### Service Client Updates
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Introducing support for EventBridge Api Destinations - any HTTP APIs as Targets, with managed authorization via EventBridge Connections.
* `service/mwaa`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release adds the ResolvedOutputS3Uri to the DescribeFeatureGroup API to indicate the S3 prefix where offline data is stored in a feature group
* `service/servicediscovery`: Updates service API and documentation

Release v1.37.23 (2021-03-03)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * Adds 2 new APIs to add and retrieve account configuration in AWS Certificate Manager.
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now supports Session Manager debugging for batch builds.
* `service/es`: Updates service API and documentation
  * AWS ElasticSearch Feature : Support for adding tags in elastic search domain during domain creation
* `service/events`: Updates service API and documentation
  * Adds TraceHeader to PutEventsRequestEntry to support AWS X-Ray trace-ids on events generated using the PutEvents operation.
* `service/forecast`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/secretsmanager`: Updates service API and documentation
  * Added support for multi-Region secrets APIs ReplicateSecretToRegions, RemoveRegionsFromReplication, and StopReplicationToReplica
* `service/wellarchitected`: Updates service API and documentation

Release v1.37.22 (2021-03-02)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service documentation
* `service/datasync`: Updates service API and documentation
* `service/directconnect`: Updates service documentation
  * Doc only update for AWS Direct Connect that fixes several customer-reported issues
* `service/eventbridge`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/managedblockchain`: Updates service documentation

Release v1.37.21 (2021-03-01)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/codepipeline`: Updates service API, documentation, and paginators
  * Added a new field to the ListPipelines API to allow maximum search results of 1000
* `service/eks`: Updates service API
* `service/ssm`: Updates service API and documentation
  * Add Support for Patch Manger Baseline Override parameter.

Release v1.37.20 (2021-02-26)
===

### Service Client Updates
* `service/eks`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * Added UpdateStudio API that allows updating a few attributes of an EMR Studio.
* `service/s3`: Updates service API, documentation, and examples
  * Add RequestPayer to GetObjectTagging and PutObjectTagging.
* `service/sso-admin`: Updates service API

Release v1.37.19 (2021-02-25)
===

### Service Client Updates
* `service/databrew`: Updates service API and documentation
* `service/detective`: Updates service API and documentation
* `service/imagebuilder`: Updates service API, documentation, and paginators
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/transfer`: Updates service API
  * Corrected the upper limit for TestIdentityProvider input lengths to 1024 characters

Release v1.37.18 (2021-02-24)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/compute-optimizer`: Updates service documentation
* `service/ecr-public`: Updates service API and documentation
* `service/es`: Updates service API, documentation, and paginators
  * Amazon Elasticsearch Service now supports Auto-Tune, which monitors performance metrics and automatically optimizes domains
* `service/mediapackage-vod`: Updates service API and documentation

Release v1.37.17 (2021-02-23)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Adds a new optional IncludeDeletedGroups parameter to the DescribeScalingActivities API.
* `service/connect`: Updates service API
* `service/glue`: Updates service API and documentation
  * Updating the page size for Glue catalog getter APIs.
* `service/iotevents`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * Enables AWS Pinpoint customers to use Entity Id and Template Id when sending SMS message. These parameters can be obtained from the regulatory body of the country where you are trying to send the SMS.
* `service/quicksight`: Updates service documentation
  * Documentation updates for QuickSight Row Level Security
* `service/redshift-data`: Updates service API and documentation
* `service/s3control`: Updates service documentation
  * Documentation updates for s3-control

Release v1.37.16 (2021-02-22)
===

### Service Client Updates
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports core dump for SageMaker Endpoints and direct invocation of a single container in a SageMaker Endpoint that hosts multiple containers.

Release v1.37.15 (2021-02-19)
===

### Service Client Updates
* `service/rds`: Updates service API and documentation
  * Added awsBackupRecoveryPointArn in ModifyDBInstanceRequest and in the response of ModifyDBInstance.

Release v1.37.14 (2021-02-18)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Adding the 'callAs' parameter to all CloudFormation StackSets APIs except getTemplateSummary to support creating and managing service-managed StackSets with AWS Organizations Delegated Administrators
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild now allows you to specify a separate bucket owner as part of the S3 destination in a report group.
* `service/health`: Updates service documentation
  * Documentation updates for health
* `service/sagemaker`: Updates service API and documentation
  * This release adds expires-in-seconds parameter to the CreatePresignedDomainUrl API for support of a configurable TTL.

### SDK Enhancements
* `service/neptune`: Support for PreSignedUrl generation for CopyDBClusterSnapshot and CreateDBCluster operations. ([#3782](https://github.com/aws/aws-sdk-go/pull/3782))
* `service/docdb`: Support for PreSignedUrl generation for CopyDBClusterSnapshot and CreateDBCluster operations. ([#3782](https://github.com/aws/aws-sdk-go/pull/3782))

Release v1.37.13 (2021-02-17)
===

### Service Client Updates
* `service/config`: Updates service API
* `service/ec2`: Updates service API and documentation
  * This release includes a new filter for describe-vpc-endpoint-services.
* `service/lookoutvision`: Updates service API and documentation

Release v1.37.12 (2021-02-16)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * This release provides per-project limits for the number of concurrent builds
* `service/devops-guru`: Updates service API and documentation

### SDK Bugs
* `aws/client`: Fix logging to allow it to be enabled per operation
  * Allow logging of operation and request to be enabled per operation, not only per client or session.

Release v1.37.11 (2021-02-15)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/medialive`: Updates service API and documentation
  * AWS MediaLive now supports Automatic-Input-Failover for CDI Inputs.
* `service/mediatailor`: Updates service API, documentation, and paginators
* `service/pinpoint`: Updates service API and documentation
  * Lets customers use origination number when specifying SMS message configuration for Campaigns and Journeys.
* `service/redshift-data`: Updates service API and documentation
* `service/workmailmessageflow`: Updates service API and documentation

Release v1.37.10 (2021-02-12)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/codepipeline`: Updates service API and documentation
  * The release provides new GetActionType and UpdateActionType APIs for viewing and editing action types in CodePipeline.
* `service/detective`: Updates service API
* `service/eks`: Updates service API, documentation, and paginators
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/iam`: Updates service API and documentation
  * AWS Identity and Access Management now supports tagging for the following resources: customer managed policies, identity providers, instance profiles, server certificates, and virtual MFA devices.
* `service/macie2`: Updates service API and documentation
* `service/personalize-events`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * EngineMode in the response of DescribeDBClusterSnapshots. SupportedEngineModes, SupportsParallelQuery and SupportsGlobalDatabases in ValidUpgradeTarget of DBEngineVersions in DescribeDBEngineVersions.
* `service/wafv2`: Updates service API and documentation

Release v1.37.9 (2021-02-11)
===

### Service Client Updates
* `service/databrew`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Adding support for RDS Aurora Global Database Failover

Release v1.37.8 (2021-02-09)
===

### Service Client Updates
* `service/gamelift`: Updates service API
  * GameLift FleetIQ users can now use AMD instance families in supported Regions. In addition, FlexMatch matchmaking notification now supports SNS FIFO topics.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for WMA audio only ingest, SMPTE-TT text and image caption ingest, and MPEG-2 video in MXF OP1a outputs.
* `service/qldb-session`: Updates service API and documentation
* `service/quicksight`: Updates service API, documentation, and paginators
  * QuickSight now supports Python's paginators for Exploration APIs.
* `service/sagemaker`: Updates service API and documentation
  * Add a new optional FrameworkVersion field to Sagemaker Neo CreateCompilationJob API

Release v1.37.7 (2021-02-08)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API and documentation
  * ConflictException is now thrown when certain operations are called on resources before CloudTrail has time to load the resources. Two new exceptions have been added to the PutInsightSelectors API.
* `service/dataexchange`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/globalaccelerator`: Updates service API and documentation
* `service/iotsitewise`: Updates service API and documentation
* `service/ivs`: Updates service API
* `service/macie2`: Updates service API and documentation

Release v1.37.6 (2021-02-05)
===

### Service Client Updates
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/macie`: Updates service documentation
  * Documentation updates for Amazon Macie Classic. We replaced the term "master account" with the term "administrator account." An administrator account is used to centrally manage multiple accounts.
* `service/organizations`: Updates service API and documentation
  * Added support for a few additional exception codes for some AWS Organizations APIs.

Release v1.37.5 (2021-02-04)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * AWS Outposts now supports EBS local snapshots on Outposts that allows customers to store snapshots of EBS volumes and AMIs locally on S3 on Outposts.

Release v1.37.4 (2021-02-04)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/athena`: Updates service API and documentation
  * Adds the Athena ListEngineVersions action and the EngineVersion data type. ListEngineVersions returns the available Athena engine versions, including Auto, as a list of EngineVersion objects.
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * AWS Outposts now supports EBS local snapshots on Outposts that allows customers to store snapshots of EBS volumes and AMIs locally on S3 on Outposts.
* `service/emr-containers`: Updates service API
* `service/quicksight`: Updates service API and documentation
  * API release for field folders feature.

Release v1.37.3 (2021-02-03)
===

### Service Client Updates
* `service/auditmanager`: Updates service API
* `service/ce`: Updates service documentation
* `service/codebuild`: Updates service documentation
  * Documentation updates for codebuild
* `service/compute-optimizer`: Updates service documentation
* `service/databrew`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, and paginators
  * EC2 Public IP now supports API for setting PTR records on Elastic IP address.
* `service/iotsitewise`: Updates service API and documentation
* `service/lambda`: Updates service API, documentation, and examples
  * Support for creating Lambda Functions using 'nodejs14.x'
* `service/securityhub`: Updates service API and documentation
* `service/workmail`: Updates service API
  * Increased maximum length of ipRanges values for Access Control Rules from 10 to 1024.

Release v1.37.2 (2021-02-02)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/appmesh`: Updates service API and documentation
* `service/iotwireless`: Updates service API and documentation
* `service/location`: Updates service documentation
* `service/lookoutvision`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports Image Media Playlists on HLS outputs, version 0.4 (trick-mode).
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations.
* `service/rds-data`: Updates service API and documentation
* `service/route53`: Updates service documentation
  * Documentation updates for Route 53
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations now supports Delete Object Tagging

### SDK Enhancements
* `service/s3`: Amazon S3 now supports AWS PrivateLink, providing direct access to S3 via a private endpoint within your virtual private network.

### SDK Bugs
* `aws/session`: Fixed a bug that prevented credentials from being sourced from the environment if the loaded shared config profile contained partial SSO configuration. ([#3769](https://github.com/aws/aws-sdk-go/pull/3769))
  * Fixes ([#3768](https://github.com/aws/aws-sdk-go/issues/3768))

Release v1.37.1 (2021-01-29)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/macie2`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * "AWS Elemental MediaLive now supports output to a private VPC. When this property is specified, the output will egress from a user specified VPC."
* `service/transcribe-streaming`: Updates service API and documentation

### SDK Bugs
* `service/lexmodelsv2`: Add fix to send expected Content-Type header
    * Fixes the Amazon Lex Model Builder V2 API client to send the expected Content-Type of application/x-amz-json-1.1.

Release v1.37.0 (2021-01-28)
===

### Service Client Updates
* `service/databrew`: Updates service API and documentation
* `service/iot`: Updates service documentation
  * Documentation updates for IoT DeleteOTAUpdate API
* `service/managedblockchain`: Updates service API and documentation
* `service/monitoring`: Updates service API and documentation
  * Update to SDK to support label time zones in CloudWatch GetMetricData
* `service/robomaker`: Updates service API and documentation
* `service/wellarchitected`: Updates service documentation

### SDK Features
* `aws/credentials/ssocreds`: Add support for AWS Single Sign-On (SSO) Credential Provider ([#3755](https://github.com/aws/aws-sdk-go/pull/3755))
* `aws/session`: Support has been added to resolve shared configuration profiles that are configured for AWS Single Sign-On (SSO) ([#3755](https://github.com/aws/aws-sdk-go/pull/3755))

Release v1.36.33 (2021-01-27)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/customer-profiles`: Updates service API
* `service/elasticache`: Updates service API and documentation
  * Add support to pass ParameterGroup name as part updating Engine Version of Global Datastore.
* `service/es`: Updates service API and documentation
  * Amazon Elasticsearch Service adds support for node-to-node encryption and encryption at rest for existing domains running Elasticsearch version 6.7 and above
* `service/lightsail`: Updates service documentation
  * Documentation updates for Lightsail
* `service/sesv2`: Updates service API and documentation

Release v1.36.32 (2021-01-26)
===

### Service Client Updates
* `service/backup`: Updates service documentation

Release v1.36.31 (2021-01-22)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Introducing startDate field for CapacityReservation object for the date and time which the reservation started and adding reserved parameter for ModifyCapacityReservation.
* `service/greengrassv2`: Updates service documentation
* `service/models.lex.v2`: Adds new service
* `service/rds`: Updates service documentation
  * Documentation updates for Amazon RDS
* `service/redshift`: Updates service API and documentation
  * Update VPC endpoint field names.
* `service/runtime.lex.v2`: Adds new service
* `service/ssm`: Updates service documentation
  * Documentation updates for the ListDocumentFilters API action.

Release v1.36.30 (2021-01-21)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/resourcegroupstaggingapi`: Updates service API and documentation
  * This release adds a new parameter ResourceARNList to Resource Groups Tagging api GetResources api to allow customers retrieve tag data for specific resources.
* `service/securityhub`: Updates service API and documentation

Release v1.36.29 (2021-01-19)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * Add support for specifying ChimeBearer header as part of the request for Amazon Chime SDK messaging APIs. Documentation updates.
* `service/ecs`: Updates service API and documentation
  * This release adds support to include task definition metadata information such as registeredAt, deregisteredAt, registeredBy as part of DescribeTaskDefinition API.

Release v1.36.28 (2021-01-15)
===

### Service Client Updates
* `service/sns`: Updates service documentation
  * Documentation updates for Amazon SNS.

Release v1.36.27 (2021-01-14)
===

### Service Client Updates
* `service/cognito-identity`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * Customers can create segments using 5 new filters. Filters can check for the presence of a substring in attributes and can perform time-based comparisons formatted as ISO_INSTANT datetimes.
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations now supports restoring objects from the S3 Intelligent-Tiering Archive Access and Deep Archive Access tiers.
* `service/sagemaker`: Updates service API and documentation
  * This feature allows customers to enable/disable model caching on Multi-Model endpoints.

Release v1.36.26 (2021-01-13)
===

### Service Client Updates
* `service/frauddetector`: Updates service API and documentation
* `service/personalize`: Updates service documentation

### SDK Enhancements
* `private/protocol`: Loosen endpoint validation to allow customer specify port number ([#3730](https://github.com/aws/aws-sdk-go/pull/3730))
    * Updates SDK's endpoint validation of the hostname to allow ports to be specified.
* `service/s3/s3manager`: Add ETag field to UploadOutput ([#3733](https://github.com/aws/aws-sdk-go/pull/3733))
  * Adds the ETag field to the Uploader's UploadOutput return value.
  * Fixes [#2764](https://github.com/aws/aws-sdk-go/issues/2764)
* `aws`: Add `WithLowerCaseHeaderMaps` and `WithDisableRestProtocolURICleaning` to `aws.Config`. ([#3671](https://github.com/aws/aws-sdk-go/pull/3671))

### SDK Bugs
* `aws`: Fixed a case where `LowerCaseHeaderMaps` would not be merged when merging`aws.Config` types. ([#3671](https://github.com/aws/aws-sdk-go/pull/3671))

Release v1.36.25 (2021-01-12)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Adds support for the Smart Card Redirection feature
* `service/auditmanager`: Updates service API and documentation
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/lightsail`: Updates service API and documentation
  * This release adds IPv6 support for Amazon Lightsail instances, container services, CDN distributions, and load balancers.
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager adds pagination support for DescribeDocumentPermission API

Release v1.36.24 (2021-01-11)
===

### Service Client Updates
* `service/kms`: Updates service API and documentation
  * Adds support for filtering grants by grant ID and grantee principal in ListGrants requests to AWS KMS.
* `service/rds`: Updates service API and documentation
  * This releases adds support for Major Version Upgrades on Aurora MySQL Global Clusters. Customers will be able to upgrade their whole Aurora MySQL Global Cluster to a new major engine version.

Release v1.36.23 (2021-01-07)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Adding cancelled status and summary for executions aborted by pipeline updates.
* `service/devops-guru`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for I-Frame-only HLS manifest generation in CMAF outputs.

Release v1.36.22 (2021-01-06)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * This update increases the number of instance types that can be added to the overrides within an mixed instances group configuration.
* `service/autoscaling-plans`: Updates service documentation
* `service/transfer`: Updates service API and documentation
  * This release adds support for Amazon EFS, so customers can transfer files over SFTP, FTPS and FTP in and out of Amazon S3 as well as Amazon EFS.

Release v1.36.21 (2021-01-05)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/ce`: Updates service API and documentation

Release v1.36.20 (2021-01-04)
===

### Service Client Updates
* `service/cloudsearch`: Updates service API
  * This release adds support for new Amazon CloudSearch instances.
* `service/healthlake`: Updates service API and documentation

Release v1.36.19 (2020-12-31)
===

### Service Client Updates
* `service/servicecatalog`: Updates service API and documentation
  * Enhanced Service Catalog DescribeProvisioningParameters API to return new parameter constraints, i.e., MinLength, MaxLength, MinValue, MaxValue, ConstraintDescription and AllowedPattern

Release v1.36.18 (2020-12-30)
===

### Service Client Updates
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/macie2`: Updates service documentation

Release v1.36.17 (2020-12-29)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `service/apigatewayv2`: Updates service API and documentation
  * Amazon API Gateway now supports data mapping for HTTP APIs which allows customers to modify HTTP Request before sending it to their integration and HTTP Response before sending it to the invoker.

Release v1.36.16 (2020-12-28)
===

### Service Client Updates
* `service/cloudfront`: Updates service documentation
  * Amazon CloudFront has deprecated the CreateStreamingDistribution and CreateStreamingDistributionWithTags APIs as part of discontinuing support for Real-Time Messaging Protocol (RTMP) distributions.

Release v1.36.15 (2020-12-23)
===

### Service Client Updates
* `service/compute-optimizer`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * AWS DMS launches support for AWS Secrets Manager to manage Oracle ASM Database credentials
* `service/resource-groups`: Updates service API, documentation, and paginators

Release v1.36.14 (2020-12-22)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/connect`: Updates service API, documentation, and paginators
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/glue`: Updates service API and documentation
  * AWS Glue Find Matches machine learning transforms now support column importance scores.
* `service/iotwireless`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Adds customer-owned IP address (CoIP) support to Amazon RDS on AWS Outposts.
* `service/ssm`: Updates service API and documentation
  * SSM Maintenance Window support for registering/updating maintenance window tasks without targets.

Release v1.36.13 (2020-12-21)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway.
* `service/batch`: Updates service documentation
  * Documentation updates for batch
* `service/config`: Updates service API, documentation, and paginators
* `service/connectparticipant`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * AWS DMS launches support for AWS Secrets Manager to manage source and target database credentials.
* `service/ec2`: Updates service API and documentation
  * This release adds Tag On Create feature support for the AllocateAddress API.
* `service/glue`: Updates service API and documentation
  * Add 4 connection properties: SECRET_ID, CONNECTOR_URL, CONNECTOR_TYPE, CONNECTOR_CLASS_NAME. Add two connection types: MARKETPLACE, CUSTOM
* `service/managedblockchain`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/qldb-session`: Updates service API and documentation
* `service/s3`: Updates service API and examples
  * Format GetObject's Expires header to be an http-date instead of iso8601
* `service/securityhub`: Updates service documentation
* `service/service-quotas`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Updates service API and documentation

Release v1.36.12 (2020-12-18)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * EBS io2 volumes now supports Multi-Attach
* `service/personalize-runtime`: Updates service API
* `service/rds`: Updates service API and documentation
  * Adds IAM DB authentication information to the PendingModifiedValues output of the DescribeDBInstances API. Adds ClusterPendingModifiedValues information to the output of the DescribeDBClusters API.

Release v1.36.11 (2020-12-17)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API
  * C6gn instances are powered by AWS Graviton2 processors and offer 100 Gbps networking bandwidth. These instances deliver up to 40% better price-performance benefit versus comparable x86-based instances
* `service/imagebuilder`: Updates service API, documentation, and paginators
* `service/kms`: Updates service API, documentation, and examples
  * Added CreationDate and LastUpdatedDate timestamps to ListAliases API response
* `service/route53`: Updates service API and documentation
  * This release adds support for DNSSEC signing in Amazon Route 53.
* `service/route53resolver`: Updates service API, documentation, and paginators
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * Support TagOptions sharing with Service Catalog portfolio sharing.
* `service/sqs`: Updates service API and documentation
  * Amazon SQS adds queue attributes to enable high throughput FIFO.

Release v1.36.10 (2020-12-16)
===

### Service Client Updates
* `service/amp`: Updates service documentation
* `service/ce`: Updates service API and documentation
* `service/location`: Adds new service
* `service/quicksight`: Updates service API and documentation
  * QuickSight now supports connecting to federated data sources of Athena
* `service/wellarchitected`: Adds new service

Release v1.36.9 (2020-12-15)
===

### Service Client Updates
* `service/amp`: Adds new service
* `service/greengrassv2`: Adds new service
* `service/iot`: Updates service API, documentation, and paginators
  * AWS IoT Rules Engine adds Kafka Action that allows sending data to Apache Kafka clusters inside a VPC. AWS IoT Device Defender adds custom metrics and machine-learning based anomaly detection.
* `service/iotanalytics`: Updates service API and documentation
* `service/iotdeviceadvisor`: Adds new service
* `service/iotfleethub`: Adds new service
* `service/iotwireless`: Adds new service
* `service/lambda`: Updates service API, documentation, and examples
  * Added support for Apache Kafka as a event source. Added support for TumblingWindowInSeconds for streams event source mappings. Added support for FunctionResponseTypes for streams event source mappings
* `service/ssm`: Updates service API, documentation, and paginators
  * Adding support for Change Manager API content

Release v1.36.8 (2020-12-14)
===

### Service Client Updates
* `service/devops-guru`: Updates service API, documentation, paginators, and examples
* `service/ec2`: Updates service API
  * Add c5n.metal to ec2 instance types list
* `service/globalaccelerator`: Updates service paginators

Release v1.36.7 (2020-12-11)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `service/cloudtrail`: Updates service API and documentation
  * CloudTrailInvalidClientTokenIdException is now thrown when a call results in the InvalidClientTokenId error code. The Name parameter of the AdvancedEventSelector data type is now optional.
* `service/guardduty`: Updates service documentation
  * Documentation updates for GuardDuty
* `service/iotsitewise`: Updates service API, documentation, and paginators
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring
* `service/pi`: Updates service documentation

Release v1.36.6 (2020-12-10)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * TGW connect simplifies connectivity of SD-WAN appliances; IGMP support for TGW multicast; VPC Reachability Analyzer for VPC resources connectivity analysis.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports adding synonyms to an index through the new Thesaurus resource.
* `service/networkmanager`: Updates service API, documentation, and paginators

Release v1.36.5 (2020-12-09)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release adds support for G4ad instances powered by AMD Radeon Pro V520 GPUs and AMD 2nd Generation EPYC processors
* `service/globalaccelerator`: Updates service API, documentation, and paginators
* `service/redshift`: Updates service API and documentation
  * Add support for availability zone relocation feature.

### SDK Enhancements
* `aws/session`: Add support for client TLS certs on HTTP client ([#3654](https://github.com/aws/aws-sdk-go/pull/3654))
    * Adds support for the SDK to automatically modify the HTTP client to include TLS configuration of custom Client TLS certificate.

Release v1.36.4 (2020-12-08)
===

### Service Client Updates
* `service/auditmanager`: Adds new service
* `service/ecr`: Updates service API and documentation
  * This release adds support for configuring cross-region and cross-account replication of your Amazon ECR images.
* `service/emr-containers`: Adds new service
* `service/forecast`: Updates service API and documentation
* `service/healthlake`: Adds new service
* `service/kendra`: Updates service API and documentation
  * 1. Amazon Kendra connector for Google Drive repositories 2. Amazon Kendra's relevance ranking models are regularly tuned for each customer by capturing end-user search patterns and feedback.
* `service/quicksight`: Updates service API and documentation
  * Added new parameters for join optimization.
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This feature helps you monitor model performance characteristics such as accuracy, identify undesired bias in your ML models, and explain model decisions better with explainability drift detection.
* `service/sagemaker-edge`: Adds new service

Release v1.36.3 (2020-12-07)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Added PreserveTransaction setting to preserve order of CDC for S3 as target. Added CsvNoSupValue setting to replace empty value for columns not included in the supplemental log for S3 as target.
* `service/servicecatalog-appregistry`: Updates service API and documentation

Release v1.36.2 (2020-12-04)
===

### Service Client Updates
* `service/ds`: Updates service documentation
  * Documentation updates for ds - updated descriptions
* `service/ec2`: Updates service API and documentation
  * This release introduces tag-on-create capability for the CreateImage API. A user can now specify tags that will be applied to the new resources (image, snapshots or both), during creation time.
* `service/kafka`: Updates service API and documentation
* `service/lambda`: Updates service API, documentation, and examples
  * Added the additional enum InvalidImage to StateReasonCode and LastUpdateStatusReasonCode fields.
* `service/license-manager`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports black video and audio silence as new conditions to trigger automatic input failover.
* `service/rds`: Updates service API and documentation
  * Adds support for Amazon RDS Cross-Region Automated Backups, the ability to setup automatic replication of snapshots and transaction logs from a primary AWS Region to a secondary AWS Region.
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager Patch Manager MAC OS Support and OpsMetadata Store APIs to store operational metadata for an Application.
* `service/workspaces`: Updates service API and documentation
  * Update the import-workspace-image API to have "BYOL_REGULAR_WSP" as a valid input string for ingestion-process.

Release v1.36.1 (2020-12-03)
===

### Service Client Updates
* `service/amplifybackend`: Updates service documentation
* `service/batch`: Updates service API and documentation
  * This release adds support for customer to run Batch Jobs on ECS Fargate, the serverless compute engine built for containers on AWS. Customer can also propagate Job and Job Definition Tags to ECS Task.
* `service/compute-optimizer`: Updates service API and documentation
* `service/license-manager`: Updates service API and documentation

Release v1.36.0 (2020-12-02)
===

### Service Client Updates
* `service/customer-profiles`: Adds new service

### SDK Features
* `service/profile`: Remove incorrectly named client package, profile.
  * Removes an incorrectly named service client package `profile` that was included in release, v1.35.37.

Release v1.35.37 (2020-12-01)
===

### Service Client Updates
* `service/amplifybackend`: Adds new service
* `service/appintegrations`: Adds new service
* `service/connect`: Updates service API, documentation, and paginators
* `service/connect-contact-lens`: Adds new service
* `service/devops-guru`: Adds new service
* `service/ds`: Updates service API and documentation
  * Adding client authentication feature for AWS AD Connector
* `service/ec2`: Updates service API and documentation
  * This release adds support for: EBS gp3 volumes; and D3/D3en/R5b/M5zn instances powered by Intel Cascade Lake CPUs
* `service/ecr-public`: Adds new service
* `service/eks`: Updates service API, documentation, waiters, and paginators
* `service/honeycode`: Updates service API, documentation, and paginators
* `service/lambda`: Updates service API and documentation
  * This release includes support for a new feature: Container images support in AWS Lambda. This adds APIs for deploying functions as container images. AWS Lambda now supports memory up to 10240MB.
* `service/lookoutvision`: Adds new service
* `service/profile`: Adds new service
* `service/s3`: Updates service API, documentation, and examples
  * S3 adds support for multiple-destination replication, option to sync replica modifications;  S3 Bucket Keys to reduce cost of S3 SSE with AWS KMS
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Amazon SageMaker Pipelines for ML workflows. Amazon SageMaker Feature Store, a fully managed repository for ML features.
* `service/sagemaker-featurestore-runtime`: Adds new service

Release v1.35.36 (2020-12-01)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release introduces Amazon EC2 Mac1 instances, a new Amazon EC2 instance family built on Apple Mac mini computers, powered by AWS Nitro System, and support running macOS workloads on Amazon EC2

Release v1.35.35 (2020-11-24)
===

### Service Client Updates
* `service/appflow`: Updates service API and documentation
* `service/batch`: Updates service API and documentation
  * Add Ec2Configuration in ComputeEnvironment.ComputeResources. Use in CreateComputeEnvironment API to enable AmazonLinux2 support.
* `service/cloudformation`: Updates service API and documentation
  * Adds support for the new Modules feature for CloudFormation. A module encapsulates one or more resources and their respective configurations for reuse across your organization.
* `service/cloudtrail`: Updates service API and documentation
  * CloudTrail now includes advanced event selectors, which give you finer-grained control over the events that are logged to your trail.
* `service/codebuild`: Updates service API and documentation
  * Adding GetReportGroupTrend API for Test Reports.
* `service/cognito-idp`: Updates service API and documentation
* `service/comprehend`: Updates service API, documentation, and paginators
* `service/elasticbeanstalk`: Updates service API and documentation
  * Updates the Integer constraint of DescribeEnvironmentManagedActionHistory's MaxItems parameter to [1, 100].
* `service/fsx`: Updates service API and documentation
* `service/gamelift`: Updates service API and documentation
  * GameLift FlexMatch is now available as a standalone matchmaking solution. FlexMatch now provides customizable matchmaking for games hosted peer-to-peer, on-premises, or on cloud compute primitives.
* `service/iotsitewise`: Updates service API and documentation
* `service/lex-models`: Updates service API
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for Vorbis and Opus audio in OGG/OGA containers.
* `service/mwaa`: Adds new service
* `service/quicksight`: Updates service API and documentation
  * Support for embedding without user registration. New enum EmbeddingIdentityType. A potential breaking change. Affects code that refers IdentityType enum type directly instead of literal string value.
* `service/states`: Updates service API and documentation
  * This release of the AWS Step Functions SDK introduces support for Synchronous Express Workflows
* `service/timestream-write`: Updates service API and documentation
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.35.34 (2020-11-23)
===

### Service Client Updates
* `service/application-insights`: Updates service API and documentation
* `service/autoscaling`: Updates service documentation
  * Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `service/codeartifact`: Updates service API and documentation
* `service/codestar-connections`: Updates service API and documentation
* `service/dynamodb`: Updates service API and documentation
  * With this release, you can capture data changes in any Amazon DynamoDB table as an Amazon Kinesis data stream. You also can use PartiQL (SQL-compatible language) to manipulate data in DynamoDB tables.
* `service/ec2`: Updates service API and documentation
  * This release adds support for Multiple Private DNS names to DescribeVpcEndpointServices response.
* `service/ecs`: Updates service API and documentation
  * This release adds support for updating capacity providers, specifying custom instance warmup periods for capacity providers, and using deployment circuit breaker for your ECS Services.
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/elasticmapreduce`: Updates service API, documentation, and paginators
  * Add API support for EMR Studio, a new notebook-first IDE for data scientists and data engineers with single sign-on, Jupyter notebooks, automated infrastructure provisioning, and job diagnosis.
* `service/forecast`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Feature1 - Glue crawler adds data lineage configuration option. Feature2 - AWS Glue Data Catalog adds APIs for PartitionIndex creation and deletion as part of Enhancement Partition Management feature.
* `service/iot`: Updates service API and documentation
  * This release enables users to identify different file types in the over-the-air update (OTA) functionality using fileType parameter for CreateOTAUpdate API
* `service/kafka`: Updates service API and documentation
* `service/lambda`: Updates service API, documentation, and paginators
  * This release includes support for new feature: Code Signing for AWS Lambda. This adds new resources and APIs to configure Lambda functions to accept and verify signed code artifacts at deployment.
* `service/license-manager`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/signer`: Updates service API and documentation
  * AWS Signer is launching code-signing for AWS Lambda. Now customers can cryptographically sign Lambda code to ensure trust, integrity, and functionality.
* `service/sso-admin`: Updates service API and documentation
* `service/timestream-query`: Updates service API, documentation, and paginators
* `service/translate`: Updates service API, documentation, and paginators

Release v1.35.33 (2020-11-20)
===

### Service Client Updates
* `service/appmesh`: Updates service API
* `service/chime`: Updates service API, documentation, and paginators
  * The Amazon Chime SDK for messaging provides the building blocks needed to build chat and other real-time collaboration features.
* `service/cloudhsmv2`: Updates service API and documentation
  * Added managed backup retention, a feature that enables customers to retain backups for a configurable period after which CloudHSM service will automatically delete them.
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/cognito-identity`: Updates service API and paginators
* `service/connect`: Updates service API, documentation, and paginators
* `service/kafka`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Add new documentation regarding automatically generated Content-MD5 headers when using the SDK or CLI.
* `service/servicecatalog-appregistry`: Updates service API and documentation

Release v1.35.32 (2020-11-19)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * You can now create Auto Scaling groups with multiple launch templates using a mixed instances policy, making it easy to deploy an AMI with an architecture that is different from the rest of the group.
* `service/ce`: Updates service API and documentation
* `service/ds`: Updates service API and documentation
  * Adding multi-region replication feature for AWS Managed Microsoft AD
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * EventBridge now supports Resource-based policy authorization on event buses. This enables cross-account PutEvents API calls, creating cross-account rules, and simplifies permission management.
* `service/glue`: Updates service API, documentation, and paginators
  * Adding support for Glue Schema Registry. The AWS Glue Schema Registry is a new feature that allows you to centrally discover, control, and evolve data stream schemas.
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Added the starting position and starting position timestamp to ESM Configuration. Now customers will be able to view these fields for their ESM.
* `service/lex-models`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * The AWS Elemental MediaLive APIs and SDKs now support the ability to see the software update status on Link devices
* `service/redshift`: Updates service API, documentation, and paginators
  * Amazon Redshift support for returning ClusterNamespaceArn in describeClusters
* `service/runtime.lex`: Updates service API and documentation

Release v1.35.31 (2020-11-18)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/cloudformation`: Updates service API and documentation
  * This release adds ChangeSets support for Nested Stacks. ChangeSets offer a preview of how proposed changes to a stack might impact existing resources or create new ones.
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild - Adding Status field for Report Group
* `service/ec2`: Updates service documentation
  * EC2 Fleet adds support of DeleteFleets API for instant type fleets. Now you can delete an instant type fleet and terminate all associated instances with a single API call.
* `service/elasticache`: Updates service documentation
  * Adding Memcached 1.6 to parameter family
* `service/outposts`: Updates service API
* `service/s3control`: Updates service API and documentation
  * AWS S3 Storage Lens provides visibility into your storage usage and activity trends at the organization or account level, with aggregations by Region, storage class, bucket, and prefix.

### SDK Enhancements
* Update golang.org/x/net dependency [#3638](https://github.com/aws/aws-sdk-go/pull/3638)
  * Updates the SDK's dependency on golang.org/x/net module to update the transitive golang.org/x/text module dependency to the latest version of v0.3.3.
  * Fixes [#3457](https://github.com/aws/aws-sdk-go/issues/3457)

Release v1.35.30 (2020-11-17)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * This release adds CRUD APIs for Amazon Chime SipMediaApplications and SipRules. It also adds the API for creating outbound PSTN calls for Amazon Chime meetings.
* `service/connect`: Updates service API and documentation
* `service/fms`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/network-firewall`: Adds new service
* `service/rds`: Updates service API and documentation
  * Support copy-db-snapshot in the one region on cross clusters and local cluster for RDSonVmware. Add target-custom-availability-zone parameter to specify where a snapshot should be copied.

Release v1.35.29 (2020-11-16)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * We show details about inbound executions and id of action executions in GetPipelineState API. We also add ConflictException to StartPipelineExecution, RetryStageExecution, StopPipelineExecution APIs.
* `service/dms`: Updates service API and documentation
  * Adding MoveReplicationTask feature to move replication tasks between instances
* `service/iotsecuretunneling`: Updates service API and documentation
* `service/iotsitewise`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Adding new parameters for dashboard persistence
* `service/sagemaker`: Updates service API and documentation
  * This feature enables customers to encrypt their Amazon SageMaker Studio storage volumes with customer master keys (CMKs) managed by them in AWS Key Management Service (KMS).
* `service/servicecatalog`: Updates service API and documentation
  * Support import of CloudFormation stacks into Service Catalog provisioned products.
* `service/sns`: Updates service documentation
  * Documentation updates for Amazon SNS.
* `service/synthetics`: Updates service API and documentation

Release v1.35.28 (2020-11-13)
===

### Service Client Updates
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/shield`: Updates service API, documentation, and paginators
  * This release adds APIs for two new features: 1) Allow customers to bundle resources into protection groups and treat as a single unit. 2) Provide per-account event summaries to all AWS customers.
* `service/textract`: Updates service API and documentation

Release v1.35.27 (2020-11-12)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * This release adds a batchMode parameter to the IotEvents, IotAnalytics, and Firehose actions which allows customers to send an array of messages to the corresponding services
* `service/lex-models`: Updates service API
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Amazon Lightsail container services. You can now create a Lightsail container service, and deploy Docker images to it.
* `service/personalize-runtime`: Updates service API and documentation
* `service/polly`: Updates service API and documentation
  * Amazon Polly adds new Australian English female voice - Olivia. Olivia is available as Neural voice only.
* `service/robomaker`: Updates service API and documentation
* `service/servicecatalog-appregistry`: Adds new service

Release v1.35.26 (2020-11-11)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/databrew`: Adds new service
* `service/forecast`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for Automated ABR encoding and improved the reliability of embedded captions in accelerated outputs.
* `service/quicksight`: Updates service API and documentation
  * QuickSight now supports Column-level security and connecting to Oracle data source.
* `service/servicecatalog`: Updates service API and documentation
  * Adding support to remove a Provisioned Product launch role via UpdateProvisionedProductProperties

Release v1.35.25 (2020-11-10)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `service/ec2`: Updates service API and documentation
  * This release adds support for Gateway Load Balancer VPC endpoints and VPC endpoint services
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * Add SessionId as a filter for DescribeSessions API

Release v1.35.24 (2020-11-09)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/dynamodb`: Updates service API, documentation, and paginators
  * This release adds supports for exporting Amazon DynamoDB table data to Amazon S3 to perform analytics at any scale.
* `service/ecs`: Updates service API and documentation
  * This release provides native support for specifying Amazon FSx for Windows File Server file systems as volumes in your Amazon ECS task definitions.
* `service/es`: Updates service API, documentation, and paginators
  * Adding support for package versioning in Amazon Elasticsearch Service
* `service/fsx`: Updates service API, documentation, paginators, and examples
* `service/iotanalytics`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * S3 Intelligent-Tiering adds support for Archive and Deep Archive Access tiers; S3 Replication adds replication metrics and failure notifications, brings feature parity for delete marker replication
* `service/ssm`: Updates service API and documentation
  * add a new filter to allow customer to filter automation executions by using resource-group which used for execute automation
* `service/storagegateway`: Updates service API, documentation, and paginators
  * Added bandwidth rate limit schedule for Tape and Volume Gateways

Release v1.35.23 (2020-11-06)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Network card support with four new attributes: NetworkCardIndex, NetworkPerformance, DefaultNetworkCardIndex, and MaximumNetworkInterfaces, added to the DescribeInstanceTypes API.
* `service/iotsitewise`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * Support for SCTE35 ad markers in OnCuePoint style in RTMP outputs.
* `service/ssm`: Updates service documentation
  * Documentation updates for Systems Manager

Release v1.35.22 (2020-11-05)
===

### Service Client Updates
* `service/appmesh`: Updates service API, documentation, paginators, and examples
* `service/dynamodb`: Updates service API and documentation
  * This release adds a new ReplicaStatus INACCESSIBLE_ENCRYPTION_CREDENTIALS for the Table description, indicating when a key used to encrypt a regional replica table is not accessible.
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2.
* `service/es`: Updates service API and documentation
  * Amazon Elasticsearch Service now provides the ability to define a custom endpoint for your domain and link an SSL certificate from ACM, making it easier to refer to Kibana and the domain endpoint.
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * With this release, customers can now reprocess past events by storing the events published on event bus in an encrypted archive.
* `service/frauddetector`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports providing user context in your query requests, Tokens can be JSON or JWT format. This release also introduces support for Confluence cloud datasources.
* `service/lambda`: Updates service API and documentation
  * Support Amazon MQ as an Event Source.
* `service/rds`: Updates service API and documentation
  * Supports a new parameter to set the max allocated storage in gigabytes for the CreateDBInstanceReadReplica API.

Release v1.35.21 (2020-11-04)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Capacity Rebalance helps you manage and maintain workload availability during Spot interruptions by proactively augmenting your Auto Scaling group with a new instance before interrupting an old one.
* `service/ec2`: Updates service API and documentation
  * Added support for Client Connect Handler for AWS Client VPN. Fleet supports launching replacement instances in response to Capacity Rebalance recommendation.
* `service/es`: Updates service API and documentation
  * Amazon Elasticsearch Service now supports native SAML authentication that seamlessly integrates with the customers' existing SAML 2.0 Identity Provider (IdP).
* `service/iot`: Updates service API, documentation, and paginators
  * Updated API documentation and added paginator for AWS Iot Registry ListThingPrincipals API.
* `service/meteringmarketplace`: Updates service API and documentation
  * Adding Vendor Tagging Support in MeterUsage and BatchMeterUsage API.
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring
* `service/mq`: Updates service API and documentation
  * Amazon MQ introduces support for RabbitMQ, a popular message-broker with native support for AMQP 0.9.1. You can now create fully-managed RabbitMQ brokers in the cloud.
* `service/servicecatalog`: Updates service API and documentation
  * Service Catalog API ListPortfolioAccess can now support a maximum PageSize of 100.
* `service/transcribe-streaming`: Updates service API
* `service/xray`: Updates service API, documentation, and paginators
  * Releasing new APIs GetInsightSummaries, GetInsightEvents, GetInsight, GetInsightImpactGraph and updating GetTimeSeriesServiceStatistics API for AWS X-Ray Insights feature

Release v1.35.20 (2020-11-02)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for the following features: 1. P4d instances based on NVIDIA A100 GPUs.  2. NetworkCardIndex attribute to support multiple network cards.

Release v1.35.19 (2020-10-30)
===

### Service Client Updates
* `service/braket`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * Adding DocDbSettings to support DocumentDB as a source.
* `service/elasticache`: Updates service documentation
  * Documentation updates for AWS ElastiCache
* `service/imagebuilder`: Updates service API and documentation
* `service/macie2`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * Support for HLS discontinuity tags in the child manifests. Support for incomplete segment behavior in the media output. Support for automatic input failover condition settings.
* `service/sns`: Updates service documentation
  * Documentation updates for Amazon SNS

Release v1.35.18 (2020-10-29)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Support disabling the default execute-api endpoint for REST APIs.
* `service/codeartifact`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Support for Appliance mode on Transit Gateway that simplifies deployment of stateful network appliances. Added support for AWS Client VPN Self-Service Portal.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/marketplacecommerceanalytics`: Updates service documentation
  * Documentation updates for marketplacecommerceanalytics to specify four data sets which are deprecated.
* `service/sesv2`: Updates service API, documentation, and paginators
* `service/storagegateway`: Updates service API and documentation
  * Adding support for access based enumeration on SMB file shares, file share visibility on SMB file shares, and file upload notifications for all file shares

Release v1.35.17 (2020-10-28)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * AWS Nitro Enclaves general availability. Added support to RunInstances for creating enclave-enabled EC2 instances. New APIs to associate an ACM certificate with an IAM role, for enclave consumption.
* `service/iot`: Updates service API and documentation
  * This release adds support for GG-Managed Job Namespace
* `service/workmail`: Updates service documentation
  * Documentation update for Amazon WorkMail

Release v1.35.16 (2020-10-27)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * AWS Glue machine learning transforms now support encryption-at-rest for labels and trained models.

Release v1.35.15 (2020-10-26)
===

### Service Client Updates
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports indexing data from Confluence Server.
* `service/neptune`: Updates service API, documentation, and paginators
  * This feature enables custom endpoints for Amazon Neptune clusters. Custom endpoints simplify connection management when clusters contain instances with different capacities and configuration settings.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This release enables customers to bring custom images for use with SageMaker Studio notebooks.

Release v1.35.14 (2020-10-23)
===

### Service Client Updates
* `service/macie2`: Updates service documentation
* `service/mediatailor`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Support description on columns.

Release v1.35.13 (2020-10-22)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service documentation
* `service/appflow`: Updates service API and documentation
* `service/servicecatalog`: Updates service documentation
  * Documentation updates for servicecatalog
* `service/sns`: Updates service API and documentation
  * SNS now supports a new class of topics: FIFO (First-In-First-Out). FIFO topics provide strictly-ordered, deduplicated, filterable, encryptable, many-to-many messaging at scale.

Release v1.35.12 (2020-10-21)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * CloudFront adds support for managing the public keys for signed URLs and signed cookies directly in CloudFront (it no longer requires the AWS root account).
* `service/ec2`: Updates service API and documentation
  * instance-storage-info nvmeSupport added to DescribeInstanceTypes API
* `service/globalaccelerator`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * AWS Glue crawlers now support incremental crawls for the Amazon Simple Storage Service (Amazon S3) data source.
* `service/kendra`: Updates service API and documentation
  * This release adds custom data sources: a new data source type that gives you full control of the documents added, modified or deleted during a data source sync while providing run history metrics.
* `service/organizations`: Updates service documentation
  * AWS Organizations renamed the 'master account' to 'management account'.

### SDK Bugs
* `aws/credentials`: Fixed a race condition checking if credentials are expired. ([#3448](https://github.com/aws/aws-sdk-go/issues/3448))
  * Fixes [#3524](https://github.com/aws/aws-sdk-go/issues/3524)
* `internal/ini`: Fixes ini file parsing for cases when Right Hand Value is missed in the last statement of the ini file ([#3596](https://github.com/aws/aws-sdk-go/pull/3596)) 
  * related to [#2800](https://github.com/aws/aws-sdk-go/issues/2800)

Release v1.35.11 (2020-10-20)
===

### Service Client Updates
* `service/appsync`: Updates service documentation
* `service/batch`: Updates service API and documentation
  * Adding evaluateOnExit to job retry strategies.
* `service/elasticbeanstalk`: Updates service API
  * EnvironmentStatus enum update to include Aborting, LinkingFrom and LinkingTo

Release v1.35.10 (2020-10-19)
===

### Service Client Updates
* `service/backup`: Updates service documentation
* `service/cloudfront`: Updates service API and documentation
  * Amazon CloudFront adds support for Origin Shield.
* `service/docdb`: Updates service documentation
  * Documentation updates for docdb
* `service/servicecatalog`: Updates service API and documentation
  * An Admin can now update the launch role associated with a Provisioned Product. Admins and End Users can now view the launch role associated with a Provisioned Product.
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release now supports Common Vulnerabilities and Exposure (CVE) Ids for missing packages via the DescribeInstancePatches API.

Release v1.35.9 (2020-10-16)
===

### Service Client Updates
* `service/medialive`: Updates service API, documentation, and paginators
  * The AWS Elemental MediaLive APIs and SDKs now support the ability to transfer the ownership of MediaLive Link devices across AWS accounts.
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations.

### SDK Bugs
* `s3control`: Fixes bug in SDK that caused GetAccessPointPolicy, DeleteAccessPointPolicy, and PutAccessPointPolicy operations to not route properly for S3 on Outposts. ([#3599](https://github.com/aws/aws-sdk-go/pull/3599))
  * Fixes [#3598](https://github.com/aws/aws-sdk-go/issues/3598).

Release v1.35.8 (2020-10-15)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/budgets`: Updates service API, documentation, and paginators
  * This release introduces AWS Budgets Actions, allowing you to define an explicit response(or set of responses)  to take when your budget exceeds it's action threshold.
* `service/ce`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * When creating Endpoints, Replication Instances, and Replication Tasks, the feature provides you the option to specify friendly name to the resources.
* `service/glue`: Updates service documentation
  * API Documentation updates for Glue Get-Plan API
* `service/groundstation`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * Add new variable, lastStatusChangeDate, to DescribeDomainConfiguration  API
* `service/macie2`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Return tags for all resources in the output of DescribeDBInstances, DescribeDBSnapshots, DescribeDBClusters, and DescribeDBClusterSnapshots API operations.
* `service/rekognition`: Updates service API and documentation
  * This SDK Release introduces new API (DetectProtectiveEquipment) for Amazon Rekognition. This release also adds ServiceQuotaExceeded exception to Amazon Rekognition IndexFaces API.
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release now supports searching for available packages from Amazon Linux and Amazon Linux 2 via the DescribeAvailablePatches API.
* `service/transfer`: Updates service API and documentation
  * Add support to associate VPC Security Groups at server creation.
* `service/workmail`: Updates service API and documentation
  * Add CreateOrganization and DeleteOrganization API operations.
* `service/workspaces`: Updates service documentation
  * Documentation updates for WorkSpaces
* `service/xray`: Updates service API, documentation, and paginators
  * Enhancing CreateGroup, UpdateGroup, GetGroup and GetGroups APIs to support configuring X-Ray Insights Notifications. Adding TraceLimit information into X-Ray BatchGetTraces API response.

### SDK Bugs
* `s3control`: Fixes bug in SDK that caused input for certain s3control operation to be modified, when using ARNs. ([#3595](https://github.com/aws/aws-sdk-go/pull/3595))
  * Fixes [#3583](https://github.com/aws/aws-sdk-go/issues/3583).

Release v1.35.7 (2020-10-09)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/eks`: Updates service API
* `service/medialive`: Updates service API and documentation
  * WAV audio output. Extracting ancillary captions in MP4 file inputs. Priority on channels feeding a multiplex (higher priority channels will tend to have higher video quality).
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * This new API takes either a ProvisonedProductId or a ProvisionedProductName, along with a list of 1 or more output keys and responds with the (key,value) pairs of those outputs.
* `service/snowball`: Updates service API and documentation
  * We added new APIs to allow customers to better manage their device shipping. You can check if your shipping label expired, generate a new label, and tell us that you received or shipped your job.

Release v1.35.6 (2020-10-08)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * AWS EC2 RevokeSecurityGroupIngress and RevokeSecurityGroupEgress APIs will return IpPermissions which do not match with any existing IpPermissions for security groups in default VPC and EC2-Classic.
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Amazon EventBridge (formerly called CloudWatch Events) adds support for target Dead-letter Queues and custom retry policies.
* `service/rds`: Updates service API and documentation
  * Supports a new parameter to set the max allocated storage in gigabytes for restore database instance from S3 and restore database instance to a point in time APIs.
* `service/rekognition`: Updates service API and documentation
  * This release provides location information for the manifest validation files.
* `service/sagemaker`: Updates service API and documentation
  * This release enables Sagemaker customers to convert Tensorflow and PyTorch models to CoreML (ML Model) format.
* `service/sns`: Updates service documentation
  * Documentation updates for SNS.

Release v1.35.5 (2020-10-07)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/compute-optimizer`: Updates service API and documentation
* `service/elasticache`: Updates service API, documentation, and paginators
  * This release introduces User and UserGroup to allow customers to have access control list of the Redis resources for AWS ElastiCache. This release also adds support for Outposts  for AWS ElastiCache.
* `service/mediapackage`: Updates service API and documentation
  * AWS Elemental MediaPackage provides access logs that capture detailed information about requests sent to a customer's MediaPackage channel.

### SDK Bugs
* `aws/credentials`: Monotonic clock readings will now be cleared when setting credential expiry time. ([#3573](https://github.com/aws/aws-sdk-go/pull/3573))
  * Prevents potential issues when the host system is hibernated / slept and the monotonic clock readings don't match the wall-clock time.

Release v1.35.4 (2020-10-06)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Added new S3 endpoint settings to allow partitioning CDC data by date for S3 as target. Exposed some Extra Connection Attributes as endpoint settings for relational databases as target.
* `service/ec2`: Updates service API and documentation
  * This release supports returning additional information about local gateway virtual interfaces, and virtual interface groups.
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation

Release v1.35.3 (2020-10-05)
===

### Service Client Updates
* `service/dynamodb`: Updates service API and documentation
  * This release adds a new ReplicaStatus REGION DISABLED for the Table description. This state indicates that the AWS Region for the replica is inaccessible because the AWS Region is disabled.
* `service/glue`: Updates service API and documentation
  * AWS Glue crawlers now support Amazon DocumentDB (with MongoDB compatibility) and MongoDB collections. You can choose to crawl the entire data set or only a small sample to reduce crawl time.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for AVC-I and VC3 encoding in the MXF OP1a container, Nielsen non-linear watermarking, and InSync FrameFormer frame rate conversion.
* `service/sagemaker`: Updates service API and documentation
  * This release adds support for launching Amazon SageMaker Studio in your VPC. Use AppNetworkAccessType in CreateDomain API to disable access to public internet and restrict the network traffic to VPC.
* `service/streams.dynamodb`: Updates service documentation

Release v1.35.2 (2020-10-02)
===

### Service Client Updates
* `service/batch`: Updates service API, documentation, and examples
  * Support tagging for Batch resources (compute environment, job queue, job definition and job) and tag based access control on Batch APIs
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/personalize-events`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Adds the NCHAR Character Set ID parameter to the CreateDbInstance API for RDS Oracle.
* `service/s3`: Updates service API and documentation
  * Amazon S3 Object Ownership is a new S3 feature that enables bucket owners to automatically assume ownership of objects that are uploaded to their buckets by other AWS Accounts.
* `service/servicediscovery`: Updates service API and documentation

Release v1.35.1 (2020-10-01)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service documentation
  * Documentation updates for elasticmapreduce
* `service/glue`: Updates service API and documentation
  * Adding additional optional map parameter to get-plan api
* `service/kafka`: Updates service API and documentation
* `service/quicksight`: Updates service API
  * QuickSight now supports connecting to AWS Timestream data source
* `service/wafv2`: Updates service API and documentation

Release v1.35.0 (2020-09-30)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/directconnect`: Updates service documentation
  * Documentation updates for AWS Direct Connect.
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR customers can now use EC2 placement group to influence the placement of master nodes in a high-availability (HA) cluster across distinct underlying hardware to improve cluster availability.
* `service/imagebuilder`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * AWS IoT Rules Engine adds Timestream action. The Timestream rule action lets you stream time-series data from IoT sensors and applications to Amazon Timestream databases for time series analysis.
* `service/mediaconnect`: Updates service API, documentation, and paginators
* `service/pinpoint`: Updates service API and documentation
  * Amazon Pinpoint - Features - Customers can start a journey based on an event being triggered by an endpoint or user.
* `service/s3`: Updates service API, documentation, and examples
  * Amazon S3 on Outposts expands object storage to on-premises AWS Outposts environments, enabling you to store and retrieve objects using S3 APIs and features.
* `service/s3outposts`: Adds new service
* `service/securityhub`: Updates service API and documentation

### SDK Features
* `service/s3`: Adds support for outposts access point ARNs.
* `service/s3control`: Adds support for S3 on outposts access point and S3 on outposts bucket ARNs.

Release v1.34.34 (2020-09-29)
===

### Service Client Updates
* `service/connect`: Updates service documentation
* `service/ec2`: Updates service documentation
  * This release adds support for Client to Client routing for AWS Client VPN.
* `service/schemas`: Updates service API and documentation
* `service/ssm`: Updates service documentation
  * Simple update to description of ComplianceItemStatus.
* `service/timestream-query`: Adds new service
* `service/timestream-write`: Adds new service

Release v1.34.33 (2020-09-28)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * This release adds the InsufficientAvailableIPsInSubnetFault error for RDS Proxy.

Release v1.34.32 (2020-09-25)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Support custom logging, executionRole, secrets, and linuxParameters (initProcessEnabled, maxSwap, swappiness, sharedMemorySize, and tmpfs). Also, add new context keys for awslogs.
* `service/config`: Updates service API
* `service/docdb`: Updates service documentation
  * Documentation updates for docdb
* `service/ec2`: Updates service API and documentation
  * This release supports returning additional information about local gateway resources, such as the local gateway route table.
* `service/frauddetector`: Updates service API and documentation
* `service/sts`: Updates service API and documentation
  * Documentation update for AssumeRole error

Release v1.34.31 (2020-09-24)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/eks`: Updates service API and documentation
* `service/savingsplans`: Updates service API and documentation
* `service/synthetics`: Updates service API and documentation
* `service/textract`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

Release v1.34.30 (2020-09-23)
===

### Service Client Updates
* `service/backup`: Updates service API and documentation
* `service/ce`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Added Sheet information to DescribeDashboard, DescribeTemplate and DescribeAnalysis API response.
* `service/translate`: Updates service API and documentation

### SDK Enhancements
* `service/s3/s3manager`:  Prefer using allocated slices from pool over allocating new ones. ([#3534](https://github.com/aws/aws-sdk-go/pull/3534))

Release v1.34.29 (2020-09-22)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/lex-models`: Updates service API and documentation
* `service/streams.dynamodb`: Updates service API and documentation
* `service/workmail`: Updates service API, documentation, and paginators
  * Adding support for Mailbox Export APIs

Release v1.34.28 (2020-09-21)
===

### Service Client Updates
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Add support for Redshift Data API Targets
* `service/glue`: Updates service API and documentation
  * Adding support to update multiple partitions of a table in a single request
* `service/iotsitewise`: Updates service API and documentation
* `service/rds`: Updates service documentation
  * Documentation updates for the RDS DescribeExportTasks API
* `service/resource-groups`: Updates service documentation and paginators
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates for the Resource Groups Tagging API.

Release v1.34.27 (2020-09-18)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports batch operations, which allow users to start, stop, and delete multiple MediaLive resources with a single request.
* `service/sso-admin`: Updates service documentation

Release v1.34.26 (2020-09-17)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Adds support for mutual TLS authentication for public regional REST Apis
* `service/apigatewayv2`: Updates service API and documentation
  * Adds support for mutual TLS authentication and disableAPIExecuteEndpoint for public regional HTTP Apis
* `service/cloudfront`: Updates service documentation
  * Documentation updates for CloudFront
* `service/comprehend`: Updates service API and documentation
* `service/es`: Updates service API and documentation
  * Adds support for data plane audit logging in Amazon Elasticsearch Service.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports additional file formats and metadata for FAQs.
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.34.25 (2020-09-16)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/dlm`: Updates service API and documentation
* `service/greengrass`: Updates service API and documentation
  * This release includes the ability to set run-time configuration for a Greengrass core. The Telemetry feature, also included in this release, can be configured via run-time configuration per core.
* `service/servicecatalog`: Updates service API and documentation
  * Enhance DescribeProvisionedProduct API to allow useProvisionedProduct Name as Input, so customer can provide ProvisionedProduct Name instead of ProvisionedProduct Id to describe a ProvisionedProduct.
* `service/ssm`: Updates service documentation
  * The ComplianceItemEntry Status description was updated to address Windows patches that aren't applicable.

Release v1.34.24 (2020-09-15)
===

### Service Client Updates
* `service/budgets`: Updates service API, documentation, and paginators
  * Documentation updates for Daily Cost and Usage budgets
* `service/ec2`: Updates service API
  * T4g instances are powered by AWS Graviton2 processors
* `service/kafka`: Updates service API, documentation, and paginators
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now returns confidence scores for 'document' query responses.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports CDI (Cloud Digital Interface) inputs which enable uncompressed video from applications on Elastic Cloud Compute (EC2), AWS Media Services, and from AWS partners
* `service/organizations`: Updates service API and documentation
  * AWS Organizations now enables you to add tags to the AWS accounts, organizational units, organization root, and policies in your organization.
* `service/sagemaker`: Updates service API and documentation
  * Sagemaker Ground Truth: Added support for a new Streaming feature which helps to continuously feed data and receive labels in real time. This release adds a new input and output SNS data channel.
* `service/transcribe`: Updates service API and documentation

Release v1.34.23 (2020-09-14)
===

### Service Client Updates
* `service/docdb`: Updates service API, documentation, and paginators
  * Updated API documentation and added paginators for DescribeCertificates, DescribeDBClusterParameterGroups, DescribeDBClusterParameters, DescribeDBClusterSnapshots and DescribePendingMaintenanceActions
* `service/ec2`: Updates service API
  * This release adds support for the T4G instance family to the EC2 ModifyDefaultCreditSpecification and GetDefaultCreditSpecification APIs.
* `service/managedblockchain`: Updates service API and documentation
* `service/states`: Updates service API and documentation
  * This release of the AWS Step Functions SDK introduces support for AWS X-Ray.

Release v1.34.22 (2020-09-11)
===

### Service Client Updates
* `service/workspaces`: Updates service API and documentation
  * Adds API support for WorkSpaces Cross-Region Redirection feature.

Release v1.34.21 (2020-09-10)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Cloudfront adds support for Brotli. You can enable brotli caching and compression support by enabling it in your Cache Policy.
* `service/ebs`: Updates service documentation
* `service/pinpoint`: Updates service documentation
  * Update SMS message model description to clearly indicate that the MediaUrl field is reserved for future use and is not supported by Pinpoint as of today.
* `service/s3`: Updates service API, documentation, and examples
  * Bucket owner verification feature added. This feature introduces the x-amz-expected-bucket-owner and x-amz-source-expected-bucket-owner headers.
* `service/sso-admin`: Adds new service

Release v1.34.20 (2020-09-09)
===

### Service Client Updates
* `service/glue`: Updates service API, documentation, and paginators
  * Adding support for partitionIndexes to improve GetPartitions performance.
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/redshift-data`: Adds new service

Release v1.34.19 (2020-09-08)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * You can now secure HTTP APIs using Lambda authorizers and IAM authorizers. These options enable you to make flexible auth decisions using a Lambda function, or using IAM policies, respectively.
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild - Support keyword search for test cases in DecribeTestCases API . Allow deletion of reports in the report group, before deletion of report group using the deleteReports flag.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/lex-models`: Updates service API and documentation
* `service/quicksight`: Updates service API and documentation
  * Adds tagging support for QuickSight customization resources.  A user can now specify a list of tags when creating a customization resource and use a customization ARN in QuickSight's tagging APIs.

Release v1.34.18 (2020-09-04)
===

### Service Client Updates
* `service/ssm`: Updates service documentation
  * Documentation-only updates for AWS Systems Manager
* `service/workspaces`: Updates service API and documentation
  * Adding support for Microsoft Office 2016 and Microsoft Office 2019 in BYOL Images
* `service/xray`: Updates service API and documentation
  * Enhancing CreateGroup, UpdateGroup, GetGroup and GetGroups APIs to support configuring X-Ray Insights

Release v1.34.17 (2020-09-03)
===

### Service Client Updates
* `service/guardduty`: Updates service API and documentation
  * GuardDuty findings triggered by failed events now include the error code name within the AwsApiCallAction section.
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now returns confidence scores for both 'answer' and 'question and answer' query responses.
* `service/mediapackage`: Updates service API and documentation
  * Enables inserting a UTCTiming XML tag in the output manifest of a DASH endpoint which a media player will use to help with time synchronization.
* `service/states`: Updates service API and documentation
  * This release of the AWS Step Functions SDK introduces support for payloads up to 256KB for Standard and Express workflows

Release v1.34.16 (2020-09-02)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds a new transit gateway attachment state and resource type.
* `service/macie2`: Updates service API and documentation

Release v1.34.15 (2020-09-01)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.34.14 (2020-08-31)
===

### Service Client Updates
* `service/backup`: Updates service documentation
* `service/cloudfront`: Updates service API and documentation
  * CloudFront now supports real-time logging for CloudFront distributions. CloudFront real-time logs are more detailed, configurable, and are available in real time.
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 and Spot Fleet now support modification of launch template configs for a running fleet enabling instance type, instance weight, AZ, and AMI updates without losing the current fleet ID.
* `service/sqs`: Updates service documentation
  * Documentation updates for SQS.

### SDK Bugs
* `aws/ec2metadata`: Add support for EC2 IMDS endpoint from environment variable ([#3504](https://github.com/aws/aws-sdk-go/pull/3504))
  * Adds support for specifying a custom EC2 IMDS endpoint from the environment variable, `AWS_EC2_METADATA_SERVICE_ENDPOINT`.
  * The `aws/session#Options` struct also has a new field, `EC2IMDSEndpoint`. This field can be used to configure the custom endpoint of the EC2 IMDS client. The option only applies to EC2 IMDS clients created after the Session with `EC2IMDSEndpoint` is specified.

Release v1.34.13 (2020-08-28)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * You can now manage CloudFront's additional, real-time metrics with the CloudFront API.
* `service/cur`: Updates service API and documentation
  * This release add MONTHLY as the new supported TimeUnit for ReportDefinition.
* `service/elasticmapreduce`: Updates service API, documentation, and paginators
  * Amazon EMR adds support for ICMP, port -1, in Block Public Access Exceptions and API access for EMR Notebooks execution. You can now non-interactively execute EMR Notebooks and pass input parameters.
* `service/route53`: Updates service documentation
  * Documentation updates for Route 53

### SDK Bugs
*  `private/protocol`: Limit iso8601 fractional second precision to milliseconds ([#3507](https://github.com/aws/aws-sdk-go/pull/3507))
  * Fixes [#3498](https://github.com/aws/aws-sdk-go/issues/3498)

Release v1.34.12 (2020-08-27)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Introduces support to initiate Internet Key Exchange (IKE) negotiations for VPN connections from AWS. A user can now send the initial IKE message to their Customer Gateway (CGW) from VPN endpoints.
* `service/gamelift`: Updates service API, documentation, and paginators
  * GameLift FleetIQ as a standalone feature is now generally available. FleetIQ makes low-cost Spot instances viable for game hosting. Use GameLift FleetIQ with your EC2 Auto Scaling groups.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for WebM DASH outputs as well as H.264 4:2:2 10-bit output in MOV and MP4.
* `service/redshift`: Updates service documentation
  * Documentation updates for Amazon Redshift.

Release v1.34.11 (2020-08-26)
===

### Service Client Updates
* `service/appflow`: Adds new service
* `service/route53resolver`: Updates service API, documentation, and paginators

Release v1.34.10 (2020-08-24)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Added new endpoint settings to include columns with Null and Empty value when using Kinesis and Kafka as target. Added a new endpoint setting to set maximum message size when using Kafka as target.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release enables customers to use VPC prefix lists in their transit gateway route tables, and it adds support for Provisioned IOPS SSD (io2) EBS volumes.
* `service/iotsitewise`: Updates service API and documentation
* `service/kafka`: Updates service API and documentation
* `service/logs`: Updates service documentation
  * Documentation updates for CloudWatch Logs
* `service/ssm`: Updates service API and documentation
  * Add string length constraints to OpsDataAttributeName and OpsFilterValue.
* `service/xray`: Updates service API and documentation
  * AWS X-Ray now supports tagging on sampling rules and groups.

Release v1.34.9 (2020-08-20)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * Customers can now create Amazon API Gateway HTTP APIs that route requests to AWS AppConfig, Amazon EventBridge, Amazon Kinesis Data Streams, Amazon SQS, and AWS Step Functions.
* `service/chime`: Updates service documentation
  * Documentation updates for chime
* `service/fsx`: Updates service documentation

### SDK Enhancements
* `private/protocol`: The SDK now supports the serialization of ISO8601 date-time formats with fractional seconds precision. ([#3489](https://github.com/aws/aws-sdk-go/pull/3489))

Release v1.34.8 (2020-08-19)
===

### Service Client Updates
* `service/ivs`: Updates service API, documentation, and paginators
* `service/lakeformation`: Updates service API and documentation
* `service/organizations`: Updates service documentation
  * Minor documentation updates for AWS Organizations
* `service/servicecatalog`: Updates service API and documentation
  * Enhance SearchProvisionedProducts API to allow queries using productName and provisioningArtifactName. Added lastProvisioningRecordId and lastSuccessfulRecordId to Read ProvisionedProduct APIs
* `service/storagegateway`: Updates service API and documentation
  * Added WORM, tape retention lock, and custom pool features for virtual tapes.
* `service/transcribe-streaming`: Updates service API and documentation

Release v1.34.7 (2020-08-18)
===

### Service Client Updates
* `service/codebuild`: Updates service documentation
  * Documentation updates for codebuild
* `service/cognito-idp`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/identitystore`: Adds new service
* `service/securityhub`: Updates service API and documentation
* `service/sesv2`: Updates service API, documentation, and paginators

Release v1.34.6 (2020-08-17)
===

### Service Client Updates
* `service/acm`: Updates service API
  * ACM provides support for the new Private CA feature Cross-account CA sharing. ACM users can issue certificates signed by a private CA belonging to another account where the CA was shared with them.
* `service/acm-pca`: Updates service API and documentation
* `service/ecr`: Updates service API and documentation
  * This feature adds support for pushing and pulling Open Container Initiative (OCI) artifacts.
* `service/elasticloadbalancing`: Updates service documentation
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/kinesis`: Updates service API and documentation
  * Introducing ShardFilter for ListShards API to filter the shards using a position in the stream, and ChildShards support for GetRecords and SubscribeToShard API to discover children shards on shard end
* `service/quicksight`: Updates service API, documentation, and paginators
  * Amazon QuickSight now supports programmatic creation and management of analyses with new APIs.
* `service/robomaker`: Updates service API, documentation, and paginators

Release v1.34.5 (2020-08-14)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Adds support for the Desktop View feature
* `service/braket`: Updates service API
* `service/ec2`: Updates service API
  * New C5ad instances featuring AMD's 2nd Generation EPYC processors, offering up to 96 vCPUs, 192 GiB of instance memory, 3.8 TB of NVMe based SSD instance storage, and 20 Gbps in Network bandwidth
* `service/license-manager`: Updates service documentation
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports 1) creating real-time inference endpoints using model container images from Docker registries in customers' VPC 2) AUC(Area under the curve) as AutoPilot objective metric

Release v1.34.4 (2020-08-13)
===

### Service Client Updates
* `service/appsync`: Updates service documentation
* `service/braket`: Adds new service
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Added MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool to ModifySubnetAttribute to allow CoIP auto assign. Fields are returned in DescribeSubnets and DescribeNetworkInterfaces responses.
* `service/eks`: Updates service API and documentation
* `service/macie2`: Updates service documentation
* `service/rds`: Updates service API and documentation
  * This release allows customers to specify a replica mode when creating or modifying a Read Replica, for DB engines which support this feature.

Release v1.34.3 (2020-08-12)
===

### Service Client Updates
* `service/cloud9`: Updates service API and documentation
  * Add ConnectionType input parameter to CreateEnvironmentEC2 endpoint. New parameter enables creation of environments with SSM connection.
* `service/comprehend`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * Introduces support for IPv6-in-IPv4 IPsec tunnels. A user can now send traffic from their on-premise IPv6 network to AWS VPCs that have IPv6 support enabled.
* `service/fsx`: Updates service API and documentation
* `service/iot`: Updates service API, documentation, and paginators
  * Audit finding suppressions: Device Defender enables customers to turn off non-compliant findings for specific resources on a per check basis.
* `service/lambda`: Updates service API and examples
  * Support for creating Lambda Functions using 'java8.al2' and 'provided.al2'
* `service/transfer`: Updates service API, documentation, and paginators
  * Adds security policies to control cryptographic algorithms advertised by your server, additional characters in usernames and length increase, and FIPS compliant endpoints in the US and Canada regions.
* `service/workspaces`: Updates service API and documentation
  * Adds optional EnableWorkDocs property to WorkspaceCreationProperties in the ModifyWorkspaceCreationProperties API

### SDK Enhancements
* `codegen`: Add XXX_Values functions for getting slice of API enums by type.
  * Fixes [#3441](https://github.com/aws/aws-sdk-go/issues/3441) by adding a new XXX_Values function for each API enum type that returns a slice of enum values, e.g `DomainStatus_Values`.
* `aws/request`: Update default retry to retry "use of closed network connection" errors ([#3476](https://github.com/aws/aws-sdk-go/pull/3476))
  * Fixes [#3406](https://github.com/aws/aws-sdk-go/issues/3406)

### SDK Bugs
* `private/protocol/json/jsonutil`: Fixes a bug that truncated millisecond precision time in API response to seconds. ([#3474](https://github.com/aws/aws-sdk-go/pull/3474))
  * Fixes [#3464](https://github.com/aws/aws-sdk-go/issues/3464)
  * Fixes [#3410](https://github.com/aws/aws-sdk-go/issues/3410)
* `codegen`: Export event stream constructor for easier mocking ([#3473](https://github.com/aws/aws-sdk-go/pull/3473))
  * Fixes [#3412](https://github.com/aws/aws-sdk-go/issues/3412) by exporting the operation's EventStream type's constructor function so it can be used to fully initialize fully when mocking out behavior for API operations with event streams.
* `service/ec2`: Fix max retries with client customizations ([#3465](https://github.com/aws/aws-sdk-go/pull/3465))
  * Fixes [#3374](https://github.com/aws/aws-sdk-go/issues/3374) by correcting the EC2 API client's customization for ModifyNetworkInterfaceAttribute and AssignPrivateIpAddresses operations to use the aws.Config.MaxRetries value if set. Previously the API client's customizations would ignore MaxRetries specified in the SDK's aws.Config.MaxRetries field.

Release v1.34.2 (2020-08-11)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release rolls back the EC2 On-Demand Capacity Reservations (ODCRs) release 1.11.831 published on 2020-07-30, which was deployed in error.
* `service/lambda`: Updates service API, documentation, and examples
  * Support Managed Streaming for Kafka as an Event Source. Support retry until record expiration for Kinesis and Dynamodb streams event source mappings.
* `service/organizations`: Updates service documentation
  * Minor documentation update for AWS Organizations
* `service/s3`: Updates service API, documentation, and examples
  * Add support for in-region CopyObject and UploadPartCopy through S3 Access Points

Release v1.34.1 (2020-08-10)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Remove CoIP Auto-Assign feature references.
* `service/glue`: Updates service API and documentation
  * Starting today, you can further control orchestration of your ETL workloads in AWS Glue by specifying the maximum number of concurrent runs for a Glue workflow.
* `service/savingsplans`: Updates service API

### SDK Enhancements
* `aws/credentials/stscreds`: Add optional expiry duration to WebIdentityRoleProvider ([#3356](https://github.com/aws/aws-sdk-go/pull/3356))
  * Adds a new optional field to the WebIdentityRoleProvider that allows you to specify the duration the assumed role credentials will be valid for.
* `example/service/s3/putObjectWithProgress`: Fix example for file upload with progress ([#3377](https://github.com/aws/aws-sdk-go/pull/3377))
  * Fixes [#2468](https://github.com/aws/aws-sdk-go/issues/2468) by ignoring the first read of the progress reader wrapper. Since the first read is used for signing the request, not upload progress.
  * Updated the example to write progress inline instead of newlines.
* `service/dynamodb/dynamodbattribute`: Fix typo in package docs ([#3446](https://github.com/aws/aws-sdk-go/pull/3446))
  * Fixes typo in dynamodbattribute package docs.

Release v1.34.0 (2020-08-07)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * AWS Glue now adds support for Network connection type enabling you to access resources inside your VPC using Glue crawlers and Glue ETL jobs.
* `service/organizations`: Updates service API and documentation
  * Documentation updates for some new error reasons.
* `service/s3`: Updates service documentation and examples
  * Updates Amazon S3 API reference documentation.
* `service/sms`: Updates service API and documentation
  * In this release, AWS Server Migration Service (SMS) has added new features: 1. APIs to work with application and instance level validation 2. Import application catalog from AWS Application Discovery Service 3. For an application you can start on-demand replication

### SDK Features
* `service/s3/s3crypto`: Updates to the Amazon S3 Encryption Client - This change includes fixes for issues that were reported by Sophie Schmieg from the Google ISE team, and for issues that were discovered by AWS Cryptography.

Release v1.33.21 (2020-08-06)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * This release supports Wavelength resources, including carrier gateways, and carrier IP addresses.
* `service/lex-models`: Updates service API and documentation
* `service/personalize`: Updates service API and documentation
* `service/personalize-events`: Updates service API and documentation
* `service/personalize-runtime`: Updates service API and documentation
* `service/runtime.lex`: Updates service API and documentation

Release v1.33.20 (2020-08-05)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/fsx`: Updates service documentation
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates for the Resource Group Tagging API namespace.
* `service/sns`: Updates service documentation
  * Documentation updates for SNS.
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.33.19 (2020-08-04)
===

### Service Client Updates
* `service/health`: Updates service documentation
  * Documentation updates for health

Release v1.33.18 (2020-08-03)
===

### Service Client Updates
* `service/ssm`: Updates service waiters and paginators
  * Adds a waiter for CommandExecuted and paginators for various other APIs.

Release v1.33.17 (2020-07-31)
===

### Service Client Updates
* `service/chime`: Updates service API
  * This release increases the CreateMeetingWithAttendee max attendee limit to 10.
* `service/personalize-runtime`: Updates service API and documentation
* `service/resourcegroupstaggingapi`: Updates service API and documentation
  * Updates to the list of services supported by this API.
* `service/storagegateway`: Updates service API and documentation
  * Add support for gateway VM deprecation dates
* `service/wafv2`: Updates service API and documentation

Release v1.33.16 (2020-07-30)
===

### Service Client Updates
* `service/cloudfront`: Updates service documentation
  * Documentation updates for CloudFront
* `service/codebuild`: Updates service API, documentation, and paginators
  * Adding support for BuildBatch, and CodeCoverage APIs. BuildBatch allows you to model your project environment in source, and helps start multiple builds with a single API call. CodeCoverage allows you to track your code coverage using AWS CodeBuild.
* `service/ec2`: Updates service API
  * EC2 On-Demand Capacity Reservations now adds support to bring your own licenses (BYOL) of Windows operating system to launch EC2 instances.
* `service/guardduty`: Updates service API, documentation, and paginators
  * GuardDuty can now provide detailed cost metrics broken down by account, data source, and S3 resources, based on the past 30 days of usage.  This new feature also supports viewing cost metrics for all member accounts as a GuardDuty master.
* `service/kafka`: Updates service API and documentation
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations
* `service/resource-groups`: Updates service documentation
* `service/servicecatalog`: Updates service API and documentation
  * This release adds support for ProvisionProduct, UpdateProvisionedProduct & DescribeProvisioningParameters by product name, provisioning artifact name and path name. In addition DescribeProvisioningParameters now returns a list of provisioning artifact outputs.
* `service/sesv2`: Updates service API, documentation, and paginators

Release v1.33.15 (2020-07-29)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * Adding support to target EC2 On-Demand Capacity Reservations within an AWS Resource Group to launch EC2 instances.
* `service/ecr`: Updates service API and documentation
  * This release adds support for encrypting the contents of your Amazon ECR repository with customer master keys (CMKs) stored in AWS Key Management Service.
* `service/firehose`: Updates service API and documentation
  * This release includes a new Kinesis Data Firehose feature that supports data delivery to Https endpoint and to partners. You can now use Kinesis Data Firehose to ingest real-time data and deliver to Https endpoint and partners in a serverless, reliable, and salable manner.
* `service/guardduty`: Updates service API and documentation
  * GuardDuty now supports S3 Data Events as a configurable data source type. This feature expands GuardDuty's monitoring scope to include S3 data plane operations, such as GetObject and PutObject. This data source is optional and can be enabled or disabled at anytime. Accounts already using GuardDuty must first enable the new feature to use it; new accounts will be enabled by default. GuardDuty masters can configure this data source for individual member accounts and GuardDuty masters associated through AWS Organizations can automatically enable the data source in member accounts.
* `service/resource-groups`: Updates service API and documentation
* `service/servicediscovery`: Updates service documentation

Release v1.33.14 (2020-07-28)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Now you can enable Instance Metadata Service Version 2 (IMDSv2) or disable the instance metadata endpoint with Launch Configurations.
* `service/ec2`: Updates service API and documentation
  * Introduces support for tag-on-create capability for the following APIs: CreateVpnConnection, CreateVpnGateway, and CreateCustomerGateway. A user can now add tags while creating these resources. For further detail, please see AWS Tagging Strategies.
* `service/imagebuilder`: Updates service API and documentation
* `service/ivs`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports several new features: EBU-TT-D captions in Microsoft Smooth outputs; interlaced video in HEVC outputs; video noise reduction (using temporal filtering) in HEVC outputs.
* `service/rds`: Updates service documentation
  * Adds reporting of manual cluster snapshot quota to DescribeAccountAttributes API
* `service/securityhub`: Updates service API and documentation

Release v1.33.13 (2020-07-27)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/dms`: Updates service API, documentation, and paginators
  * Basic endpoint settings for relational databases, Preflight validation API.
* `service/ec2`: Updates service API
  * m6gd, c6gd, r6gd instances are powered by AWS Graviton2 processors and support local NVMe instance storage
* `service/frauddetector`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Add ability to manually resume workflows in AWS Glue providing customers further control over the orchestration of ETL workloads.
* `service/ssm`: Updates service documentation
  * Assorted doc ticket-fix updates for Systems Manager.

Release v1.33.12 (2020-07-24)
===

### Service Client Updates
* `service/frauddetector`: Updates service API and documentation
* `service/fsx`: Updates service documentation
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra now supports sorting query results based on document attributes. Amazon Kendra also introduced an option to enclose table and column names with double quotes for database data sources.
* `service/macie2`: Updates service API and documentation
* `service/mediaconnect`: Updates service API and documentation
* `service/mediapackage`: Updates service API and documentation
  * The release adds daterange as a new ad marker option. This option enables MediaPackage to insert EXT-X-DATERANGE tags in HLS and CMAF manifests. The EXT-X-DATERANGE tag is used to signal ad and program transition events.
* `service/monitoring`: Updates service API and documentation
  * AWS CloudWatch ListMetrics now supports an optional parameter (RecentlyActive) to filter results by only metrics that have received new datapoints in the past 3 hours. This enables more targeted metric data retrieval through the Get APIs
* `service/mq`: Updates service API, documentation, and paginators
  * Amazon MQ now supports LDAP (Lightweight Directory Access Protocol), providing authentication and authorization of Amazon MQ users via a customer designated LDAP server.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * Sagemaker Ground Truth:Added support for OIDC (OpenID Connect) to authenticate workers via their own identity provider instead of through Amazon Cognito. This release adds new APIs (CreateWorkforce, DeleteWorkforce, and ListWorkforces) to SageMaker Ground Truth service.  Sagemaker Neo: Added support for detailed target device description by using TargetPlatform fields - OS, architecture, and accelerator. Added support for additional compilation parameters by using JSON field CompilerOptions.  Sagemaker Search: SageMaker Search supports transform job details in trial components.

### SDK Bugs
* `service/s3/s3crypto`: Fix client's temporary file buffer error on retry ([#3344](https://github.com/aws/aws-sdk-go/pull/3344))
  * Fixes the Crypto client's temporary file buffer cleanup returning an error when the request is retried.

Release v1.33.11 (2020-07-23)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/directconnect`: Updates service documentation
  * Documentation updates for AWS Direct Connect
* `service/fsx`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Added new ConnectionProperties: "KAFKA_SSL_ENABLED" (to toggle SSL connections) and "KAFKA_CUSTOM_CERT" (import CA certificate file)
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Amazon Lightsail content delivery network (CDN) distributions and SSL/TLS certificates.
* `service/workspaces`: Updates service API and documentation
  * Added UpdateWorkspaceImagePermission API to share Amazon WorkSpaces images across AWS accounts.

Release v1.33.10 (2020-07-22)
===

### Service Client Updates
* `service/medialive`: Updates service API and documentation
  * The AWS Elemental MediaLive APIs and SDKs now support the ability to get thumbnails for MediaLive devices that are attached or not attached to a channel. Previously, this thumbnail feature was available only on the console.
* `service/quicksight`: Updates service API, documentation, and paginators
  * New API operations - GetSessionEmbedUrl, CreateNamespace, DescribeNamespace, ListNamespaces, DeleteNamespace, DescribeAccountSettings, UpdateAccountSettings, CreateAccountCustomization, DescribeAccountCustomization, UpdateAccountCustomization, DeleteAccountCustomization. Modified API operations to support custom permissions restrictions - RegisterUser, UpdateUser, UpdateDashboardPermissions

### SDK Enhancements
* `example/aws/request/httptrace`: Update example with more metrics ([#3436](https://github.com/aws/aws-sdk-go/pull/3436))
  * Updates the tracing example to include additional metrics such as SDKs request handlers, and support multiple request attempts.

Release v1.33.9 (2020-07-21)
===

### Service Client Updates
* `service/codeguruprofiler`: Updates service API and documentation

Release v1.33.8 (2020-07-20)
===

### Service Client Updates
* `service/cloudfront`: Adds new service
  * CloudFront adds support for cache policies and origin request policies. With these new policies, you can now more granularly control the query string, header, and cookie values that are included in the cache key and in requests that CloudFront sends to your origin.
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild adds support for Session Manager and Windows 2019 Environment type
* `service/ec2`: Updates service API and documentation
  * Added support for tag-on-create for CreateVpcPeeringConnection and CreateRouteTable. You can now specify tags when creating any of these resources. For more information about tagging, see AWS Tagging Strategies. Add poolArn to the response of DescribeCoipPools.
* `service/fms`: Updates service API and documentation
* `service/frauddetector`: Updates service API, documentation, and paginators
* `service/groundstation`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Add a new SupportsParallelQuery output field to DescribeDBEngineVersions. This field shows whether the engine version supports parallelquery. Add a new SupportsGlobalDatabases output field to DescribeDBEngineVersions and DescribeOrderableDBInstanceOptions. This field shows whether global database is supported by engine version or the combination of engine version and instance class.

Release v1.33.7 (2020-07-17)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/appsync`: Updates service documentation
* `service/connect`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2
* `service/elasticbeanstalk`: Updates service waiters and paginators
  * Add waiters for `EnvironmentExists`, `EnvironmentUpdated`, and `EnvironmentTerminated`. Add paginators for `DescribeEnvironmentManagedActionHistory` and `ListPlatformVersions`.
* `service/macie2`: Updates service API, documentation, and paginators

### SDK Enhancements
* `service/s3/s3manager`: Clarify documentation and behavior of GetBucketRegion ([#3428](https://github.com/aws/aws-sdk-go/pull/3428))
  * Updates the documentation for GetBucketRegion's behavior with regard to default configuration for path style addressing. Provides examples how to override this behavior.
  * Updates the GetBucketRegion utility to not require a region hint when the session or client was configured with a custom endpoint URL.
  * Related to [#3115](https://github.com/aws/aws-sdk-go/issues/3115)
* `service/s3`: Add failsafe handling for unknown stream messages
  * Adds failsafe handling for receiving unknown stream messages from an API. A `<streamName>UnknownEvent` type will encapsulate the unknown message received from the API. Where `<streamName>` is the name of the API's stream, (e.g. S3's `SelectObjectContentEventStreamUnknownEvent`).

Release v1.33.6 (2020-07-15)
===

### Service Client Updates
* `service/ivs`: Adds new service

### SDK Enhancements
* `service/s3/s3crypto`: Allow envelope unmarshal to accept JSON numbers for tag length [(#3422)](https://github.com/aws/aws-sdk-go/pull/3422)

Release v1.33.5 (2020-07-09)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/amplify`: Updates service documentation
* `service/appmesh`: Updates service API, documentation, and paginators
* `service/cloudhsmv2`: Updates service documentation
  * Documentation updates for cloudhsmv2
* `service/comprehend`: Updates service API and documentation
* `service/ebs`: Updates service API and documentation
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Amazon CloudWatch Events/EventBridge adds support for API Gateway as a target.
* `service/sagemaker`: Updates service API and documentation
  * This release adds the DeleteHumanTaskUi API to Amazon Augmented AI
* `service/secretsmanager`: Updates service API, documentation, and examples
  * Adds support for filters on the ListSecrets API to allow filtering results by name, tag key, tag value, or description.  Adds support for the BlockPublicPolicy option on the PutResourcePolicy API to block resource policies which grant a wide range of IAM principals access to secrets. Adds support for the ValidateResourcePolicy API to validate resource policies for syntax and prevent lockout error scenarios and wide access to secrets.
* `service/sns`: Updates service documentation
  * This release adds support for SMS origination number as an attribute in the MessageAttributes parameter for the SNS Publish API.
* `service/wafv2`: Updates service API and documentation

Release v1.33.4 (2020-07-08)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * EC2 Spot now enables customers to tag their Spot Instances Requests on creation.
* `service/forecast`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * We have launched a self-service option to make it easier for customers to manage the use of their content by AI services. Certain AI services (Amazon CodeGuru Profiler, Amazon Comprehend, Amazon Lex, Amazon Polly, Amazon Rekognition, Amazon Textract, Amazon Transcribe, and Amazon Translate) may use content to improve the service. Customers have been able to opt out of this use by contacting AWS Support, and now they can opt out on a self-service basis by setting an Organizations policy for all or an individual AI service listed above. Please refer to the technical documentation in the online AWS Organizations User Guide for more details.

Release v1.33.3 (2020-07-07)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * Amazon CloudFront adds support for a new security policy, TLSv1.2_2019.
* `service/ec2`: Updates service API and documentation
  * DescribeAvailabilityZones now returns additional data about Availability Zones and Local Zones.
* `service/elasticfilesystem`: Updates service API, documentation, and examples
  * This release adds support for automatic backups of Amazon EFS file systems to further simplify backup management.
* `service/glue`: Updates service API and documentation
  * AWS Glue Data Catalog supports cross account sharing of tables through AWS Lake Formation
* `service/lakeformation`: Updates service API and documentation
* `service/storagegateway`: Updates service API and documentation
  * Adding support for file-system driven directory refresh, Case Sensitivity toggle for SMB File Shares, and S3 Prefixes and custom File Share names

Release v1.33.2 (2020-07-06)
===

### Service Client Updates
* `service/iotsitewise`: Updates service API
* `service/quicksight`: Updates service API and documentation
  * Add Theme APIs and update Dashboard APIs to support theme overrides.
* `service/rds`: Updates service API and documentation
  * Adds support for Amazon RDS on AWS Outposts.

Release v1.33.1 (2020-07-02)
===

### Service Client Updates
* `service/connect`: Updates service documentation
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache

Release v1.33.0 (2020-07-01)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * This release supports third party emergency call routing configuration for Amazon Chime Voice Connectors.
* `service/codebuild`: Updates service API and documentation
  * Support build status config in project source
* `service/imagebuilder`: Updates service API and documentation
* `service/rds`: Updates service API
  * This release adds the exceptions KMSKeyNotAccessibleFault and InvalidDBClusterStateFault to the Amazon RDS ModifyDBInstance API.
* `service/securityhub`: Updates service API and documentation

### SDK Features
* `service/s3/s3crypto`: Introduces `EncryptionClientV2` and `DecryptionClientV2` encryption and decryption clients which support a new key wrapping algorithm `kms+context`. ([#3403](https://github.com/aws/aws-sdk-go/pull/3403))
  * `DecryptionClientV2` maintains the ability to decrypt objects encrypted using the `EncryptionClient`.
  * Please see `s3crypto` documentation for migration details.

Release v1.32.13 (2020-06-30)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/comprehendmedical`: Updates service API
* `service/ec2`: Updates service API and documentation
  * Added support for tag-on-create for CreateVpc, CreateEgressOnlyInternetGateway, CreateSecurityGroup, CreateSubnet, CreateNetworkInterface, CreateNetworkAcl, CreateDhcpOptions and CreateInternetGateway. You can now specify tags when creating any of these resources. For more information about tagging, see AWS Tagging Strategies.
* `service/ecr`: Updates service API and documentation
  * Add a new parameter (ImageDigest) and a new exception (ImageDigestDoesNotMatchException) to PutImage API to support pushing image by digest.
* `service/rds`: Updates service documentation
  * Documentation updates for rds

Release v1.32.12 (2020-06-29)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation and examples
  * Documentation updates for Amazon EC2 Auto Scaling.
* `service/codeguruprofiler`: Updates service API, documentation, and paginators
* `service/codestar-connections`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * Virtual Private Cloud (VPC) customers can now create and manage their own Prefix Lists to simplify VPC configurations.

Release v1.32.11 (2020-06-26)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * ListStackInstances and DescribeStackInstance now return a new `StackInstanceStatus` object that contains `DetailedStatus` values: a disambiguation of the more generic `Status` value. ListStackInstances output can now be filtered on `DetailedStatus` using the new `Filters` parameter.
* `service/cognito-idp`: Updates service API
* `service/dms`: Updates service documentation
  * This release contains miscellaneous API documentation updates for AWS DMS in response to several customer reported issues.
* `service/quicksight`: Updates service API and documentation
  * Added support for cross-region DataSource credentials copying.
* `service/sagemaker`: Updates service API and documentation
  * The new 'ModelClientConfig' parameter being added for CreateTransformJob and DescribeTransformJob api actions enable customers to configure model invocation related parameters such as timeout and retry.

Release v1.32.10 (2020-06-25)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Added support for tag-on-create for Host Reservations in Dedicated Hosts. You can now specify tags when you create a Host Reservation for a Dedicated Host. For more information about tagging, see AWS Tagging Strategies.
* `service/glue`: Updates service API and documentation
  * This release adds new APIs to support column level statistics in AWS Glue Data Catalog

Release v1.32.9 (2020-06-24)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling.
* `service/backup`: Updates service API and documentation
* `service/codecommit`: Updates service API, documentation, and paginators
  * This release introduces support for reactions to CodeCommit comments. Users will be able to select from a pre-defined list of emojis to express their reaction to any comments.
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR customers can now set allocation strategies for On-Demand and Spot instances in their EMR clusters with instance fleets. These allocation strategies use real-time capacity insights to provision clusters faster and make the most efficient use of available spare capacity to allocate Spot instances to reduce interruptions.
* `service/fsx`: Updates service API and documentation
* `service/honeycode`: Adds new service
* `service/iam`: Updates service documentation
  * Documentation updates for iam
* `service/organizations`: Updates service API and documentation
  * This release adds support for a new backup policy type for AWS Organizations.

Release v1.32.8 (2020-06-23)
===

### Service Client Updates
* `service/mediatailor`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * Added a new error message to support the requirement for a Business License on AWS accounts in China to create an organization.

Release v1.32.7 (2020-06-22)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds Tag On Create feature support for the ImportImage, ImportSnapshot, ExportImage and CreateInstanceExportTask APIs.
* `service/elasticmapreduce`: Updates service API and documentation
  * Adding support for MaximumCoreCapacityUnits parameter for EMR Managed Scaling. It allows users to control how many units/nodes are added to the CORE group/fleet. Remaining units/nodes are added to the TASK groups/fleet in the cluster.
* `service/rds`: Updates service documentation and paginators
  * Added paginators for various APIs.
* `service/rekognition`: Updates service API, documentation, and paginators
  * This update adds the ability to detect black frames, end credits, shots, and color bars in stored videos
* `service/sqs`: Updates service API, documentation, and paginators
  * AWS SQS adds pagination support for ListQueues and ListDeadLetterSourceQueues APIs

Release v1.32.6 (2020-06-19)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Adds support to tag elastic-gpu on the RunInstances api
* `service/elasticache`: Updates service documentation
  * Documentation updates for elasticache
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports Input Prepare schedule actions. This feature improves existing input switching by allowing users to prepare an input prior to switching to it.
* `service/opsworkscm`: Updates service API and documentation
  * Documentation updates for AWS OpsWorks CM.

Release v1.32.5 (2020-06-18)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for NexGuard FileMarker SDK, which allows NexGuard partners to watermark proprietary content in mezzanine and OTT streaming contexts.
* `service/meteringmarketplace`: Updates service documentation
  * Documentation updates for meteringmarketplace
* `service/rds`: Updates service API and documentation
  * Adding support for global write forwarding on secondary clusters in an Aurora global database.
* `service/route53`: Updates service API and documentation
  * Added a new ListHostedZonesByVPC API for customers to list all the private hosted zones that a specified VPC is associated with.
* `service/sesv2`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * Added offset support for specifying the number of days to wait after the date and time specified by a CRON expression before running the maintenance window.
* `service/support`: Updates service documentation
  * Documentation updates for support

Release v1.32.4 (2020-06-17)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * nvmeSupport added to DescribeInstanceTypes API
* `service/macie2`: Updates service documentation
* `service/route53`: Updates service API
  * Add PriorRequestNotComplete exception to AssociateVPCWithHostedZone API
* `service/snowball`: Updates service API and documentation
  * AWS Snowcone is a portable, rugged and secure device for edge computing and data transfer. You can use Snowcone to collect, process, and move data to AWS, either offline by shipping the device to AWS or online by using AWS DataSync. With 2 CPUs and 4 GB RAM of compute and 8 TB of storage, Snowcone can run edge computing workloads and store data securely. Snowcone's small size (8.94" x 5.85" x 3.25" / 227 mm x 148.6 mm x 82.65 mm) allows you to set it next to machinery in a factory. Snowcone weighs about 4.5 lbs. (2 kg), so you can carry one in a backpack, use it with battery-based operation, and use the Wi-Fi interface to gather sensor data. Snowcone supports a file interface with NFS support.

### SDK Enhancements
* `private/protocol`: Adds support for decimal precision UNIX timestamps up to thousandths of a second ([#3376](https://github.com/aws/aws-sdk-go/pull/3376))

Release v1.32.3 (2020-06-16)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Introducing instance refresh, a feature that helps you update all instances in an Auto Scaling group in a rolling fashion (for example, to apply a new AMI or instance type). You can control the pace of the refresh by defining the percentage of the group that must remain running/healthy during the replacement process and the time for new instances to warm up between replacements.
* `service/cloudfront`: Updates service documentation
  * Documentation updates for CloudFront
* `service/dataexchange`: Updates service API
* `service/lambda`: Updates service API, documentation, and examples
  * Adds support for using Amazon Elastic File System (persistent storage) with AWS Lambda. This enables customers to share data across function invocations, read large reference data files, and write function output to a persistent and shared store.
* `service/polly`: Updates service API
  * Amazon Polly adds new US English child voice - Kevin. Kevin is available as Neural voice only.
* `service/qldb`: Updates service documentation

Release v1.32.2 (2020-06-15)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/appconfig`: Updates service API, documentation, and paginators
* `service/chime`: Updates service API and documentation
  * feature: Chime: This release introduces the ability to create an AWS Chime SDK meeting with attendees.
* `service/cognito-idp`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * Added support for job executions rollout configuration, job abort configuration, and job executions timeout configuration for AWS IoT Over-the-Air (OTA) Update Feature.

Release v1.32.1 (2020-06-12)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/cloudformation`: Updates service documentation
  * The following parameters now return the organization root ID or organizational unit (OU) IDs that you specified for DeploymentTargets: the OrganizationalUnitIds parameter on StackSet and the OrganizationalUnitId parameter on StackInstance, StackInstanceSummary, and StackSetOperationResultSummary
* `service/glue`: Updates service API and documentation
  * You can now choose to crawl the entire table or just a sample of records in DynamoDB when using AWS Glue crawlers. Additionally, you can also specify a scanning rate for crawling DynamoDB tables.
* `service/storagegateway`: Updates service API and documentation
  * Display EndpointType in DescribeGatewayInformation

Release v1.32.0 (2020-06-11)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * This release adds support for deleting capacity providers.
* `service/imagebuilder`: Updates service API and documentation
* `service/lex-models`: Updates service API and documentation

### SDK Features
* `service/iotdataplane`: As part of this release, we are introducing a new feature called named shadow, which extends the capability of AWS IoT Device Shadow to support multiple shadows for a single IoT device. With this release, customers can store different device state data into different shadows, and as a result access only the required state data when needed and reduce individual shadow size.

Release v1.31.15 (2020-06-10)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/codeartifact`: Adds new service
* `service/compute-optimizer`: Updates service API and documentation
* `service/dlm`: Updates service API
* `service/ec2`: Updates service API
  * New C6g instances powered by AWS Graviton2 processors and ideal for running advanced, compute-intensive workloads; New R6g instances powered by AWS Graviton2 processors and ideal for running memory-intensive workloads.
* `service/lightsail`: Updates service documentation
  * Documentation updates for lightsail
* `service/macie2`: Updates service API and documentation
* `service/servicecatalog`: Updates service documentation
  * Service Catalog Documentation Update for Integration with AWS Organizations Delegated Administrator feature
* `service/shield`: Updates service API and documentation
  * Corrections to the supported format for contact phone numbers and to the description for the create subscription action.

### SDK Enhancements
* `aws/credentials`: Update documentation for shared credentials provider to specify the type of credentials it supports retrieving from shared credentials file.
    * Related to [#3328](https://github.com/aws/aws-sdk-go/issues/3328)

Release v1.31.14 (2020-06-09)
===

### Service Client Updates
* `service/transfer`: Updates service API and documentation
  * This release updates the API so customers can test use of Source IP to allow, deny or limit access to data in their S3 buckets after integrating their identity provider.

Release v1.31.13 (2020-06-08)
===

### Service Client Updates
* `service/servicediscovery`: Updates service API, documentation, and examples
  * Added support for tagging Service and Namespace type resources  in Cloud Map
* `service/shield`: Updates service API, documentation, and paginators
  * This release adds the option for customers to identify a contact name and method that the DDoS Response Team can proactively engage when a Route 53 Health Check that is associated with a Shield protected resource fails.

Release v1.31.12 (2020-06-05)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Amazon API Gateway now allows customers of REST APIs to skip trust chain validation for backend server certificates for HTTP and VPC Link Integration. This feature enables customers to configure their REST APIs to integrate with backends that are secured with certificates vended from private certificate authorities (CA) or certificates that are self-signed.
* `service/cloudfront`: Updates service API and documentation
  * Amazon CloudFront adds support for configurable origin connection attempts and origin connection timeout.
* `service/elasticbeanstalk`: Updates service API and documentation
  * These API changes enable an IAM user to associate an operations role with an Elastic Beanstalk environment, so that the IAM user can call Elastic Beanstalk actions without having access to underlying downstream AWS services that these actions call.
* `service/personalize`: Updates service API and documentation
* `service/personalize-runtime`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This release enables additional functionality for the Amazon Pinpoint journeys feature. With this release, you can send messages through additional channels, including SMS, push notifications, and custom channels.
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/servicecatalog`: Updates service API and documentation
  * This release adds support for DescribeProduct and DescribeProductAsAdmin by product name, DescribeProvisioningArtifact by product name or provisioning artifact name, returning launch paths as part of DescribeProduct output and adds maximum length for provisioning artifact name and provisioning artifact description.

Release v1.31.11 (2020-06-04)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * New C5a instances, the latest generation of EC2's compute-optimized instances featuring AMD's 2nd Generation EPYC processors. C5a instances offer up to 96 vCPUs, 192 GiB of instance memory, 20 Gbps in Network bandwidth; New G4dn.metal bare metal instance with 8 NVIDIA T4 GPUs.
* `service/lightsail`: Updates service API and documentation
  * This release adds the BurstCapacityPercentage and BurstCapacityTime instance metrics, which allow you to track the burst capacity available to your instance.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/meteringmarketplace`: Updates service documentation
  * Documentation updates for meteringmarketplace
* `service/ssm`: Updates service API and documentation
  * SSM State Manager support for executing an association only at specified CRON schedule after creating/updating an association.

### SDK Bugs
* `private/model`: Fixes SDK not enabling endpoint discovery when endpoint is set to empty string ([#3349](https://github.com/aws/aws-sdk-go/pull/3349))

Release v1.31.10 (2020-06-03)
===

### Service Client Updates
* `service/directconnect`: Updates service API and documentation
  * This release supports the virtual interface failover test, which allows you to verify that traffic routes over redundant virtual interfaces when you bring your primary virtual interface out of service.
* `service/elasticache`: Updates service API and documentation
  * This release improves the Multi-AZ feature in ElastiCache by adding a separate flag and proper validations.
* `service/es`: Updates service API, documentation, and paginators
  * Amazon Elasticsearch Service now offers support for cross-cluster search, enabling you to perform searches, aggregations, and visualizations across multiple Amazon Elasticsearch Service domains with a single query or from a single Kibana interface. New feature includes the ability to setup connection, required to perform cross-cluster search, between domains using an approval workflow.
* `service/glue`: Updates service API and documentation
  * Adding databaseName in the response for GetUserDefinedFunctions() API.
* `service/iam`: Updates service API and documentation
  * GenerateServiceLastAccessedDetails will now return ActionLastAccessed details for certain S3 control plane actions
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for the encoding of VP8 or VP9 video in WebM container with Vorbis or Opus audio.

Release v1.31.9 (2020-06-02)
===

### Service Client Updates
* `service/guardduty`: Updates service API and documentation
  * Amazon GuardDuty findings now include S3 bucket details under the resource section if an S3 Bucket was one of the affected resources

Release v1.31.8 (2020-06-01)
===

### Service Client Updates
* `service/athena`: Updates service API, documentation, and paginators
  * This release adds support for connecting Athena to your own Apache Hive Metastores in addition to the AWS Glue Data Catalog. For more information, please see https://docs.aws.amazon.com/athena/latest/ug/connect-to-data-source-hive.html
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR now supports encrypting log files with AWS Key Management Service (KMS) customer managed keys.
* `service/fsx`: Updates service API and documentation
* `service/kms`: Updates service API and documentation
  * AWS Key Management Service (AWS KMS): If the GenerateDataKeyPair or GenerateDataKeyPairWithoutPlaintext APIs are called on a CMK in a custom key store (origin == AWS_CLOUDHSM), they return an UnsupportedOperationException. If a call to UpdateAlias causes a customer to exceed the Alias resource quota, the UpdateAlias API returns a LimitExceededException.
* `service/sagemaker`: Updates service API and documentation
  * We are releasing HumanTaskUiArn as a new parameter in CreateLabelingJob and RenderUiTemplate which can take an ARN for a system managed UI to render a task.
* `service/worklink`: Updates service API and documentation

Release v1.31.7 (2020-05-28)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/marketplace-catalog`: Updates service API and documentation
* `service/qldb-session`: Updates service documentation
* `service/workmail`: Updates service API and documentation
  * This release adds support for Amazon WorkMail organization-level retention policies.

Release v1.31.6 (2020-05-27)
===

### Service Client Updates
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/guardduty`: Updates service documentation
  * Documentation updates for GuardDuty

Release v1.31.5 (2020-05-26)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * ebsOptimizedInfo, efaSupported and supportedVirtualizationTypes added to DescribeInstanceTypes API
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache now allows you to use resource based policies to manage access to operations performed on ElastiCache resources. Also, Amazon ElastiCache now exposes ARN (Amazon Resource Names) for ElastiCache resources such as Cache Clusters and Parameter Groups. ARNs can be used to apply IAM policies to ElastiCache resources.
* `service/macie`: Updates service documentation, paginators, and examples
  * This is a documentation-only update to the Amazon Macie Classic API. This update corrects out-of-date references to the service name.
* `service/quicksight`: Updates service API and documentation
  * Add DataSetArns to QuickSight DescribeDashboard API response.
* `service/ssm`: Updates service API and documentation
  * The AWS Systems Manager GetOpsSummary API action now supports multiple OpsResultAttributes in the request. Currently, this feature only supports OpsResultAttributes with the following TypeNames: [AWS:EC2InstanceComputeOptimizer] or [AWS:EC2InstanceInformation, AWS:EC2InstanceComputeOptimizer]. These TypeNames can be used along with either or both of the following: [AWS:EC2InstanceRecommendation, AWS:RecommendationSource]

Release v1.31.4 (2020-05-22)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling
* `service/iotsitewise`: Updates service API and documentation

Release v1.31.3 (2020-05-21)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild adds support for tagging with report groups
* `service/ec2`: Updates service API and documentation
  * From this release onwards ProvisionByoipCidr publicly supports IPv6. Updated ProvisionByoipCidr API to support tags for public IPv4 and IPv6 pools. Added NetworkBorderGroup to the DescribePublicIpv4Pools response.
* `service/s3`: Updates service API, documentation, and examples
  * Deprecates unusable input members bound to Content-MD5 header. Updates example and documentation.
* `service/synthetics`: Updates service API and documentation

Release v1.31.2 (2020-05-20)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/appmesh`: Updates service API and documentation
* `service/backup`: Updates service API and documentation
* `service/chime`: Updates service API and documentation
  * Amazon Chime enterprise account administrators can now set custom retention policies on chat data in the Amazon Chime application.
* `service/codedeploy`: Updates service API and documentation
  * Amazon ECS customers using application and network load balancers can use CodeDeploy BlueGreen hook to invoke a CloudFormation stack update. With this update you can view CloudFormation deployment and target details via existing APIs and use your stack Id to list or delete all deployments associated with the stack.
* `service/medialive`: Updates service API, documentation, waiters, and paginators
  * AWS Elemental MediaLive now supports the ability to ingest the content that is streaming from an AWS Elemental Link device: https://aws.amazon.com/medialive/features/link/. This release also adds support for SMPTE-2038 and input state waiters.
* `service/securityhub`: Updates service API and documentation
* `service/transcribe-streaming`: Updates service API and documentation

### SDK Bugs
* `service/s3/s3crypto`: Add missing return in encryption client ([#3258](https://github.com/aws/aws-sdk-go/pull/3258))
  * Fixes a missing return in the encryption client that was causing a nil dereference panic.

Release v1.31.1 (2020-05-19)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * You can now receive Voice Connector call events through SNS or SQS.
* `service/ec2`: Updates service API and documentation
  * This release adds support for Federated Authentication via SAML-2.0 in AWS ClientVPN.
* `service/health`: Updates service API, documentation, and paginators
  * Feature: Health: AWS Health added a new field to differentiate Public events from Account-Specific events in the API request and response. Visit https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html to learn more.
* `service/transcribe`: Updates service documentation

Release v1.31.0 (2020-05-18)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Amazon Chime now supports redacting chat messages.
* `service/dynamodb`: Updates service documentation
  * Documentation updates for dynamodb
* `service/ec2`: Updates service API
  * This release changes the RunInstances CLI and SDK's so that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `service/ecs`: Updates service API and documentation
  * This release adds support for specifying environment files to add environment variables to your containers.
* `service/macie2`: Updates service API
* `service/qldb`: Updates service API, documentation, and paginators

### SDK Features
* `service/dynamodb/dynamodbattribute`: Support has been added for empty string and byte values.
  * `Encoder` has added two new configuration options for controlling whether empty string and byte values are sent as null or empty.
    * `NullEmptyString`: Whether string values that are empty will be sent as null (default: `true`).
    * `NullEmptyByteSlice`: Whether byte slice that are empty will be sent as null (default: `true`).
    * The default value for these options retrains the existing behavior of the SDK in prior releases.

Release v1.30.29 (2020-05-15)
===

### Service Client Updates
* `service/cloudformation`: Updates service API, documentation, waiters, and paginators
  * This release adds support for the following features: 1. DescribeType and ListTypeVersions APIs now output a field IsDefaultVersion, indicating if a version is the default version for its type; 2. Add StackRollbackComplete waiter feature to wait until stack status is UPDATE_ROLLBACK_COMPLETE; 3. Add paginators in DescribeAccountLimits, ListChangeSets, ListStackInstances, ListStackSetOperationResults, ListStackSetOperations, ListStackSets APIs.
* `service/ecr`: Updates service API and documentation
  * This release adds support for specifying an image manifest media type when pushing a manifest to Amazon ECR.
* `service/glue`: Updates service API and documentation
  * Starting today, you can stop the execution of Glue workflows that are running. AWS Glue workflows are directed acyclic graphs (DAGs) of Glue triggers, crawlers and jobs. Using a workflow, you can design a complex multi-job extract, transform, and load (ETL) activity that AWS Glue can execute and track as single entity.
* `service/sts`: Updates service API
  * API updates for STS

Release v1.30.28 (2020-05-14)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 now supports adding AWS resource tags for associations between VPCs and local gateways, at creation time.
* `service/imagebuilder`: Updates service API and documentation

Release v1.30.27 (2020-05-13)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache now supports auto-update of ElastiCache clusters after the "recommended apply by date" of  service update has passed. ElastiCache will use your maintenance window to schedule the auto-update of applicable clusters. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/Self-Service-Updates.html and https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `service/macie2`: Adds new service

Release v1.30.26 (2020-05-12)
===

### Service Client Updates
* `service/iotsitewise`: Updates service documentation
* `service/workmail`: Updates service API and documentation
  * Minor API fixes and updates to the documentation.

Release v1.30.25 (2020-05-11)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API and documentation
* `service/ec2`: Updates service API
  * M6g instances are our next-generation general purpose instances powered by AWS Graviton2 processors
* `service/kendra`: Updates service API and documentation
  * Amazon Kendra is now generally available. As part of general availability, we are launching * Developer edition * Ability to scale your Amazon Kendra index with capacity units * Support for new connectors * Support for new tagging API's * Support for Deleting data source * Metrics for data source sync operations * Metrics for query & storage utilization

Release v1.30.24 (2020-05-08)
===

### Service Client Updates
* `service/guardduty`: Updates service documentation
  * Documentation updates for GuardDuty
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates for resourcegroupstaggingapi
* `service/sagemaker`: Updates service API and documentation
  * This release adds a new parameter (EnableInterContainerTrafficEncryption) to CreateProcessingJob API to allow for enabling inter-container traffic encryption on processing jobs.

### SDK Bugs
* `service/dynamodb/dynamodbattribute`:  Simplified decode logic to decode AttributeValue as it is defined ([#3308](https://github.com/aws/aws-sdk-go/pull/3308))

Release v1.30.23 (2020-05-07)
===

### Service Client Updates
* `service/appconfig`: Updates service documentation
* `service/codebuild`: Updates service API, documentation, and paginators
  * Add COMMIT_MESSAGE enum for webhook filter types
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 now adds warnings to identify issues when creating a launch template or launch template version.
* `service/lightsail`: Updates service API and documentation
  * This release adds support for the following options in instance public ports: Specify source IP addresses, specify ICMP protocol like PING, and enable/disable the Lightsail browser-based SSH and RDP clients' access to your instance.
* `service/logs`: Updates service API and documentation
  * Amazon CloudWatch Logs now offers the ability to interact with Logs Insights queries via the new PutQueryDefinition, DescribeQueryDefinitions, and DeleteQueryDefinition APIs.
* `service/route53`: Updates service API
  * Amazon Route 53 now supports the EU (Milan) Region (eu-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/ssm`: Updates service API
  * This Patch Manager release supports creating patch baselines for Oracle Linux and Debian

Release v1.30.22 (2020-05-06)
===

### Service Client Updates
* `service/codestar-connections`: Updates service API and documentation
* `service/comprehendmedical`: Updates service API and documentation

Release v1.30.21 (2020-05-05)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * With this release, you can call ModifySubnetAttribute with two new parameters: MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool, to map a customerOwnedIpv4Pool to a subnet. You will also see these two new fields in the DescribeSubnets response. If your subnet has a customerOwnedIpv4Pool mapped, your network interface will get an auto assigned customerOwnedIpv4 address when placed onto an instance.
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager Parameter Store launches new data type to support aliases in EC2 APIs
* `service/support`: Updates service documentation
  * Documentation updates for support

Release v1.30.20 (2020-05-04)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway
* `service/ec2`: Updates service documentation
  * With this release, you can include enriched metadata in Amazon Virtual Private Cloud (Amazon VPC) flow logs published to Amazon CloudWatch Logs or Amazon Simple Storage Service (S3). Prior to this, custom format VPC flow logs enriched with additional metadata could be published only to S3. With this launch, we are also adding additional metadata fields that provide insights about the location such as AWS Region, AWS Availability Zone, AWS Local Zone, AWS Wavelength Zone, or AWS Outpost where the network interface where flow logs are captured exists.
* `service/s3control`: Updates service API and documentation
  * Amazon S3 Batch Operations now supports Object Lock.

Release v1.30.19 (2020-05-01)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service API
  * Change the TagKeys argument for UntagResource to a URL parameter to address an issue with the Java and .NET SDKs.
* `service/ssm`: Updates service API and documentation
  * Added TimeoutSeconds as part of ListCommands API response.

Release v1.30.18 (2020-04-30)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * AWS IoT Core released Fleet Provisioning for scalable onboarding of IoT devices to the cloud. This release includes support for customer's Lambda functions to validate devices during onboarding. Fleet Provisioning also allows devices to send Certificate Signing Requests (CSR) to AWS IoT Core for signing and getting a unique certificate. Lastly,  AWS IoT Core added a feature to register the same certificate for multiple accounts in the same region without needing to register the certificate authority (CA).
* `service/iotevents`: Updates service API and documentation
* `service/lambda`: Updates service documentation and examples
  * Documentation updates for Lambda
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for including AFD signaling in MXF wrapper.
* `service/schemas`: Updates service API and documentation
* `service/storagegateway`: Updates service API
  * Adding support for S3_INTELLIGENT_TIERING as a storage class option

Release v1.30.17 (2020-04-29)
===

### Service Client Updates
* `service/iotsitewise`: Adds new service
* `service/servicediscovery`: Updates service documentation and examples
  * Documentation updates for servicediscovery
* `service/transcribe`: Updates service API, documentation, and paginators
* `service/waf`: Updates service API and documentation
  * This release add migration API for AWS WAF Classic ("waf" and "waf-regional"). The migration API will parse through your web ACL and generate a CloudFormation template into your S3 bucket. Deploying this template will create equivalent web ACL under new AWS WAF ("wafv2").
* `service/waf-regional`: Updates service API and documentation

Release v1.30.16 (2020-04-28)
===

### Service Client Updates
* `service/ecr`: Updates service API and documentation
  * This release adds support for multi-architecture images also known as a manifest list
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/kinesisvideo`: Updates service API and documentation
  * Add "GET_CLIP" to the list of supported API names for the GetDataEndpoint API.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports several new features: enhanced VQ for H.264 (AVC) output encodes; passthrough of timed metadata and of Nielsen ID3 metadata in fMP4 containers in HLS outputs; the ability to generate a SCTE-35 sparse track without additional segmentation, in Microsoft Smooth outputs;  the ability to select the audio from a TS input by specifying the audio track; and conversion of HDR colorspace in the input to an SDR colorspace in the output.
* `service/route53`: Updates service API, documentation, and paginators
  * Amazon Route 53 now supports the Africa (Cape Town) Region (af-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/ssm`: Updates service API and documentation
  * SSM State Manager support for adding list association filter for Resource Group and manual mode of managing compliance for an association.

### SDK Bugs
* `service/s3`: Fix S3 client behavior wrt 200 OK response with empty payload

Release v1.30.15 (2020-04-27)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation
* `service/dataexchange`: Updates service API and documentation
* `service/dms`: Updates service API and documentation
  * Adding minimum replication engine version for describe-endpoint-types api.
* `service/sagemaker`: Updates service API and documentation
  * Change to the input, ResourceSpec, changing EnvironmentArn to SageMakerImageArn. This affects the following preview APIs: CreateDomain, DescribeDomain, UpdateDomain, CreateUserProfile, DescribeUserProfile, UpdateUserProfile, CreateApp and DescribeApp.

Release v1.30.14 (2020-04-24)
===

### Service Client Updates
* `service/dlm`: Updates service documentation
* `service/elastic-inference`: Updates service API, documentation, and paginators
* `service/iot`: Updates service API
  * This release adds a new exception type to the AWS IoT SetV2LoggingLevel API.

Release v1.30.13 (2020-04-23)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API, documentation, and examples
* `service/firehose`: Updates service API and documentation
  * You can now deliver streaming data to an Amazon Elasticsearch Service domain in an Amazon VPC. You can now compress streaming data delivered to S3 using Hadoop-Snappy in addition to Gzip, Zip and Snappy formats.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API enhances support for sending campaigns through custom channels to locations such as AWS Lambda functions or web applications. Campaigns can now use CustomDeliveryConfiguration and CampaignCustomMessage to configure custom channel settings for a campaign.
* `service/ram`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Adds support for AWS Local Zones, including a new optional parameter AvailabilityZoneGroup for the DescribeOrderableDBInstanceOptions operation.
* `service/storagegateway`: Updates service API and documentation
  * Added AutomaticTapeCreation APIs
* `service/transfer`: Updates service API and documentation
  * This release adds support for transfers over FTPS and FTP in and out of Amazon S3, which makes it easy to migrate File Transfer Protocol over SSL (FTPS) and FTP workloads to AWS, in addition to the existing support for Secure File Transfer Protocol (SFTP).

### SDK Enhancements
* `aws/credentials/stscreds`: Add support for policy ARNs ([#3249](https://github.com/aws/aws-sdk-go/pull/3249))
  * Adds support for passing AWS policy ARNs to the `AssumeRoleProvider` and `WebIdentityRoleProvider` credential providers. This allows you provide policy ARNs when assuming the role that will further limit the permissions of the credentials returned.

Release v1.30.12 (2020-04-22)
===

### Service Client Updates
* `service/codeguru-reviewer`: Updates service API, documentation, and paginators
* `service/es`: Updates service API and documentation
  * This change adds a new field 'OptionalDeployment' to ServiceSoftwareOptions to indicate whether a service software update is optional or mandatory. If True, it indicates that the update is optional, and the service software is not automatically updated. If False, the service software is automatically updated after AutomatedUpdateDate.
* `service/fms`: Updates service API and documentation
* `service/redshift`: Updates service API, documentation, and paginators
  * Amazon Redshift support for usage limits
* `service/transcribe-streaming`: Updates service API and documentation

### SDK Enhancements
* `aws/credentials/stscreds`: Add support for custom web identity TokenFetcher ([#3256](https://github.com/aws/aws-sdk-go/pull/3256))
  * Adds new constructor, `NewWebIdentityRoleProviderWithToken` for `WebIdentityRoleProvider` which takes a `TokenFetcher`. Implement `TokenFetcher` to provide custom sources for web identity tokens. The `TokenFetcher` must be concurrency safe. `TokenFetcher` may return unique value each time it is called.

Release v1.30.11 (2020-04-21)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR adds support for configuring a managed scaling policy for an Amazon EMR cluster. This enables automatic resizing of a cluster to optimize for job execution speed and reduced cluster cost.
* `service/guardduty`: Updates service API, documentation, and paginators
  * AWS GuardDuty now supports using AWS Organizations delegated administrators to create and manage GuardDuty master and member accounts.  The feature also allows GuardDuty to be automatically enabled on associated organization accounts.
* `service/route53domains`: Updates service API and documentation
  * You can now programmatically transfer domains between AWS accounts without having to contact AWS Support

Release v1.30.10 (2020-04-20)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * You can now export an OpenAPI 3.0 compliant API definition file for Amazon API Gateway HTTP APIs using the Export API.
* `service/ce`: Updates service API, documentation, and paginators
* `service/glue`: Updates service API and documentation
  * Added a new ConnectionType "KAFKA" and a ConnectionProperty "KAFKA_BOOTSTRAP_SERVERS" to support Kafka connection.
* `service/iotevents`: Updates service API and documentation
* `service/synthetics`: Adds new service

Release v1.30.9 (2020-04-17)
===

### Service Client Updates
* `service/frauddetector`: Updates service API and documentation
* `service/opsworkscm`: Updates service documentation and paginators
  * Documentation updates for opsworkscm

Release v1.30.8 (2020-04-16)
===

### Service Client Updates
* `service/AWSMigrationHub`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 now supports adding AWS resource tags for placement groups and key pairs, at creation time. The CreatePlacementGroup API will now return placement group information when created successfully. The DeleteKeyPair API now supports deletion by resource ID.
* `service/glue`: Updates service API
  * This release adds support for querying GetUserDefinedFunctions API without databaseName.
* `service/imagebuilder`: Updates service API and documentation
* `service/iotevents`: Updates service API and documentation
* `service/lambda`: Updates service documentation and examples
  * Sample code for AWS Lambda operations
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert now allows you to specify your input captions frame rate for SCC captions sources.
* `service/mediatailor`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * This release adds support for Amazon RDS Proxy with PostgreSQL compatibility.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports running training jobs on ml.g4dn and ml.c5n instance types. Amazon SageMaker supports in "IN" operation for Search now.
* `service/sagemaker-a2i-runtime`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation
* `service/snowball`: Updates service API
  * An update to the Snowball Edge Storage Optimized device has been launched. Like the previous version, it has 80 TB of capacity for data transfer. Now it has 40 vCPUs, 80 GiB, and a 1 TiB SATA SSD of memory for EC2 compatible compute. The 80 TB of capacity can also be used for EBS-like volumes for AMIs.

Release v1.30.7 (2020-04-08)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * feature: Chime: This release introduces the ability to tag Amazon Chime SDK meeting resources.  You can use tags to organize and identify your resources for cost allocation.
* `service/cloudformation`: Updates service documentation
  * The OrganizationalUnitIds parameter on StackSet and the OrganizationalUnitId parameter on StackInstance, StackInstanceSummary, and StackSetOperationResultSummary are now reserved for internal use. No data is returned for this parameter.
* `service/codeguruprofiler`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API and documentation
  * This release provides the ability to include tags in EC2 event notifications.
* `service/ecs`: Updates service API and documentation
  * This release provides native support for specifying Amazon EFS file systems as volumes in your Amazon ECS task definitions.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK adds support for queue hopping. Jobs can now hop from their original queue to a specified alternate queue, based on the maximum wait time that you specify in the job settings.
* `service/migrationhub-config`: Updates service API and documentation

### SDK Enhancements
* `example/service/ecr`: Add create and delete repository examples ([#3221](https://github.com/aws/aws-sdk-go/pull/3221))
  * Adds examples demonstrating how you can create and delete repositories with the SDK.

Release v1.30.6 (2020-04-07)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Amazon API Gateway.
* `service/codeguru-reviewer`: Updates service API
* `service/mediaconnect`: Updates service API and documentation

Release v1.30.5 (2020-04-06)
===

### Service Client Updates
* `service/chime`: Updates service API, documentation, and paginators
  * Amazon Chime proxy phone sessions let you provide two users with a shared phone number to communicate via voice or text for up to 12 hours without revealing personal phone numbers. When users call or message the provided phone number, they are connected to the other party and their private phone numbers are replaced with the shared number in Caller ID.
* `service/elasticbeanstalk`: Updates service API, documentation, and paginators
  * This release adds a new action, ListPlatformBranches, and updates two actions, ListPlatformVersions and DescribePlatformVersion, to support the concept of Elastic Beanstalk platform branches.
* `service/iam`: Updates service documentation
  * Documentation updates for AWS Identity and Access Management (IAM).
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.30.4 (2020-04-03)
===

### Service Client Updates
* `service/personalize-runtime`: Updates service API and documentation
* `service/robomaker`: Updates service API and documentation

Release v1.30.3 (2020-04-02)
===

### Service Client Updates
* `service/gamelift`: Updates service API and documentation
  * Public preview of GameLift FleetIQ as a standalone feature. GameLift FleetIQ makes it possible to use low-cost Spot instances by limiting the chance of interruptions affecting game sessions. FleetIQ is a feature of the managed GameLift service, and can now be used with game hosting in EC2 Auto Scaling groups that you manage in your own account.
* `service/medialive`: Updates service API, documentation, and waiters
  * AWS Elemental MediaLive now supports Automatic Input Failover. This feature provides resiliency upstream of the channel, before ingest starts.
* `service/monitoring`: Updates service API and documentation
  * Amazon CloudWatch Contributor Insights adds support for tags and tagging on resource creation.
* `service/rds`: Updates service documentation
  * Documentation updates for RDS: creating read replicas is now supported for SQL Server DB instances
* `service/redshift`: Updates service documentation
  * Documentation updates for redshift

### SDK Enhancements
* `aws/credentials`: `ProviderWithContext` optional interface has been added to support passing contexts on credential retrieval ([#3223](https://github.com/aws/aws-sdk-go/pull/3223))
  * Credential providers that implement the optional `ProviderWithContext` will have context passed to them
  * `ec2rolecreds.EC2RoleProvider`, `endpointcreds.Provider`, `stscreds.AssumeRoleProvider`, `stscreds.WebIdentityRoleProvider` have been updated to support the `ProviderWithContext` interface
  * Fixes [#3213](https://github.com/aws/aws-sdk-go/issues/3213)
* `aws/ec2metadata`: Context aware operations have been added `EC2Metadata` client ([#3223](https://github.com/aws/aws-sdk-go/pull/3223))

Release v1.30.2 (2020-04-01)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * This release introduces Dimensions for AWS IoT Device Defender. Dimensions can be used in Security Profiles to collect and monitor fine-grained metrics.
* `service/mediaconnect`: Updates service API and documentation

Release v1.30.1 (2020-03-31)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/detective`: Updates service documentation
* `service/elastic-inference`: Updates service API
* `service/fms`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * Add two enums for MongoDB connection: Added "CONNECTION_URL" to "ConnectionPropertyKey" and added "MONGODB" to "ConnectionType"
* `service/lambda`: Updates service API and documentation
  * AWS Lambda now supports .NET Core 3.1
* `service/mediastore`: Updates service API and documentation
  * This release adds support for CloudWatch Metrics. You can now set a policy on your container to dictate which metrics MediaStore sends to CloudWatch.
* `service/opsworkscm`: Updates service documentation
  * Documentation updates for OpsWorks-CM CreateServer values.
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces MMS support for SMS messages.
* `service/rekognition`: Updates service API and documentation
  * This release adds DeleteProject and DeleteProjectVersion APIs to Amazon Rekognition Custom Labels.
* `service/storagegateway`: Updates service API and documentation
  * Adding audit logging support for SMB File Shares
* `service/wafv2`: Updates service API and documentation

Release v1.30.0 (2020-03-30)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation

### SDK Features
* SDK generated errors are fixed to use pointer receivers preventing confusion, and potential impossible type assertions. The SDK will only return API generated API error types as pointers. This fix ensures Go's type system will catch invalid error type assertions.

### SDK Enhancements
* Update SDK's `go-jmespath` dependency to latest tagged version `0.3.0` ([#3205](https://github.com/aws/aws-sdk-go/pull/3205))

### SDK Bugs
* Fix generated SDK errors to use pointer receivers
  * Fixes the generated SDK API errors to use pointer function receivers instead of value. This fixes potential confusion writing code and not casting to the correct type. The SDK will always return the API error as a pointer, not value.
  * Code that did type assertions from the operation's returned error to the value type would never be satisfied. Leading to errors being missed. Changing the function receiver to a pointer prevents this error. Highlighting it in code bases.

Release v1.29.34 (2020-03-27)
===

### Service Client Updates
* `service/globalaccelerator`: Updates service API and documentation
* `service/kendra`: Updates service API and documentation
  * The Amazon Kendra Microsoft SharePoint data source now supports include and exclude regular expressions and change log features. Include and exclude regular expressions enable you to  provide a list of regular expressions to match the display URL of SharePoint documents to either include or exclude documents respectively. When you enable the changelog feature it enables Amazon Kendra to use the SharePoint change log to determine which documents to update in the index.
* `service/servicecatalog`: Updates service documentation
  * Added "LocalRoleName" as an acceptable Parameter for Launch type in CreateConstraint and UpdateConstraint APIs

Release v1.29.33 (2020-03-26)
===

### Service Client Updates
* `service/fsx`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * This release updates Amazon Augmented AI CreateFlowDefinition API and DescribeFlowDefinition response.
* `service/securityhub`: Updates service API and documentation

Release v1.29.32 (2020-03-25)
===

### Service Client Updates
* `service/application-insights`: Updates service API and documentation
* `service/ce`: Updates service API and documentation
* `service/detective`: Updates service API and documentation
* `service/es`: Updates service API, documentation, and paginators
  * Adding support for customer packages (dictionary files) to Amazon Elasticsearch Service
* `service/managedblockchain`: Updates service API and documentation
* `service/xray`: Updates service API and documentation
  * GetTraceSummaries - Now provides additional root cause attribute ClientImpacting which indicates whether root cause impacted trace client.

Release v1.29.31 (2020-03-24)
===

### Service Client Updates
* `service/athena`: Updates service documentation
  * Documentation updates for Athena, including QueryExecutionStatus QUEUED and RUNNING states. QUEUED now indicates that the query has been submitted to the service. RUNNING indicates that the query is in execution phase.
* `service/eks`: Updates service API and documentation
* `service/organizations`: Updates service API, documentation, and paginators
  * Introduces actions for giving a member account administrative Organizations permissions for an AWS service. You can run this action only for AWS services that support this feature.
* `service/rds-data`: Updates service documentation

Release v1.29.30 (2020-03-23)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * Documentation updates to reflect that the default timeout for integrations is now 30 seconds for HTTP APIs.
* `service/eks`: Updates service API and documentation
* `service/route53`: Updates service documentation
  * Documentation updates for Route 53.

Release v1.29.29 (2020-03-20)
===

### Service Client Updates
* `service/servicecatalog`: Updates service API and documentation
  * Added "productId" and "portfolioId" to responses from CreateConstraint, UpdateConstraint, ListConstraintsForPortfolio, and DescribeConstraint APIs

Release v1.29.28 (2020-03-19)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * AWS Certificate Manager documentation updated on API calls ImportCertificate and ListCertificate. Specific updates included input constraints, private key size for import and next token size for list.
* `service/outposts`: Updates service documentation

Release v1.29.27 (2020-03-18)
===

### Service Client Updates
* `service/mediaconnect`: Updates service API and documentation
* `service/personalize`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Updated the MaxRecords type in DescribeExportTasks to Integer.

Release v1.29.26 (2020-03-17)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for: AV1 encoding in File Group MP4, DASH and CMAF DASH outputs; PCM/WAV audio output in MPEG2-TS containers; and Opus audio in Webm inputs.

Release v1.29.25 (2020-03-16)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release adds the ability to update the task placement strategy and constraints for Amazon ECS services.
* `service/elasticache`: Updates service API, documentation, and paginators
  * Amazon ElastiCache now supports Global Datastore for Redis. Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. You can create, modify and describe a Global Datastore, as well as add or remove regions from your Global Datastore and promote a region as primary in Global Datastore.
* `service/s3control`: Updates service API and documentation
  * Amazon S3 now supports Batch Operations job tagging.
* `service/ssm`: Updates service API and documentation
  * Resource data sync for AWS Systems Manager Inventory now includes destination data sharing. This feature enables you to synchronize inventory data from multiple AWS accounts into a central Amazon S3 bucket. To use this feature, all AWS accounts must be listed in AWS Organizations.

Release v1.29.24 (2020-03-13)
===

### Service Client Updates
* `service/appconfig`: Updates service documentation

Release v1.29.23 (2020-03-12)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * Amazon API Gateway HTTP APIs is now generally available. HTTP APIs offer the core functionality of REST API at up to 71% lower price compared to REST API, 60% lower p99 latency, and is significantly easier to use. As part of general availability, we added new features to route requests to private backends such as private ALBs, NLBs, and IP/ports. We also brought over a set of features from REST API such as Stage Variables, and Stage/Route level throttling. Custom domain names can also now be used with both REST And HTTP APIs.
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2
* `service/iot`: Updates service API and documentation
  * As part of this release, we are extending capability of AWS IoT Rules Engine to support IoT Cloudwatch log action. The IoT Cloudwatch log rule action lets you send messages from IoT sensors and applications to Cloudwatch logs for troubleshooting and debugging.
* `service/lex-models`: Updates service API and documentation
* `service/securityhub`: Updates service API and documentation

Release v1.29.22 (2020-03-11)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service documentation
  * Documentation updates for elasticfilesystem
* `service/redshift`: Updates service API and documentation
  * Amazon Redshift now supports operations to pause and resume a cluster on demand or on a schedule.

Release v1.29.21 (2020-03-10)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2
* `service/iotevents`: Updates service API and documentation
* `service/marketplacecommerceanalytics`: Updates service documentation
  * Change the disbursement data set to look past 31 days instead until the beginning of the month.
* `service/serverlessrepo`: Updates service API and documentation

### SDK Enhancements
* `aws/credentials`: Clarify `token` usage in `NewStaticCredentials` documentation.
  * Related to [#3162](https://github.com/aws/aws-sdk-go/issues/3162).
* `service/s3/s3manager`: Improve memory allocation behavior by replacing sync.Pool with custom pool implementation ([#3183](https://github.com/aws/aws-sdk-go/pull/3183))
  * Improves memory allocations that occur when the provided `io.Reader` to upload does not satisfy both the `io.ReaderAt` and `io.ReadSeeker` interfaces.
  * Fixes [#3075](https://github.com/aws/aws-sdk-go/issues/3075)

Release v1.29.20 (2020-03-09)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Added new settings for Kinesis target to include detailed transaction info; to capture table DDL details; to use single-line unformatted json, which can be directly queried by AWS Athena if data is streamed into S3 through AWS Kinesis Firehose. Added CdcInsertsAndUpdates in S3 target settings to allow capture ongoing insertions and updates only.
* `service/ec2`: Updates service API and documentation
  * Amazon Virtual Private Cloud (VPC) NAT Gateway adds support for tagging on resource creation.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports the ability to configure the Preferred Channel Pipeline for channels contributing to a Multiplex.

Release v1.29.19 (2020-03-06)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release provides customers with a self-service option to enable Local Zones.
* `service/guardduty`: Updates service API and documentation
  * Amazon GuardDuty findings now include the OutpostArn if the finding is generated for an AWS Outposts EC2 host.
* `service/robomaker`: Updates service API and documentation
* `service/signer`: Updates service API and documentation
  * This release enables signing image format override in PutSigningProfile requests, adding two more enum fields, JSONEmbedded and JSONDetached. This release also extends the length limit of SigningProfile name from 20 to 64.

Release v1.29.18 (2020-03-05)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * You can now create AWS Client VPN Endpoints with a specified VPC and Security Group. Additionally, you can modify these attributes when modifying the endpoint.
* `service/eks`: Updates service API and documentation
* `service/guardduty`: Updates service API and documentation
  * Add a new finding field for EC2 findings indicating the instance's local IP address involved in the threat.
* `service/opsworkscm`: Updates service API
  * Updated the Tag regex pattern to align with AWS tagging APIs.

Release v1.29.17 (2020-03-04)
===

### Service Client Updates
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces support for integrating recommender models with email, push notification, and SMS message templates. You can now use these types of templates to connect to recommender models and add personalized recommendations to messages that you send from campaigns and journeys.

### SDK Bugs
* `service/s3/s3manager`: Fix resource leak on UploadPart failures ([#3144](https://github.com/aws/aws-sdk-go/pull/3144))

Release v1.29.16 (2020-03-03)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * Amazon VPC Flow Logs adds support for tags and tagging on resource creation.

Release v1.29.15 (2020-03-02)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service API and documentation
* `service/monitoring`: Updates service API, documentation, waiters, and paginators
  * Introducing Amazon CloudWatch Composite Alarms

Release v1.29.14 (2020-02-29)
===

### Service Client Updates
* `service/config`: Updates service API and documentation

Release v1.29.13 (2020-02-28)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service paginators
* `service/appmesh`: Updates service API and documentation
* `service/codeguruprofiler`: Updates service documentation
* `service/config`: Updates service API, documentation, and paginators
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/glue`: Updates service API, documentation, and paginators
  * AWS Glue adds resource tagging support for Machine Learning Transforms and adds a new API, ListMLTransforms to support tag filtering.  With this feature, customers can use tags in AWS Glue to organize and control access to Machine Learning Transforms.
* `service/quicksight`: Updates service API, documentation, and paginators
  * Added SearchDashboards API that allows listing of dashboards that a specific user has access to.
* `service/sagemaker-a2i-runtime`: Updates service API and documentation
* `service/workdocs`: Updates service documentation
  * Documentation updates for workdocs

Release v1.29.12 (2020-02-27)
===

### Service Client Updates
* `service/globalaccelerator`: Updates service API and documentation
* `service/lightsail`: Updates service API and documentation
  * Adds support to create notification contacts in Amazon Lightsail, and to create instance, database, and load balancer metric alarms that notify you based on the value of a metric relative to a threshold that you specify.

Release v1.29.11 (2020-02-26)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release changes the RunInstances CLI and SDK's so that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker UpdateEndpoint API now supports retained variant properties, e.g., instance count, variant weight. SageMaker ListTrials API filter by TrialComponentName. Make ExperimentConfig name length limits consistent with CreateExperiment, CreateTrial, and CreateTrialComponent APIs.
* `service/securityhub`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

Release v1.29.10 (2020-02-25)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/outposts`: Updates service API and documentation
* `service/secretsmanager`: Updates service API and documentation
  * This release increases the maximum allowed size of SecretString or SecretBinary from 10KB to 64KB in the CreateSecret, UpdateSecret, PutSecretValue and GetSecretValue APIs.
* `service/states`: Updates service API and documentation
  * This release adds support for CloudWatch Logs for Standard Workflows.

Release v1.29.9 (2020-02-24)
===

### Service Client Updates
* `service/docdb`: Updates service documentation
  * Documentation updates for docdb
* `service/eventbridge`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * This release allows you to create and manage tags for event buses.
* `service/fsx`: Updates service API and documentation
  * Announcing persistent file systems for Amazon FSx for Lustre that are ideal for longer-term storage and workloads, and a new generation of scratch file systems that offer higher burst throughput for spiky workloads.
* `service/iotevents`: Updates service documentation
* `service/snowball`: Updates service API and documentation
  * AWS Snowball adds a field for entering your GSTIN when creating AWS Snowball jobs in the Asia Pacific (Mumbai) region.

Release v1.29.8 (2020-02-21)
===

### Service Client Updates
* `service/imagebuilder`: Updates service API and documentation
* `service/redshift`: Updates service API and documentation
  * Extend elastic resize to support resizing clusters to different instance types.
* `service/wafv2`: Updates service API and documentation

Release v1.29.7 (2020-02-20)
===

### Service Client Updates
* `service/appconfig`: Updates service API and documentation
* `service/pinpoint`: Updates service API
  * As of this release of the Amazon Pinpoint API, the Title property is optional for the CampaignEmailMessage object.
* `service/savingsplans`: Updates service API

Release v1.29.6 (2020-02-19)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Doc update for EC2 Auto Scaling: Add Enabled parameter for PutScalingPolicy
* `service/lambda`: Updates service API, documentation, and examples
  * AWS Lambda now supports Ruby 2.7
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * "ListPortfolioAccess" API now has a new optional parameter "OrganizationParentId". When it is provided and if the portfolio with the "PortfolioId" given was shared with an organization or organizational unit with "OrganizationParentId", all accounts in the organization sub-tree under parent which inherit an organizational portfolio share will be listed, rather than all accounts with external shares. To accommodate long lists returned from the new option, the API now supports pagination.

Release v1.29.5 (2020-02-18)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling now supports the ability to enable/disable target tracking, step scaling, and simple scaling policies.
* `service/chime`: Updates service API and documentation
  * Added AudioFallbackUrl to support Chime SDK client.
* `service/rds`: Updates service API and documentation
  * This release supports Microsoft Active Directory authentication for Amazon Aurora.

Release v1.29.4 (2020-02-17)
===

### Service Client Updates
* `service/cloud9`: Updates service API and documentation
  * AWS Cloud9 now supports the ability to tag Cloud9 development environments.
* `service/ec2`: Updates service API and documentation
  * Documentation updates for EC2
* `service/rekognition`: Updates service API, documentation, and paginators
  * This update adds the ability to detect text in videos and adds filters to image and video text detection.
* ` service/dynamodb`: Add feature update for Amazon DynamoDB
  * Amazon DynamoDB enables you to restore your DynamoDB backup or table data across AWS Regions such that the restored table is created in a different AWS Region from where the source table or backup resides. You can do cross-region restores between AWS commercial Regions, AWS China Regions, and AWS GovCloud (US) Regions.

Release v1.29.3 (2020-02-14)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * You can now enable Multi-Attach on Provisioned IOPS io1 volumes through the create-volume API.
* `service/mediatailor`: Updates service API and documentation
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/shield`: Updates service API and documentation
  * This release adds support for associating Amazon Route 53 health checks to AWS Shield Advanced protected resources.

### SDK Enhancements
* `aws/credentials`: Add support for context when getting credentials.
  * Adds `GetWithContext` to `Credentials` that allows canceling getting the credentials if the context is canceled, or times out. This fixes an issue where API operations would ignore their provide context when waiting for credentials to refresh.
  * Related to [#3127](https://github.com/aws/aws-sdk-go/pull/3127).

Release v1.29.2 (2020-02-13)
===

### Service Client Updates
* `service/mediapackage-vod`: Updates service API and documentation

Release v1.29.1 (2020-02-12)
===

### Service Client Updates
* `service/chime`: Updates service documentation
  * Documentation updates for Amazon Chime
* `service/ds`: Updates service API and documentation
  * Release to add the ExpirationDateTime as an output to ListCertificates so as to ease customers to look into their certificate lifetime and make timely decisions about renewing them.
* `service/ec2`: Updates service API and documentation
  * This release adds support for tagging public IPv4 pools.
* `service/es`: Updates service API and documentation
  * Amazon Elasticsearch Service now offers fine-grained access control, which adds multiple capabilities to give tighter control over data. New features include the ability to use roles to define granular permissions for indices, documents, or fields and to extend Kibana with read-only views and secure multi-tenant support.
* `service/glue`: Updates service API and documentation
  * Adding ability to add arguments that cannot be overridden to AWS Glue jobs
* `service/neptune`: Updates service API and documentation
  * This launch enables Neptune start-db-cluster and stop-db-cluster. Stopping and starting Amazon Neptune clusters helps you manage costs for development and test environments. You can temporarily stop all the DB instances in your cluster, instead of setting up and tearing down all the DB instances each time that you use the cluster.
* `service/workmail`: Updates service API and documentation
  * This release adds support for access control rules management  in Amazon WorkMail.

### SDK Enhancements
* `aws/credentials`: Add grouping of concurrent refresh of credentials ([#3127](https://github.com/aws/aws-sdk-go/pull/3127/)
  * Concurrent calls to `Credentials.Get` are now grouped in order to prevent numerous synchronous calls to refresh the credentials. Replacing the mutex with a singleflight reduces the overall amount of time request signatures need to wait while retrieving credentials. This is improvement becomes pronounced when many requests are being made concurrently.

Release v1.29.0 (2020-02-11)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * This release of AWS CloudFormation StackSets allows you to centrally manage deployments to all the accounts in your organization or specific organizational units (OUs) in AWS Organizations. You will also be able to enable automatic deployments to any new accounts added to your organization or OUs. The permissions needed to deploy across accounts will automatically be taken care of by the StackSets service.
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 Now Supports Tagging Spot Fleet.

### SDK Features
* Remove SDK's `vendor` directory of vendored dependencies
  * Updates the SDK's Go module definition to enumerate all dependencies of the SDK and its components. 
  * SDK's repository root package has been updated to refer to runtime dependencies like `go-jmespath` for `go get` the SDK with Go without modules.
* Deletes the deprecated `awsmigrate` utility from the SDK's repository.
  * This utility is no longer relevant. The utility allowed users the beta pre-release v0 SDK to update to the v1.0 released version of the SDK.

Release v1.28.14 (2020-02-10)
===

### Service Client Updates
* `service/docdb`: Updates service documentation
  * Added clarifying information that Amazon DocumentDB shares operational technology with Amazon RDS and Amazon Neptune.
* `service/kms`: Updates service API and documentation
  * The ConnectCustomKeyStore API now provides a new error code (SUBNET_NOT_FOUND) for customers to better troubleshoot if their "connect-custom-key-store" operation fails.

Release v1.28.13 (2020-02-07)
===

### Service Client Updates
* `service/imagebuilder`: Updates service API and documentation
* `service/rds`: Updates service documentation
  * Documentation updates for RDS: when restoring a DB cluster from a snapshot, must create DB instances
* `service/robomaker`: Updates service API, documentation, and paginators

Release v1.28.12 (2020-02-06)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild adds support for Amazon Elastic File Systems
* `service/ebs`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * This release adds platform details and billing info to the DescribeImages API.
* `service/ecr`: Updates service documentation
  * This release contains updated text for the GetAuthorizationToken API.
* `service/lex-models`: Updates service API, documentation, and examples

Release v1.28.11 (2020-02-05)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release provides support for tagging when you create a VPC endpoint, or VPC endpoint service.
* `service/forecastquery`: Updates service API and documentation
* `service/groundstation`: Updates service API, documentation, paginators, and examples
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for fine-tuned QVBR quality level.
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation-only update that adds services to the list of supported services.
* `service/securityhub`: Updates service API and documentation

Release v1.28.10 (2020-02-04)
===

### Service Client Updates
* `service/cloudfront`: Updates service documentation
  * Documentation updates for CloudFront
* `service/ec2`: Updates service API and documentation
  * Amazon VPC Flow Logs adds support for 1-minute aggregation intervals.
* `service/iot`: Updates service API
  * Updated ThrottlingException documentation to report that the error code is 400, and not 429, to reflect actual system behaviour.
* `service/kafka`: Updates service API, documentation, and paginators
* `service/ssm`: Updates service API and documentation
  * This feature ensures that an instance is patched up to the available patches on a particular date. It can be enabled by selecting the 'ApproveUntilDate' option as the auto-approval rule while creating the patch baseline. ApproveUntilDate - The cutoff date for auto approval of released patches. Any patches released on or before this date will be installed automatically.
* `service/storagegateway`: Updates service API
  * Adding KVM as a support hypervisor
* `service/workmail`: Updates service API and documentation
  * This release adds support for tagging Amazon WorkMail organizations.

### SDK Enhancements
* `aws/request`: Add support for EC2 specific throttle exception code
  * Adds support for the EC2ThrottledException throttling exception code. The SDK will now treat this error code as throttling.

### SDK Bugs
* `aws/request`: Fixes an issue where the HTTP host header did not reflect changes to the endpoint URL ([#3102](https://github.com/aws/aws-sdk-go/pull/3102))
  * Fixes [#3093](https://github.com/aws/aws-sdk-go/issues/3093)

Release v1.28.9 (2020-01-24)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release provides support for tagging Amazon ECS task sets for services using external deployment controllers.
* `service/eks`: Updates service API
* `service/opsworkscm`: Updates service documentation
  * AWS OpsWorks for Chef Automate now supports in-place upgrade to Chef Automate 2. Eligible servers can be updated through the management console, CLI and APIs.
* `service/workspaces`: Updates service documentation
  * Documentation updates for WorkSpaces

Release v1.28.8 (2020-01-23)
===

### Service Client Updates
* `service/iam`: Updates service API and documentation
  * This release enables the Identity and Access Management policy simulator to simulate permissions boundary policies.
* `service/rds`: Updates service API, documentation, and paginators
  * This SDK release introduces APIs that automate the export of Amazon RDS snapshot data to Amazon S3. The new APIs include: StartExportTask, CancelExportTask, DescribeExportTasks. These APIs automate the extraction of data from an RDS snapshot and export it to an Amazon S3 bucket. The data is stored in a compressed, consistent, and query-able format. After the data is exported, you can query it directly using tools such as Amazon Athena or Redshift Spectrum. You can also consume the data as part of a data lake solution. If you archive the data in S3 Infrequent Access or Glacier, you can reduce long term data storage costs by applying data lifecycle policies.

### SDK Bugs
* Fix generated errors for some JSON APIs not including a message ([#3089](https://github.com/aws/aws-sdk-go/issues/3089))
  * Fixes the SDK's generated errors to all include the `Message` member regardless if it was modeled on the error shape. This fixes the bug identified in #3088 where some JSON errors were not modeled with the Message member.

Release v1.28.7 (2020-01-21)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * AWS CodePipeline enables an ability to stop pipeline executions.
* `service/discovery`: Updates service documentation
  * Documentation updates for the AWS Application Discovery Service.
* `service/ec2`: Updates service API
  * Add an enum value to the result of DescribeByoipCidrs to support CIDRs that are not publicly advertisable.
* `service/iotevents`: Updates service documentation
* `service/marketplacecommerceanalytics`: Updates service documentation
  * Remove 4 deprecated data sets, change some data sets available dates to 2017-09-15

Release v1.28.6 (2020-01-20)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/application-insights`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * This release provides support for a preview of bringing your own IPv6 addresses (BYOIP for IPv6) for use in AWS.
* `service/kms`: Updates service API and documentation
  * The ConnectCustomKeyStore operation now provides new error codes (USER_LOGGED_IN and USER_NOT_FOUND) for customers to better troubleshoot if their connect custom key store operation fails. Password length validation during CreateCustomKeyStore now also occurs on the client side.
* `service/lambda`: Updates service API and documentation
  * Added reason codes to StateReasonCode (InvalidSubnet, InvalidSecurityGroup) and LastUpdateStatusReasonCode (SubnetOutOfIPAddresses, InvalidSubnet, InvalidSecurityGroup) for functions that connect to a VPC.
* `service/monitoring`: Updates service API and documentation
  * Updating DescribeAnomalyDetectors API to return AnomalyDetector Status value in response.

### SDK Bugs
* `service/dynamodb/expression`: Allow AttributeValue as a value to BuildOperand. ([#3057](https://github.com/aws/aws-sdk-go/pull/3057))
  * This change fixes the SDK's behavior with DynamoDB Expression builder to not double marshal AttributeValues when used as BuildOperands, `Value` type. The AttributeValue will be used in the expression as the specific value set in the AttributeValue, instead of encoded as another AttributeValue.

Release v1.28.5 (2020-01-17)
===

### Service Client Updates
* `service/batch`: Updates service documentation
  * This release ensures INACTIVE job definitions are permanently deleted after 180 days.
* `service/cloudhsmv2`: Updates service API and documentation
  * This release introduces resource-level and tag-based access control for AWS CloudHSM resources. You can now tag CloudHSM backups, tag CloudHSM clusters on creation, and tag a backup as you copy it to another region.
* `service/ecs`: Updates service API, documentation, and paginators
  * This release provides a public preview for specifying Amazon EFS file systems as volumes in your Amazon ECS task definitions.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for MP3 audio only outputs.
* `service/neptune`: Updates service API and documentation
  * This release includes Deletion Protection for Amazon Neptune databases.
* `service/redshift`: Updates service documentation
  * Documentation updates for redshift

Release v1.28.4 (2020-01-16)
===

### Service Client Updates
* `service/ds`: Updates service API
  * To reduce the number of errors our customers are facing, we have modified the requirements of input parameters for two of Directory Service APIs.
* `service/ec2`: Updates service API and documentation
  * Client VPN now supports Port Configuration for VPN Endpoints, allowing usage of either port 443 or port 1194.
* `service/sagemaker`: Updates service API and documentation
  * This release adds two new APIs (UpdateWorkforce and DescribeWorkforce) to SageMaker Ground Truth service for workforce IP whitelisting.

Release v1.28.3 (2020-01-15)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * General Update to EC2 Docs and SDKs
* `service/organizations`: Updates service documentation
  * Updated description for PolicyID parameter and ConstraintViolationException.
* `service/securityhub`: Updates service API and documentation
* `service/ssm`: Updates service documentation
  * Document updates for Patch Manager 'NoReboot' feature.

### SDK Enhancements
* `service/s3/s3crypto`: Added X-Ray support to encrypt/decrypt clients ([#2912](https://github.com/aws/aws-sdk-go/pull/2912))
  * Adds support for passing Context down to the crypto client's KMS client enabling tracing for tools like X-Ray, and metrics.

Release v1.28.2 (2020-01-14)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for partition placement groups and instance metadata option in Launch Templates

Release v1.28.1 (2020-01-13)
===

### Service Client Updates
* `service/backup`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service documentation
  * Documentation updates for the StopInstances API. You can now stop and start an Amazon EBS-backed Spot Instance at will, instead of relying on the Stop interruption behavior to stop your Spot Instances when interrupted.
* `service/elasticfilesystem`: Updates service API, documentation, and paginators
  * This release adds support for managing EFS file system policies and EFS Access Points.

Release v1.28.0 (2020-01-10)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Add shared profile support to new and existing users
* `service/ec2`: Updates service API and documentation
  * This release introduces the ability to tag egress only internet gateways, local gateways, local gateway route tables, local gateway virtual interfaces, local gateway virtual interface groups, local gateway route table VPC association and local gateway route table virtual interface group association. You can use tags to organize and identify your resources for cost allocation.
* `service/rds`: Updates service API and documentation
  * This release adds an operation that enables users to override the system-default SSL/TLS certificate for new Amazon RDS DB instances temporarily, or remove the customer override.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker ListTrialComponents API filter by TrialName and ExperimentName.
* `service/transfer`: Updates service API and documentation
  * This release introduces a new endpoint type that allows you to attach Elastic IP addresses from your AWS account with your server's endpoint directly and whitelist access to your server by client's internet IP address(es) using VPC Security Groups.
* `service/workspaces`: Updates service API and documentation
  * Added the migrate feature to Amazon WorkSpaces.

### SDK Features
* Add generated error types for JSONRPC and RESTJSON APIs
  * Adds generated error types for APIs using JSONRPC and RESTJSON protocols. This allows you to retrieve additional error metadata within an error message that was previously unavailable. For example, Amazon DynamoDB's TransactWriteItems operation can return a `TransactionCanceledException` continuing detailed `CancellationReasons` member. This data is now available by type asserting the error returned from the operation call to `TransactionCanceledException` type.
* `service/dynamodb/dynamodbattribute`: Go 1.9+, Add caching of struct serialization ([#3070](https://github.com/aws/aws-sdk-go/pull/3070))
  * For Go 1.9 and above, adds struct field caching to the SDK's DynamoDB AttributeValue marshalers and unmarshalers. This significantly reduces time, and overall allocations of the (un)marshalers by caching the reflected structure's fields. This should improve the performance of applications using DynamoDB AttributeValue (un)marshalers.

### SDK Bugs
* `service/s3/s3manager`: Fix resource leak on failed CreateMultipartUpload calls ([#3069](https://github.com/aws/aws-sdk-go/pull/3069))
  * Fixes [#3000](https://github.com/aws/aws-sdk-go/issues/3000), [#3035](https://github.com/aws/aws-sdk-go/issues/3035)

Release v1.27.4 (2020-01-09)
===

### Service Client Updates
* `service/logs`: Updates service documentation
  * Documentation updates for logs
* `service/sts`: Updates service examples
  * Documentation updates for sts

Release v1.27.3 (2020-01-08)
===

### Service Client Updates
* `service/ce`: Updates service documentation
* `service/fms`: Updates service API and documentation
* `service/translate`: Updates service API, documentation, and paginators

Release v1.27.2 (2020-01-07)
===

### Service Client Updates
* `service/AWSMigrationHub`: Updates service API, documentation, and paginators
* `service/codebuild`: Updates service API and documentation
  * Add encryption key override to StartBuild API in AWS CodeBuild.
* `service/xray`: Updates service documentation
  * Documentation updates for xray

### SDK Enhancements
* `aws`: Add configuration option enable the SDK to unmarshal API response header maps to normalized lower case map keys. ([#3033](https://github.com/aws/aws-sdk-go/pull/3033))
  * Setting `aws.Config.LowerCaseHeaderMaps` to `true` will result in S3's X-Amz-Meta prefixed header to be unmarshaled to lower case Metadata member's map keys.

### SDK Bugs
* `aws/ec2metadata` : Reduces request timeout for EC2Metadata client along with maximum number of retries ([#3066](https://github.com/aws/aws-sdk-go/pull/3066))
  * Reduces latency while fetching response from EC2Metadata client running in a container to around 3 seconds
  * Fixes [#2972](https://github.com/aws/aws-sdk-go/issues/2972)

Release v1.27.1 (2020-01-06)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release supports service providers configuring a private DNS name for services other than AWS services and services available in the AWS marketplace. This feature allows consumers to access the service using an existing DNS name without making changes to their applications.
* `service/mediapackage`: Updates service API and documentation
  * You can now restrict direct access to AWS Elemental MediaPackage by securing requests for live content using CDN authorization. With CDN authorization, content requests require a specific HTTP header and authorization code.

### SDK Bugs
* `aws/session`: Fix client init not exposing endpoint resolve error ([#3059](https://github.com/aws/aws-sdk-go/pull/3059))
  * Fixes the SDK API clients not surfacing endpoint resolution errors, when the EndpointResolver is unable to resolve an endpoint for the client and region.

Release v1.27.0 (2020-01-02)
===

### Service Client Updates
* `service/ce`: Updates service documentation
* `service/ecr`: Updates service waiters
  * Adds waiters for ImageScanComplete and LifecyclePolicyPreviewComplete
* `service/lex-models`: Updates service documentation
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Certificate Authority (CA) certificate identifier to managed databases in Amazon Lightsail.

### SDK Features
* `services/transcribestreamingservice`: Support for Amazon Transcribe Streaming ([#3048](https://github.com/aws/aws-sdk-go/pull/3048))
  * The SDK now supports the Amazon Transcribe Streaming APIs by utilizing event stream encoding over HTTP/2
  * See [Amazon Transcribe Developer Guide](https://docs.aws.amazon.com/transcribe/latest/dg)
  * Fixes [#2487](https://github.com/aws/aws-sdk-go/issues/2487)

Release v1.26.8 (2019-12-23)
===

### Service Client Updates
* `service/detective`: Updates service documentation
* `service/fsx`: Updates service API, documentation, and paginators
* `service/health`: Updates service API, documentation, and paginators
  * With this release, you can now centrally aggregate AWS Health events from all accounts in your AWS organization. Visit AWS Health documentation to learn more about enabling and using this feature: https://docs.aws.amazon.com/health/latest/ug/organizational-view-health.html.

Release v1.26.7 (2019-12-20)
===

### Service Client Updates
* `service/devicefarm`: Updates service API, documentation, and paginators
  * Introduced browser testing support through AWS Device Farm
* `service/ec2`: Updates service API and documentation
  * This release introduces the ability to tag key pairs, placement groups, export tasks, import image tasks, import snapshot tasks and export image tasks. You can use tags to organize and identify your resources for cost allocation.
* `service/eks`: Updates service API and documentation
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces versioning support for message templates.
* `service/rds`: Updates service API and documentation
  * This release adds an operation that enables users to specify whether a database is restarted when its SSL/TLS certificate is rotated. Only customers who do not use SSL/TLS should use this operation.
* `service/redshift`: Updates service documentation
  * Documentation updates for Amazon Redshift RA3 node types.
* `service/securityhub`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * This release updates the attachments support to include AttachmentReference source for Automation documents.
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.26.6 (2019-12-19)
===

### Service Client Updates
* `service/codestar-connections`: Adds new service
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * We are updating the supportedRootDevices field to supportedRootDeviceTypes for DescribeInstanceTypes API to ensure that the actual value is returned, correcting a previous error in the model.
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift now supports ARNs for all key GameLift resources, tagging for GameLift resource authorization management, and updated documentation that articulates GameLift's resource authorization strategy.
* `service/lex-models`: Updates service API and documentation
* `service/personalize-runtime`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * This release allows customers to add tags to Automation execution, enabling them to sort and filter executions in different ways, such as by resource, purpose, owner, or environment.
* `service/transcribe`: Updates service API and documentation

Release v1.26.5 (2019-12-18)
===

### Service Client Updates
* `service/cloudfront`: Updates service documentation
  * Documentation updates for CloudFront
* `service/ec2`: Updates service API and documentation
  * This release introduces the ability to tag Elastic Graphics accelerators. You can use tags to organize and identify your accelerators for cost allocation.
* `service/opsworkscm`: Updates service API and documentation
  * AWS OpsWorks CM now supports tagging, and tag-based access control, of servers and backups.
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates for resourcegroupstaggingapi
* `service/s3`: Updates service documentation
  * Updates Amazon S3 endpoints allowing you to configure your client to opt-in to using S3 with the us-east-1 regional endpoint, instead of global.

### SDK Bugs
* `aws/request`: Fix shouldRetry behavior for nested errors ([#3017](https://github.com/aws/aws-sdk-go/pull/3017))

Release v1.26.4 (2019-12-17)
===

### Service Client Updates
* `service/ec2`: Updates service documentation
  * Documentation updates for Amazon EC2
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS.
* `service/iot`: Updates service API and documentation
  * Added a new Over-the-Air (OTA) Update feature that allows you to use different, or multiple, protocols to transfer an image from the AWS cloud to IoT devices.
* `service/kinesisanalyticsv2`: Updates service API
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports HLS ID3 segment tagging, HLS redundant manifests for CDNs that support different publishing/viewing endpoints, fragmented MP4 (fMP4), and frame capture intervals specified in milliseconds.
* `service/ssm`: Updates service API and documentation
  * Added support for Cloud Watch Output and Document Version to the Run Command tasks in Maintenance Windows.

Release v1.26.3 (2019-12-16)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * You can now configure your EC2 Fleet to preferentially use EC2 Capacity Reservations for launching On-Demand instances, enabling you to fully utilize the available (and unused) Capacity Reservations before launching On-Demand instances on net new capacity.
* `service/mq`: Updates service API and documentation
  * Amazon MQ now supports throughput-optimized message brokers, backed by Amazon EBS.

Release v1.26.2 (2019-12-13)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild adds support for cross account
* `service/detective`: Adds new service
* `service/sesv2`: Updates service API and documentation

Release v1.26.1 (2019-12-12)
===

### Service Client Updates
* `service/accessanalyzer`: Updates service API and documentation

### SDK Bugs
* `service/s3/s3crypto`: Fixes a bug where `gcmEncryptReader` and `gcmDecryptReader` would return an invalid number of bytes as having been read. ([#3005](https://github.com/aws/aws-sdk-go/pull/3005))
  * Fixes [#2999](https://github.com/aws/aws-sdk-go/issues/2999)

Release v1.26.0 (2019-12-11)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release allows customers to attach multiple Elastic Inference Accelerators to a single EC2 instance. It adds support for a Count parameter for each Elastic Inference Accelerator type you specify on the RunInstances and LaunchTemplate APIs.

### SDK Features

* `aws/credentials/stscreds`: Add support for session tags to `AssumeRoleProvider` ([#2993](https://github.com/aws/aws-sdk-go/pull/2993))
  * Adds support for session tags to the AssumeRoleProvider. This feature is used to enable modeling Attribute Based Access Control (ABAC) on top of AWS IAM Policies, User and Roles.
  * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html

### SDK Enhancements
* `aws/request`: Adds `ThrottledException` to the list of retryable request exceptions ([#3006](https://github.com/aws/aws-sdk-go/pull/3006))

Release v1.25.50 (2019-12-10)
===

### Service Client Updates
* `service/kendra`: Updates service API and documentation
  * 1. Adding DocumentTitleFieldName as an optional configuration for SharePoint. 2. updating s3 object pattern to  support all s3 keys.

Release v1.25.49 (2019-12-09)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/kms`: Updates service API and documentation
  * The Verify operation now returns KMSInvalidSignatureException on invalid signatures. The Sign and Verify operations now return KMSInvalidStateException when a request is made against a CMK pending deletion.
* `service/quicksight`: Updates service documentation
  * Documentation updates for QuickSight
* `service/ssm`: Updates service API and documentation
  * Adds the SSM GetCalendarState API and ChangeCalendar SSM Document type. These features enable the forthcoming Systems Manager Change Calendar feature, which will allow you to schedule events during which actions should (or should not) be performed.

### SDK Bugs
* `service/s3`: Fix SDK support for Accesspoint ARNs with slash in resource ([#3001](https://github.com/aws/aws-sdk-go/pull/3001))
  * Fixes the SDK's handling of S3 Accesspoint ARNs to correctly parse ARNs with slashes in the resource component as valid. Previously the SDK's ARN parsing incorrectly identify ARN resources with slash delimiters as invalid ARNs.

Release v1.25.48 (2019-12-05)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
  * Amazon API Gateway now supports HTTP APIs (beta), enabling customers to quickly build high performance RESTful APIs that are up to 71% cheaper than REST APIs also available from API Gateway. HTTP APIs are optimized for building APIs that proxy to AWS Lambda functions or HTTP backends, making them ideal for serverless workloads. Using HTTP APIs, you can secure your APIs using OIDC and OAuth 2 out of box, quickly build web applications using a simple CORS experience, and get started immediately with automatic deployment and simple create workflows.
* `service/kinesis-video-signaling`: Adds new service
* `service/kinesisvideo`: Updates service API, documentation, and paginators
  * Introduces management of signaling channels for Kinesis Video Streams.

Release v1.25.47 (2019-12-04)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/ebs`: Adds new service
* `service/lambda`: Updates service API, documentation, and paginators
  * - Added the ProvisionedConcurrency type and operations. Allocate provisioned concurrency to enable your function to scale up without fluctuations in latency. Use PutProvisionedConcurrencyConfig to configure provisioned concurrency on a version of a function, or on an alias.
* `service/rds`: Updates service API, documentation, and paginators
  * This release adds support for the Amazon RDS Proxy
* `service/rekognition`: Updates service API, documentation, waiters, and paginators
  * This SDK Release introduces APIs for Amazon Rekognition Custom Labels feature (CreateProjects, CreateProjectVersion,DescribeProjects, DescribeProjectVersions, StartProjectVersion, StopProjectVersion and DetectCustomLabels).  Also new is  AugmentedAI (Human In The Loop) Support for DetectModerationLabels in Amazon Rekognition.
* `service/sagemaker`: Updates service API, documentation, waiters, and paginators
  * You can now use SageMaker Autopilot for automatically training and tuning candidate models using a combination of various feature engineering, ML algorithms, and hyperparameters determined from the user's input data. SageMaker Automatic Model Tuning now supports tuning across multiple algorithms. With Amazon SageMaker Experiments users can create Experiments, ExperimentTrials, and ExperimentTrialComponents to track, organize, and evaluate their ML training jobs. With Amazon SageMaker Debugger, users can easily debug training jobs using a number of pre-built rules provided by Amazon SageMaker, or build custom rules. With Amazon SageMaker Processing, users can run on-demand, distributed, and fully managed jobs for data pre- or post- processing or model evaluation. With Amazon SageMaker Model Monitor, a user can create MonitoringSchedules to automatically monitor endpoints to detect data drift and other issues and get alerted on them. This release also includes the preview version of Amazon SageMaker Studio with Domains, UserProfiles, and Apps. This release also includes the preview version of Amazon Augmented AI to easily implement human review of machine learning predictions by creating FlowDefinitions, HumanTaskUis, and HumanLoops.
* `service/states`: Updates service API and documentation
  * This release of the AWS Step Functions SDK introduces support for Express Workflows.

Release v1.25.46 (2019-12-03)
===

### Service Client Updates
* `service/codeguru-reviewer`: Adds new service
* `service/codeguruprofiler`: Adds new service
* `service/compute-optimizer`: Adds new service
* `service/ec2`: Updates service API and documentation
  * This release adds support for the following features: 1. An option to enable acceleration for Site-to-Site VPN connections, to improve connection performance by leveraging AWS Global Accelerator; 2. Inf1 instances featuring up to 16 AWS Inferentia chips, custom-built for ML inference applications to deliver low latency and high throughput performance. Use Inf1 instances to run high scale ML inference applications such as image recognition, speech recognition, natural language processing, personalization, and fraud detection at the lowest cost in the cloud. Inf1 instances will soon be available for use with Amazon SageMaker, Amazon EKS and Amazon ECS. To get started, see https://aws.amazon.com/ec2/instance-types/Inf1; 3. The ability to associate route tables with internet gateways and virtual private gateways, and define routes to insert network and security virtual appliances in the path of inbound and outbound traffic. For more information on Amazon VPC Ingress Routing, see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#gateway-route-table; 4. AWS Local Zones that place compute, storage, database, and other select services closer to you for applications that require very low latency to your end-users. AWS Local Zones also allow you to seamlessly connect to the full range of services in the AWS Region through the same APIs and tool sets; 5. Launching and viewing EC2 instances and EBS volumes running locally in Outposts. This release also introduces a new local gateway (LGW) with Outposts to enable connectivity between Outposts and local on-premises networks as well as the internet; 6. Peering Transit Gateways between regions simplifying creation of secure and private global networks on AWS; 7. Transit Gateway Multicast, enabling multicast routing within and between VPCs using Transit Gateway as a multicast router.
* `service/ecs`: Updates service API, documentation, and paginators
  * This release supports ECS Capacity Providers, Fargate Spot, and ECS Cluster Auto Scaling.  These features enable new ways for ECS to manage compute capacity used by tasks.
* `service/eks`: Updates service API, documentation, and paginators
* `service/es`: Updates service API and documentation
  * UltraWarm storage provides a cost-effective way to store large amounts of read-only data on Amazon Elasticsearch Service. Rather than attached storage, UltraWarm nodes use Amazon S3 and a sophisticated caching solution to improve performance. For indices that you are not actively writing to and query less frequently, UltraWarm storage offers significantly lower costs per GiB. In Elasticsearch, these warm indices behave just like any other index. You can query them using the same APIs or use them to create dashboards in Kibana.
* `service/frauddetector`: Adds new service
* `service/kendra`: Adds new service
  * It is a preview launch of Amazon Kendra. Amazon Kendra is a managed, highly accurate and easy to use enterprise search service that is powered by machine learning.
* `service/networkmanager`: Adds new service
* `service/outposts`: Adds new service
* `service/s3`: Updates service documentation and examples
  * Amazon S3 Access Points is a new S3 feature that simplifies managing data access at scale for shared data sets on Amazon S3. Access Points provide a customizable way to access the objects in a bucket, with a unique hostname and access policy that enforces the specific permissions and network controls for any request made through the access point. This represents a new way of provisioning access to shared data sets.
* `service/s3control`: Updates service documentation
  * Amazon S3 Access Points is a new S3 feature that simplifies managing data access at scale for shared data sets on Amazon S3. Access Points provide a customizable way to access the objects in a bucket, with a unique hostname and access policy that enforces the specific permissions and network controls for any request made through the access point. This represents a new way of provisioning access to shared data sets.
* `service/sagemaker-a2i-runtime`: Adds new service
* `service/textract`: Updates service API and documentation

### SDK Enhancements
* `service/s3`: Add support for Access Point resources
  * Adds support for using Access Point resource with Amazon S3 API operation calls. The Access Point resource are identified by an Amazon Resource Name (ARN).
  * To make operation calls to an S3 Access Point instead of a S3 Bucket, provide the Access Point ARN string as the value of the Bucket parameter. You can create an Access Point for your bucket with the Amazon S3 Control API. The Access Point ARN can be obtained from the S3 Control API. You should avoid building the ARN directly.

Release v1.25.45 (2019-12-02)
===

### Service Client Updates
* `service/accessanalyzer`: Adds new service

Release v1.25.44 (2019-12-02)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * AWS now provides a new BYOL experience for software licenses, such as Windows and SQL Server, that require a dedicated physical server. You can now enjoy the flexibility and cost effectiveness of using your own licenses on Amazon EC2 Dedicated Hosts, but with the simplicity, resiliency, and elasticity of AWS. You can specify your Dedicated Host management preferences, such as host allocation, host capacity utilization, and instance placement in AWS License Manager.  Once set up, AWS takes care of these administrative tasks on your behalf, so that you can seamlessly launch virtual machines (instances) on Dedicated Hosts just like you would launch an EC2 instance with AWS provided licenses.
* `service/imagebuilder`: Adds new service
* `service/license-manager`: Updates service API and documentation
* `service/schemas`: Adds new service

Release v1.25.43 (2019-11-26)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/ds`: Updates service API and documentation
  * This release will introduce optional encryption over LDAP network traffic using SSL certificates between customer's self-managed AD and AWS Directory Services instances. The release also provides APIs for Certificate management.
* `service/dynamodb`: Updates service API, documentation, and paginators
  * 1) Amazon Contributor Insights for Amazon DynamoDB is a diagnostic tool for identifying frequently accessed keys and understanding database traffic trends. 2) Support for displaying new fields when a table's encryption state is Inaccessible or the table have been Archived.
* `service/elastic-inference`: Adds new service
* `service/mediatailor`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * Introduces the DescribeEffectivePolicy action, which returns the contents of the policy that's in effect for the account.
* `service/quicksight`: Updates service documentation
  * Documentation updates for QuickSight
* `service/rds-data`: Updates service API and documentation
* `service/resourcegroupstaggingapi`: Updates service API, documentation, and paginators
  * You can use tag policies to help standardize on tags across your organization's resources.
* `service/serverlessrepo`: Updates service API and documentation
* `service/workspaces`: Updates service API and documentation
  * For the WorkspaceBundle API, added the image identifier and the time of the last update.

Release v1.25.42 (2019-11-25)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/appconfig`: Adds new service
* `service/application-autoscaling`: Updates service API and documentation
* `service/application-insights`: Updates service API, documentation, and paginators
* `service/athena`: Updates service API and documentation
  * This release adds additional query lifecycle metrics to the QueryExecutionStatistics object in GetQueryExecution response.
* `service/ce`: Updates service API and documentation
* `service/codebuild`: Updates service API and documentation
  * CodeBuild adds support for test reporting
* `service/cognito-idp`: Updates service API
* `service/comprehend`: Updates service API and documentation
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds two new APIs: 1. ModifyDefaultCreditSpecification, which allows you to set default credit specification at the account level per AWS Region, per burstable performance instance family, so that all new burstable performance instances in the account launch using the new default credit specification. 2. GetDefaultCreditSpecification, which allows you to get current default credit specification per AWS Region, per burstable performance instance family. This release also adds new client exceptions for StartInstances and StopInstances.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/greengrass`: Updates service API and documentation
  * IoT Greengrass supports machine learning resources in 'No container' mode.
* `service/iot`: Updates service API and documentation
  * This release adds: 1) APIs for fleet provisioning claim and template, 2) endpoint configuration and custom domains, 3) support for enhanced custom authentication, d) support for 4 additional audit checks: Device and CA certificate key quality checks, IoT role alias over-permissive check and IoT role alias access to unused services check, 5) extended capability of AWS IoT Rules Engine to support IoT SiteWise rule action. The IoT SiteWise rule action lets you send messages from IoT sensors and applications to IoT SiteWise asset properties
* `service/iotsecuretunneling`: Adds new service
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/kms`: Updates service API and documentation
  * AWS Key Management Service (KMS) now enables creation and use of asymmetric Customer Master Keys (CMKs) and the generation of asymmetric data key pairs.
* `service/lambda`: Updates service API, documentation, waiters, and paginators
  * Added the function state and update status to the output of GetFunctionConfiguration and other actions. Check the state information to ensure that a function is ready before you perform operations on it. Functions take time to become ready when you connect them to a VPC.Added the EventInvokeConfig type and operations to configure error handling options for asynchronous invocation. Use PutFunctionEventInvokeConfig to configure the number of retries and the maximum age of events when you invoke the function asynchronously.Added on-failure and on-success destination settings for asynchronous invocation. Configure destinations to send an invocation record to an SNS topic, an SQS queue, an EventBridge event bus, or a Lambda function.Added error handling options to event source mappings. This enables you to configure the number of retries, configure the maximum age of records, or retry with smaller batches when an error occurs when a function processes a Kinesis or DynamoDB stream.Added the on-failure destination setting to event source mappings. This enables you to send discarded events to an SNS topic or SQS queue when all retries fail or when the maximum record age is exceeded when a function processes a Kinesis or DynamoDB stream.Added the ParallelizationFactor option to event source mappings to increase concurrency per shard when a function processes a Kinesis or DynamoDB stream.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for 8K outputs and support for QuickTime Animation Codec (RLE) inputs.
* `service/medialive`: Updates service API, documentation, waiters, and paginators
  * AWS Elemental MediaLive now supports the ability to create a multiple program transport stream (MPTS).
* `service/mediapackage-vod`: Updates service API and documentation
* `service/monitoring`: Updates service API, documentation, and paginators
  * This release adds a new feature called "Contributor Insights". "Contributor Insights" supports the following 6 new APIs (PutInsightRule, DeleteInsightRules, EnableInsightRules, DisableInsightRules, DescribeInsightRules and GetInsightRuleReport).
* `service/ram`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Cluster Endpoints can now be tagged by using --tags in the create-db-cluster-endpoint API
* `service/redshift`: Updates service API, documentation, and paginators
  * This release contains changes for 1. Redshift Scheduler 2. Update to the DescribeNodeConfigurationOptions to include a new action type recommend-node-config
* `service/runtime.lex`: Updates service API and documentation
* `service/sesv2`: Updates service API, documentation, and paginators
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager Documents now supports more Document Types: ApplicationConfiguration, ApplicationConfigurationSchema and DeploymentStrategy. This release also extends Document Permissions capabilities and introduces a new Force flag for DeleteDocument API.

### SDK Enhancements
* `aws/credentials/processcreds`: Increase the default max buffer size ([#2957](https://github.com/aws/aws-sdk-go/pull/2957))
  * Fixes [#2875](https://github.com/aws/aws-sdk-go/issues/2875)

Release v1.25.41 (2019-11-22)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * This release adds support for Tag-Based IAM for AWS Certificate Manager and adding tags to certificates upon creation.
* `service/application-autoscaling`: Updates service API
* `service/autoscaling-plans`: Updates service API
* `service/codebuild`: Updates service API and documentation
  * Add Canonical ARN to LogsLocation.
* `service/ec2`: Updates service API and documentation
  * This release adds two new APIs (DescribeInstanceTypes and DescribeInstanceTypeOfferings) that give customers access to instance type attributes and regional and zonal offerings.
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR adds support for concurrent step execution and cancelling running steps. Amazon EMR has added a new Outpost ARN field in the ListCluster and DescribeCluster API responses that is populated for clusters launched in an AWS Outpost subnet.
* `service/forecast`: Updates service API and documentation
* `service/mediapackage-vod`: Updates service API and documentation
* `service/rekognition`: Updates service API and documentation
  * This release adds enhanced face filtering support to the IndexFaces API operation, and introduces face filtering for CompareFaces and SearchFacesByImage API operations.
* `service/sns`: Updates service documentation
  * Added documentation for the dead-letter queue feature.
* `service/ssm`: Updates service API and documentation
  * Add RebootOption and LastNoRebootInstallOperationTime for DescribeInstancePatchStates and DescribeInstancePatchStatesForPatchGroup API
* `service/sts`: Updates service API, documentation, and examples
  * Support tagging for STS sessions and tag based access control for the STS APIs

### SDK Bugs
* `aws/ec2metadata`: Fix failing concurrency test for ec2metadata client ([#2960](https://github.com/aws/aws-sdk-go/pull/2960))
  * Fixes a resource leak  in ec2metadata client, where response body was not closed after reading

Release v1.25.40 (2019-11-21)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/appsync`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/connectparticipant`: Adds new service
* `service/dynamodb`: Updates service API and documentation
  * With this release, you can convert an existing Amazon DynamoDB table to a global table by adding replicas in other AWS Regions.
* `service/ec2`: Updates service API and documentation
  * This release adds support for attaching AWS License Manager Configurations to Amazon Machine Image (AMI) using ImportImage API; and adds support for running different instance sizes on EC2 Dedicated Hosts
* `service/glue`: Updates service API and documentation
  * This release adds support for Glue 1.0 compatible ML Transforms.
* `service/lex-models`: Updates service API and documentation
* `service/meteringmarketplace`: Updates service documentation
  * Documentation updates for the AWS Marketplace Metering Service.
* `service/runtime.lex`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * The release contains new API and API changes for AWS Systems Manager Explorer product.
* `service/transcribe`: Updates service API

Release v1.25.39 (2019-11-20)
===

### Service Client Updates
* `service/AWSMigrationHub`: Updates service API, documentation, and paginators
* `service/chime`: Updates service API, documentation, and paginators
  * Adds APIs to create and manage meeting session resources for the Amazon Chime SDK
* `service/cloudtrail`: Updates service API and documentation
  * 1. This release adds two new APIs, GetInsightSelectors and PutInsightSelectors, which let you configure CloudTrail Insights event delivery on a trail. An Insights event is a new type of event that is generated when CloudTrail detects unusual activity in your AWS account. In this release, only "ApiCallRateInsight" is a supported Insights event type. 2. This release also adds the new "ExcludeManagementEventSource" option to the existing PutEventSelectors API. This field currently supports only AWS Key Management Services.
* `service/codecommit`: Updates service API, documentation, and paginators
  * This release adds support for creating pull request approval rules and pull request approval rule templates in AWS CodeCommit. This allows developers to block merges of pull requests, contingent on the approval rules being satisfiied.
* `service/datasync`: Updates service API and documentation
* `service/discovery`: Updates service API and documentation
  * New exception type for use with Migration Hub home region
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API, documentation, waiters, and paginators
  * This release of Amazon Elastic Compute Cloud (Amazon EC2) introduces support for Amazon Elastic Block Store (Amazon EBS) fast snapshot restores.
* `service/ecs`: Updates service API and documentation
  * Added support for CPU and memory task-level overrides on the RunTask and StartTask APIs.  Added location information to Tasks.
* `service/firehose`: Updates service API and documentation
  * With this release, Amazon Kinesis Data Firehose allows server side encryption with customer managed CMKs. Customer managed CMKs ( "Customer Master Keys") are AWS Key Management Service (KMS) keys that are fully managed by the customer. With customer managed CMKs, customers can establish and maintain their key policies, IAM policies, rotating policies and add tags. For more information about AWS KMS and CMKs, please refer to:  https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html. Please refer to the following link to create CMKs: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html
* `service/fsx`: Updates service API and documentation
* `service/mediastore`: Updates service API and documentation
  * This release fixes a broken link in the SDK documentation.
* `service/migrationhub-config`: Adds new service
* `service/quicksight`: Updates service API, documentation, and paginators
  * Amazon QuickSight now supports programmatic creation and management of data sources, data sets, dashboards and templates with new APIs. Templates hold dashboard metadata, and can be used to create copies connected to the same or different dataset as required. Also included in this release are APIs for SPICE ingestions, fine-grained access control over AWS resources using AWS Identity and Access Management (IAM) policies, as well AWS tagging. APIs are supported for both Standard and Enterprise Edition, with edition-specific support for specific functionality.
* `service/s3`: Updates service API and documentation
  * This release introduces support for Amazon S3 Replication Time Control, a new feature of S3 Replication that provides a predictable replication time backed by a Service Level Agreement. S3 Replication Time Control helps customers meet compliance or business requirements for data replication, and provides visibility into the replication process with new Amazon CloudWatch Metrics.
* `service/storagegateway`: Updates service API and documentation
  * The new DescribeAvailabilityMonitorTest API provides the results of the most recent High Availability monitoring test. The new StartAvailabilityMonitorTest API verifies the storage gateway is configured for High Availability monitoring. The new ActiveDirectoryStatus response element has been added to the DescribeSMBSettings and JoinDomain APIs to indicate the status of the gateway after the most recent JoinDomain operation. The new TimeoutInSeconds parameter of the JoinDomain API allows for the configuration of the timeout in which the JoinDomain operation must complete.
* `service/transcribe`: Updates service API and documentation

Release v1.25.38 (2019-11-19)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling now supports Instance Weighting and Max Instance Lifetime. Instance Weighting allows specifying the capacity units for each instance type included in the MixedInstancesPolicy and how they would contribute to your application's performance. Max Instance Lifetime allows specifying the maximum length of time that an instance can be in service. If any instances are approaching this limit, Amazon EC2 Auto Scaling gradually replaces them.
* `service/cloudformation`: Updates service API and documentation
  * This release of AWS CloudFormation StackSets enables users to detect drift on a stack set and the stack instances that belong to that stack set.
* `service/codebuild`: Updates service API and documentation
  * Add support for ARM and GPU-enhanced build environments and a new SSD-backed Linux compute type with additional CPU and memory in CodeBuild
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for RunInstances to specify the metadata options for new instances; adds a new API, ModifyInstanceMetadataOptions, which lets you modify the metadata options for a running or stopped instance; and adds support for CreateCustomerGateway to specify a device name.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/iam`: Updates service API, documentation, and examples
  * IAM reports the timestamp when a role's credentials were last used to make an AWS request. This helps you identify unused roles and remove them confidently from your AWS accounts.
* `service/iot`: Updates service API and documentation
  * As part of this release, we are extending the capability of AWS IoT Rules Engine to send messages directly to customer's own web services/applications. Customers can now create topic rules with HTTP actions to route messages from IoT Core directly to URL's that they own. Ownership is proved by creating and confirming topic rule destinations.
* `service/lambda`: Updates service API
  * This release provides three new runtimes to support Node.js 12 (initially 12.13.0), Python 3.8 and Java 11.

### SDK Enhancements
* `aws/ec2metadata`: Adds support for EC2Metadata client to use secure tokens provided by the IMDS ([#2958](https://github.com/aws/aws-sdk-go/pull/2958))
  * Modifies and adds tests to verify the behavior of the EC2Metadata client.

Release v1.25.37 (2019-11-18)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/cloudformation`: Updates service API, documentation, waiters, and paginators
  * This release introduces APIs for the CloudFormation Registry, a new service to submit and discover resource providers with which you can manage third-party resources natively in CloudFormation.
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces support for using and managing message templates for messages that are sent through the voice channel. It also introduces support for specifying default values for message variables in message templates.
* `service/rds`: Updates service documentation
  * Documentation updates for rds
* `service/runtime.sagemaker`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * Added support for S3 Replication for existing objects. This release allows customers who have requested and been granted access to replicate existing S3 objects across buckets.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports multi-model endpoints to host multiple models on an endpoint using a single inference container.
* `service/ssm`: Updates service API and documentation
  * The release contains new API and API changes for AWS Systems Manager Explorer product.

Release v1.25.36 (2019-11-15)
===

### Service Client Updates
* `service/chime`: Updates service API, documentation, and paginators
  * This release adds support for Chime Room Management APIs
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * You can now add tags while copying snapshots. Previously, a user had to first copy the snapshot and then add tags to the copied snapshot manually. Moving forward, you can specify the list of tags you wish to be applied to the copied snapshot as a parameter on the Copy Snapshot API.
* `service/eks`: Updates service API, documentation, waiters, paginators, and examples
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/elasticmapreduce`: Updates service API and documentation
  * Access to the cluster ARN makes it easier for you to author resource-level permissions policies in AWS Identity and Access Management. To simplify the process of obtaining the cluster ARN, Amazon EMR has added a new field containing the cluster ARN to all API responses that include the cluster ID.
* `service/guardduty`: Updates service API, documentation, and paginators
  * This release includes new operations related to findings export, including: CreatePublishingDestination, UpdatePublishingDestination, DescribePublishingDestination, DeletePublishingDestination and ListPublishingDestinations.
* `service/logs`: Updates service documentation
  * Documentation updates for logs
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for DolbyVision encoding, and SCTE35 & ESAM insertion to DASH ISO EMSG.
* `service/ssm`: Updates service documentation
  * This release updates AWS Systems Manager Parameter Store documentation for the enhanced search capability.
* `service/workspaces`: Updates service API and documentation
  * Added APIs to register your directories with Amazon WorkSpaces and to modify directory details.

Release v1.25.35 (2019-11-14)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/connect`: Updates service API and documentation
* `service/meteringmarketplace`: Updates service API and documentation
  * Added CustomerNotEntitledException in MeterUsage API for Container use case.
* `service/personalize`: Updates service API, documentation, and paginators
* `service/ssm`: Updates service API and documentation
  * Updates support for adding attachments to Systems Manager Automation documents

### SDK Enhancements
* `aws/endpoints`: Add support for regional S3 us-east-1 endpoint
  * Adds support for S3 configuring an SDK Amazon S3 client for the regional us-east-1 endpoint instead of the default global S3 endpoint.
  * Adds a new configuration option, `S3UsEast1RegionalEndpoint` which when set to `RegionalS3UsEast1Endpoint`, and region is `us-east-1` the S3 client will resolve the `us-east-1` regional endpoint, `s3.us-east-1.amazonaws.com` instead of the global S3 endpoint, `s3.amazonaws.com`. The SDK defaults to the current global S3 endpoint resolution for backwards compatibility.
  * Opt-in to the `us-east-1` regional endpoint via the SDK's Config, environment variable, `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT=regional`, or shared config option, `s3_us_east_1_regional_endpoint=regional`.
  * Note the SDK does not support the shared configuration file by default.  You must opt-in to that behavior via Session Option `SharedConfigState`, or `AWS_SDK_LOAD_CONFIG=true` environment variable.

Release v1.25.34 (2019-11-13)
===

### Service Client Updates
* `service/cloudsearch`: Updates service API, documentation, paginators, and examples
  * Amazon CloudSearch domains let you require that all traffic to the domain arrive over HTTPS. This security feature helps you block clients that send unencrypted requests to the domain.
* `service/dataexchange`: Adds new service
* `service/dlm`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * This release adds the custom fields definition support in the index definition for AWS IoT Fleet Indexing Service. Custom fields can be used as an aggregation field to run aggregations with both existing GetStatistics API and newly added GetCardinality, GetPercentiles APIs. GetStatistics will return all statistics (min/max/sum/avg/count...) with this release. For more information, please refer to our latest documentation: https://docs.aws.amazon.com/iot/latest/developerguide/iot-indexing.html
* `service/sesv2`: Adds new service

### SDK Enhancements
* Replaced case-insensitive string comparisons with `strings.EqualFold(...)` ([#2922](https://github.com/aws/aws-sdk-go/pull/2922))

Release v1.25.33 (2019-11-12)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * AWS CodePipeline now supports the use of variables in action configuration.
* `service/dynamodb`: Updates service API and documentation
  * Amazon DynamoDB enables you to restore your data to a new DynamoDB table using a point-in-time or on-demand backup. You now can modify the settings on the new restored table. Specifically, you can exclude some or all of the local and global secondary indexes from being created with the restored table. In addition, you can change the billing mode and provisioned capacity settings.
* `service/elasticloadbalancingv2`: Updates service documentation
* `service/marketplace-catalog`: Adds new service
* `service/transcribe`: Updates service API and documentation

Release v1.25.32 (2019-11-11)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/cloudformation`: Updates service API, documentation, and waiters
  * The Resource Import feature enables customers to import existing AWS resources into new or existing CloudFormation Stacks.

Release v1.25.31 (2019-11-08)
===

### Service Client Updates
* `service/cognito-identity`: Updates service API and documentation
* `service/ecr`: Updates service documentation
  * This release contains ticket fixes for Amazon ECR.

### SDK Bugs
* `aws/request`: Ensure New request handles nil retryer ([#2934](https://github.com/aws/aws-sdk-go/pull/2934))
  * Adds additional default behavior to the SDK's New request constructor, to handle the case where a nil Retryer was passed in. This error could occur when the SDK's Request type was being used to create requests directly, not through one of the SDK's client.
  * Fixes [#2889](https://github.com/aws/aws-sdk-go/issues/2889)

Release v1.25.30 (2019-11-07)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/ssm`: Updates service API
  * AWS Systems Manager Session Manager target length increased to 400.
* `service/sso`: Adds new service
  * This is an initial release of AWS Single Sign-On (SSO) end-user access. This release adds support for accessing AWS accounts assigned in AWS SSO using short term credentials.
* `service/sso-oidc`: Adds new service

Release v1.25.29 (2019-11-06)
===

### Service Client Updates
* `service/savingsplans`: Updates service documentation

Release v1.25.28 (2019-11-06)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Documentation updates for budgets to track Savings Plans utilization and coverage
* `service/ce`: Updates service API, documentation, and paginators
* `service/codebuild`: Updates service API and documentation
  * Add support for Build Number, Secrets Manager and Exported Environment Variables.
* `service/elasticfilesystem`: Updates service API
  * EFS customers can select a lifecycle policy that automatically moves files that have not been accessed for 7 days into the EFS Infrequent Access (EFS IA) storage class. EFS IA provides price/performance that is cost-optimized for files that are not accessed every day.
* `service/savingsplans`: Adds new service
* `service/signer`: Updates service API and documentation
  * This release adds support for tagging code-signing profiles in AWS Signer.

Release v1.25.27 (2019-11-05)
===

### Service Client Updates
* `service/codestar-notifications`: Adds new service
* `service/rds`: Updates service documentation
  * Documentation updates for Amazon RDS

Release v1.25.26 (2019-11-04)
===

### Service Client Updates
* `service/dax`: Updates service documentation
  * Documentation updates for dax
* `service/ec2`: Updates service API and documentation
  * Documentation updates for ec2
* `service/robomaker`: Updates service API and documentation

Release v1.25.25 (2019-11-01)
===

### Service Client Updates
* `service/cloudtrail`: Updates service API, documentation, and paginators
  * This release adds two new APIs, GetTrail and ListTrails, and support for adding tags when you create a trail by using a new TagsList parameter on CreateTrail operations.
* `service/dms`: Updates service API and documentation
  * This release contains task timeline attributes in replication task statistics. This release also adds a note to the documentation for the CdcStartPosition task request parameter. This note describes how to enable the use of native CDC start points for a PostgreSQL source by setting the new slotName extra connection attribute on the source endpoint to the name of an existing logical replication slot.
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces support for using and managing journeys, and querying analytics data for journeys.

Release v1.25.24 (2019-10-31)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/s3`: Updates service API and examples
  * S3 Inventory now supports a new field 'IntelligentTieringAccessTier' that reports the access tier (frequent or infrequent) of objects stored in Intelligent-Tiering storage class.
* `service/support`: Updates service API, documentation, and paginators
  * The status descriptions for TrustedAdvisorCheckRefreshStatus have been updated

Release v1.25.23 (2019-10-30)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache for Redis 5.0.5 now allows you to modify authentication tokens by setting and rotating new tokens. You can now modify active tokens while in use, or add brand-new tokens to existing encryption-in-transit enabled clusters that were previously setup without authentication tokens. This is a two-step process that allows you to set and rotate the token without interrupting client requests.

Release v1.25.22 (2019-10-29)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Adds support for providing domain names that can embed streaming sessions
* `service/cloud9`: Updates service API, documentation, and examples
  * Added CREATING and CREATE_FAILED environment lifecycle statuses.

Release v1.25.21 (2019-10-28)
===

### Service Client Updates
* `service/s3`: Updates service API, documentation, and examples
  * Adding support in SelectObjectContent for scanning a portion of an object specified by a scan range.

Release v1.25.20 (2019-10-28)
===

### Service Client Updates
* `service/ecr`: Updates service API, documentation, and paginators
  * This release of Amazon Elastic Container Registry Service (Amazon ECR) introduces support for image scanning. This identifies the software vulnerabilities in the container image based on the Common Vulnerabilities and Exposures (CVE) database.
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache adds support for migrating Redis workloads hosted on Amazon EC2 into ElastiCache by syncing the data between the source Redis cluster and target ElastiCache for Redis cluster in real time. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/migrate-to-elasticache.html.
* `service/transfer`: Updates service API and documentation
  * This release adds logical directories support to your AWS SFTP server endpoint, so you can now create logical directory structures mapped to Amazon Simple Storage Service (Amazon S3) bucket paths for users created and stored within the service. Amazon S3 bucket names and paths can now be hidden from AWS SFTP users, providing an additional level of privacy to meet security requirements. You can lock down your SFTP users' access to designated folders (commonly referred to as 'chroot'), and simplify complex folder structures for data distribution through SFTP without replicating files across multiple users.

### SDK Enhancements
* `aws/client`: Add PartitionID to Config ([#2902](https://github.com/aws/aws-sdk-go/pull/2902))
* `aws/client/metadata`: Add PartitionID to ClientInfo ([#2902](https://github.com/aws/aws-sdk-go/pull/2902))
* `aws/endpoints`: Add PartitionID to ResolvedEndpoint ([#2902](https://github.com/aws/aws-sdk-go/pull/2902))

### SDK Bugs
* `aws/endpoints`: Fix resolve endpoint with empty region ([#2911](https://github.com/aws/aws-sdk-go/pull/2911))
  * Fixes the SDK's behavior when attempting to resolve a service's endpoint when no region was provided. Adds legacy support for services that were able to resolve a valid endpoint. No new service will support resolving an endpoint without an region.
  * Fixes [#2909](https://github.com/aws/aws-sdk-go/issues/2909)

Release v1.25.19 (2019-10-24)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/chime`: Updates service API, documentation, and paginators
  * * This release introduces Voice Connector PDX region and defaults previously created Voice Connectors to IAD. You can create Voice Connector Groups and add region specific Voice Connectors to direct telephony traffic across AWS regions in case of regional failures. With this release you can add phone numbers to Voice Connector Groups and can bulk move phone numbers between Voice Connectors, between Voice Connector and Voice Connector Groups and between Voice Connector Groups. Voice Connector now supports additional settings to enable SIP Log capture. This is in addition to the launch of Voice Connector Cloud Watch metrics in this release. This release also supports assigning outbound calling name (CNAM) to AWS account and individual phone numbers assigned to Voice Connectors. * Voice Connector now supports a setting to enable real time audio streaming delivered via Kinesis Audio streams. Please note that recording Amazon Chime Voice Connector calls with this feature maybe be subject to laws or regulations regarding the recording of telephone calls and other electronic communications. AWS Customer and their end users' have the responsibility to comply with all applicable laws regarding the recording, including properly notifying all participants in a recorded session or to a recorded communication that the session or communication is being recorded and obtain their consent.
* `service/ec2`: Updates service API and documentation
  * This release updates CreateFpgaImage to support tagging FPGA images on creation
* `service/gamelift`: Updates service API
  * Amazon GameLift offers expanded hardware options for game hosting: Custom game builds can use the Amazon Linux 2 operating system, and fleets for both custom builds and Realtime servers can now use C5, M5, and R5 instance types.
* `service/sagemaker`: Updates service API
  * Adds support for the new family of Elastic Inference Accelerators (eia2) for SageMaker Hosting and Notebook Services

Release v1.25.18 (2019-10-23)
===

### Service Client Updates
* `service/connect`: Updates service API, documentation, and paginators
* `service/polly`: Updates service API
  * Amazon Polly adds new female voices: US Spanish - Lupe and Brazilian Portuguese - Camila; both voices are available in Standard and Neural engine.
* `service/sts`: Updates service documentation
  * AWS Security Token Service (STS) now supports a regional configuration flag to make the client respect the region without the need for the endpoint parameter.

### SDK Enhancements
* `aws/endpoints`: Adds support for STS Regional Flags ([#2779](https://github.com/aws/aws-sdk-go/pull/2779))
  * Implements STS regional flag, with support for `legacy` and `regional` options. Defaults to `legacy`. Legacy, will force all regions specified in aws/endpoints/sts_legacy_regions.go to resolve to the STS global endpoint, sts.amazonaws.com. This is the SDK's current behavior.
  * When the flag's value is `regional` the SDK will resolve the endpoint based on the endpoints.json model. This allows STS to update their service's modeled endpoints to be regionalized for all regions. When `regional` turned on use `aws-global` as the region to use the global endpoint.
  * `AWS_STS_REGIONAL_ENDPOINTS=regional` for environment, or `sts_regional_endpoints=regional` in shared config file.
  * The regions the SDK defaults to the STS global endpoint in `legacy` mode are: 
    * ap-northeast-1
    * ap-south-1
    * ap-southeast-1
    * ap-southeast-2
    * aws-global
    * ca-central-1
    * eu-central-1
    * eu-north-1
    * eu-west-1
    * eu-west-2
    * eu-west-3
    * sa-east-1
    * us-east-1
    * us-east-2
    * us-west-1
    * us-west-2

Release v1.25.17 (2019-10-22)
===

### Service Client Updates
* `service/iotevents`: Updates service API and documentation
* `service/opsworkscm`: Updates service API and documentation
  * AWS OpsWorks for Chef Automate (OWCA) now allows customers to use a custom domain and respective certificate, for their AWS OpsWorks For Chef Automate servers. Customers can now provide a CustomDomain, CustomCertificate and CustomPrivateKey in CreateServer API to configure their Chef Automate servers with a custom domain and certificate.

### SDK Bugs
* `service/s3`,`service/kinesis`: Fix streaming APIs' Err method closing stream ([#2882](https://github.com/aws/aws-sdk-go/pull/2882))
  * Fixes calling the Err method on SDK's Amazon Kinesis's SubscribeToShared and Amazon S3's SelectObjectContent response EventStream members closing the stream. This would cause unexpected read errors, or early termination of the streams. Only the Close method of the streaming members will close the streams.
  * Related to [#2769](https://github.com/aws/aws-sdk-go/issues/2769)

Release v1.25.16 (2019-10-18)
===

### Service Client Updates
* `service/monitoring`: Updates service API and documentation
  * New Period parameter added to MetricDataQuery structure.

Release v1.25.15 (2019-10-17)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Adding support for Compute Environment Allocation Strategies
* `service/rds`: Updates service API, documentation, and paginators
  * Amazon RDS now supports Amazon RDS on VMware with the introduction of APIs related to Custom Availability Zones and Media installation.

Release v1.25.14 (2019-10-16)
===

### Service Client Updates
* `service/kafka`: Updates service API and documentation
* `service/marketplacecommerceanalytics`: Updates service API and documentation
  * add 2 more values for the supporting sections - age of past due funds + uncollected funds breakdown
* `service/robomaker`: Updates service API

Release v1.25.13 (2019-10-15)
===

### Service Client Updates
* `service/kinesis-video-archived-media`: Updates service API and documentation

Release v1.25.12 (2019-10-14)
===

### Service Client Updates
* `service/personalize`: Updates service API and documentation
* `service/workspaces`: Updates service documentation
  * Documentation updates for WorkSpaces

Release v1.25.11 (2019-10-11)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/greengrass`: Updates service API
  * Greengrass OTA service supports Raspbian/Armv6l platforms.

Release v1.25.10 (2019-10-10)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * New EC2 M5n, M5dn, R5n, R5dn instances with 100 Gbps network performance and Elastic Fabric Adapter (EFA) for ultra low latency; New A1.metal bare metal instance powered by AWS Graviton Processors
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/fms`: Updates service API and documentation
* `service/iotanalytics`: Updates service API and documentation
* `service/runtime.lex`: Updates service API and documentation

Release v1.25.9 (2019-10-09)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache now allows you to apply available service updates on demand to your Memcached and Redis Cache Clusters. Features included: (1) Access to the list of applicable service updates and their priorities. (2) Service update monitoring and regular status updates. (3) Recommended apply-by-dates for scheduling the service updates. (4) Ability to stop and later re-apply updates. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/Self-Service-Updates.html and https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `service/kafka`: Updates service documentation
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for Dolby Atmos encoding, up to 36 outputs, accelerated transcoding with frame capture and preferred acceleration feature.

Release v1.25.8 (2019-10-08)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/eventbridge`: Updates service documentation
* `service/firehose`: Updates service API and documentation
  * With this release, you can use Amazon Kinesis Firehose delivery streams to deliver streaming data to Amazon Elasticsearch Service version 7.x clusters. For technical documentation, look for CreateDeliveryStream operation in Amazon Kinesis Firehose API reference.
* `service/organizations`: Updates service documentation
  * Documentation updates for organizations

Release v1.25.7 (2019-10-07)
===

### Service Client Updates
* `service/directconnect`: Updates service API and documentation
  * This release adds a service provider field for physical connection creation and provides a list of available partner providers for each Direct Connect location.
* `service/firehose`: Updates service API and documentation
  * Amazon Kinesis Data Firehose now allows delivering data to Elasticsearch clusters set up in a different AWS account than the Firehose AWS account. For technical documentation, look for ElasticsearchDestinationConfiguration in the Amazon Kinesis Firehose API reference.
* `service/glue`: Updates service API and documentation
  * AWS Glue now provides ability to use custom certificates for JDBC Connections.
* `service/pinpoint`: Updates service API and documentation
  * This release of the Amazon Pinpoint API introduces support for using and managing message templates.
* `service/pinpoint-email`: Updates service API and documentation
* `service/snowball`: Updates service API and documentation
  * AWS Snowball Edge now allows you to perform an offline update to the software of your Snowball Edge device when your device is not connected to the internet. Previously, updating your Snowball Edge's software required that the device be connected to the internet or be sent back to AWS. Now, you can keep your Snowball Edge software up to date even if your device(s) cannot connect to the internet, or are required to run in an air-gapped environment. To complete offline updates, download the software update from a client machine with connection to the internet using the AWS Command Line Interface (CLI). Then, have the Snowball Edge device download and install the software update using the Snowball Edge device API. For more information about offline updates, visit the Snowball Edge documentation page.

Release v1.25.6 (2019-10-04)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API, documentation, and paginators
* `service/mediapackage`: Updates service API, documentation, and paginators
  * New Harvest Job APIs to export segment-accurate content windows from MediaPackage Origin Endpoints to S3. See https://docs.aws.amazon.com/mediapackage/latest/ug/harvest-jobs.html for more info
* `service/ssm`: Updates service documentation
  * Documentation updates for Systems Manager / StartSession.

Release v1.25.5 (2019-10-03)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation and examples
* `service/devicefarm`: Updates service documentation and examples
  * Documentation updates for devicefarm
* `service/ec2`: Updates service API and documentation
  * This release allows customers to purchase regional EC2 RIs on a future date.
* `service/es`: Updates service API and documentation
  * Amazon Elasticsearch Service now supports configuring additional options for domain endpoint, such as whether to require HTTPS for all traffic.

### SDK Bugs
* `service/dynamodb/dynamodbattribute`: Fixes a panic when decoding into a map with a key string type alias. ([#2870](https://github.com/aws/aws-sdk-go/pull/2870))

Release v1.25.4 (2019-10-02)
===

### Service Client Updates
* `service/lightsail`: Updates service API and documentation
  * This release adds support for the automatic snapshots add-on for instances and block storage disks.

### SDK Enhancements
* `service/s3/s3manager`: Allow reuse of Uploader buffer `sync.Pool` amongst multiple Upload calls ([#2863](https://github.com/aws/aws-sdk-go/pull/2863)) 
  * The `sync.Pool` used for the reuse of `[]byte` slices when handling streaming payloads will now be shared across multiple Upload calls when the upload part size remains constant. 

### SDK Bugs
* `internal/ini`: Fix ini parser to handle empty values [#2860](https://github.com/aws/aws-sdk-go/pull/2860)
  * Fixes incorrect modifications to the previous token value of the skipper. Adds checks for cases where a skipped statement should be marked as complete and not be ignored.
  * Adds tests for nested and empty field value parsing, along with tests suggested in [#2801](https://github.com/aws/aws-sdk-go/pull/2801)
  * Fixes [#2800](https://github.com/aws/aws-sdk-go/issues/2800)

Release v1.25.3 (2019-10-01)
===

### Service Client Updates
* `service/docdb`: Updates service API and documentation
  * This release provides support for describe and modify CA certificates.

### SDK Bugs
* `private/model/api` : Fixes broken test for code generation example ([#2855](https://github.com/aws/aws-sdk-go/pull/2855))

Release v1.25.2 (2019-09-30)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mq`: Updates service API and documentation
  * Amazon MQ now includes the ability to scale your brokers by changing the host instance type. See the hostInstanceType property of UpdateBrokerInput (https://docs.aws.amazon.com/amazon-mq/latest/api-reference/brokers-broker-id.html#brokers-broker-id-model-updatebrokerinput), and pendingHostInstanceType property of DescribeBrokerOutput (https://docs.aws.amazon.com/amazon-mq/latest/api-reference/brokers-broker-id.html#brokers-broker-id-model-describebrokeroutput).
* `service/rds`: Updates service API, documentation, and waiters
  * This release adds support for creating a Read Replica with Active Directory domain information. This release updates RDS API to indicate whether an OrderableDBInstanceOption supports Kerberos Authentication.
* `service/waf`: Updates service API and documentation
  * Lowering the threshold for Rate Based rule from 2000 to 100.

Release v1.25.1 (2019-09-27)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) removes FirelensConfiguration from the DescribeTask output during the FireLens public preview.

### SDK Enhancements
* `private/protocol/xml/xmlutil`: Support for sorting xml attributes ([#2854](https://github.com/aws/aws-sdk-go/pull/2854))

### SDK Bugs
* `private/model/api`: Write locationName for top-level shapes for rest-xml and ec2 protocols ([#2854](https://github.com/aws/aws-sdk-go/pull/2854))
* `private/mode/api`: Colliding fields should serialize with original name ([#2854](https://github.com/aws/aws-sdk-go/pull/2854))
  * Fixes [#2806](https://github.com/aws/aws-sdk-go/issues/2806) 
Release v1.25.0 (2019-09-26)
===

### Service Client Updates
* `service/codepipeline`: Updates service documentation
  * Documentation updates for CodePipeline
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/ssm`: Updates service API and documentation
  * This release updates the AWS Systems Manager Parameter Store PutParameter and LabelParameterVersion APIs to return the "Tier" of parameter created/updated and the "parameter version" labeled respectively.

### SDK Features
* `service/dynamodb/dynamodbattribute`: Add EnableEmptyCollections flag to Encoder and Decoder ([#2834](https://github.com/aws/aws-sdk-go/pull/2834))
  * The `Encoder` and `Decoder` types have been enhanced to allow support for specifying the SDK's behavior when marshaling structures, maps, and slices to DynamoDB.
  * When `EnableEmptyCollections` is set to `True` the SDK will preserve the empty of these types in DynamoDB rather then encoding a NULL AttributeValue.
  * Fixes [#682](https://github.com/aws/aws-sdk-go/issues/682)
  * Fixes [#1890](https://github.com/aws/aws-sdk-go/issues/1890)
  * Fixes [#2746](https://github.com/aws/aws-sdk-go/issues/2746)
* `service/s3/s3manager`: Add Download Buffer Provider ([#2823](https://github.com/aws/aws-sdk-go/pull/2823))
  * Adds a new `BufferProvider` member for specifying how part data can be buffered in memory when copying from the http response body.
  * Windows platforms will now default to buffering 1MB per part to reduce contention when downloading files.
  * Non-Windows platforms will continue to employ a non-buffering behavior.
  * Fixes [#2180](https://github.com/aws/aws-sdk-go/issues/2180)
  * Fixes [#2662](https://github.com/aws/aws-sdk-go/issues/2662)

Release v1.24.6 (2019-09-25)
===

### Service Client Updates
* `service/dms`: Updates service API, documentation, and examples
  * This release adds a new DeleteConnection API to delete the connection between a replication instance and an endpoint. It also adds an optional S3 setting to specify the precision of any TIMESTAMP column values written to an S3 object file in .parquet format.
* `service/globalaccelerator`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Enable G4D and R5 instances in SageMaker Hosting Services

Release v1.24.5 (2019-09-24)
===

### Service Client Updates
* `service/comprehendmedical`: Updates service API and documentation
* `service/datasync`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

### SDK Enhancements
* `private/model/api`: Skip unsupported API models during code generation ([#2849](https://github.com/aws/aws-sdk-go/pull/2849))
  * Adds support for removing API modeled operations that use unsupported features. If a API model results in having no operations it will be skipped.

Release v1.24.4 (2019-09-23)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds-data`: Updates service API, documentation, paginators, and examples
* `service/redshift`: Updates service API, documentation, and paginators
  * Adds API operation DescribeNodeConfigurationOptions and associated data structures.

Release v1.24.3 (2019-09-20)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * G4 instances are Amazon EC2 instances based on NVIDIA T4 GPUs and are designed to provide cost-effective machine learning inference for applications, like image classification, object detection, recommender systems, automated speech recognition, and language translation. G4 instances are also a cost-effective platform for building and running graphics-intensive applications, such as remote graphics workstations, video transcoding, photo-realistic design, and game streaming in the cloud. To get started with G4 instances visit https://aws.amazon.com/ec2/instance-types/g4.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/greengrass`: Updates service API and documentation
  * Greengrass OTA service now returns the updated software version in the PlatformSoftwareVersion parameter of a CreateSoftwareUpdateJob response
* `service/rds`: Updates service API and documentation
  * Add a new LeaseID output field to DescribeReservedDBInstances, which shows the unique identifier for the lease associated with the reserved DB instance. AWS Support might request the lease ID for an issue related to a reserved DB instance.
* `service/workspaces`: Updates service API and documentation
  * Adds the WorkSpaces restore feature

Release v1.24.2 (2019-09-19)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for container image manifest digests. This enables you to identify all tasks launched using a container image pulled from ECR in order to correlate what was built with where it is running.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * AWS Glue DevEndpoints now supports GlueVersion, enabling you to choose Apache Spark 2.4.3 (in addition to Apache Spark 2.2.1). In addition to supporting the latest version of Spark, you will also have the ability to choose between Python 2 and Python 3.
* `service/mediaconnect`: Updates service API and documentation

Release v1.24.1 (2019-09-18)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Amazon API Gateway simplifies accessing PRIVATE APIs by allowing you to associate one or more Amazon Virtual Private Cloud (VPC) Endpoints to a private API. API Gateway will create and manage DNS alias records necessary for easily invoking the private APIs. With this feature, you can leverage private APIs in web applications hosted within your VPCs.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/ram`: Updates service API, documentation, and paginators
* `service/waf-regional`: Updates service API and documentation

Release v1.24.0 (2019-09-17)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release adds DataManifestLocation field indicating the location and file name of the data manifest file. Users can get a list of files that the Athena query wrote or intended to write from the manifest file.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iam`: Updates service documentation and examples
  * Documentation updates for iam
* `service/personalize`: Updates service API and documentation

### SDK Features
* `service/s3/s3manager`: Add Upload Buffer Provider ([#2792](https://github.com/aws/aws-sdk-go/pull/2792))
  * Adds a new `BufferProvider` member for specifying how part data can be buffered in memory.
  * Windows platforms will now default to buffering 1MB per part to reduce contention when uploading files.
  * Non-Windows platforms will continue to employ a non-buffering behavior.

### SDK Enhancements
* `awstesting/integration/performance/s3UploadManager`: Extended to support benchmarking and usage of new `BufferProvider` ([#2792](https://github.com/aws/aws-sdk-go/pull/2792))

Release v1.23.22 (2019-09-16)
===

### Service Client Updates
* `service/eks`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added support for multi-DRM SPEKE with CMAF outputs, MP3 ingest, and options for improved video quality.

### SDK Enhancements
* `aws/client`: Adds configurations to the default retryer ([#2830](https://github.com/aws/aws-sdk-go/pull/2830))
  * Exposes members of the default retryer. Adds NoOpRetryer to support no retry behavior. 
  * Updates the underlying logic used by the default retryer to calculate jittered delay for retry. 
  * Fixes [#2829](https://github.com/aws/aws-sdk-go/issues/2829)

Release v1.23.21 (2019-09-12)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Fix for FleetActivityStatus and FleetStateCode enum
* `service/elasticloadbalancingv2`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive now supports High Efficiency Video Coding (HEVC) for standard-definition (SD), high-definition (HD), and ultra-high-definition (UHD) encoding with HDR support.Encoding with HEVC offers a number of advantages. While UHD video requires an advanced codec beyond H.264 (AVC), high frame rate (HFR) or High Dynamic Range (HDR) content in HD also benefit from HEVC's advancements. In addition, benefits can be achieved with HD and SD content even if HDR and HFR are not needed.
* `service/workmailmessageflow`: Adds new service

### SDK Enhancements
* `aws`: Add value/pointer conversion functions for all basic number types ([#2740](https://github.com/aws/aws-sdk-go/pull/2740))
  * Adds value and pointer conversion utilities for the remaining set of integer and float number types.

Release v1.23.20 (2019-09-11)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for new data fields and log format in VPC flow logs.
* `service/email`: Updates service documentation
  * Updated API documentation to correct broken links, and to update content based on customer feedback.
* `service/mediaconnect`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * This release allows customers to specify a custom parameter group when creating a Read Replica, for DB engines which support this feature.
* `service/states`: Updates service API and documentation
  * Fixing letter case in Map history event details to be small case

### SDK Enhancements
* Enabled verbose logging for continuous integration tests ([#2815](https://github.com/aws/aws-sdk-go/pull/2815))

Release v1.23.19 (2019-09-10)
===

### Service Client Updates
* `service/storagegateway`: Updates service API and documentation
  * The CloudWatchLogGroupARN parameter of the UpdateGatewayInformation API allows for configuring the gateway to use a CloudWatch log-group where Storage Gateway health events will be logged.

Release v1.23.18 (2019-09-09)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/appstream`: Updates service API and documentation
  * IamRoleArn support in CreateFleet, UpdateFleet, CreateImageBuilder APIs
* `service/ec2`: Updates service API and documentation
  * This release expands Site-to-Site VPN tunnel options to allow customers to restrict security algorithms and configure timer settings for VPN connections. Customers can specify these new options while creating new VPN connections, or they can modify the tunnel options on existing connections using a new API.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/marketplacecommerceanalytics`: Updates service API and documentation
  * Add FDP+FPS (monthly_revenue_field_demonstration_usage + monthly_revenue_flexible_payment_schedule)  to Marketplace Commerce Analytics Service
* `service/qldb`: Adds new service
* `service/qldb-session`: Adds new service
* `service/robomaker`: Updates service API and documentation

### SDK Bugs
* Fixed failing tests when executed as a module dependency ([#2817](https://github.com/aws/aws-sdk-go/pull/2817))
Release v1.23.17 (2019-09-06)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kinesisanalytics`: Updates service documentation
  * Documentation updates for kinesisanalytics

### SDK Bugs
* `awstesting`: Fixes AssertXML to correctly assert on differences ([#2804](https://github.com/aws/aws-sdk-go/pull/2804))
Release v1.23.16 (2019-09-05)
===

### Service Client Updates
* `service/config`: Updates service API, documentation, and paginators
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.23.15 (2019-09-04)
===

### Service Client Updates
* `service/eks`: Updates service API, documentation, and paginators
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/states`: Updates service API and documentation
  * Added support for new history events
* `service/transcribe`: Updates service API and documentation

Release v1.23.14 (2019-09-03)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for attaching Amazon Elastic Inference accelerators to your containers. This enables you to run deep learning inference workloads with hardware acceleration in a more efficient way.
* `service/gamelift`: Updates service API and documentation
  * You can now make use of PKI resources to provide more secure connections between your game clients and servers.  To learn more, please refer to the public Amazon GameLift documentation.
* `service/resourcegroupstaggingapi`: Updates service documentation
  * Documentation updates for resourcegroupstaggingapi

Release v1.23.13 (2019-08-30)
===

### Service Client Updates
* `service/apigatewaymanagementapi`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for modifying the cluster settings for existing clusters, which enables you to toggle whether Container Insights is enabled or not. Support is also introduced for custom log routing using the ECS FireLens integration.
* `service/mq`: Updates service API and documentation
  * Adds support for updating security groups selection of an Amazon MQ broker.

### SDK Bugs
* `aws/csm`: Fix metricChan's unsafe atomic operations ([#2785](https://github.com/aws/aws-sdk-go/pull/2785))
  * Fixes [#2784](https://github.com/aws/aws-sdk-go/issues/2784) test failure caused by the metricChan.paused member being a value instead of a pointer. If the metricChan value was ever copied the atomic operations performed on paused would be invalid.
* `aws/client`: Updates logic for request retry delay calculation ([#2796](https://github.com/aws/aws-sdk-go/pull/2796))
  * Updates logic for calculating the delay after which a request can be retried. Retry delay now includes the Retry-After duration specified in a request. Fixes broken test for retry delays for throttled exceptions.
  * Fixes [#2795](https://github.com/aws/aws-sdk-go/issues/2795)
Release v1.23.12 (2019-08-29)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API, documentation, and paginators
* `service/codepipeline`: Updates service API and documentation
  * Introducing pipeline execution trigger details in ListPipelineExecutions API.
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for including Docker container IDs in the API response when describing and stopping tasks. This enables customers to easily map containers to the tasks they are associated with.
* `service/elasticache`: Updates service API and documentation
  * Amazon ElastiCache for Redis now supports encryption at rest using customer managed customer master keys (CMKs) in AWS Key Management Service (KMS). Amazon ElastiCache now supports cluster names upto 40 characters for replicationGoups and upto 50 characters for cacheClusters.
* `service/lambda`: Updates service API, documentation, and paginators
  * Adds a "MaximumBatchingWindowInSeconds" parameter to event source mapping api's. Usable by Dynamodb and Kinesis event sources.

### SDK Enhancements
* `aws/ec2metadata`: Add marketplaceProductCodes to EC2 Instance Identity Document
  * Adds `MarketplaceProductCodes` to the EC2 Instance Metadata's Identity Document. The ec2metadata client will now retrieve these values if they are available.
  * Fixes [#2781](https://github.com/aws/aws-sdk-go/issues/2781)
* `private/protocol`: Add support for parsing fractional time ([#2760](https://github.com/aws/aws-sdk-go/pull/2760))
  * Fixes the SDK's ability to parse fractional unix timestamp values and added tests.
  * Fixes [#1448](https://github.com/aws/aws-sdk-go/pull/1448)

Release v1.23.11 (2019-08-28)
===

### Service Client Updates
* `service/globalaccelerator`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release adds the ability to send a job to an on-demand queue while simulating the performance of a job sent to a reserved queue. Use this setting to estimate the number of reserved transcoding slots (RTS) you need for a reserved queue.
* `service/sqs`: Updates service API and documentation
  * Added support for message system attributes, which currently lets you send AWS X-Ray trace IDs through Amazon SQS.

Release v1.23.10 (2019-08-27)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/organizations`: Updates service documentation
  * Documentation updates for organizations

### SDK Bugs
* `service/ec2`: Fix int overflow in minTime on 386 and arm ([#2787](https://github.com/aws/aws-sdk-go/pull/2787))
  * Fixes [2786](https://github.com/aws/aws-sdk-go/issues/2786) int overflow issue on 32-bit platforms like 386 and arm.
Release v1.23.9 (2019-08-26)
===

### Service Client Updates
* `service/securityhub`: Updates service API
* `service/ssm`: Updates service API and documentation
  * This feature adds "default tier" to the AWS Systems Manager Parameter Store for parameter creation and update. AWS customers can now set the "default tier" to one of the following values: Standard (default), Advanced or Intelligent-Tiering.  This allows customers to create advanced parameters or parameters in corresponding tiers with one setting rather than code change to specify parameter tiers.

Release v1.23.8 (2019-08-23)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release of EC2 VM Import Export adds support for exporting Amazon Machine Image(AMI)s to a VM file
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediapackage-vod`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

### SDK Enhancements
* `aws/session`: Add support for CSM options from shared config file ([#2768](https://github.com/aws/aws-sdk-go/pull/2768))
  * Adds support for enabling and controlling the Client Side Metrics (CSM) reporting from the shared configuration files in addition to the environment variables.

### SDK Bugs
* `service/s3/s3crypto`: Fix tmp file not being deleted after upload ([#2776](https://github.com/aws/aws-sdk-go/pull/2776))
  * Fixes the s3crypto's getWriterStore utiliy's send handler not cleaning up the temporary file after Send completes.
* `private/protocol`: Add protocol tests for blob types and headers ([#2770](https://github.com/aws/aws-sdk-go/pull/2770))
  * Adds RESTJSON and RESTXML protocol tests for blob headers.
  * Related to [#750](https://github.com/aws/aws-sdk-go/issues/750)
* `service/dynamodb/expression`: Improved reporting of bad key conditions ([#2775](https://github.com/aws/aws-sdk-go/pull/2775))
  * Improved error reporting when invalid key conditions are constructed using KeyConditionBuilder
Release v1.23.7 (2019-08-22)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * This release allows users to enable RDS Data API while creating Aurora Serverless databases.

### SDK Bugs
* `aws/request`: Fix IsErrorRetryable returning true for nil error ([#2774](https://github.com/aws/aws-sdk-go/pull/2774))
  * Fixes [#2773](https://github.com/aws/aws-sdk-go/pull/2773) where the IsErrorRetryable helper was incorrectly returning true for nil errors passed in. IsErrorRetryable will now correctly return false when the passed in error is nil like documented.

Release v1.23.6 (2019-08-21)
===

### Service Client Updates
* `service/elasticache`: Updates service API and documentation
  * ElastiCache extends support for Scale down for Redis Cluster-mode enabled and disabled replication groups
* `service/forecast`: Adds new service
* `service/forecastquery`: Adds new service
* `service/personalize-runtime`: Updates service API
* `service/rekognition`: Updates service documentation
  * Documentation updates for Amazon Rekognition.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker now supports Amazon EFS and Amazon FSx for Lustre file systems as data sources for training machine learning models. Amazon SageMaker now supports running training jobs on ml.p3dn.24xlarge instance type. This instance type is offered as a limited private preview for certain SageMaker customers. If you are interested in joining the private preview, please reach out to the SageMaker Product Management team via AWS Support."
* `service/sqs`: Updates service API and documentation
  * This release provides a way to add metadata tags to a queue when it is created. You can use tags to organize and identify your Amazon SQS queues for cost allocation.

### SDK Enhancements
* `aws/session`: Ignore invalid shared config file when not used ([#2731](https://github.com/aws/aws-sdk-go/pull/2731))
  * Updates the Session to not fail to load when credentials are provided via the environment variable, the AWS_PROFILE/Option.Profile have not been specified, and the shared config has not been enabled.
  * Fixes [#2455](https://github.com/aws/aws-sdk-go/issues/2455)

Release v1.23.5 (2019-08-20)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/appstream`: Updates service API and documentation
  * Includes API updates to support streaming through VPC endpoints for image builders and stacks.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker introduces Managed Spot Training. Increases the maximum number of metric definitions to 40 for SageMaker Training and Hyperparameter Tuning Jobs. SageMaker Neo adds support for Acer aiSage and Qualcomm QCS605 and QCS603.
* `service/transfer`: Updates service API and documentation
  * New field in response of TestIdentityProvider

Release v1.23.4 (2019-08-19)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/cur`: Updates service API and documentation
  * New IAM permission required for editing AWS Cost and Usage Reports - Starting today, you can allow or deny IAM users permission to edit Cost & Usage Reports through the API and the Billing and Cost Management console. To allow users to edit Cost & Usage Reports, ensure that they have 'cur: ModifyReportDefinition' permission. Refer to the technical documentation (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_ModifyReportDefinition.html) for additional details.

Release v1.23.3 (2019-08-16)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for controlling the usage of swap space on a per-container basis for Linux containers.
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR  has introduced an account level configuration called Block Public Access that allows you to block clusters with ports open to traffic from public IP sources (i.e. 0.0.0.0/0 for IPv4 and ::/0 for IPv6) from launching.  Individual ports or port ranges can be added as exceptions to allow public access.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/robomaker`: Updates service API and documentation

Release v1.23.2 (2019-08-15)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/athena`: Updates service API and documentation
  * This release adds support for querying S3 Requester Pays buckets. Users can enable this feature through their Workgroup settings.
* `service/codecommit`: Updates service API and documentation
  * This release adds an API, BatchGetCommits, that allows retrieval of metadata for multiple commits in an AWS CodeCommit repository.
* `service/ec2`: Updates service API and documentation
  * This release adds an option to use private certificates from AWS Certificate Manager (ACM) to authenticate a Site-to-Site VPN connection's tunnel endpoints and customer gateway device.
* `service/glue`: Updates service API, documentation, and paginators
  * GetJobBookmarks API is withdrawn.
* `service/storagegateway`: Updates service API and documentation
  * CreateSnapshotFromVolumeRecoveryPoint API supports new parameter: Tags (to be attached to the created resource)

### SDK Enhancements
* `service/kinesis`: Add support for retrying service specific API errors ([#2751](https://github.com/aws/aws-sdk-go/pull/2751)
  * Adds support for retrying the Kinesis API error, LimitExceededException.
  * Fixes [#1376](https://github.com/aws/aws-sdk-go/issues/1376)
* `aws/credentials/stscreds`: Add STS and Assume Role specific retries ([#2752](https://github.com/aws/aws-sdk-go/pull/2752))
  * Adds retries to specific STS API errors to the STS AssumeRoleWithWebIdentity credential provider, and STS API operations in general.

Release v1.23.1 (2019-08-14)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds a new API called SendDiagnosticInterrupt, which allows you to send diagnostic interrupts to your EC2 instance.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.23.0 (2019-08-13)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

### SDK Features
* SDK code generation will no longer remove stutter from operations and type names in service API packages. New API operations and types will not have the service's name removed from them. The SDK was previously squashing API types if removing stutter from a type resulted in a name of a type that already existed. The existing type would be deleted. Only the renamed type remained. This has been fixed, and previously deleted types are now available.
  * `AWS Glue`'s `GlueTable` with `Table`.  The API's previously deleted `Table` is available as `TableData`.
  * `AWS IoT Events`'s `IotEventsAction` with `Action`. The previously deleted `Action` is available as `ActionData`.

### SDK Bugs
* `private/model/api`: Fix broken shape stutter rename during generation ([#2747](https://github.com/aws/aws-sdk-go/pull/2747))
  * Fixes the SDK's code generation incorrectly renaming types and operations. The code generation would incorrectly rename an API type by removing the service's name from the type's name. This was done without checking for if a type with the new name already existed. Causing the SDK to replace the existing type with the renamed one.
  * Fixes [#2741](https://github.com/aws/aws-sdk-go/issues/2741)
* `private/model/api`: Fix API doc being generated with wrong value ([#2748](https://github.com/aws/aws-sdk-go/pull/2748))
  * Fixes the SDK's generated API documentation for structure member being generated with the wrong documentation value when the member was included multiple times in the model doc-2.json file, but under different types.
Release v1.22.4 (2019-08-12)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/autoscaling`: Updates service documentation
  * Amazon EC2 Auto Scaling now supports a new Spot allocation strategy "capacity-optimized" that fulfills your request using Spot Instance pools that are optimally chosen based on the available Spot capacity.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring
* `service/rekognition`: Updates service API
  * Adding new Emotion, Fear

Release v1.22.3 (2019-08-09)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/guardduty`: Updates service API and documentation
  * New "evidence" field in the finding model to provide evidence information explaining why the finding has been triggered. Currently only threat-intelligence findings have this field. Some documentation updates.
* `service/iot`: Updates service API and documentation
  * This release adds Quality of Service (QoS) support for AWS IoT rules engine republish action.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert has added support for multi-DRM SPEKE with CMAF outputs, MP3 ingest, and options for improved video quality.
* `service/redshift`: Updates service API and documentation
  * Add expectedNextSnapshotScheduleTime and expectedNextSnapshotScheduleTimeStatus to redshift cluster object.
* `service/runtime.lex`: Updates service API and documentation

Release v1.22.2 (2019-08-08)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild adds CloudFormation support for SourceCredential
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API, documentation, and paginators
  * You can now use AWS Glue to find matching records across dataset even without identifiers to join on by using the new FindMatches ML Transform. Find related products, places, suppliers, customers, and more by teaching a custom machine learning transformation that you can use to identify matching matching records as part of your analysis, data cleaning, or master data management project by adding the FindMatches transformation to your Glue ETL Jobs. If your problem is more along the lines of deduplication, you can use the FindMatches in much the same way to identify customers who have signed up more than ones, products that have accidentally been added to your product catalog more than once, and so forth. Using the FindMatches MLTransform, you can teach a Transform your definition of a duplicate through examples, and it will use machine learning to identify other potential duplicates in your dataset. As with data integration, you can then use your new Transform in your deduplication projects by adding the FindMatches transformation to your Glue ETL Jobs. This release also contains additional APIs that support AWS Lake Formation.
* `service/lakeformation`: Adds new service
* `service/opsworkscm`: Updates service API
  * This release adds support for Chef Automate 2 specific engine attributes.

Release v1.22.1 (2019-08-07)
===

### Service Client Updates
* `service/application-insights`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.22.0 (2019-08-06)
===

### Service Client Updates
* `service/batch`: Updates service documentation
  * Documentation updates for AWS Batch

### SDK Features
* `aws/session`: Corrected order of SDK environment and shared config loading.
  * Environment credentials have precedence over shared config credentials even if the AWS_PROFILE environment credentials are present. The session.Options.Profile value needs to be used to specify a profile for shared config to have precedence over environment credentials. #2694 incorrectly gave AWS_PROFILE for shared config precedence over environment credentials as well.

### SDK Bugs
* `aws/session`: Fix credential loading order for env and shared config ([#2729](https://github.com/aws/aws-sdk-go/pull/2729))
  * Fixes the credential loading order for environment credentials, when the presence of an AWS_PROFILE value is also provided. The environment credentials have precedence over the AWS_PROFILE.
  * Fixes [#2727](https://github.com/aws/aws-sdk-go/issues/2727)
Release v1.21.10 (2019-08-05)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/ec2`: Updates service API
  * Amazon EC2 now supports a new Spot allocation strategy "Capacity-optimized" that fulfills your request using Spot Instance pools that are optimally chosen based on the available Spot capacity.
* `service/iot`: Updates service API and documentation
  * In this release, AWS IoT Device Defender introduces audit mitigation actions that can be applied to audit findings to help mitigate security issues.

Release v1.21.9 (2019-08-02)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/sts`: Updates service documentation
  * Documentation updates for sts

### SDK Enhancements
* `aws/endpoints`: Expose DNSSuffix for partitions ([#2711](https://github.com/aws/aws-sdk-go/pull/2711))
  * Exposes the underlying partition metadata's DNSSuffix value via the `DNSSuffix` method on the endpoint's `Partition` type. This allows access to the partition's DNS suffix, e.g. "amazon.com".
  * Fixes [#2710](https://github.com/aws/aws-sdk-go/issues/2710)

Release v1.21.8 (2019-07-30)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconvert`: Updates service API and documentation
  * MediaConvert adds support for specifying priority (-50 to 50) on jobs submitted to on demand or reserved queues
* `service/polly`: Updates service API and documentation
  * Amazon Polly adds support for Neural text-to-speech engine.
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Middle East (Bahrain) Region (me-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

Release v1.21.7 (2019-07-29)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * This release supports better exception handling for merges.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.21.6 (2019-07-26)
===

### Service Client Updates
* `service/batch`: Updates service API, documentation, and paginators
  * AWS Batch now supports SDK auto-pagination and Job-level docker devices.
* `service/ce`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * You can now create EC2 Capacity Reservations using Availability Zone ID or Availability Zone name. You can view usage of Amazon EC2 Capacity Reservations per AWS account.
* `service/glue`: Updates service API, documentation, and paginators
  * This release provides GetJobBookmark and GetJobBookmarks APIs. These APIs enable users to look at specific versions or all versions of the JobBookmark for a specific job. This release also enables resetting the job bookmark to a specific run via an enhancement of the ResetJobBookmark API.
* `service/greengrass`: Updates service API and documentation
  * Greengrass OTA service supports openwrt/aarch64 and openwrt/armv7l platforms.
* `service/logs`: Updates service API and documentation
  * Allow for specifying multiple log groups in an Insights query, and deprecate storedByte field for LogStreams and interleaved field for FilterLogEventsRequest.
* `service/mediaconnect`: Updates service API and documentation

Release v1.21.5 (2019-07-25)
===

### Service Client Updates
* `service/ecr`: Updates service API and documentation
  * This release adds support for immutable image tags.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert has added several features including support for: audio normalization using ITU BS.1770-3, 1770-4 algorithms, extension of job progress indicators, input cropping rectangle & output position rectangle filters per input, and dual SCC caption mapping to additional codecs and containers.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive is adding Input Clipping, Immediate Mode Input Switching, and Dynamic Inputs.

Release v1.21.4 (2019-07-24)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release introduces support for split tunnel with AWS Client VPN, and also adds support for opt-in Regions in DescribeRegions API. In addition, customers can now also tag Launch Templates on creation.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * This release provides GlueVersion option for Job APIs and WorkerType option for DevEndpoint APIs. Job APIs enable users to pick specific GlueVersion for a specific job and pin the job to a specific runtime environment. DevEndpoint APIs enable users to pick different WorkerType for memory intensive workload.
* `service/pinpoint`: Updates service API and documentation
  * This release adds support for programmatic access to many of the same campaign metrics that are displayed on the Amazon Pinpoint console. You can now use the Amazon Pinpoint API to monitor and assess performance data for campaigns, and integrate metrics data with other reporting tools. We update the metrics data continuously, resulting in a data latency timeframe that is limited to approximately two hours.
* `service/sts`: Updates service API and documentation
  * New STS GetAccessKeyInfo API operation that returns the account identifier for the specified access key ID.

Release v1.21.3 (2019-07-23)
===

### Service Client Updates
* `service/secretsmanager`: Updates service API and documentation
  * This release increases the maximum allowed size of SecretString or SecretBinary from 7KB to 10KB in the CreateSecret, UpdateSecret, PutSecretValue and GetSecretValue APIs. This release also increases the maximum allowed size of ResourcePolicy from 4KB to 20KB in the GetResourcePolicy and PutResourcePolicy APIs.
* `service/ssm`: Updates service API and documentation
  * You can now use Maintenance Windows to select a resource group as the target. By selecting a resource group as the target of a Maintenance Window, customers can perform routine tasks across different resources such as Amazon Elastic Compute Cloud (AmazonEC2) instances, Amazon Elastic Block Store (Amazon EBS) volumes, and Amazon Simple Storage Service(Amazon S3) buckets within the same recurring time window.

Release v1.21.2 (2019-07-22)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mq`: Updates service API and documentation
  * Adds support for AWS Key Management Service (KMS) to offer server-side encryption. You can now select your own customer managed CMK, or use an AWS managed CMK in your KMS  account.
* `service/shield`: Updates service API and documentation
  * Adding new VectorType (HTTP_Reflection) and related top contributor types to describe WordPress Pingback DDoS attacks.

### SDK Enhancements
* Fixup SDK source formating, test error checking, and simplify type conervsions
  * [#2703](https://github.com/aws/aws-sdk-go/pull/2703), [#2704](https://github.com/aws/aws-sdk-go/pull/2704), [#2705](https://github.com/aws/aws-sdk-go/pull/2705), [#2706](https://github.com/aws/aws-sdk-go/pull/2706), [#2707](https://github.com/aws/aws-sdk-go/pull/2707), [#2708](https://github.com/aws/aws-sdk-go/pull/2708)

### SDK Bugs
* `aws/request`: Fix SDK error checking when seeking readers ([#2696](https://github.com/aws/aws-sdk-go/pull/2696))
  * Fixes the SDK handling of seeking a reader to ensure errors are not lost, and are bubbled up.
  * In several places the SDK ignored Seek errors when attempting to determine a reader's length, or rewinding the reader for retry attempts.
  * Related to [#2525](https://github.com/aws/aws-sdk-go/issues/2525)
Release v1.21.1 (2019-07-19)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iotevents`: Updates service API and documentation
* `service/sqs`: Updates service documentation
  * This release updates the information about the availability of FIFO queues and includes miscellaneous fixes.

Release v1.21.0 (2019-07-18)
===

### Service Client Updates
* `service/codedeploy`: Updates service documentation
  * Documentation updates for codedeploy
* `service/comprehend`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for cluster settings. Cluster settings specify whether CloudWatch Container Insights is enabled or disabled for the cluster.
* `service/elasticache`: Updates service documentation
  * Updates for Elasticache

### SDK Features
* `aws/session`: Add support for assuming role via Web Identity Token ([#2667](https://github.com/aws/aws-sdk-go/pull/2667))
  * Adds support for assuming an role via the Web Identity Token. Allows for OIDC token files to be used by specifying the token path through the AWS_WEB_IDENTITY_TOKEN_FILE, and AWS_ROLE_ARN environment variables.

### SDK Bugs
* `aws/session`: Fix SDK AWS_PROFILE and static environment credential behavior ()
  * Fixes the SDK's behavior when determining the source of credentials to load. Previously the SDK would ignore the AWS_PROFILE environment, if static environment credentials were also specified.
  * If both AWS_PROFILE and static environment credentials are defined, the SDK will load any credentials from the shared config/credentials file for the AWS_PROFILE first. Only if there are no credentials defined in the shared config/credentials file will the SDK use the static environment credentials instead.
Release v1.20.21 (2019-07-17)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for autoscaling
* `service/config`: Updates service API
* `service/dms`: Updates service API and documentation
  * S3 endpoint settings update: 1) Option to append operation column to full-load files. 2) Option to add a commit timestamp column to full-load and cdc files. Updated DescribeAccountAttributes to include UniqueAccountIdentifier.

Release v1.20.20 (2019-07-12)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/es`: Updates service API
  * Amazon Elasticsearch Service now supports M5, C5, and R5 instance types.
* `service/iam`: Updates service API
  * Removed exception that was indicated but never thrown for IAM GetAccessKeyLastUsed API
* `service/robomaker`: Updates service API and documentation

Release v1.20.19 (2019-07-11)
===

### Service Client Updates
* `service/eventbridge`: Adds new service
* `service/events`: Updates service API and documentation
  * Adds APIs for partner event sources, partner event buses, and custom event buses. These new features are managed in the EventBridge service.

### SDK Enhancements
* `aws/session`: Add Assume role for credential process from aws shared config ([#2674](https://github.com/aws/aws-sdk-go/pull/2674))
  * Adds support for assuming role using credential process from the shared config file. Also updated SDK's environment testing and added SDK's CI testing with Windows.
* `aws/csm`: Add support for AWS_CSM_HOST env option ([#2677](https://github.com/aws/aws-sdk-go/pull/2677))
  * Adds support for a host to be configured for the SDK's metric reporting Client Side Metrics (CSM) client via the AWS_CSM_HOST environment variable.

Release v1.20.18 (2019-07-10)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glacier`: Updates service documentation
  * Documentation updates for glacier
* `service/quicksight`: Updates service API and documentation
  * Amazon QuickSight now supports embedding dashboards for all non-federated QuickSight users. This includes IAM users, AD users and users from the QuickSight user pool. The get-dashboard-embed-url API accepts QUICKSIGHT as identity type with a user ARN to authenticate the embeddable dashboard viewer as a non-federated user.
* `service/servicecatalog`: Updates service API and documentation
  * This release adds support for Parameters in ExecuteProvisionedProductServiceAction and adds functionality to get the default parameter values for a Self-Service Action execution against a Provisioned Product via DescribeServiceActionExecutionParameters

Release v1.20.17 (2019-07-09)
===

### Service Client Updates
* `service/amplify`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/elasticfilesystem`: Updates service API and documentation
  * EFS customers can now enable Lifecycle Management for all file systems. You can also now select from one of four Lifecycle Management policies (14, 30, 60 and 90 days), to automatically move files that have not been accessed for the period of time defined by the policy, from the EFS Standard storage class to the EFS Infrequent Access (IA) storage class. EFS IA provides price/performance that is cost-optimized for files that are not accessed every day.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/gamelift`: Updates service API and documentation
  * GameLift FlexMatch now supports matchmaking of up to 200 players per game session, and FlexMatch can now automatically backfill your game sessions whenever there is an open slot.
* `service/kinesis-video-archived-media`: Updates service API, documentation, and paginators
* `service/kinesisvideo`: Updates service API and paginators
  * Add "GET_DASH_STREAMING_SESSION_URL" as an API name to the GetDataEndpoint API.
* `service/monitoring`: Updates service API and documentation
  * This release adds three new APIs (PutAnomalyDetector, DeleteAnomalyDetector, and DescribeAnomalyDetectors) to support the new feature, CloudWatch Anomaly Detection. In addition, PutMetricAlarm and DescribeAlarms APIs are updated to support management of Anomaly Detection based alarms.
* `service/waf`: Updates service API and documentation
  * Updated SDK APIs to add tags to WAF Resources: WebACL, Rule, Rulegroup and RateBasedRule. Tags can also be added during creation of these resources.
* `service/waf-regional`: Updates service API and documentation

Release v1.20.16 (2019-07-08)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.20.15 (2019-07-03)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * AssignPrivateIpAddresses response includes two new fields: AssignedPrivateIpAddresses, NetworkInterfaceId
* `service/rds`: Updates service API and documentation
  * This release supports Cross-Account Cloning for Amazon Aurora clusters.
* `service/s3`: Updates service API, documentation, and examples
  * Add S3 x-amz-server-side-encryption-context support.
* `service/swf`: Updates service API and documentation
  * This release adds APIs that allow adding and removing tags to a SWF domain, and viewing tags for a domain. It also enables adding tags when creating a domain.

Release v1.20.14 (2019-07-02)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Adding ImageBuilderName in Fleet API and Documentation updates for AppStream.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediastore`: Updates service API, documentation, and paginators
  * This release adds support for tagging, untagging, and listing tags for AWS Elemental MediaStore containers.

Release v1.20.13 (2019-07-01)
===

### Service Client Updates
* `service/docdb`: Updates service API and documentation
  * This release provides support for cluster delete protection and the ability to stop and start clusters.
* `service/ec2`: Updates service API and documentation
  * This release adds support for specifying a maximum hourly price for all On-Demand and Spot instances in both Spot Fleet and EC2 Fleet.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/organizations`: Updates service API and documentation
  * Specifying the tag key and tag value is required for tagging requests.
* `service/rds`: Updates service API and documentation
  * This release adds support for RDS DB Cluster major version upgrade

Release v1.20.12 (2019-06-28)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * You can now launch 8xlarge and 16xlarge instance sizes on the general purpose M5 and memory optimized R5 instance types.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/redshift`: Updates service API and documentation
  * ClusterAvailabilityStatus: The availability status of the cluster for queries. Possible values are the following: Available, Unavailable, Maintenance, Modifying, Failed.
* `service/workspaces`: Updates service API and documentation
  * Minor API fixes for WorkSpaces.

Release v1.20.11 (2019-06-27)
===

### Service Client Updates
* `service/directconnect`: Updates service API and documentation
  * Tags will now be included in the API responses of all supported resources (Virtual interfaces, Connections, Interconnects and LAGs). You can also add tags while creating these resources.
* `service/ec2-instance-connect`: Adds new service
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/pinpoint`: Updates service API and documentation
  * This release includes editorial updates for the Amazon Pinpoint API documentation.
* `service/workspaces`: Updates service API and documentation
  * Added support for the WorkSpaces restore feature and copying WorkSpaces Images across AWS Regions.

Release v1.20.10 (2019-06-27)
===

### Service Client Updates
* `service/dynamodb`: Updates service documentation and examples
  * Documentation updates for dynamodb
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.20.9 (2019-06-26)
===

### Service Client Updates
* `service/apigatewayv2`: Updates service API and documentation
* `service/codecommit`: Updates service API and documentation
  * This release supports better exception handling for merges.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.20.8 (2019-06-25)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and paginators
  * Starting today, you can use Traffic Mirroring  to copy network traffic from an elastic network interface of Amazon EC2 instances and then send it to out-of-band security and monitoring appliances for content inspection, threat monitoring, and troubleshooting. These appliances can be deployed as individual instances, or as a fleet of instances behind a Network Load Balancer with a User Datagram Protocol (UDP) listener. Traffic Mirroring supports filters and packet truncation, so that you only extract the traffic of interest to monitor by using monitoring tools of your choice.
* `service/eks`: Updates service API

Release v1.20.7 (2019-06-24)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Customers can pick different security policies (TLS version + cipher suite) for custom domains in API Gateway
* `service/apigatewayv2`: Updates service API and documentation
  * Customers can get information about security policies set on custom domain resources in API Gateway
* `service/application-insights`: Adds new service
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/fsx`: Updates service API and documentation
* `service/resourcegroupstaggingapi`: Updates service API, documentation, and paginators
  * Updated service APIs and documentation.
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/service-quotas`: Adds new service
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager now supports deleting a specific version of a SSM Document.

Release v1.20.6 (2019-06-21)
===

### Service Client Updates
* `service/devicefarm`: Updates service documentation
  * This release includes updated documentation about the default timeout value for test runs and remote access sessions. This release also includes miscellaneous bug fixes for the documentation.
* `service/iam`: Updates service API, documentation, and examples
  * We are making it easier for you to manage your permission guardrails i.e. service control policies by enabling you to retrieve the last timestamp when an AWS service was accessed within an account or AWS Organizations entity.
* `service/kinesis-video-media`: Updates service documentation
* `service/mediapackage`: Updates service API and documentation
  * Added two new origin endpoint fields for configuring which SCTE-35 messages are treated as advertisements.

Release v1.20.5 (2019-06-20)
===

### Service Client Updates
* `service/acm-pca`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API, documentation, and paginators
  * Starting today, you can now use workflows in AWS Glue to author directed acyclic graphs (DAGs) of Glue triggers, crawlers and jobs. Workflows enable orchestration of your ETL workloads by building dependencies between Glue entities (triggers, crawlers and jobs).  You can visually track status of the different nodes in the workflows on the console making it easier to monitor progress and troubleshoot issues. Also, you can share parameters across entities in the workflow.
* `service/health`: Updates service API and documentation
  * API improvements for the AWS Health service.
* `service/iotevents-data`: Updates service API and documentation
* `service/opsworks`: Updates service documentation
  * Documentation updates for OpsWorks Stacks.
* `service/rds`: Updates service API and documentation
  * This release adds support for RDS storage autoscaling

Release v1.20.4 (2019-06-19)
===

### Service Client Updates
* `service/eks`: Updates service documentation

Release v1.20.3 (2019-06-18)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * You can now launch new 12xlarge, 24xlarge, and metal instance sizes on the Amazon EC2 compute optimized C5 instance types featuring 2nd Gen Intel Xeon Scalable Processors.
* `service/resourcegroupstaggingapi`: Updates service API, documentation, and paginators
  * You can use tag policies to help standardize on tags across your organization's resources.

Release v1.20.2 (2019-06-17)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/neptune`: Updates service API and documentation
  * This release adds a feature to configure Amazon Neptune to publish audit logs to Amazon CloudWatch Logs.
* `service/robomaker`: Updates service API and documentation
* `service/servicecatalog`: Updates service API
  * Restrict concurrent calls by a single customer account for CreatePortfolioShare and DeletePortfolioShare when sharing/unsharing to an Organization.

Release v1.20.1 (2019-06-14)
===

### Service Client Updates
* `service/appstream`: Updates service API
  * Added 2 new values(WINDOWS_SERVER_2016, WINDOWS_SERVER_2019) for PlatformType enum.
* `service/cloudfront`: Adds new service
  * A new datatype in the CloudFront API, AliasICPRecordal, provides the ICP recordal status for CNAMEs associated with distributions. AWS services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they have added to CloudFront. The status value is returned in the CloudFront response; you cannot configure it yourself. The status is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
* `service/ec2`: Updates service API
  * Correction to enumerations in EC2 client.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/personalize`: Updates service documentation

Release v1.20.0 (2019-06-13)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `service/ec2`: Updates service API
  * G4 instances are Amazon EC2 instances based on NVIDIA T4 GPUs and are designed to provide cost-effective machine learning inference for applications, like image classification, object detection, recommender systems, automated speech recognition, and language translation. G4 instances are also a cost-effective platform for building and running graphics-intensive applications, such as remote graphics workstations, video transcoding, photo-realistic design, and game streaming in the cloud. To get started with G4 instances visit https://aws.amazon.com/ec2/instance-types/g4.
* `service/elasticache`: Updates service API and documentation
  * This release is to add support for reader endpoint for cluster-mode disabled Amazon ElastiCache for Redis clusters.
* `service/guardduty`: Updates service API, documentation, and paginators
  * Support for tagging functionality in Create and Get operations for Detector, IP Set, Threat Intel Set, and Finding Filter resources and 3 new tagging APIs: ListTagsForResource, TagResource, and UntagResource.

### SDK Features

* `aws/session`: Add support for chaining assume IAM role from shared config ([#2579](https://github.com/aws/aws-sdk-go/pull/2579))
  * Adds support chaining assume role credentials from the shared config/credentials files. This change allows you to create an assume role chain of multiple levels of assumed IAM roles. The config profile the deepest in the chain must use static credentials, or `credential_source`. If the deepest profile doesn't have either of these the session will fail to load.
  * Fixes the SDK's shared config credential source not assuming a role with environment and ECS credentials. EC2 credentials were already supported.
  * Fix [#2528](https://github.com/aws/aws-sdk-go/issue/2528)
  * Fix [#2385](https://github.com/aws/aws-sdk-go/issue/2385)

### SDK Enhancements
* `service/s3/s3manager/s3manageriface`: Add missing methods ([#2612](https://github.com/aws/aws-sdk-go/pull/2612))
  * Adds the missing interface and methods from the `s3manager` Uploader, Downloader, and Batch Delete utilities.

Release v1.19.49 (2019-06-12)
===

### Service Client Updates
* `service/servicecatalog`: Updates service API and documentation
  * This release adds a new field named Guidance to update provisioning artifact, this field can be set by the administrator to provide guidance to end users about which provisioning artifacts to use.

Release v1.19.48 (2019-06-11)
===

### Service Client Updates
* `service/sagemaker`: Updates service API and documentation
  * The default TaskTimeLimitInSeconds of labeling job is increased to 8 hours. Batch Transform introduces a new DataProcessing field which supports input and output filtering and data joining. Training job increases the max allowed input channels from 8 to 20.

Release v1.19.47 (2019-06-10)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * AWS CodeBuild adds support for source version on project level.
* `service/codecommit`: Updates service API, documentation, and paginators
  * This release adds two merge strategies for merging pull requests: squash and three-way. It also adds functionality for resolving merge conflicts, testing merge outcomes, and for merging branches using one of the three supported merge strategies.
* `service/personalize`: Adds new service
* `service/personalize-events`: Adds new service
* `service/personalize-runtime`: Adds new service

Release v1.19.46 (2019-06-07)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds DNS entries and NLB ARNs to describe-vpc-endpoint-connections API response. Adds owner ID to describe-vpc-endpoints and create-vpc-endpoint API responses.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.19.45 (2019-06-06)
===

### Service Client Updates
* `service/dynamodb`: Updates service documentation
  * Documentation updates for dynamodb
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for launching container instances using supported Amazon EC2 instance types that have increased elastic network interface density. Using these instance types and opting in to the awsvpcTrunking account setting provides increased elastic network interface (ENI) density on newly launched container instances which allows you to place more tasks on each container instance.
* `service/email`: Updates service API and documentation
  * You can now specify whether the Amazon Simple Email Service must deliver email over a connection that is encrypted using Transport Layer Security (TLS).
* `service/guardduty`: Updates service API, documentation, paginators, and examples
  * Improve FindingCriteria Condition field names, support long-typed conditions and deprecate old Condition field names.
* `service/logs`: Updates service documentation
  * Documentation updates for logs
* `service/mediaconnect`: Updates service API and documentation
* `service/organizations`: Updates service API, documentation, and paginators
  * You can tag and untag accounts in your organization and view tags on an account in your organization.
* `service/ssm`: Updates service API and documentation
  * OpsCenter is a new Systems Manager capability that allows you to view, diagnose, and remediate, operational issues, aka OpsItems, related to various AWS resources by bringing together contextually relevant investigation information. New APIs to create, update, describe, and get OpsItems as well as OpsItems summary API.

Release v1.19.44 (2019-06-05)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Support specifying python version for Python shell jobs. A new parameter PythonVersion is added to the JobCommand data type.

Release v1.19.43 (2019-06-04)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for Host Recovery feature which automatically restarts instances on to a new replacement host if failures are detected on Dedicated Host.
* `service/elasticache`: Updates service API, documentation, and paginators
  * Amazon ElastiCache now allows you to apply available service updates on demand. Features included: (1) Access to the list of applicable service updates and their priorities. (2) Service update monitoring and regular status updates. (3) Recommended apply-by-dates for scheduling the service updates, which is critical if your cluster is in ElastiCache-supported compliance programs. (4) Ability to stop and later re-apply updates. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iam`: Updates service API, documentation, and examples
  * This release adds validation for policy path field. This field is now restricted to be max 512 characters.
* `service/s3`: Updates service documentation
  * Documentation updates for s3
* `service/storagegateway`: Updates service API and documentation
  * AWS Storage Gateway now supports AWS PrivateLink, enabling you to administer and use gateways without needing to use public IP addresses or a NAT/Internet Gateway, while avoiding traffic from going over the internet.

Release v1.19.42 (2019-06-03)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Amazon EC2 I3en instances are the new storage-optimized instances offering up to 60 TB NVMe SSD instance storage and up to 100 Gbps of network bandwidth.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service documentation
  * Amazon RDS Data API is generally available. Removing beta notes in the documentation.

Release v1.19.41 (2019-05-30)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * This release adds APIs that allow adding and removing tags to a repository, and viewing tags for a repository. It also enables adding tags when creating a repository.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iotanalytics`: Updates service API and documentation
* `service/iotevents`: Adds new service
* `service/iotevents-data`: Adds new service
* `service/kafka`: Updates service API, documentation, and paginators
* `service/pinpoint-email`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * This release adds support for Activity Streams for database clusters.
* `service/rds-data`: Updates service API, documentation, and examples
* `service/servicecatalog`: Updates service API and documentation
  * Service Catalog ListStackInstancesForProvisionedProduct API enables customers to get details of a provisioned product with type "CFN_STACKSET". By passing the provisioned product id, the API will list account, region and status of each stack instances that are associated with this provisioned product.

Release v1.19.40 (2019-05-29)
===

### Service Client Updates
* `service/dlm`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Customers can now simultaneously take snapshots of multiple EBS volumes attached to an EC2 instance. With this new capability, snapshots guarantee crash-consistency across multiple volumes by preserving the order of IO operations. This new feature is fully integrated with Amazon Data Lifecycle Manager (DLM) allowing customers to automatically manage snapshots by creating lifecycle policies.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iotthingsgraph`: Adds new service
* `service/rds`: Updates service documentation
  * Documentation updates for rds
* `service/securityhub`: Updates service API, documentation, and paginators
* `service/ssm`: Updates service documentation
  * Systems Manager - Documentation updates

### SDK Enhancements
* `service/mediastoredata`: Add support for nonseekable io.Reader ([#2622](https://github.com/aws/aws-sdk-go/pull/2622))
  * Updates the SDK's documentation to clarify how you can use the SDK's `aws.ReadSeekCloser` utility function to wrap an io.Reader to be used with an API operation that allows streaming unsigned payload in the operation's request.
  * Adds example using ReadSeekCloser with AWS Elemental MediaStore Data's PutObject API operation.
* Update CI validation testing for Go module files ([#2626](https://github.com/aws/aws-sdk-go/pull/2626))
  * Suppress changes to the Go module definition files during CI code generation validation testing.

### SDK Bugs
* `service/pinpointemail`: Fix client unable to make API requests ([#2625](https://github.com/aws/aws-sdk-go/pull/2625))
  * Fixes the API client's code generation to ignore the `targetPrefix` modeled value. This value is not valid for the REST-JSON protocol.
  * Updates the SDK's code generation to ignore the `targetPrefix` for all protocols other than RPCJSON.

Release v1.19.39 (2019-05-28)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * This release adds the ability to search and order toll free phone numbers for Voice Connectors.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/groundstation`: Adds new service
* `service/pinpoint-email`: Updates service API, documentation, and paginators
* `service/rds`: Updates service API and documentation
  * Add a new output field Status to DBEngineVersion which shows the status of the engine version (either available or deprecated). Add a new parameter IncludeAll to DescribeDBEngineVersions to make it possible to return both available and deprecated engine versions. These changes enable a user to create a Read Replica of an DB instance on a deprecated engine version.
* `service/robomaker`: Updates service API and documentation
* `service/storagegateway`: Updates service API and documentation
  * Introduce AssignTapePool operation to allow customers to migrate tapes between pools.
* `service/sts`: Updates service documentation
* `service/transcribe`: Updates service API
* `service/waf`: Updates service documentation
  * Documentation updates for waf

Release v1.19.38 (2019-05-24)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * AWS CodeDeploy now supports tagging for the application and deployment group resources.
* `service/mediastore-data`: Updates service API, documentation, and paginators
* `service/opsworkscm`: Updates service documentation
  * Documentation updates for OpsWorks for Chef Automate; attribute values updated for Chef Automate 2.0 release.

### SDK Bugs
* `service/dynamodb/expression`: Fix Builder with KeyCondition example ([#2618](https://github.com/aws/aws-sdk-go/pull/2618))
  * Fixes the ExampleBuilder_WithKeyCondition example to include the ExpressionAttributeNames member being set.
  * Related to [aws/aws-sdk-go-v2#285](https://github.com/aws/aws-sdk-go-v2/issues/285)
* `private/model/api`: Improve SDK API reference doc generation ([#2617](https://github.com/aws/aws-sdk-go/pull/2617))
  * Improves the SDK's generated documentation for API client, operation, and types. This fixes several bugs in the doc generation causing poor formatting, an difficult to read reference documentation.
  * Fixes [#2572](https://github.com/aws/aws-sdk-go/pull/2572)
  * Fixes [#2374](https://github.com/aws/aws-sdk-go/pull/2374)

Release v1.19.37 (2019-05-23)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * New APIs to enable EBS encryption by default feature. Once EBS encryption by default is enabled in a region within the account, all new EBS volumes and snapshot copies are always encrypted
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/waf-regional`: Updates service documentation

Release v1.19.36 (2019-05-22)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * This release adds support for tagging of Amazon API Gateway resources.
* `service/budgets`: Updates service API and documentation
  * Added new datatype PlannedBudgetLimits to Budget model, and updated examples for AWS Budgets API for UpdateBudget, CreateBudget, DescribeBudget, and DescribeBudgets
* `service/devicefarm`: Updates service API and documentation
  * This release introduces support for tagging, tag-based access control, and resource-based access control.
* `service/ec2`: Updates service API and documentation
  * This release adds idempotency support for associate, create route and authorization APIs for AWS Client VPN Endpoints.
* `service/elasticfilesystem`: Updates service API and documentation
  * AWS EFS documentation updated to reflect the minimum required value for ProvisionedThroughputInMibps is 1 from the previously documented 0. The service has always required a minimum value of 1, therefor service behavior is not changed.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service documentation
  * Documentation updates for rds
* `service/servicecatalog`: Updates service API and documentation
  * Service Catalog UpdateProvisionedProductProperties API enables customers to manage provisioned product ownership. Administrators can now update the user associated to a provisioned product to another user within the same account allowing the new user to describe, update, terminate and execute service actions in that Service Catalog resource. New owner will also be able to list and describe all past records executed for that provisioned product.
* `service/worklink`: Updates service API, documentation, and paginators

Release v1.19.35 (2019-05-21)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API, documentation, and paginators
* `service/datasync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.19.34 (2019-05-20)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kafka`: Updates service API, documentation, and paginators
* `service/mediapackage-vod`: Adds new service
* `service/meteringmarketplace`: Updates service documentation
  * Documentation updates for meteringmarketplace

### SDK Enhancements
* Add raw error message bytes to SerializationError errors ([#2600](https://github.com/aws/aws-sdk-go/pull/2600))
  * Updates the SDK's API error message SerializationError handling to capture the original error message byte, and include it in the SerializationError error value.
  * Fixes [#2562](https://github.com/aws/aws-sdk-go/issues/2562), [#2411](https://github.com/aws/aws-sdk-go/issues/2411), [#2315](https://github.com/aws/aws-sdk-go/issues/2315)

### SDK Bugs
* `service/s3/s3manager`: Fix uploader to check for empty part before max parts check (#2556)
  * Fixes the S3 Upload manager's behavior for uploading exactly MaxUploadParts * PartSize to S3. The uploader would previously return an error after the full content was uploaded, because the assert on max upload parts was occurring before the check if there were any more parts to upload.
  * Fixes [#2557](https://github.com/aws/aws-sdk-go/issues/2557)

Release v1.19.33 (2019-05-17)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Includes APIs for managing subscriptions to AppStream 2.0 usage reports and configuring idle disconnect timeouts on AppStream 2.0 fleets.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.19.32 (2019-05-16)
===

### Service Client Updates
* `service/medialive`: Updates service waiters and paginators
  * Added channel state waiters to MediaLive.
* `service/s3`: Updates service API, documentation, and examples
  * This release updates the Amazon S3 PUT Bucket replication API to include a new optional field named token, which allows you to add a replication configuration to an S3 bucket that has Object Lock enabled.

Release v1.19.31 (2019-05-15)
===

### Service Client Updates
* `service/codepipeline`: Updates service API, documentation, and paginators
  * This feature includes new APIs to add, edit, remove and view tags for pipeline, custom action type and webhook resources. You can also add tags while creating these resources.
* `service/ec2`: Updates service API and documentation
  * Adding tagging support for VPC Endpoints and VPC Endpoint Services.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediapackage`: Updates service API and documentation
  * Adds optional configuration for DASH SegmentTemplateFormat to refer to segments by Number with Duration, rather than Number or Time with SegmentTimeline.
* `service/rds`: Updates service documentation
  * In the RDS API and CLI documentation, corrections to the descriptions for Boolean parameters to avoid references to TRUE and FALSE. The RDS CLI does not allow TRUE and FALSE values values for Boolean parameters.
* `service/transcribe`: Updates service API

Release v1.19.30 (2019-05-14)
===

### Service Client Updates
* `service/chime`: Updates service API and documentation
  * Amazon Chime private bots GA release.
* `service/comprehend`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API, documentation, and paginators
  * Pagination support for ec2.DescribeSubnets, ec2.DescribeDhcpOptions
* `service/storagegateway`: Updates service API and documentation
  * Add Tags parameter to CreateSnapshot and UpdateSnapshotSchedule APIs, used for creating tags on create for one off snapshots and scheduled snapshots.

Release v1.19.29 (2019-05-13)
===

### Service Client Updates
* `service/datasync`: Updates service API and documentation
* `service/iotanalytics`: Updates service API and documentation
* `service/lambda`: Updates service API and waiters
  * AWS Lambda now supports Node.js v10

Release v1.19.28 (2019-05-10)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * AWS Glue now supports specifying existing catalog tables for a crawler to examine as a data source. A new parameter CatalogTargets is added to the CrawlerTargets data type.
* `service/sts`: Updates service API, documentation, and examples
  * AWS Security Token Service (STS) now supports passing IAM Managed Policy ARNs as session policies when you programmatically create temporary sessions for a role or federated user. The Managed Policy ARNs can be passed via the PolicyArns parameter, which is now available in the AssumeRole, AssumeRoleWithWebIdentity, AssumeRoleWithSAML, and GetFederationToken APIs. The session policies referenced by the PolicyArn parameter will only further restrict the existing permissions of an IAM User or Role for individual sessions.

Release v1.19.27 (2019-05-08)
===

### Service Client Updates
* `service/eks`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot1click-projects`: Updates service paginators
* `service/kinesisanalytics`: Updates service API and documentation
  * Kinesis Data Analytics APIs now support tagging on applications.
* `service/kinesisanalyticsv2`: Updates service API and documentation
* `service/sagemaker`: Updates service API and documentation
  * Workteams now supports notification configurations. Neo now supports Jetson Nano as a target device and NumberOfHumanWorkersPerDataObject is now included in the ListLabelingJobsForWorkteam response.
* `service/servicecatalog`: Updates service API and documentation
  * Adds "Parameters" field in UpdateConstraint API, which will allow Admin user to update "Parameters" in created Constraints.

Release v1.19.26 (2019-05-07)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/appsync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/ssm`: Updates service API and documentation
  * Patch Manager adds support for Microsoft Application Patching.
* `service/storagegateway`: Updates service API and documentation
  * Add optional field AdminUserList to CreateSMBFileShare and UpdateSMBFileShare APIs.

Release v1.19.25 (2019-05-06)
===

### Service Client Updates
* `service/codepipeline`: Updates service documentation
  * Documentation updates for codepipeline
* `service/config`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for iam
* `service/sts`: Updates service documentation
  * Documentation updates for sts

Release v1.19.24 (2019-05-03)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconvert`: Updates service API and documentation
  * DASH output groups using DRM encryption can now enable a playback device compatibility mode to correct problems with playback on older devices.
* `service/medialive`: Updates service API and documentation
  * You can now switch the channel mode of your channels from standard to single pipeline and from single pipeline to standard. In order to switch a channel from single pipeline to standard all inputs attached to the channel must support two encoder pipelines.
* `service/workmail`: Updates service API, documentation, and paginators
  * Amazon WorkMail is releasing two new actions: 'GetMailboxDetails' and 'UpdateMailboxQuota'. They add insight into how much space is used by a given mailbox (size) and what its limit is (quota). A mailbox quota can be updated, but lowering the value will not influence WorkMail per user charges. For a closer look at the actions please visit https://docs.aws.amazon.com/workmail/latest/APIReference/API_Operations.html

Release v1.19.23 (2019-05-02)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kms`: Updates service API and documentation
  * AWS Key Management Service (KMS) can return an INTERNAL_ERROR connection error code if it cannot connect a custom key store to its AWS CloudHSM cluster. INTERNAL_ERROR is one of several connection error codes that help you to diagnose and fix a problem with your custom key store.

Release v1.19.22 (2019-05-01)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds an API for the modification of a VPN Connection, enabling migration from a Virtual Private Gateway (VGW) to a Transit Gateway (TGW), while preserving the VPN endpoint IP addresses on the AWS side as well as the tunnel options.
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces additional task definition parameters that enable you to define secret options for Docker log configuration, a per-container list contains secrets stored in AWS Systems Manager Parameter Store or AWS Secrets Manager.
* `service/xray`: Updates service API, documentation, and paginators
  * AWS X-Ray now includes Analytics, an interactive approach to analyzing user request paths (i.e., traces). Analytics will allow you to easily understand how your application and its underlying services are performing. With X-Ray Analytics, you can quickly detect application issues, pinpoint the root cause of the issue, determine the severity of the issues, and identify which end users were impacted. With AWS X-Ray Analytics you can explore, analyze, and visualize traces, allowing you to find increases in response time to user requests or increases in error rates. Metadata around peak periods, including frequency and actual times of occurrence, can be investigated by applying filters with a few clicks. You can then drill down on specific errors, faults, and response time root causes and view the associated traces.

Release v1.19.21 (2019-04-30)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * This release contains an update to the PipelineContext object that includes the Pipeline ARN, and the Pipeline Execution Id. The ActionContext object is also updated to include the Action Execution Id.
* `service/directconnect`: Updates service API and documentation
  * This release adds support for AWS Direct Connect customers to use AWS Transit Gateway with AWS Direct Connect gateway to route traffic between on-premise networks and their VPCs.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/managedblockchain`: Adds new service
* `service/neptune`: Updates service API, documentation, and examples
  * Adds a feature to allow customers to specify a custom parameter group when restoring a database cluster.
* `service/s3control`: Updates service API, documentation, and paginators
  * Add support for Amazon S3 Batch Operations.
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * Admin users can now associate/disassociate aws budgets with a portfolio or product in Service Catalog. End users can see the association by listing it or as part of the describe portfolio/product output. A new optional boolean parameter, "DisableTemplateValidation", is added to ProvisioningArtifactProperties data type. The purpose of the parameter is to enable or disable the CloudFormation template validtion when creating a product or a provisioning artifact.

Release v1.19.20 (2019-04-29)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds support for Elastic Fabric Adapter (EFA) ENIs.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/transfer`: Updates service API, documentation, and paginators
  * This release adds support for per-server host-key management. You can now specify the SSH RSA private key used by your SFTP server.

Release v1.19.19 (2019-04-26)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iam`: Updates service API, documentation, waiters, and examples
  * AWS Security Token Service (STS) enables you to request session tokens from the global STS endpoint that work in all AWS Regions. You can configure the global STS endpoint to vend session tokens that are compatible with all AWS Regions using the new IAM SetSecurityTokenServicePreferences API.
* `service/sns`: Updates service API and documentation
  * With this release AWS SNS adds tagging support for Topics.

Release v1.19.18 (2019-04-25)
===

### Service Client Updates
* `service/batch`: Updates service documentation
  * Documentation updates for AWS Batch.
* `service/dynamodb`: Updates service API and documentation
  * This update allows you to tag Amazon DynamoDB tables when you create them. Tags are labels you can attach to AWS resources to make them easier to manage, search, and filter.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/gamelift`: Updates service API and documentation
  * This release introduces the new Realtime Servers feature, giving game developers a lightweight yet flexible solution that eliminates the need to build a fully custom game server. The AWS SDK updates provide support for scripts, which are used to configure and customize Realtime Servers.
* `service/inspector`: Updates service API and documentation
  * AWS Inspector - Improve the ListFindings API response time and decreases the maximum number of agentIDs from 500 to 99.
* `service/lambda`: Updates service API and documentation
  * AWS Lambda now supports the GetLayerVersionByArn API.
* `service/workspaces`: Updates service documentation
  * Documentation updates for workspaces

Release v1.19.17 (2019-04-24)
===

### Bug Fixes
* `aws/endpoints`: Fix incorrect AWS Organizations global endpoint
  * Fixes the endpoint metadata for the AWS Organization in [Release v1.19.16](https://github.com/aws/aws-sdk-go/releases/tag/v1.19.16)

Release v1.19.16 (2019-04-24)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API, documentation, and paginators
* `service/cloudformation`: Updates service documentation
  * Documentation updates for cloudformation
* `service/ec2`: Updates service API
  * You can now launch the new Amazon EC2 general purpose burstable instance types T3a that feature AMD EPYC processors.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconnect`: Updates service API, documentation, and paginators
* `service/mediatailor`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * A new parameter "feature-name" is added to the add-role and remove-role db cluster APIs. The value for the parameter is optional for Aurora MySQL compatible database clusters, but mandatory for Aurora PostgresQL. You can find the valid list of values using describe db engine versions API.
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports the Asia Pacific (Hong Kong) Region (ap-east-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `service/ssm`: Updates service API and documentation
  * This release updates AWS Systems Manager APIs to allow customers to configure parameters to use either the standard-parameter tier (the default tier) or the advanced-parameter tier. It allows customers to create parameters with larger values and attach parameter policies to an Advanced Parameter.
* `service/storagegateway`: Updates service API, documentation, and paginators
  * AWS Storage Gateway now supports Access Control Lists (ACLs) on File Gateway SMB shares, enabling you to apply fine grained access controls for Active Directory users and groups.
* `service/textract`: Updates service API and documentation

Release v1.19.15 (2019-04-19)
===

### Service Client Updates
* `service/resource-groups`: Updates service API and documentation
* `service/transcribe`: Updates service API
* `service/workspaces`: Updates service API and documentation
  * Added a new reserved field.

Release v1.19.14 (2019-04-18)
===

### Service Client Updates
* `service/cognito-idp`: Updates service documentation
* `service/discovery`: Updates service API
  * The Application Discovery Service's DescribeImportTasks and BatchDeleteImportData APIs now return additional statuses for error reporting.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kafka`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * AWS Organizations is now available in the AWS GovCloud (US) Regions, and we added a new API action for creating accounts in those Regions. For more information, see CreateGovCloudAccount in the AWS Organizations API Reference.
* `service/rds`: Updates service API and documentation
  * This release adds the TimeoutAction parameter to the ScalingConfiguration of an Aurora Serverless DB cluster. You can now configure the behavior when an auto-scaling capacity change can't find a scaling point.
* `service/worklink`: Updates service API, documentation, and paginators
* `service/workspaces`: Updates service documentation
  * Documentation updates for workspaces

Release v1.19.13 (2019-04-17)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for requester-managed Interface VPC Endpoints (powered by AWS PrivateLink). The feature prevents VPC endpoint owners from accidentally deleting or otherwise mismanaging the VPC endpoints of some AWS VPC endpoint services.
* `service/polly`: Updates service API
  * Amazon Polly adds Arabic language support with new female voice - "Zeina"

Release v1.19.12 (2019-04-16)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API, documentation, and paginators
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring
* `service/mq`: Updates service API and documentation
  * This release adds the ability to retrieve information about broker engines and broker instance options. See Broker Engine Types and Broker Instance Options in the Amazon MQ REST API Reference.
* `service/organizations`: Updates service documentation
  * Documentation updates for organizations
* `service/redshift`: Updates service API and documentation
  * DescribeResize can now return percent of data transferred from source cluster to target cluster for a classic resize.
* `service/storagegateway`: Updates service API and documentation
  * This change allows you to select either a weekly or monthly maintenance window for your volume or tape gateway. It also allows you to tag your tape and volume resources on creation by adding a Tag value on calls to the respective api endpoints.

### SDK Enhancements
* `example/service/dynamodb`: Add custom unmarshaller error example for TransactWriteItems ([#2548](https://github.com/aws/aws-sdk-go/pull/2548))
  * Adds an example for building and using a custom unmarshaller to unmarshal TransactionCancelledExceptions from the error response of TransactWriteItems operation.

Release v1.19.11 (2019-04-05)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `service/glue`: Updates service API and documentation
  * AWS Glue now supports workerType choices in the CreateJob, UpdateJob, and StartJobRun APIs, to be used for memory-intensive jobs.
* `service/iot1click-devices`: Updates service API and documentation
* `service/mediaconvert`: Updates service API
  * Rectify incorrect modelling of DisassociateCertificate method
* `service/medialive`: Updates service API, documentation, and paginators
  * Today AWS Elemental MediaLive (https://aws.amazon.com/medialive/) adds the option to create "Single Pipeline" channels, which offers a lower-cost option compared to Standard channels. MediaLive Single Pipeline channels have a single encoding pipeline rather than the redundant dual Availability Zone (AZ) pipelines that MediaLive provides with a "Standard" channel.

Release v1.19.10 (2019-04-04)
===

### Service Client Updates
* `service/eks`: Updates service API and documentation
* `service/iam`: Updates service documentation
  * Documentation updates for iam

Release v1.19.9 (2019-04-03)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Support for GPU resource requirement in RegisterJobDefinition and SubmitJob
* `service/comprehend`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.19.8 (2019-04-02)
===

### Service Client Updates
* `service/acm`: Updates service documentation
  * Documentation updates for acm
* `service/ec2`: Updates service paginators
  * Add paginators.
* `service/securityhub`: Updates service API and documentation

Release v1.19.7 (2019-04-01)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API, documentation, and paginators
  * Amazon EMR adds the ability to modify instance group configurations on a running cluster through the new "configurations" field in the ModifyInstanceGroups API.
* `service/ssm`: Updates service documentation
  * March 2019 documentation updates for Systems Manager.

Release v1.19.6 (2019-03-29)
===

### Service Client Updates
* `service/comprehend`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/greengrass`: Updates service API and documentation
  * Greengrass APIs now support tagging operations on resources
* `service/monitoring`: Updates service API and documentation
  * Added 3 new APIs, and one additional parameter to PutMetricAlarm API, to support tagging of CloudWatch Alarms.

Release v1.19.5 (2019-03-28)
===

### Service Client Updates
* `service/medialive`: Updates service API and documentation
  * This release adds a new output locking mode synchronized to the Unix epoch.
* `service/pinpoint-email`: Updates service API and documentation
* `service/servicecatalog`: Updates service API and documentation
  * Adds "Tags" field in UpdateProvisionedProduct API. The product should have a new RESOURCE_UPDATE Constraint with TagUpdateOnProvisionedProduct field set to ALLOWED for it to work. See API docs for CreateConstraint for more information
* `service/workspaces`: Updates service API and documentation
  * Amazon WorkSpaces adds tagging support for WorkSpaces Images, WorkSpaces directories, WorkSpaces bundles and IP Access control groups.

Release v1.19.4 (2019-03-27)
===

### Service Client Updates
* `service/directconnect`: Updates service API and documentation
  * Direct Connect gateway enables you to establish connectivity between your on-premise networks and Amazon Virtual Private Clouds (VPCs) in any commercial AWS Region (except in China) using AWS Direct Connect connections at any AWS Direct Connect location. This release enables multi-account support for Direct Connect gateway, with multi-account support for Direct Connect gateway, you can associate up to ten VPCs from any AWS account with a Direct Connect gateway. The AWS accounts owning VPCs and the Direct Connect gateway must belong to the same AWS payer account ID. This release also enables Direct Connect Gateway owners to allocate allowed prefixes from each associated VPCs.
* `service/fms`: Updates service API, documentation, and paginators
* `service/iotanalytics`: Updates service API and documentation
* `service/mediaconvert`: Updates service API and documentation
  * This release adds support for detailed job progress status and S3 server-side output encryption. In addition, the anti-alias filter will now be automatically applied to all outputs
* `service/robomaker`: Updates service API, documentation, and paginators
* `service/transcribe`: Updates service API and documentation

Release v1.19.3 (2019-03-27)
===

### Service Client Updates
* `service/appmesh`: Updates service API, documentation, and paginators
* `service/ec2`: Updates service API
  * You can now launch the new Amazon EC2 R5ad and M5ad instances that feature local NVMe attached SSD instance storage (up to 3600 GB). M5ad and R5ad feature AMD EPYC processors that offer a 10% cost savings over the M5d and R5d EC2 instances.
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for external deployment controllers for ECS services with the launch of task set management APIs. Task sets are a new primitive for controlled management of application deployments within a single ECS service.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/s3`: Updates service API, documentation, and examples
  * S3 Glacier Deep Archive provides secure, durable object storage class for long term data archival. This SDK release provides API support for this new storage class.
* `service/storagegateway`: Updates service API and documentation
  * This change allows you to select a pool for archiving virtual tapes. Pools are associated with S3 storage classes. You can now choose to archive virtual tapes in either S3 Glacier or S3 Glacier Deep Archive storage class. CreateTapes API now takes a new PoolId parameter which can either be GLACIER or DEEP_ARCHIVE. Tapes created with this parameter will be archived in the corresponding storage class.
* `service/transfer`: Updates service API and documentation
  * This release adds PrivateLink support to your AWS SFTP server endpoint, enabling the customer to access their SFTP server within a VPC, without having to traverse the internet. Customers can now can create a server and specify an option whether they want the endpoint to be hosted as public or in their VPC, and with the in VPC option, SFTP clients and users can access the server only from the customer's VPC or from their on-premises environments using DX or VPN. This release also relaxes the SFTP user name requirements to allow underscores and hyphens.

Release v1.19.2 (2019-03-26)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * This new feature will now allow customers to add a customized csv classifier with classifier API. They can specify a custom delimiter, quote symbol and control other behavior they'd like crawlers to have while recognizing csv files
* `service/workmail`: Updates service API and documentation
  * Documentation updates for Amazon WorkMail.

Release v1.19.1 (2019-03-22)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot1click-projects`: Updates service API and documentation
* `service/transcribe`: Updates service API and documentation

Release v1.19.0 (2019-03-21)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation
  * Documentation updates for Amazon EC2 Auto Scaling
* `service/cognito-idp`: Updates service API and documentation
* `service/events`: Updates service API and documentation
  * Added 3 new APIs, and one additional parameter to the PutRule API, to support tagging of CloudWatch Events rules.
* `service/iot`: Updates service API and documentation
  * This release adds the GetStatistics API for the AWS IoT Fleet Indexing Service, which allows customers to query for statistics about registered devices that match a search query. This release only supports the count statistics. For more information about this API, see https://docs.aws.amazon.com/iot/latest/apireference/API_GetStatistics.html
* `service/lightsail`: Updates service API and documentation
  * This release adds the DeleteKnownHostKeys API, which enables Lightsail's browser-based SSH or RDP clients to connect to the instance after a host key mismatch.

### SDK Features
* `aws/credentials/stscreds`: Update StdinTokenProvider to prompt on stder ([#2481](https://github.com/aws/aws-sdk-go/pull/2481))
  * Updates the `stscreds` package default MFA token provider, `StdinTokenProvider`, to prompt on `stderr` instead of `stdout`. This is to make it possible to redirect/pipe output when using `StdinTokenProvider` and still seeing the prompt text.

Release v1.18.6 (2019-03-20)
===

### Service Client Updates
* `service/codepipeline`: Updates service API and documentation
  * Add support for viewing details of each action execution belonging to past and latest pipeline executions that have occurred in customer's pipeline. The details include start/updated times, action execution results, input/output artifacts information, etc. Customers also have the option to add pipelineExecutionId in the input to filter the results down to a single pipeline execution.
* `service/cognito-identity`: Updates service API and documentation
* `service/meteringmarketplace`: Updates service API and documentation
  * This release increases AWS Marketplace Metering Service maximum usage quantity to 2147483647 and makes parameters usage quantity and dryrun optional.

### SDK Bugs
* `private/protocol`: Use correct Content-Type for rest json protocol ([#2497](https://github.com/aws/aws-sdk-go/pull/2497))
  * Updates the SDK to use the correct `application/json` content type for all rest json protocol based AWS services. This fixes the bug where the jsonrpc protocol's `application/x-amz-json-X.Y` content type would be used for services like Pinpoint SMS.

Release v1.18.5 (2019-03-19)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/eks`: Updates service API and documentation

Release v1.18.4 (2019-03-18)
===

### Service Client Updates
* `service/chime`: Updates service API, documentation, and paginators
  * This release adds support for the Amazon Chime Business Calling and Voice Connector features.
* `service/dms`: Updates service API, documentation, and paginators
  * S3 Endpoint Settings added support for 1) Migrating to Amazon S3 as a target in Parquet format 2) Encrypting S3 objects after migration with custom KMS Server-Side encryption. Redshift Endpoint Settings added support for encrypting intermediate S3 objects during migration with custom KMS Server-Side encryption.
* `service/ec2`: Updates service API and documentation
  * DescribeFpgaImages API now returns a new DataRetentionSupport attribute to indicate if the AFI meets the requirements to support DRAM data retention. DataRetentionSupport is a read-only attribute.

Release v1.18.3 (2019-03-14)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * AWS Certificate Manager has added a new API action, RenewCertificate. RenewCertificate causes ACM to force the renewal of any private certificate which has been exported.
* `service/acm-pca`: Updates service API, documentation, and paginators
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * This release adds tagging support for Dedicated Host Reservations.
* `service/iot`: Updates service API and documentation
  * In this release, AWS IoT introduces support for tagging OTA Update and Stream resources. For more information about tagging, see the AWS IoT Developer Guide.
* `service/monitoring`: Updates service API, documentation, and paginators
  * New Messages parameter for the output of GetMetricData, to support new metric search functionality.
* `service/sagemaker`: Updates service API and documentation
  * Amazon SageMaker Automatic Model Tuning now supports random search and hyperparameter scaling.

Release v1.18.2 (2019-03-13)
===

### Service Client Updates
* `service/config`: Updates service API, documentation, and paginators
* `service/logs`: Updates service documentation
  * Documentation updates for logs

Release v1.18.1 (2019-03-12)
===

### Service Client Updates
* `service/serverlessrepo`: Updates service API and documentation

Release v1.18.0 (2019-03-11)
===

### Service Client Updates
* `service/ce`: Updates service API
* `service/elasticbeanstalk`: Updates service API and documentation
  * Elastic Beanstalk added support for tagging, and tag-based access control, of all Elastic Beanstalk resources.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * CreateDevEndpoint and UpdateDevEndpoint now support Arguments to configure the DevEndpoint.
* `service/iot`: Updates service documentation
  * Documentation updates for iot
* `service/quicksight`: Updates service API and documentation
  * Amazon QuickSight user and group operation results now include group principal IDs and user principal IDs. This release also adds "DeleteUserByPrincipalId", which deletes users given their principal ID. The update also improves role session name validation.
* `service/rekognition`: Updates service documentation
  * Documentation updates for Amazon Rekognition

### SDK Features
* `service/kinesis`: Enable support for SubscribeToStream API operation ([#2402](https://github.com/aws/aws-sdk-go/pull/2402))
  * Adds support for Kinesis's SubscribeToStream API operation. The API operation response type, `SubscribeToStreamOutput` member, EventStream has a method `Events` which returns a channel to read Kinesis record events from.

Release v1.17.14 (2019-03-08)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * CodeBuild also now supports Git Submodules.  CodeBuild now supports opting out of Encryption for S3 Build Logs.  By default these logs are encrypted.
* `service/s3`: Updates service documentation and examples
  * Documentation updates for s3
* `service/sagemaker`: Updates service API and documentation
  * SageMaker notebook instances now support enabling or disabling root access for notebook users. SageMaker Neo now supports rk3399 and rk3288 as compilation target devices.

Release v1.17.13 (2019-03-07)
===

### Service Client Updates
* `service/appmesh`: Adds new service
* `service/autoscaling`: Updates service documentation
  * Documentation updates for autoscaling
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces additional task definition parameters that enable you to define dependencies for container startup and shutdown, a per-container start and stop timeout value, as well as an AWS App Mesh proxy configuration which eases the integration between Amazon ECS and AWS App Mesh.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift-hosted instances can now securely access resources on other AWS services using IAM roles. See more details at https://aws.amazon.com/releasenotes/amazon-gamelift/.
* `service/greengrass`: Updates service API and documentation
  * Greengrass group UID and GID settings can now be configured to use a provided default via FunctionDefaultConfig. If configured, all Lambda processes in your deployed Greengrass group will by default start with the provided UID and/or GID, rather than by default starting with UID "ggc_user" and GID "ggc_group" as they would if not configured. Individual Lambdas can also be configured to override the defaults if desired via each object in the Functions list of your FunctionDefinitionVersion.
* `service/medialive`: Updates service API and documentation
  * This release adds a MediaPackage output group, simplifying configuration of outputs to AWS Elemental MediaPackage.
* `service/rds`: Updates service API and documentation
  * You can configure your Aurora database cluster to automatically copy tags on the cluster to any automated or manual database cluster snapshots that are created from the cluster. This allows you to easily set metadata on your snapshots to match the parent cluster, including access policies. You may enable or disable this functionality while creating a new cluster, or by modifying an existing database cluster.

Release v1.17.12 (2019-03-06)
===

### Service Client Updates
* `service/directconnect`: Updates service API and documentation
  * Exposed a new available port speeds field in the DescribeLocation api call.
* `service/ec2`: Updates service API, documentation, and paginators
  * This release adds pagination support for ec2.DescribeVpcs, ec2.DescribeInternetGateways and ec2.DescribeNetworkAcls APIs
* `service/elasticfilesystem`: Updates service examples
  * Documentation updates for elasticfilesystem adding new examples for EFS Lifecycle Management feature.

Release v1.17.11 (2019-03-05)
===

### Service Client Updates
* `service/codedeploy`: Updates service documentation
  * Documentation updates for codedeploy
* `service/medialive`: Updates service API and documentation
  * This release adds support for pausing and unpausing one or both pipelines at scheduled times.
* `service/storagegateway`: Updates service API and documentation
  * ActivateGateway, CreateNFSFileShare and CreateSMBFileShare APIs support a new parameter: Tags (to be attached to the created resource). Output for DescribeNFSFileShare, DescribeSMBFileShare and DescribeGatewayInformation APIs now also list the Tags associated with the resource. Minimum length of a KMSKey is now 7 characters.
* `service/textract`: Adds new service

Release v1.17.10 (2019-03-04)
===

### Service Client Updates
* `service/mediapackage`: Updates service API and documentation
  * This release adds support for user-defined tagging of MediaPackage resources. Users may now call operations to list, add and remove tags from channels and origin-endpoints. Users can also specify tags to be attached to these resources during their creation. Describe and list operations on these resources will now additionally return any tags associated with them.
* `service/ssm`: Updates service API and documentation
  * This release updates AWS Systems Manager APIs to support service settings for AWS customers.  A service setting is a key-value pair that defines how a user interacts with or uses an AWS service, and is typically created and consumed by the AWS service team. AWS customers can read a service setting via GetServiceSetting API and update the setting via UpdateServiceSetting API or ResetServiceSetting API, which are introduced in this release. For example, if an AWS service charges money to the account based on a feature or service usage, then the AWS service team might create a setting with the default value of "false".   This means the user can't use this feature unless they update the setting to "true" and  intentionally opt in for a paid feature.

Release v1.17.9 (2019-03-01)
===

### Service Client Updates
* `service/autoscaling-plans`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * This release adds support for modifying instance event start time which allows users to reschedule EC2 events.

### SDK Enhancements
* `example/service/s3`: Add example of S3 download with progress ([#2456](https://github.com/aws/aws-sdk-go/pull/2456))
  * Adds a new example to the S3 service's examples. This example shows how you could use the S3's GetObject API call in conjunction with a custom writer keeping track of progress.
  * Related to [#1868](https://github.com/aws/aws-sdk-go/pull/1868), [#2468](https://github.com/aws/aws-sdk-go/pull/2468)

### SDK Bugs
* `aws/session`: Allow HTTP Proxy with custom CA bundle ([#2343](https://github.com/aws/aws-sdk-go/pull/2343))
  * Ensures Go HTTP Client's  `ProxyFromEnvironment` functionality is still enabled when  custom CA bundles are used with the SDK.
  * Fix [#2287](https://github.com/aws/aws-sdk-go/pull/2287)

Release v1.17.8 (2019-02-28)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/apigatewayv2`: Updates service API and documentation
* `service/application-autoscaling`: Updates service documentation
* `service/ssm`: Updates service API and documentation

Release v1.17.7 (2019-02-28)
===

### Service Client Updates
* `service/waf`: Updates service documentation
  * Documentation updates for waf
* `service/waf-regional`: Updates service documentation

### SDK Bugs
* `aws/request`: Fix RequestUserAgent tests to be stable ([#2462](https://github.com/aws/aws-sdk-go/pull/2462))
  * Fixes the request User-Agent unit tests to be stable across all platforms and environments.
  * Fixes [#2366](https://github.com/aws/aws-sdk-go/issues/2366)
* `aws/ec2metadata`: Fix EC2 Metadata client panic with debug logging ([#2461](https://github.com/aws/aws-sdk-go/pull/2461))
  * Fixes a panic that could occur witihin the EC2 Metadata client when both `AWS_EC2_METADATA_DISABLED` env var is set and log level is LogDebugWithHTTPBody.
* `private/protocol/rest`: Trim space in header key and value ([#2460](https://github.com/aws/aws-sdk-go/pull/2460))
  * Updates the REST protocol marshaler to trip leading and trailing space from header keys and values before setting the HTTP request header. Fixes a bug when using S3 metadata where metadata values with leading spaces would trigger request signature validation errors when the request is received by the service.
  * Fixes [#2448](https://github.com/aws/aws-sdk-go/issues/2448)

Release v1.17.6 (2019-02-26)
===

### Service Client Updates
* `service/cur`: Updates service API, documentation, and examples
  * Adding support for Athena and new report preferences to the Cost and Usage Report API.
* `service/discovery`: Updates service documentation
  * Documentation updates for discovery
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconvert`: Updates service API and documentation
  * AWS Elemental MediaConvert SDK has added several features including support for: auto-rotation or user-specified rotation of 0, 90, 180, or 270 degrees; multiple output groups with DRM; ESAM XML documents to specify ad insertion points; Offline Apple HLS FairPlay content protection.
* `service/opsworkscm`: Updates service documentation
  * Documentation updates for opsworkscm
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations
* `service/pinpoint`: Updates service API and documentation
  * This release adds support for the Amazon Resource Groups Tagging API to Amazon Pinpoint, which means that you can now add and manage tags for Amazon Pinpoint projects (apps), campaigns, and segments. A tag is a label that you optionally define and associate with Amazon Pinpoint resource. Tags can help you categorize and manage these types of resources in different ways, such as by purpose, owner, environment, or other criteria. For example, you can use tags to apply policies or automation, or to identify resources that are subject to certain compliance requirements. A project, campaign, or segment can have as many as 50 tags. For more information about using and managing tags in Amazon Pinpoint, see the Amazon Pinpoint Developer Guide at https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html. For more information about the Amazon Resource Group Tagging API, see the Amazon Resource Group Tagging API Reference at https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html.
* `service/resource-groups`: Updates service documentation

Release v1.17.5 (2019-02-25)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Added support for passing an empty SpotMaxPrice parameter to remove a value previously set when updating an Amazon EC2 Auto Scaling group.
* `service/ce`: Updates service documentation
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/mediastore`: Updates service API and documentation
  * This release adds support for access logging, which provides detailed records for the requests that are made to objects in a container.

Release v1.17.4 (2019-02-22)
===

### Service Client Updates
* `service/athena`: Updates service API and documentation
  * This release adds tagging support for Workgroups to Amazon Athena. Use these APIs to add, remove, or list tags on Workgroups, and leverage the tags for various authorization and billing scenarios.
* `service/cloud9`: Updates service API and documentation
  * Adding EnvironmentLifecycle to the Environment data type.
* `service/glue`: Updates service API, documentation, and paginators
  * AWS Glue adds support for assigning AWS resource tags to jobs, triggers, development endpoints, and crawlers. Each tag consists of a key and an optional value, both of which you define. With this capacity, customers can use tags in AWS Glue to easily organize and identify your resources, create cost allocation reports, and control access to resources.
* `service/states`: Updates service API and documentation
  * This release adds support for tag-on-create. You can now add tags when you create AWS Step Functions activity and state machine resources. For more information about tagging, see AWS Tagging Strategies.

Release v1.17.3 (2019-02-21)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Add support for CodeBuild local caching feature
* `service/kinesis-video-archived-media`: Updates service API and documentation
* `service/kinesis-video-media`: Updates service documentation
* `service/kinesisvideo`: Updates service documentation
  * Documentation updates for Kinesis Video Streams
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring
* `service/organizations`: Updates service documentation
  * Documentation updates for organizations
* `service/transfer`: Updates service API and documentation
  * Bug fix: increased the max length allowed for request parameter NextToken when paginating List operations
* `service/workdocs`: Updates service documentation
  * Documentation updates for workdocs

Release v1.17.2 (2019-02-20)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * This release adds an API for adding / updating / deleting / copying / moving / setting file modes for one or more files directly to an AWS CodeCommit repository without requiring a Git client.
* `service/directconnect`: Updates service API and documentation
  * Documentation updates for AWS Direct Connect
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/medialive`: Updates service API and documentation
  * This release adds support for VPC inputs, allowing you to push content from your Amazon VPC directly to MediaLive.

Release v1.17.1 (2019-02-19)
===

### Service Client Updates
* `service/ds`: Updates service API and documentation
  * This release adds support for tags during directory creation (CreateDirectory, CreateMicrosoftAd, ConnectDirectory).
* `service/elasticfilesystem`: Updates service API, documentation, and examples
  * Amazon EFS now supports adding tags to file system resources as part of the CreateFileSystem API . Using this capability, customers can now more easily enforce tag-based authorization for EFS file system resources.
* `service/iot`: Updates service API and documentation
  * AWS IoT - AWS IoT Device Defender adds support for configuring behaviors in a security profile with statistical thresholds. Device Defender also adds support for configuring multiple data-point evaluations before a violation is either created or cleared.
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager now supports adding tags when creating Activations, Patch Baselines, Documents, Parameters, and Maintenance Windows

Release v1.17.0 (2019-02-18)
===

### Service Client Updates
* `service/athena`: Updates service API, documentation, and paginators
  * This release adds support for Workgroups to Amazon Athena. Use Workgroups to isolate users, teams, applications or workloads in the same account, control costs by setting up query limits and creating Amazon SNS alarms, and publish query-related metrics to Amazon CloudWatch.
* `service/secretsmanager`: Updates service API and documentation
  * This release increases the maximum allowed size of SecretString or SecretBinary from 4KB to 7KB in the CreateSecret, UpdateSecret, PutSecretValue and GetSecretValue APIs.

### SDK Features
* `service/s3/s3manager`: Update S3 Upload Multipart location ([#2453](https://github.com/aws/aws-sdk-go/pull/2453))
  * Updates the Location returned value of S3 Upload's Multipart UploadOutput type to be consistent with single part upload URL. This update also brings the multipart upload Location inline with the S3 object URLs created by the SDK
  * Fix [#1385](https://github.com/aws/aws-sdk-go/issues/1385)

### SDK Enhancements
* `service/s3`: Update BucketRegionError message to include more information ([#2451](https://github.com/aws/aws-sdk-go/pull/2451))
  * Updates the BucketRegionError error message to include information about the endpoint and actual region the bucket is in if known. This error message is created by the SDK, but could produce a confusing error message if the user provided a region that doesn't match the endpoint.
  * Fix [#2426](https://github.com/aws/aws-sdk-go/pull/2451)

Release v1.16.36 (2019-02-15)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/chime`: Updates service documentation
  * Documentation updates for Amazon Chime
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot`: Updates service API and documentation
  * In this release, IoT Device Defender introduces support for tagging Scheduled Audit resources.

Release v1.16.35 (2019-02-14)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds tagging and ARN support for AWS Client VPN Endpoints.You can now run bare metal workloads on EC2 M5 and M5d instances. m5.metal and m5d.metal instances are powered by custom Intel Xeon Scalable Processors with a sustained all core frequency of up to 3.1 GHz. m5.metal and m5d.metal offer 96 vCPUs and 384 GiB of memory. With m5d.metal, you also have access to 3.6 TB of NVMe SSD-backed instance storage. m5.metal and m5d.metal instances deliver 25 Gbps of aggregate network bandwidth using Elastic Network Adapter (ENA)-based Enhanced Networking, as well as 14 Gbps of bandwidth to EBS.You can now run bare metal workloads on EC2 z1d instances. z1d.metal instances are powered by custom Intel Xeon Scalable Processors with a sustained all core frequency of up to 4.0 GHz. z1d.metal offers 48 vCPUs, 384 GiB of memory, and 1.8 TB of NVMe SSD-backed instance storage. z1d.metal instances deliver 25 Gbps of aggregate network bandwidth using Elastic Network Adapter (ENA)-based Enhanced Networking, as well as 14 Gbps of bandwidth to EBS.
* `service/kinesisvideo`: Updates service API and documentation
  * Adds support for Tag-On-Create for Kinesis Video Streams. A list of tags associated with the stream can be created at the same time as the stream creation.

Release v1.16.34 (2019-02-13)
===

### Service Client Updates
* `service/elasticfilesystem`: Updates service API and documentation
  * Customers can now use the EFS Infrequent Access (IA) storage class to more cost-effectively store larger amounts of data in their file systems. EFS IA is cost-optimized storage for files that are not accessed every day. You can create a new file system and enable Lifecycle Management to automatically move files that have not been accessed for 30 days from the Standard storage class to the IA storage class.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediatailor`: Updates service API and documentation
* `service/rekognition`: Updates service API and documentation
  * GetContentModeration now returns the version of the moderation detection model used to detect unsafe content.

Release v1.16.33 (2019-02-12)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lambda`: Updates service documentation
  * Documentation updates for AWS Lambda

Release v1.16.32 (2019-02-11)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This update enables customers to find the start time, max expiration time, and connection status associated with AppStream streaming session.
* `service/codebuild`: Updates service API and documentation
  * Add customized webhook filter support
* `service/mediapackage`: Updates service API and documentation
  * Adds optional configuration for DASH to compact the manifest by combining duplicate SegmentTemplate tags. Adds optional configuration for DASH SegmentTemplate format to refer to segments by "Number" (default) or by "Time".

Release v1.16.31 (2019-02-08)
===

### Service Client Updates
* `service/discovery`: Updates service documentation
  * Documentation updates for the AWS Application Discovery Service.
* `service/dlm`: Updates service API and documentation
* `service/ecs`: Updates service API, documentation, and examples
  * Amazon ECS introduces the PutAccountSettingDefault API, an API that allows a user to set the default ARN/ID format opt-in status for all the roles and users in the account. Previously, setting the account's default opt-in status required the use of the root user with the PutAccountSetting API.

Release v1.16.30 (2019-02-07)
===

### Service Client Updates
* `service/es`: Updates service API and documentation
  * Feature: Support for three Availability Zone deployments
* `service/gamelift`: Updates service API and documentation
  * This release delivers a new API action for deleting unused matchmaking rule sets. More details are available at https://aws.amazon.com/releasenotes/?tag=releasenotes%23keywords%23amazon-gamelift.
* `service/medialive`: Updates service API and documentation
  * This release adds tagging of channels, inputs, and input security groups.
* `service/robomaker`: Updates service API and documentation

Release v1.16.29 (2019-02-06)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Add Linux with SQL Server Standard, Linux with SQL Server Web, and Linux with SQL Server Enterprise to the list of allowed instance platforms for On-Demand Capacity Reservations.
* `service/fsx`: Updates service API and documentation

Release v1.16.28 (2019-02-05)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * ec2.DescribeVpcPeeringConnections pagination support
* `service/servicecatalog`: Updates service documentation
  * Service Catalog Documentation Update for ProvisionedProductDetail
* `service/shield`: Updates service API and documentation
  * The DescribeProtection request now accepts resource ARN as valid parameter.

Release v1.16.27 (2019-02-04)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/codecommit`: Updates service API
  * This release supports a more graceful handling of the error case when a repository is not associated with a pull request ID in a merge request in AWS CodeCommit.
* `service/ecs`: Updates service API and documentation
  * This release of Amazon Elastic Container Service (Amazon ECS) introduces support for GPU workloads by enabling you to create clusters with GPU-enabled container instances.
* `service/workspaces`: Updates service API
  * This release sets ClientProperties as a required parameter.

Release v1.16.26 (2019-01-25)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * The PutFile API will now throw new exception FilePathConflictsWithSubmodulePathException when a submodule exists at the input file path; PutFile API will also throw FolderContentSizeLimitExceededException when the total size of any folder on the path exceeds the limit as a result of the operation.
* `service/devicefarm`: Updates service API and documentation
  * Introduces a new rule in Device Pools - "Availability". Customers can now ensure they pick devices that are available (i.e., not being used by other customers).
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediaconnect`: Updates service API and documentation
* `service/medialive`: Updates service API and documentation
  * This release adds support for Frame Capture output groups and for I-frame only manifests (playlists) in HLS output groups.

Release v1.16.25 (2019-01-24)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * This release adds support for cross-account ECR images and private registry authentication.
* `service/ecr`: Updates service API
  * Amazon ECR updated the default endpoint URL to support AWS Private Link.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/logs`: Updates service documentation
  * Documentation updates for CloudWatch Logs
* `service/rds`: Updates service API and documentation
  * The Amazon RDS API allows you to add or remove Identity and Access Management (IAM) role associated with a specific feature name with an RDS database instance. This helps with capabilities such as invoking Lambda functions from within a trigger in the database, load data from Amazon S3 and so on
* `service/sms-voice`: Updates service API and documentation

Release v1.16.24 (2019-01-23)
===

### Service Client Updates
* `service/acm-pca`: Updates service API, documentation, and waiters
* `service/apigatewaymanagementapi`: Updates service API
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/worklink`: Adds new service

### SDK Enhancements
* `aws`: Update Context to be an alias of context.Context for Go 1.9 ([#2412](https://github.com/aws/aws-sdk-go/pull/2412))
  * Updates aws.Context interface to be an alias of the standard libraries context.Context type instead of redefining the interface. This will allow IDEs and utilities to interpret the aws.Context as the exactly same type as the standard libraries context.Context.

Release v1.16.23 (2019-01-21)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This API update includes support for tagging Stack, Fleet, and ImageBuilder resources at creation time.
* `service/discovery`: Updates service API, documentation, and paginators
  * The Application Discovery Service's import APIs allow you to import information about your on-premises servers and applications into ADS so that you can track the status of your migrations through the Migration Hub console.
* `service/dms`: Updates service waiters
  * Update for DMS TestConnectionSucceeds waiter
* `service/fms`: Updates service API and documentation
* `service/ssm`: Updates service API and documentation
  * AWS Systems Manager State Manager now supports configuration management of all AWS resources through integration with Automation.

Release v1.16.22 (2019-01-18)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Adjust EC2's available instance types.
* `service/glue`: Updates service API and documentation
  * AllocatedCapacity field is being deprecated and replaced with MaxCapacity field

Release v1.16.21 (2019-01-17)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lambda`: Updates service documentation and examples
  * Documentation updates for AWS Lambda
* `service/lightsail`: Updates service API and documentation
  * This release adds functionality to the CreateDiskSnapshot API that allows users to snapshot instance root volumes. It also adds various documentation updates.
* `service/pinpoint`: Updates service API and documentation
  * This release updates the PutEvents operation. AppPackageName, AppTitle, AppVersionCode, SdkName fields will now be accepted as a part of the event when submitting events.
* `service/rekognition`: Updates service API and documentation
  * GetLabelDetection now returns bounding box information for common objects and a hierarchical taxonomy of detected labels. The version of the model used for video label detection is also returned. DetectModerationLabels now returns the version of the model used for detecting unsafe content.

### SDK Enhancements
* `aws/request: Improve error handling in shouldRetryCancel ([#2298](https://github.com/aws/aws-sdk-go/pull/2298))
  * Simplifies and improves SDK's detection of HTTP request errors that should be retried. Previously the SDK would incorrectly attempt to retry `EHOSTDOWN` connection errors. This change fixes this, by using the `Temporary` interface when available.

Release v1.16.20 (2019-01-16)
===

### Service Client Updates
* `service/backup`: Adds new service
* `service/ce`: Updates service documentation
* `service/dynamodb`: Updates service API and documentation
  * Amazon DynamoDB now integrates with AWS Backup, a centralized backup service that makes it easy for customers to configure and audit the AWS resources they want to backup, automate backup scheduling, set retention policies, and monitor all recent backup and restore activity. AWS Backup provides a fully managed, policy-based backup solution, simplifying your backup management, and helping you meet your business and regulatory backup compliance requirements. For more information, see the Amazon DynamoDB Developer Guide.

Release v1.16.19 (2019-01-14)
===

### Service Client Updates
* `service/mediaconvert`: Updates service API and documentation
  * IMF decode from a Composition Playlist for IMF specializations App #2 and App #2e; up to 99 input clippings; caption channel selection for MXF; and updated rate control for CBR jobs. Added support for acceleration in preview
* `service/storagegateway`: Updates service API and documentation
  * JoinDomain API supports two more  parameters: organizational unit(OU) and domain controllers.  Two new APIs are introduced: DetachVolume and AttachVolume.

### SDK Enhancements
* `aws/endpoints`: Add customization for AWS GovCloud (US) Application Autoscalling ([#2395](https://github.com/aws/aws-sdk-go/pull/2395))
  * Adds workaround to correct the endpoint for Application Autoscaling running in AWS GovCloud (US).
  * Fixes [#2391](https://github.com/aws/aws-sdk-go/issues/2391)

Release v1.16.18 (2019-01-11)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * Documentation updates for Amazon EMR
* `service/rds-data`: Updates service API, documentation, paginators, and examples

Release v1.16.17 (2019-01-10)
===

### Service Client Updates
* `service/codedeploy`: Updates service documentation
  * Documentation updates for codedeploy
* `service/ec2`: Updates service API and documentation
  * EC2 Spot: a) CreateFleet support for Single AvailabilityZone requests and b) support for paginated DescribeSpotInstanceRequests.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot`: Updates service API and documentation
  * This release adds tagging support for rules of AWS IoT Rules Engine. Tags enable you to categorize your rules in different ways, for example, by purpose, owner, or environment. For more information about tagging, see AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/). For technical documentation, look for the tagging operations in the AWS IoT Core API reference or User Guide (https://docs.aws.amazon.com/iot/latest/developerguide/tagging-iot.html).
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Training Jobs now support Inter-Container traffic encryption.

Release v1.16.16 (2019-01-09)
===

### Service Client Updates
* `service/docdb`: Adds new service
  * Amazon DocumentDB (with MongoDB compatibility) is a fast, reliable, and fully-managed database service. Amazon DocumentDB makes it easy for developers to set up, run, and scale MongoDB-compatible databases in the cloud.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/redshift`: Updates service API and documentation
  * DescribeSnapshotSchedules returns a list of snapshot schedules. With this release, this API will have a list of clusters and number of clusters associated with the schedule.

Release v1.16.15 (2019-01-07)
===

### Service Client Updates
* `service/appmesh`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.16.14 (2019-01-04)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * "This release provides support for running Appium Node.js and Appium Ruby tests on AWS Device Farm.
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS tagging feature.

Release v1.16.13 (2019-01-03)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iotanalytics`: Updates service API and documentation

### SDK Enhancements
* `aws/credentials`: Add support for getting credential's ExpiresAt. ([#2375](https://github.com/aws/aws-sdk-go/pull/2375))
  * Adds an Expirer interface that Providers can implement, and add a suitable implementation to Expiry class used by most Providers. Add a method on Credentials to get the expiration time of the underlying Provider, if Expirer is supported, without exposing Provider to callers.
  * Fix [#1329](https://github.com/aws/aws-sdk-go/pull/1329)

### SDK Bugs
* `aws/ec2metadata`: bounds check region identifier before split ([#2380](https://github.com/aws/aws-sdk-go/pull/2380))
  * Adds empty response checking to ec2metadata's Region request to prevent a out of bounds panic if empty response received.
* Fix SDK's generated API reference doc page's constants section links ([#2373](https://github.com/aws/aws-sdk-go/pull/2373))
  * Fixes the SDK's generated API reference documentation page's constants section links to to be clickable.

Release v1.16.12 (2019-01-03)
===

### Service Client Updates
* `service/opsworkscm`: Updates service documentation
  * Documentation updates for opsworkscm

Release v1.16.11 (2018-12-21)
===

### Service Client Updates
* `service/acm-pca`: Updates service documentation, waiters, paginators, and examples
* `service/dynamodb`: Updates service API and documentation
  * Added provisionedThroughPut exception on the request level for transaction APIs.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/sms-voice`: Updates service API and documentation
* `service/states`: Updates service API and documentation
  * This release adds support for cost allocation tagging. You can now create, delete, and list tags for AWS Step Functions activity and state machine resources. For more information about tagging, see AWS Tagging Strategies.

Release v1.16.10 (2018-12-20)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/comprehend`: Updates service API and documentation
* `service/firehose`: Updates service API and documentation
  * Support for specifying customized s3 keys and supplying a separate prefix for failed-records
* `service/medialive`: Updates service API and documentation
  * This release provides support for ID3 tags and video quality setting for subgop_length.
* `service/transcribe`: Updates service API and documentation

### SDK Enhancements
* `service/dynamodb/expression`: Clarify expression examples ([#2367](https://github.com/aws/aws-sdk-go/pull/2367))
  * Clarifies the expression package's examples to distinguish the pkg expression from a expr value.

Release v1.16.9 (2018-12-19)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release adds support for specifying partition as a strategy for EC2 Placement Groups. This new strategy allows one to launch instances into partitions that do not share certain underlying hardware between partitions, to assist with building and deploying highly available replicated applications.
* `service/sagemaker`: Updates service API and documentation
  * Batch Transform Jobs now supports TFRecord as a Split Type. ListCompilationJobs API action now supports SortOrder and SortBy inputs.
* `service/waf`: Updates service API and documentation
  * This release adds rule-level control for rule group. If a rule group contains a rule that blocks legitimate traffic, previously you had to override the entire rule group to COUNT in order to allow the traffic. You can now use the UpdateWebACL API to exclude specific rules within a rule group. Excluding rules changes the action for the individual rules to COUNT. Excluded rules will be recorded in the new "excludedRules" attribute of the WAF logs.
* `service/waf-regional`: Updates service API and documentation

Release v1.16.8 (2018-12-18)
===

### Service Client Updates
* `service/apigatewaymanagementapi`: Adds new service
* `service/apigatewayv2`: Adds new service
  * This is the initial SDK release for the Amazon API Gateway v2 APIs. This SDK will allow you to manage and configure APIs in Amazon API Gateway; this first release provides the capabilities that allow you to programmatically setup and manage WebSocket APIs end to end.
* `service/ec2`: Updates service API and documentation
  * Client VPN, is a client-based VPN service. With Client VPN, you can securely access resources in AWS as well as access resources in on-premises from any location using OpenVPN based devices. With Client VPN, you can set network based firewall rules that can restrict access to networks based on Active Directory groups.
* `service/elasticbeanstalk`: Updates service API and documentation
  * This release adds a new resource that Elastic Beanstalk will soon support, EC2 launch template, to environment resource descriptions.
* `service/globalaccelerator`: Upd