/*  job_computedimrecurrence.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_COMPUTEDIMRECURRENCE_H_
#define JOB_COMPUTEDIMRECURRENCE_H_

#include "job.h"

namespace Reduze {

/// shift of space time dimension
class ComputeDimRecurrence: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("compute_dim_recurrence");
		s.set_short_description("Shift dimension.");
		s.set_long_description("Generate raising dimensional shift identity"
				" according to 1007.2256 (with mu=-1 for Minkowski propagators)."
				" The integration measure is d^d k / Pi^(d/2) per loop."
				" Please note that the export command will not adjust powers"
				" of an overall scale set to 1 for dimensionally shifted integrals.");
		s.add_option("input_file", true, "string",
				"Name of file with integrals.");
		s.add_option("output_file", true, "string",
				"Name of file for the generated identities.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	ComputeDimRecurrence() {
		add_auto_options();
	}
	virtual ~ComputeDimRecurrence() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_file_);
		add_auto_io("output_file", output_file_);
	}
	virtual void init();
private:
	std::string input_file_, output_file_;
};

}

#endif /* JOB_COMPUTEDIMRECURRENCE_H_ */
