/*  job_finddiagramshiftsalt.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_FINDDIAGRAMSHIFTSALT_H_
#define JOB_FINDDIAGRAMSHIFTSALT_H_

#include "job.h"

namespace Reduze {

class Graph;
class Diagram;
class SectorGL;

/// Job to match diagrams to sectors via combinatorics
class FindDiagramShiftsAlt: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("find_diagram_shifts_alt");
		s.set_short_description(
				"Matches diagrams to sectors via combinatorics.");
		s.set_long_description(""//
					"Job to match diagrams to sectors by shifting loop momenta."
					" This jobs uses a robust but potentially slow"
					" combinatorical approach, please see 'find_diagram_shifts'"
					" for a graph based approach.");
		s.add_option("qgraf_file", true, "string", ""//
					"Input file: QGRAF output (using style file for Reduze YAML"
					" format).");
		s.add_option("output_file", true, "string", "Output file name (YAML).");
		s.add_option("info_file_form", false, "string",
				"Output file for matching info (FORM). If file name is missing"
					" or empty no info file is produced.");
		/// \todo use positions instead of names to select (for consistency with compute_diagram_interferences)
		s.add_option("names", false, "sequence of strings", ""//
					"Input files: list of the names of the diagrams that are"
					" processed; empty means all.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	FindDiagramShiftsAlt()  {
		add_auto_options();
	}
	virtual ~FindDiagramShiftsAlt() {
	}

	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("qgraf_file", qgraf_filename_);
		add_auto_io("output_file", output_filename_);
		add_auto_io("info_file_form", info_filename_form_);
		add_auto_io("names", names_);
	}
private:
	std::string qgraf_filename_; // input (YAML)
	std::string output_filename_; // output of diagrams (YAML)
	std::string info_filename_form_; // output of matching info (FORM)
	std::set<std::string> names_; // input: list of the names of the diagrams that are processed; empty means all
};

}

#endif /* JOB_FINDDIAGRAMSHIFTSALT_H_ */
