/*  job_test.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_test.h"
#include "functions.h"
#include "int.h"
#include "filedata.h"
#include "equation.h"

using namespace std;

namespace Reduze {

namespace {
JobProxy<Test> dummy;
}

bool Test::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	return true;
}

void Test::init() {
}

std::string Test::get_description() const {
	return "perform some tests";
}

void Test::run_serial() {
	Timer t;
	set<INT> intset, intset2;
	t.restart();
	ifstream ins("redtest");
	char c;
	while (ins.get(c)) {}
	ins.close();
	LOG("this took " << t.get_wall_time_nice_string());
	t.restart();
	ifstream in("redtest");
	string s;
	while (getline(in, s)) {
		if (s.size() < 3)
			continue;
		INT i(s);
		intset2.insert(i);
		getline(in, s);
	}
	in.close();
	LOG("this took " << t.get_wall_time_nice_string());
	t.restart();
	InFileLinearCombinations::find_INT("redtest", intset);
	LOG("this took " << t.get_wall_time_nice_string());
	t.restart();
	InFileLinearCombinations inin("redtest");
	LinCombHLight lc;
	while (inin.get(lc)) {
	}
	LOG("this took " << t.get_wall_time_nice_string());
}

}
