/*  streamutils.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "streamutils.h"
#include <fstream>
#include <iostream>
#include <stdexcept>
#include "functions.h"
#include "int.h"

namespace Reduze {

// NullBuffer

NullBuffer::NullBuffer() {
	setp(0, 0);
	setg(0, 0, 0);
}

NullBuffer::int_type NullBuffer::overflow(int_type c) {
	return c;
}

NullBuffer::int_type NullBuffer::underflow() {
	return traits_type::eof();
}

NullBuffer::int_type NullBuffer::sync() {
	return 0;
}

} // namespace Reduze
