/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClassMethodsRunner;
import org.junit.internal.runners.TestClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized
extends TestClassRunner {
    public static Collection<Object[]> eachOne(Object ... params) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        Object[] objectArray = params;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object param = objectArray[n];
            results.add(new Object[]{param});
            ++n;
        }
        return results;
    }

    public Parameterized(Class<?> klass) throws Exception {
        super(klass, new RunAllParameterMethods(klass));
    }

    @Override
    protected void validate(MethodValidator methodValidator) {
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassRunnerForParameters
    extends TestClassMethodsRunner {
        private final Object[] fParameters;
        private final int fParameterSetNumber;
        private final Constructor fConstructor;

        TestClassRunnerForParameters(Class<?> klass, Object[] parameters, int i) {
            super(klass);
            this.fParameters = parameters;
            this.fParameterSetNumber = i;
            this.fConstructor = this.getOnlyConstructor();
        }

        @Override
        protected Object createTest() throws Exception {
            return this.fConstructor.newInstance(this.fParameters);
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.fParameterSetNumber);
        }

        @Override
        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.fParameterSetNumber);
        }

        private Constructor getOnlyConstructor() {
            Constructor<?>[] constructors = this.getTestClass().getConstructors();
            Assert.assertEquals(1, constructors.length);
            return constructors[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAllParameterMethods
    extends CompositeRunner {
        private final Class<?> fKlass;

        public RunAllParameterMethods(Class<?> klass) throws Exception {
            super(klass.getName());
            this.fKlass = klass;
            int i = 0;
            for (Object[] parameters : this.getParametersList()) {
                super.add(new TestClassRunnerForParameters(klass, parameters, i++));
            }
        }

        private Collection<Object[]> getParametersList() throws IllegalAccessException, InvocationTargetException, Exception {
            return (Collection)this.getParametersMethod().invoke(null, new Object[0]);
        }

        private Method getParametersMethod() throws Exception {
            Method[] methodArray = this.fKlass.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method each = methodArray[n];
                if (Modifier.isStatic(each.getModifiers())) {
                    Annotation[] annotations;
                    Annotation[] annotationArray = annotations = each.getAnnotations();
                    int n3 = 0;
                    int n4 = annotationArray.length;
                    while (n3 < n4) {
                        Annotation annotation = annotationArray[n3];
                        if (annotation.annotationType() == Parameters.class) {
                            return each;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            throw new Exception("No public static parameters method on class " + this.getName());
        }
    }
}

