/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

import javax.swing.JOptionPane;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * LocalProperties
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class LocalProperties {

  private static LocalProperties instance = null;
  public static final String PROP_FILE = "/.vdr_channeleditor_local.properties"; //$NON-NLS-1$
  public static final String PROP_LASTFILE_PREFIX = "last.open.file."; //$NON-NLS-1$
  public static final String PROP_ICONSET = "icon.set"; //$NON-NLS-1$
  public static final String PROP_FONTSIZE = "font.size"; //$NON-NLS-1$
  public static final String PROP_SYSTEM_LANGUAGE = "system.language";
  

  private Properties localProps = null;

  /**
   * Constructor
   */
  private LocalProperties() {
    // read lokal Props, create one if not there
    localProps = new Properties();
    File propFile = new File(System.getProperty("user.home") + PROP_FILE); //$NON-NLS-1$
    if (propFile.exists()) {
      try {
        localProps.load(new FileInputStream(propFile));
      } catch (Exception e1) {
        // Log Error
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("LocalProperties.5"), //$NON-NLS-1$
                                      Messages.getString("LocalProperties.6"), JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$
      }
    }

    // check default values
    if (localProps.get(PROP_ICONSET) == null) {
      localProps.setProperty(PROP_ICONSET, "default"); //$NON-NLS-1$
    }
    if (localProps.get(PROP_FONTSIZE) == null) {
      localProps.setProperty(PROP_FONTSIZE, "0"); //$NON-NLS-1$
    }
  }

  /**
   * Singleton access getInstance
   * 
   * @return
   */
  public static LocalProperties getInstance() {
    if (instance != null) { return instance; }
    instance = new LocalProperties();
    return instance;
  }

  /**
   * getLocalProps
   * 
   * @return Returns the localProps
   */
  public Properties getLocalProps() {
    return localProps;
  }

  /**
   * setLocalProps
   * 
   * @param localProps The localProps to set.
   */
  public void setLocalProps(Properties localProps) {
    this.localProps = localProps;
  }

  /**
   * storeLocalProps
   */
  public void storeLocalProps() {
    if (localProps != null) {
      File propFile = new File(System.getProperty("user.home") + PROP_FILE); //$NON-NLS-1$
      try {
        localProps.store(new FileOutputStream(propFile), Messages.getString("LocalProperties.10")); //$NON-NLS-1$
      } catch (Exception e) {
        // Log Error
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("LocalProperties.11"), //$NON-NLS-1$
                                      Messages.getString("LocalProperties.12"), //$NON-NLS-1$
                                      JOptionPane.ERROR_MESSAGE);
      }
    }
  }

  /**
   * getProperty
   * 
   * @param key
   * @return
   */
  public String getProperty(String key) {
    return localProps.getProperty(key);
  }

  /**
   * setProperty
   * 
   * @param key
   * @param value
   */
  public void setProperty(String key, String value) {
    if (localProps != null) {
      localProps.setProperty(key, value);
    }
  }
}
