#ifndef CRYPTO_COMPAT_H_
#define CRYPTO_COMPAT_H_

#include <openssl/ossl_typ.h>

/**
 * crypto_compat_RSA_valid_size(key):
 * Return nonzero if ${key} has a valid size, and zero for an invalid size.
 */
int crypto_compat_RSA_valid_size(const RSA * const);

/**
 * crypto_compat_RSA_import(key, n, e, d, p, q, dmp1, dmq1, iqmp):
 * Import the given BIGNUMs into the RSA ${key}.  If this function fails,
 * free any any BIGNUMs which have not been imported into the ${key}, but do
 * not free the ${key} itself.
 */
int crypto_compat_RSA_import(RSA *, BIGNUM *, BIGNUM *, BIGNUM *,
    BIGNUM *, BIGNUM *, BIGNUM *, BIGNUM *, BIGNUM *);

/**
 * crypto_compat_RSA_export(key, n, e, d, p, q, dmp1, dmq1, iqmp):
 * Export values from the given RSA ${key} into the BIGNUMs.  ${n} and ${e}
 * must be non-NULL; the other values may be NULL if desired, and will
 * therefore not be exported.
 */
int crypto_compat_RSA_export(RSA *, const BIGNUM **, const BIGNUM **,
    const BIGNUM **, const BIGNUM **, const BIGNUM **,
    const BIGNUM **, const BIGNUM **, const BIGNUM **);

/**
 * crypto_compat_RSA_generate_key(void):
 * Generate a key pair.
 */
RSA * crypto_compat_RSA_generate_key(void);

/**
 * crypto_compat_free(void):
 * Free the shared memory allocated by OpenSSL.
 */
void crypto_compat_free(void);

#endif /* !CRYPTO_COMPAT_H_ */
