/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba.auth;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.settingsSync.jba.SettingsSyncJbaBundle;
import com.intellij.settingsSync.jba.SettingsSyncPromotion;
import com.intellij.settingsSync.jba.auth.DummyJBAccountInfoService;
import com.intellij.ui.JBAccountInfoService;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010#\u001a\u0004\u0018\u00010$R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0019\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/intellij/settingsSync/jba/auth/JBAAuthService;", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "<init>", "()V", "invalidatedIdToken", "", "isTokenValid", "", "token", "getUserData", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "userId", "getAvailableUserAccounts", "", "fromJBAData", "jbaData", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "idToken", "getIdToken", "()Ljava/lang/String;", "providerCode", "getProviderCode", "providerName", "getProviderName", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "login", "parentComponent", "Ljava/awt/Component;", "(Ljava/awt/Component;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invalidateJBA", "", "getAccountInfoService", "Lcom/intellij/ui/JBAccountInfoService;", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nJBAAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBAAuthService.kt\ncom/intellij/settingsSync/jba/auth/JBAAuthService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n14#2:156\n*S KotlinDebug\n*F\n+ 1 JBAAuthService.kt\ncom/intellij/settingsSync/jba/auth/JBAAuthService\n*L\n24#1:156\n*E\n"})
public final class JBAAuthService
implements SettingsSyncAuthService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile String invalidatedIdToken;
    @NotNull
    private final Icon icon;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String JBA_USER_ID = "jba";

    public JBAAuthService() {
        Icon icon = AllIcons.Ultimate.IdeaUltimatePromo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IdeaUltimatePromo");
        this.icon = icon;
    }

    private final boolean isTokenValid(String token) {
        return token != null && !Intrinsics.areEqual((Object)token, (Object)this.invalidatedIdToken);
    }

    @Override
    @Nullable
    public SettingsSyncUserData getUserData(@NotNull String userId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (ApplicationManagerEx.isInIntegrationTest()) {
            object = DummyJBAccountInfoService.INSTANCE.getUserData();
        } else {
            JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
            object = jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null;
        }
        return this.fromJBAData((JBAccountInfoService.JBAData)object);
    }

    @Override
    @NotNull
    public List<SettingsSyncUserData> getAvailableUserAccounts() {
        SettingsSyncUserData userData = this.getUserData("");
        if (userData != null) {
            return CollectionsKt.listOf((Object)userData);
        }
        return CollectionsKt.emptyList();
    }

    private final SettingsSyncUserData fromJBAData(JBAccountInfoService.JBAData jbaData) {
        if (jbaData == null) {
            return null;
        }
        return new SettingsSyncUserData(JBA_USER_ID, this.getProviderCode(), jbaData.email, jbaData.email, null, 16, null);
    }

    @Nullable
    public final String getIdToken() {
        String token;
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
        String string = token = jBAccountInfoService != null ? jBAccountInfoService.getIdToken() : null;
        if (!this.isTokenValid(token)) {
            return null;
        }
        return token;
    }

    @Override
    @NotNull
    public String getProviderCode() {
        return JBA_USER_ID;
    }

    @Override
    @NotNull
    public String getProviderName() {
        return "JetBrains";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Object login(@Nullable Component parentComponent, @NotNull Continuation<? super SettingsSyncUserData> $completion) {
        ModalTaskOwner modalTaskOwner = parentComponent != null ? ModalTaskOwner.component((Component)parentComponent) : ModalTaskOwner.guess();
        Intrinsics.checkNotNull((Object)modalTaskOwner);
        ModalTaskOwner modalTaskOwner2 = modalTaskOwner;
        return TasksKt.withModalProgress((ModalTaskOwner)modalTaskOwner2, (String)SettingsSyncJbaBundle.INSTANCE.message("login.manual.helper.text", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SettingsSyncUserData>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ JBAAuthService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JBAccountInfoService accountInfoService = this.this$0.getAccountInfoService();
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from.settings.sync", (Object)"true")};
                        HashMap loginMetadata = MapsKt.hashMapOf((Pair[])pairArray);
                        if (SettingsSyncPromotion.Companion.getPromotionShownThisSession()) {
                            ((Map)loginMetadata).put("from.settings.sync.promotion", "true");
                        }
                        if (accountInfoService == null) {
                            JBAAuthService.access$getLOG$cp().error("JBA auth service is not available!");
                            return null;
                        }
                        if (JBAAuthService.access$isTokenValid(this.this$0, accountInfoService.getIdToken())) {
                            return JBAAuthService.access$fromJBAData(this.this$0, accountInfoService.getUserData());
                        }
                        JBAAuthService jBAAuthService = this.this$0;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = accountInfoService;
                        this.L$1 = loginMetadata;
                        this.L$2 = jBAAuthService;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        try {
                            void var2_3;
                            cont.invokeOnCancellation((Function1)new Function1<Throwable, Unit>((CancellableContinuation<? super SettingsSyncUserData>)cont){
                                final /* synthetic */ CancellableContinuation<SettingsSyncUserData> $cont;
                                {
                                    this.$cont = $cont;
                                }

                                public final void invoke(Throwable it) {
                                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(null));
                                }
                            });
                            Function1 function1 = (Function1)new Function1<JBAccountInfoService.LoginResult, Unit>(jBAAuthService, (CancellableContinuation<? super SettingsSyncUserData>)cont){
                                final /* synthetic */ JBAAuthService this$0;
                                final /* synthetic */ CancellableContinuation<SettingsSyncUserData> $cont;
                                {
                                    this.this$0 = $receiver;
                                    this.$cont = $cont;
                                }

                                public final void invoke(JBAccountInfoService.LoginResult loginResult) {
                                    SettingsSyncUserData settingsSyncUserData;
                                    JBAccountInfoService.LoginResult loginResult2 = loginResult;
                                    if (loginResult2 instanceof JBAccountInfoService.LoginResult.LoginSuccessful) {
                                        settingsSyncUserData = JBAAuthService.access$fromJBAData(this.this$0, ((JBAccountInfoService.LoginResult.LoginSuccessful)loginResult).jbaUser());
                                    } else if (loginResult2 instanceof JBAccountInfoService.LoginResult.LoginFailed) {
                                        JBAAuthService.access$getLOG$cp().warn("Login failed: " + ((JBAccountInfoService.LoginResult.LoginFailed)loginResult).errorMessage());
                                        settingsSyncUserData = null;
                                    } else {
                                        JBAAuthService.access$getLOG$cp().warn("Unknown login result: " + loginResult);
                                        settingsSyncUserData = null;
                                    }
                                    SettingsSyncUserData result = settingsSyncUserData;
                                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)result));
                                }
                            };
                            ((CompletableFuture)var2_3.startLoginSession(JBAccountInfoService.LoginMode.AUTO, null, (Map)loginMetadata).onCompleted().exceptionally(new Function((CancellableContinuation<? super SettingsSyncUserData>)cont){
                                final /* synthetic */ CancellableContinuation<SettingsSyncUserData> $cont;
                                {
                                    this.$cont = $cont;
                                }

                                public final JBAccountInfoService.LoginResult apply(Throwable exc) {
                                    if (exc instanceof CancellationException) {
                                        JBAAuthService.access$getLOG$cp().warn("Login cancelled");
                                    } else {
                                        JBAAuthService.access$getLOG$cp().warn("Login failed", exc);
                                    }
                                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(null));
                                    return null;
                                }
                            })).thenApply(new Function(function1){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                    this.function = function;
                                }

                                public final /* synthetic */ Object apply(Object p0) {
                                    return this.function.invoke(p0);
                                }
                            });
                        }
                        catch (Throwable e) {
                            JBAAuthService.access$getLOG$cp().error(e);
                            ((Continuation)cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                        }
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        JBAAuthService cfr_ignored_0 = (JBAAuthService)this.L$2;
                        HashMap cfr_ignored_1 = (HashMap)this.L$1;
                        JBAccountInfoService cfr_ignored_2 = (JBAccountInfoService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SettingsSyncUserData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public final void invalidateJBA(@NotNull String idToken) {
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        if (Intrinsics.areEqual((Object)this.invalidatedIdToken, (Object)idToken)) {
            return;
        }
        LOG.warn("Invalidating JBA Token");
        this.invalidatedIdToken = idToken;
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
    }

    @Nullable
    public final JBAccountInfoService getAccountInfoService() {
        if (ApplicationManagerEx.isInIntegrationTest() || Intrinsics.areEqual((Object)System.getProperty("settings.sync.test.auth"), (Object)"true")) {
            return DummyJBAccountInfoService.INSTANCE;
        }
        return JBAccountInfoService.getInstance();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isTokenValid(JBAAuthService $this, String token) {
        return $this.isTokenValid(token);
    }

    public static final /* synthetic */ SettingsSyncUserData access$fromJBAData(JBAAuthService $this, JBAccountInfoService.JBAData jbaData) {
        return $this.fromJBAData(jbaData);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JBAAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/jba/auth/JBAAuthService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "JBA_USER_ID", "", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

