/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline;

import com.intellij.codeInsight.inline.completion.DefaultInlineCompletionInsertHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionInsertEnvironment;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionSkipTextElement;
import com.intellij.codeInsight.inline.completion.utils.InlineCompletionSkipElementUtils;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixerKt;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.cache.LightweightCacheKey;
import com.intellij.ml.inline.completion.impl.cache.MLInlineCompletionCache;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionCustomInlineEventsKt;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionExtractedFirstLine;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionFirstLineModeInfo;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionManualCallPurpose;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH$J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001fH\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler;", "Lcom/intellij/codeInsight/inline/completion/DefaultInlineCompletionInsertHandler;", "providerId", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProviderID;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/lang/String;", "getLanguageKit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "language", "Lcom/intellij/lang/Language;", "getCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "getCacheService", "Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache;", "afterInsertion", "", "environment", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionInsertEnvironment;", "elements", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "moveCaretBeforeSuffix", "performAutoImport", "handleFirstLineMode", "getSkipOffsets", "", "", "trimEndingMatchedSymbols", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "cacheSuggestion", "proposal", "Companion", "intellij.ml.inline.completion"})
public abstract class MLCompletionInsertHandler
extends DefaultInlineCompletionInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String providerId;
    @NotNull
    private static final Key<Integer> CARET_SHIFT_AFTER_INSERTION_KEY;

    private MLCompletionInsertHandler(String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.providerId = providerId;
    }

    @Nullable
    protected abstract MLCompletionLanguageKit getLanguageKit(@NotNull Language var1);

    @NotNull
    protected abstract CoroutineScope getCoroutineScope(@NotNull Project var1);

    @NotNull
    protected abstract MLInlineCompletionCache getCacheService(@NotNull Project var1);

    public void afterInsertion(@NotNull InlineCompletionInsertEnvironment environment, @NotNull List<? extends InlineCompletionElement> elements) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super.afterInsertion(environment, elements);
        this.moveCaretBeforeSuffix(environment);
        this.performAutoImport(environment);
        this.handleFirstLineMode(environment);
    }

    private final void moveCaretBeforeSuffix(InlineCompletionInsertEnvironment environment) {
        block0: {
            Integer n = (Integer)environment.getUserData(CARET_SHIFT_AFTER_INSERTION_KEY);
            if (n == null) break block0;
            int shift = ((Number)n).intValue();
            boolean bl = false;
            Caret caret = environment.getEditor().getCaretModel().getCurrentCaret();
            boolean bl2 = false;
            caret.moveToOffset(caret.getOffset() + shift);
        }
    }

    private final void performAutoImport(InlineCompletionInsertEnvironment environment) {
        Language language = environment.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Object object = this.getLanguageKit(language);
        if (object == null || (object = object.getImportFixer()) == null) {
            return;
        }
        Object importFixer = object;
        Project project = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImportFixerKt.runAutoImportAsync((ImportFixer)importFixer, this.getCoroutineScope(project), environment.getFile(), environment.getEditor(), environment.getInsertedRange());
    }

    private final void handleFirstLineMode(InlineCompletionInsertEnvironment environment) {
        MLCompletionExtractedFirstLine extractedFirstLine;
        MLCompletionFirstLineModeInfo firstLineModeInfo;
        MLCompletionFirstLineModeInfo mLCompletionFirstLineModeInfo = firstLineModeInfo = (MLCompletionFirstLineModeInfo)environment.getUserData(MLCompletionFirstLineModeInfo.Companion.getKEY());
        MLCompletionExtractedFirstLine mLCompletionExtractedFirstLine = extractedFirstLine = mLCompletionFirstLineModeInfo != null ? mLCompletionFirstLineModeInfo.getExtractedFirstLine() : null;
        if (extractedFirstLine == null) {
            return;
        }
        AnalyzedMLCompletionProposal initialProposal = firstLineModeInfo.getInitialProposal();
        List<InlineCompletionElement> suffixElements = extractedFirstLine.getOtherLines();
        String suffixText = CollectionsKt.joinToString$default((Iterable)suffixElements, (CharSequence)"", null, null, (int)0, null, MLCompletionInsertHandler::handleFirstLineMode$lambda$2, (int)30, null);
        List newSuffixElements = InlineCompletionSkipElementUtils.INSTANCE.insertOffsetsAndAdditionalLines(suffixElements, extractedFirstLine.getOffsetsToInsertAutomatically(), environment.getEditor(), environment.getEditor().getCaretModel().getOffset(), suffixText);
        Set<Integer> newSkipOffsets = this.getSkipOffsets(newSuffixElements);
        String initialSuggestion = initialProposal.getSuggestion() + initialProposal.getSuffix();
        int prefixLength = initialSuggestion.length() - suffixText.length();
        AnalyzedMLCompletionProposal finalProposal = initialProposal.trimPrefix(StringsKt.take((String)initialSuggestion, (int)prefixLength));
        finalProposal.getDetails().set(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES(), newSkipOffsets);
        finalProposal = this.trimEndingMatchedSymbols(finalProposal);
        this.cacheSuggestion(environment, finalProposal);
        ApplicationKt.getApplication().invokeLater(() -> MLCompletionInsertHandler.handleFirstLineMode$lambda$3(environment, this));
    }

    private final Set<Integer> getSkipOffsets(List<? extends InlineCompletionElement> $this$getSkipOffsets) {
        Set result = new LinkedHashSet();
        int offset = 0;
        for (InlineCompletionElement inlineCompletionElement : $this$getSkipOffsets) {
            if (inlineCompletionElement instanceof InlineCompletionSkipTextElement) {
                int n = ((InlineCompletionSkipTextElement)inlineCompletionElement).getText().length();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    ((Collection)result).add(offset + it);
                }
            }
            offset += inlineCompletionElement.getText().length();
        }
        return result;
    }

    private final AnalyzedMLCompletionProposal trimEndingMatchedSymbols(AnalyzedMLCompletionProposal $this$trimEndingMatchedSymbols) {
        Set matched;
        int length;
        int finalLength = length = $this$trimEndingMatchedSymbols.getSuggestion().length() + $this$trimEndingMatchedSymbols.getSuffix().length();
        Set set = $this$trimEndingMatchedSymbols.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        if (set == null) {
            set = matched = SetsKt.emptySet();
        }
        while (finalLength > 0 && matched.contains(finalLength - 1)) {
            --finalLength;
        }
        return $this$trimEndingMatchedSymbols.trimSuffix(StringsKt.takeLast((String)($this$trimEndingMatchedSymbols.getSuggestion() + $this$trimEndingMatchedSymbols.getSuffix()), (int)(length - finalLength)));
    }

    private final void cacheSuggestion(InlineCompletionInsertEnvironment environment, AnalyzedMLCompletionProposal proposal) {
        LightweightCacheKey cacheKey = LightweightCacheKey.Companion.ofBlocking(environment.getEditor());
        Project project = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.getCacheService(project).cacheAnalyzed(cacheKey, proposal);
    }

    private static final CharSequence handleFirstLineMode$lambda$2(InlineCompletionElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final void handleFirstLineMode$lambda$3(InlineCompletionInsertEnvironment $environment, MLCompletionInsertHandler this$0) {
        block0: {
            InlineCompletionEvent.ManualCall newEvent = MLCompletionCustomInlineEventsKt.create-WmoXmhE(InlineCompletionEvent.ManualCall.Companion, $environment.getEditor(), this$0.providerId, MLCompletionManualCallPurpose.ShowRemainingMultiline.INSTANCE);
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull($environment.getEditor());
            if (inlineCompletionHandler == null) break block0;
            inlineCompletionHandler.invokeEvent((InlineCompletionEvent)newEvent);
        }
    }

    public /* synthetic */ MLCompletionInsertHandler(String providerId, DefaultConstructorMarker $constructor_marker) {
        this(providerId);
    }

    static {
        Key key = Key.create((String)"full.line.inline.caret.shift");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CARET_SHIFT_AFTER_INSERTION_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler$Companion;", "", "<init>", "()V", "CARET_SHIFT_AFTER_INSERTION_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCARET_SHIFT_AFTER_INSERTION_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getCARET_SHIFT_AFTER_INSERTION_KEY() {
            return CARET_SHIFT_AFTER_INSERTION_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

