/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.util.io.NetUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b\u001a\u001d\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u0019\u0010\u0016\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002\"!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"toTimeoutInMillis", "", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "linuxPamPasswordPromptTranslations", "", "", "getLinuxPamPasswordPromptTranslations", "()Ljava/util/Set;", "linuxPamPasswordPromptTranslations$delegate", "Lkotlin/Lazy;", "isOpenPamPasswordPrompt", "", "message", "isPamUnixPasswordPrompted", "getMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "throwable", "", "full", "getNetworkExceptionMessage", "Lorg/jetbrains/annotations/Nls;", "t", "intellij.platform.ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    @NotNull
    private static final Lazy linuxPamPasswordPromptTranslations$delegate = LazyKt.lazy(SshConnectionUtil::linuxPamPasswordPromptTranslations_delegate$lambda$3);

    public static final int toTimeoutInMillis(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        long timeoutInMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeoutInMillis);
        }
        if (timeoutInMillis > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeoutInMillis;
    }

    private static final Set<String> getLinuxPamPasswordPromptTranslations() {
        Lazy lazy = linuxPamPasswordPromptTranslations$delegate;
        return (Set)lazy.getValue();
    }

    private static final boolean isOpenPamPasswordPrompt(String message) {
        return Intrinsics.areEqual((Object)message, (Object)"Password:") || Pattern.compile("^Password for [^ ]+@[^ ]+:$").matcher(message).matches();
    }

    public static final boolean isPamUnixPasswordPrompted(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SshConnectionUtil.getLinuxPamPasswordPromptTranslations().contains(message) || SshConnectionUtil.isOpenPamPasswordPrompt(message);
    }

    @NotNull
    public static final String getMessage(@Nullable Throwable throwable, boolean full) {
        String string;
        Throwable grandCause;
        Throwable throwable2 = throwable;
        Intrinsics.checkNotNull((Object)throwable2);
        String solutionMessage = NetUtils.INSTANCE.getNetworkErrorSolutionMessage(throwable2, full);
        if (solutionMessage != null) {
            return solutionMessage;
        }
        Object reason = throwable.getMessage();
        Throwable cause = throwable.getCause();
        if (cause != throwable && (cause instanceof ConnectException || cause instanceof UnknownHostException || cause instanceof SshException)) {
            if (((Exception)cause).getCause() != null) {
                reason = SshConnectionUtil.getNetworkExceptionMessage(((Exception)cause).getCause());
            }
            if (reason == null || ((Exception)cause).getCause() == null) {
                reason = SshConnectionUtil.getNetworkExceptionMessage(cause);
            }
            if (reason == null) {
                reason = throwable.getMessage();
            }
        }
        if (cause instanceof SSLHandshakeException && (grandCause = ((SSLHandshakeException)cause).getCause()) instanceof CertificateException && !StringUtil.isEmptyOrSpaces((String)((CertificateException)grandCause).getMessage())) {
            reason = grandCause instanceof CertificateExpiredException ? SshBundle.message("expired.certificate", new Object[0]) + " " : SshBundle.message("invalid.certificate", new Object[0]) + " ";
            reason = (String)reason + ((CertificateException)grandCause).getMessage();
        }
        if (reason == null) {
            reason = SshBundle.message("unknown.reason", new Object[0]);
        }
        if (full) {
            if (!Intrinsics.areEqual((Object)reason, (Object)throwable.getMessage())) {
                Object[] objectArray = new Object[]{throwable.getMessage(), reason};
                String string2 = MessageFormat.format("{0} ({1})", objectArray);
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                String string3 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string3);
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
            }
        } else {
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)reason, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    private static final String getNetworkExceptionMessage(Throwable t) {
        String string;
        if (t instanceof UnknownHostException) {
            string = SshBundle.message("host.not.found", new Object[0]);
        } else {
            Throwable throwable = t;
            Intrinsics.checkNotNull((Object)throwable);
            string = throwable.getMessage();
        }
        return string;
    }

    private static final boolean linuxPamPasswordPromptTranslations_delegate$lambda$3$lambda$2$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && !StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null);
    }

    private static final String linuxPamPasswordPromptTranslations_delegate$lambda$3$lambda$2$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = Base64.getDecoder().decode(it);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set linuxPamPasswordPromptTranslations_delegate$lambda$3() {
        Set set;
        Closeable closeable = SshConnection.class.getClassLoader().getResource("com/intellij/ssh/pam_unix_password_prompt_translations").openStream();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)TextStreamsKt.lineSequence((BufferedReader)new BufferedReader(new InputStreamReader(stream, "UTF-8"))), SshConnectionUtil::linuxPamPasswordPromptTranslations_delegate$lambda$3$lambda$2$lambda$0), SshConnectionUtil::linuxPamPasswordPromptTranslations_delegate$lambda$3$lambda$2$lambda$1));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return set;
    }
}

