/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ui.AuthTypeDescription;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SystemProperties;
import java.io.File;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"noteSeparator", "", "append", "", "Lcom/intellij/ui/ColoredTextContainer;", "authType", "Lcom/intellij/remote/AuthType;", "createBrowseListenerForPrivateKey", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener;", "Ljavax/swing/JTextField;", "privateKeyFileField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "manageSshConfiguration", "intellij.platform.ssh.ui"})
@JvmName(name="SshUIUtil")
public final class SshUIUtil {
    @NotNull
    private static final String noteSeparator = " ";

    public static final void append(@NotNull ColoredTextContainer $this$append, @NotNull AuthType authType) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        AuthTypeDescription item = AuthTypeDescription.Companion.get(authType);
        $this$append.append(item.getLabel(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (item.getNote() != null) {
            $this$append.append(noteSeparator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String string = item.getNote();
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            $this$append.append(string, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    @NotNull
    public static final ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createBrowseListenerForPrivateKey(@NotNull TextFieldWithBrowseButton privateKeyFileField) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFileField, (String)"privateKeyFileField");
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, true, false).withTitle(SshBundle.message("choose.private.key", new Object[0])).withHideIgnored(false).withShowHiddenFiles(true);
        TextComponentAccessor textComponentAccessor = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
        return (ComponentWithBrowseButton.BrowseFolderActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(privateKeyFileField, descriptor, (TextComponentAccessor<JTextField>)textComponentAccessor){

            private final VirtualFile getSshHome() {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                String userHome = string;
                if (StringUtil.isEmpty((String)userHome)) {
                    return null;
                }
                File file = Ssh.getHomeSshDirectory().toFile();
                if (!file.exists()) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }

            protected VirtualFile getInitialFile() {
                VirtualFile initialFile = super.getInitialFile();
                VirtualFile virtualFile = initialFile;
                if (virtualFile == null) {
                    virtualFile = this.getSshHome();
                }
                return virtualFile;
            }
        };
    }

    public static final void manageSshConfiguration() {
        ShowSettingsUtil.getInstance().showSettingsDialog(ProjectManager.getInstance().getDefaultProject(), SshBundle.message("ssh.configurable.title", new Object[0]));
    }
}

