/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.util.SystemProperties;
import git4idea.commit.signing.GpgAgentConfiguratorKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.GpgAgentPathsLocator;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgit4idea/commit/signing/MacAndUnixGpgAgentPathsLocator;", "Lgit4idea/commit/signing/GpgAgentPathsLocator;", "<init>", "()V", "resolvePaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "intellij.vcs.git"})
final class MacAndUnixGpgAgentPathsLocator
implements GpgAgentPathsLocator {
    @Override
    @Nullable
    public GpgAgentPaths resolvePaths() {
        try {
            String[] stringArray = new String[]{".gnupg"};
            Path gpgAgentHome = Paths.get(SystemProperties.getUserHome(), stringArray);
            Path gpgAgentConf = gpgAgentHome.resolve("gpg-agent.conf");
            Path gpgAgentConfBackup = gpgAgentHome.resolve("gpg-agent.conf.bak");
            Path gpgPinentryAppLauncher = gpgAgentHome.resolve("pinentry-ide.sh");
            Intrinsics.checkNotNull((Object)gpgAgentHome);
            Intrinsics.checkNotNull((Object)gpgAgentConf);
            Intrinsics.checkNotNull((Object)gpgAgentConfBackup);
            Intrinsics.checkNotNull((Object)gpgPinentryAppLauncher);
            return new GpgAgentPaths(gpgAgentHome, gpgAgentConf, gpgAgentConfBackup, gpgPinentryAppLauncher, ((Object)gpgPinentryAppLauncher.toAbsolutePath()).toString());
        }
        catch (InvalidPathException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot resolve path", (Throwable)e);
            return null;
        }
    }
}

