/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInjectionUtil {
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = List.of(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class, PsiComment.class);

    private PyInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@NotNull PsiElement context) {
        if (context == null) {
            PyInjectionUtil.$$$reportNull$$$0(0);
        }
        PsiElement element = null;
        for (PsiElement current = context; current != null && PyInjectionUtil.isStringLiteralPart(current, element); current = current.getParent()) {
            element = current;
        }
        return element;
    }

    @NotNull
    public static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, @NotNull Language language) {
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(1);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            PyInjectionUtil.$$$reportNull$$$0(3);
        }
        registrar.startInjecting(language);
        InjectionResult result2 = PyInjectionUtil.processStringLiteral(element, registrar, "", "", Formatting.NONE);
        if (result2.isInjected()) {
            registrar.doneInjecting();
        }
        InjectionResult injectionResult = result2;
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(4);
        }
        return injectionResult;
    }

    private static boolean isStringLiteralPart(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(5);
        }
        if (element == context || element instanceof PyStringLiteralExpression || element instanceof PsiComment) {
            return true;
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            return contained != null && PyInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            if (expr.isOperator("+")) {
                return PyInjectionUtil.isStringLiteralPart((PsiElement)left, context) || right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, context);
            }
            if (expr.isOperator("%")) {
                return right != context && PyInjectionUtil.isStringLiteralPart((PsiElement)left, context);
            }
            return false;
        }
        if (element instanceof PyCallExpression) {
            PyExpression qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element);
            return qualifier != null && PyInjectionUtil.isStringLiteralPart((PsiElement)qualifier, context);
        }
        if (element instanceof PyReferenceExpression) {
            PyCallExpression callExpr = PyCallExpressionNavigator.getPyCallExpressionByCallee(element);
            return callExpr != null && PyInjectionUtil.isStringLiteralPart((PsiElement)callExpr, context);
        }
        return false;
    }

    @Nullable
    private static PyExpression getFormatCallQualifier(@NotNull PyCallExpression element) {
        PyQualifiedExpression qualifiedExpr;
        PyExpression qualifier;
        PyExpression callee;
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(6);
        }
        if ((callee = element.getCallee()) instanceof PyQualifiedExpression && (qualifier = (qualifiedExpr = (PyQualifiedExpression)callee).getQualifier()) != null && "format".equals(qualifiedExpr.getReferencedName())) {
            return qualifier;
        }
        return null;
    }

    @NotNull
    private static InjectionResult processStringLiteral(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, @NotNull String prefix, @NotNull String suffix, @NotNull Formatting formatting) {
        PyExpression qualifier;
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(7);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            PyInjectionUtil.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            PyInjectionUtil.$$$reportNull$$$0(10);
        }
        if (formatting == null) {
            PyInjectionUtil.$$$reportNull$$$0(11);
        }
        String missingValue = "missing_value";
        if (element instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
            boolean injected = false;
            boolean strict = true;
            for (PyStringElement stringElem : expr.getStringElements()) {
                int nodeOffsetInParent = stringElem.getTextOffset() - expr.getTextRange().getStartOffset();
                TextRange contentRange = stringElem.getContentRange();
                int contentStartOffset = contentRange.getStartOffset();
                if (formatting != Formatting.NONE || stringElem.isFormatted()) {
                    List subsRanges;
                    if (formatting != Formatting.NONE) {
                        String content2 = stringElem.getContent();
                        subsRanges = StreamEx.of(formatting == Formatting.NEW_STYLE ? PyStringFormatParser.parseNewStyleFormat(content2) : PyStringFormatParser.parsePercentFormat(content2)).select(PyStringFormatParser.SubstitutionChunk.class).map(chunk -> chunk.getTextRange().shiftRight(contentStartOffset)).toList();
                    } else {
                        subsRanges = ContainerUtil.map(((PyFormattedStringElement)stringElem).getFragments(), PsiElement::getTextRangeInParent);
                    }
                    if (!subsRanges.isEmpty()) {
                        strict = false;
                    }
                    TextRange sentinel = TextRange.from((int)contentRange.getEndOffset(), (int)0);
                    List withSentinel = ContainerUtil.append((List)subsRanges, (Object[])new TextRange[]{sentinel});
                    int literalChunkStart = contentStartOffset;
                    for (int i = 0; i < withSentinel.size(); ++i) {
                        TextRange subRange = (TextRange)withSentinel.get(i);
                        int literalChunkEnd = subRange.getStartOffset();
                        if (literalChunkEnd > literalChunkStart) {
                            String chunkPrefix = i == 0 ? prefix : (i == 1 && ((TextRange)withSentinel.get(0)).getStartOffset() == contentStartOffset ? "missing_value" : "");
                            String chunkSuffix = i < withSentinel.size() - 1 ? "missing_value" : (i == withSentinel.size() - 1 ? suffix : "");
                            TextRange chunkRange = TextRange.create((int)literalChunkStart, (int)literalChunkEnd);
                            registrar.addPlace(chunkPrefix, chunkSuffix, (PsiLanguageInjectionHost)expr, chunkRange.shiftRight(nodeOffsetInParent));
                            injected = true;
                        }
                        literalChunkStart = subRange.getEndOffset();
                    }
                    continue;
                }
                registrar.addPlace(prefix, suffix, (PsiLanguageInjectionHost)expr, contentRange.shiftRight(nodeOffsetInParent));
                injected = true;
            }
            return new InjectionResult(injected, strict);
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            if (contained != null) {
                return PyInjectionUtil.processStringLiteral((PsiElement)contained, registrar, prefix, suffix, formatting);
            }
        } else if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            boolean isLeftString = PyInjectionUtil.isStringLiteralPart((PsiElement)left, null);
            if (expr.isOperator("+")) {
                boolean isRightString = right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, null);
                InjectionResult result2 = InjectionResult.EMPTY;
                if (isLeftString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, isRightString ? "" : "missing_value", formatting));
                }
                if (isRightString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)right, registrar, isLeftString ? "" : "missing_value", suffix, formatting));
                }
                InjectionResult injectionResult = result2;
                if (injectionResult == null) {
                    PyInjectionUtil.$$$reportNull$$$0(12);
                }
                return injectionResult;
            }
            if (expr.isOperator("%")) {
                return PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, suffix, Formatting.PERCENT);
            }
        } else if (element instanceof PyCallExpression && (qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element)) != null) {
            return PyInjectionUtil.processStringLiteral((PsiElement)qualifier, registrar, prefix, suffix, Formatting.NEW_STYLE);
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(13);
        }
        return injectionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStringLiteralInjection";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLargestStringLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjection";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralPart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFormatCallQualifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processStringLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static enum Formatting {
        NONE,
        PERCENT,
        NEW_STYLE;

    }

    public static class InjectionResult {
        public static final InjectionResult EMPTY = new InjectionResult(false, true);
        private final boolean myInjected;
        private final boolean myStrict;

        public InjectionResult(boolean injected, boolean strict) {
            this.myInjected = injected;
            this.myStrict = strict;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public InjectionResult append(@NotNull InjectionResult result2) {
            if (result2 == null) {
                InjectionResult.$$$reportNull$$$0(0);
            }
            return new InjectionResult(this.myInjected || result2.isInjected(), this.myStrict && result2.isStrict());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult", "append"));
        }
    }
}

