/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ControlledCycle;
import com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache;
import com.intellij.openapi.vcs.changes.RemoteRevisionsStateCache;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class RemoteRevisionsCache
implements VcsListener {
    @Topic.ProjectLevel
    public static final Topic<Runnable> REMOTE_VERSION_CHANGED = new Topic("REMOTE_VERSION_CHANGED", Runnable.class);
    public static final int DEFAULT_REFRESH_INTERVAL = 180000;
    private final RemoteRevisionsNumbersCache myRemoteRevisionsNumbersCache;
    private final RemoteRevisionsStateCache myRemoteRevisionsStateCache;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final RemoteStatusChangeNodeDecorator myChangeDecorator;
    private final Project myProject;
    private final ControlledCycle myControlledCycle;

    public static RemoteRevisionsCache getInstance(Project project) {
        return (RemoteRevisionsCache)project.getService(RemoteRevisionsCache.class);
    }

    private RemoteRevisionsCache(Project project) {
        this.myProject = project;
        this.myRemoteRevisionsNumbersCache = new RemoteRevisionsNumbersCache(this.myProject);
        this.myRemoteRevisionsStateCache = new RemoteRevisionsStateCache(this.myProject);
        this.myChangeDecorator = new RemoteStatusChangeNodeDecorator(this);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myControlledCycle = new ControlledCycle(project, () -> {
            boolean shouldBeDone;
            boolean bl = shouldBeDone = vcsConfiguration.isChangedOnServerEnabled() && this.myVcsManager.hasActiveVcss();
            if (shouldBeDone) {
                boolean somethingChanged = this.myRemoteRevisionsNumbersCache.updateStep();
                if (somethingChanged |= this.myRemoteRevisionsStateCache.updateStep()) {
                    ((Runnable)BackgroundTaskUtil.syncPublisher((Project)this.myProject, REMOTE_VERSION_CHANGED)).run();
                }
            }
            return shouldBeDone;
        }, VcsBundle.message((String)"changes.finishing.changed.on.server.update", (Object[])new Object[0]), 180000);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)this);
        if (!this.myProject.isDefault() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myVcsManager.runAfterInitialization(() -> {
                if (!this.myVcsManager.hasActiveVcss() || !vcsConfiguration.isChangedOnServerEnabled()) {
                    return;
                }
                this.myControlledCycle.startIfNotStarted();
            });
        }
    }

    public void updateAutomaticRefreshAlarmState(boolean remoteCacheStateChanged) {
        this.manageAlarm();
    }

    private void manageAlarm() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault() && this.myVcsManager.hasActiveVcss() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myControlledCycle.startIfNotStarted();
        } else {
            this.myControlledCycle.stop();
        }
    }

    public void directoryMappingChanged() {
        if (!VcsConfiguration.getInstance((Project)this.myProject).isChangedOnServerEnabled()) {
            this.manageAlarm();
        } else {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
                try {
                    this.myRemoteRevisionsNumbersCache.directoryMappingChanged();
                    this.myRemoteRevisionsStateCache.directoryMappingChanged();
                    this.manageAlarm();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            });
        }
    }

    public void changeUpdated(@NotNull String path, @NotNull AbstractVcs vcs) {
        if (path == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(1);
        }
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeUpdated(path, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeUpdated(path, vcs);
        }
    }

    public void invalidate(UpdatedFiles updatedFiles) {
        ArrayList<String> newForTree = new ArrayList<String>();
        ArrayList<String> newForUsual = new ArrayList<String>();
        UpdateFilesHelper.iterateAffectedFiles(updatedFiles, (Consumer<? super Couple<String>>)((Consumer)pair -> {
            AbstractVcs vcs = this.myVcsManager.findVcsByName((String)pair.getSecond());
            if (vcs == null) {
                return;
            }
            if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
                newForTree.add((String)pair.getFirst());
            } else {
                newForUsual.add((String)pair.getFirst());
            }
        }));
        this.myRemoteRevisionsStateCache.invalidate(newForTree);
        this.myRemoteRevisionsNumbersCache.invalidate(newForUsual);
    }

    public void changeRemoved(@NotNull String path, @NotNull AbstractVcs vcs) {
        if (path == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(3);
        }
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeRemoved(path, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeRemoved(path, vcs);
        }
    }

    public boolean isUpToDate(@NotNull Change change) {
        if (change == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return true;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject);
        if (vcs == null) {
            return true;
        }
        RemoteDifferenceStrategy strategy = vcs.getRemoteDifferenceStrategy();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
            return this.myRemoteRevisionsStateCache.isUpToDate(change, vcs);
        }
        return this.myRemoteRevisionsNumbersCache.isUpToDate(change, vcs);
    }

    @NotNull
    public RemoteStatusChangeNodeDecorator getChangesNodeDecorator() {
        RemoteStatusChangeNodeDecorator remoteStatusChangeNodeDecorator = this.myChangeDecorator;
        if (remoteStatusChangeNodeDecorator == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(5);
        }
        return remoteStatusChangeNodeDecorator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/RemoteRevisionsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/RemoteRevisionsCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNodeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

