/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.LocalChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;)V", "changeInfoCalculator", "Lcom/intellij/openapi/vcs/changes/ui/ChangeInfoCalculator;", "commitLegend", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel;", "deleteLocallyAddedFilesCheckBox", "Ljavax/swing/JCheckBox;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "isInvokedFromModalContext", "", "createCenterPanel", "Ljavax/swing/JComponent;", "inclusionListener", "", "doOKAction", "getPreferredFocusedComponent", "getDimensionServiceKey", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRollbackChangesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackChangesDialog.kt\ncom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1755#2,3:159\n*S KotlinDebug\n*F\n+ 1 RollbackChangesDialog.kt\ncom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog\n*L\n82#1:159,3\n*E\n"})
public final class RollbackChangesDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LocalChangesBrowser browser;
    @NotNull
    private final ChangeInfoCalculator changeInfoCalculator;
    @NotNull
    private final CommitLegendPanel commitLegend;
    private JCheckBox deleteLocallyAddedFilesCheckBox;
    @NotNull
    private final String operationName;
    private final boolean isInvokedFromModalContext;
    @NotNull
    private static final String DELETE_LOCALLY_ADDED_FILES_KEY = "delete.locally.added.files";

    private RollbackChangesDialog(Project project, LocalChangesBrowser browser) {
        super(project, true);
        this.project = project;
        this.browser = browser;
        this.changeInfoCalculator = new ChangeInfoCalculator();
        this.commitLegend = new CommitLegendPanel(this.changeInfoCalculator);
        this.isInvokedFromModalContext = LaterInvocator.isInModalContext();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.browser);
        this.browser.setInclusionChangedListener(() -> RollbackChangesDialog._init_$lambda$0(this));
        this.browser.getViewer().addPropertyChangeListener("model", arg_0 -> RollbackChangesDialog._init_$lambda$1(this, arg_0));
        String string = RollbackUtil.getRollbackOperationName(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRollbackOperationName(...)");
        String operationNameWithMnemonic = string;
        this.setOKButtonText(operationNameWithMnemonic);
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.operationName = UIUtil.removeMnemonic((String)operationNameWithMnemonic);
        Object[] objectArray = new Object[]{StringUtil.toLowerCase((String)this.operationName)};
        this.browser.setToggleActionTitle(VcsBundle.message((String)"changes.action.include.in.operation.name", (Object[])objectArray));
        objectArray = new Object[]{this.operationName};
        this.setTitle(VcsBundle.message((String)"changes.action.rollback.custom.title", (Object[])objectArray));
        this.init();
        this.inclusionListener();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel(arg_0 -> RollbackChangesDialog.createCenterPanel$lambda$7(this, arg_0));
        boolean bl = false;
        it.setMinimumSize((Dimension)JBUI.size((int)200, (int)150));
        return (JComponent)dialogPanel;
    }

    private final void inclusionListener() {
        JCheckBox jCheckBox;
        boolean hasNewFiles;
        List<Change> includedChanges;
        block4: {
            List<Change> allChanges = this.browser.getAllChanges();
            includedChanges = this.browser.getIncludedChanges();
            Intrinsics.checkNotNull(allChanges);
            Intrinsics.checkNotNull(includedChanges);
            ChangeInfoCalculator.update$default(this.changeInfoCalculator, allChanges, CollectionsKt.toList((Iterable)includedChanges), 0, 0, 12, null);
            this.commitLegend.update();
            Iterable $this$any$iv = includedChanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Change change = (Change)element$iv;
                    boolean bl = false;
                    if (!(change.getType() == Change.Type.NEW)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasNewFiles = false;
            }
        }
        if ((jCheckBox = this.deleteLocallyAddedFilesCheckBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deleteLocallyAddedFilesCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setEnabled(hasNewFiles);
        this.getOKAction().setEnabled(!((Collection)includedChanges).isEmpty());
    }

    protected void doOKAction() {
        super.doOKAction();
        RollbackWorker rollbackWorker = new RollbackWorker(this.project, this.operationName, this.isInvokedFromModalContext);
        Collection collection = this.browser.getIncludedChanges();
        JCheckBox jCheckBox = this.deleteLocallyAddedFilesCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deleteLocallyAddedFilesCheckBox");
            jCheckBox = null;
        }
        rollbackWorker.doRollback(collection, jCheckBox.isSelected());
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.browser.getPreferredFocusedComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getPreferredFocusedComponent(...)");
        return jComponent;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }

    private static final void _init_$lambda$0(RollbackChangesDialog this$0) {
        this$0.inclusionListener();
    }

    private static final void _init_$lambda$1(RollbackChangesDialog this$0, PropertyChangeEvent it) {
        this$0.inclusionListener();
    }

    private static final Unit createCenterPanel$lambda$7$lambda$2(RollbackChangesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.browser).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3(RollbackChangesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.commitLegend.getComponent());
        return Unit.INSTANCE;
    }

    private static final boolean createCenterPanel$lambda$7$lambda$6$lambda$4() {
        return PropertiesComponent.getInstance().isTrueValue(DELETE_LOCALLY_ADDED_FILES_KEY);
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6$lambda$5(boolean newValue) {
        PropertiesComponent.getInstance().setValue(DELETE_LOCALLY_ADDED_FILES_KEY, newValue);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(RollbackChangesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"changes.checkbox.delete.locally.added.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.deleteLocallyAddedFilesCheckBox = (JCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), RollbackChangesDialog::createCenterPanel$lambda$7$lambda$6$lambda$4, RollbackChangesDialog::createCenterPanel$lambda$7$lambda$6$lambda$5).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(RollbackChangesDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RollbackChangesDialog.createCenterPanel$lambda$7$lambda$2(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RollbackChangesDialog.createCenterPanel$lambda$7$lambda$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RollbackChangesDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        Companion.rollbackChanges(project, changes);
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project) {
        Companion.rollbackChanges(project);
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project, @NotNull LocalChangeList changeList) {
        Companion.rollbackChanges(project, changeList);
    }

    @JvmStatic
    @NotNull
    public static final String operationNameByChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        return Companion.operationNameByChanges(project, changes);
    }

    public /* synthetic */ RollbackChangesDialog(Project project, LocalChangesBrowser browser, DefaultConstructorMarker $constructor_marker) {
        this(project, browser);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J/\u0010\u0012\u001a\u00130\u0005\u00a2\u0006\u000e\b\u0013\u0012\n\b\u0014\u0012\u0006\b\n0\u00158\u00162\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog$Companion;", "", "<init>", "()V", "DELETE_LOCALLY_ADDED_FILES_KEY", "", "rollbackChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "showRollbackDialog", "browser", "Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;", "operationNameByChanges", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
            LocalChangesBrowser localChangesBrowser;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerEx), (String)"getInstanceEx(...)");
            ChangeListManagerEx changeListManager = changeListManagerEx;
            if (changeListManager.areChangeListsEnabled()) {
                Collection<LocalChangeList> collection = changeListManager.getAffectedLists(changes);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getAffectedLists(...)");
                Collection<LocalChangeList> lists = collection;
                localChangesBrowser = !lists.isEmpty() ? (LocalChangesBrowser)new LocalChangesBrowser.SelectedChangeLists(project, lists) : (LocalChangesBrowser)new LocalChangesBrowser.NonEmptyChangeLists(project);
            } else {
                localChangesBrowser = new LocalChangesBrowser.AllChanges(project);
            }
            LocalChangesBrowser browser = localChangesBrowser;
            browser.getViewer().invokeAfterRefresh(() -> Companion.rollbackChanges$lambda$0(browser, changes));
            this.showRollbackDialog(project, browser);
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project) {
            LocalChangesBrowser localChangesBrowser;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            if (changeListManager2.areChangeListsEnabled()) {
                LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
                Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
                LocalChangeList defaultChangeList = localChangeList;
                Collection collection = defaultChangeList.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                localChangesBrowser = !collection.isEmpty() ? (LocalChangesBrowser)new LocalChangesBrowser.SelectedChangeLists(project, CollectionsKt.listOf((Object)defaultChangeList)) : (LocalChangesBrowser)new LocalChangesBrowser.NonEmptyChangeLists(project);
            } else {
                localChangesBrowser = new LocalChangesBrowser.AllChanges(project);
            }
            LocalChangesBrowser browser = localChangesBrowser;
            this.showRollbackDialog(project, browser);
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project, @NotNull LocalChangeList changeList) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
            List lists = CollectionsKt.listOf((Object)changeList);
            LocalChangesBrowser.SelectedChangeLists browser = new LocalChangesBrowser.SelectedChangeLists(project, lists);
            this.showRollbackDialog(project, browser);
        }

        private final void showRollbackDialog(Project project, LocalChangesBrowser browser) {
            new RollbackChangesDialog(project, browser, null).show();
        }

        @JvmStatic
        @NotNull
        public final String operationNameByChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            String string = RollbackUtil.getRollbackOperationName(ChangesUtil.getAffectedVcses(changes, (Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRollbackOperationName(...)");
            return string;
        }

        private static final void rollbackChanges$lambda$0(LocalChangesBrowser $browser, Collection $changes) {
            $browser.setIncludedChangesBy($changes);
            $browser.getViewer().resetTreeState();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

