/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.foundation.util;

import androidx.compose.runtime.internal.StabilityInferred;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\b'\u0018\u0000 \u00132\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001c\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001c\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001c\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001c\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "", "<init>", "()V", "trace", "", "message", "", "t", "", "debug", "info", "warn", "error", "Factory", "JavaFactory", "ReflectionBasedFactory", "IdeaFactory", "Slf4JFactory", "Companion", "foundation"})
@ApiStatus.NonExtendable
@StabilityInferred(parameters=1)
public abstract class JewelLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Factory factory;

    public final void trace(@Nullable String message) {
        this.trace(message, null);
    }

    public final void trace(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.trace(t.getMessage(), t);
    }

    public final void debug(@Nullable String message) {
        this.debug(message, null);
    }

    public final void debug(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.debug(t.getMessage(), t);
    }

    public final void info(@Nullable String message) {
        this.info(message, null);
    }

    public final void info(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.info(t.getMessage(), t);
    }

    public final void warn(@Nullable String message) {
        this.warn(message, null);
    }

    public final void warn(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.warn(t.getMessage(), t);
    }

    public final void error(@Nullable String message) {
        this.error(message, null);
    }

    public final void error(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.error(t.getMessage(), t);
    }

    public abstract void trace(@Nullable String var1, @Nullable Throwable var2);

    public abstract void debug(@Nullable String var1, @Nullable Throwable var2);

    public abstract void info(@Nullable String var1, @Nullable Throwable var2);

    public abstract void warn(@Nullable String var1, @Nullable Throwable var2);

    public abstract void error(@Nullable String var1, @Nullable Throwable var2);

    static {
        factory = JewelLogger.Companion.createFactory();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$Companion;", "", "<init>", "()V", "factory", "Lorg/jetbrains/jewel/foundation/util/JewelLogger$Factory;", "createFactory", "getInstance", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "category", "", "clazz", "Ljava/lang/Class;", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        private final Factory createFactory() {
            Factory factory;
            try {
                factory = new IdeaFactory();
            }
            catch (Throwable t) {
                Factory factory2;
                try {
                    factory2 = new Slf4JFactory();
                }
                catch (Throwable t2) {
                    factory2 = new JavaFactory();
                }
                factory = factory2;
            }
            return factory;
        }

        @NotNull
        public final JewelLogger getInstance(@NotNull String category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            return factory.getInstance("#" + category);
        }

        @NotNull
        public final JewelLogger getInstance(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return this.getInstance("#" + clazz.getName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$Factory;", "", "getInstance", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "category", "", "foundation"})
    private static interface Factory {
        @NotNull
        public JewelLogger getInstance(@Nullable String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$IdeaFactory;", "Lorg/jetbrains/jewel/foundation/util/JewelLogger$ReflectionBasedFactory;", "<init>", "()V", "myGetInstance", "Ljava/lang/reflect/Method;", "ideaTrace", "ideaDebug", "ideaInfo", "ideaWarn", "ideaError", "trace", "", "message", "", "t", "", "logger", "", "debug", "error", "warn", "info", "getLogger", "category", "foundation"})
    private static final class IdeaFactory
    extends ReflectionBasedFactory {
        @NotNull
        private final Method myGetInstance;
        @NotNull
        private final Method ideaTrace;
        @NotNull
        private final Method ideaDebug;
        @NotNull
        private final Method ideaInfo;
        @NotNull
        private final Method ideaWarn;
        @NotNull
        private final Method ideaError;

        public IdeaFactory() {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            Class[] classArray = new Class[]{String.class};
            this.myGetInstance = loggerClass.getMethod("getInstance", classArray);
            this.myGetInstance.setAccessible(true);
            classArray = new Class[]{Throwable.class};
            this.ideaTrace = loggerClass.getMethod("trace", classArray);
            this.ideaTrace.setAccessible(true);
            classArray = new Class[]{String.class, Throwable.class};
            this.ideaDebug = loggerClass.getMethod("debug", classArray);
            this.ideaDebug.setAccessible(true);
            classArray = new Class[]{String.class, Throwable.class};
            this.ideaInfo = loggerClass.getMethod("info", classArray);
            this.ideaInfo.setAccessible(true);
            classArray = new Class[]{String.class, Throwable.class};
            this.ideaWarn = loggerClass.getMethod("warn", classArray);
            this.ideaWarn.setAccessible(true);
            classArray = new Class[]{String.class, Throwable.class};
            this.ideaError = loggerClass.getMethod("error", classArray);
            this.ideaError.setAccessible(true);
        }

        @Override
        protected void trace(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{t};
            this.ideaTrace.invoke(logger, objectArray);
        }

        @Override
        protected void debug(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.ideaDebug.invoke(logger, objectArray);
        }

        @Override
        protected void error(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.ideaError.invoke(logger, objectArray);
        }

        @Override
        protected void warn(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.ideaWarn.invoke(logger, objectArray);
        }

        @Override
        protected void info(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.ideaInfo.invoke(logger, objectArray);
        }

        @Override
        @NotNull
        protected Object getLogger(@Nullable String category) throws Exception {
            Object[] objectArray = new Object[]{category};
            Object object = this.myGetInstance.invoke(null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b\u00b2\u0006\u0012\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$JavaFactory;", "Lorg/jetbrains/jewel/foundation/util/JewelLogger$Factory;", "<init>", "()V", "getInstance", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "category", "", "foundation", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType"})
    private static final class JavaFactory
    implements Factory {
        @Override
        @NotNull
        public JewelLogger getInstance(@Nullable String category) {
            Lazy logger$delegate = LazyKt.lazy(() -> JavaFactory.getInstance$lambda$0(category));
            return new JewelLogger((Lazy<? extends Logger>)logger$delegate){
                final /* synthetic */ Lazy<Logger> $logger$delegate;
                {
                    this.$logger$delegate = $logger$delegate;
                }

                public void trace(String message, Throwable t) {
                    JavaFactory.access$getInstance$lambda$1(this.$logger$delegate).log(Level.FINER, message, t);
                }

                public void debug(String message, Throwable t) {
                    JavaFactory.access$getInstance$lambda$1(this.$logger$delegate).log(Level.FINE, message, t);
                }

                public void info(String message, Throwable t) {
                    JavaFactory.access$getInstance$lambda$1(this.$logger$delegate).log(Level.INFO, message, t);
                }

                public void warn(String message, Throwable t) {
                    JavaFactory.access$getInstance$lambda$1(this.$logger$delegate).log(Level.WARNING, message, t);
                }

                public void error(String message, Throwable t) {
                    JavaFactory.access$getInstance$lambda$1(this.$logger$delegate).log(Level.SEVERE, message, t);
                }
            };
        }

        private static final Logger getInstance$lambda$0(String $category) {
            Logger l = Logger.getLogger($category);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])l.getHandlers());
            while (iterator2.hasNext()) {
                Handler handler2 = (Handler)iterator2.next();
                l.removeHandler(handler2);
            }
            ConsoleHandler handler3 = new ConsoleHandler();
            handler3.setLevel(Level.FINER);
            l.addHandler(handler3);
            l.setLevel(Level.FINER);
            l.setUseParentHandlers(false);
            return l;
        }

        private static final Logger getInstance$lambda$1(Lazy<? extends Logger> $logger$delegate) {
            Lazy<? extends Logger> lazy = $logger$delegate;
            return (Logger)lazy.getValue();
        }

        public static final /* synthetic */ Logger access$getInstance$lambda$1(Lazy $logger$delegate) {
            return JavaFactory.getInstance$lambda$1((Lazy<? extends Logger>)$logger$delegate);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J&\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J&\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J&\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J&\u0010\u0011\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J&\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H$\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$ReflectionBasedFactory;", "Lorg/jetbrains/jewel/foundation/util/JewelLogger$Factory;", "<init>", "()V", "getInstance", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "category", "", "trace", "", "message", "t", "", "logger", "", "debug", "error", "warn", "info", "getLogger", "foundation"})
    private static abstract class ReflectionBasedFactory
    implements Factory {
        @Override
        @NotNull
        public JewelLogger getInstance(@Nullable String category) throws RuntimeException {
            try {
                Object logger = this.getLogger(category);
                return new JewelLogger(this, logger){
                    final /* synthetic */ ReflectionBasedFactory this$0;
                    final /* synthetic */ Object $logger;
                    {
                        this.this$0 = $receiver;
                        this.$logger = $logger;
                    }

                    public void trace(String message, Throwable t) {
                        try {
                            this.this$0.trace(message, t, this.$logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void debug(String message, Throwable t) {
                        try {
                            this.this$0.debug(message, t, this.$logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void info(String message, Throwable t) {
                        try {
                            this.this$0.info(message, t, this.$logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void warn(String message, Throwable t) {
                        try {
                            this.this$0.warn(message, t, this.$logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void error(String message, Throwable t) {
                        try {
                            this.this$0.error(message, t, this.$logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void trace(@Nullable String var1, @Nullable Throwable var2, @Nullable Object var3) throws Exception;

        protected abstract void debug(@Nullable String var1, @Nullable Throwable var2, @Nullable Object var3) throws Exception;

        protected abstract void error(@Nullable String var1, @Nullable Throwable var2, @Nullable Object var3) throws Exception;

        protected abstract void warn(@Nullable String var1, @Nullable Throwable var2, @Nullable Object var3) throws Exception;

        protected abstract void info(@Nullable String var1, @Nullable Throwable var2, @Nullable Object var3) throws Exception;

        @NotNull
        protected abstract Object getLogger(@Nullable String var1) throws Exception;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/jewel/foundation/util/JewelLogger$Slf4JFactory;", "Lorg/jetbrains/jewel/foundation/util/JewelLogger$ReflectionBasedFactory;", "<init>", "()V", "myGetLogger", "Ljava/lang/reflect/Method;", "myTrace", "myDebug", "myInfo", "myWarn", "myError", "trace", "", "message", "", "t", "", "logger", "", "debug", "error", "warn", "info", "getLogger", "category", "foundation"})
    private static final class Slf4JFactory
    extends ReflectionBasedFactory {
        @NotNull
        private final Method myGetLogger;
        @NotNull
        private final Method myTrace;
        @NotNull
        private final Method myDebug;
        @NotNull
        private final Method myInfo;
        @NotNull
        private final Method myWarn;
        @NotNull
        private final Method myError;

        public Slf4JFactory() {
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Class[] classArray = new Class[]{String.class};
            this.myGetLogger = loggerFactoryClass.getMethod("getLogger", classArray);
            this.myGetLogger.setAccessible(true);
            Class<?> loggerClass = Class.forName("org.slf4j.Logger");
            Class[] classArray2 = new Class[]{String.class, Throwable.class};
            this.myTrace = loggerClass.getMethod("trace", classArray2);
            this.myTrace.setAccessible(true);
            classArray2 = new Class[]{String.class, Throwable.class};
            this.myDebug = loggerClass.getMethod("debug", classArray2);
            this.myDebug.setAccessible(true);
            classArray2 = new Class[]{String.class, Throwable.class};
            this.myInfo = loggerClass.getMethod("info", classArray2);
            this.myInfo.setAccessible(true);
            classArray2 = new Class[]{String.class, Throwable.class};
            this.myWarn = loggerClass.getMethod("warn", classArray2);
            this.myWarn.setAccessible(true);
            classArray2 = new Class[]{String.class, Throwable.class};
            this.myError = loggerClass.getMethod("error", classArray2);
            this.myError.setAccessible(true);
        }

        @Override
        protected void trace(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.myTrace.invoke(logger, objectArray);
        }

        @Override
        protected void debug(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.myDebug.invoke(logger, objectArray);
        }

        @Override
        protected void error(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.myError.invoke(logger, objectArray);
        }

        @Override
        protected void warn(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.myWarn.invoke(logger, objectArray);
        }

        @Override
        protected void info(@Nullable String message, @Nullable Throwable t, @Nullable Object logger) throws Exception {
            Object[] objectArray = new Object[]{message, t};
            this.myInfo.invoke(logger, objectArray);
        }

        @Override
        @NotNull
        protected Object getLogger(@Nullable String category) throws Exception {
            Object[] objectArray = new Object[]{category};
            Object object = this.myGetLogger.invoke(null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            return object;
        }
    }
}

