/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 40942409100151L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1514120640 + -10168, 1514120640 - 6653, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1514120640 + -10167, 1514120640 + 890, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 4307845547851L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.Y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-6684570 - -((char)-25008), -6684570 - -((char)-24513), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-6684570 - -((char)-25007), 6684570 - (char)-28355, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-6684570 - -((char)-25014), 6684570 - (char)-26525, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 49657511226607L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.Y();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-155), -900713040 - -((char)-7585), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-154), 900713040 - (char)-787, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-153), 900581970 + (char)-4438, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-152), 900713040 - (char)-5765, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-151), -900581970 + -((char)-17535), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-153), 900581970 + (char)-4438, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-900713040 - -((char)-150), -900713040 - -((char)-6150), (int)l2));
            if (!ActionTimestamp.Y()) {
                SshAgentIpcService.Y(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 82641177533025L;
                    stringArray = SshAgentIpcService.Y();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    String[] stringArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 41687379154204L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            stringArray = SshAgentIpcService.Y();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (stringArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(426632850 - (char)-9814, -426632850 - -27467, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9821, -426632850 - -((char)-21951), (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9820, 426632850 - (char)-15492, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(426632850 - (char)-9814, -426632850 - -27467, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9819, 426632850 - (char)-18514, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (stringArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n = Kernel32.INSTANCE.GetLastError();
                            if (n == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(426632850 - (char)-9814, -426632850 - -27467, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9818, -426632850 - -26974, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9825, -426632850 - -((char)-16987), (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9820, 426632850 - (char)-15492, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(426632850 - (char)-9814, -426632850 - -27467, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(426632850 - (char)-9810, -426632850 - -26529, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(426632850 - (char)-9824, 426632850 - (char)-32242, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 72509532404126L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1894485780 + -19569, -1894485780 + -25682, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 114061027467417L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(419030790 - 10633, -419030790 - -21717, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u00e2\u00c8\u00fe\u0097\u00dd;$%\u00ff\\\u00ba\u00e1\u00d3\u00d1W'\u009f/\u00c4\u0014\u0016\u0086`X\u0015\u0000@\u00c7\u00f1\u0006\u00be~\u0091\u00db\u00de\u00edC\u00b0X\r";
                                        var4_3 = "\u00e2\u00c8\u00fe\u0097\u00dd;$%\u00ff\\\u00ba\u00e1\u00d3\u00d1W'\u009f/\u00c4\u0014\u0016\u0086`X\u0015\u0000@\u00c7\u00f1\u0006\u00be~\u0091\u00db\u00de\u00edC\u00b0X\r".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 38;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 100;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 52;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 24;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 106;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 20;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 118;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 41;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n, int n2, int n3) {
                                    int n4 = (n ^ n3 ^ 0xFFFFDDE5) & 0xFFFF;
                                    if (b[n4] == null) {
                                        int n5;
                                        char[] cArray = a[n4].toCharArray();
                                        int n6 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 3;
                                            case 1 -> 109;
                                            case 2 -> 48;
                                            case 3 -> 148;
                                            case 4 -> 2;
                                            case 5 -> 134;
                                            case 6 -> 30;
                                            case 7 -> 87;
                                            case 8 -> 113;
                                            case 9 -> 1;
                                            case 10 -> 135;
                                            case 11 -> 166;
                                            case 12 -> 56;
                                            case 13 -> 232;
                                            case 14 -> 246;
                                            case 15 -> 185;
                                            case 16 -> 20;
                                            case 17 -> 176;
                                            case 18 -> 11;
                                            case 19 -> 0;
                                            case 20 -> 215;
                                            case 21 -> 34;
                                            case 22 -> 156;
                                            case 23 -> 127;
                                            case 24 -> 170;
                                            case 25 -> 24;
                                            case 26 -> 45;
                                            case 27 -> 190;
                                            case 28 -> 165;
                                            case 29 -> 206;
                                            case 30 -> 31;
                                            case 31 -> 61;
                                            case 32 -> 236;
                                            case 33 -> 23;
                                            case 34 -> 155;
                                            case 35 -> 26;
                                            case 36 -> 184;
                                            case 37 -> 182;
                                            case 38 -> 120;
                                            case 39 -> 35;
                                            case 40 -> 100;
                                            case 41 -> 128;
                                            case 42 -> 248;
                                            case 43 -> 99;
                                            case 44 -> 208;
                                            case 45 -> 157;
                                            case 46 -> 138;
                                            case 47 -> 29;
                                            case 48 -> 57;
                                            case 49 -> 27;
                                            case 50 -> 83;
                                            case 51 -> 43;
                                            case 52 -> 112;
                                            case 53 -> 162;
                                            case 54 -> 180;
                                            case 55 -> 9;
                                            case 56 -> 6;
                                            case 57 -> 159;
                                            case 58 -> 46;
                                            case 59 -> 75;
                                            case 60 -> 73;
                                            case 61 -> 32;
                                            case 62 -> 216;
                                            case 63 -> 86;
                                            case 64 -> 173;
                                            case 65 -> 211;
                                            case 66 -> 78;
                                            case 67 -> 161;
                                            case 68 -> 110;
                                            case 69 -> 63;
                                            case 70 -> 119;
                                            case 71 -> 42;
                                            case 72 -> 66;
                                            case 73 -> 230;
                                            case 74 -> 139;
                                            case 75 -> 238;
                                            case 76 -> 178;
                                            case 77 -> 188;
                                            case 78 -> 59;
                                            case 79 -> 142;
                                            case 80 -> 44;
                                            case 81 -> 133;
                                            case 82 -> 13;
                                            case 83 -> 252;
                                            case 84 -> 28;
                                            case 85 -> 103;
                                            case 86 -> 253;
                                            case 87 -> 85;
                                            case 88 -> 114;
                                            case 89 -> 40;
                                            case 90 -> 82;
                                            case 91 -> 144;
                                            case 92 -> 105;
                                            case 93 -> 14;
                                            case 94 -> 191;
                                            case 95 -> 141;
                                            case 96 -> 4;
                                            case 97 -> 169;
                                            case 98 -> 237;
                                            case 99 -> 226;
                                            case 100 -> 189;
                                            case 101 -> 123;
                                            case 102 -> 126;
                                            case 103 -> 93;
                                            case 104 -> 167;
                                            case 105 -> 10;
                                            case 106 -> 224;
                                            case 107 -> 219;
                                            case 108 -> 209;
                                            case 109 -> 41;
                                            case 110 -> 47;
                                            case 111 -> 243;
                                            case 112 -> 69;
                                            case 113 -> 172;
                                            case 114 -> 213;
                                            case 115 -> 241;
                                            case 116 -> 171;
                                            case 117 -> 62;
                                            case 118 -> 154;
                                            case 119 -> 107;
                                            case 120 -> 147;
                                            case 121 -> 214;
                                            case 122 -> 195;
                                            case 123 -> 145;
                                            case 124 -> 244;
                                            case 125 -> 36;
                                            case 126 -> 200;
                                            case 127 -> 137;
                                            case 128 -> 228;
                                            case 129 -> 198;
                                            case 130 -> 121;
                                            case 131 -> 97;
                                            case 132 -> 203;
                                            case 133 -> 158;
                                            case 134 -> 227;
                                            case 135 -> 72;
                                            case 136 -> 116;
                                            case 137 -> 186;
                                            case 138 -> 81;
                                            case 139 -> 183;
                                            case 140 -> 106;
                                            case 141 -> 79;
                                            case 142 -> 104;
                                            case 143 -> 88;
                                            case 144 -> 124;
                                            case 145 -> 251;
                                            case 146 -> 91;
                                            case 147 -> 201;
                                            case 148 -> 101;
                                            case 149 -> 90;
                                            case 150 -> 74;
                                            case 151 -> 151;
                                            case 152 -> 192;
                                            case 153 -> 174;
                                            case 154 -> 193;
                                            case 155 -> 52;
                                            case 156 -> 117;
                                            case 157 -> 207;
                                            case 158 -> 108;
                                            case 159 -> 250;
                                            case 160 -> 54;
                                            case 161 -> 150;
                                            case 162 -> 49;
                                            case 163 -> 136;
                                            case 164 -> 221;
                                            case 165 -> 38;
                                            case 166 -> 197;
                                            case 167 -> 212;
                                            case 168 -> 76;
                                            case 169 -> 70;
                                            case 170 -> 65;
                                            case 171 -> 125;
                                            case 172 -> 16;
                                            case 173 -> 202;
                                            case 174 -> 239;
                                            case 175 -> 68;
                                            case 176 -> 132;
                                            case 177 -> 8;
                                            case 178 -> 84;
                                            case 179 -> 160;
                                            case 180 -> 115;
                                            case 181 -> 177;
                                            case 182 -> 60;
                                            case 183 -> 240;
                                            case 184 -> 17;
                                            case 185 -> 149;
                                            case 186 -> 164;
                                            case 187 -> 254;
                                            case 188 -> 199;
                                            case 189 -> 33;
                                            case 190 -> 71;
                                            case 191 -> 217;
                                            case 192 -> 234;
                                            case 193 -> 5;
                                            case 194 -> 175;
                                            case 195 -> 25;
                                            case 196 -> 229;
                                            case 197 -> 102;
                                            case 198 -> 19;
                                            case 199 -> 247;
                                            case 200 -> 233;
                                            case 201 -> 218;
                                            case 202 -> 15;
                                            case 203 -> 67;
                                            case 204 -> 53;
                                            case 205 -> 231;
                                            case 206 -> 249;
                                            case 207 -> 255;
                                            case 208 -> 118;
                                            case 209 -> 39;
                                            case 210 -> 92;
                                            case 211 -> 55;
                                            case 212 -> 181;
                                            case 213 -> 146;
                                            case 214 -> 80;
                                            case 215 -> 153;
                                            case 216 -> 242;
                                            case 217 -> 89;
                                            case 218 -> 94;
                                            case 219 -> 95;
                                            case 220 -> 204;
                                            case 221 -> 152;
                                            case 222 -> 64;
                                            case 223 -> 222;
                                            case 224 -> 77;
                                            case 225 -> 245;
                                            case 226 -> 225;
                                            case 227 -> 129;
                                            case 228 -> 122;
                                            case 229 -> 131;
                                            case 230 -> 140;
                                            case 231 -> 179;
                                            case 232 -> 235;
                                            case 233 -> 12;
                                            case 234 -> 143;
                                            case 235 -> 22;
                                            case 236 -> 58;
                                            case 237 -> 7;
                                            case 238 -> 51;
                                            case 239 -> 18;
                                            case 240 -> 21;
                                            case 241 -> 194;
                                            case 242 -> 130;
                                            case 243 -> 187;
                                            case 244 -> 220;
                                            case 245 -> 50;
                                            case 246 -> 223;
                                            case 247 -> 96;
                                            case 248 -> 37;
                                            case 249 -> 210;
                                            case 250 -> 168;
                                            case 251 -> 111;
                                            case 252 -> 163;
                                            case 253 -> 205;
                                            case 254 -> 98;
                                            default -> 196;
                                        };
                                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                                        if (n7 < 0) {
                                            n7 += 256;
                                        }
                                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                                            n5 += 256;
                                        }
                                        int n8 = 0;
                                        while (n8 < cArray.length) {
                                            int n9 = n8 % 2;
                                            int n10 = n8;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n10];
                                            if (n9 == 0) {
                                                cArray2[n10] = (char)(c2 ^ n7);
                                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                                            } else {
                                                cArray2[n10] = (char)(c2 ^ n5);
                                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                                            }
                                            ++n8;
                                        }
                                        accept.3.b[n4] = new String(cArray).intern();
                                    }
                                    return b[n4];
                                }
                            };
                            if (stringArray != null) break block32;
                            if (!ActionTimestamp.Y()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.Y(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 116757455304691L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.Y();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1230616230 + -23379, 1230616230 + (char)-20560, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1230616230 + -23375, 1230616230 + (char)-21190, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1230616230 + -23356, 1230616230 + (char)-22475, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1230616230 + -23379, 1230616230 + (char)-20560, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1230616230 + -23375, 1230616230 + (char)-21190, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1230616230 + -23355, -1230616230 + -31099, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 21511125044200L;
                        String[] stringArray2 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1928826120 + 1275, 1928826120 + 10465, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1928826120 + 1274, -1928826120 + -18734, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 39807076584131L;
                String[] stringArray2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8673, -1319612760 + -((char)-3262), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8677, -1319612760 + -((char)-4136), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8660, -1319743830 - -((char)-18253), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8677, -1319612760 + -((char)-4136), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8667, 1319743830 - (char)-19315, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8673, -1319612760 + -((char)-3262), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8677, -1319612760 + -((char)-4136), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8661, 1319612760 + (char)-6751, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8673, -1319612760 + -((char)-3262), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8677, -1319612760 + -((char)-4136), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8654, -1319743830 - -((char)-12793), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8673, -1319612760 + -((char)-3262), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8677, -1319612760 + -((char)-4136), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1319743830 - (char)-8655, -1319612760 + -((char)-1133), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 70563949563538L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.Y();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1931840730 + 19084, -1931840730 + -5103, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1931840730 + 19088, -1931840730 + -6309, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1931840730 + 19101, -1931840730 + -8518, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1931840730 + 19100, -1931840730 + -28883, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1931840730 + 19084, -1931840730 + -5103, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1931840730 + 19088, -1931840730 + -6309, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1931840730 + 19095, 1931840730 + 6913, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1931840730 + 19084, -1931840730 + -5103, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1931840730 + 19088, -1931840730 + -6309, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1931840730 + 19094, 1931840730 + 3943, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1931840730 + 19084, -1931840730 + -5103, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1931840730 + 19088, -1931840730 + -6309, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1931840730 + 19097, -1931840730 + -13993, (int)l2));
                    if (stringArray == null) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1931840730 + 19084, -1931840730 + -5103, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1931840730 + 19088, -1931840730 + -6309, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1931840730 + 19096, 1931840730 + 22102, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "c\u0005Y\u00f1\u00dcu\u00deQ\u0014\u009c\u0095\u009e\u0004\u00daC\u00b1\u008d\u00aa\u007f*\u001bm\u0081\u00ed\u0093s\u00d2\u008b9\u0006\u0086\u0097\u00e5\u00a3!~\u00185\u000e\u00cbG\u00f2\u00ee\u00b6\u00f8\u0082\u00ac \u0011J?[\u00c6\f\u0011J\u00dc\u009f+u\u00aa\ti\u00ba\u00de`;\u0095\u0097\u00df\u009a\u0005k\u00e5X\u00ed\u008c\bb`y,\u008a\u00e8\u0012\u0000\u0005\u0081Z\u0005\u001a'\u001e\u00efX\u00dd>\u00a1\u0005~\u00ff>X\u00fc\b\u009d<\u0003\u00c2\u00e6\u0000\u00c5\n\u00c2\u00de\u00d2\u00d9rj2u\u00d2\t\u0010\u00af\u001a1\u00b3k\u0086\u00d1v\u00b6\u00db`\u0085\b\u00d8\u001e\u00c1\tT\u0019\u00af\u0005F\u001e\u001e1E\u0010\u0085\u00d8t\u00eb\u00c3\u008d\u00c4\u0017\u0014\u00f74\u0000\u0082hO\u00d7?\u00c9\u00b3\u0011C5\u00a3iG\u00ad\u009e\u00cb+\u00c4\u00ae\u0015\u00a9\u00e1\bX\u00ce\u00ff\u0014\u000e\u00e6\u00f9eN j\u00f5\u00f1\u0098E\u00af\u008bO\u00fb9|\u00dd\u00e3{l2\u00d7\u0015\u00ef\u00964\u0093\u00d9g!JzrO\u00ce\u0082\u00d5\u0007qL\bI,\u001c\u00a5&\u00d9\u0087&\f\u008a\u0016t\u00f960k\u001c\u00c8\u00de\u00fd!F\u0014\u0004\u00a7\u00bbLx$\u0015!\u00f3\u00ca@r\u00cb\u00dc#$>\u00e0\u00a7\u00fak\u00ad;\u00bb\u00f5\u00f59\u00a2\u00ff\u00d2\u00e5\u001d\u00b6BM\u00184\u00ab\u00b8\u008a\u00c2\u00ca\u00fe\u00dd\t\u00fahq\u00b4\u0017)\u0017\u0015\u00aa\u0082\u00ca\u00a4\u00a4$\u00f0&\u00ee\u00f4\u00ed\u0001TxCE\u001fp\u00fc.\u00aa\u00df\u0097\u00b1\u00ad\u00c7\u0012\u00c3Az\b\u00f4\u00f5c\u000e\b\u0001\u00b0?KN Ho\u00fdd\u00e9\b\u000bF\u00f8\u00ed$\u0005\u008b\rk\u0004<n\u0015)\u00f1\u0000\u0006\u00bf\u00a7\u00b6\u0093M\u00c3\u008f\u00b0M\u009a\u000f\u00f1\u00e7\u001aE\u00fa/)\"wd\u00db\u0096\u00b9\u0098h\u00e2\u00aagV\u00ea\u00e0x\u00ed\u00ad\u0085\n\u00d7\u0000\u009d\u009b\u0002U\u0088\u0016\u009dd\u0011\u008a\u0006\u00e8o\u009a\u00fb\u001d\u00ff\u0080hL\u0007\u0082\u008cz\u00beqH\u00ff\u0007s\u00b0 U\u00dd\u00da|(\u00b7J\u009a]\u00f9\u0003\u0083\u0018\u00f1s/[\u00c0\u00c0\u007fjJ\u00d8X?+\u00be\u0091\u00ad\u0084\u00c1\u009a\u00cf\u00c2;\u0085Z\u00f2\u008fGJ\u001c\u00b43\u00f2\u000f\u001f\u0098\u00c1.z\u0001V\u009b>\u008ew\u00b5kI\u0094\"\u0017\u00a2\u00c2aB\u00ee\u0002\u0082\u00b1\u00f7\r\u00fd\u00a4\u0099\u00d5\f\u00f3\u0090K7\u00c2\u0081c\u00d1\u00d9\u00a6J\u0086\u00cb@\u00dd+,9\u000e\u008d\u0097\u0093\u00cf0=\u001f\u001c\u0017~R\u00ab\u00c3\u0080\u001b\u0094\u001a\u00b7{O\u001ee$\u000f\u00fe\u00dc\u00baB\u0094/\u00bb\u0004\u00cc\b \u0091Wz\u00ad\u00b1D\u0012\n\u000e| \u00b0\u00a9\u0083j\u00bdE\u00af\u0018\u0081\u00f8\u0015*\u001a\u0088\u00ee\u00a8`\u00a6\u00f3.\u001eUX\u00a2\u009d\u00ee\u00ec\u001du\u00bb\u00bdc)\u00f9/\u001f\u00d0\u00f9\u00d8uD_/\u00d0\u00e6\u0018\u00ff\u00b9u\u00eb\u00e3\u001d\u00de\u00d8\u00ac\u00c9(j_l\u008bx\u008f\u00b2D\u00ca\u00f9\u000b\u00bd\u00f1\u0013\u001d\u00f5\u00ff";
                var4_3 = "c\u0005Y\u00f1\u00dcu\u00deQ\u0014\u009c\u0095\u009e\u0004\u00daC\u00b1\u008d\u00aa\u007f*\u001bm\u0081\u00ed\u0093s\u00d2\u008b9\u0006\u0086\u0097\u00e5\u00a3!~\u00185\u000e\u00cbG\u00f2\u00ee\u00b6\u00f8\u0082\u00ac \u0011J?[\u00c6\f\u0011J\u00dc\u009f+u\u00aa\ti\u00ba\u00de`;\u0095\u0097\u00df\u009a\u0005k\u00e5X\u00ed\u008c\bb`y,\u008a\u00e8\u0012\u0000\u0005\u0081Z\u0005\u001a'\u001e\u00efX\u00dd>\u00a1\u0005~\u00ff>X\u00fc\b\u009d<\u0003\u00c2\u00e6\u0000\u00c5\n\u00c2\u00de\u00d2\u00d9rj2u\u00d2\t\u0010\u00af\u001a1\u00b3k\u0086\u00d1v\u00b6\u00db`\u0085\b\u00d8\u001e\u00c1\tT\u0019\u00af\u0005F\u001e\u001e1E\u0010\u0085\u00d8t\u00eb\u00c3\u008d\u00c4\u0017\u0014\u00f74\u0000\u0082hO\u00d7?\u00c9\u00b3\u0011C5\u00a3iG\u00ad\u009e\u00cb+\u00c4\u00ae\u0015\u00a9\u00e1\bX\u00ce\u00ff\u0014\u000e\u00e6\u00f9eN j\u00f5\u00f1\u0098E\u00af\u008bO\u00fb9|\u00dd\u00e3{l2\u00d7\u0015\u00ef\u00964\u0093\u00d9g!JzrO\u00ce\u0082\u00d5\u0007qL\bI,\u001c\u00a5&\u00d9\u0087&\f\u008a\u0016t\u00f960k\u001c\u00c8\u00de\u00fd!F\u0014\u0004\u00a7\u00bbLx$\u0015!\u00f3\u00ca@r\u00cb\u00dc#$>\u00e0\u00a7\u00fak\u00ad;\u00bb\u00f5\u00f59\u00a2\u00ff\u00d2\u00e5\u001d\u00b6BM\u00184\u00ab\u00b8\u008a\u00c2\u00ca\u00fe\u00dd\t\u00fahq\u00b4\u0017)\u0017\u0015\u00aa\u0082\u00ca\u00a4\u00a4$\u00f0&\u00ee\u00f4\u00ed\u0001TxCE\u001fp\u00fc.\u00aa\u00df\u0097\u00b1\u00ad\u00c7\u0012\u00c3Az\b\u00f4\u00f5c\u000e\b\u0001\u00b0?KN Ho\u00fdd\u00e9\b\u000bF\u00f8\u00ed$\u0005\u008b\rk\u0004<n\u0015)\u00f1\u0000\u0006\u00bf\u00a7\u00b6\u0093M\u00c3\u008f\u00b0M\u009a\u000f\u00f1\u00e7\u001aE\u00fa/)\"wd\u00db\u0096\u00b9\u0098h\u00e2\u00aagV\u00ea\u00e0x\u00ed\u00ad\u0085\n\u00d7\u0000\u009d\u009b\u0002U\u0088\u0016\u009dd\u0011\u008a\u0006\u00e8o\u009a\u00fb\u001d\u00ff\u0080hL\u0007\u0082\u008cz\u00beqH\u00ff\u0007s\u00b0 U\u00dd\u00da|(\u00b7J\u009a]\u00f9\u0003\u0083\u0018\u00f1s/[\u00c0\u00c0\u007fjJ\u00d8X?+\u00be\u0091\u00ad\u0084\u00c1\u009a\u00cf\u00c2;\u0085Z\u00f2\u008fGJ\u001c\u00b43\u00f2\u000f\u001f\u0098\u00c1.z\u0001V\u009b>\u008ew\u00b5kI\u0094\"\u0017\u00a2\u00c2aB\u00ee\u0002\u0082\u00b1\u00f7\r\u00fd\u00a4\u0099\u00d5\f\u00f3\u0090K7\u00c2\u0081c\u00d1\u00d9\u00a6J\u0086\u00cb@\u00dd+,9\u000e\u008d\u0097\u0093\u00cf0=\u001f\u001c\u0017~R\u00ab\u00c3\u0080\u001b\u0094\u001a\u00b7{O\u001ee$\u000f\u00fe\u00dc\u00baB\u0094/\u00bb\u0004\u00cc\b \u0091Wz\u00ad\u00b1D\u0012\n\u000e| \u00b0\u00a9\u0083j\u00bdE\u00af\u0018\u0081\u00f8\u0015*\u001a\u0088\u00ee\u00a8`\u00a6\u00f3.\u001eUX\u00a2\u009d\u00ee\u00ec\u001du\u00bb\u00bdc)\u00f9/\u001f\u00d0\u00f9\u00d8uD_/\u00d0\u00e6\u0018\u00ff\u00b9u\u00eb\u00e3\u001d\u00de\u00d8\u00ac\u00c9(j_l\u008bx\u008f\u00b2D\u00ca\u00f9\u000b\u00bd\u00f1\u0013\u001d\u00f5\u00ff".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 38;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "Q\u0015\u00ddH\u00d0\u00aaH.\u00e0\u001d\u00ec>o %\u0014<\u000f\u00a4\u0094}C\u007f\u0099\u0087k\u00fe\u00fe=+[\u00ff\u0098N9]E\\\u001f";
                    var4_3 = "Q\u0015\u00ddH\u00d0\u00aaH.\u00e0\u001d\u00ec>o %\u0014<\u000f\u00a4\u0094}C\u007f\u0099\u0087k\u00fe\u00fe=+[\u00ff\u0098N9]E\\\u001f".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 91;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 93;
                            break;
                        }
                        case 1: {
                            v15 = 30;
                            break;
                        }
                        case 2: {
                            v15 = 114;
                            break;
                        }
                        case 3: {
                            v15 = 81;
                            break;
                        }
                        case 4: {
                            v15 = 117;
                            break;
                        }
                        case 5: {
                            v15 = 43;
                            break;
                        }
                        default: {
                            v15 = 39;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x19FF) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 69;
                case 1 -> 158;
                case 2 -> 143;
                case 3 -> 223;
                case 4 -> 235;
                case 5 -> 227;
                case 6 -> 81;
                case 7 -> 237;
                case 8 -> 167;
                case 9 -> 102;
                case 10 -> 85;
                case 11 -> 222;
                case 12 -> 84;
                case 13 -> 211;
                case 14 -> 41;
                case 15 -> 13;
                case 16 -> 128;
                case 17 -> 7;
                case 18 -> 62;
                case 19 -> 243;
                case 20 -> 161;
                case 21 -> 115;
                case 22 -> 154;
                case 23 -> 138;
                case 24 -> 76;
                case 25 -> 105;
                case 26 -> 3;
                case 27 -> 174;
                case 28 -> 117;
                case 29 -> 114;
                case 30 -> 149;
                case 31 -> 46;
                case 32 -> 239;
                case 33 -> 37;
                case 34 -> 39;
                case 35 -> 152;
                case 36 -> 109;
                case 37 -> 50;
                case 38 -> 155;
                case 39 -> 80;
                case 40 -> 236;
                case 41 -> 4;
                case 42 -> 126;
                case 43 -> 35;
                case 44 -> 68;
                case 45 -> 250;
                case 46 -> 72;
                case 47 -> 48;
                case 48 -> 86;
                case 49 -> 204;
                case 50 -> 2;
                case 51 -> 172;
                case 52 -> 88;
                case 53 -> 203;
                case 54 -> 205;
                case 55 -> 51;
                case 56 -> 77;
                case 57 -> 196;
                case 58 -> 113;
                case 59 -> 198;
                case 60 -> 185;
                case 61 -> 145;
                case 62 -> 162;
                case 63 -> 181;
                case 64 -> 31;
                case 65 -> 11;
                case 66 -> 79;
                case 67 -> 70;
                case 68 -> 193;
                case 69 -> 151;
                case 70 -> 19;
                case 71 -> 165;
                case 72 -> 60;
                case 73 -> 142;
                case 74 -> 202;
                case 75 -> 184;
                case 76 -> 146;
                case 77 -> 55;
                case 78 -> 168;
                case 79 -> 191;
                case 80 -> 207;
                case 81 -> 5;
                case 82 -> 192;
                case 83 -> 34;
                case 84 -> 66;
                case 85 -> 246;
                case 86 -> 224;
                case 87 -> 130;
                case 88 -> 106;
                case 89 -> 201;
                case 90 -> 20;
                case 91 -> 241;
                case 92 -> 96;
                case 93 -> 32;
                case 94 -> 245;
                case 95 -> 100;
                case 96 -> 65;
                case 97 -> 78;
                case 98 -> 112;
                case 99 -> 213;
                case 100 -> 220;
                case 101 -> 232;
                case 102 -> 134;
                case 103 -> 111;
                case 104 -> 141;
                case 105 -> 144;
                case 106 -> 53;
                case 107 -> 248;
                case 108 -> 28;
                case 109 -> 197;
                case 110 -> 56;
                case 111 -> 123;
                case 112 -> 177;
                case 113 -> 22;
                case 114 -> 249;
                case 115 -> 92;
                case 116 -> 125;
                case 117 -> 104;
                case 118 -> 136;
                case 119 -> 122;
                case 120 -> 209;
                case 121 -> 228;
                case 122 -> 108;
                case 123 -> 176;
                case 124 -> 121;
                case 125 -> 87;
                case 126 -> 42;
                case 127 -> 183;
                case 128 -> 38;
                case 129 -> 163;
                case 130 -> 27;
                case 131 -> 131;
                case 132 -> 187;
                case 133 -> 255;
                case 134 -> 217;
                case 135 -> 173;
                case 136 -> 110;
                case 137 -> 216;
                case 138 -> 240;
                case 139 -> 26;
                case 140 -> 61;
                case 141 -> 147;
                case 142 -> 244;
                case 143 -> 190;
                case 144 -> 40;
                case 145 -> 225;
                case 146 -> 135;
                case 147 -> 71;
                case 148 -> 140;
                case 149 -> 23;
                case 150 -> 182;
                case 151 -> 238;
                case 152 -> 99;
                case 153 -> 74;
                case 154 -> 179;
                case 155 -> 247;
                case 156 -> 139;
                case 157 -> 94;
                case 158 -> 47;
                case 159 -> 166;
                case 160 -> 226;
                case 161 -> 17;
                case 162 -> 95;
                case 163 -> 1;
                case 164 -> 153;
                case 165 -> 124;
                case 166 -> 254;
                case 167 -> 219;
                case 168 -> 89;
                case 169 -> 119;
                case 170 -> 14;
                case 171 -> 180;
                case 172 -> 29;
                case 173 -> 171;
                case 174 -> 186;
                case 175 -> 195;
                case 176 -> 16;
                case 177 -> 116;
                case 178 -> 43;
                case 179 -> 148;
                case 180 -> 36;
                case 181 -> 83;
                case 182 -> 49;
                case 183 -> 103;
                case 184 -> 54;
                case 185 -> 6;
                case 186 -> 8;
                case 187 -> 214;
                case 188 -> 59;
                case 189 -> 44;
                case 190 -> 194;
                case 191 -> 252;
                case 192 -> 98;
                case 193 -> 118;
                case 194 -> 233;
                case 195 -> 107;
                case 196 -> 58;
                case 197 -> 175;
                case 198 -> 200;
                case 199 -> 63;
                case 200 -> 132;
                case 201 -> 160;
                case 202 -> 21;
                case 203 -> 164;
                case 204 -> 178;
                case 205 -> 189;
                case 206 -> 231;
                case 207 -> 199;
                case 208 -> 91;
                case 209 -> 133;
                case 210 -> 52;
                case 211 -> 150;
                case 212 -> 15;
                case 213 -> 212;
                case 214 -> 170;
                case 215 -> 218;
                case 216 -> 0;
                case 217 -> 25;
                case 218 -> 82;
                case 219 -> 251;
                case 220 -> 234;
                case 221 -> 64;
                case 222 -> 221;
                case 223 -> 67;
                case 224 -> 242;
                case 225 -> 9;
                case 226 -> 75;
                case 227 -> 156;
                case 228 -> 90;
                case 229 -> 188;
                case 230 -> 33;
                case 231 -> 159;
                case 232 -> 30;
                case 233 -> 93;
                case 234 -> 210;
                case 235 -> 215;
                case 236 -> 206;
                case 237 -> 101;
                case 238 -> 230;
                case 239 -> 157;
                case 240 -> 253;
                case 241 -> 45;
                case 242 -> 169;
                case 243 -> 129;
                case 244 -> 57;
                case 245 -> 24;
                case 246 -> 10;
                case 247 -> 229;
                case 248 -> 208;
                case 249 -> 120;
                case 250 -> 137;
                case 251 -> 18;
                case 252 -> 73;
                case 253 -> 97;
                case 254 -> 12;
                default -> 127;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 104708401497769L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1393798380 + -18255, 1393798380 - 6579, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 28770306153357L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1679793120 - 17664, 1679793120 - 16285, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1679793120 - 17661, 1679793120 - (char)-32491, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1679793120 - 17662, -1679793120 - -((char)-29960), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "i\u0080\u00a3K!\u0011\u008e\u00a1\u0010\u00ef+\u0082\u009f\u00bf0\u00a4\u00dc\u00d95\u0087\u00fa\u00c7\u00d8\u009b\u0000";
                    var4_3 = "i\u0080\u00a3K!\u0011\u008e\u00a1\u0010\u00ef+\u0082\u009f\u00bf0\u00a4\u00dc\u00d95\u0087\u00fa\u00c7\u00d8\u009b\u0000".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 113;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "=\u00e4d\u008a\u00e45&\u00be\u0010\u00ad\u00b8\u0002\u0011|U\u00d7\u00c9+\u00b4E\u00bdt\u001c=\u009f\u0087\u00b9\u0089\u00e6\u00f7\u00c2\u0007H\u00e4\u000b\u00d1\u00fa\u001c7\u00fdcu\u00af\u00a2\u00f5*\u001c\b58_\u00f8\u00e3\u00c7\u00a3~\u00b4\t\u008e";
                        var4_3 = "=\u00e4d\u008a\u00e45&\u00be\u0010\u00ad\u00b8\u0002\u0011|U\u00d7\u00c9+\u00b4E\u00bdt\u001c=\u009f\u0087\u00b9\u0089\u00e6\u00f7\u00c2\u0007H\u00e4\u000b\u00d1\u00fa\u001c7\u00fdcu\u00af\u00a2\u00f5*\u001c\b58_\u00f8\u00e3\u00c7\u00a3~\u00b4\t\u008e".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 16;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 60;
                                break;
                            }
                            case 1: {
                                v15 = 65;
                                break;
                            }
                            case 2: {
                                v15 = 88;
                                break;
                            }
                            case 3: {
                                v15 = 13;
                                break;
                            }
                            case 4: {
                                v15 = 47;
                                break;
                            }
                            case 5: {
                                v15 = 46;
                                break;
                            }
                            default: {
                                v15 = 62;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFF8D6C) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 90;
                    case 1 -> 50;
                    case 2 -> 116;
                    case 3 -> 171;
                    case 4 -> 87;
                    case 5 -> 38;
                    case 6 -> 70;
                    case 7 -> 100;
                    case 8 -> 113;
                    case 9 -> 55;
                    case 10 -> 101;
                    case 11 -> 207;
                    case 12 -> 54;
                    case 13 -> 34;
                    case 14 -> 30;
                    case 15 -> 48;
                    case 16 -> 195;
                    case 17 -> 229;
                    case 18 -> 247;
                    case 19 -> 29;
                    case 20 -> 92;
                    case 21 -> 194;
                    case 22 -> 205;
                    case 23 -> 72;
                    case 24 -> 222;
                    case 25 -> 94;
                    case 26 -> 142;
                    case 27 -> 23;
                    case 28 -> 133;
                    case 29 -> 238;
                    case 30 -> 245;
                    case 31 -> 40;
                    case 32 -> 1;
                    case 33 -> 62;
                    case 34 -> 66;
                    case 35 -> 186;
                    case 36 -> 60;
                    case 37 -> 86;
                    case 38 -> 81;
                    case 39 -> 96;
                    case 40 -> 213;
                    case 41 -> 91;
                    case 42 -> 181;
                    case 43 -> 252;
                    case 44 -> 77;
                    case 45 -> 114;
                    case 46 -> 44;
                    case 47 -> 80;
                    case 48 -> 210;
                    case 49 -> 45;
                    case 50 -> 56;
                    case 51 -> 37;
                    case 52 -> 168;
                    case 53 -> 173;
                    case 54 -> 254;
                    case 55 -> 230;
                    case 56 -> 36;
                    case 57 -> 74;
                    case 58 -> 22;
                    case 59 -> 235;
                    case 60 -> 69;
                    case 61 -> 232;
                    case 62 -> 17;
                    case 63 -> 99;
                    case 64 -> 106;
                    case 65 -> 84;
                    case 66 -> 154;
                    case 67 -> 141;
                    case 68 -> 20;
                    case 69 -> 110;
                    case 70 -> 97;
                    case 71 -> 203;
                    case 72 -> 35;
                    case 73 -> 250;
                    case 74 -> 208;
                    case 75 -> 158;
                    case 76 -> 156;
                    case 77 -> 148;
                    case 78 -> 15;
                    case 79 -> 187;
                    case 80 -> 234;
                    case 81 -> 149;
                    case 82 -> 7;
                    case 83 -> 3;
                    case 84 -> 11;
                    case 85 -> 175;
                    case 86 -> 123;
                    case 87 -> 71;
                    case 88 -> 200;
                    case 89 -> 43;
                    case 90 -> 223;
                    case 91 -> 226;
                    case 92 -> 211;
                    case 93 -> 182;
                    case 94 -> 201;
                    case 95 -> 189;
                    case 96 -> 76;
                    case 97 -> 242;
                    case 98 -> 108;
                    case 99 -> 196;
                    case 100 -> 147;
                    case 101 -> 179;
                    case 102 -> 246;
                    case 103 -> 53;
                    case 104 -> 136;
                    case 105 -> 184;
                    case 106 -> 115;
                    case 107 -> 119;
                    case 108 -> 78;
                    case 109 -> 120;
                    case 110 -> 241;
                    case 111 -> 0;
                    case 112 -> 25;
                    case 113 -> 126;
                    case 114 -> 240;
                    case 115 -> 4;
                    case 116 -> 188;
                    case 117 -> 174;
                    case 118 -> 47;
                    case 119 -> 118;
                    case 120 -> 130;
                    case 121 -> 135;
                    case 122 -> 51;
                    case 123 -> 209;
                    case 124 -> 155;
                    case 125 -> 167;
                    case 126 -> 117;
                    case 127 -> 170;
                    case 128 -> 58;
                    case 129 -> 178;
                    case 130 -> 221;
                    case 131 -> 164;
                    case 132 -> 225;
                    case 133 -> 166;
                    case 134 -> 64;
                    case 135 -> 39;
                    case 136 -> 5;
                    case 137 -> 31;
                    case 138 -> 63;
                    case 139 -> 6;
                    case 140 -> 176;
                    case 141 -> 150;
                    case 142 -> 140;
                    case 143 -> 206;
                    case 144 -> 104;
                    case 145 -> 18;
                    case 146 -> 127;
                    case 147 -> 239;
                    case 148 -> 183;
                    case 149 -> 131;
                    case 150 -> 65;
                    case 151 -> 83;
                    case 152 -> 185;
                    case 153 -> 253;
                    case 154 -> 146;
                    case 155 -> 157;
                    case 156 -> 21;
                    case 157 -> 52;
                    case 158 -> 59;
                    case 159 -> 14;
                    case 160 -> 215;
                    case 161 -> 73;
                    case 162 -> 9;
                    case 163 -> 121;
                    case 164 -> 138;
                    case 165 -> 8;
                    case 166 -> 124;
                    case 167 -> 134;
                    case 168 -> 125;
                    case 169 -> 88;
                    case 170 -> 129;
                    case 171 -> 197;
                    case 172 -> 128;
                    case 173 -> 237;
                    case 174 -> 95;
                    case 175 -> 98;
                    case 176 -> 102;
                    case 177 -> 152;
                    case 178 -> 199;
                    case 179 -> 212;
                    case 180 -> 145;
                    case 181 -> 228;
                    case 182 -> 192;
                    case 183 -> 19;
                    case 184 -> 236;
                    case 185 -> 67;
                    case 186 -> 139;
                    case 187 -> 227;
                    case 188 -> 160;
                    case 189 -> 162;
                    case 190 -> 27;
                    case 191 -> 13;
                    case 192 -> 32;
                    case 193 -> 151;
                    case 194 -> 111;
                    case 195 -> 61;
                    case 196 -> 42;
                    case 197 -> 224;
                    case 198 -> 251;
                    case 199 -> 165;
                    case 200 -> 255;
                    case 201 -> 163;
                    case 202 -> 161;
                    case 203 -> 249;
                    case 204 -> 243;
                    case 205 -> 12;
                    case 206 -> 79;
                    case 207 -> 68;
                    case 208 -> 193;
                    case 209 -> 10;
                    case 210 -> 216;
                    case 211 -> 82;
                    case 212 -> 28;
                    case 213 -> 219;
                    case 214 -> 137;
                    case 215 -> 177;
                    case 216 -> 75;
                    case 217 -> 89;
                    case 218 -> 107;
                    case 219 -> 143;
                    case 220 -> 109;
                    case 221 -> 202;
                    case 222 -> 93;
                    case 223 -> 217;
                    case 224 -> 2;
                    case 225 -> 198;
                    case 226 -> 112;
                    case 227 -> 57;
                    case 228 -> 169;
                    case 229 -> 103;
                    case 230 -> 190;
                    case 231 -> 105;
                    case 232 -> 132;
                    case 233 -> 122;
                    case 234 -> 49;
                    case 235 -> 244;
                    case 236 -> 46;
                    case 237 -> 41;
                    case 238 -> 220;
                    case 239 -> 33;
                    case 240 -> 85;
                    case 241 -> 16;
                    case 242 -> 144;
                    case 243 -> 24;
                    case 244 -> 218;
                    case 245 -> 159;
                    case 246 -> 191;
                    case 247 -> 26;
                    case 248 -> 233;
                    case 249 -> 248;
                    case 250 -> 180;
                    case 251 -> 172;
                    case 252 -> 231;
                    case 253 -> 214;
                    case 254 -> 153;
                    default -> 204;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 79891204486098L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "sd\u0007r|\u00031*\ttn\u0014x1A,6(";
                    var5_4 = "sd\u0007r|\u00031*\ttn\u0014x1A,6(".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 64;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 88;
                                    break;
                                }
                                case 1: {
                                    v11 = 65;
                                    break;
                                }
                                case 2: {
                                    v11 = 53;
                                    break;
                                }
                                case 3: {
                                    v11 = 92;
                                    break;
                                }
                                case 4: {
                                    v11 = 89;
                                    break;
                                }
                                case 5: {
                                    v11 = 47;
                                    break;
                                }
                                default: {
                                    v11 = 66;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 7040694486452L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "a;.tt\u0002\f\u0004g%\"n\nk:)nx\u0000\u0014A; \tk:)nx\u0000\u0014M1\rl<4cr\r\u000eM63is\u0004";
                    var5_4 = "a;.tt\u0002\f\u0004g%\"n\nk:)nx\u0000\u0014A; \tk:)nx\u0000\u0014M1\rl<4cr\r\u000eM63is\u0004".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "8j{ '^T\u00068j{ +T";
                        var5_4 = "8j{ '^T\u00068j{ +T".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 57;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 66;
                                break;
                            }
                            case 1: {
                                v15 = 63;
                                break;
                            }
                            case 2: {
                                v15 = 45;
                                break;
                            }
                            case 3: {
                                v15 = 106;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 9;
                                break;
                            }
                            default: {
                                v15 = 10;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 49216930403254L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-900188760 - -((char)-14458), 900188760 - 26444, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 14301332378835L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a2\u00ba\u00f0JW\u00037\u0088\u00f6\u0005h\u00d1\u008f\u00e3[\r\u00c1!\u008c\u00b7\u00ce\u009a\u00f7\u00f9.\u0019\u0018\u00bd\u00e8\u0010-\u00fb\u00d6\u0007\u00ba\u0019R\u00b4S4TU\u0087{\u00de \u0005\u000b-\u00e3|\u00d63x\u00ce\u009cw&S\u00f1\u00e9Zb\u00fe\u00b6\u0014V\u0080\u009a\u00ca4\u00f0\u00d1\u00e8E\u00b3\u00a7lP\u0003C\u00dc\u0088~\u00a5\u00a4\u001b\u00ea\u00c2}W\u00d0\\R\u0087\u00ed\u00e2t\u001e*F\b~(";
                    var4_3 = "\u00a2\u00ba\u00f0JW\u00037\u0088\u00f6\u0005h\u00d1\u008f\u00e3[\r\u00c1!\u008c\u00b7\u00ce\u009a\u00f7\u00f9.\u0019\u0018\u00bd\u00e8\u0010-\u00fb\u00d6\u0007\u00ba\u0019R\u00b4S4TU\u0087{\u00de \u0005\u000b-\u00e3|\u00d63x\u00ce\u009cw&S\u00f1\u00e9Zb\u00fe\u00b6\u0014V\u0080\u009a\u00ca4\u00f0\u00d1\u00e8E\u00b3\u00a7lP\u0003C\u00dc\u0088~\u00a5\u00a4\u001b\u00ea\u00c2}W\u00d0\\R\u0087\u00ed\u00e2t\u001e*F\b~(".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 75;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0000W\u0080a\u0083&\u0086\u00a0:E\u008a\u0088\u00af3(\u00daL\u00ee\u00a9\u00aat\u00ecL\u0005\u0083\u00c3\u00b2\u0019\u00cf\u00d3U4o\u00aa\u00a8\u00f0Gs\u0000\u0019^\u00e9we\u0092\u0019\b\u00da)\u00d3\u0097\u0086\u00bc1\u00b5\u0090\u0095\u009f\u00b0h\u008a\">\u00d8\u0089W@\u00d8\u00e8U\u00bc\u00f1\u0014\u00f8\u00b0\u00ffXBB\u0006\u00cf\u00e3\"\u0014\u00a3\u0018#\u001bq\u00a0T\u00bcO";
                        var4_3 = "\u0000W\u0080a\u0083&\u0086\u00a0:E\u008a\u0088\u00af3(\u00daL\u00ee\u00a9\u00aat\u00ecL\u0005\u0083\u00c3\u00b2\u0019\u00cf\u00d3U4o\u00aa\u00a8\u00f0Gs\u0000\u0019^\u00e9we\u0092\u0019\b\u00da)\u00d3\u0097\u0086\u00bc1\u00b5\u0090\u0095\u009f\u00b0h\u008a\">\u00d8\u0089W@\u00d8\u00e8U\u00bc\u00f1\u0014\u00f8\u00b0\u00ffXBB\u0006\u00cf\u00e3\"\u0014\u00a3\u0018#\u001bq\u00a0T\u00bcO".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 55;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 13;
                                break;
                            }
                            case 1: {
                                v15 = 109;
                                break;
                            }
                            case 2: {
                                v15 = 15;
                                break;
                            }
                            case 3: {
                                v15 = 119;
                                break;
                            }
                            case 4: {
                                v15 = 55;
                                break;
                            }
                            case 5: {
                                v15 = 38;
                                break;
                            }
                            default: {
                                v15 = 22;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFAE98) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 220;
                    case 1 -> 52;
                    case 2 -> 28;
                    case 3 -> 172;
                    case 4 -> 67;
                    case 5 -> 199;
                    case 6 -> 113;
                    case 7 -> 125;
                    case 8 -> 43;
                    case 9 -> 51;
                    case 10 -> 54;
                    case 11 -> 150;
                    case 12 -> 175;
                    case 13 -> 129;
                    case 14 -> 132;
                    case 15 -> 251;
                    case 16 -> 37;
                    case 17 -> 152;
                    case 18 -> 1;
                    case 19 -> 196;
                    case 20 -> 117;
                    case 21 -> 40;
                    case 22 -> 92;
                    case 23 -> 101;
                    case 24 -> 42;
                    case 25 -> 119;
                    case 26 -> 213;
                    case 27 -> 167;
                    case 28 -> 176;
                    case 29 -> 7;
                    case 30 -> 34;
                    case 31 -> 58;
                    case 32 -> 249;
                    case 33 -> 120;
                    case 34 -> 73;
                    case 35 -> 6;
                    case 36 -> 109;
                    case 37 -> 240;
                    case 38 -> 142;
                    case 39 -> 111;
                    case 40 -> 159;
                    case 41 -> 198;
                    case 42 -> 222;
                    case 43 -> 178;
                    case 44 -> 254;
                    case 45 -> 223;
                    case 46 -> 149;
                    case 47 -> 60;
                    case 48 -> 25;
                    case 49 -> 182;
                    case 50 -> 164;
                    case 51 -> 27;
                    case 52 -> 124;
                    case 53 -> 235;
                    case 54 -> 64;
                    case 55 -> 224;
                    case 56 -> 70;
                    case 57 -> 76;
                    case 58 -> 212;
                    case 59 -> 82;
                    case 60 -> 65;
                    case 61 -> 205;
                    case 62 -> 108;
                    case 63 -> 231;
                    case 64 -> 243;
                    case 65 -> 180;
                    case 66 -> 18;
                    case 67 -> 227;
                    case 68 -> 59;
                    case 69 -> 31;
                    case 70 -> 89;
                    case 71 -> 114;
                    case 72 -> 36;
                    case 73 -> 21;
                    case 74 -> 66;
                    case 75 -> 105;
                    case 76 -> 23;
                    case 77 -> 131;
                    case 78 -> 141;
                    case 79 -> 148;
                    case 80 -> 242;
                    case 81 -> 32;
                    case 82 -> 46;
                    case 83 -> 163;
                    case 84 -> 116;
                    case 85 -> 225;
                    case 86 -> 63;
                    case 87 -> 44;
                    case 88 -> 90;
                    case 89 -> 93;
                    case 90 -> 95;
                    case 91 -> 24;
                    case 92 -> 232;
                    case 93 -> 2;
                    case 94 -> 171;
                    case 95 -> 201;
                    case 96 -> 139;
                    case 97 -> 135;
                    case 98 -> 61;
                    case 99 -> 79;
                    case 100 -> 77;
                    case 101 -> 252;
                    case 102 -> 98;
                    case 103 -> 41;
                    case 104 -> 88;
                    case 105 -> 234;
                    case 106 -> 123;
                    case 107 -> 255;
                    case 108 -> 134;
                    case 109 -> 166;
                    case 110 -> 19;
                    case 111 -> 204;
                    case 112 -> 217;
                    case 113 -> 185;
                    case 114 -> 173;
                    case 115 -> 214;
                    case 116 -> 209;
                    case 117 -> 144;
                    case 118 -> 13;
                    case 119 -> 161;
                    case 120 -> 57;
                    case 121 -> 69;
                    case 122 -> 179;
                    case 123 -> 78;
                    case 124 -> 30;
                    case 125 -> 183;
                    case 126 -> 236;
                    case 127 -> 3;
                    case 128 -> 87;
                    case 129 -> 29;
                    case 130 -> 128;
                    case 131 -> 174;
                    case 132 -> 56;
                    case 133 -> 195;
                    case 134 -> 245;
                    case 135 -> 115;
                    case 136 -> 138;
                    case 137 -> 16;
                    case 138 -> 237;
                    case 139 -> 181;
                    case 140 -> 189;
                    case 141 -> 157;
                    case 142 -> 170;
                    case 143 -> 14;
                    case 144 -> 228;
                    case 145 -> 72;
                    case 146 -> 191;
                    case 147 -> 160;
                    case 148 -> 55;
                    case 149 -> 250;
                    case 150 -> 177;
                    case 151 -> 103;
                    case 152 -> 50;
                    case 153 -> 81;
                    case 154 -> 155;
                    case 155 -> 96;
                    case 156 -> 211;
                    case 157 -> 127;
                    case 158 -> 49;
                    case 159 -> 218;
                    case 160 -> 85;
                    case 161 -> 230;
                    case 162 -> 226;
                    case 163 -> 241;
                    case 164 -> 15;
                    case 165 -> 136;
                    case 166 -> 10;
                    case 167 -> 100;
                    case 168 -> 186;
                    case 169 -> 193;
                    case 170 -> 99;
                    case 171 -> 71;
                    case 172 -> 200;
                    case 173 -> 9;
                    case 174 -> 216;
                    case 175 -> 20;
                    case 176 -> 239;
                    case 177 -> 238;
                    case 178 -> 84;
                    case 179 -> 168;
                    case 180 -> 143;
                    case 181 -> 8;
                    case 182 -> 38;
                    case 183 -> 184;
                    case 184 -> 122;
                    case 185 -> 219;
                    case 186 -> 4;
                    case 187 -> 91;
                    case 188 -> 203;
                    case 189 -> 80;
                    case 190 -> 133;
                    case 191 -> 244;
                    case 192 -> 97;
                    case 193 -> 169;
                    case 194 -> 118;
                    case 195 -> 104;
                    case 196 -> 112;
                    case 197 -> 162;
                    case 198 -> 147;
                    case 199 -> 0;
                    case 200 -> 165;
                    case 201 -> 35;
                    case 202 -> 110;
                    case 203 -> 221;
                    case 204 -> 45;
                    case 205 -> 188;
                    case 206 -> 154;
                    case 207 -> 140;
                    case 208 -> 5;
                    case 209 -> 206;
                    case 210 -> 86;
                    case 211 -> 48;
                    case 212 -> 151;
                    case 213 -> 62;
                    case 214 -> 246;
                    case 215 -> 190;
                    case 216 -> 187;
                    case 217 -> 156;
                    case 218 -> 130;
                    case 219 -> 248;
                    case 220 -> 74;
                    case 221 -> 207;
                    case 222 -> 210;
                    case 223 -> 17;
                    case 224 -> 11;
                    case 225 -> 233;
                    case 226 -> 229;
                    case 227 -> 121;
                    case 228 -> 53;
                    case 229 -> 47;
                    case 230 -> 192;
                    case 231 -> 107;
                    case 232 -> 22;
                    case 233 -> 83;
                    case 234 -> 153;
                    case 235 -> 208;
                    case 236 -> 75;
                    case 237 -> 12;
                    case 238 -> 215;
                    case 239 -> 145;
                    case 240 -> 68;
                    case 241 -> 202;
                    case 242 -> 106;
                    case 243 -> 158;
                    case 244 -> 146;
                    case 245 -> 94;
                    case 246 -> 197;
                    case 247 -> 126;
                    case 248 -> 194;
                    case 249 -> 102;
                    case 250 -> 33;
                    case 251 -> 137;
                    case 252 -> 253;
                    case 253 -> 247;
                    case 254 -> 26;
                    default -> 39;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 91109067964371L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-73268130 + -8764, -73268130 + -26753, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 16213446789480L;
                    String[] stringArray = SshAgentIpcService.Y();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-54787260 - -((char)-11948), 54787260 - (char)-17573, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 110049477123800L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "E\u0000J'\u00fe\u0003\u00b0\u00cf\u00a2";
                var4_3 = "E\u0000J'\u00fe\u0003\u00b0\u00cf\u00a2".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 106;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 125;
                                break;
                            }
                            case 1: {
                                v11 = 68;
                                break;
                            }
                            case 2: {
                                v11 = 66;
                                break;
                            }
                            case 3: {
                                v11 = 109;
                                break;
                            }
                            case 4: {
                                v11 = 101;
                                break;
                            }
                            case 5: {
                                v11 = 66;
                                break;
                            }
                            default: {
                                v11 = 52;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x5DF1) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 37;
                    case 1 -> 110;
                    case 2 -> 25;
                    case 3 -> 174;
                    case 4 -> 35;
                    case 5 -> 57;
                    case 6 -> 69;
                    case 7 -> 40;
                    case 8 -> 207;
                    case 9 -> 224;
                    case 10 -> 31;
                    case 11 -> 52;
                    case 12 -> 124;
                    case 13 -> 186;
                    case 14 -> 129;
                    case 15 -> 41;
                    case 16 -> 87;
                    case 17 -> 156;
                    case 18 -> 168;
                    case 19 -> 125;
                    case 20 -> 91;
                    case 21 -> 46;
                    case 22 -> 77;
                    case 23 -> 29;
                    case 24 -> 22;
                    case 25 -> 173;
                    case 26 -> 71;
                    case 27 -> 17;
                    case 28 -> 221;
                    case 29 -> 58;
                    case 30 -> 215;
                    case 31 -> 252;
                    case 32 -> 158;
                    case 33 -> 179;
                    case 34 -> 18;
                    case 35 -> 162;
                    case 36 -> 175;
                    case 37 -> 108;
                    case 38 -> 251;
                    case 39 -> 61;
                    case 40 -> 226;
                    case 41 -> 51;
                    case 42 -> 202;
                    case 43 -> 132;
                    case 44 -> 152;
                    case 45 -> 147;
                    case 46 -> 244;
                    case 47 -> 85;
                    case 48 -> 134;
                    case 49 -> 223;
                    case 50 -> 216;
                    case 51 -> 33;
                    case 52 -> 24;
                    case 53 -> 141;
                    case 54 -> 182;
                    case 55 -> 122;
                    case 56 -> 55;
                    case 57 -> 225;
                    case 58 -> 138;
                    case 59 -> 23;
                    case 60 -> 93;
                    case 61 -> 128;
                    case 62 -> 167;
                    case 63 -> 233;
                    case 64 -> 109;
                    case 65 -> 120;
                    case 66 -> 20;
                    case 67 -> 11;
                    case 68 -> 148;
                    case 69 -> 76;
                    case 70 -> 14;
                    case 71 -> 0;
                    case 72 -> 171;
                    case 73 -> 212;
                    case 74 -> 189;
                    case 75 -> 32;
                    case 76 -> 181;
                    case 77 -> 19;
                    case 78 -> 12;
                    case 79 -> 161;
                    case 80 -> 178;
                    case 81 -> 176;
                    case 82 -> 219;
                    case 83 -> 255;
                    case 84 -> 82;
                    case 85 -> 135;
                    case 86 -> 213;
                    case 87 -> 49;
                    case 88 -> 231;
                    case 89 -> 3;
                    case 90 -> 92;
                    case 91 -> 241;
                    case 92 -> 107;
                    case 93 -> 245;
                    case 94 -> 34;
                    case 95 -> 103;
                    case 96 -> 192;
                    case 97 -> 143;
                    case 98 -> 169;
                    case 99 -> 130;
                    case 100 -> 203;
                    case 101 -> 146;
                    case 102 -> 44;
                    case 103 -> 6;
                    case 104 -> 96;
                    case 105 -> 112;
                    case 106 -> 187;
                    case 107 -> 50;
                    case 108 -> 126;
                    case 109 -> 194;
                    case 110 -> 127;
                    case 111 -> 1;
                    case 112 -> 234;
                    case 113 -> 214;
                    case 114 -> 166;
                    case 115 -> 222;
                    case 116 -> 101;
                    case 117 -> 2;
                    case 118 -> 140;
                    case 119 -> 246;
                    case 120 -> 196;
                    case 121 -> 81;
                    case 122 -> 68;
                    case 123 -> 111;
                    case 124 -> 97;
                    case 125 -> 201;
                    case 126 -> 26;
                    case 127 -> 100;
                    case 128 -> 8;
                    case 129 -> 7;
                    case 130 -> 220;
                    case 131 -> 254;
                    case 132 -> 159;
                    case 133 -> 184;
                    case 134 -> 116;
                    case 135 -> 86;
                    case 136 -> 185;
                    case 137 -> 193;
                    case 138 -> 188;
                    case 139 -> 210;
                    case 140 -> 114;
                    case 141 -> 5;
                    case 142 -> 237;
                    case 143 -> 75;
                    case 144 -> 80;
                    case 145 -> 157;
                    case 146 -> 199;
                    case 147 -> 236;
                    case 148 -> 72;
                    case 149 -> 59;
                    case 150 -> 98;
                    case 151 -> 144;
                    case 152 -> 113;
                    case 153 -> 180;
                    case 154 -> 21;
                    case 155 -> 160;
                    case 156 -> 248;
                    case 157 -> 154;
                    case 158 -> 106;
                    case 159 -> 137;
                    case 160 -> 105;
                    case 161 -> 118;
                    case 162 -> 64;
                    case 163 -> 83;
                    case 164 -> 243;
                    case 165 -> 232;
                    case 166 -> 228;
                    case 167 -> 53;
                    case 168 -> 250;
                    case 169 -> 235;
                    case 170 -> 208;
                    case 171 -> 45;
                    case 172 -> 48;
                    case 173 -> 30;
                    case 174 -> 117;
                    case 175 -> 99;
                    case 176 -> 242;
                    case 177 -> 153;
                    case 178 -> 36;
                    case 179 -> 84;
                    case 180 -> 177;
                    case 181 -> 73;
                    case 182 -> 62;
                    case 183 -> 217;
                    case 184 -> 204;
                    case 185 -> 42;
                    case 186 -> 43;
                    case 187 -> 253;
                    case 188 -> 227;
                    case 189 -> 16;
                    case 190 -> 15;
                    case 191 -> 190;
                    case 192 -> 94;
                    case 193 -> 209;
                    case 194 -> 102;
                    case 195 -> 200;
                    case 196 -> 54;
                    case 197 -> 90;
                    case 198 -> 89;
                    case 199 -> 150;
                    case 200 -> 66;
                    case 201 -> 47;
                    case 202 -> 155;
                    case 203 -> 133;
                    case 204 -> 79;
                    case 205 -> 170;
                    case 206 -> 123;
                    case 207 -> 163;
                    case 208 -> 28;
                    case 209 -> 27;
                    case 210 -> 131;
                    case 211 -> 4;
                    case 212 -> 70;
                    case 213 -> 211;
                    case 214 -> 149;
                    case 215 -> 121;
                    case 216 -> 172;
                    case 217 -> 60;
                    case 218 -> 67;
                    case 219 -> 88;
                    case 220 -> 230;
                    case 221 -> 119;
                    case 222 -> 145;
                    case 223 -> 239;
                    case 224 -> 151;
                    case 225 -> 115;
                    case 226 -> 183;
                    case 227 -> 63;
                    case 228 -> 56;
                    case 229 -> 198;
                    case 230 -> 38;
                    case 231 -> 229;
                    case 232 -> 197;
                    case 233 -> 164;
                    case 234 -> 191;
                    case 235 -> 78;
                    case 236 -> 249;
                    case 237 -> 238;
                    case 238 -> 139;
                    case 239 -> 218;
                    case 240 -> 65;
                    case 241 -> 9;
                    case 242 -> 39;
                    case 243 -> 10;
                    case 244 -> 195;
                    case 245 -> 165;
                    case 246 -> 104;
                    case 247 -> 74;
                    case 248 -> 95;
                    case 249 -> 205;
                    case 250 -> 247;
                    case 251 -> 13;
                    case 252 -> 240;
                    case 253 -> 142;
                    case 254 -> 206;
                    default -> 136;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

