/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.CLibraryNative;
import com.pty4j.unix.FDSet;
import com.pty4j.unix.Pollfd;
import com.pty4j.unix.PollfdStructure;
import com.pty4j.unix.PollfdStructureByReference;
import com.pty4j.unix.fd_set;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J+\u0010\u0018\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0007J \u0010%\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/pty4j/unix/CLibrary;", "", "()V", "EAGAIN", "", "EINTR", "ENOTTY", "O_NOCTTY", "O_RDWR", "O_WRONLY", "POLLIN", "", "libc", "Lcom/pty4j/unix/CLibraryNative;", "close", "fd", "errno", "open", "path", "", "flags", "pipe", "fds", "", "poll", "", "Lcom/pty4j/unix/Pollfd;", "nfds", "timeout", "([Lcom/pty4j/unix/Pollfd;II)I", "read", "buf", "", "len", "select", "readfds", "Lcom/pty4j/unix/FDSet;", "write", "pty4j"})
public final class CLibrary {
    @NotNull
    public static final CLibrary INSTANCE = new CLibrary();
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final short POLLIN = 1;
    public static final int EINTR = 4;
    @JvmField
    public static final int EAGAIN = Platform.isLinux() || Platform.isSolaris() ? 11 : 35;
    @JvmField
    public static final int O_NOCTTY = Platform.isLinux() ? 256 : (Platform.isFreeBSD() ? 32768 : (Platform.isSolaris() ? 2048 : 131072));
    public static final int ENOTTY = 25;
    @NotNull
    private static final CLibraryNative libc;

    private CLibrary() {
    }

    @JvmStatic
    public static final int open(@NotNull String path, int flags) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return libc.open(path, flags);
    }

    @JvmStatic
    public static final int close(int fd) {
        return libc.close(fd);
    }

    @JvmStatic
    public static final int read(int fd, @NotNull byte[] buf, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        LibCAPI.ssize_t result = libc.read(fd, buf, new LibCAPI.size_t((long)len));
        return result.intValue();
    }

    @JvmStatic
    public static final int write(int fd, @NotNull byte[] buf, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        LibCAPI.ssize_t result = libc.write(fd, buf, new LibCAPI.size_t((long)len));
        return result.intValue();
    }

    @JvmStatic
    public static final int pipe(@NotNull int[] fds) {
        Intrinsics.checkNotNullParameter((Object)fds, (String)"fds");
        return libc.pipe(fds);
    }

    @JvmStatic
    public static final int errno() {
        return Native.getLastError();
    }

    @JvmStatic
    public static final int poll(@NotNull Pollfd[] fds, int nfds, int timeout) {
        Intrinsics.checkNotNullParameter((Object)fds, (String)"fds");
        if (nfds <= 0 || nfds > fds.length) {
            throw new IllegalArgumentException("nfds " + nfds + " must be <= fds.size " + fds.length);
        }
        PollfdStructureByReference pollfdsReference = new PollfdStructureByReference();
        Structure[] structureArray = pollfdsReference.toArray(nfds);
        Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.pty4j.unix.PollfdStructure>");
        PollfdStructure[] pollfdStructures = (PollfdStructure[])structureArray;
        for (int i = 0; i < nfds; ++i) {
            pollfdStructures[i].fd = fds[i].getFd();
            pollfdStructures[i].events = fds[i].getEvents();
        }
        int ret = libc.poll(pollfdsReference, nfds, timeout);
        for (int i = 0; i < nfds; ++i) {
            fds[i].setRevents(pollfdStructures[i].revents);
        }
        return ret;
    }

    @JvmStatic
    public static final int select(int nfds, @NotNull FDSet readfds) {
        Intrinsics.checkNotNullParameter((Object)readfds, (String)"readfds");
        return libc.select(nfds, (fd_set)readfds, null, null, null);
    }

    static {
        Library library = Native.load((String)Platform.C_LIBRARY_NAME, CLibraryNative.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        libc = (CLibraryNative)library;
    }
}

