/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.customElements.json.CustomElementsContribution;
import com.intellij.webSymbols.customElements.json.Deprecated;
import com.intellij.webSymbols.customElements.json.Reference;
import com.intellij.webSymbols.customElements.json.Type;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"deprecated", "description", "inheritedFrom", "name", "summary", "type"})
public class Event
implements CustomElementsContribution {
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the event is deprecated.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A markdown description.")
    private String description;
    @JsonProperty(value="inheritedFrom")
    @JsonPropertyDescription(value="A reference to an export of a module.\n\nAll references are required to be publically accessible, so the canonical\nrepresentation of a reference is the export it's available from.\n\n`package` should generally refer to an npm package name. If `package` is\nundefined then the reference is local to this package. If `module` is\nundefined the reference is local to the containing module.\n\nReferences to global symbols like `Array`, `HTMLElement`, or `Event` should\nuse a `package` name of `\"global:\"`.")
    private Reference inheritedFrom;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A markdown summary suitable for display in a listing.")
    private String summary;
    @JsonProperty(value="type")
    private Type type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="inheritedFrom")
    public Reference getInheritedFrom() {
        return this.inheritedFrom;
    }

    @JsonProperty(value="inheritedFrom")
    public void setInheritedFrom(Reference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

