/* Piper - the Swiss Army Knife of SOCKS/WinGate manipulation
 * Written by gcc@i.am (Chris Wilson) 16.1.99
 *
 * RCS ChangeLog:
 * $Log: piper.c,v $
 * Revision 1.14  2001/07/20 18:24:19  chris
 * Added bouncer support (finally!)
 * More generic multiplex code (re-used by bouncer)
 *
 * Revision 1.13  2001/07/14 15:09:25  chris
 * Removed Asylum limited distribution messages
 * Licensed under GPL
 *
 * Revision 1.12  1999/01/18 22:59:14  chris
 * Moved more nonessential function into util.c and modules.c
 *
 * Revision 1.11  1999/01/18 14:13:09  chris
 * Utility code moved into util.c
 * Portscans partially debugged
 * Changed host processing to use single-entry hostlists for one host
 * Added library routines for decoding port specs and reading /etc/services
 *
 * Revision 1.10  1999/01/18 01:25:45  chris
 * Cosmetic changes to reporting format in socks_test
 * Made error testing/reporting in socks_connect more modular
 * Better error messages (i.e. shorter :) from socks_connect
 * Initial support for portscanning
 *
 * Revision 1.9  1999/01/17 13:30:26  chris
 * Modified Test function to use host lists
 * Compiled with -Wall and fixed all warnings
 * Removed timeouts from socks_connect (breaking host lists)
 * Changed socks_connect error messages for neater test output
 * Improved host list functions
 * Added initial code to support forking
 *
 * Revision 1.8  1999/01/16 17:34:02  chris
 * Fixed lots of small bugs with the host list code
 * Small cosmetic changes
 *
 * Revision 1.7  1999/01/16 16:53:28  chris
 * Fixed various typos and small mistakes so it actually compiles ;)
 * Rearranged include file order (cosmetic)
 *
 * Revision 1.6  1999/01/16 16:47:00  chris
 * Utility functions for host lists added
 * Investigator modified to accept either single hosts or hostlists
 *
 * Revision 1.5  1999/01/16 16:21:52  chris
 * Added 'investigate host' function, tested it
 * Rearranged argument checking code in socks_test, much neater now
 * Better error messages
 * Fixed bug in hostname resolution return values
 *
 * Revision 1.4  1998/10/15 22:50:38  chris
 * Added automatic timing to Test command
 * Made socks_connect() far more useful (return values!)
 * Started work on interactive connect
 *
 * Revision 1.3  1998/10/15 16:42:11  chris
 * Added SOCKS Tester function, tested and debugged
 *
 * Revision 1.2  1998/10/14 20:36:29  chris
 * Fixed some formatting in usage().
 *
 * Revision 1.1  1998/10/14 20:30:46  chris
 * Initial revision
 *
 */

#include "piper.h"

char rcsid[] = "$Id: piper.c,v 1.14 2001/07/20 18:24:19 chris Exp chris $";
// pid_t* proclist;

int main(int argc, char** argv) {
  if (argc==1) {
    usage();
    return 2;
  }

  if (strcmp(argv[1], "-h") == 0 || strcmp(argv[1], "-?") == 0) {
    usage();
  } else if (strcmp(argv[1], "-v") == 0) {
    version();
  } else if (strcmp(argv[1], "-t") == 0) {
    socks_test(argc-2, argv+2);
  } else if (strcmp(argv[1], "-c") == 0) {
    conn(argc-2, argv+2);
  } else if (strcmp(argv[1], "-i") == 0) {
    socks_investigate(argc-2, argv+2);
  } else if (strcmp(argv[1], "-p") == 0) {
    socks_portscan(argc-2, argv+2);
  } else if (strcmp(argv[1], "-b") == 0) {
    socks_bouncer(argc-2, argv+2);
  } else {
    printf("Unrecognised command '%s'. Use '-h' or '-?' for usage info.\n",
	   argv[1]);
    return 2;
  }

  return 0;
}

// Print the usage information for Piper
void usage() {
  puts("Piper - the Swiss Army Knife of SOCKS servers - by GCC <gcc@i.am>");
  version();
  puts("\n"
       "Usage: piper -t [options] wingates testhost           (test)\n"
       "       piper -c [options] wingate  desthost           (telnet)\n"
       "       piper -b [options] wingate  desthost localport (bouncer)\n"
       "       piper -p [options] wingates desthost ports     (portscan)\n"
       "       piper -i [options] wingates hosts    port      (investigate)\n"
       "       piper -h (print this usage information)\n"
       "\n"
       "Parameters:\n"
       "  wingate       WinGate or other computer running SOCKS 5 server\n"
       "  testhost      any valid and open host:port for testing purposes\n"
       "  desthost      destination host for bounces, connects and portscans\n"
       "  localport     bouncer binds to this port (or vhost:port) eg. 31337\n"
       "  wingates      hostname of socks server, or @filename for a list\n"
       "  hosts         hostname of target host, or @filename for a list\n"
       "\n"
       "Options:\n"
       "  -v            verbose mode (multi-line output)\n"
       "  -l <logfile>  write session logs to logfile (bouncer mode only)"
       );
}

// Print the version of Piper
void version() {
  char* temp;
  temp = strtok(rcsid, " "); // first word in rcsid[]
  temp = strtok((char*) NULL, " "); // second word...
  temp = strtok((char*) NULL, " "); // third word.
  printf("piper version %s\n", temp);
}
