use scallop::ExecStatus;

use super::_new::new;
use super::doconfd;
use super::make_builtin;

const LONG_DOC: &str = "Install renamed config files into /etc/conf.d/.";

#[doc = stringify!(LONG_DOC)]
fn run(args: &[&str]) -> scallop::Result<ExecStatus> {
    new(args, doconfd)
}

const USAGE: &str = "newconfd path/to/config/file new_filename";
make_builtin!("newconfd", newconfd_builtin);

#[cfg(test)]
mod tests {
    use std::fs;
    use std::io::Write;

    use crate::shell::test::FileTree;
    use crate::shell::write_stdin;

    use super::super::{assert_invalid_args, cmd_scope_tests, newconfd};
    use super::*;

    cmd_scope_tests!(USAGE);

    #[test]
    fn invalid_args() {
        assert_invalid_args(newconfd, &[0, 1, 3]);
    }

    #[test]
    fn creation() {
        let file_tree = FileTree::new();

        fs::File::create("config").unwrap();
        newconfd(&["config", "pkgcraft"]).unwrap();
        file_tree.assert(
            r#"
            [[files]]
            path = "/etc/conf.d/pkgcraft"
            mode = 0o100644
        "#,
        );

        // re-run using data from stdin
        write_stdin!("pkgcraft");
        newconfd(&["-", "pkgcraft"]).unwrap();
        file_tree.assert(
            r#"
            [[files]]
            path = "/etc/conf.d/pkgcraft"
            data = "pkgcraft"
            mode = 0o100644
        "#,
        );
    }
}
