/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.domain.arg;

import java.util.Collection;
import java.util.stream.Collectors;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.RebuildOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.domain.arg.ArgAbstractDomain;
import proguard.analysis.cpa.domain.arg.ArgAbstractState;
import proguard.analysis.cpa.domain.arg.ArgAbstractStateFactory;
import proguard.analysis.cpa.domain.arg.ArgCpa;
import proguard.analysis.cpa.domain.arg.ArgExpandOperator;
import proguard.analysis.cpa.domain.arg.ArgMergeOperator;
import proguard.analysis.cpa.domain.arg.ArgPrecisionAdjustment;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentTransferRelation;
import proguard.analysis.cpa.domain.arg.ArgRebuildOperator;
import proguard.analysis.cpa.domain.arg.ArgReduceOperator;
import proguard.analysis.cpa.domain.arg.ArgStopOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.classfile.Signature;

public class ArgBamCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends AbstractState, CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, SignatureT extends Signature>
extends BamCpaRun<ArgCpa, ArgAbstractState, CfaNodeT, CfaEdgeT, SignatureT> {
    protected final BamCpaRun<CpaT, AbstractStateT, CfaNodeT, CfaEdgeT, SignatureT> wrappedBamCpaRun;
    protected final ArgAbstractStateFactory argAbstractStateFactory;

    public ArgBamCpaRun(BamCpaRun<CpaT, AbstractStateT, CfaNodeT, CfaEdgeT, SignatureT> wrappedBamCpaRun, ArgAbstractStateFactory argAbstractStateFactory) {
        super(wrappedBamCpaRun.getAbortOperator(), wrappedBamCpaRun.getMaxCallStackDepth());
        this.wrappedBamCpaRun = wrappedBamCpaRun;
        this.argAbstractStateFactory = argAbstractStateFactory;
    }

    @Override
    public ReduceOperator<CfaNodeT, CfaEdgeT, SignatureT> createReduceOperator() {
        return new ArgReduceOperator<CfaNodeT, CfaEdgeT, SignatureT>(this.wrappedBamCpaRun.createReduceOperator(), this.argAbstractStateFactory);
    }

    @Override
    public ExpandOperator<CfaNodeT, CfaEdgeT, SignatureT> createExpandOperator() {
        return new ArgExpandOperator<CfaNodeT, CfaEdgeT, SignatureT>(this.wrappedBamCpaRun.createExpandOperator(), this.argAbstractStateFactory);
    }

    @Override
    public RebuildOperator createRebuildOperator() {
        return new ArgRebuildOperator(this.wrappedBamCpaRun.createRebuildOperator(), this.argAbstractStateFactory);
    }

    @Override
    public Cfa<CfaNodeT, CfaEdgeT, SignatureT> getCfa() {
        return this.wrappedBamCpaRun.getCfa();
    }

    @Override
    public SignatureT getMainSignature() {
        return this.wrappedBamCpaRun.getMainSignature();
    }

    @Override
    public ArgCpa createIntraproceduralCPA() {
        CpaT wrappedCpa = this.wrappedBamCpaRun.createIntraproceduralCPA();
        return new ArgCpa(new ArgAbstractDomain(wrappedCpa.getAbstractDomain(), this.argAbstractStateFactory), new ArgProgramLocationDependentTransferRelation(wrappedCpa.getTransferRelation(), this.argAbstractStateFactory), new ArgMergeOperator(wrappedCpa.getMergeOperator(), this.argAbstractStateFactory), new ArgStopOperator(wrappedCpa.getStopOperator()), new ArgPrecisionAdjustment(wrappedCpa.getPrecisionAdjustment(), this.argAbstractStateFactory));
    }

    @Override
    public Collection<ArgAbstractState> getInitialStates() {
        return this.wrappedBamCpaRun.getInitialStates().stream().map(this.argAbstractStateFactory::createArgAbstractState).collect(Collectors.toList());
    }

    @Override
    protected ReachedSet createReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }
}

