/*
 * Decompiled with CFR 0.152.
 */
package driftwood.star;

import driftwood.util.SoftLog;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class StarTokenizer {
    static final String TYPE_NONE = "nil-type";
    static final String TYPE_DATA_NAME = "data-name";
    static final String TYPE_DATA_VALUE = "data-value";
    static final String TYPE_GLOBAL_START = "global-start";
    static final String TYPE_DATA_START = "data-start";
    static final String TYPE_SAVE_START = "save-start";
    static final String TYPE_SAVE_END = "save-end";
    static final String TYPE_LOOP_START = "loop-start";
    static final String TYPE_STOP = "stop";
    static final int NIL_CHARACTER = -1;
    LineNumberReader in;
    char[] buffer = new char[256];
    int bufferIndex = 0;
    int firstChar;
    long charsRead;
    String stringValue;
    String type;
    boolean isBOL;
    boolean isEOF;

    public StarTokenizer(LineNumberReader lineNumberReader) throws IOException {
        this.in = lineNumberReader;
        this.charsRead = 0L;
        this.isEOF = false;
        this.firstChar = 10;
        this.advance();
    }

    void bufferAppend(char c) {
        if (this.bufferIndex >= this.buffer.length) {
            char[] cArray = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
            this.buffer = cArray;
        }
        this.buffer[this.bufferIndex++] = c;
    }

    String bufferToString() {
        return new String(this.buffer, 0, this.bufferIndex);
    }

    void bufferClear() {
        this.bufferIndex = 0;
    }

    int in_read() throws IOException {
        ++this.charsRead;
        return this.in.read();
    }

    public long getCharsRead() {
        return this.charsRead;
    }

    void error(String string) {
        SoftLog.err.println("[line " + (this.in.getLineNumber() + 1) + "] " + string);
    }

    public void advance() throws IOException {
        this.stringValue = null;
        this.type = TYPE_NONE;
        this.isBOL = false;
        this.bufferClear();
        int n = this.firstChar > 0 ? this.firstChar : this.in_read();
        this.firstChar = -1;
        while (n == 32 || n == 10 || n == 9 || n == 12) {
            boolean bl = this.isBOL = n == 10;
            n = this.in_read();
            if (n != 35) continue;
            while (n != 10 && n != -1) {
                n = this.in_read();
            }
        }
        if (n == -1) {
            this.isEOF = true;
            return;
        }
        if (n == 39 || n == 34) {
            this.readQuoted((char)n);
            this.type = TYPE_DATA_VALUE;
        } else if (this.isBOL && n == 59) {
            this.readLongQuoted((char)n);
            this.type = TYPE_DATA_VALUE;
        } else {
            this.bufferAppend((char)n);
            this.readUnquoted();
            if (this.stringValue.startsWith("_")) {
                this.type = TYPE_DATA_NAME;
            } else if (this.stringValue.equals("loop_")) {
                this.type = TYPE_LOOP_START;
            } else if (this.stringValue.startsWith("save_")) {
                if (this.stringValue.length() == 5) {
                    this.type = TYPE_SAVE_END;
                } else {
                    this.stringValue = this.stringValue.substring(5);
                    this.type = TYPE_SAVE_START;
                }
            } else if (this.stringValue.startsWith("data_")) {
                this.stringValue = this.stringValue.substring(5);
                this.type = TYPE_DATA_START;
            } else {
                this.type = this.stringValue.equals("global_") ? TYPE_GLOBAL_START : (this.stringValue.equals("stop_") ? TYPE_STOP : TYPE_DATA_VALUE);
            }
        }
        this.bufferClear();
    }

    void readQuoted(char c) throws IOException {
        int n = 1;
        while (n > 0) {
            int n2 = this.firstChar > 0 ? this.firstChar : this.in_read();
            this.firstChar = -1;
            if (n2 == -1) {
                n = 0;
                this.error("Quoted token terminated by EOF; type = " + c + "" + c);
                continue;
            }
            if (n2 == 10) {
                n = 0;
                this.error("Quoted token terminated by newline; type = " + c + "" + c);
                continue;
            }
            if (n2 == c) {
                int n3;
                this.firstChar = n3 = this.in_read();
                if (n3 == -1 || n3 == 32 || n3 == 10 || n3 == 9 || n3 == 12) {
                    --n;
                    continue;
                }
                this.bufferAppend((char)n2);
                continue;
            }
            this.bufferAppend((char)n2);
        }
        this.stringValue = this.bufferToString();
    }

    void readLongQuoted(char c) throws IOException {
        int n = 1;
        boolean bl = false;
        while (n > 0) {
            int n2 = this.in_read();
            if (n2 == -1) {
                n = 0;
                this.error("Quoted token terminated by EOF; type = " + c + "" + c);
                continue;
            }
            if (n2 == 10) {
                bl = true;
                continue;
            }
            if (bl) {
                if (n2 == c) {
                    --n;
                } else {
                    this.bufferAppend('\n');
                    this.bufferAppend((char)n2);
                }
                bl = false;
                continue;
            }
            this.bufferAppend((char)n2);
        }
        this.stringValue = this.bufferToString();
    }

    void readUnquoted() throws IOException {
        int n;
        while (true) {
            if ((n = this.in_read()) == -1 || n == 32 || n == 10 || n == 9 || n == 12) break;
            this.bufferAppend((char)n);
        }
        this.firstChar = n;
        this.stringValue = this.bufferToString();
    }

    public boolean isBOL() {
        return this.isBOL;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    public boolean isName() {
        return this.type == TYPE_DATA_NAME;
    }

    public boolean isValue() {
        return this.type == TYPE_DATA_VALUE;
    }

    public boolean isGlobal() {
        return this.type == TYPE_GLOBAL_START;
    }

    public boolean isData() {
        return this.type == TYPE_DATA_START;
    }

    public boolean isSaveStart() {
        return this.type == TYPE_SAVE_START;
    }

    public boolean isSaveEnd() {
        return this.type == TYPE_SAVE_END;
    }

    public boolean isLoopStart() {
        return this.type == TYPE_LOOP_START;
    }

    public boolean isLoopEnd() {
        return this.type == TYPE_STOP;
    }

    public String getType() {
        return this.type;
    }

    public String getString() {
        return this.stringValue;
    }

    public void Main() throws IOException {
        long l = System.currentTimeMillis();
        while (!this.isEOF()) {
            String string = this.getString();
            if (this.isBOL()) {
                System.out.println("[BOL:" + StarTokenizer.justifyLeft(this.getType(), 12) + "] " + string);
            } else {
                System.out.println("[    " + StarTokenizer.justifyLeft(this.getType(), 12) + "] " + string);
            }
            this.advance();
        }
        l = System.currentTimeMillis() - l;
        System.out.println("END OF FILE (" + l + " ms)");
        System.out.println();
        System.out.println();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            System.err.println("*** Takes a STAR file on stdin and writes tokens to stdout.");
        }
        try {
            new StarTokenizer(new LineNumberReader(new InputStreamReader(System.in))).Main();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public static String justifyLeft(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.ensureCapacity(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

