/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import king.core.KList;
import king.core.KPoint;
import king.core.KView;
import king.core.Transformable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Engine {
    public final int TOP_LAYER;
    public Transform xform3D = null;
    public Transform xform2D = null;
    public double zoom3D = 1.0;
    public double zoom2D = 1.0;
    public double clipBack = 0.0;
    public double clipFront = 1.0;
    public double clipDepth = 1.0;
    public double perspDist = 2000.0;
    public boolean useObjPicking = false;
    public boolean bigMarkers = false;
    public boolean bigLabels = false;
    public boolean cueIntensity = true;
    public boolean monochrome = false;
    public int widthCue = 0;
    public int colorCue = 0;
    public int activeAspect = 0;
    public int markerSize = 1;
    public Font labelFont = null;
    public int backgroundMode = -1;
    public Triple lightingVector = new Triple(-1.0, 1.0, 3.0).unit();
    public Rectangle pickingRect = new Rectangle();
    public boolean usePerspective = false;
    public boolean cueThickness = false;
    public boolean thinLines = false;
    public boolean whiteBackground = false;
    public boolean colorByList = false;
    public Triple work1 = new Triple();
    public Triple work2 = new Triple();
    public Dimension dim1 = new Dimension();
    ArrayList<KPoint>[] zbuffer;
    HashMap<KPoint, Double> ballmap;
    ArrayList<KList>[] parents;
    KList actingParent = null;
    protected double viewClipBack = -1.0;
    protected double viewClipFront = 1.0;
    protected double viewClipScaling = 1.0;
    Map<Object, Double> frontClipMap = new HashMap<Object, Double>();
    Map<Object, Double> backClipMap = new HashMap<Object, Double>();
    float pickingRadius = 5.0f;
    boolean warnedPickingRegion = false;

    public Engine() {
        this.TOP_LAYER = 1000;
        this.flushZBuffer();
    }

    void transform(Transformable transformable, KView kView, Rectangle rectangle) {
        for (int i = 0; i <= this.TOP_LAYER; ++i) {
            this.zbuffer[i].clear();
            this.parents[i].clear();
        }
        this.ballmap.clear();
        this.xform3D = this.create3DTransform(kView, rectangle);
        this.xform2D = this.create2DTransform(rectangle);
        this.chooseClipMode(null);
        this.pickingRect.setBounds(rectangle);
        transformable.doTransform(this, this.xform3D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transform create3DTransform(KView kView, Rectangle rectangle) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = rectangle.getWidth();
        double d14 = rectangle.getHeight();
        double d15 = Math.min(d13, d14);
        double d16 = rectangle.getX() + d13 / 2.0;
        double d17 = rectangle.getY() + d14 / 2.0;
        this.viewClipScaling = d15 / 2.0;
        Object object = kView;
        synchronized (object) {
            kView.compile();
            this.zoom3D = d15 / (double)kView.getSpan();
            d12 = kView.cx;
            d11 = kView.cy;
            d10 = kView.cz;
            d9 = kView.R11;
            d8 = kView.R12;
            d7 = kView.R13;
            d6 = kView.R21;
            d5 = kView.R22;
            d4 = kView.R23;
            d3 = kView.R31;
            d2 = kView.R32;
            d = kView.R33;
            this.viewClipFront = kView.getClip();
            this.viewClipBack = -this.viewClipFront;
        }
        object = new Transform();
        Transform transform = new Transform();
        transform.likeTranslation(-d12, -d11, -d10);
        ((Transform)object).append(transform);
        transform.likeMatrix(d9, d8, d7, d6, d5, d4, d3, d2, d);
        ((Transform)object).append(transform);
        transform.likeScale(this.zoom3D);
        ((Transform)object).append(transform);
        if (this.usePerspective) {
            this.perspDist = 5.0 * d15;
            transform.likePerspective(this.perspDist);
            ((Transform)object).append(transform);
        }
        transform.likeScale(1.0, -1.0, 1.0);
        ((Transform)object).append(transform);
        transform.likeTranslation(d16, d17, 0.0);
        ((Transform)object).append(transform);
        return object;
    }

    Transform create2DTransform(Rectangle rectangle) {
        double d = rectangle.getWidth();
        double d2 = rectangle.getHeight();
        double d3 = Math.min(d, d2);
        double d4 = rectangle.getX() + d / 2.0;
        double d5 = rectangle.getY() + d2 / 2.0;
        this.zoom2D = d3 / 400.0;
        Transform transform = new Transform();
        Transform transform2 = new Transform();
        transform2.likeScale(this.zoom2D);
        transform.append(transform2);
        transform2.likeScale(1.0, -1.0, 1.0);
        transform.append(transform2);
        transform2.likeTranslation(d4, d5, 0.0);
        transform.append(transform2);
        return transform;
    }

    public void setActingParent(KList kList) {
        this.actingParent = kList;
    }

    public void putClipMode(Object object, double d, double d2) {
        if (object == null) {
            return;
        }
        this.frontClipMap.put(object, new Double(d));
        this.backClipMap.put(object, new Double(d2));
    }

    public void chooseClipMode(Object object) {
        this.clipFront = this.viewClipFront;
        this.clipBack = this.viewClipBack;
        if (object != null) {
            Double d = this.frontClipMap.get(object);
            if (d != null) {
                this.clipFront = d;
            }
            if ((d = this.backClipMap.get(object)) != null) {
                this.clipBack = d;
            }
        }
        this.clipFront *= this.viewClipScaling;
        this.clipBack *= this.viewClipScaling;
        if (this.usePerspective) {
            this.clipFront = this.perspDist * this.clipFront / (this.perspDist - this.clipFront);
            this.clipBack = this.perspDist * this.clipBack / (this.perspDist - this.clipBack);
        }
        this.clipDepth = this.clipFront - this.clipBack;
    }

    public void addPaintable(KPoint kPoint, double d) {
        this.addPaintableToLayer(kPoint, (int)((double)this.TOP_LAYER * (d - this.clipBack) / this.clipDepth));
    }

    public void addPaintableToLayer(KPoint kPoint, int n) {
        if (n < 0 || n > this.TOP_LAYER || kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList != null && kList.getScreen()) {
            n = 0;
        }
        this.zbuffer[n].add(kPoint);
        this.parents[n].add(this.actingParent);
    }

    public void flushZBuffer() {
        int n;
        this.zbuffer = null;
        this.zbuffer = new ArrayList[this.TOP_LAYER + 1];
        for (n = 0; n <= this.TOP_LAYER; ++n) {
            this.zbuffer[n] = new ArrayList(10);
        }
        this.parents = null;
        this.parents = new ArrayList[this.TOP_LAYER + 1];
        for (n = 0; n <= this.TOP_LAYER; ++n) {
            this.parents[n] = new ArrayList(10);
        }
        this.ballmap = null;
        this.ballmap = new HashMap(1000);
    }

    public void addShortener(KPoint kPoint, double d) {
        Double d2 = this.ballmap.get(kPoint);
        if (d2 == null || d2 < d) {
            this.ballmap.put(kPoint, new Double(d));
        }
    }

    public double getShortening(KPoint kPoint) {
        Double d = this.ballmap.get(kPoint);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public KPoint pickPoint(int n, int n2, boolean bl) {
        if (!this.pickingRect.contains(n, n2)) {
            if (!this.warnedPickingRegion) {
                try {
                    JCheckBox jCheckBox = new JCheckBox("Don't warn me again", false);
                    JOptionPane.showMessageDialog(null, new Object[]{"When using stereo, only the right-hand half\nof the screen is active for picking.", jCheckBox}, "Out-of-bounds pick", 2);
                    this.warnedPickingRegion = jCheckBox.isSelected();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
            return null;
        }
        KPoint kPoint = null;
        for (int i = this.TOP_LAYER; i >= 0 && kPoint == null; --i) {
            ArrayList<KPoint> arrayList = this.zbuffer[i];
            int n3 = arrayList.size();
            for (int j = 0; j < n3 && kPoint == null; ++j) {
                KPoint kPoint2 = arrayList.get(j);
                KPoint kPoint3 = kPoint2.isPickedBy(n, n2, this.pickingRadius, this.useObjPicking);
                if (kPoint3 == null || kPoint3.isUnpickable() && !bl || kPoint3.getDrawingColor(this).isInvisible()) continue;
                kPoint = kPoint3;
            }
        }
        return kPoint;
    }

    public void setPickingRadius(double d) {
        if (d > 1.0) {
            this.pickingRadius = (float)d;
        }
    }

    public Collection pickAll3D(double d, double d2, double d3, boolean bl, double d4) {
        int n;
        ArrayList<KPoint> arrayList = new ArrayList<KPoint>();
        double d5 = d4 * d4;
        for (int i = n = this.TOP_LAYER; i >= 0; --i) {
            ArrayList<KPoint> arrayList2 = this.zbuffer[i];
            int n2 = arrayList2.size();
            for (int j = 0; j < n2; ++j) {
                double d6;
                double d7;
                KPoint kPoint = arrayList2.get(j);
                double d8 = kPoint.getX() - d;
                if (!(d8 * d8 + (d7 = kPoint.getY() - d2) * d7 + (d6 = kPoint.getZ() - d3) * d6 <= d5) || kPoint.isUnpickable() && !bl || kPoint.getDrawingColor(this).isInvisible()) continue;
                arrayList.add(kPoint);
            }
        }
        return arrayList;
    }

    public Collection<KPoint> pickAll2D(double d, double d2, boolean bl, double d3) {
        ArrayList<KPoint> arrayList = new ArrayList<KPoint>();
        for (int i = this.TOP_LAYER; i >= 0; --i) {
            ArrayList<KPoint> arrayList2 = this.zbuffer[i];
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                KPoint kPoint = arrayList2.get(j);
                KPoint kPoint2 = kPoint.isPickedBy((float)d, (float)d2, (float)d3, this.useObjPicking);
                if (kPoint2 == null || kPoint2.isUnpickable() && !bl || kPoint2.getDrawingColor(this).isInvisible()) continue;
                arrayList.add(kPoint2);
            }
        }
        return arrayList;
    }

    public int getNumberPainted() {
        int n = 0;
        for (int i = 0; i < this.zbuffer.length; ++i) {
            n += this.zbuffer[i].size();
        }
        return n;
    }
}

