/*
 * Decompiled with CFR 0.152.
 */
package hless;

public class Triple {
    double x;
    double y;
    double z;

    public Triple(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Triple(Triple triple) {
        this.x = triple.x;
        this.y = triple.y;
        this.z = triple.z;
    }

    public Triple() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Triple dup() {
        return new Triple(this.x, this.y, this.z);
    }

    public Triple like(Triple triple) {
        if (triple != null) {
            this.x = triple.x;
            this.y = triple.y;
            this.z = triple.z;
        }
        return this;
    }

    public Triple set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double dot(Triple triple) {
        return this.x * triple.x + this.y * triple.y + this.z * triple.z;
    }

    public Triple cross(Triple triple) {
        double d = this.y * triple.z - this.z * triple.y;
        double d2 = this.z * triple.x - this.x * triple.z;
        double d3 = this.x * triple.y - this.y * triple.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Triple unit() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public Triple scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Triple add(Triple triple) {
        this.x += triple.x;
        this.y += triple.y;
        this.z += triple.z;
        return this;
    }

    public Triple sub(Triple triple) {
        this.x -= triple.x;
        this.y -= triple.y;
        this.z -= triple.z;
        return this;
    }

    public Triple neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public double distance(Triple triple) {
        double d = this.x - triple.x;
        double d2 = this.y - triple.y;
        double d3 = this.z - triple.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double sqDistance(Triple triple) {
        double d = this.x - triple.x;
        double d2 = this.y - triple.y;
        double d3 = this.z - triple.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public static Triple midpoint(Triple triple, Triple triple2) {
        return new Triple((triple.x + triple2.x) / 2.0, (triple.y + triple2.y) / 2.0, (triple.z + triple2.z) / 2.0);
    }

    public double angle(Triple triple) {
        return Math.toDegrees(Math.acos(this.dot(triple) / (this.mag() * triple.mag())));
    }

    public static double angle(Triple triple, Triple triple2, Triple triple3) {
        Triple triple4 = triple.dup().sub(triple2);
        Triple triple5 = triple3.dup().sub(triple2);
        return Math.toDegrees(Math.acos(triple4.dot(triple5) / (triple4.mag() * triple5.mag())));
    }

    public static double dihedral(Triple triple, Triple triple2, Triple triple3, Triple triple4) {
        Triple triple5 = triple2.dup().sub(triple);
        Triple triple6 = triple3.dup().sub(triple2);
        Triple triple7 = triple4.dup().sub(triple3);
        Triple triple8 = triple5.dup().cross(triple6);
        Triple triple9 = triple6.dup().cross(triple7);
        double d = triple8.angle(triple9);
        if (triple8.angle(triple7) > 90.0) {
            d = -d;
        }
        return d;
    }

    public static Triple normalToPlane(Triple triple, Triple triple2, Triple triple3) {
        Triple triple4 = triple2.dup().sub(triple);
        Triple triple5 = triple3.dup().sub(triple2);
        triple4.cross(triple5);
        triple4.unit();
        return triple4;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)object;
        return this.x == triple.x && this.y == triple.y && this.z == triple.z;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = l ^ l2 ^ l3;
        return (int)(l4 ^ l4 >>> 32);
    }

    void echo(String string) {
        System.err.println(string);
    }

    void echon(String string) {
        System.err.print(string);
    }
}

