/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import chiropraxis.dangle.AtomSpec;
import chiropraxis.dangle.Measurement;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomKinSmith {
    final DecimalFormat df1 = new DecimalFormat("0.##");
    final DecimalFormat df2 = new DecimalFormat("#.###");
    ArrayList<String> distList;
    ArrayList<String> angList;
    Measurement[] meas;
    String label;
    CoordinateFile coords;
    boolean doDistDevsKin;
    boolean doAngleDevsKin;
    boolean doKinHeadings;
    double sigmaCutoff;
    File kinout;
    boolean ignoreDNA;
    boolean subgroupNotGroup;
    boolean doHets;

    public GeomKinSmith(ArrayList<Measurement> arrayList, String string, CoordinateFile coordinateFile, boolean bl, boolean bl2, boolean bl3, double d, boolean bl4, boolean bl5, boolean bl6) {
        this.meas = arrayList.toArray(new Measurement[arrayList.size()]);
        this.label = string;
        this.coords = coordinateFile;
        this.doDistDevsKin = bl;
        this.doAngleDevsKin = bl2;
        this.doKinHeadings = bl3;
        this.sigmaCutoff = d;
        this.ignoreDNA = bl4;
        this.subgroupNotGroup = bl5;
        this.doHets = bl6;
    }

    public void makeKin() {
        for (Model model : this.coords.getModels()) {
            ModelState modelState = model.getState();
            this.distList = new ArrayList();
            this.angList = new ArrayList();
            for (Residue residue : model.getResidues()) {
                int n;
                boolean bl = true;
                int n2 = 999;
                for (n = 0; n < this.meas.length; ++n) {
                    if (!this.ignoreDNA || !this.meas[n].getLabel().equals("c2o2") || n2 != 999) continue;
                    n2 = n;
                }
                for (n = 0; n < this.meas.length; ++n) {
                    if (!this.ignoreDNA || n2 == 999 || !Double.isNaN(this.meas[n2].measure(model, modelState, residue, this.doHets))) continue;
                    bl = false;
                }
                if (!bl) continue;
                for (n = 0; n < this.meas.length; ++n) {
                    Measurement.Group group = null;
                    try {
                        group = (Measurement.Group)this.meas[n];
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (group != null) {
                        boolean bl2 = false;
                        Measurement.Group group2 = (Measurement.Group)this.meas[n];
                        ArrayList arrayList = (ArrayList)group2.group;
                        for (Measurement measurement : arrayList) {
                            double d = measurement.measure(model, modelState, residue, this.doHets);
                            double d2 = measurement.getDeviation();
                            double d3 = measurement.mean;
                            if (Double.isNaN(d) || bl2) continue;
                            bl2 = true;
                            if (Double.isNaN(d2) || !(Math.abs(d2) >= this.sigmaCutoff)) continue;
                            if (measurement.getType().equals("distance")) {
                                this.distImpl(measurement, model, modelState, residue, d, d3, d2);
                            }
                            if (!measurement.getType().equals("angle")) continue;
                            this.angleImpl(measurement, model, modelState, residue, d, d3);
                        }
                        continue;
                    }
                    double d = this.meas[n].measure(model, modelState, residue, this.doHets);
                    double d4 = this.meas[n].getDeviation();
                    double d5 = this.meas[n].mean;
                    if (Double.isNaN(d) || Double.isNaN(d4) || !(Math.abs(d4) >= this.sigmaCutoff)) continue;
                    if (this.meas[n].getType().equals("distance")) {
                        this.distImpl(this.meas[n], model, modelState, residue, d, d5, d4);
                    }
                    if (!this.meas[n].getType().equals("angle")) continue;
                    this.angleImpl(this.meas[n], model, modelState, residue, d, d5);
                }
            }
            this.printModel(model);
        }
    }

    protected void distImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d, double d2, double d3) {
        Object object5;
        Measurement.Distance distance = (Measurement.Distance)measurement;
        AtomSpec atomSpec = (AtomSpec)distance.getA();
        AtomSpec atomSpec2 = (AtomSpec)distance.getB();
        String string = this.getName(atomSpec);
        String string2 = this.getName(atomSpec2);
        Residue residue2 = atomSpec.getRes(model, modelState, residue);
        Residue residue3 = atomSpec2.getRes(model, modelState, residue);
        if (atomSpec.getResOffset() == -1) {
            residue2 = residue.getPrev(model);
        }
        if (atomSpec.getResOffset() == 1) {
            residue2 = residue.getNext(model);
        }
        if (atomSpec2.getResOffset() == -1) {
            residue3 = residue.getPrev(model);
        }
        if (atomSpec2.getResOffset() == 1) {
            residue3 = residue.getNext(model);
        }
        Object object2 = null;
        Object object3 = null;
        for (Object object4 : residue2.getAtoms()) {
            if (!((Atom)object4).getName().trim().equals(string.trim()) && !((Atom)object4).getName().trim().equals(string.trim().replace('*', '\'')) && !((Atom)object4).getName().trim().equals(string.trim().replace('\'', '*'))) continue;
            object2 = object4;
        }
        for (Object object5 : residue3.getAtoms()) {
            if (!((Atom)object5).getName().trim().equals(string2.trim()) && !((Atom)object5).getName().trim().equals(string2.trim().replace('*', '\'')) && !((Atom)object5).getName().trim().equals(string2.trim().replace('\'', '*'))) continue;
            object3 = object5;
        }
        object5 = null;
        AtomState atomState = null;
        try {
            object5 = modelState.get((Atom)object2);
            atomState = modelState.get((Atom)object3);
        }
        catch (AtomException atomException) {
            System.out.println("Couldn't get AtomState");
        }
        String string3 = this.label.substring(0, 4) + " " + residue2.getName() + residue2.getSequenceInteger() + "-" + residue3.getName() + residue3.getSequenceInteger() + " " + ((Atom)object2).getName().trim() + "-" + ((Atom)object3).getName().trim();
        Triple triple = new Triple(((Triple)object5).getX(), ((Triple)object5).getY(), ((Triple)object5).getZ());
        Triple triple2 = new Triple(atomState.getX(), atomState.getY(), atomState.getZ());
        this.addSpring(string3, triple, triple2, d, d2, d3);
    }

    protected String getName(AtomSpec atomSpec) {
        String string = atomSpec.toString();
        String string2 = string.substring(string.length() - 4);
        int n = 99;
        int n2 = 99;
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (!string3.equals("_") && n == 99 && n2 == 99) {
                n = i;
                continue;
            }
            if (!string3.equals("_") || n == 99 || n2 != 99) continue;
            n2 = i;
        }
        if (n2 == 99) {
            return string2.substring(n);
        }
        return string2.substring(n, n2);
    }

    protected void angleImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d, double d2) {
        Measurement.Angle angle = (Measurement.Angle)measurement;
        AtomSpec atomSpec = angle.getA();
        AtomSpec atomSpec2 = angle.getB();
        AtomSpec atomSpec3 = angle.getC();
        AtomState atomState = atomSpec.get(model, modelState, residue);
        AtomState atomState2 = atomSpec2.get(model, modelState, residue);
        AtomState atomState3 = atomSpec3.get(model, modelState, residue);
        String string = this.label.substring(0, 4) + " " + residue.getName() + " " + residue.getSequenceInteger() + " " + atomState.getName().trim() + "-" + atomState2.getName().trim() + "-" + atomState3.getName().trim();
        this.addLineAndBlurredLine(string, atomState, atomState2, atomState3, d, d2);
    }

    public void addBall(String string, Triple triple, Triple triple2, double d, double d2) {
        double d3 = d - d2;
        String string2 = "red";
        if (d3 < 0.0) {
            string2 = "blue";
            d3 = -d3;
        }
        Triple triple3 = new Triple().likeVector(triple, triple2);
        triple3 = triple3.mult(d2 / d).add(triple);
        double d4 = triple3.getX();
        double d5 = triple3.getY();
        double d6 = triple3.getZ();
        String string3 = "@balllist {" + string + "} color= " + string2 + " radius= " + this.df1.format(d3) + " master= {dist devs}";
        String string4 = "{" + string + "}L " + this.df2.format(d4) + " " + this.df2.format(d5) + " " + this.df2.format(d6);
        this.distList.add(string3);
        this.distList.add(string4);
    }

    public void addBallInMiddle(String string, Triple triple, Triple triple2, double d, double d2) {
        double d3 = d - d2;
        String string2 = "red";
        if (d3 < 0.0) {
            string2 = "blue";
            d3 = -d3;
        }
        Triple triple3 = new Triple().likeMidpoint(triple, triple2);
        double d4 = triple3.getX();
        double d5 = triple3.getY();
        double d6 = triple3.getZ();
        String string3 = "@balllist {" + string + "} color= " + string2 + " radius= " + this.df1.format(d3) + " master= {dist devs}";
        String string4 = "{" + string + "}L " + this.df2.format(d4) + " " + this.df2.format(d5) + " " + this.df2.format(d6);
        this.distList.add(string3);
        this.distList.add(string4);
    }

    public void addSpring(String string, Triple triple, Triple triple2, double d, double d2, double d3) {
        Triple triple3 = new Triple(triple.getX(), triple.getY(), triple.getZ());
        ArrayList<String> arrayList = new ArrayList<String>();
        Triple triple4 = new Triple(triple2.getX() - triple.getX(), triple2.getY() - triple.getY(), triple2.getZ() - triple.getZ());
        Triple triple5 = new Triple(1.0, 0.0, 0.0);
        Triple triple6 = new Triple().likeNormal(triple, triple2, triple5);
        triple6.mult(0.2);
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        arrayList.add("@vectorlist {" + string + "} color= " + string2 + " width= " + 3 + " master= {dist devs}");
        arrayList.add("{" + string + "}P " + this.df2.format(triple.getX()) + " " + this.df2.format(triple.getY()) + " " + this.df2.format(triple.getZ()));
        arrayList.add("{" + string + "}L " + this.df2.format(triple.getX() + triple6.getX()) + " " + this.df2.format(triple.getY() + triple6.getY()) + " " + this.df2.format(triple.getZ() + triple6.getZ()));
        double d4 = triple.getX() + triple6.getX();
        double d5 = triple.getY() + triple6.getY();
        double d6 = triple.getZ() + triple6.getZ();
        Triple triple7 = new Triple(d4, d5, d6);
        double d7 = 36.0;
        if (d3 > 10.0) {
            d3 = 10.0;
        }
        if (d3 < -10.0) {
            d3 = -10.0;
        }
        if (d3 <= 0.0) {
            d7 += 1.5 * Math.abs(d3);
        } else if (d3 > 0.0) {
            d7 -= 1.5 * d3;
        }
        int n = 60;
        double d8 = new Triple(triple2.getX() - triple.getX(), triple2.getY() - triple.getY(), triple2.getZ() - triple.getZ()).mag();
        Triple triple8 = triple6;
        for (int i = 1; i <= n; ++i) {
            triple = new Triple(triple3.getX(), triple3.getY(), triple3.getZ());
            triple4 = new Triple().likeVector(triple, triple2);
            Transform object = new Transform();
            object = object.likeRotation(triple4, d7);
            object.transform(triple8);
            Triple triple9 = new Triple(triple4.getX(), triple4.getY(), triple4.getZ());
            triple9.div(n);
            triple8.add(triple9);
            Triple triple10 = triple.add(triple8);
            arrayList.add("{" + string + "}L " + this.df2.format(triple10.getX()) + " " + this.df2.format(triple10.getY()) + " " + this.df2.format(triple10.getZ()));
        }
        arrayList.add("{" + string + "}L " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ()));
        for (String string3 : arrayList) {
            this.distList.add(string3);
        }
    }

    public void addLine(String string, Triple triple, Triple triple2, Triple triple3, double d, double d2) {
        Triple triple4 = new Triple().likeNormal(triple, triple2, triple3);
        Transform transform = new Transform();
        transform = transform.likeRotation(triple4, d - d2);
        Triple triple5 = new Triple(triple3.getX() - triple2.getX(), triple3.getY() - triple2.getY(), triple3.getZ() - triple2.getZ());
        transform.transform(triple5);
        Triple triple6 = new Triple(triple2.getX() + triple5.getX(), triple2.getY() + triple5.getY(), triple2.getZ() + triple5.getZ());
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        String string3 = "@vectorlist {" + string + "} color= " + string2 + " width= 4" + " master= {angle devs}";
        String string4 = "{" + string + "}P " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ());
        String string5 = "{" + string + "}L " + this.df2.format(triple6.getX()) + " " + this.df2.format(triple6.getY()) + " " + this.df2.format(triple6.getZ());
        this.angList.add(string3);
        this.angList.add(string4);
        this.angList.add(string5);
    }

    public void addBlurredLine(String string, Triple triple, Triple triple2, Triple triple3, double d, double d2) {
        Triple triple4 = new Triple().likeNormal(triple, triple2, triple3);
        Transform transform = new Transform();
        transform = transform.likeRotation(triple4, (d - d2) * 1.0);
        Transform transform2 = new Transform();
        transform2 = transform2.likeRotation(triple4, (d - d2) * 0.75);
        Transform transform3 = new Transform();
        transform3 = transform3.likeRotation(triple4, (d - d2) * 0.5);
        Transform transform4 = new Transform();
        transform4 = transform4.likeRotation(triple4, (d - d2) * 0.25);
        Triple triple5 = new Triple().likeVector(triple2, triple3);
        Triple triple6 = new Triple().likeVector(triple2, triple3);
        Triple triple7 = new Triple().likeVector(triple2, triple3);
        Triple triple8 = new Triple().likeVector(triple2, triple3);
        transform.transform(triple5);
        transform2.transform(triple6);
        transform3.transform(triple7);
        transform4.transform(triple8);
        Triple triple9 = triple5.mult(0.75).add(triple2);
        Triple triple10 = triple6.mult(0.75).add(triple2);
        Triple triple11 = triple7.mult(0.75).add(triple2);
        Triple triple12 = triple8.mult(0.75).add(triple2);
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        arrayList.add(triple9);
        arrayList.add(triple10);
        arrayList.add(triple11);
        arrayList.add(triple12);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = "@vectorlist {" + string + "} color= " + string2 + " width= " + (4 - i) + " master= {angle devs}";
            Triple triple13 = (Triple)arrayList.get(i);
            String string4 = "{" + string + "}P " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ());
            String string5 = "{" + string + "}L " + this.df2.format(triple13.getX()) + " " + this.df2.format(triple13.getY()) + " " + this.df2.format(triple13.getZ());
            this.angList.add(string3);
            this.angList.add(string4);
            this.angList.add(string5);
        }
    }

    public void addLineAndBlurredLine(String string, Triple triple, Triple triple2, Triple triple3, double d, double d2) {
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        Triple triple4 = new Triple().likeVector(triple2, triple);
        Triple triple5 = triple4.mult(0.75).add(triple2);
        String string3 = "@vectorlist {" + string + "} color= " + string2 + " width= " + 4 + " master= {angle devs}";
        String string4 = "{" + string + "}P " + this.df2.format(triple5.getX()) + " " + this.df2.format(triple5.getY()) + " " + this.df2.format(triple5.getZ());
        String string5 = "{" + string + "}L " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ());
        this.angList.add(string3);
        this.angList.add(string4);
        this.angList.add(string5);
        this.addBlurredLine(string, triple, triple2, triple3, d, d2);
    }

    public void printModel(Model model) {
        if (this.doKinHeadings) {
            System.out.println("@kinemage {" + this.label.substring(0, 4) + " geom devs}");
            System.out.println("@master {dist devs}");
            System.out.println("@master {angle devs}");
        }
        if (this.subgroupNotGroup) {
            System.out.println("@subgroup {" + this.label.substring(0, 4) + " " + model.getName() + " geom devs} dominant master= {all models}");
        } else {
            System.out.println("@group {" + this.label.substring(0, 4) + " " + model.getName() + " geom devs} dominant master= {all models}");
        }
        if (this.doDistDevsKin) {
            for (String string : this.distList) {
                System.out.println(string);
            }
        }
        if (this.doAngleDevsKin) {
            for (String string : this.angList) {
                System.out.println(string);
            }
        }
        if (this.distList.size() == 0) {
            System.out.println("<distList is empty>");
        }
        if (this.angList.size() == 0) {
            System.out.println("<angList is empty>");
        }
    }
}

