/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelingTool;
import chiropraxis.kingtools.SswingRunner;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.gui.TablePane2;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import king.ToolBox;
import king.core.KPoint;

public class SswingTool
extends ModelingTool {
    Residue targetRes;
    File ccp4MapFile = null;
    SuffixFileFilter mapFilter;
    JFileChooser mapChooser;
    JDialog dialog;
    JTextField sswingCmdField;

    public SswingTool(ToolBox toolBox) {
        super(toolBox);
        this.buildGUI();
    }

    private void buildGUI() {
        this.mapFilter = new SuffixFileFilter("CCP4 electron density maps");
        this.mapFilter.addSuffix(".ccp4");
        this.mapFilter.addSuffix(".mbk");
        this.mapFilter.addSuffix(".map");
        this.mapChooser = new JFileChooser();
        this.mapChooser.addChoosableFileFilter(this.mapFilter);
        this.mapChooser.setFileFilter(this.mapFilter);
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.mapChooser.setCurrentDirectory(new File(string));
        }
        this.sswingCmdField = new JTextField(40);
        JButton jButton = new JButton(new ReflectiveAction("Choose new map...", null, (Object)this, "onChooseMap"));
        JButton jButton2 = new JButton(new ReflectiveAction("Run Sswing", null, (Object)this, "onRunSswing"));
        JButton jButton3 = new JButton(new ReflectiveAction("Don't run", null, (Object)this, "onCancel"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.hfill(true).addCell(this.sswingCmdField, 4, 1);
        tablePane2.newRow();
        tablePane2.weights(0.0, 0.0).memorize();
        tablePane2.addCell(jButton);
        tablePane2.weights(1.0, 0.0).addCell(Box.createGlue());
        tablePane2.addCell(jButton3).addCell(jButton2);
        this.dialog = new JDialog(this.kMain.getTopWindow(), this.toString(), true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setContentPane(tablePane2);
        this.dialog.pack();
    }

    public void start() {
        super.start();
        this.modelman.onShowDialog(null);
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint != null) {
            ModelState modelState = this.modelman.getMoltenState();
            this.targetRes = this.getResidueNearest(this.modelman.getModel(), modelState, kPoint.getX(), kPoint.getY(), kPoint.getZ());
            if (this.ccp4MapFile == null) {
                this.onChooseMap(null);
            }
            if (this.ccp4MapFile == null) {
                return;
            }
            try {
                String string = this.makeSswingCmdLine();
                this.sswingCmdField.setText(string);
                this.dialog.setVisible(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    String makeSswingCmdLine() throws IOException {
        String string = SswingRunner.findProgram(this.kMain, "sswing");
        String string2 = "-f -s ";
        if (!" ".equals(this.targetRes.getChain())) {
            string2 = string2 + "-c " + this.targetRes.getChain();
        }
        String string3 = string + " " + string2 + " " + "'" + this.modelman.getFrozenPDB().getCanonicalPath() + "' " + this.targetRes.getSequenceNumber() + " " + this.targetRes.getName() + " " + "'" + this.ccp4MapFile.getCanonicalPath() + "'";
        return string3;
    }

    public void onCancel(ActionEvent actionEvent) {
        this.dialog.setVisible(false);
    }

    public void onRunSswing(ActionEvent actionEvent) {
        this.dialog.setVisible(false);
        String string = this.sswingCmdField.getText();
        System.out.println(string + "...\n");
        SswingRunner sswingRunner = new SswingRunner(this.kMain, this.modelman, this.targetRes, string);
    }

    public void onChooseMap(ActionEvent actionEvent) {
        if (0 == this.mapChooser.showOpenDialog(this.kMain.getTopWindow())) {
            this.ccp4MapFile = this.mapChooser.getSelectedFile();
            try {
                String string = this.makeSswingCmdLine();
                this.sswingCmdField.setText(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    protected Container getToolPanel() {
        return null;
    }

    public String getHelpAnchor() {
        return null;
    }

    public String toString() {
        return "Sswing";
    }
}

