/*
 * Decompiled with CFR 0.152.
 */
package absigner.kingplugin;

import absigner.Absigner;
import absigner.Parameters;
import driftwood.gui.ReflectiveAction;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.StreamTank;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import king.Plugin;
import king.ToolBox;
import king.core.AGE;
import king.core.AHE;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KPalette;
import king.core.Kinemage;
import molikin.PrekinIDer;

public class AbsignerPlugin
extends Plugin {
    Absigner ab = null;

    public AbsignerPlugin(ToolBox toolBox) {
        super(toolBox);
    }

    public void onOpenFile(ActionEvent actionEvent) {
        File file;
        String string = System.getProperty("user.dir");
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if (0 == jFileChooser.showOpenDialog(this.kMain.getTopWindow()) && (file = jFileChooser.getSelectedFile()) != null && file.exists()) {
            this.ab = new Absigner(file);
            this.buildKinemage(null);
            this.exploreParameters();
        }
    }

    public void buildKinemage(Kinemage kinemage) {
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        this.ab.printKinemage(this.ab.getPdb(), printWriter);
        streamTank.close();
        this.kMain.getKinIO().loadStream((InputStream)streamTank.getInputStream(), streamTank.size(), kinemage);
    }

    public void recolorGroup(KGroup kGroup, double[] dArray) {
        PrekinIDer prekinIDer = new PrekinIDer();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int[] nArray = new int[]{2};
        this.ab.recalculate(nArray, dArray);
        HashMap<Residue, Integer> hashMap2 = this.ab.getAlphaMap();
        HashMap<Residue, Integer> hashMap3 = this.ab.getBetaMap();
        CoordinateFile coordinateFile = this.ab.getPdb();
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        Set set = model.getChainIDs();
        for (Object object : set) {
            Set set2 = model.getChain((String)object);
            for (Residue residue : set2) {
                Iterator iterator = residue.getAtoms().iterator();
                while (iterator.hasNext()) {
                    try {
                        Atom atom = (Atom)iterator.next();
                        AtomState atomState = modelState.get(atom);
                        String string = prekinIDer.identifyAtom(atomState);
                        hashMap.put(string, new Integer(hashMap2.get(residue) + hashMap3.get(residue)));
                        if (hashMap3.get(residue) == 0) continue;
                    }
                    catch (AtomException atomException) {}
                }
            }
        }
        KIterator kIterator = KIterator.allPoints((AGE)kGroup);
        for (Set set2 : kIterator) {
            if (hashMap.containsKey(set2.getName())) {
                int n = (Integer)hashMap.get(set2.getName());
                if (n == 0) {
                    set2.setColor(KPalette.white);
                    continue;
                }
                if (n == 1) {
                    set2.setColor(KPalette.yellowtint);
                    continue;
                }
                if (n == 2) {
                    set2.setColor(KPalette.greentint);
                    continue;
                }
                if (n >= 3) {
                    set2.setColor(KPalette.green);
                    continue;
                }
                if (n == -1) {
                    set2.setColor(KPalette.pinktint);
                    continue;
                }
                if (n == -2) {
                    set2.setColor(KPalette.pink);
                    continue;
                }
                if (n > -3) continue;
                set2.setColor(KPalette.hotpink);
                continue;
            }
            System.err.println("Point Map does not have key for " + set2);
        }
    }

    public void exploreParameters() {
        Kinemage kinemage = this.kMain.getKinemage();
        KGroup kGroup = (KGroup)kinemage.getChildren().get(0);
        for (int i = 1; i <= 30; ++i) {
            kGroup.setAnimate(true);
            KGroup kGroup2 = kGroup.clone(true);
            double[] dArray = new double[]{i, i, i, i, i, i};
            this.recolorGroup(kGroup2, dArray);
            kinemage.add((AHE)kGroup2);
        }
    }

    public String toString() {
        return "ABsigner";
    }

    public JMenuItem getToolsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction(this.toString(), null, (Object)this, "onOpenFile"));
        return jMenuItem;
    }

    public void onTest(ActionEvent actionEvent) {
        this.checkAngleInRange(150.0, 160.0, 15.0, true);
        this.checkAngleInRange(150.0, 160.0, 10.0, true);
        this.checkAngleInRange(150.0, 150.0, 0.0, true);
        this.checkAngleInRange(170.0, -170.0, 20.0, true);
        this.checkAngleInRange(-170.0, 170.0, 20.0, true);
        this.checkAngleInRange(-180.0, 180.0, 0.0, true);
        this.checkAngleInRange(180.0, -180.0, 0.0, true);
        this.checkAngleInRange(0.0, 5.0, 10.0, true);
        this.checkAngleInRange(0.0, -5.0, 10.0, true);
        this.checkAngleInRange(150.0, 151.0, 0.0, false);
        this.checkAngleInRange(170.0, -170.0, 10.0, false);
        this.checkAngleInRange(-170.0, 170.0, 10.0, false);
        System.out.println("Test complete");
    }

    private void checkAngleInRange(double d, double d2, double d3, boolean bl) {
        if (Parameters.angleInRange(d, d2, d3) != bl) {
            System.out.println("ERROR: " + Double.toString(d) + " +/- " + Double.toString(d3) + " not " + bl + " of " + Double.toString(d2));
        }
    }
}

