/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.mysql.DatabaseManager;
import driftwood.r3.Builder;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jiffiloop.Filler;
import jiffiloop.PdbLibraryReader;
import jiffiloop.ProteinGap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragFiller
implements Filler {
    static final DecimalFormat df = new DecimalFormat("0.000");
    HashMap<ProteinGap, ArrayList<String>> filledMap = new HashMap();
    static boolean ntermsup = false;

    public FragFiller(Map<String, ArrayList<ProteinGap>> map) {
        ArrayList<ProteinGap> arrayList = new ArrayList<ProteinGap>();
        for (ArrayList<ProteinGap> object : map.values()) {
            arrayList.addAll(object);
        }
        for (ProteinGap proteinGap : arrayList) {
            this.filledMap.put(proteinGap, new ArrayList());
        }
    }

    public void searchDB(int n) {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.connectToDatabase("//quality.biochem.duke.edu/vbc3");
        for (ProteinGap proteinGap : this.filledMap.keySet()) {
            ArrayList<Double> arrayList = proteinGap.getParameters();
            int n2 = proteinGap.getSize();
            String string = "SELECT pdb_id, chain_id, frag_length, start_res_num FROM parameters5200 ";
            string = n == 0 ? string.concat("WHERE frag_length = " + Integer.toString(n2) + " \n") : string.concat("WHERE frag_length = " + Integer.toString(n) + " \n");
            double d = arrayList.get(0);
            string = string.concat("AND (distance <= " + df.format(arrayList.get(0) + 1.0) + " AND distance >= " + df.format(arrayList.get(0) - 1.0));
            string = string.concat(") \n");
            double d2 = arrayList.get(1);
            string = string.concat(this.createWhereQuery(d2, "start_angle") + " \n");
            double d3 = arrayList.get(2);
            string = string.concat(this.createWhereQuery(d3, "end_angle") + " \n");
            double d4 = arrayList.get(3);
            string = string.concat(this.createWhereQuery(d4, "start_dihedral") + " \n");
            double d5 = arrayList.get(4);
            string = string.concat(this.createWhereQuery(d5, "middle_dihedral") + " \n");
            double d6 = arrayList.get(5);
            string = string.concat(this.createWhereQuery(d6, "end_dihedral") + " \n");
            string = string.concat("AND max_B_factor <= 35;");
            System.out.println(string);
            ArrayList<String> arrayList2 = this.filledMap.get(proteinGap);
            databaseManager.select(string);
            while (databaseManager.next()) {
                arrayList2.add(databaseManager.getString(1) + " " + databaseManager.getString(2) + " " + databaseManager.getString(3) + " " + databaseManager.getString(4));
            }
        }
    }

    public String getMatchesInfo() {
        String string = "";
        for (ProteinGap proteinGap : this.filledMap.keySet()) {
            ArrayList<String> arrayList = this.filledMap.get(proteinGap);
            string = string.concat(proteinGap.getSourceString() + " had " + arrayList.size() + " matches\n");
        }
        return string;
    }

    public String createWhereQuery(double d, String string) {
        if (d > 155.0) {
            return "AND (" + string + " >= " + Double.toString(d - 25.0) + " OR " + string + " <= " + Double.toString(-335.0 + d) + ")";
        }
        if (d < -155.0) {
            return "AND (" + string + " <= " + Double.toString(d + 25.0) + " OR " + string + " >= " + Double.toString(d + 360.0 - 25.0) + ")";
        }
        return "AND (" + string + " <= " + Double.toString(d + 25.0) + " AND " + string + " >= " + Double.toString(d - 25.0) + ")";
    }

    public void scanLoopData(ArrayList<File> arrayList, ArrayList<ProteinGap> arrayList2) {
        for (File file : arrayList) {
            if (file == null || !file.exists()) continue;
            try {
                System.out.println("Opening file: " + file.getName());
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string;
                    ZipEntry zipEntry = enumeration.nextElement();
                    System.out.println("Scanning: " + zipEntry.getName());
                    LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
                    while ((string = lineNumberReader.readLine()) != null) {
                        String[] stringArray = string.split(",");
                        String[] stringArray2 = stringArray[0].split(" ");
                        double[] dArray = new double[8];
                        dArray[1] = Double.parseDouble(stringArray2[1]);
                        for (int i = 2; i < 8; ++i) {
                            dArray[i] = Double.parseDouble(stringArray[i]);
                        }
                        for (ProteinGap proteinGap : arrayList2) {
                            ArrayList<Double> arrayList3 = proteinGap.getParameters();
                            int n = proteinGap.getSize();
                            if (!this.scanLine(dArray, n, arrayList3)) continue;
                            ArrayList<String> arrayList4 = this.filledMap.get(arrayList3);
                            arrayList4.add(stringArray[0] + " " + stringArray[1]);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("An I/O error occurred while loading the file:\n" + iOException.getMessage());
            }
        }
    }

    public boolean scanLine(double[] dArray, int n, ArrayList<Double> arrayList) {
        boolean bl = true;
        if ((double)n != dArray[1]) {
            bl = false;
        }
        if (dArray[2] >= arrayList.get(0) + 1.0 || dArray[2] <= arrayList.get(0) - 1.0) {
            bl = false;
        }
        for (int i = 3; i < arrayList.size() && bl; ++i) {
            bl = this.checkAngle(arrayList.get(i - 2), dArray[i]);
        }
        return bl;
    }

    public boolean checkAngle(double d, double d2) {
        if (d > 155.0) {
            return d2 >= d - 25.0 || d2 <= -335.0 + d;
        }
        if (d < -155.0) {
            return d2 <= d + 25.0 || d2 >= d + 360.0 - 25.0;
        }
        return d2 <= d + 25.0 && d2 >= d - 25.0;
    }

    @Override
    public CoordinateFile[] getFragments(PdbLibraryReader pdbLibraryReader, boolean bl, int n) {
        CoordinateFile[] coordinateFileArray = new CoordinateFile[this.filledMap.keySet().size()];
        int n2 = 0;
        for (ProteinGap proteinGap : this.filledMap.keySet()) {
            coordinateFileArray[n2] = new CoordinateFile();
            coordinateFileArray[n2].setIdCode(proteinGap.getSourceString() + "." + proteinGap.getOneNum() + "-" + proteinGap.getNNum());
            ArrayList<String> arrayList = this.filledMap.get(proteinGap);
            for (int i = 0; i < n && i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                String[] stringArray = string.split(" ");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = Integer.parseInt(stringArray[3]);
                pdbLibraryReader.setCurrentPdb(string2, string3);
                Model model = pdbLibraryReader.getFragment(Integer.toString(i), string3, n4, n3, proteinGap.getOneNum() - 1);
                if (model == null) continue;
                try {
                    Object object;
                    Transform transform = null;
                    if (!bl) {
                        object = new SuperPoser(proteinGap.getTupleArray(), pdbLibraryReader.getFragmentEndpointAtoms(model));
                        transform = ((SuperPoser)object).superpos();
                    } else {
                        object = new Builder();
                        Tuple3[] tuple3Array = proteinGap.getNtermTuples();
                        Tuple3[] tuple3Array2 = pdbLibraryReader.getFragmentNtermAtoms(model);
                        transform = ((Builder)object).dock3on3(tuple3Array[2], tuple3Array[0], tuple3Array[1], tuple3Array2[2], tuple3Array2[0], tuple3Array2[1]);
                    }
                    this.transform(model, transform);
                    coordinateFileArray[n2].add(model);
                    if (Math.IEEEremainder(i, 100.0) != 0.0) continue;
                    System.out.println("Opened: " + i);
                    continue;
                }
                catch (AtomException atomException) {
                    System.err.println("Problem with atom " + atomException.getMessage() + " in pdb " + string2);
                    atomException.printStackTrace(System.err);
                }
            }
            ++n2;
        }
        return coordinateFileArray;
    }

    public void transform(Model model, Transform transform) {
        ModelState modelState = model.getState();
        for (Residue residue : model.getResidues()) {
            for (Atom atom : residue.getAtoms()) {
                try {
                    AtomState atomState = modelState.get(atom);
                    Triple triple = new Triple();
                    triple.setXYZ(atomState.getX(), atomState.getY(), atomState.getZ());
                    transform.transform(triple);
                    atomState.setX(triple.getX());
                    atomState.setY(triple.getY());
                    atomState.setZ(triple.getZ());
                }
                catch (AtomException atomException) {
                    System.err.println("Problem with atom " + atomException.getMessage() + " in fragment filler");
                }
            }
        }
    }

    @Override
    public Tuple3[] getTupleArray(ArrayList<Triple> arrayList) {
        Tuple3[] tuple3Array = new Tuple3[]{arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3)};
        return tuple3Array;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

