/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PdbLibraryReader {
    HashMap<String, ZipEntry> pdbMap;
    CoordinateFile currentPdb;
    String currentChain;
    ZipFile zip;
    boolean renumber;
    boolean reResid;

    public PdbLibraryReader(File file, boolean bl, boolean bl2) {
        this.renumber = bl;
        this.reResid = bl2;
        File[] fileArray = file.listFiles();
        this.pdbMap = new HashMap();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (!file2.getName().endsWith(".zip")) continue;
                try {
                    System.out.println("Opening file: " + file2.getName());
                    this.zip = new ZipFile(file2);
                    Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.getName().indexOf(".pdb") <= -1) continue;
                        String[] stringArray = zipEntry.getName().split("/");
                        String string = stringArray[stringArray.length - 1];
                        this.pdbMap.put(string.substring(0, 5).toLowerCase(), zipEntry);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("An I/O error occurred while loading the file:\n" + iOException.getMessage());
                }
            }
        } else {
            System.err.println("PDB library not found, make sure to use -pdbloc to set the location to the directory of the PDB library zip file!");
        }
    }

    public CoordinateFile readPdb(String string) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.zip.getInputStream(this.pdbMap.get(string))));
            PdbReader pdbReader = new PdbReader();
            CoordinateFile coordinateFile = pdbReader.read(lineNumberReader);
            return coordinateFile;
        }
        catch (IOException iOException) {
            System.err.println("Problem when reading pdb file: " + string);
            return null;
        }
    }

    public void setCurrentPdb(String string, String string2) {
        if (this.currentPdb == null || this.currentChain == null || !this.currentPdb.getIdCode().equals(string) || this.currentChain != string2) {
            this.currentPdb = this.readPdb(string.toLowerCase() + string2.toLowerCase());
            this.currentChain = string2;
        }
    }

    public Model getFragment(String string, String string2, int n, int n2, int n3) {
        Model model = new Model(string);
        ModelState modelState = new ModelState();
        TreeMap<String, ModelState> treeMap = new TreeMap<String, ModelState>();
        treeMap.put(" ", modelState);
        model.setStates(treeMap);
        if (this.currentPdb != null) {
            Model model2 = this.currentPdb.getFirstModel();
            ModelState modelState2 = model2.getState();
            Set set = model2.getChain(string2);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (model.getResidues().size() <= n2 + 2 && iterator.hasNext()) {
                    Residue residue = (Residue)iterator.next();
                    int n4 = residue.getSequenceInteger();
                    if (n4 < n || n4 > n + n2 + 2 || !residue.getInsertionCode().equals(" ")) continue;
                    try {
                        if (this.isResidueComplete(residue)) {
                            model.add(residue);
                            residue.cloneStates(residue, modelState2, modelState);
                            String string3 = "  " + this.currentPdb.getIdCode() + Integer.toString(n) + string2;
                            this.addPast80Info(residue, string3, modelState);
                            continue;
                        }
                        System.err.println("fragment from " + this.currentPdb.getIdCode() + " " + String.valueOf(n4) + " discarded due to incomplete residues");
                        return null;
                    }
                    catch (AtomException atomException) {
                        System.err.println("Error occurred during cloning of atom in PdbLibraryReader.");
                    }
                    catch (ResidueException residueException) {
                        System.err.println("Error occurred during adding of residue in PdbLibraryReader.");
                    }
                }
            } else {
                System.err.println("This shouldn't happen, but a pdb in the library does not have a chain the database says it should!");
            }
        } else {
            System.err.println("No pdb set in PdbLibraryReader!");
        }
        this.trimFragment(model);
        if (this.renumber || this.reResid) {
            model = this.revampFragment(model, n3);
        }
        return model;
    }

    public Model revampFragment(Model model, int n) {
        ModelState modelState = model.getState();
        Model model2 = new Model(model.getName());
        ModelState modelState2 = new ModelState();
        TreeMap<String, ModelState> treeMap = new TreeMap<String, ModelState>();
        treeMap.put(" ", modelState2);
        model2.setStates(treeMap);
        Set set = model.getChainIDs();
        for (String string : set) {
            try {
                Set set2 = model.getChain(string);
                for (Residue residue : set2) {
                    String string2 = residue.getSequenceNumber();
                    if (this.renumber) {
                        string2 = Strings.justifyRight(Integer.toString(n), 4);
                    }
                    String string3 = residue.getName();
                    if (this.reResid && !string3.equals("PRO") && !string3.equals("GLY")) {
                        string3 = "ALA";
                    }
                    Residue residue2 = new Residue(residue.getChain(), residue.getSegment(), string2, residue.getInsertionCode(), string3);
                    model2.add(residue2);
                    ArrayList arrayList = new ArrayList(residue.getAtoms());
                    for (int i = 0; i < arrayList.size(); ++i) {
                        AtomState atomState;
                        Atom atom = (Atom)arrayList.get(i);
                        Atom atom2 = new Atom(atom);
                        if (this.reResid) {
                            if (!this.isBackboneAtom(atom)) continue;
                            residue2.add(atom2);
                            atomState = modelState.get(atom);
                            modelState2.add(atomState.cloneFor(atom2));
                            continue;
                        }
                        residue2.add(atom2);
                        atomState = modelState.get(atom);
                        modelState2.add(atomState.cloneFor(atom2));
                    }
                    ++n;
                }
            }
            catch (AtomException atomException) {
                System.err.println("Error occurred during renumbering of atom in PdbLibraryReader.");
            }
            catch (ResidueException residueException) {
                System.err.println("Error occurred during renumbering of residue in PdbLibraryReader.");
            }
        }
        return model2;
    }

    public void addPast80Info(Residue residue, String string, ModelState modelState) {
        Collection collection = residue.getAtoms();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                Atom atom = (Atom)iterator.next();
                AtomState atomState = modelState.get(atom);
                atomState.setPast80(string);
            }
            catch (AtomException atomException) {
                System.err.println("Error occurred while adding extra info in PdbLibraryReader.");
            }
        }
    }

    public void trimFragment(Model model) {
        try {
            UberSet uberSet = new UberSet(model.getResidues());
            Residue residue = (Residue)uberSet.firstItem();
            Atom atom = residue.getAtom(" N  ");
            if (atom == null) {
                throw new AtomException("trouble trimming model " + model.toString() + " res " + residue.getSequenceNumber());
            }
            residue.remove(atom);
            Residue residue2 = (Residue)uberSet.lastItem();
            Atom atom2 = residue2.getAtom(" O  ");
            Atom atom3 = residue2.getAtom(" C  ");
            if (atom2 == null) {
                throw new AtomException("trouble trimming model " + model.toString() + " res " + residue.getSequenceNumber());
            }
            residue2.remove(atom2);
            if (atom3 == null) {
                throw new AtomException("trouble trimming model " + model.toString() + " res " + residue.getSequenceNumber());
            }
            residue2.remove(atom3);
        }
        catch (AtomException atomException) {
            System.err.println(atomException);
        }
    }

    public boolean isResidueComplete(Residue residue) {
        if (residue == null) {
            return false;
        }
        return residue.getAtom(" N  ") != null && residue.getAtom(" CA ") != null && residue.getAtom(" C  ") != null && residue.getAtom(" O  ") != null;
    }

    public boolean isBackboneAtom(Atom atom) {
        String string = atom.getName();
        return string.equals(" N  ") || string.equals(" CA ") || string.equals(" C  ") || string.equals(" O  ") || string.equals(" H  ") || string.equals(" HA ") || string.equals(" HA2") || string.equals(" HA3");
    }

    public Tuple3[] getFragmentEndpointAtoms(Model model) throws AtomException {
        UberSet uberSet = new UberSet(model.getResidues());
        Tuple3[] tuple3Array = new Tuple3[4];
        if (this.currentPdb != null) {
            ModelState modelState = model.getState();
            Residue residue = (Residue)uberSet.firstItem();
            Residue residue2 = (Residue)uberSet.itemAfter(residue);
            Residue residue3 = (Residue)uberSet.lastItem();
            Residue residue4 = (Residue)uberSet.itemBefore(residue3);
            tuple3Array[0] = modelState.get(residue.getAtom(" CA "));
            tuple3Array[1] = modelState.get(residue2.getAtom(" CA "));
            tuple3Array[2] = modelState.get(residue4.getAtom(" CA "));
            tuple3Array[3] = modelState.get(residue3.getAtom(" CA "));
            return tuple3Array;
        }
        System.err.println("No pdb set in PdbLibraryReader!");
        return null;
    }

    public Tuple3[] getStemNtermAtoms(Model model) throws AtomException, NoSuchElementException {
        UberSet uberSet = new UberSet(model.getResidues());
        Tuple3[] tuple3Array = new Tuple3[3];
        if (this.currentPdb != null) {
            ModelState modelState = model.getState();
            Residue residue = (Residue)uberSet.firstItem();
            Residue residue2 = (Residue)uberSet.itemAfter(residue);
            Residue residue3 = (Residue)uberSet.itemAfter(residue2);
            tuple3Array[0] = modelState.get(residue.getAtom(" CA "));
            tuple3Array[1] = modelState.get(residue2.getAtom(" CA "));
            tuple3Array[2] = modelState.get(residue3.getAtom(" CA "));
            return tuple3Array;
        }
        System.err.println("No pdb set in PdbLibraryReader!");
        return null;
    }

    public Tuple3[] getStemCtermAtoms(Model model) throws AtomException, NoSuchElementException {
        UberSet uberSet = new UberSet(model.getResidues());
        Tuple3[] tuple3Array = new Tuple3[3];
        if (this.currentPdb != null) {
            ModelState modelState = model.getState();
            Residue residue = (Residue)uberSet.lastItem();
            Residue residue2 = (Residue)uberSet.itemBefore(residue);
            Residue residue3 = (Residue)uberSet.itemBefore(residue2);
            tuple3Array[0] = modelState.get(residue3.getAtom(" CA "));
            tuple3Array[1] = modelState.get(residue2.getAtom(" CA "));
            tuple3Array[2] = modelState.get(residue.getAtom(" CA "));
            return tuple3Array;
        }
        System.err.println("No pdb set in PdbLibraryReader!");
        return null;
    }

    public Tuple3[] getFragmentNtermAtoms(Model model) throws AtomException {
        UberSet uberSet = new UberSet(model.getResidues());
        Tuple3[] tuple3Array = new Tuple3[3];
        if (this.currentPdb != null) {
            ModelState modelState = model.getState();
            Residue residue = (Residue)uberSet.firstItem();
            Residue residue2 = (Residue)uberSet.itemAfter(residue);
            tuple3Array[0] = modelState.get(residue.getAtom(" CA "));
            tuple3Array[1] = modelState.get(residue.getAtom(" O  "));
            tuple3Array[2] = modelState.get(residue2.getAtom(" CA "));
            return tuple3Array;
        }
        System.err.println("No pdb set in PdbLibraryReader!");
        return null;
    }
}

