/*
 * Decompiled with CFR 0.152.
 */
package molikin.logic;

import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.SecondaryStructure;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import molikin.AtomClassifier;
import molikin.DataCache;
import molikin.GuidePoint;
import molikin.ResClassifier;
import molikin.RibbonPrinter;
import molikin.Ribbons;
import molikin.crayons.ConstCrayon;
import molikin.crayons.ResColorMapCrayon;
import molikin.logic.Logic;

public class RibbonLogic
implements Logic {
    public static final Object COLOR_BY_SEC_STRUCT = "secondary structure";
    public static final Object COLOR_BY_RAINBOW = "N -> C / 5' -> 3'";
    PrintWriter out = null;
    RibbonPrinter rp = null;
    public boolean doProtein;
    public boolean doNucleic;
    public boolean doUntwistRibbons;
    public boolean doDnaStyle;
    public boolean doPlainCoils = false;
    public Object colorBy = COLOR_BY_SEC_STRUCT;
    public SecondaryStructure secondaryStructure = null;

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string) {
        this.out = printWriter;
        this.rp = new RibbonPrinter(printWriter);
        String string2 = "_";
        if (set.size() > 0) {
            string2 = ((Residue)set.iterator().next()).getChain().trim();
        }
        if (string2.equals("")) {
            string2 = "_";
        }
        if (this.doProtein) {
            this.printProtein(model, set, string2, string);
        }
        if (this.doNucleic) {
            this.printNucAcid(model, set, string2, string);
        }
        this.out.flush();
        this.out = null;
        this.rp = null;
    }

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string, String string2) {
        this.printKinemage(printWriter, model, set, string2);
    }

    private void setUpColoring(Collection collection) {
        if (this.colorBy == COLOR_BY_SEC_STRUCT) {
            this.rp.setCrayon(ConstCrayon.NONE);
        } else if (this.colorBy == COLOR_BY_RAINBOW) {
            this.rp.setCrayon(ResColorMapCrayon.newRainbow(collection));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void printProtein(Model model, Set set, String string, String string2) {
        DataCache dataCache = DataCache.getDataFor(model);
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        ResClassifier resClassifier = dataCache.getResClassifier();
        ModelState modelState = model.getState();
        if (atomClassifier.bbNotCa == 0) {
            this.secondaryStructure = new SecondaryStructure.AllCoil();
        }
        Ribbons ribbons = new Ribbons();
        Collection collection = ribbons.getProteinContigs(set, modelState, resClassifier);
        this.setUpColoring(collection);
        this.rp.setRnaPointIDs(false);
        if (collection.size() > 0 && this.secondaryStructure != null) {
            if (string2.equals("white")) {
                this.out.println("@colorset {alph" + string + "} red");
                this.out.println("@colorset {beta" + string + "} lime");
                this.out.println("@colorset {coil" + string + "} white");
            } else {
                this.out.println("@colorset {alph" + string + "} " + string2);
                this.out.println("@colorset {beta" + string + "} " + string2);
                this.out.println("@colorset {coil" + string + "} " + string2);
            }
        }
        int n = 0;
        for (Collection collection2 : collection) {
            if (collection2.size() >= 2) {
                GuidePoint[] guidePointArray = ribbons.makeProteinGuidepoints(collection2, modelState);
                if (this.doUntwistRibbons) {
                    ribbons.untwistRibbon(guidePointArray);
                }
                if (this.secondaryStructure != null) {
                    if (this.doPlainCoils) {
                        this.rp.printFancyRibbon(guidePointArray, this.secondaryStructure, 2.0, 2.2, "color= {alph" + string + "} master= {protein} master= {ribbon} master= {alpha}", "color= {beta" + string + "} master= {protein} master= {ribbon} master= {beta}", "width= 4 color= {coil" + string + "} master= {protein} master= {ribbon} master= {coil}");
                    } else {
                        this.rp.printFancyRibbon(guidePointArray, this.secondaryStructure, 2.0, 2.2, "color= {alph" + string + "} master= {protein} master= {ribbon} master= {alpha}", "color= {beta" + string + "} master= {protein} master= {ribbon} master= {beta}", "width= 4 fore color= {coil" + string + "} master= {protein} master= {ribbon} master= {coil}", "width= 6 rear color= deadblack master= {protein} master= {ribbon} master= {coil}");
                    }
                } else {
                    this.out.println("@ribbonlist {protein ribbon} color= " + string2 + " master= {protein} master= {ribbon}");
                    this.rp.printFlatRibbon(guidePointArray, 4, true);
                }
            }
            ++n;
        }
    }

    void printNucAcid(Model model, Set set, String string, String string2) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        ModelState modelState = model.getState();
        Ribbons ribbons = new Ribbons();
        Collection collection = ribbons.getNucleicAcidContigs(set, modelState, resClassifier);
        this.setUpColoring(collection);
        this.rp.setRnaPointIDs(true);
        if (collection.size() > 0 && this.secondaryStructure != null) {
            if (string2.equals("white")) {
                this.out.println("@colorset {nucl" + string + "} lime");
                this.out.println("@colorset {ncoi" + string + "} white");
            } else {
                this.out.println("@colorset {nucl" + string + "} " + string2);
                this.out.println("@colorset {ncoi" + string + "} " + string2);
            }
        }
        for (Collection collection2 : collection) {
            if (collection2.size() < 2) continue;
            GuidePoint[] guidePointArray = ribbons.makeNucleicAcidGuidepoints(collection2, modelState);
            if (this.doUntwistRibbons) {
                ribbons.untwistRibbon(guidePointArray);
            }
            if (this.doDnaStyle) {
                ribbons.swapEdgeAndFace(guidePointArray);
            }
            if (this.secondaryStructure != null) {
                this.rp.printFancyRibbon(guidePointArray, this.secondaryStructure, 3.0, 3.0, "color= {nucl" + string + "} master= {nucleic acid} master= {ribbon} master= {RNA helix?}", "color= {nucl" + string + "} master= {nucleic acid} master= {ribbon} master= {A-form}", "width= 4 color= {ncoi" + string + "} master= {nucleic acid} master= {ribbon} master= {coil}");
                continue;
            }
            this.out.println("@ribbonlist {nucleic acid ribbon} color= " + string2 + " master= {nucleic acid} master= {ribbon}");
            this.rp.printFlatRibbon(guidePointArray, 4, true);
        }
    }
}

