% Steerable pyramid filters.  Transform described  in:
%
% @INPROCEEDINGS{Simoncelli95b,
%	TITLE = "The Steerable Pyramid: A Flexible Architecture for
%		 Multi-Scale Derivative Computation",
%	AUTHOR = "E P Simoncelli and W T Freeman",
%	BOOKTITLE = "Second Int'l Conf on Image Processing",
%	ADDRESS = "Washington, DC", MONTH = "October", YEAR = 1995 }
%
% Filter kernel design described in:
%
%@INPROCEEDINGS{Karasaridis96,
%	TITLE = "A Filter Design Technique for 
%		Steerable Pyramid Image Transforms",
%	AUTHOR = "A Karasaridis and E P Simoncelli",
%	BOOKTITLE = "ICASSP",	ADDRESS = "Atlanta, GA",
%	MONTH = "May",	YEAR = 1996 }

% Eero Simoncelli, 6/96.

function [lo0filt,hi0filt,lofilt,bfilts,mtx,harmonics] = sp5Filters();

harmonics = [1 3 5];

mtx = [ ...
    0.3333    0.2887    0.1667    0.0000   -0.1667   -0.2887
    0.0000    0.1667    0.2887    0.3333    0.2887    0.1667
    0.3333   -0.0000   -0.3333   -0.0000    0.3333   -0.0000
    0.0000    0.3333    0.0000   -0.3333    0.0000    0.3333
    0.3333   -0.2887    0.1667   -0.0000   -0.1667    0.2887
   -0.0000    0.1667   -0.2887    0.3333   -0.2887    0.1667];

hi0filt = [ 
-0.00033429 -0.00113093 -0.00171484 -0.00133542 -0.00080639 -0.00133542 -0.00171484 -0.00113093 -0.00033429
-0.00113093 -0.00350017 -0.00243812 0.00631653 0.01261227 0.00631653 -0.00243812 -0.00350017 -0.00113093
-0.00171484 -0.00243812 -0.00290081 -0.00673482 -0.00981051 -0.00673482 -0.00290081 -0.00243812 -0.00171484
-0.00133542 0.00631653 -0.00673482 -0.07027679 -0.11435863 -0.07027679 -0.00673482 0.00631653 -0.00133542
-0.00080639 0.01261227 -0.00981051 -0.11435863 0.81380200 -0.11435863 -0.00981051 0.01261227 -0.00080639
-0.00133542 0.00631653 -0.00673482 -0.07027679 -0.11435863 -0.07027679 -0.00673482 0.00631653 -0.00133542
-0.00171484 -0.00243812 -0.00290081 -0.00673482 -0.00981051 -0.00673482 -0.00290081 -0.00243812 -0.00171484
-0.00113093 -0.00350017 -0.00243812 0.00631653 0.01261227 0.00631653 -0.00243812 -0.00350017 -0.00113093
-0.00033429 -0.00113093 -0.00171484 -0.00133542 -0.00080639 -0.00133542 -0.00171484 -0.00113093 -0.00033429];


lo0filt = [
0.00341614 -0.01551246 -0.03848215 -0.01551246 0.00341614
-0.01551246 0.05586982 0.15925570 0.05586982 -0.01551246
-0.03848215 0.15925570 0.40304148 0.15925570 -0.03848215
-0.01551246 0.05586982 0.15925570 0.05586982 -0.01551246
0.00341614 -0.01551246 -0.03848215 -0.01551246 0.00341614];

lofilt = 2*[
0.00085404 -0.00244917 -0.00387812 -0.00944432 -0.00962054 -0.00944432 -0.00387812 -0.00244917 0.00085404
-0.00244917 -0.00523281 -0.00661117 0.00410600 0.01002988 0.00410600 -0.00661117 -0.00523281 -0.00244917
-0.00387812 -0.00661117 0.01396746 0.03277038 0.03981393 0.03277038 0.01396746 -0.00661117 -0.00387812
-0.00944432 0.00410600 0.03277038 0.06426333 0.08169618 0.06426333 0.03277038 0.00410600 -0.00944432
-0.00962054 0.01002988 0.03981393 0.08169618 0.10096540 0.08169618 0.03981393 0.01002988 -0.00962054
-0.00944432 0.00410600 0.03277038 0.06426333 0.08169618 0.06426333 0.03277038 0.00410600 -0.00944432
-0.00387812 -0.00661117 0.01396746 0.03277038 0.03981393 0.03277038 0.01396746 -0.00661117 -0.00387812
-0.00244917 -0.00523281 -0.00661117 0.00410600 0.01002988 0.00410600 -0.00661117 -0.00523281 -0.00244917
0.00085404 -0.00244917 -0.00387812 -0.00944432 -0.00962054 -0.00944432 -0.00387812 -0.00244917 0.00085404];

bfilts = [...
 0.00277643 0.00496194 0.01026699 0.01455399 0.01026699 0.00496194 0.00277643 ...
-0.00986904 -0.00893064 0.01189859 0.02755155 0.01189859 -0.00893064 -0.00986904 ...
-0.01021852 -0.03075356 -0.08226445 -0.11732297 -0.08226445 -0.03075356 -0.01021852 ...
 0.00000000 0.00000000 0.00000000 0.00000000 0.00000000 0.00000000 0.00000000 ...
 0.01021852 0.03075356 0.08226445 0.11732297 0.08226445 0.03075356 0.01021852 ...
 0.00986904 0.00893064 -0.01189859 -0.02755155 -0.01189859 0.00893064 0.00986904 ...
-0.00277643 -0.00496194 -0.01026699 -0.01455399 -0.01026699 -0.00496194 -0.00277643;
...
-0.00343249 -0.00640815 -0.00073141 0.01124321 0.00182078 0.00285723 0.01166982 ...
-0.00358461 -0.01977507 -0.04084211 -0.00228219 0.03930573 0.01161195 0.00128000 ...
 0.01047717 0.01486305 -0.04819057 -0.12227230 -0.05394139 0.00853965 -0.00459034 ...
 0.00790407 0.04435647 0.09454202 -0.00000000 -0.09454202 -0.04435647 -0.00790407 ...
 0.00459034 -0.00853965 0.05394139 0.12227230 0.04819057 -0.01486305 -0.01047717 ...
-0.00128000 -0.01161195 -0.03930573 0.00228219 0.04084211 0.01977507 0.00358461 ...
-0.01166982 -0.00285723 -0.00182078 -0.01124321 0.00073141 0.00640815 0.00343249;
...
 0.00343249 0.00358461 -0.01047717 -0.00790407 -0.00459034 0.00128000 0.01166982 ...
 0.00640815 0.01977507 -0.01486305 -0.04435647 0.00853965 0.01161195 0.00285723 ...
 0.00073141 0.04084211 0.04819057 -0.09454202 -0.05394139 0.03930573 0.00182078 ...
-0.01124321 0.00228219 0.12227230 -0.00000000 -0.12227230 -0.00228219 0.01124321 ...
-0.00182078 -0.03930573 0.05394139 0.09454202 -0.04819057 -0.04084211 -0.00073141 ...
-0.00285723 -0.01161195 -0.00853965 0.04435647 0.01486305 -0.01977507 -0.00640815 ...
-0.01166982 -0.00128000 0.00459034 0.00790407 0.01047717 -0.00358461 -0.00343249;
...
-0.00277643 0.00986904 0.01021852 -0.00000000 -0.01021852 -0.00986904 0.00277643 ...
-0.00496194 0.00893064 0.03075356 -0.00000000 -0.03075356 -0.00893064 0.00496194 ...
-0.01026699 -0.01189859 0.08226445 -0.00000000 -0.08226445 0.01189859 0.01026699 ...
-0.01455399 -0.02755155 0.11732297 -0.00000000 -0.11732297 0.02755155 0.01455399 ...
-0.01026699 -0.01189859 0.08226445 -0.00000000 -0.08226445 0.01189859 0.01026699 ...
-0.00496194 0.00893064 0.03075356 -0.00000000 -0.03075356 -0.00893064 0.00496194 ...
-0.00277643 0.00986904 0.01021852 -0.00000000 -0.01021852 -0.00986904 0.00277643;
...
-0.01166982 -0.00128000 0.00459034 0.00790407 0.01047717 -0.00358461 -0.00343249 ...
-0.00285723 -0.01161195 -0.00853965 0.04435647 0.01486305 -0.01977507 -0.00640815 ...
-0.00182078 -0.03930573 0.05394139 0.09454202 -0.04819057 -0.04084211 -0.00073141 ...
-0.01124321 0.00228219 0.12227230 -0.00000000 -0.12227230 -0.00228219 0.01124321 ...
 0.00073141 0.04084211 0.04819057 -0.09454202 -0.05394139 0.03930573 0.00182078 ...
 0.00640815 0.01977507 -0.01486305 -0.04435647 0.00853965 0.01161195 0.00285723 ...
 0.00343249 0.00358461 -0.01047717 -0.00790407 -0.00459034 0.00128000 0.01166982;
...
-0.01166982 -0.00285723 -0.00182078 -0.01124321 0.00073141 0.00640815 0.00343249 ...
-0.00128000 -0.01161195 -0.03930573 0.00228219 0.04084211 0.01977507 0.00358461 ...
 0.00459034 -0.00853965 0.05394139 0.12227230 0.04819057 -0.01486305 -0.01047717 ...
 0.00790407 0.04435647 0.09454202 -0.00000000 -0.09454202 -0.04435647 -0.00790407 ...
 0.01047717 0.01486305 -0.04819057 -0.12227230 -0.05394139 0.00853965 -0.00459034 ...
-0.00358461 -0.01977507 -0.04084211 -0.00228219 0.03930573 0.01161195 0.00128000 ...
-0.00343249 -0.00640815 -0.00073141 0.01124321 0.00182078 0.00285723 0.01166982]'; 
