/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.IntegerArgumentPropertySerializer;
import io.netty.buffer.ByteBuf;

class FloatArgumentPropertySerializer
implements ArgumentPropertySerializer<FloatArgumentType> {
    static final FloatArgumentPropertySerializer FLOAT = new FloatArgumentPropertySerializer();

    private FloatArgumentPropertySerializer() {
    }

    @Override
    public FloatArgumentType deserialize(ByteBuf buf) {
        byte flags = buf.readByte();
        float minimum = (flags & 1) != 0 ? buf.readFloat() : Float.MIN_VALUE;
        float maximum = (flags & 2) != 0 ? buf.readFloat() : Float.MAX_VALUE;
        return FloatArgumentType.floatArg(minimum, maximum);
    }

    @Override
    public void serialize(FloatArgumentType object, ByteBuf buf) {
        boolean hasMinimum = Float.compare(object.getMinimum(), Float.MIN_VALUE) != 0;
        boolean hasMaximum = Float.compare(object.getMaximum(), Float.MAX_VALUE) != 0;
        byte flag = IntegerArgumentPropertySerializer.getFlags(hasMinimum, hasMaximum);
        buf.writeByte(flag);
        if (hasMinimum) {
            buf.writeFloat(object.getMinimum());
        }
        if (hasMaximum) {
            buf.writeFloat(object.getMaximum());
        }
    }
}

